/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.calc.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.alloc.function.AbstractCalcFunction;
import kd.macc.sca.algox.calc.input.CalcMaterial;
import kd.macc.sca.algox.calc.input.CompleteProduct;
import kd.macc.sca.algox.calc.input.CostObjectForCalc;
import kd.macc.sca.algox.calc.input.Product;
import kd.macc.sca.algox.calc.input.ProductCostObject;
import kd.macc.sca.algox.calc.input.SubElementFee;
import kd.macc.sca.algox.calc.input.SubElementTotalFee;

@Deprecated
public class DiffTransCalcFunction
extends AbstractCalcFunction {
    private static final long serialVersionUID = 100000L;
    private static String[] submatWightFields = new String[]{"costobject", "newdifftype", "element", "subelement", "amount"};
    private static String[] submatWightGroupFields = new String[]{"costobject", "newdifftype", "element", "subelement"};

    @Override
    public Collection<DynamicObject> doCalculate(Iterable<RowX> iterable) {
        return null;
    }

    public List<ProductCostObject> doCalculateByDataSet(Iterable<Row> elementMatAbsCostData, Iterable<Row> elementMatCostData, Iterable<Row> elemDataSet, Map<Object, BigDecimal> finishco) {
        Set<CalcMaterial> curCalcMatSet = this.args.getCurCalcMat();
        if (curCalcMatSet == null || curCalcMatSet.size() == 0) {
            return null;
        }
        Map<Object, Map<Object, BigDecimal>> difftypeAmtMap = this.getDiffAndElementAmt(elementMatCostData);
        Map<Object, Map<Object, BigDecimal>> difftypeAbsAmtMap = this.getDiffAndElementAmt(elementMatAbsCostData);
        List<SubElementTotalFee> subElementTotalFeeList = this.getSubElementTotalFee(elemDataSet);
        List<SubElementFee> subElementFeeList = this.getSubElementFee(elementMatCostData);
        Map<Object, List<SubElementTotalFee>> coSubElementMap = this.getCostObjIdAndTotalElementFeeMap(subElementTotalFeeList);
        Map<Object, List<SubElementFee>> cosubElementMatMap = this.getCostObjIdAndSubMatElementFeeMap(subElementFeeList);
        Map<Object, BigDecimal> costObjAndAmountMap = this.getCostObjIdAndAmountMap(subElementFeeList);
        Set<Object> costObjIdSet = coSubElementMap.keySet();
        Map<String, Set<Object>> costProdRef = this.getCostProdRef(costObjIdSet);
        Map<Object, Set<CompleteProduct>> cofinishedProduct = this.getFinishedProductQuantitys(this.args.getOrgId(), costObjIdSet);
        List<ProductCostObject> productCostObjects = this.calcTransFinishedProductCostOnStd(costProdRef, cofinishedProduct, cosubElementMatMap, coSubElementMap, costObjAndAmountMap, difftypeAmtMap, difftypeAbsAmtMap, finishco);
        return productCostObjects;
    }

    private Map<Object, Map<Object, BigDecimal>> getDiffAndElementAmt(Iterable<Row> elementMatCostData) {
        DataSet copyElementMatCostData = ((DataSet)elementMatCostData).copy();
        DataSet amtdset = copyElementMatCostData.select(submatWightFields).groupBy(submatWightGroupFields).sum("amount").finish();
        Map<Object, Map<Object, BigDecimal>> difftypeAmtMap = this.getCostDifftypeTotalAmount(amtdset);
        return difftypeAmtMap;
    }

    private Map<Object, Map<Object, BigDecimal>> getCostDifftypeTotalAmount(DataSet amtdset) {
        HashMap<Object, Map<Object, BigDecimal>> map = new HashMap<Object, Map<Object, BigDecimal>>();
        if (amtdset != null) {
            for (Row row : amtdset) {
                Long costobjectid = row.getLong("costobject");
                BigDecimal amount = row.getBigDecimal("amount");
                Object newdifftype = row.get("newdifftype");
                Object element = row.get("element");
                Object subelement = row.get("subelement");
                String key = newdifftype + "&" + element + "&" + subelement;
                Map dmap = map.computeIfAbsent(costobjectid, v -> new HashMap());
                BigDecimal addRes = dmap.computeIfAbsent(key, v -> BigDecimal.ZERO).add(amount);
                dmap.put(key, addRes);
            }
        }
        return map;
    }

    private List<ProductCostObject> calcTransFinishedProductCostOnStd(Map<String, Set<Object>> costProdRef, Map<Object, Set<CompleteProduct>> cofinishedProduct, Map<Object, List<SubElementFee>> cosubMatElementMap, Map<Object, List<SubElementTotalFee>> coSubElementMap, Map<Object, BigDecimal> costObjAndAmountMap, Map<Object, Map<Object, BigDecimal>> difftypeAmtMap, Map<Object, Map<Object, BigDecimal>> difftypeAbsAmtMap, Map<Object, BigDecimal> finishco) {
        ArrayList<ProductCostObject> productCostObjects = new ArrayList<ProductCostObject>(10);
        for (Map.Entry<String, Set<Object>> entry : costProdRef.entrySet()) {
            String productgroup = entry.getKey();
            String[] productgroups = productgroup.split(";");
            Long productid = Long.valueOf(productgroups[0]);
            Long matversion = Long.valueOf(productgroups[1]);
            Long auxpty = Long.valueOf(productgroups[2]);
            Product product = new Product(productid, matversion, auxpty);
            Set<Object> costobjects = entry.getValue();
            HashSet<CostObjectForCalc> cocs = new HashSet<CostObjectForCalc>(16);
            for (Object costobjectid : costobjects) {
                BigDecimal totalQty = finishco.get(costobjectid);
                BigDecimal coadjamout = costObjAndAmountMap.get(costobjectid);
                List<SubElementTotalFee> coSubElementTotalFee = coSubElementMap.get(costobjectid);
                List<SubElementFee> coSubMatElementFee = cosubMatElementMap.get(costobjectid);
                Set<CompleteProduct> finishcoll = cofinishedProduct.get(costobjectid);
                Map<Object, BigDecimal> coDifftypeAmt = difftypeAmtMap.get(costobjectid);
                Map<Object, BigDecimal> coDifftypeAbsAmt = difftypeAbsAmtMap.get(costobjectid);
                CostObjectForCalc costObjectForCalc = new CostObjectForCalc();
                costObjectForCalc.setId(costobjectid).setTotalQty(totalQty).setAmout(coadjamout).setCompleteProducts(finishcoll).setSubElementTotalFee(coSubElementTotalFee).setSubMatElementFee(coSubMatElementFee).setDiffTypeAmount(coDifftypeAmt).setDiffTypeAbsAmount(coDifftypeAbsAmt);
                cocs.add(costObjectForCalc);
            }
            ProductCostObject mco = new ProductCostObject(product, cocs);
            productCostObjects.add(mco);
        }
        return productCostObjects;
    }

    private Map<String, Set<Object>> getCostProdRef(Set<Object> costObjIdSet) {
        HashMap<String, Set<Object>> mcs = new HashMap<String, Set<Object>>(16);
        DataSet costObjectData = QueryServiceHelper.queryDataSet((String)"", (String)"cad_costobject", (String)"id,material,bomversion,auxpty", (QFilter[])new QFilter("id", "in", costObjIdSet).toArray(), null);
        for (Row costObjectDatum : costObjectData) {
            Long id = costObjectDatum.getLong("id");
            Long material = costObjectDatum.getLong("material");
            Long bomversion = costObjectDatum.getLong("bomversion");
            Long auxpty = costObjectDatum.getLong("auxpty");
            String key = material + ";" + bomversion + ";" + auxpty;
            mcs.computeIfAbsent(key, v -> new HashSet()).add(id);
        }
        return mcs;
    }

    private Map<Object, List<SubElementTotalFee>> getCostObjIdAndTotalElementFeeMap(List<SubElementTotalFee> subElementTotalFeeList) {
        HashMap<Object, List<SubElementTotalFee>> costObjAndSubElementMap = new HashMap<Object, List<SubElementTotalFee>>(16);
        for (SubElementTotalFee subElementFee : subElementTotalFeeList) {
            costObjAndSubElementMap.computeIfAbsent(subElementFee.getCostObjectId(), v -> new ArrayList()).add(subElementFee);
        }
        return costObjAndSubElementMap;
    }

    private Map<Object, List<SubElementFee>> getCostObjIdAndSubMatElementFeeMap(List<SubElementFee> subElementFeeList) {
        HashMap<Object, List<SubElementFee>> costObjAndSubElementMap = new HashMap<Object, List<SubElementFee>>(16);
        for (SubElementFee subElementFee : subElementFeeList) {
            costObjAndSubElementMap.computeIfAbsent(subElementFee.getCostObjectId(), v -> new ArrayList()).add(subElementFee);
        }
        return costObjAndSubElementMap;
    }

    private Map<Object, BigDecimal> getCostObjIdAndAmountMap(List<SubElementFee> subElementFeeList) {
        HashMap<Object, BigDecimal> costObjAndAmountMap = new HashMap<Object, BigDecimal>(16);
        for (SubElementFee subElementFee : subElementFeeList) {
            long costObjectId = subElementFee.getCostObjectId();
            BigDecimal eleAmount = subElementFee.getAmount();
            eleAmount = eleAmount == null ? BigDecimal.ZERO : eleAmount;
            BigDecimal addRes = costObjAndAmountMap.computeIfAbsent(costObjectId, v -> BigDecimal.ZERO).add(eleAmount);
            costObjAndAmountMap.put(costObjectId, addRes);
        }
        return costObjAndAmountMap;
    }

    private List<SubElementFee> getSubElementFee(Iterable<Row> dataSet) {
        ArrayList<SubElementFee> subElementFeeList = new ArrayList<SubElementFee>(10);
        if (dataSet != null) {
            for (Row row : dataSet) {
                SubElementFee subElementFee = new SubElementFee();
                subElementFee.setOrg(row.getLong("org"));
                subElementFee.setCostCenterId(row.getLong("costcenter"));
                subElementFee.setCostAccountId(row.getLong("costaccount"));
                subElementFee.setCostObjectId(row.getLong("costobject"));
                subElementFee.setSubElementId(row.getLong("subelement"));
                subElementFee.setElementProp(row.getString("elementprop"));
                subElementFee.setSubElementProp(row.getString("subelementprop"));
                subElementFee.setElementId(row.getLong("element"));
                subElementFee.setMaterialId(row.getLong("submaterial"));
                subElementFee.setMatversion(row.getLong("submatversion"));
                subElementFee.setMatauxpty(row.getLong("submatauxpty"));
                subElementFee.setDifftype(row.get("newdifftype"));
                subElementFee.setAmount(row.getBigDecimal("amount"));
                subElementFeeList.add(subElementFee);
            }
        }
        return subElementFeeList;
    }

    private Map<Object, Set<CompleteProduct>> getFinishedProductQuantitys(Object orgId, Set<Object> costObjIdSet) {
        DataSet dataSet = this.getFinishedProductCostObjInfo(orgId, costObjIdSet);
        HashMap<Object, Set<CompleteProduct>> coCompleteProductMap = new HashMap<Object, Set<CompleteProduct>>(16);
        for (Row row : dataSet) {
            Long costObjId = row.getLong("costobject");
            Long id = row.getLong("id");
            CompleteProduct completeProduct = new CompleteProduct();
            completeProduct.setCompleteBillId(id);
            completeProduct.setSourceBillEntryId(row.getLong("sourcebillentry"));
            completeProduct.setSourceBillId(row.getLong("sourcebill"));
            completeProduct.setCostObjectId(costObjId);
            completeProduct.setQty(row.getBigDecimal("qty"));
            HashSet<CompleteProduct> set = (HashSet<CompleteProduct>)coCompleteProductMap.get(costObjId);
            if (set == null) {
                set = new HashSet<CompleteProduct>(16);
                set.add(completeProduct);
                coCompleteProductMap.put(costObjId, set);
                continue;
            }
            set.add(completeProduct);
        }
        return coCompleteProductMap;
    }

    private DataSet getFinishedProductCostObjInfo(Object orgId, Set<Object> costObjIdSet) {
        String algoKey = "kd.macc.sca.algox.calc.function.FinishCalcFunction.getFinishedProductCostObjInfo";
        QFilter orgIdFilter = new QFilter("org", "=", orgId);
        QFilter costObjIdFilter = new QFilter("entryentity.costobject", "in", costObjIdSet);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter beginDateFilter = new QFilter("bookdate", ">=", (Object)this.args.getStartDate());
        QFilter endDateFilter = new QFilter("bookdate", "<=", (Object)this.args.getEndDate());
        String selectFields = "id,org, costcenter,sourcebillentry,sourcebill,entryentity.costobject costobject, case when entryentity.qty < 0 then 0-entryentity.qty else entryentity.qty end qty";
        QFilter[] filters = new QFilter[]{orgIdFilter, beginDateFilter, endDateFilter, costObjIdFilter, statusFilter};
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filters, null);
        return resultDs;
    }

    private List<SubElementTotalFee> getSubElementTotalFee(Iterable<Row> elmentMatCostData) {
        ArrayList<SubElementTotalFee> subElementFeeList = new ArrayList<SubElementTotalFee>(10);
        if (elmentMatCostData != null) {
            for (Row row : elmentMatCostData) {
                SubElementTotalFee subElementFee = new SubElementTotalFee();
                subElementFee.setOrg(row.getLong("org"));
                subElementFee.setCostCenterId(row.getLong("costcenter"));
                subElementFee.setCostAccountId(row.getLong("costaccount"));
                subElementFee.setCostObjectId(row.getLong("costobject"));
                subElementFee.setSubElementId(row.getLong("subelement"));
                subElementFee.setElementId(row.getLong("element"));
                subElementFee.setDifftype(row.get("newdifftype"));
                subElementFee.setAmount(row.getBigDecimal("amount"));
                subElementFeeList.add(subElementFee);
            }
        }
        return subElementFeeList;
    }
}

