/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.sca.algox.costrec.CostRecCalcHelper;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.costrec.HalfprdStructureInfo;
import kd.macc.sca.algox.costrec.HalfprdStructureParams;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CostRecoveryHelper;
import org.apache.commons.lang3.StringUtils;

public class BopHalfprdStructureEngineV2 {
    private static final Log logger = LogFactory.getLog(BopHalfprdStructureEngineV2.class);
    private static final String ALGOKEY = "BopHalfprdStructureEngine.";

    public void genBopHalfprdStructure(CostRecoveryParams crParams) {
        if (SysParamEnum.RESTOREDIMENSION_ORG.getValue().equals(crParams.getCalDimension())) {
            HalfprdStructureParams hrParam = new HalfprdStructureParams();
            hrParam.setCalOrgId(crParams.getCalOrgId());
            hrParam.setCostAccountId(crParams.getCostAccountId());
            hrParam.setManuOrgId(0L);
            hrParam.setStOrgId(0L);
            hrParam.setPeriodId(crParams.getPeriodId());
            hrParam.setPriceScale(crParams.getPriceScale());
            hrParam.setCalcKeycol(!crParams.getCalcKeys().isEmpty());
            this.genBopHalfprdStructure(hrParam);
        } else if (crParams.getManuOrgId() > 0L) {
            HalfprdStructureParams hrParam = new HalfprdStructureParams();
            hrParam.setCalOrgId(crParams.getCalOrgId());
            hrParam.setCostAccountId(crParams.getCostAccountId());
            hrParam.setManuOrgId(crParams.getManuOrgId());
            hrParam.setPeriodId(crParams.getPeriodId());
            hrParam.setPriceScale(crParams.getPriceScale());
            hrParam.setCalcKeycol(!crParams.getCalcKeys().isEmpty());
            List stOrgs = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)crParams.getManuOrgId(), (boolean)true);
            for (Long storg : stOrgs) {
                hrParam.setStOrgId(storg);
                this.genBopHalfprdStructure(hrParam);
            }
        } else {
            for (Map.Entry<Long, Long> entry : crParams.getRelaOrgCostAccountMap().entrySet()) {
                HalfprdStructureParams hrParam = new HalfprdStructureParams();
                hrParam.setCalOrgId(entry.getKey());
                hrParam.setCostAccountId(entry.getValue());
                hrParam.setPeriodId(crParams.getPeriodId());
                hrParam.setPriceScale(crParams.getPriceScale());
                hrParam.setManuOrgId(0L);
                hrParam.setCalcKeycol(!crParams.getCalcKeys().isEmpty());
                List<Long> orgToStOrgs = CostRecoveryHelper.getOrgToStOrg(entry.getKey());
                for (Long stOrg : orgToStOrgs) {
                    hrParam.setStOrgId(stOrg);
                    this.genBopHalfprdStructure(hrParam);
                }
                List manuOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)hrParam.getCalOrgId(), (boolean)true);
                for (Long manuOrg : manuOrgs) {
                    hrParam.setManuOrgId(manuOrg);
                    List stOrgs = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuOrg, (boolean)true);
                    for (Long storg : stOrgs) {
                        hrParam.setStOrgId(storg);
                        this.genBopHalfprdStructure(hrParam);
                    }
                }
            }
        }
    }

    public void genBopHalfprdStructure(HalfprdStructureParams hrParam) {
        HashSet<Long> unRecoveryMaterialIdSet = new HashSet<Long>();
        HashSet<Long> unRecoverySubMaterialIdSet = new HashSet<Long>();
        CostRecoveryHelper.buildUnRecoveryMaterial(hrParam.getCalOrgId(), hrParam.getCostAccountId(), hrParam.getManuOrgId(), unRecoveryMaterialIdSet, unRecoverySubMaterialIdSet, null);
        QFilter eleTypeFilter = this.getMatElementFilter();
        QFilter baseFilter = this.getBaseFilter(hrParam);
        Set matIds = this.getTopMatIds(baseFilter, eleTypeFilter);
        Set<String> reCalcMatIds = this.getRecalcMatIds(baseFilter);
        this.clearHalfHide(reCalcMatIds, baseFilter);
        DataSet changedProducts = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdhide", (String)"material as materialId,calckeycol as calckeycolId", (QFilter[])new QFilter[]{baseFilter, CostRecCalcHelper.getMatKeyQFilter(reCalcMatIds, "entryentity.submaterial", "entryentity.subcalckeycol")}, null);
        for (Row row : changedProducts) {
            reCalcMatIds.add(CostRecCalcHelper.getKeyIdStr(row.getLong("materialId"), row.getLong("calckeycolId")));
        }
        CostRecoveryHelper.logInfoIdSet(logger, "reCalcMatIds", reCalcMatIds);
        this.createHalfprdstructureInfos(hrParam, baseFilter, Sets.newHashSet(reCalcMatIds), unRecoveryMaterialIdSet);
        HashSet needExpendMatSet = Sets.newHashSet();
        DataSet changedProductsForMuilt = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdstructure", (String)"entryentity.submaterial as submaterialId,entryentity.subcalckeycol as subcalckeycolId", (QFilter[])new QFilter[]{baseFilter, eleTypeFilter, CostRecCalcHelper.getMatKeyQFilter(reCalcMatIds, "material", "calckeycol")}, null);
        for (Row row : changedProductsForMuilt) {
            needExpendMatSet.add(CostRecCalcHelper.getKeyIdStr(row.getLong("submaterialId"), row.getLong("subcalckeycolId")));
        }
        needExpendMatSet.removeAll(reCalcMatIds);
        CostRecoveryHelper.logInfoIdSet(logger, "needExpendMatSet", needExpendMatSet);
        HashSet allRecalMatIds = Sets.newHashSet();
        allRecalMatIds.addAll(reCalcMatIds);
        allRecalMatIds.addAll(needExpendMatSet);
        HashSet existsTreepath = Sets.newHashSet();
        HashSet notDeleted = Sets.newHashSet();
        Set nextLevelMatIds = null;
        for (int index = 0; index < 30; ++index) {
            matIds.retainAll(allRecalMatIds);
            if (matIds.isEmpty()) break;
            Tuple<HashSet<String>, HashMap<String, Set<HalfprdStructureInfo>>> result = this.getHalfprdstructureInfos(baseFilter, matIds);
            nextLevelMatIds = (Set)result.item1;
            Map parentAndSubInfosMap = (Map)result.item2;
            try {
                this.updateHalfprdStrctHideNew(hrParam, baseFilter, eleTypeFilter, matIds, unRecoverySubMaterialIdSet, unRecoveryMaterialIdSet, parentAndSubInfosMap, reCalcMatIds, needExpendMatSet, allRecalMatIds, existsTreepath, notDeleted);
            }
            catch (Exception ex) {
                logger.error("\u5b9e\u9645\u6210\u672c\u8fd8\u539f-\u751f\u6210\u591a\u7ea7\u5931\u8d25", (Throwable)ex);
                throw ex;
            }
            matIds = nextLevelMatIds;
        }
    }

    private void clearHalfHide(Set<String> reCalcMatIds, QFilter baseFilter) {
        DataSet halfHidePrd = QueryServiceHelper.queryDataSet((String)"BopHalfprdStructureEngine.clearHalfHide", (String)"sca_halfprdhide", (String)"id,material as materialId,calckeycol as calckeycolId", (QFilter[])new QFilter[]{baseFilter}, null);
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (Row row : halfHidePrd) {
            if (!reCalcMatIds.contains(CostRecCalcHelper.getKeyIdStr(row.getLong("materialId"), row.getLong("calckeycolId")))) continue;
            billIds.add(row.getLong("id"));
        }
        List spList = Lists.partition(billIds, (int)100);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"sca_halfprdhide");
        for (List sp : spList) {
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])sp.toArray());
        }
    }

    private QFilter getBaseFilter(HalfprdStructureParams hrParam) {
        QFilter baseFilter = new QFilter("costaccount", "=", (Object)hrParam.getCostAccountId());
        baseFilter.and("org", "=", (Object)hrParam.getCalOrgId());
        baseFilter.and("period", "=", (Object)hrParam.getPeriodId());
        baseFilter.and("prdorg", "=", (Object)hrParam.getManuOrgId());
        baseFilter.and("billstatus", "=", (Object)"C");
        QFilter stOrgFilter = new QFilter("storageorgunit", "=", (Object)0L);
        if (hrParam.getStOrgId() != 0L) {
            stOrgFilter = hrParam.getManuOrgId() == 0L ? new QFilter("storageorgunit", "=", (Object)hrParam.getStOrgId()) : new QFilter("storageorgunit", "in", (Object)new Long[]{hrParam.getStOrgId(), 0L});
            baseFilter.and(stOrgFilter);
        } else {
            baseFilter.and(stOrgFilter);
        }
        return baseFilter;
    }

    private QFilter getMatElementFilter() {
        QFilter eleTypeFilter = new QFilter("entryentity.subelement.type", "in", (Object)new String[]{"001"});
        eleTypeFilter.and("entryentity.isunabsorb", "=", (Object)"A");
        return eleTypeFilter;
    }

    public Set<String> getTopMatIds(QFilter baseFilter, QFilter eleTypeFilter) {
        Set<HalfprdStructureInfo> hightMatInfos = this.getTopMatStructs(baseFilter, eleTypeFilter);
        HashSet<String> matIds = new HashSet<String>(5);
        for (HalfprdStructureInfo hightMatInfo : hightMatInfos) {
            matIds.add(CostRecCalcHelper.getKeyIdStr(hightMatInfo.getMaterialId(), hightMatInfo.getCalckeycolId()));
        }
        return matIds;
    }

    private String getMaterialKeyStr(Long materialId, Long versionId, Long auxptyId, Long calckeycolId) {
        return String.format("%s@%s@%s@%s", materialId, versionId, auxptyId, calckeycolId);
    }

    private Set<HalfprdStructureInfo> getTopMatStructs(QFilter baseFilter, QFilter eleTypeFilter) {
        DataSet halfprdStructureData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdstructure", (String)"material as materialId,materialversion matverId,auxprop.id as auxpropId,calckeycol as calckeycolId,entryentity.submaterial as submaterialId,entryentity.submaterialversion as submatverId,entryentity.submaterialauxprop as subauxpropId,entryentity.subcalckeycol as subcalckeycolId", (QFilter[])new QFilter[]{baseFilter, eleTypeFilter}, null);
        HashSet<HalfprdStructureInfo> hightMatInfos = new HashSet<HalfprdStructureInfo>();
        HashSet<HalfprdStructureInfo> subMatInfos = new HashSet<HalfprdStructureInfo>();
        for (Row row : halfprdStructureData) {
            HalfprdStructureInfo parentMatInfo = new HalfprdStructureInfo();
            parentMatInfo.setMaterialId(row.getLong("materialId"));
            parentMatInfo.setMatverId(row.getLong("matverId"));
            parentMatInfo.setAuxpropId(row.getLong("auxpropId"));
            parentMatInfo.setCalckeycolId(row.getLong("calckeycolId"));
            hightMatInfos.add(parentMatInfo);
            HalfprdStructureInfo subMatInfo = new HalfprdStructureInfo();
            subMatInfo.setMaterialId(row.getLong("submaterialId"));
            subMatInfo.setMatverId(row.getLong("submatverId"));
            subMatInfo.setAuxpropId(row.getLong("subauxpropId"));
            subMatInfo.setCalckeycolId(row.getLong("subcalckeycolId"));
            subMatInfos.add(subMatInfo);
        }
        for (HalfprdStructureInfo subMatInfo : subMatInfos) {
            hightMatInfos.remove(subMatInfo);
        }
        return hightMatInfos;
    }

    private Tuple<HashSet<String>, HashMap<String, Set<HalfprdStructureInfo>>> getHalfprdstructureInfos(QFilter baseFilter, Set<String> matIds) {
        HashMap<String, Set<HalfprdStructureInfo>> parentAndSubInfosMap = new HashMap<String, Set<HalfprdStructureInfo>>();
        QFilter parentMatFilter = CostRecCalcHelper.getMatKeyQFilter(matIds, "material", "calckeycol");
        DataSet parentHalfprdStructureData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdstructure", (String)this.getHalfprdstructurefields(), (QFilter[])new QFilter[]{baseFilter, parentMatFilter}, null);
        if (parentHalfprdStructureData.isEmpty()) {
            return new Tuple(new HashSet(16), new HashMap(16));
        }
        HashSet<String> nextLevelMats = new HashSet<String>(16);
        for (Row row : parentHalfprdStructureData) {
            Set<HalfprdStructureInfo> submatInfos;
            String key = this.getMaterialKeyStr(row.getLong("materialId"), row.getLong("matverId"), row.getLong("auxpropId"), row.getLong("calckeycolId"));
            HalfprdStructureInfo subMatInfo = this.buildHalfprdStructureInfo(row);
            String matKey = CostRecCalcHelper.getKeyIdStr(row.getLong("materialId"), row.getLong("calckeycolId"));
            String submatKey = CostRecCalcHelper.getKeyIdStr(row.getLong("submaterialId"), row.getLong("subcalckeycolId"));
            if ("001".equals(row.getString("subelementType")) && !matKey.equals(submatKey)) {
                nextLevelMats.add(submatKey);
            }
            if (parentAndSubInfosMap.containsKey(key)) {
                submatInfos = (Set)parentAndSubInfosMap.get(key);
                if (submatInfos.contains(subMatInfo)) {
                    for (HalfprdStructureInfo oldSubMatInfo : submatInfos) {
                        if (!oldSubMatInfo.equals(subMatInfo)) continue;
                        BigDecimal newSubmatAmt = BigDecimalUtils.getBigDecimalOrZero(subMatInfo.getSubmatAmt());
                        BigDecimal oldeSubmatAmt = BigDecimalUtils.getBigDecimalOrZero(oldSubMatInfo.getSubmatAmt());
                        BigDecimal newSubmatQty = BigDecimalUtils.getBigDecimalOrZero(subMatInfo.getSubmatQty());
                        BigDecimal oldSubmatQty = BigDecimalUtils.getBigDecimalOrZero(oldSubMatInfo.getSubmatQty());
                        BigDecimal newSubmatAmtCoef = BigDecimalUtils.getBigDecimalOrZero(subMatInfo.getSubmatAmtCoef());
                        BigDecimal oldSubmatAmtCoef = BigDecimalUtils.getBigDecimalOrZero(oldSubMatInfo.getSubmatAmtCoef());
                        oldSubMatInfo.setSubmatAmt(newSubmatAmt.add(oldeSubmatAmt));
                        oldSubMatInfo.setSubmatQty(newSubmatQty.add(oldSubmatQty));
                        oldSubMatInfo.setSubmatAmtCoef(newSubmatAmtCoef.add(oldSubmatAmtCoef));
                        break;
                    }
                }
                submatInfos.add(subMatInfo);
                continue;
            }
            submatInfos = new HashSet();
            submatInfos.add(subMatInfo);
            parentAndSubInfosMap.put(key, submatInfos);
        }
        return new Tuple(nextLevelMats, parentAndSubInfosMap);
    }

    private HalfprdStructureInfo buildHalfprdStructureInfo(Row row) {
        HalfprdStructureInfo subMatInfo = new HalfprdStructureInfo();
        subMatInfo.setElementId(row.getLong("elementId"));
        subMatInfo.setSubelementId(row.getLong("subelementId"));
        subMatInfo.setElementtype(row.getString("subelementType"));
        subMatInfo.setSubmaterialId(row.getLong("submaterialId"));
        subMatInfo.setSubmatverId(row.getLong("submatverId"));
        subMatInfo.setSubauxpropId(row.getLong("subauxpropId"));
        subMatInfo.setSubcalckeycolId(row.getLong("subcalckeycolId"));
        subMatInfo.setSubmatQty(row.getBigDecimal("subQty"));
        subMatInfo.setSubmatAmt(row.getBigDecimal("subAmt"));
        subMatInfo.setSubmatAmtCoef(row.getBigDecimal("subAmtCoef"));
        subMatInfo.setIsunabsorb(row.getString("isunabsorb"));
        subMatInfo.setLevel(row.getInteger("level"));
        subMatInfo.setTreepath(row.getString("treepath"));
        return subMatInfo;
    }

    private void updateHalfprdStrctHideNew(HalfprdStructureParams hrParam, QFilter baseFilter, QFilter eleTypeFilter, Set<String> matIds, Set<Long> unRecoverySubMaterialIdSet, Set<Long> unRecoveryMaterialIdSet, Map<String, Set<HalfprdStructureInfo>> parentAndSubInfosMap, Set<String> reCalcMatIds, Set<String> needExpendMatSet, Set<String> allRecalMatIds, Set<String> existsTreepath, Set<String> notDeletedSet) {
        QFilter subMatFilter = CostRecCalcHelper.getMatQFilter(matIds, "entryentity.submaterial");
        subMatFilter = subMatFilter.and(CostRecCalcHelper.getMatKeyQFilter(allRecalMatIds, "material", "calckeycol"));
        DynamicObject[] subHalfprdStructures = BusinessDataServiceHelper.load((String)"sca_halfprdhide", (String)(this.getHalfprdStcHideFiledsByObj() + ",level"), (QFilter[])new QFilter[]{baseFilter, subMatFilter, eleTypeFilter});
        if (subHalfprdStructures == null || subHalfprdStructures.length == 0) {
            return;
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(16);
        String userId = RequestContext.get().getUserId();
        Date date = TimeServiceHelper.now();
        for (DynamicObject subHalfprdStructure : subHalfprdStructures) {
            BigDecimal totalAmt = subHalfprdStructure.getBigDecimal("totalamount");
            DynamicObjectCollection entrys = subHalfprdStructure.getDynamicObjectCollection("entryentity");
            logger.info("BopHalfprdStructureEngine\u2014\u2014>materialid:{},entrys:{}\u6761", (Object)subHalfprdStructure.getString("material.id"), (Object)entrys.size());
            String materialKey = CostRecCalcHelper.getKeyIdStr(subHalfprdStructure.getLong("material.id"), subHalfprdStructure.getLong("calckeycol.id"));
            ArrayList<DynamicObject> removeEntrys = new ArrayList<DynamicObject>();
            HashSet needGenSubMatSet = Sets.newHashSet();
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                String keytreepath = entry.getString("keytreepath");
                String treepath = entry.getString("treepath");
                if (StringUtils.isEmpty((CharSequence)keytreepath)) {
                    keytreepath = CostRecCalcHelper.getKeytreepath(treepath);
                    entry.set("keytreepath", (Object)keytreepath);
                }
                for (String matId : matIds) {
                    if (!reCalcMatIds.contains(matId) && (!needExpendMatSet.contains(matId) || !reCalcMatIds.contains(materialKey))) continue;
                    if (keytreepath.indexOf(matId + "@") > 0 && !notDeletedSet.contains(keytreepath)) {
                        removeEntrys.add(entry);
                    }
                    needGenSubMatSet.add(matId);
                }
            }
            for (DynamicObject removeEntry : removeEntrys) {
                entrys.remove((Object)removeEntry);
            }
            int entryLenght = entrys.size();
            BigDecimal oneTotalAmt = BigDecimal.ZERO;
            for (int i = 0; i < entryLenght; ++i) {
                if (((DynamicObject)entrys.get(i)).getInt("level") != 1) continue;
                oneTotalAmt = oneTotalAmt.add(((DynamicObject)entrys.get(i)).getBigDecimal("amount"));
            }
            if (totalAmt.compareTo(oneTotalAmt) != 0) {
                totalAmt = oneTotalAmt;
            }
            boolean needSave = false;
            for (int i = 0; i < entryLenght; ++i) {
                String parentTreePath;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                String subMaterialKey = CostRecCalcHelper.getKeyIdStr(entry.getLong("submaterial.id"), entry.getLong("subcalckeycol.id"));
                if (materialKey.equals(subMaterialKey) || unRecoverySubMaterialIdSet.contains(entry.getLong("submaterial.id")) || unRecoveryMaterialIdSet.contains(entry.getLong("submaterial.id")) || !needGenSubMatSet.contains(subMaterialKey) || !"001".equals(entry.getString("subelement.type")) || entry.getString("isunabsorb").equals("B") || existsTreepath.contains(parentTreePath = entry.getString("keytreepath"))) continue;
                boolean isMuilt = !reCalcMatIds.contains(subMaterialKey);
                ArrayList subMatList = Lists.newArrayList();
                String key = this.getMaterialKeyStr(entry.getLong("submaterial.id"), entry.getLong("submaterialversion.id"), entry.getLong("submaterialauxprop.id"), entry.getLong("subcalckeycol.id"));
                if (isMuilt && parentAndSubInfosMap.containsKey(key)) {
                    DataSet prdHideDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sca_halfprdhide", (String)this.getHalfprdStructureFileds(), (QFilter[])new QFilter[]{baseFilter, CostRecCalcHelper.getMatKeyQFilter(subMaterialKey, "material", "calckeycol")}, (String)"entryentity.level");
                    for (Row row : prdHideDataSet) {
                        int level = row.getInteger("level");
                        if (subMatList.size() < level) {
                            subMatList.add(Sets.newHashSet());
                        }
                        Set tmpSet = (Set)subMatList.get(level - 1);
                        HalfprdStructureInfo subMatInfo = this.buildHalfprdStructureInfo(row);
                        subMatInfo.setKeytreepath(row.getString("keytreepath"));
                        if (StringUtils.isEmpty((CharSequence)subMatInfo.getKeytreepath())) {
                            subMatInfo.setKeytreepath(CostRecCalcHelper.getKeytreepath(subMatInfo.getTreepath()));
                        }
                        tmpSet.add(subMatInfo);
                    }
                } else {
                    Set<HalfprdStructureInfo> submatInfos = parentAndSubInfosMap.get(key);
                    if (submatInfos != null) {
                        subMatList.add(submatInfos);
                    }
                }
                if (subMatList == null || subMatList.isEmpty()) continue;
                needSave = true;
                existsTreepath.add(parentTreePath);
                this.generateSubNode(hrParam, entry, entrys, subMatList, notDeletedSet, isMuilt, totalAmt);
                logger.info("BopHalfprdStructureEngine\u2014\u2014>materialid:{},added new entrys:{}\u6761", (Object)subHalfprdStructure.getString("material.id"), (Object)entrys.size());
            }
            if (needSave) {
                if (entrys.size() - entryLenght > 0) {
                    this.reSetLeaf(entrys);
                }
                this.setAmountCoeff(entrys, totalAmt);
                subHalfprdStructure.set("modifier", (Object)userId);
                subHalfprdStructure.set("modifytime", (Object)date);
                subHalfprdStructure.set("auditor", (Object)userId);
                subHalfprdStructure.set("auditdate", (Object)date);
                saveList.add(subHalfprdStructure);
            }
            if (saveList.size() < 10) continue;
            Long starttime = System.currentTimeMillis();
            logger.info("BopHalfprdStructureEngine\u2014\u2014>saveList.size:{}", (Object)saveList.size());
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            logger.info("BopHalfprdStructureEngine\u4fdd\u5b58\u8017\u65f6\uff1a{}\u79d2", (Object)((System.currentTimeMillis() - starttime) / 1000L));
            saveList.clear();
        }
        if (!saveList.isEmpty()) {
            Long starttime = System.currentTimeMillis();
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            logger.info("BopHalfprdStructureEngine\u4fdd\u5b58\u8017\u65f6\uff1a{}\u79d2", (Object)((System.currentTimeMillis() - starttime) / 1000L));
        }
    }

    private void generateSubNode(HalfprdStructureParams hrParam, DynamicObject parentEntry, DynamicObjectCollection entrys, List<Set<HalfprdStructureInfo>> subMatList, Set<String> notDeletedSet, boolean isMuilt, BigDecimal totalAmt) {
        Long level = parentEntry.getLong("level");
        BigDecimal unitQty = parentEntry.getBigDecimal("qty");
        BigDecimal unitAmt = parentEntry.getBigDecimal("amount");
        String parentTreePath = parentEntry.getString("treepath");
        String parentKeyTreePath = parentEntry.getString("keytreepath");
        if (StringUtils.isEmpty((CharSequence)parentKeyTreePath)) {
            parentKeyTreePath = CostRecCalcHelper.getKeytreepath(parentTreePath);
            parentEntry.set("keytreepath", (Object)parentKeyTreePath);
        }
        HashMap currDifAmtMap = Maps.newHashMapWithExpectedSize((int)16);
        currDifAmtMap.put(parentKeyTreePath, unitAmt);
        for (Set<HalfprdStructureInfo> tmpSubmatInfos : subMatList) {
            HashMap tmpRowMap = Maps.newHashMapWithExpectedSize((int)64);
            HashMap difAmtMap = Maps.newHashMapWithExpectedSize((int)64);
            ArrayList newEntrys = Lists.newArrayListWithExpectedSize((int)64);
            for (HalfprdStructureInfo halfprdStructureInfo : tmpSubmatInfos) {
                BigDecimal compareAmt;
                BigDecimal currAllocedAmt = halfprdStructureInfo.getSubmatAmtCoef().multiply(unitAmt).setScale(hrParam.getPriceScale(), RoundingMode.HALF_UP);
                if (BigDecimal.ZERO.compareTo(currAllocedAmt) == 0) continue;
                DynamicObject newSubmatInfso = entrys.addNew();
                newEntrys.add(newSubmatInfso);
                newSubmatInfso.set("level", (Object)(level + (long)halfprdStructureInfo.getLevel().intValue()));
                newSubmatInfso.set("element", (Object)halfprdStructureInfo.getElementId());
                newSubmatInfso.set("subelement", (Object)halfprdStructureInfo.getSubelementId());
                if (isMuilt) {
                    newSubmatInfso.set("submaterial", (Object)halfprdStructureInfo.getSubmaterialId());
                    newSubmatInfso.set("subcalckeycol", (Object)halfprdStructureInfo.getSubcalckeycolId());
                    newSubmatInfso.set("treepath", (Object)(parentTreePath.substring(0, parentTreePath.lastIndexOf("@")) + "@" + halfprdStructureInfo.getTreepath()));
                    newSubmatInfso.set("keytreepath", (Object)(parentKeyTreePath.substring(0, parentKeyTreePath.lastIndexOf("@")) + "@" + halfprdStructureInfo.getKeytreepath()));
                } else {
                    if (!"001".equals(halfprdStructureInfo.getElementtype()) && !"002".equals(halfprdStructureInfo.getElementtype())) {
                        newSubmatInfso.set("submaterial", (Object)parentEntry.getString("submaterial.id"));
                        newSubmatInfso.set("subcalckeycol", (Object)parentEntry.getString("subcalckeycol.id"));
                    } else {
                        newSubmatInfso.set("submaterial", (Object)halfprdStructureInfo.getSubmaterialId());
                        newSubmatInfso.set("subcalckeycol", (Object)halfprdStructureInfo.getSubcalckeycolId());
                    }
                    if ("001".equals(halfprdStructureInfo.getElementtype())) {
                        newSubmatInfso.set("treepath", (Object)(parentTreePath + "@" + halfprdStructureInfo.getSubmaterialId()));
                        newSubmatInfso.set("keytreepath", (Object)(parentKeyTreePath + "@" + CostRecCalcHelper.getKeyIdStr(halfprdStructureInfo.getSubmaterialId(), halfprdStructureInfo.getSubcalckeycolId())));
                    } else {
                        newSubmatInfso.set("treepath", (Object)(parentTreePath + "@0"));
                        newSubmatInfso.set("keytreepath", (Object)(parentKeyTreePath + "@" + CostRecCalcHelper.getKeyIdStr(0L, 0L)));
                    }
                }
                notDeletedSet.add(newSubmatInfso.getString("keytreepath"));
                String treepath = newSubmatInfso.getString("keytreepath");
                String tmpTree = treepath.substring(0, treepath.lastIndexOf("@"));
                newSubmatInfso.set("submaterialversion", (Object)halfprdStructureInfo.getSubmatverId());
                newSubmatInfso.set("submaterialauxprop", (Object)halfprdStructureInfo.getSubauxpropId());
                newSubmatInfso.set("isunabsorb", (Object)halfprdStructureInfo.getIsunabsorb());
                newSubmatInfso.set("qty", (Object)halfprdStructureInfo.getSubmatQty().multiply(unitQty));
                newSubmatInfso.set("amount", (Object)currAllocedAmt);
                if (totalAmt != null && totalAmt.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal amountcoeff = currAllocedAmt.divide(totalAmt, 10, RoundingMode.HALF_UP);
                    newSubmatInfso.set("amountcoeff", (Object)amountcoeff);
                }
                if ((compareAmt = difAmtMap.computeIfAbsent(tmpTree, p -> BigDecimal.ZERO)) == null || currAllocedAmt.compareTo(compareAmt) > 0) {
                    difAmtMap.put(tmpTree, currAllocedAmt);
                    tmpRowMap.put(tmpTree, newSubmatInfso);
                }
                BigDecimal tmp = (BigDecimal)currDifAmtMap.get(tmpTree);
                currDifAmtMap.put(tmpTree, tmp.subtract(currAllocedAmt));
            }
            for (Map.Entry entry : currDifAmtMap.entrySet()) {
                DynamicObject row;
                String tmpParentTreePath = (String)entry.getKey();
                BigDecimal difAmt = (BigDecimal)entry.getValue();
                if (BigDecimal.ZERO.compareTo(difAmt) == 0 || (row = (DynamicObject)tmpRowMap.get(tmpParentTreePath)) == null) continue;
                BigDecimal bigde = row.getBigDecimal("amount");
                bigde = bigde.add(difAmt);
                row.set("amount", (Object)bigde);
                if (totalAmt == null || totalAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                row.set("amountcoeff", (Object)bigde.divide(totalAmt, 10, RoundingMode.HALF_UP));
            }
            currDifAmtMap.clear();
            for (DynamicObject dynamicObject : newEntrys) {
                currDifAmtMap.put(dynamicObject.getString("keytreepath"), dynamicObject.getBigDecimal("amount"));
            }
        }
    }

    private void setAmountCoeff(DynamicObjectCollection entrys, BigDecimal totalAmt) {
        if (totalAmt != null && totalAmt.compareTo(BigDecimal.ZERO) != 0) {
            for (DynamicObject entry : entrys) {
                BigDecimal amountcoeffCr;
                BigDecimal amountcoeff = entry.getBigDecimal("amountcoeff");
                if (amountcoeff.compareTo(amountcoeffCr = entry.getBigDecimal("amount").divide(totalAmt, 10, RoundingMode.HALF_UP)) == 0) continue;
                entry.set("amountcoeff", (Object)amountcoeffCr);
            }
        }
    }

    private void reSetLeaf(DynamicObjectCollection entrys) {
        HashSet<String> parentTreepathSet = new HashSet<String>();
        for (DynamicObject newSubmatInfso : entrys) {
            String treepath = newSubmatInfso.getString("treepath");
            parentTreepathSet.add(treepath.substring(0, treepath.lastIndexOf("@")));
        }
        for (DynamicObject newSubmatInfso : entrys) {
            String isleaf = newSubmatInfso.getString("isleaf");
            if (parentTreepathSet.contains(newSubmatInfso.getString("treepath"))) {
                if (!StringUtils.isEmpty((CharSequence)isleaf) && !"true".equals(isleaf)) continue;
                newSubmatInfso.set("isleaf", (Object)"0");
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)isleaf) && !"false".equals(isleaf)) continue;
            newSubmatInfso.set("isleaf", (Object)"1");
        }
    }

    private void createHalfprdstructureInfos(HalfprdStructureParams hrParam, QFilter baseFilter, Set<String> matIds, Set<Long> unRecoveryMaterialIdSet) {
        QFilter parentMatFilter = CostRecCalcHelper.getMatKeyQFilter(matIds, "material", "calckeycol");
        DataSet parHalfprdStructuresDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdhide", (String)"material as materialId,calckeycol as calckeycolId", (QFilter[])new QFilter[]{baseFilter, parentMatFilter}, null).distinct();
        for (Object row : parHalfprdStructuresDataSet) {
            matIds.remove(CostRecCalcHelper.getKeyIdStr(row.getLong("materialId"), row.getLong("calckeycolId")));
        }
        if (!CadEmptyUtils.isEmpty(unRecoveryMaterialIdSet)) {
            HashSet<String> needRemoveId = new HashSet<String>();
            for (String matKey : matIds) {
                String[] matcols = matKey.split("-");
                if (!unRecoveryMaterialIdSet.contains(Long.parseLong(matcols[0]))) continue;
                needRemoveId.add(matKey);
            }
            matIds.removeAll(needRemoveId);
        }
        QFilter matFilter = CostRecCalcHelper.getMatKeyQFilter(matIds, "material", "calckeycol");
        DynamicObject[] halfprdStructures = BusinessDataServiceHelper.load((String)"sca_halfprdstructure", (String)this.getHalfprdStcFiledsByObj(), (QFilter[])new QFilter[]{baseFilter, matFilter});
        ArrayList<DynamicObject> halfprdhideInfos = new ArrayList<DynamicObject>(halfprdStructures.length);
        String userId = RequestContext.get().getUserId();
        Date date = TimeServiceHelper.now();
        for (DynamicObject halfprdStructure : halfprdStructures) {
            DynamicObject halfprdhideInfo = BusinessDataServiceHelper.newDynamicObject((String)"sca_halfprdhide");
            halfprdhideInfo.set("billno", (Object)ID.genStringId());
            halfprdhideInfo.set("org", halfprdStructure.get("org"));
            halfprdhideInfo.set("costaccount", halfprdStructure.get("costaccount"));
            halfprdhideInfo.set("prdorg", halfprdStructure.get("prdorg"));
            halfprdhideInfo.set("storageorgunit", (Object)hrParam.getStOrgId());
            halfprdhideInfo.set("currency", halfprdStructure.get("currency"));
            halfprdhideInfo.set("period", halfprdStructure.get("period"));
            halfprdhideInfo.set("material", halfprdStructure.get("material"));
            halfprdhideInfo.set("materialversion", halfprdStructure.get("materialversion"));
            halfprdhideInfo.set("auxprop", halfprdStructure.get("auxprop"));
            halfprdhideInfo.set("calckeycol", halfprdStructure.get("calckeycol"));
            halfprdhideInfo.set("totalamount", halfprdStructure.get("totalamount"));
            halfprdhideInfo.set("billstatus", (Object)"C");
            halfprdhideInfo.set("creator", (Object)userId);
            halfprdhideInfo.set("createtime", (Object)date);
            halfprdhideInfo.set("modifier", (Object)userId);
            halfprdhideInfo.set("modifytime", (Object)date);
            halfprdhideInfo.set("auditor", (Object)userId);
            halfprdhideInfo.set("auditdate", (Object)date);
            DynamicObjectCollection entrys = halfprdStructure.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entrysHides = halfprdhideInfo.getDynamicObjectCollection("entryentity");
            BigDecimal totalamount = BigDecimalUtils.getBigDecimalOrZero(halfprdStructure.getBigDecimal("totalamount"));
            HashMap<String, Integer> matAndIndexMap = new HashMap<String, Integer>();
            for (DynamicObject entry : entrys) {
                BigDecimal qty = BigDecimalUtils.getBigDecimalOrZero(entry.getBigDecimal("qty"));
                BigDecimal amt = BigDecimalUtils.getBigDecimalOrZero(entry.getBigDecimal("amount"));
                String matver = this.getStringIdDefaultZero(entry, "submaterialversion.id");
                String auxprop = this.getStringIdDefaultZero(entry, "submaterialauxprop.id");
                if (BigDecimal.ZERO.compareTo(qty) == 0 && BigDecimal.ZERO.compareTo(amt) == 0) continue;
                String entryKey = entry.getString("submaterial.id") + "@" + matver + "@" + auxprop + "@" + entry.getString("element.id") + "@" + entry.getString("subelement.id") + "@" + entry.getString("subcalckeycol.id");
                if (matAndIndexMap.containsKey(entryKey)) {
                    DynamicObject oldEntry = (DynamicObject)entrysHides.get(((Integer)matAndIndexMap.get(entryKey)).intValue());
                    oldEntry.set("qty", (Object)oldEntry.getBigDecimal("qty").add(qty));
                    BigDecimal entryAmount = oldEntry.getBigDecimal("amount").add(amt);
                    oldEntry.set("amount", (Object)entryAmount);
                    if (BigDecimal.ZERO.compareTo(totalamount) == 0) continue;
                    oldEntry.set("amountcoeff", (Object)entryAmount.divide(totalamount, 10, RoundingMode.HALF_UP));
                    continue;
                }
                DynamicObject entryHide = entrysHides.addNew();
                matAndIndexMap.put(entryKey, entrysHides.size() - 1);
                entryHide.set("element", entry.get("element"));
                entryHide.set("subelement", entry.get("subelement"));
                entryHide.set("level", (Object)1);
                if (!"001".equals(entry.getString("subelement.type")) && !"002".equals(entry.getString("subelement.type"))) {
                    entryHide.set("submaterial", halfprdStructure.get("material.id"));
                    entryHide.set("subcalckeycol", halfprdStructure.get("calckeycol.id"));
                } else {
                    entryHide.set("submaterial", entry.get("submaterial"));
                    entryHide.set("subcalckeycol", entry.get("subcalckeycol"));
                }
                if ("001".equals(entry.getString("subelement.type"))) {
                    entryHide.set("treepath", (Object)(halfprdhideInfo.get("material.id") + "@" + entry.get("submaterial.id")));
                    entryHide.set("keytreepath", (Object)(CostRecCalcHelper.getKeyIdStr(halfprdhideInfo.getLong("material.id"), halfprdhideInfo.getLong("calckeycol.id")) + "@" + CostRecCalcHelper.getKeyIdStr(entry.getLong("submaterial.id"), entry.getLong("subcalckeycol.id"))));
                } else {
                    entryHide.set("treepath", (Object)(halfprdhideInfo.get("material.id") + "@0"));
                    entryHide.set("keytreepath", (Object)(CostRecCalcHelper.getKeyIdStr(halfprdhideInfo.getLong("material.id"), halfprdhideInfo.getLong("calckeycol.id")) + "@" + CostRecCalcHelper.getKeyIdStr(0L, 0L)));
                }
                entryHide.set("isleaf", (Object)1);
                entryHide.set("isunabsorb", (Object)entry.getString("isunabsorb"));
                entryHide.set("submaterialversion", entry.get("submaterialversion"));
                entryHide.set("submaterialauxprop", entry.get("submaterialauxprop"));
                entryHide.set("qty", (Object)qty);
                entryHide.set("amount", (Object)amt);
                entryHide.set("vrtdionno", entry.get("vrtdionno"));
                entryHide.set("issprit", (Object)1);
                if (BigDecimal.ZERO.compareTo(totalamount) == 0) continue;
                entryHide.set("amountcoeff", (Object)entry.getBigDecimal("amount").divide(totalamount, 10, RoundingMode.HALF_UP));
            }
            BigDecimal sumcoeff = BigDecimal.ZERO;
            int maxAmountIndex = 0;
            for (int i = 0; i < entrysHides.size(); ++i) {
                sumcoeff = sumcoeff.add(((DynamicObject)entrysHides.get(i)).getBigDecimal("amountcoeff"));
                if (((DynamicObject)entrysHides.get(maxAmountIndex)).getBigDecimal("amount").compareTo(((DynamicObject)entrysHides.get(i)).getBigDecimal("amount")) >= 0) continue;
                maxAmountIndex = i;
            }
            if (sumcoeff.compareTo(new BigDecimal(1)) != 0) {
                sumcoeff = new BigDecimal(1).subtract(sumcoeff);
                ((DynamicObject)entrysHides.get(maxAmountIndex)).set("amountcoeff", (Object)sumcoeff.add(((DynamicObject)entrysHides.get(maxAmountIndex)).getBigDecimal("amountcoeff")));
            }
            halfprdhideInfos.add(halfprdhideInfo);
        }
        SaveServiceHelper.save((DynamicObject[])halfprdhideInfos.toArray(new DynamicObject[0]));
    }

    private Set<String> getRecalcMatIds(QFilter baseFilter) {
        HashSet<String> reqRecalcMatIds = new HashSet<String>();
        HashSet<String> prdMatIds = new HashSet<String>();
        HashSet<String> prdHideMatIds = new HashSet<String>();
        DataSet halfprdStructureData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdstructure", (String)"material as materialId,calckeycol as calckeycolId,ismodify", (QFilter[])new QFilter[]{baseFilter}, null).distinct();
        for (Row row : halfprdStructureData) {
            String matIdKey = CostRecCalcHelper.getKeyIdStr(row.getLong("materialId"), row.getLong("calckeycolId"));
            if (Boolean.TRUE.equals(row.getBoolean("ismodify"))) {
                reqRecalcMatIds.add(matIdKey);
            }
            prdMatIds.add(matIdKey);
        }
        DataSet halfHidePrd = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdhide", (String)"material as materialId,calckeycol as calckeycolId", (QFilter[])new QFilter[]{baseFilter}, null).distinct();
        for (Row row : halfHidePrd) {
            prdHideMatIds.add(CostRecCalcHelper.getKeyIdStr(row.getLong("materialId"), row.getLong("calckeycolId")));
        }
        prdHideMatIds.removeAll(prdMatIds);
        reqRecalcMatIds.addAll(prdHideMatIds);
        return reqRecalcMatIds;
    }

    private String getStringIdDefaultZero(DynamicObject entry, String key) {
        return entry.getString(key) == null ? "0" : entry.getString(key);
    }

    private String getHalfprdstructurefields() {
        String selectFields = "material as materialId,materialversion matverId,auxprop.id as auxpropId,calckeycol calckeycolId,totalamount,entryentity.submaterial as submaterialId,entryentity.submaterialversion as submatverId,entryentity.submaterialauxprop as subauxpropId,entryentity.subcalckeycol as subcalckeycolId,entryentity.element as elementId,entryentity.subelement.id as subelementId,entryentity.qty as subQty,entryentity.subelement.type as subelementType,entryentity.amount as subAmt,entryentity.amount/totalamount as subAmtCoef,entryentity.vrtdionno as vrtdionno,entryentity.isunabsorb as isunabsorb,1 as level,entryentity.submaterial as treepath";
        return selectFields;
    }

    private String getHalfprdStructureFileds() {
        return "material as materialId,materialversion matverId,auxprop.id as auxpropId,calckeycol calckeycolId,totalamount,entryentity.submaterial as submaterialId,entryentity.submaterialversion as submatverId,entryentity.submaterialauxprop as subauxpropId,entryentity.subcalckeycol as subcalckeycolId,entryentity.element as elementId,entryentity.subelement.id as subelementId,entryentity.qty as subQty,entryentity.subelement.type as subelementType,entryentity.amount as subAmt,entryentity.amountcoeff as subAmtCoef,entryentity.treepath as treepath,entryentity.keytreepath  as keytreepath,entryentity.vrtdionno as vrtdionno,entryentity.isunabsorb as isunabsorb,entryentity.level as level";
    }

    private String getHalfprdStcHideFiledsByObj() {
        return "org,costaccount,prdorg,currency,period,material,materialversion,auxprop.id,calckeycol,totalamount,creator,createtime,modifier,modifytime,auditor,auditdate,entryentity.submaterial,entryentity.submaterialversion,entryentity.submaterialauxprop,entryentity.subcalckeycol,entryentity.element ,entryentity.subelement,entryentity.subelement.type as subelementType,entryentity.qty,entryentity.amount,entryentity.amountcoeff,entryentity.keytreepath,entryentity.treepath,entryentity.vrtdionno,entryentity.isunabsorb,entryentity.isleaf,entryentity.issprit,entryentity.isunabsorb";
    }

    private String getHalfprdStcFiledsByObj() {
        return "org,costaccount,prdorg,currency,period,material,materialversion,auxprop.id,calckeycol,totalamount,creator,createtime,modifier,modifytime,auditor,auditdate,entryentity.submaterial,entryentity.submaterialversion,entryentity.submaterialauxprop,entryentity.subcalckeycol,entryentity.element ,entryentity.subelement,entryentity.qty,entryentity.amount,entryentity.amountcoeff,entryentity.treepath,entryentity.keytreepath,entryentity.vrtdionno,entryentity.isunabsorb,entryentity.isleaf";
    }
}

