/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.Collector;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.sca.algox.calc.input.CalcMaterial;
import kd.macc.sca.algox.constants.FactCostReductCalcCheck;
import kd.macc.sca.algox.costrec.BopHalfprdStructureEngine;
import kd.macc.sca.algox.costrec.CostRecoveryDataInputFactory;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.costrec.DebugInfoMsgHandler;
import kd.macc.sca.algox.costrec.function.CostRecoveryCalculateForPursFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryCalculateForTransInFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryCalculateForTransSumFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryCalculateFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryFlagEquationFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryPreConstrBillSaveFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryProMatAmtProcessFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryStructMergeFunction;
import kd.macc.sca.algox.costrec.function.CostRecoverySubMatAmtProcessFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryTransCalcFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryTransStructFunction;
import kd.macc.sca.algox.enums.FactCostReductItemEnum;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CostRecoveryHelper;
import kd.macc.sca.algox.utils.DataSetHelper;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.algox.utils.DataSetXLogUtil;
import kd.macc.sca.algox.utils.FactCostReductTaskHelper;
import kd.macc.sca.algox.utils.IInfoMsgHandler;
import kd.macc.sca.algox.utils.MatLevelHelper;
import kd.macc.sca.algox.utils.ReductCheckHelper;
import kd.macc.sca.algox.utils.ScaDebugHelper;
import kd.macc.sca.algox.wip.CalcMutexHelper;

public class CostRecoveryService {
    private static final Log logger = LogFactory.getLog(CostRecoveryService.class);
    private static final String ALGOKEY_PRE = "CostRec-";
    private static final String[] unionSelect = new String[]{"invOrgId", "level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd", "preQty", "preAmount", "finQty", "finAmount", "preProQty", "proQty", "amountCoeff"};
    private static final String[] calOrgUnionFields = new String[]{"calOrgId", "invOrgId", "periodId", "level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd", "preQty", "preAmount", "finQty", "finAmount", "transInQty", "transInAmt", "actQtyForFinish", "actAmountForFinish", "actQtyForTrans", "actAmountForTrans", "actQtyForPurs", "actAmountForPurs", "preProQty", "proQty", "proTransInQty", "proTransInAmt", "subEntryType", "transOutOrgId"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void costRecovery(CostRecoveryParams crParams) throws KDBizException {
        String periodIsCurrent;
        String lockStr;
        Long taskRecordId;
        Long checkResultId;
        boolean isFail;
        block56: {
            List<Set<CalcMaterial>> matList;
            DynamicObject[] costaccountColl;
            String debugValue;
            String debugColName;
            int seq;
            String curItem;
            String showMsg;
            Long reportId;
            block57: {
                isFail = false;
                checkResultId = crParams.getCheckReportId();
                taskRecordId = crParams.getTaskRecordId();
                reportId = crParams.getCalcReportId();
                showMsg = ResManager.loadKDString((String)"\u7b2c%s\u5c42\u7269\u6599", (String)"CostRecoveryService_0", (String)"macc-sca-algox", (Object[])new Object[0]);
                curItem = FactCostReductItemEnum.getName(FactCostReductItemEnum.CALCTASKCHECK.getValue());
                seq = FactCostReductTaskHelper.saveTaskRecordEntry(taskRecordId, FactCostReductCalcCheck.CALCTASKCHECK, curItem, "2", null);
                String param = SerializationUtils.toJsonString((Object)crParams);
                param = CostRecoveryHelper.changeSomeValue(param);
                ReductCheckHelper.doCheck(param, crParams);
                int failCount = crParams.getCheckNoPassCount();
                FactCostReductTaskHelper.upateTaskRecord(taskRecordId, 10, "2", false);
                if (failCount == 0) {
                    FactCostReductTaskHelper.upateTaskRecordEntry(taskRecordId, FactCostReductCalcCheck.CALCTASKCHECK, seq, "4");
                } else {
                    Map<String, String> failMap = ReductCheckHelper.getCostReductCalcReportEntryFailInfo(checkResultId);
                    String notPassMsg = String.valueOf(failMap.get("notPassMsg"));
                    FactCostReductTaskHelper.upateTaskRecordEntryWithMsg(taskRecordId, FactCostReductCalcCheck.CALCTASKCHECK, seq, notPassMsg, checkResultId, "3");
                }
                String debugString = ScaDebugHelper.getDebugKeyword("sca_costrecovery");
                String tmpDebugColName = null;
                String tmpDebugValue = null;
                try {
                    if (StringUtils.isNotEmpty((String)debugString)) {
                        String[] ss = debugString.split("=");
                        tmpDebugColName = ss[0];
                        tmpDebugValue = ss[1];
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                debugColName = tmpDebugColName;
                debugValue = tmpDebugValue;
                if (failCount != 0) break block56;
                crParams.setCheckResultId(checkResultId);
                curItem = FactCostReductItemEnum.getName(FactCostReductItemEnum.CLEARPREDATA.getValue());
                seq = FactCostReductTaskHelper.saveTaskRecordEntry(taskRecordId, FactCostReductCalcCheck.CLEARPREDATA, curItem, "2", null);
                CostRecoveryHelper.setDefaultElementId(crParams);
                costaccountColl = CostRecoveryHelper.setCommonAttribute(crParams);
                if (crParams.isUsePreConstr()) {
                    BopHalfprdStructureEngine bopHalfprdStructureEngine = new BopHalfprdStructureEngine();
                    bopHalfprdStructureEngine.genBopHalfprdStructure(crParams);
                }
                QFilter clearFilter = new QFilter("org.id", "in", crParams.getRelationCalOrgIds());
                clearFilter.and("costaccount.id", "in", crParams.getRelationCostAccountIds());
                if (crParams.getManuOrgId() != 0L) {
                    clearFilter.and("prdorg.id", "=", (Object)crParams.getManuOrgId());
                }
                clearFilter.and("period.id", "=", (Object)crParams.getNextPeriodId());
                DeleteServiceHelper.delete((String)"sca_halfprdhide", (QFilter[])new QFilter[]{clearFilter});
                QFilter modifyFilter = new QFilter("ismodify", "=", (Object)Boolean.FALSE);
                DeleteServiceHelper.delete((String)"sca_halfprdstructure", (QFilter[])new QFilter[]{clearFilter, modifyFilter});
                FactCostReductTaskHelper.upateTaskRecord(taskRecordId, 10, "2");
                FactCostReductTaskHelper.upateTaskRecordEntry(taskRecordId, FactCostReductCalcCheck.CLEARPREDATA, seq, "4");
                curItem = FactCostReductItemEnum.getName(FactCostReductItemEnum.CLEARCURRDATA.getValue());
                seq = FactCostReductTaskHelper.saveTaskRecordEntry(taskRecordId, FactCostReductCalcCheck.CLEARCURRDATA, curItem, "2", null);
                clearFilter = new QFilter("org.id", "in", crParams.getRelationCalOrgIds());
                clearFilter.and("costaccount.id", "in", crParams.getRelationCostAccountIds());
                if (crParams.getManuOrgId() != 0L) {
                    clearFilter.and("manuorg.id", "=", (Object)crParams.getManuOrgId());
                }
                clearFilter.and("period.id", "=", (Object)crParams.getPeriodId());
                DeleteServiceHelper.delete((String)"sca_costrecovry", (QFilter[])new QFilter[]{clearFilter});
                FactCostReductTaskHelper.upateTaskRecord(taskRecordId, 10, "2");
                FactCostReductTaskHelper.upateTaskRecordEntry(taskRecordId, FactCostReductCalcCheck.CLEARCURRDATA, seq, "4");
                curItem = FactCostReductItemEnum.getName(FactCostReductItemEnum.GETMATLOWLEVEL.getValue());
                seq = FactCostReductTaskHelper.saveTaskRecordEntry(taskRecordId, FactCostReductCalcCheck.GETMATLOWLEVEL, curItem, "2", null);
                MatLevelHelper matLevelHelper = new MatLevelHelper();
                matList = matLevelHelper.getMatLevelByRecovery(crParams);
                if (matList != null && matList.size() != 0) break block57;
                CostRecoveryHelper.afterCalc(isFail, crParams, checkResultId);
                FactCostReductTaskHelper.upateTaskRecord(taskRecordId, 100, isFail ? "3" : "4");
                long costAccountId = crParams.getCostAccountId();
                long manuOrgId = crParams.getManuOrgId();
                String lockStr2 = String.valueOf(costAccountId);
                if (manuOrgId > 0L) {
                    lockStr2 = lockStr2 + manuOrgId;
                }
                CalcMutexHelper.releaseXMutex("reductcalc", lockStr2.hashCode());
                String periodIsCurrent2 = crParams.getPeriodIsCurrent();
                if (CadEmptyUtils.isEmpty(periodIsCurrent2) || !"Y".equals(periodIsCurrent2)) return;
                CalcMutexHelper.releaseXMutex("reductcalc", costAccountId);
                return;
            }
            try {
                void var34_65;
                FactCostReductTaskHelper.upateTaskRecord(taskRecordId, 10, "2");
                FactCostReductTaskHelper.upateTaskRecordEntry(taskRecordId, FactCostReductCalcCheck.GETMATLOWLEVEL, seq, "4");
                logger.info(reportId + ":****matList size " + matList.size() + "****");
                int progess = (int)Math.floor(57.0 / (double)(matList.size() + 1));
                QFilter filter = new QFilter("costaccount", "=", (Object)crParams.getCostAccountId());
                filter.and("period", "=", (Object)crParams.getPeriodId());
                if (crParams.getManuOrgId() > 0L) {
                    filter.and("prdorg", "=", (Object)crParams.getManuOrgId());
                }
                DataSet bophalfStructureData = QueryServiceHelper.queryDataSet((String)"CostRec-half", (String)"sca_halfprdstructure", (String)"material as materialid,entryentity.submaterial as submaterialid", (QFilter[])filter.toArray(), null);
                bophalfStructureData = bophalfStructureData.groupBy(new String[]{"materialid", "submaterialid"}).finish();
                Iterator bophalfStructureDataIt = bophalfStructureData.iterator();
                HashSet allPreMatSet = Sets.newHashSet();
                while (bophalfStructureDataIt.hasNext()) {
                    Row row = (Row)bophalfStructureDataIt.next();
                    allPreMatSet.add(row.getLong("materialid"));
                    if (row.getLong("submaterialid") <= 0L) continue;
                    allPreMatSet.add(row.getLong("submaterialid"));
                }
                ArrayList newMatList = new ArrayList(10);
                newMatList.add(allPreMatSet);
                for (Set<CalcMaterial> set : matList) {
                    HashSet<Long> matSet = new HashSet<Long>(5);
                    for (CalcMaterial calcMaterial : set) {
                        if (calcMaterial.getMaterialId() <= 0L) continue;
                        matSet.add(calcMaterial.getMaterialId());
                    }
                    ((Set)newMatList.get(0)).removeAll(matSet);
                    newMatList.add(matSet);
                }
                final HashMap unRecoveryMaterialIdMap = Maps.newHashMapWithExpectedSize((int)16);
                HashMap unRecoverySubMaterialIdMap = Maps.newHashMapWithExpectedSize((int)16);
                CostRecoveryHelper.setUnRecoveryOrgMaterialIdSetting(logger, crParams, reportId, costaccountColl, unRecoveryMaterialIdMap, unRecoverySubMaterialIdMap);
                final HashMap unRecoverySubMaterialIdParternMap = Maps.newHashMapWithExpectedSize((int)16);
                for (Map.Entry entry : unRecoverySubMaterialIdMap.entrySet()) {
                    HashSet<String> hashSet = new HashSet<String>(((Set)entry.getValue()).size());
                    for (Long l : (Set)entry.getValue()) {
                        hashSet.add(String.format("@%s@", l));
                    }
                    unRecoverySubMaterialIdParternMap.put(entry.getKey(), hashSet);
                }
                HashMap keyInvOrgIdValCalOrgIdMap = Maps.newHashMapWithExpectedSize((int)16);
                if (crParams.getCalRange() != null && crParams.getCalRange().indexOf("PURINBILL") > -1) {
                    for (Long l : crParams.getRelationCalOrgIds()) {
                        List list = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)l, (boolean)true);
                        for (Long invOrgId : list) {
                            keyInvOrgIdValCalOrgIdMap.put(invOrgId, l);
                        }
                    }
                }
                ArrayList arrayList = Lists.newArrayList();
                for (Set set : newMatList) {
                    if (set.size() != 0) continue;
                    arrayList.add(set);
                }
                newMatList.removeAll(arrayList);
                ArrayList<Long> arrayList2 = new ArrayList<Long>(10);
                for (Set set : newMatList) {
                    arrayList2.addAll(set);
                }
                OrmInput ormInput = CostRecoveryService.getMaterialDs(arrayList2);
                boolean bl = false;
                while (var34_65 < newMatList.size()) {
                    Set allMaterialIdSet = (Set)newMatList.get((int)var34_65);
                    Set<String> curCalMatNumbers = this.getMaterialNumberSetByMaterialIdSet(allMaterialIdSet);
                    StringBuilder bigText = new StringBuilder(ResManager.loadKDString((String)"\u672c\u5c42\u8ba1\u7b97\u7269\u6599\u7f16\u7801\u8303\u56f4\uff1a", (String)"CostRecoveryService_1", (String)"macc-sca-algox", (Object[])new Object[0]));
                    bigText.append(curCalMatNumbers.toString());
                    curItem = String.format(showMsg, (int)(var34_65 + true)) + FactCostReductItemEnum.getName(FactCostReductItemEnum.COSTREDUCT.getValue());
                    seq = FactCostReductTaskHelper.saveTaskRecordEntry(taskRecordId, FactCostReductCalcCheck.COSTREDUCT, curItem, "2", bigText.toString());
                    DebugInfoMsgHandler inMsgHandler = new DebugInfoMsgHandler(crParams.getTaskRecordId(), seq);
                    int productCount = allMaterialIdSet.size();
                    logger.info(reportId + ":****setup " + (int)var34_65 + ",productCount " + productCount + "****");
                    ArrayList dataSetList = Lists.newArrayList();
                    HashMap keyCalOrgIdValCostAccountIdMap = Maps.newHashMapWithExpectedSize((int)16);
                    for (DynamicObject costaccountDyo : costaccountColl) {
                        DataSet transInDataSet;
                        Long costaccountId = costaccountDyo.getLong("id");
                        Long calOrgId = costaccountDyo.getLong("calorg.id");
                        keyCalOrgIdValCostAccountIdMap.put(calOrgId, costaccountId);
                        HashSet materialIdSet = Sets.newHashSet((Iterable)allMaterialIdSet);
                        HashSet unRecoveryMaterialIdSet = Sets.newHashSetWithExpectedSize((int)64);
                        if (materialIdSet.size() == 0) continue;
                        unRecoveryMaterialIdSet.addAll(materialIdSet);
                        CostRecoveryHelper.logInfoIdSet(logger, reportId + ":" + calOrgId + ":materialRange" + (int)var34_65, materialIdSet);
                        CostRecoveryDataInputFactory factory = new CostRecoveryDataInputFactory(crParams, costaccountId, calOrgId);
                        logger.info(reportId + "@" + costaccountId + ":****factnedDataSet start****");
                        long start = System.currentTimeMillis();
                        DataSet factnedDataSet = factory.buildFactnedInputDataSet(materialIdSet);
                        if (StringUtils.isNotEmpty((String)debugValue)) {
                            DataSetXLogUtil.logDataSet(factnedDataSet, debugColName, debugValue, String.format(ResManager.loadKDString((String)"index:%1$s@$2$s@%3$s@:\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u6570\u636e\uff1a", (String)"CostRecoveryService_6", (String)"macc-sca-algox", (Object[])new Object[0]), (int)var34_65, reportId, calOrgId), inMsgHandler);
                        }
                        logger.info(reportId + "@" + costaccountId + ":****factnedDataSet end****" + (System.currentTimeMillis() - start));
                        logger.info(reportId + "@" + calOrgId + ":****calcresultDataSet start****");
                        start = System.currentTimeMillis();
                        DataSet calcresultDataSet = factory.buildCalcresultDataSet(materialIdSet);
                        if (StringUtils.isNotEmpty((String)debugValue)) {
                            DataSetXLogUtil.logDataSet(calcresultDataSet, debugColName, debugValue, String.format(ResManager.loadKDString((String)"index:%1$s@%2$s@%3$s@:\u8ba1\u7b97\u7ed3\u679c\u5355\u5f52\u96c6\u6570\u636e\uff1a", (String)"CostRecoveryService_7", (String)"macc-sca-algox", (Object[])new Object[0]), (int)var34_65, reportId, calOrgId), inMsgHandler);
                        }
                        logger.info(reportId + "@" + calOrgId + ":****calcresultDataSet end****" + (System.currentTimeMillis() - start));
                        logger.info(reportId + "@" + calOrgId + ":****purchdiffallocDataSet start****");
                        start = System.currentTimeMillis();
                        DataSet purchdiffallocDataSet = factory.buildPurchdiffallocDataSet();
                        if (StringUtils.isNotEmpty((String)debugValue)) {
                            DataSetXLogUtil.logDataSet(purchdiffallocDataSet, debugColName, debugValue, String.format(ResManager.loadKDString((String)"index:%1$s@%2$s@%3$s@:\u4e0b\u9636\u5dee\u5f02\u5f52\u96c6\u6570\u636e\uff1a", (String)"CostRecoveryService_8", (String)"macc-sca-algox", (Object[])new Object[0]), (int)var34_65, reportId, calOrgId), inMsgHandler);
                        }
                        logger.info(reportId + "@" + calOrgId + ":****buildUnabsorbdiffDataSet start****");
                        start = System.currentTimeMillis();
                        DataSet unAbsorbdiffDataSet = factory.buildUnabsorbdiffDataSet();
                        if (StringUtils.isNotEmpty((String)debugValue)) {
                            DataSetXLogUtil.logDataSet(unAbsorbdiffDataSet, debugColName, debugValue, String.format(ResManager.loadKDString((String)"index:%1$s@%2$s@%3$s@:\u672a\u5438\u6536\u5dee\u5f02\u5f52\u96c6\u6570\u636e\uff1a", (String)"CostRecoveryService_9", (String)"macc-sca-algox", (Object[])new Object[0]), (int)var34_65, reportId, calOrgId), inMsgHandler);
                        }
                        logger.info(reportId + "@" + calOrgId + ":****buildUnabsorbdiffDataSet end****");
                        calcresultDataSet = calcresultDataSet.select("manuOrgId,materialId,materialVerId,materialAuxPropId,subMaterialId,subMertialVerId,subMerialAuxPropId,elementId,subElementId,subElementType,qty as finishQty,amount+diffAmount as finishAmount,'A' as isUnAbsorbd");
                        purchdiffallocDataSet = purchdiffallocDataSet.select("manuOrgId,materialId,materialVerId,materialAuxPropId,subMaterialId,subMertialVerId,subMerialAuxPropId,elementId,subElementId,subElementType,0.00 as finishQty,amount as finishAmount,'A' as isUnAbsorbd");
                        unAbsorbdiffDataSet = unAbsorbdiffDataSet.select("manuOrgId,materialId,materialVerId,materialAuxPropId,subMaterialId,subMertialVerId,subMerialAuxPropId,elementId,subElementId,subElementType,0.00 as finishQty,amount as finishAmount,isUnAbsorbd");
                        logger.info(reportId + "@" + calOrgId + ":****finishResultDataSet start****");
                        start = System.currentTimeMillis();
                        DataSet finishResultDataSet = calcresultDataSet.union(purchdiffallocDataSet).union(unAbsorbdiffDataSet);
                        if (SysParamEnum.RESTOREDIMENSION_ORG.getValue().equals(crParams.getCalDimension())) {
                            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(finishResultDataSet.getRowMeta().getFieldNames()));
                            fieldNames.remove("manuOrgId");
                            fieldNames.add("0L manuOrgId");
                            finishResultDataSet = finishResultDataSet.select(fieldNames.toArray(new String[0]));
                        }
                        finishResultDataSet = finishResultDataSet.groupBy(new String[]{"manuOrgId", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "subElementType", "isUnAbsorbd"}).sum("finishQty").sum("finishAmount").finish();
                        if (StringUtils.isNotEmpty((String)debugValue)) {
                            DataSetXLogUtil.logDataSet(finishResultDataSet, debugColName, debugValue, "index:" + (int)var34_65 + "@" + reportId + "@" + calOrgId + "@:finishResultDataSet\uff1a", inMsgHandler);
                        }
                        logger.info(reportId + "@" + calOrgId + ":****finishResultDataSet end****" + (System.currentTimeMillis() - start));
                        JobSession subSession = AlgoX.createSession((String)("CostRec-Lvl-" + costaccountId + ":" + (int)var34_65));
                        DataSetX finishDataSetX = null;
                        DataSetOutput resultSet = null;
                        String resultId = null;
                        if (SysParamEnum.RESTOREDIMENSION_ORG.getValue().equals(crParams.getCalDimension())) {
                            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(factnedDataSet.getRowMeta().getFieldNames()));
                            fieldNames.remove("invOrgId");
                            fieldNames.add("0L invOrgId");
                            factnedDataSet = factnedDataSet.select(fieldNames.toArray(new String[0]));
                            factnedDataSet = factnedDataSet.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).sum("qty").finish();
                        }
                        DataSet finishDataSet = finishResultDataSet.leftJoin(factnedDataSet).on("materialId", "materialId").on("materialVerId", "materialAuxPropId").on("materialAuxPropId", "materialAuxPropId").on("manuOrgId", "invOrgId").select(new String[]{"materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "subElementType", "isUnAbsorbd", "finishQty", "finishAmount"}, new String[]{"invOrgId", "qty productQty"}).finish();
                        finishDataSet = finishDataSet.filter("!(finishQty=0 and finishAmount=0)");
                        if (SysParamEnum.RESTOREDIMENSION_ORG.getValue().equals(crParams.getCalDimension())) {
                            finishDataSet = finishDataSet.select(new String[]{"materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "subElementType", "isUnAbsorbd", "finishQty", "finishAmount", "0L invOrgId", "productQty"});
                        }
                        DataSet subMaterialDataSet = finishDataSet.copy().filter("subMaterialId!=materialId").filter("isUnAbsorbd='A'").filter("subElementType='001'").select("invOrgId,subMaterialId,subMertialVerId,subMerialAuxPropId");
                        HashSet subMaterialIdSet = Sets.newHashSet();
                        for (Row row : subMaterialDataSet) {
                            subMaterialIdSet.add(row.getLong("subMaterialId"));
                        }
                        CostRecoveryHelper.logInfoIdSet(logger, reportId + "@" + calOrgId + ":subMaterialIdSet" + (int)var34_65, subMaterialIdSet);
                        logger.info(reportId + "@" + calOrgId + ":****subMatFinishDataSetX start****");
                        start = System.currentTimeMillis();
                        DataSet tmpFinishDataSet = finishDataSet.copy().filter("isUnAbsorbd='A'").groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "isUnAbsorbd"}).sum("finishQty").sum("finishAmount").max("productQty").finish();
                        DataSet subMaterialDataSet2 = finishDataSet.copy().filter("subMaterialId=materialId").filter("isUnAbsorbd='A'").filter("subElementType='001'").select("subMaterialId,subMertialVerId,subMerialAuxPropId");
                        HashSet subMaterialIdSet2 = Sets.newHashSet();
                        for (Row row : subMaterialDataSet2) {
                            subMaterialIdSet2.add(row.getLong("subMaterialId"));
                        }
                        DataSet preConstrDataSet2 = factory.buildPreConstrDataSet(subMaterialIdSet2, crParams.getPeriodId());
                        DataSet preConstrDataSet = factory.buildPreConstrDataSet(subMaterialIdSet, crParams.getNextPeriodId());
                        preConstrDataSet = preConstrDataSet.union(preConstrDataSet2);
                        DataSet subPreConstrDataSet = preConstrDataSet.leftJoin(tmpFinishDataSet).on("invOrgId", "invOrgId").on("materialId", "subMaterialId").on("materialVerId", "subMertialVerId").on("materialAuxPropId", "subMerialAuxPropId").select(preConstrDataSet.getRowMeta().getFieldNames(), new String[]{"finishQty as tmpQty", "finishAmount as tmpAmount", "materialId as tmpMaterialId", "materialVerId as tmpMaterialVerId", "materialAuxPropId as tmpMaterialAuxPropId", "productQty as tmpProductQty"}).finish();
                        DataSetX subMatFinishDataSetX = subSession.fromInput((Input)new DataSetInput(subPreConstrDataSet));
                        subMatFinishDataSetX = subMatFinishDataSetX.addFields(new Field[]{new Field("finQty", (DataType)DataType.BigDecimalType), new Field("finAmount", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
                        subMatFinishDataSetX = DataSetXLogUtil.logDataSetX(subMatFinishDataSetX, debugColName, debugValue, "index:" + (int)var34_65 + "@" + reportId + "@" + calOrgId + "@subMatFinishDataSetX-befer", inMsgHandler);
                        subMatFinishDataSetX = subMatFinishDataSetX.groupBy(new String[]{"invOrgId", "tmpMaterialId", "tmpMaterialVerId", "tmpMaterialAuxPropId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoverySubMatAmtProcessFunction(subMatFinishDataSetX.getRowMeta(), crParams));
                        logger.info(reportId + "@" + costaccountId + ":****subMatFinishDataSetX end****" + (System.currentTimeMillis() - start));
                        subMatFinishDataSetX = DataSetXLogUtil.logDataSetX(subMatFinishDataSetX, debugColName, debugValue, "index:" + (int)var34_65 + "@" + reportId + "@" + calOrgId + "@subMatFinishDataSetX-after", inMsgHandler);
                        subMatFinishDataSetX = subMatFinishDataSetX.removeFields(new String[]{"tmpQty", "tmpAmount", "tmpMaterialId", "tmpMaterialVerId", "tmpMaterialAuxPropId", "qty", "tmpProductQty"});
                        logger.info(reportId + "@" + calOrgId + ":****proMatDataSetX start****");
                        start = System.currentTimeMillis();
                        DataSet productPreConstrDataSet = factory.buildPreConstrDataSet(materialIdSet, crParams.getPeriodId());
                        logger.info(reportId + "@" + calOrgId + ":****balDataSet start****");
                        start = System.currentTimeMillis();
                        DataSet balDataSet = factory.buildBalanceDataSet(materialIdSet);
                        logger.info(reportId + "@" + calOrgId + ":****balDataSet end****" + (System.currentTimeMillis() - start));
                        productPreConstrDataSet = productPreConstrDataSet.leftJoin(balDataSet).on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").select(productPreConstrDataSet.getRowMeta().getFieldNames(), new String[]{"qty as preProQty", "amount as balanceAmount"}).finish();
                        DataSetX proMatDataSetX = subSession.fromInput((Input)new DataSetInput(productPreConstrDataSet));
                        proMatDataSetX = proMatDataSetX.addFields(new Field[]{new Field("preQty", (DataType)DataType.BigDecimalType), new Field("preAmount", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
                        HashMap fieldKey = Maps.newHashMapWithExpectedSize((int)16);
                        fieldKey.put("proQtyKey", "preProQty");
                        fieldKey.put("proAmtKey", "balanceAmount");
                        fieldKey.put("unitQtyKey", "qty");
                        fieldKey.put("unitAmountCoeffKey", "amountCoeff");
                        fieldKey.put("saveQtyKey", "preQty");
                        fieldKey.put("saveAmtKey", "preAmount");
                        proMatDataSetX = DataSetXLogUtil.logDataSetX(proMatDataSetX, debugColName, debugValue, "index:" + (int)var34_65 + "@" + reportId + "@" + calOrgId + "@proMatDataSetX-befer", inMsgHandler);
                        proMatDataSetX = proMatDataSetX.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryProMatAmtProcessFunction(proMatDataSetX.getRowMeta(), crParams, fieldKey));
                        proMatDataSetX = DataSetXLogUtil.logDataSetX(proMatDataSetX, debugColName, debugValue, "index:" + (int)var34_65 + "@" + reportId + "@" + calOrgId + "@proMatDataSetX-after", inMsgHandler);
                        proMatDataSetX = proMatDataSetX.removeFields(new String[]{"qty"});
                        logger.info(reportId + "@" + calOrgId + ":****proMatDataSetX end****" + (System.currentTimeMillis() - start));
                        logger.info(reportId + "@" + calOrgId + ":****finishDataSetX start****");
                        start = System.currentTimeMillis();
                        finishDataSet = finishDataSet.select("invOrgId,1 as level,case when subElementType ='001' then concat(cast(materialId as String),'@',cast(subMaterialId as String)) else concat(cast(materialId as String),'@0') end as treepath,materialId,materialVerId,materialAuxPropId,subMaterialId,subMertialVerId,subMerialAuxPropId,elementId,subElementId,isUnAbsorbd,0.00 as preQty,0.00 as preAmount,0.00 as amountCoeff,finishQty as finQty,finishAmount as finAmount,0.00 as preProQty,productQty as proQty");
                        finishDataSetX = subSession.fromInput((Input)new DataSetInput(finishDataSet));
                        proMatDataSetX = proMatDataSetX.addFields(new Field[]{new Field("finQty", (DataType)DataType.BigDecimalType), new Field("finAmount", (DataType)DataType.BigDecimalType), new Field("proQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
                        subMatFinishDataSetX = subMatFinishDataSetX.addFields(new Field[]{new Field("preQty", (DataType)DataType.BigDecimalType), new Field("preAmount", (DataType)DataType.BigDecimalType), new Field("preProQty", (DataType)DataType.BigDecimalType), new Field("proQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
                        proMatDataSetX = proMatDataSetX.removeFields(new String[]{"balanceAmount"});
                        finishDataSetX = finishDataSetX.select(unionSelect);
                        proMatDataSetX = proMatDataSetX.select(unionSelect);
                        subMatFinishDataSetX = subMatFinishDataSetX.select(unionSelect);
                        DataSetX rsDataSetX = finishDataSetX.union(proMatDataSetX).union(subMatFinishDataSetX);
                        if (StringUtils.isNotEmpty((String)debugValue)) {
                            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + (int)var34_65 + "@" + reportId + "@" + calOrgId + "@rsDataSetX-befer", inMsgHandler);
                        }
                        DataSetX groupByDataSetXForQty = rsDataSetX.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).max("preProQty").max("proQty");
                        rsDataSetX = rsDataSetX.removeFields(new String[]{"preProQty", "proQty"});
                        rsDataSetX = rsDataSetX.groupBy(new String[]{"invOrgId", "level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd"}).sum("preQty").sum("preAmount").max("amountCoeff").sum("finQty").sum("finAmount");
                        rsDataSetX = rsDataSetX.leftJoin(groupByDataSetXForQty).on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").select(rsDataSetX.getRowMeta().getFieldNames(), new String[]{"preProQty", "proQty"});
                        rsDataSetX = rsDataSetX.orderBy(new String[]{"invOrgId", "materialId", "level", "treepath", "subMaterialId"});
                        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("unitQty", (DataType)DataType.BigDecimalType), new Field("unitAmt", (DataType)DataType.BigDecimalType), new Field("actQtyForFinish", (DataType)DataType.BigDecimalType), new Field("actAmountForFinish", (DataType)DataType.BigDecimalType), new Field("actQtyForTrans", (DataType)DataType.BigDecimalType), new Field("actAmountForTrans", (DataType)DataType.BigDecimalType), new Field("actQtyForPurs", (DataType)DataType.BigDecimalType), new Field("actAmountForPurs", (DataType)DataType.BigDecimalType), new Field("addPreQty", (DataType)DataType.BigDecimalType), new Field("transInQty", (DataType)DataType.BigDecimalType), new Field("transInAmt", (DataType)DataType.BigDecimalType), new Field("proActAmt", (DataType)DataType.BigDecimalType), new Field("proActQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
                        if (StringUtils.isNotEmpty((String)debugValue)) {
                            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + (int)var34_65 + "@" + reportId + "@" + calOrgId + "@rsDataSetX-remove-notreduct", inMsgHandler);
                        }
                        rsDataSetX = rsDataSetX.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryCalculateFunction(rsDataSetX.getRowMeta(), crParams));
                        if (StringUtils.isNotEmpty((String)debugValue)) {
                            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + (int)var34_65 + "@" + reportId + "@" + calOrgId + "@rsDataSetX-after", inMsgHandler);
                        }
                        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("periodId", (DataType)DataType.LongType)}, new Object[]{crParams.getPeriodId()});
                        boolean isContainsTransIn = false;
                        if (crParams.getCalRange() != null && crParams.getCalRange().indexOf("TRANSDIRBILL") > -1 && !(transInDataSet = factory.buildTransInDataSet(crParams, costaccountId, calOrgId, allMaterialIdSet)).isEmpty()) {
                            isContainsTransIn = true;
                            rsDataSetX = this.transInProcess(crParams, reportId, calOrgId, subSession, (int)var34_65, rsDataSetX, transInDataSet, debugColName, debugValue, inMsgHandler);
                        }
                        if (!isContainsTransIn) {
                            rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType), new Field("transOutOrgId", (DataType)DataType.LongType), new Field("proTransInQty", (DataType)DataType.BigDecimalType), new Field("proTransInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{0, 0L, BigDecimal.ZERO, BigDecimal.ZERO});
                        }
                        if (StringUtils.isNotEmpty((String)debugValue)) {
                            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + (int)var34_65 + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-xxxxx-pre", inMsgHandler);
                        }
                        rsDataSetX = rsDataSetX.groupBy(new String[]{"periodId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryCalculateForTransInFunction(rsDataSetX.getRowMeta(), crParams));
                        if (StringUtils.isNotEmpty((String)debugValue)) {
                            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + (int)var34_65 + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-xxxxx-final", inMsgHandler);
                        }
                        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("calOrgId", (DataType)DataType.LongType)}, new Object[]{calOrgId});
                        resultSet = new DataSetOutput(rsDataSetX.getRowMeta());
                        resultId = resultSet.getId();
                        rsDataSetX.output((Output)resultSet);
                        subSession.commit(1, TimeUnit.HOURS);
                        DataSet rsDateSet = subSession.readDataSet(resultId);
                        if (StringUtils.isNotEmpty((String)debugValue)) {
                            DataSetXLogUtil.logDataSet(rsDateSet, debugColName, debugValue, "index:" + (int)var34_65 + "@" + reportId + "@" + calOrgId + "@rsDataSet-final", inMsgHandler);
                        }
                        dataSetList.add(rsDateSet);
                        logger.info(reportId + "@" + calOrgId + "index:" + (int)var34_65 + "@****finishDataSetX end****" + (System.currentTimeMillis() - start));
                    }
                    JobSession session = AlgoX.createSession((String)"CostRec-purAndSave");
                    DataSet rsDataSet = null;
                    for (int j = 0; j < dataSetList.size(); ++j) {
                        if (j == 0) {
                            rsDataSet = ((DataSet)dataSetList.get(j)).select(calOrgUnionFields);
                            continue;
                        }
                        if (rsDataSet == null) continue;
                        rsDataSet = DataSetHelper.union(rsDataSet, (DataSet)dataSetList.get(j));
                    }
                    if (rsDataSet == null) {
                        FactCostReductTaskHelper.upateTaskRecord(taskRecordId, progess, "2");
                        FactCostReductTaskHelper.upateTaskRecordEntry(taskRecordId, FactCostReductCalcCheck.COSTREDUCT, seq, "4");
                    } else {
                        DataSet purInDataSet;
                        if (StringUtils.isNotEmpty((String)debugValue)) {
                            DataSetXLogUtil.logDataSet(rsDataSet, debugColName, debugValue, "index:" + (int)var34_65 + "@" + reportId + "@AllRsDataSet-Merge", inMsgHandler);
                        }
                        DataSetX rsDataSetX = session.fromInput((Input)new DataSetInput(rsDataSet));
                        DataSetX otherSubEntryTypeDsx = rsDataSetX.filter("subEntryType>0");
                        otherSubEntryTypeDsx = otherSubEntryTypeDsx.addFields(new Field[]{new Field("pursInQty", (DataType)DataType.BigDecimalType), new Field("pursInAmt", (DataType)DataType.BigDecimalType), new Field("proPursInQty", (DataType)DataType.BigDecimalType), new Field("proPursInAmt", (DataType)DataType.BigDecimalType), new Field("salesCalOrgId", (DataType)DataType.LongType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0L});
                        rsDataSetX = rsDataSetX.filter("subEntryType=0");
                        if (crParams.getCalRange() != null && crParams.getCalRange().indexOf("PURINBILL") > -1 && !(purInDataSet = this.buildPurInDataSet(crParams, allMaterialIdSet)).isEmpty()) {
                            rsDataSetX = this.pursInProcess(crParams, reportId, session, (int)var34_65, rsDataSetX, purInDataSet, keyInvOrgIdValCalOrgIdMap, debugColName, debugValue, inMsgHandler);
                        }
                        rsDataSetX = DataSetXHelper.unionIfRowDiff(otherSubEntryTypeDsx, rsDataSetX);
                        rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + (int)var34_65 + "@reportId:" + reportId + "@session-befer", inMsgHandler);
                        Map<Long, Set<String>> userModifyMaterialIdSetMap = CostRecoveryHelper.getModifyMaterialIdSet(crParams, null);
                        if (rsDataSetX != null) {
                            rsDataSetX = rsDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup(new GroupReduceFunction(){

                                public RowMeta getResultRowMeta() {
                                    return this.sourceRowMeta;
                                }

                                public void reduce(Iterable<RowX> rowxs, Collector cols) {
                                    Iterator<RowX> its = rowxs.iterator();
                                    int i = 0;
                                    Set unRecoverySubMaterialIdParternSet = null;
                                    while (its.hasNext()) {
                                        RowX row = its.next();
                                        if (i == 0) {
                                            Long orgId = row.getLong(this.sourceRowMeta.getFieldIndex("calOrgId"));
                                            Long storgId = row.getLong(this.sourceRowMeta.getFieldIndex("invOrgId"));
                                            Long materialId = row.getLong(this.sourceRowMeta.getFieldIndex("materialId"));
                                            String key = String.format("%s@%s", orgId, storgId);
                                            if (unRecoveryMaterialIdMap.containsKey(key) && ((Set)unRecoveryMaterialIdMap.get(key)).contains(materialId)) break;
                                            unRecoverySubMaterialIdParternSet = (Set)unRecoverySubMaterialIdParternMap.get(key);
                                            ++i;
                                        }
                                        String treepath = row.getString(this.sourceRowMeta.getFieldIndex("treepath"));
                                        boolean flag = false;
                                        if (unRecoverySubMaterialIdParternSet != null && unRecoverySubMaterialIdParternSet.size() > 0) {
                                            for (String str : unRecoverySubMaterialIdParternSet) {
                                                Long materialId;
                                                String matStr;
                                                if (!treepath.contains(str) || str.equals(matStr = String.format("@%s@", materialId = row.getLong(this.sourceRowMeta.getFieldIndex("materialId"))))) continue;
                                                flag = true;
                                                break;
                                            }
                                        }
                                        if (flag) continue;
                                        cols.collect(row);
                                    }
                                }
                            });
                            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + (int)var34_65 + "@reportId:" + reportId + "@unRecovery", inMsgHandler);
                            rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("addPreQty", (DataType)DataType.BigDecimalType), new Field("actQty", (DataType)DataType.BigDecimalType), new Field("actAmount", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
                            DataSetX materialDsX = session.fromInput((Input)ormInput);
                            rsDataSetX = rsDataSetX.leftJoin(materialDsX).on("subMaterialId", "id").select(rsDataSetX.getRowMeta().getFieldNames(), new String[]{"baseunit", "precision"});
                            rsDataSetX = rsDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryPreConstrBillSaveFunction(rsDataSetX.getRowMeta(), crParams, userModifyMaterialIdSetMap, keyCalOrgIdValCostAccountIdMap));
                            rsDataSetX.output((Output)new IgnoreOutput());
                            session.commit(1, TimeUnit.HOURS);
                        }
                        if (var34_65 == newMatList.size() - 1) {
                            progess += 10;
                        }
                        FactCostReductTaskHelper.upateTaskRecord(taskRecordId, progess, "2");
                        FactCostReductTaskHelper.upateTaskRecordEntry(taskRecordId, FactCostReductCalcCheck.COSTREDUCT, seq, "4");
                    }
                    ++var34_65;
                }
            }
            catch (Exception e) {
                try {
                    logger.error(reportId + ":\u8ba1\u7b97\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (Throwable)e);
                    isFail = true;
                    FactCostReductTaskHelper.writeErroToTaskRecordEntry(taskRecordId, e);
                }
                catch (Throwable throwable) {
                    CostRecoveryHelper.afterCalc(isFail, crParams, checkResultId);
                    FactCostReductTaskHelper.upateTaskRecord(taskRecordId, 100, isFail ? "3" : "4");
                    long costAccountId = crParams.getCostAccountId();
                    long manuOrgId = crParams.getManuOrgId();
                    String lockStr3 = String.valueOf(costAccountId);
                    if (manuOrgId > 0L) {
                        lockStr3 = lockStr3 + manuOrgId;
                    }
                    CalcMutexHelper.releaseXMutex("reductcalc", lockStr3.hashCode());
                    String periodIsCurrent3 = crParams.getPeriodIsCurrent();
                    if (CadEmptyUtils.isEmpty(periodIsCurrent3) || !"Y".equals(periodIsCurrent3)) throw throwable;
                    CalcMutexHelper.releaseXMutex("reductcalc", costAccountId);
                    throw throwable;
                }
                CostRecoveryHelper.afterCalc(isFail, crParams, checkResultId);
                FactCostReductTaskHelper.upateTaskRecord(taskRecordId, 100, isFail ? "3" : "4");
                long costAccountId = crParams.getCostAccountId();
                long manuOrgId = crParams.getManuOrgId();
                lockStr = String.valueOf(costAccountId);
                if (manuOrgId > 0L) {
                    lockStr = lockStr + manuOrgId;
                }
                CalcMutexHelper.releaseXMutex("reductcalc", lockStr.hashCode());
                periodIsCurrent = crParams.getPeriodIsCurrent();
                if (CadEmptyUtils.isEmpty(periodIsCurrent) || !"Y".equals(periodIsCurrent)) return;
                CalcMutexHelper.releaseXMutex("reductcalc", costAccountId);
                return;
            }
        }
        CostRecoveryHelper.afterCalc(isFail, crParams, checkResultId);
        FactCostReductTaskHelper.upateTaskRecord(taskRecordId, 100, isFail ? "3" : "4");
        long costAccountId = crParams.getCostAccountId();
        long manuOrgId = crParams.getManuOrgId();
        lockStr = String.valueOf(costAccountId);
        if (manuOrgId > 0L) {
            lockStr = lockStr + manuOrgId;
        }
        CalcMutexHelper.releaseXMutex("reductcalc", lockStr.hashCode());
        periodIsCurrent = crParams.getPeriodIsCurrent();
        if (CadEmptyUtils.isEmpty(periodIsCurrent) || !"Y".equals(periodIsCurrent)) return;
        CalcMutexHelper.releaseXMutex("reductcalc", costAccountId);
        return;
    }

    private Set<String> getMaterialNumberSetByMaterialIdSet(Set<Long> allMaterialIdSet) {
        DataSet matDs = QueryServiceHelper.queryDataSet((String)"CostRec-mat", (String)"bd_material", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", allMaterialIdSet)}, null);
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : matDs) {
            result.add(row.getString("number") + "/" + row.getString("name"));
        }
        matDs.close();
        return result;
    }

    public static OrmInput getMaterialDs(Collection<Long> lvlmats) {
        return new OrmInput("CostRec-getMaterialInfo", "bd_material", "id,baseunit,baseunit.precision precision", new QFilter("id", "in", lvlmats).toArray());
    }

    private DataSetX transInProcess(CostRecoveryParams crParams, Long reportId, Long calOrgId, JobSession session, int index, DataSetX rsDataSetX, DataSet transInDataSet, String debugColName, String debugValue, IInfoMsgHandler inMsgHandler) {
        HashMap invOrgRelationMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap keyOutOrgIdValInInvMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap keyOutOrgIdValInInvOrgSetMap = Maps.newHashMapWithExpectedSize((int)16);
        DataSet nowTransInDataSet = transInDataSet.copy().filter("outPeriodId=" + crParams.getPeriodId());
        DataSet preTransInDataSet = transInDataSet.copy().filter("outPeriodId<" + crParams.getPeriodId());
        for (Row row : nowTransInDataSet.copy()) {
            Long materialId = row.getLong("materialId");
            Long materialVerId = row.getLong("materialVerId");
            Long materialAuxPropId = row.getLong("materialAuxPropId");
            Long inInvOrgId = row.getLong("transInOrgId");
            Long outInvOrgId = row.getLong("transOutOrgId");
            String inKey = inInvOrgId + "@" + materialId + "@" + materialVerId + "@" + materialAuxPropId;
            String outKey = outInvOrgId + "@" + materialId + "@" + materialVerId + "@" + materialAuxPropId;
            BigDecimal transInQty = row.getBigDecimal("transInQty");
            BigDecimal transInAmt = row.getBigDecimal("transInAmt");
            BigDecimal[] bgs = new BigDecimal[]{transInQty, transInAmt};
            Map inMap = invOrgRelationMap.computeIfAbsent(inKey, p -> Maps.newHashMapWithExpectedSize((int)16));
            inMap.put(outInvOrgId, bgs);
            Map outMap = keyOutOrgIdValInInvMap.computeIfAbsent(outKey, p -> Maps.newHashMapWithExpectedSize((int)16));
            outMap.put(inInvOrgId, bgs);
            Set inInvOrgSet = keyOutOrgIdValInInvOrgSetMap.computeIfAbsent(outKey, p -> Sets.newHashSetWithExpectedSize((int)16));
            inInvOrgSet.add(inInvOrgId);
        }
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-00000", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.groupBy(new String[]{"materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryStructMergeFunction(rsDataSetX.getRowMeta(), keyOutOrgIdValInInvOrgSetMap, false));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@trans-StructMerge", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("isLeaf", (DataType)DataType.IntegerType), new Field("isFlagEquation", (DataType)DataType.IntegerType)}, new Object[]{0, 0});
        rsDataSetX = rsDataSetX.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryFlagEquationFunction(rsDataSetX.getRowMeta(), false));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-FlagEquation", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.groupBy(new String[]{"level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd"}).reduceGroup((GroupReduceFunction)new CostRecoveryTransCalcFunction(rsDataSetX.getRowMeta(), invOrgRelationMap, false));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-11111-pre", inMsgHandler);
        }
        DataSetX transOutDataSetX = rsDataSetX.select(new String[]{"periodId", "invOrgId", "level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd", "unitQty", "amountCoeff"});
        transOutDataSetX = transOutDataSetX.addFields(new Field[]{new Field("transOutOrgId", (DataType)DataType.LongType), new Field("proTransInQty", (DataType)DataType.BigDecimalType), new Field("proTransInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{0L, BigDecimal.ZERO, BigDecimal.ZERO});
        transOutDataSetX = transOutDataSetX.groupBy(new String[]{"materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryTransStructFunction(transOutDataSetX.getRowMeta(), keyOutOrgIdValInInvMap, false));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            transOutDataSetX = DataSetXLogUtil.logDataSetX(transOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-22222", inMsgHandler);
        }
        transOutDataSetX = transOutDataSetX.addFields(new Field[]{new Field("transInQty", (DataType)DataType.BigDecimalType), new Field("transInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        HashMap fieldKey = Maps.newHashMapWithExpectedSize((int)16);
        fieldKey.put("proQtyKey", "proTransInQty");
        fieldKey.put("proAmtKey", "proTransInAmt");
        fieldKey.put("unitQtyKey", "unitQty");
        fieldKey.put("unitAmountCoeffKey", "amountCoeff");
        fieldKey.put("saveQtyKey", "transInQty");
        fieldKey.put("saveAmtKey", "transInAmt");
        transOutDataSetX = transOutDataSetX.groupBy(new String[]{"invOrgId", "transOutOrgId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryProMatAmtProcessFunction(transOutDataSetX.getRowMeta(), crParams, fieldKey));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            transOutDataSetX = DataSetXLogUtil.logDataSetX(transOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-33333", inMsgHandler);
        }
        HashSet outMatIdSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet outPerIdSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet outInvOrgIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : preTransInDataSet.copy()) {
            outMatIdSet.add(row.getLong("materialId"));
            outInvOrgIdSet.add(row.getLong("transOutOrgId"));
            outPerIdSet.add(row.getLong("getHalfHidePeriodId"));
            logger.info("\u5206\u5e03\u8c03\u5165\u5b58\u5728\u5f80\u671f\u7684\u7269\u6599\uff1a" + ((Object)outMatIdSet).toString());
        }
        QFilter preHalfprdhideFilter = new QFilter("storageorgunit.id", "in", (Object)outInvOrgIdSet);
        preHalfprdhideFilter.and("period.id", "in", (Object)outPerIdSet);
        preHalfprdhideFilter.and("material.id", "in", (Object)outMatIdSet);
        DataSet preHalfprdhideDataSet = QueryServiceHelper.queryDataSet((String)"CostRec-halfprdhide", (String)"sca_halfprdhide", (String)"storageorgunit.id as invOrgId,entryentity.level as level,entryentity.treepath as treepath,period.id as periodId,material.id as materialId,materialversion.id as materialVerId,auxprop.id as materialAuxPropId,entryentity.submaterial.id as subMaterialId,entryentity.submaterialversion.id as subMertialVerId,entryentity.submaterialauxprop.id as subMerialAuxPropId,entryentity.element.id as elementId,entryentity.subelement.id as subElementId,entryentity.isunabsorb as isUnAbsorbd,entryentity.qty as unitQty,entryentity.amountcoeff as amountCoeff", (QFilter[])preHalfprdhideFilter.toArray(), null);
        DataSet preTransOutDataSet = preHalfprdhideDataSet.join(preTransInDataSet).on("invOrgId", "transOutOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").on("periodId", "getHalfHidePeriodId").select(new String[]{"level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd", "unitQty", "amountCoeff"}, new String[]{"outPeriodId periodId", "transInOrgId invOrgId", "transOutOrgId", "transInQty proTransInQty", "transInAmt proTransInAmt"}).finish();
        if (StringUtils.isNotEmpty((String)debugValue)) {
            DataSetXLogUtil.logDataSet(preTransOutDataSet, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-preTransOutData", inMsgHandler);
        }
        DataSetX preTransOutDataSetX = session.fromInput((Input)new DataSetInput(preTransOutDataSet));
        preTransOutDataSetX = preTransOutDataSetX.addFields(new Field[]{new Field("transInQty", (DataType)DataType.BigDecimalType), new Field("transInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        preTransOutDataSetX = preTransOutDataSetX.groupBy(new String[]{"invOrgId", "transOutOrgId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryProMatAmtProcessFunction(preTransOutDataSetX.getRowMeta(), crParams, fieldKey));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            preTransOutDataSetX = DataSetXLogUtil.logDataSetX(preTransOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-preTransOutDataSetX", inMsgHandler);
        }
        transOutDataSetX = DataSetXHelper.union(transOutDataSetX, preTransOutDataSetX);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            transOutDataSetX = DataSetXLogUtil.logDataSetX(transOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-preTransOutDataSetX-merge", inMsgHandler);
        }
        DataSetX transInQtyAmtForProDsx = transOutDataSetX.groupBy(new String[]{"periodId", "invOrgId", "transOutOrgId", "materialId", "materialVerId", "materialAuxPropId"}).max("proTransInQty").max("proTransInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            transInQtyAmtForProDsx = DataSetXLogUtil.logDataSetX(transInQtyAmtForProDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-44444", inMsgHandler);
        }
        DataSetX sumGroupByTransInQtyDataSetX = transInQtyAmtForProDsx.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).sum("proTransInQty").sum("proTransInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            sumGroupByTransInQtyDataSetX = DataSetXLogUtil.logDataSetX(sumGroupByTransInQtyDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-55555", inMsgHandler);
        }
        DataSetX sumTransOutDataSetX = transOutDataSetX.groupBy(new String[]{"invOrgId", "level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd"}).sum("transInQty").sum("transInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            sumTransOutDataSetX = DataSetXLogUtil.logDataSetX(sumTransOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-66666", inMsgHandler);
        }
        DataSetX cacheProQtyDataSetX = rsDataSetX.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).max("preProQty").max("proQty");
        rsDataSetX = DataSetXHelper.unionIfRowDiff(rsDataSetX, sumTransOutDataSetX);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-77777", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.groupBy(new String[]{"invOrgId", "level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd"}).sum("preQty").sum("preAmount").sum("finQty").sum("finAmount").sum("transInQty").sum("transInAmt").sum("actQtyForFinish").sum("actAmountForFinish").sum("actQtyForTrans").sum("actAmountForTrans").sum("actQtyForPurs").sum("actAmountForPurs");
        rsDataSetX = rsDataSetX.leftJoin(cacheProQtyDataSetX).on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").select(rsDataSetX.getRowMeta().getFieldNames(), new String[]{"preProQty", "proQty"});
        rsDataSetX = rsDataSetX.leftJoin(sumGroupByTransInQtyDataSetX).on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").select(rsDataSetX.getRowMeta().getFieldNames(), new String[]{"proTransInQty", "proTransInAmt"});
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType), new Field("transOutOrgId", (DataType)DataType.LongType), new Field("periodId", (DataType)DataType.LongType)}, new Object[]{0, 0L, crParams.getPeriodId()});
        transOutDataSetX = transOutDataSetX.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType)}, new Object[]{1});
        rsDataSetX = DataSetXHelper.unionIfRowDiff(rsDataSetX, transOutDataSetX);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-88888", inMsgHandler);
        }
        transInQtyAmtForProDsx = transInQtyAmtForProDsx.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType)}, new Object[]{11});
        rsDataSetX = DataSetXHelper.unionIfRowDiff(rsDataSetX, transInQtyAmtForProDsx);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-99999", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("addPreQty", (DataType)DataType.BigDecimalType), new Field("unitQty", (DataType)DataType.BigDecimalType), new Field("amountCoeff", (DataType)DataType.BigDecimalType), new Field("proActAmt", (DataType)DataType.BigDecimalType), new Field("proActQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        return rsDataSetX;
    }

    private DataSetX pursInProcess(CostRecoveryParams crParams, Long reportId, JobSession session, int index, DataSetX rsDataSetX, DataSet purInDataSet, Map<Long, Long> keyInvOrgIdValCalOrgIdMap, String debugColName, String debugValue, IInfoMsgHandler inMsgHandler) {
        long start = System.currentTimeMillis();
        logger.info(reportId + "@" + index + "@:****\u8de8\u7ec4\u7ec7\u91c7\u8d2d  step1 -> start****");
        HashMap invOrgRelationMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap calOrgRelationMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap keyOutOrgIdValInInvMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap keyOutCalOrgIdValInCalOrgMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap keyOutCalOrgIdValInCalOrgQtyAmtMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Row row : purInDataSet.copy()) {
            Long materialId = row.getLong("materialId");
            Long materialVerId = row.getLong("materialVerId");
            Long materialAuxPropId = row.getLong("materialAuxPropId");
            Long inInvOrgId = row.getLong("invOrgId");
            Long outCalOrgId = row.getLong("salesCalOrgId");
            Long inCalOrgId = keyInvOrgIdValCalOrgIdMap.get(inInvOrgId);
            String inKey = inInvOrgId + "@" + materialId + "@" + materialVerId + "@" + materialAuxPropId;
            String outKey = outCalOrgId + "@" + materialId + "@" + materialVerId + "@" + materialAuxPropId;
            String calOrgInKey = inCalOrgId + "@" + materialId + "@" + materialVerId + "@" + materialAuxPropId;
            BigDecimal pursInQty = row.getBigDecimal("pursInQty");
            BigDecimal pursInAmt = row.getBigDecimal("pursInAmt");
            BigDecimal[] bgs = new BigDecimal[]{pursInQty, pursInAmt};
            Map inMap = invOrgRelationMap.computeIfAbsent(inKey, p -> Maps.newHashMapWithExpectedSize((int)16));
            inMap.put(outCalOrgId, bgs);
            Map calOrgInMap = calOrgRelationMap.computeIfAbsent(calOrgInKey, p -> Maps.newHashMapWithExpectedSize((int)16));
            calOrgInMap.put(outCalOrgId, bgs);
            Map outMap = keyOutOrgIdValInInvMap.computeIfAbsent(outKey, p -> Maps.newHashMapWithExpectedSize((int)16));
            outMap.put(inInvOrgId, bgs);
            Set inCalOrgSet = keyOutCalOrgIdValInCalOrgMap.computeIfAbsent(outKey, p -> Sets.newHashSetWithExpectedSize((int)16));
            inCalOrgSet.add(inCalOrgId);
            Map outQtyAmtMap = keyOutCalOrgIdValInCalOrgQtyAmtMap.computeIfAbsent(outKey, p -> Maps.newHashMapWithExpectedSize((int)16));
            BigDecimal[] tmpBgs = outQtyAmtMap.computeIfAbsent(inCalOrgId, p -> new BigDecimal[2]);
            tmpBgs[0] = BigDecimalUtils.getBigDecimalOrZero(tmpBgs[0]).add(pursInQty);
            tmpBgs[1] = BigDecimalUtils.getBigDecimalOrZero(tmpBgs[1]).add(pursInAmt);
            outQtyAmtMap.put(inCalOrgId, tmpBgs);
        }
        DataSetX calOrgIdRsDsx = rsDataSetX;
        DataSetX proQtyRsDsx = calOrgIdRsDsx.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).max("preProQty").max("proQty").max("proTransInQty").max("proTransInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            proQtyRsDsx = DataSetXLogUtil.logDataSetX(proQtyRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-aaaaa", inMsgHandler);
        }
        proQtyRsDsx = proQtyRsDsx.groupBy(new String[]{"calOrgId", "materialId", "materialVerId", "materialAuxPropId"}).sum("preProQty").sum("proQty").sum("proTransInQty").sum("proTransInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            proQtyRsDsx = DataSetXLogUtil.logDataSetX(proQtyRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-aaaaa-1", inMsgHandler);
        }
        calOrgIdRsDsx = calOrgIdRsDsx.groupBy(new String[]{"calOrgId", "level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd"}).sum("preQty").sum("preAmount").sum("finQty").sum("finAmount").sum("transInQty").sum("transInAmt").sum("actQtyForFinish").sum("actAmountForFinish").sum("actQtyForTrans").sum("actAmountForTrans").sum("actQtyForPurs").sum("actAmountForPurs");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            calOrgIdRsDsx = DataSetXLogUtil.logDataSetX(calOrgIdRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-bbbbb-0", inMsgHandler);
        }
        calOrgIdRsDsx = calOrgIdRsDsx.join(proQtyRsDsx).on("calOrgId", "calOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").select(calOrgIdRsDsx.getRowMeta().getFieldNames(), new String[]{"preProQty", "proQty", "proTransInQty", "proTransInAmt"});
        if (StringUtils.isNotEmpty((String)debugValue)) {
            calOrgIdRsDsx = DataSetXLogUtil.logDataSetX(calOrgIdRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-bbbbb-1", inMsgHandler);
        }
        calOrgIdRsDsx = calOrgIdRsDsx.addFields(new Field[]{new Field("addPreQty", (DataType)DataType.BigDecimalType), new Field("unitQty", (DataType)DataType.BigDecimalType), new Field("amountCoeff", (DataType)DataType.BigDecimalType), new Field("proActAmt", (DataType)DataType.BigDecimalType), new Field("proActQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        calOrgIdRsDsx = calOrgIdRsDsx.groupBy(new String[]{"calOrgId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryCalculateForTransSumFunction(calOrgIdRsDsx.getRowMeta(), crParams));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            calOrgIdRsDsx = DataSetXLogUtil.logDataSetX(calOrgIdRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-ccccc-CalculateForTransSum", inMsgHandler);
        }
        calOrgIdRsDsx = calOrgIdRsDsx.groupBy(new String[]{"materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryStructMergeFunction(calOrgIdRsDsx.getRowMeta(), keyOutCalOrgIdValInCalOrgMap, true));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            calOrgIdRsDsx = DataSetXLogUtil.logDataSetX(calOrgIdRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-ccccc-StructMerge", inMsgHandler);
        }
        calOrgIdRsDsx = calOrgIdRsDsx.addFields(new Field[]{new Field("isLeaf", (DataType)DataType.IntegerType), new Field("isFlagEquation", (DataType)DataType.IntegerType)}, new Object[]{0, 1});
        calOrgIdRsDsx = calOrgIdRsDsx.groupBy(new String[]{"calOrgId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryFlagEquationFunction(calOrgIdRsDsx.getRowMeta(), true));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            calOrgIdRsDsx = DataSetXLogUtil.logDataSetX(calOrgIdRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-ccccc-FlagEquation", inMsgHandler);
        }
        calOrgIdRsDsx = calOrgIdRsDsx.groupBy(new String[]{"level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd"}).reduceGroup((GroupReduceFunction)new CostRecoveryTransCalcFunction(calOrgIdRsDsx.getRowMeta(), calOrgRelationMap, true));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            calOrgIdRsDsx = DataSetXLogUtil.logDataSetX(calOrgIdRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-ddddd-pre", inMsgHandler);
        }
        DataSetX salesOutDataSetX = calOrgIdRsDsx.select(new String[]{"calOrgId", "level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd", "unitQty", "amountCoeff"});
        salesOutDataSetX = salesOutDataSetX.addFields(new Field[]{new Field("salesCalOrgId", (DataType)DataType.LongType), new Field("proPursInQty", (DataType)DataType.BigDecimalType), new Field("proPursInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{0L, BigDecimal.ZERO, BigDecimal.ZERO});
        salesOutDataSetX = salesOutDataSetX.groupBy(new String[]{"materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryTransStructFunction(salesOutDataSetX.getRowMeta(), keyOutCalOrgIdValInCalOrgQtyAmtMap, true));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            salesOutDataSetX = DataSetXLogUtil.logDataSetX(salesOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-eeeee-pre", inMsgHandler);
        }
        DataSetX pursDataSetX = session.fromInput((Input)new DataSetInput(purInDataSet));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            pursDataSetX = DataSetXLogUtil.logDataSetX(pursDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-eeeee-pre-2", inMsgHandler);
        }
        salesOutDataSetX = salesOutDataSetX.join(pursDataSetX).on("calOrgId", "calOrgId").on("salesCalOrgId", "salesCalOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").select(new String[]{"level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd", "unitQty", "amountCoeff"}, new String[]{"calOrgId", "invOrgId", "salesCalOrgId", "pursInQty proPursInQty", "pursInAmt proPursInAmt"});
        if (StringUtils.isNotEmpty((String)debugValue)) {
            salesOutDataSetX = DataSetXLogUtil.logDataSetX(salesOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-eeeee-final", inMsgHandler);
        }
        salesOutDataSetX = salesOutDataSetX.addFields(new Field[]{new Field("pursInQty", (DataType)DataType.BigDecimalType), new Field("pursInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        HashMap fieldKey = Maps.newHashMapWithExpectedSize((int)16);
        fieldKey.put("proQtyKey", "proPursInQty");
        fieldKey.put("proAmtKey", "proPursInAmt");
        fieldKey.put("unitQtyKey", "unitQty");
        fieldKey.put("unitAmountCoeffKey", "amountCoeff");
        fieldKey.put("saveQtyKey", "pursInQty");
        fieldKey.put("saveAmtKey", "pursInAmt");
        salesOutDataSetX = salesOutDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "salesCalOrgId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryProMatAmtProcessFunction(salesOutDataSetX.getRowMeta(), crParams, fieldKey));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            salesOutDataSetX = DataSetXLogUtil.logDataSetX(salesOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-fffff", inMsgHandler);
        }
        DataSetX pursInQtyAmtForProDsx = salesOutDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "salesCalOrgId", "materialId", "materialVerId", "materialAuxPropId"}).max("proPursInQty").max("proPursInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            pursInQtyAmtForProDsx = DataSetXLogUtil.logDataSetX(pursInQtyAmtForProDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-ggggg", inMsgHandler);
        }
        DataSetX sumGroupByPursInQtyDataSetX = pursInQtyAmtForProDsx.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).sum("proPursInQty").sum("proPursInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            sumGroupByPursInQtyDataSetX = DataSetXLogUtil.logDataSetX(sumGroupByPursInQtyDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-hhhhh", inMsgHandler);
        }
        DataSetX sumSalesOutDataSetX = salesOutDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd"}).sum("pursInQty").sum("pursInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            sumSalesOutDataSetX = DataSetXLogUtil.logDataSetX(sumSalesOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-iiiii", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("pursInQty", (DataType)DataType.BigDecimalType), new Field("pursInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX cacheProQtyDataSetX = rsDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).max("preProQty").max("proQty").max("proTransInQty");
        rsDataSetX = DataSetXHelper.unionIfRowDiff(rsDataSetX, sumSalesOutDataSetX);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-jjjjj", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "isUnAbsorbd"}).sum("preQty").sum("preAmount").sum("finQty").sum("finAmount").sum("transInQty").sum("transInAmt").sum("pursInQty").sum("pursInAmt").sum("actQtyForFinish").sum("actAmountForFinish").sum("actQtyForTrans").sum("actAmountForTrans").sum("actQtyForPurs").sum("actAmountForPurs");
        rsDataSetX = rsDataSetX.leftJoin(cacheProQtyDataSetX).on("calOrgId", "calOrgId").on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").select(rsDataSetX.getRowMeta().getFieldNames(), new String[]{"preProQty", "proQty", "proTransInQty"});
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-kkkkk", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.leftJoin(sumGroupByPursInQtyDataSetX).on("calOrgId", "calOrgId").on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").select(rsDataSetX.getRowMeta().getFieldNames(), new String[]{"proPursInQty", "proPursInAmt"});
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-lllll", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType)}, new Object[]{0});
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("salesCalOrgId", (DataType)DataType.LongType)}, new Object[]{0L});
        salesOutDataSetX = salesOutDataSetX.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType)}, new Object[]{2});
        rsDataSetX = DataSetXHelper.unionIfRowDiff(rsDataSetX, salesOutDataSetX);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-mmmmm", inMsgHandler);
        }
        pursInQtyAmtForProDsx = pursInQtyAmtForProDsx.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType)}, new Object[]{22});
        rsDataSetX = DataSetXHelper.unionIfRowDiff(rsDataSetX, pursInQtyAmtForProDsx);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-nnnnn", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("addPreQty", (DataType)DataType.BigDecimalType), new Field("unitQty", (DataType)DataType.BigDecimalType), new Field("amountCoeff", (DataType)DataType.BigDecimalType), new Field("proActAmt", (DataType)DataType.BigDecimalType), new Field("proActQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        rsDataSetX = rsDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).reduceGroup((GroupReduceFunction)new CostRecoveryCalculateForPursFunction(rsDataSetX.getRowMeta(), crParams));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-xxxxx", inMsgHandler);
        }
        logger.info(reportId + "@" + index + "@:****\u8de8\u7ec4\u7ec7\u91c7\u8d2d  step1 -> end****" + (System.currentTimeMillis() - start));
        return rsDataSetX;
    }

    private DataSet buildPurInDataSet(CostRecoveryParams crParams, Set<Long> allMaterialIdSet) {
        QFilter supFilter = new QFilter("internal_company.id", "in", crParams.getRelationCalOrgIds());
        DataSet supIdDs = QueryServiceHelper.queryDataSet((String)"CostRec-supplier", (String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{supFilter}, null);
        HashSet supIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : supIdDs) {
            supIdSet.add(row.getLong("id"));
        }
        QFilter calFilter = new QFilter("calorg", "in", crParams.getRelationCalOrgIds());
        calFilter.and("costaccount", "in", crParams.getRelationCostAccountIds());
        calFilter.and("period", "=", (Object)crParams.getPeriodId());
        calFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
        calFilter.and("issplitcreate", "=", (Object)false);
        calFilter.and("entry.material", "in", allMaterialIdSet);
        QFilter pursFilter = new QFilter("bizentityobject", "=", (Object)"im_purinbill");
        pursFilter.and(new QFilter("supplier.id", "in", (Object)supIdSet));
        String commonFilter = "costaccount.id as costaccountId,calorg.id as calOrgId,period.id as periodId,calBillType,bizentityobject,entry.material.id as materialId,0L as materialVerId,0L as materialAuxPropId";
        DataSet transInCostRecordDs = QueryServiceHelper.queryDataSet((String)ALGOKEY_PRE, (String)"cal_costrecord_subentity", (String)(commonFilter + ",storageorgunit.id as invOrgId,entry.baseqty as pursInQty,entry.actualcost as pursInAmt,'P' as transType,supplier.internal_company.id as salesCalOrgId,bizbillid as bizBillId"), (QFilter[])new QFilter[]{calFilter, pursFilter}, null);
        transInCostRecordDs = transInCostRecordDs.groupBy(new String[]{"calOrgId", "periodId", "materialId", "materialVerId", "materialAuxPropId", "invOrgId", "salesCalOrgId"}).sum("pursInQty").sum("pursInAmt").finish();
        return transInCostRecordDs;
    }
}

