/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algo.util.Tuple2;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.enums.AcaMutexEnum;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.utils.AcaMutexHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.sca.algox.constants.FactCostReductCalcCheck;
import kd.macc.sca.algox.costrec.BopHalfprdStructureEngineV2;
import kd.macc.sca.algox.costrec.CostRecCalcHelper;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.costrec.DebugInfoMsgHandler;
import kd.macc.sca.algox.costrec.function.CostRecoveryCalculateForPursFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryCalculateForTransInFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryCalculateForTransSumFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryCalculateFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryFlagEquationFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryNotRecFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryPreConstrBillSaveFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryProMatAmtProcessFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryStructMergeFunction;
import kd.macc.sca.algox.costrec.function.CostRecoverySubMatAmtProcessFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryTransCalcFunction;
import kd.macc.sca.algox.costrec.function.CostRecoveryTransStructFunction;
import kd.macc.sca.algox.costrec.input.AcaCostRecDataInputService;
import kd.macc.sca.algox.costrec.input.CostRecBaseDataInputService;
import kd.macc.sca.algox.costrec.input.CostRecDataInputService;
import kd.macc.sca.algox.costrec.input.ScaCostRecDataInputService;
import kd.macc.sca.algox.enums.FactCostReductItemEnum;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CostAccountHelper;
import kd.macc.sca.algox.utils.CostRecoveryHelper;
import kd.macc.sca.algox.utils.DataSetHelper;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.algox.utils.DataSetXLogUtil;
import kd.macc.sca.algox.utils.FactCostReductTaskHelper;
import kd.macc.sca.algox.utils.IInfoMsgHandler;
import kd.macc.sca.algox.utils.ReductCheckHelper;
import kd.macc.sca.algox.utils.ScaDebugHelper;
import kd.macc.sca.algox.wip.CalcMutexHelper;

public class CostRecoveryV2Service {
    private static final String ALGOKEY_PRE = "CostRec-";
    private static final Log logger = LogFactory.getLog(CostRecoveryV2Service.class);
    private static final String[] unionSelect = new String[]{"invOrgId", "level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd", "preQty", "preAmount", "finQty", "finAmount", "preProQty", "proQty", "amountCoeff"};
    private static final String[] calOrgUnionFields = new String[]{"calOrgId", "invOrgId", "periodId", "level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd", "preQty", "preAmount", "finQty", "finAmount", "transInQty", "transInAmt", "actQtyForFinish", "actAmountForFinish", "actQtyForTrans", "actAmountForTrans", "actQtyForPurs", "actAmountForPurs", "preProQty", "proQty", "proTransInQty", "proTransInAmt", "subEntryType", "transOutOrgId"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void costRecovery(CostRecoveryParams crParams) {
        boolean isFail = false;
        try {
            this.init(crParams);
            this.costRecoveryCalc(crParams);
        }
        catch (Exception e) {
            try {
                logger.error(crParams.getCalcReportId() + ":\u6210\u672c\u8fd8\u539f\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                isFail = true;
                FactCostReductTaskHelper.writeErroToTaskRecordEntry(crParams.getTaskRecordId(), e);
            }
            catch (Throwable throwable) {
                CostRecoveryHelper.afterCalc(isFail, crParams, crParams.getCheckResultId());
                FactCostReductTaskHelper.upateTaskRecord(crParams.getTaskRecordId(), 100, isFail ? "3" : "4");
                long costAccountId = crParams.getCostAccountId();
                long manuOrgId = crParams.getManuOrgId();
                String lockStr = String.valueOf(costAccountId);
                if (manuOrgId > 0L) {
                    lockStr = lockStr + manuOrgId;
                }
                CalcMutexHelper.releaseXMutex("reductcalc", lockStr.hashCode());
                AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.CALC_COSTREDC, (long)costAccountId);
                String periodIsCurrent = crParams.getPeriodIsCurrent();
                if (!CadEmptyUtils.isEmpty(periodIsCurrent) && "Y".equals(periodIsCurrent)) {
                    CalcMutexHelper.releaseXMutex("reductcalc", costAccountId);
                }
                throw throwable;
            }
            CostRecoveryHelper.afterCalc(isFail, crParams, crParams.getCheckResultId());
            FactCostReductTaskHelper.upateTaskRecord(crParams.getTaskRecordId(), 100, isFail ? "3" : "4");
            long costAccountId = crParams.getCostAccountId();
            long manuOrgId = crParams.getManuOrgId();
            String lockStr = String.valueOf(costAccountId);
            if (manuOrgId > 0L) {
                lockStr = lockStr + manuOrgId;
            }
            CalcMutexHelper.releaseXMutex("reductcalc", lockStr.hashCode());
            AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.CALC_COSTREDC, (long)costAccountId);
            String periodIsCurrent = crParams.getPeriodIsCurrent();
            if (!CadEmptyUtils.isEmpty(periodIsCurrent) && "Y".equals(periodIsCurrent)) {
                CalcMutexHelper.releaseXMutex("reductcalc", costAccountId);
            }
        }
        CostRecoveryHelper.afterCalc(isFail, crParams, crParams.getCheckResultId());
        FactCostReductTaskHelper.upateTaskRecord(crParams.getTaskRecordId(), 100, isFail ? "3" : "4");
        long costAccountId = crParams.getCostAccountId();
        long manuOrgId = crParams.getManuOrgId();
        String lockStr = String.valueOf(costAccountId);
        if (manuOrgId > 0L) {
            lockStr = lockStr + manuOrgId;
        }
        CalcMutexHelper.releaseXMutex("reductcalc", lockStr.hashCode());
        AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.CALC_COSTREDC, (long)costAccountId);
        String periodIsCurrent = crParams.getPeriodIsCurrent();
        if (!CadEmptyUtils.isEmpty(periodIsCurrent) && "Y".equals(periodIsCurrent)) {
            CalcMutexHelper.releaseXMutex("reductcalc", costAccountId);
        }
    }

    private void costRecoveryCalc(CostRecoveryParams crParams) {
        boolean checkFlag = this.costRecCheck(crParams);
        if (!checkFlag) {
            return;
        }
        CostRecDataInputService dataInputService = this.getDataInputService(crParams);
        CostRecoveryHelper.setDefaultElementId(crParams);
        DynamicObject[] costaccountColl = CostRecoveryHelper.setCommonAttribute(crParams);
        this.clearData(crParams, null);
        this.reCalcReductParam(crParams);
        ArrayList<List<String>> nestMatGroupsIds = new ArrayList<List<String>>();
        List<Set<String>> matList = this.getMatLvlList(crParams, dataInputService, nestMatGroupsIds);
        if (CollectionUtils.isEmpty(matList)) {
            return;
        }
        this.setOrgParam(crParams, costaccountColl);
        this.costRecCalc(crParams, dataInputService, matList, nestMatGroupsIds, costaccountColl);
    }

    private void setOrgParam(CostRecoveryParams crParams, DynamicObject[] costaccountColl) {
        HashMap keyCalOrgIdValCostAccountIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject costaccountDyo : costaccountColl) {
            keyCalOrgIdValCostAccountIdMap.put(costaccountDyo.getLong("calorg.id"), costaccountDyo.getLong("id"));
        }
        crParams.setKeyCalOrgIdValCostAccountIdMap(keyCalOrgIdValCostAccountIdMap);
        HashMap keyInvOrgIdValCalOrgIdMap = Maps.newHashMapWithExpectedSize((int)16);
        if (crParams.getCalRange() != null && crParams.getCalRange().indexOf("PURINBILL") > -1) {
            for (Long calOrgId : crParams.getRelationCalOrgIds()) {
                List invOrgIdList = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)calOrgId, (boolean)true);
                for (Long invOrgId : invOrgIdList) {
                    keyInvOrgIdValCalOrgIdMap.put(invOrgId, calOrgId);
                }
            }
        }
        crParams.setKeyInvOrgIdValCalOrgIdMap(keyInvOrgIdValCalOrgIdMap);
    }

    private void costRecCalc(CostRecoveryParams crParams, CostRecDataInputService dataInputService, List<Set<String>> matList, List<List<String>> nestMatGroupsIds, DynamicObject[] costaccountColl) {
        int progess = (int)Math.floor(57.0 / (double)(matList.size() + 1));
        HashMap unRecoveryMaterialIdMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap unRecoverySubMaterialIdParternMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap<String, Set<String>> matQueryLastMap = new HashMap<String, Set<String>>(10);
        this.buildMatNotRecMap(crParams, costaccountColl, unRecoveryMaterialIdMap, unRecoverySubMaterialIdParternMap, matQueryLastMap);
        String lvlMatMsg = ResManager.loadKDString((String)"\u7b2c%s\u5c42\u7269\u6599", (String)"CostRecoveryV2Service_0", (String)"macc-sca-algox", (Object[])new Object[0]);
        OrmInput materialDs = CostRecoveryV2Service.getMaterialDs(matList, nestMatGroupsIds);
        boolean costRecNestTwoCalc = "1".equals(CadBgParamUtils.getCadBgParamForString((String)"costRecNestTwoCalc", (String)"0"));
        int costRecLevelBatch = CadBgParamUtils.getCadParamForInt((String)"costRecLevelBatch", (int)1);
        for (int i = 0; i < matList.size(); ++i) {
            Set<String> materialIdSet = matList.get(i);
            ArrayList<Set<String>> curNestGroupIdList = new ArrayList<Set<String>>();
            materialIdSet = this.getLvlNestGroupMatList(materialIdSet, nestMatGroupsIds, curNestGroupIdList);
            Set<String> nestMatIds = this.getNestGroupMats(curNestGroupIdList);
            StringBuilder tipMsg = this.getReportRowTipMsg(materialIdSet, curNestGroupIdList, crParams.getCalcKeys());
            String curItem = String.format(lvlMatMsg, i + 1) + FactCostReductItemEnum.getName(FactCostReductItemEnum.COSTREDUCT.getValue());
            int seq = FactCostReductTaskHelper.saveTaskRecordEntry(crParams.getTaskRecordId(), FactCostReductCalcCheck.COSTREDUCT, curItem, "2", tipMsg.toString());
            DebugInfoMsgHandler inMsgHandler = new DebugInfoMsgHandler(crParams.getTaskRecordId(), seq);
            int productCount = materialIdSet.size();
            logger.info("{}:****setup {},productCount {}****", new Object[]{crParams.getCalcReportId(), i, productCount});
            CostRecoveryHelper.logInfoIdSet(logger, String.format("%s:materialRange %s", crParams.getCalcReportId(), i), materialIdSet);
            List<Set<String>> batchList = this.getBatchList(materialIdSet, costRecLevelBatch);
            for (Set<String> batchMaterial : batchList) {
                ArrayList dataSetList = Lists.newArrayList();
                for (DynamicObject costaccountDyo : costaccountColl) {
                    DataSet ds = this.costRecAccountCalc(dataInputService, crParams, costaccountDyo, batchMaterial, curNestGroupIdList, i, inMsgHandler, costRecNestTwoCalc, matQueryLastMap);
                    if (ds == null || ds.isEmpty()) continue;
                    dataSetList.add(ds);
                }
                this.costRecPurAndSave(crParams, unRecoveryMaterialIdMap, unRecoverySubMaterialIdParternMap, batchMaterial, this.getRsDataSet(dataSetList), materialDs, inMsgHandler, i, dataInputService);
            }
            if (!nestMatIds.isEmpty() && costRecNestTwoCalc) {
                ArrayList dataSetList = Lists.newArrayList();
                for (DynamicObject costaccountDyo : costaccountColl) {
                    DataSet ds = this.costRecAccountCalc(dataInputService, crParams, costaccountDyo, nestMatIds, curNestGroupIdList, i, inMsgHandler, costRecNestTwoCalc, matQueryLastMap);
                    if (ds == null || ds.isEmpty()) continue;
                    dataSetList.add(ds);
                }
                this.clearData(crParams, nestMatIds);
                this.costRecPurAndSave(crParams, unRecoveryMaterialIdMap, unRecoverySubMaterialIdParternMap, nestMatIds, this.getRsDataSet(dataSetList), materialDs, inMsgHandler, i, dataInputService);
            }
            if (crParams.isCalcKeycol()) {
                CostRecCalcHelper.updatePrdStructCalcKeycolInfo(crParams, materialIdSet, crParams.getCalcKeys());
            }
            if (i == matList.size() - 1) {
                progess += 10;
            }
            FactCostReductTaskHelper.upateTaskRecord(crParams.getTaskRecordId(), progess, "2");
            FactCostReductTaskHelper.upateTaskRecordEntry(crParams.getTaskRecordId(), FactCostReductCalcCheck.COSTREDUCT, seq, "4");
        }
    }

    private List<Set<String>> getBatchList(Set<String> materialSet, int batch) {
        ArrayList<Set<String>> batchList = new ArrayList<Set<String>>(10);
        if (batch <= 1) {
            batchList.add(materialSet);
        } else {
            int batchSize = materialSet.size() / batch;
            if (batchSize <= 1) {
                batchList.add(materialSet);
            } else {
                List splitList = Lists.partition(new ArrayList<String>(materialSet), (int)batchSize);
                for (int i = 0; i < splitList.size(); ++i) {
                    if (i == batch) {
                        ((Set)batchList.get(i - 1)).addAll((Collection)splitList.get(i));
                        continue;
                    }
                    HashSet mSet = new HashSet((Collection)splitList.get(i));
                    batchList.add(mSet);
                }
            }
        }
        return batchList;
    }

    private StringBuilder getReportRowTipMsg(Set<String> materialIdSet, List<Set<String>> curNestGroupIdList, Set<String> calcKeys) {
        HashSet<Long> materialIds = new HashSet<Long>(10);
        HashSet<Long> calckeyIds = new HashSet<Long>(10);
        CostRecCalcHelper.getMaterialIdFromKey(materialIdSet, materialIds, calckeyIds);
        Map<Long, String> curCalMatNumbers = this.getMateralMap(materialIds);
        Map<Long, String> keyColNameMap = null;
        if (!calcKeys.isEmpty()) {
            keyColNameMap = CostRecCalcHelper.getKeyColNameMap(calckeyIds, calcKeys);
        }
        StringBuilder tipMsg = new StringBuilder();
        if (!calcKeys.isEmpty()) {
            tipMsg.append("calcKeys:material");
            for (String string : calcKeys) {
                tipMsg.append(",").append(string);
            }
            tipMsg.append("\n");
        }
        if (!CadEmptyUtils.isEmpty(curNestGroupIdList)) {
            tipMsg.append(ResManager.loadKDString((String)"\u672c\u5c42\u5d4c\u5957\u7ec4\uff1a", (String)"CostRecoveryV2Service_6", (String)"macc-sca-algox", (Object[])new Object[0]));
            tipMsg.append("\n");
            for (Set set : curNestGroupIdList) {
                int i = 0;
                tipMsg.append("[");
                for (String mat : set) {
                    if (i != 0) {
                        tipMsg.append(",");
                    }
                    Tuple2<Long, Long> materialTuple = CostRecCalcHelper.getMaterialKeyId(mat);
                    tipMsg.append(curCalMatNumbers.get(materialTuple.t1) == null ? materialTuple.t1 : curCalMatNumbers.get(materialTuple.t1));
                    if (keyColNameMap != null && keyColNameMap.containsKey(materialTuple.t2)) {
                        tipMsg.append(keyColNameMap.get(materialTuple.t2));
                    }
                    ++i;
                }
                tipMsg.append("]\n");
            }
        }
        tipMsg.append(ResManager.loadKDString((String)"\u672c\u5c42\u8ba1\u7b97\u7269\u6599\u7f16\u7801\u8303\u56f4\uff1a", (String)"CostRecoveryV2Service_1", (String)"macc-sca-algox", (Object[])new Object[0]));
        tipMsg.append("\n");
        for (String string : materialIdSet) {
            Tuple2<Long, Long> materialTuple = CostRecCalcHelper.getMaterialKeyId(string);
            tipMsg.append(curCalMatNumbers.get(materialTuple.t1) == null ? materialTuple.t1 : curCalMatNumbers.get(materialTuple.t1));
            if (keyColNameMap != null && keyColNameMap.containsKey(materialTuple.t2)) {
                tipMsg.append(keyColNameMap.get(materialTuple.t2));
            }
            tipMsg.append(",");
        }
        return tipMsg;
    }

    private Set<String> getNestGroupMats(List<Set<String>> curNestGroupIdList) {
        HashSet nestGroupMatIds = Sets.newHashSetWithExpectedSize((int)10);
        for (Set<String> matIds : curNestGroupIdList) {
            nestGroupMatIds.addAll(matIds);
        }
        return nestGroupMatIds;
    }

    private Set<String> getLvlNestGroupMatList(Set<String> lvlmats, List<List<String>> nestMatGroupsIds, List<Set<String>> curNestGroupIdList) {
        if (nestMatGroupsIds == null || nestMatGroupsIds.isEmpty()) {
            return lvlmats;
        }
        for (List<String> nestGroup : nestMatGroupsIds) {
            boolean isNeedAdd = false;
            for (String matId : nestGroup) {
                if (!lvlmats.contains(matId)) continue;
                isNeedAdd = true;
                break;
            }
            if (!isNeedAdd) continue;
            lvlmats.addAll(nestGroup);
            curNestGroupIdList.add(new HashSet<String>(nestGroup));
        }
        return lvlmats;
    }

    public static OrmInput getMaterialDs(List<Set<String>> matList, List<List<String>> nestMatGroupsIds) {
        HashSet allMatIds = Sets.newHashSet();
        for (Set<String> set : matList) {
            for (String mat : set) {
                allMatIds.add(Long.parseLong(mat.split("-")[0]));
            }
        }
        if (CadEmptyUtils.isEmpty(nestMatGroupsIds)) {
            for (List list : nestMatGroupsIds) {
                for (String mat : list) {
                    allMatIds.add(Long.parseLong(mat.split("-")[0]));
                }
            }
        }
        return new OrmInput("CostRec-getMaterialInfo", "bd_material", "id,baseunit,baseunit.precision precision", new QFilter("id", "in", (Object)allMatIds).toArray());
    }

    private DataSet getRsDataSet(List<DataSet> dataSetList) {
        DataSet rsDataSet = null;
        for (int j = 0; j < dataSetList.size(); ++j) {
            rsDataSet = j == 0 ? dataSetList.get(j).select(calOrgUnionFields) : DataSetHelper.union(rsDataSet, dataSetList.get(j));
        }
        return rsDataSet;
    }

    private void costRecPurAndSave(CostRecoveryParams crParams, Map<String, Set<Long>> unRecoveryMaterialIdMap, Map<String, Set<String>> unRecoverySubMaterialIdParternMap, Set<String> materialIdSet, DataSet rsDataSet, OrmInput materialDs, IInfoMsgHandler inMsgHandler, int i, CostRecDataInputService dataInputService) {
        if (rsDataSet == null || rsDataSet.isEmpty()) {
            return;
        }
        JobSession session = AlgoX.createSession((String)"CostRec-purAndSave");
        DataSetX rsDataSetX = session.fromInput((Input)new DataSetInput(rsDataSet));
        DataSetX materialDsX = session.fromInput((Input)materialDs);
        if (crParams.getCalRange() != null && crParams.getCalRange().indexOf("PURINBILL") > -1) {
            DataSetX otherSubEntryTypeDsx = rsDataSetX.filter("subEntryType>0");
            otherSubEntryTypeDsx = otherSubEntryTypeDsx.addFields(new Field[]{new Field("pursInQty", (DataType)DataType.BigDecimalType), new Field("pursInAmt", (DataType)DataType.BigDecimalType), new Field("proPursInQty", (DataType)DataType.BigDecimalType), new Field("proPursInAmt", (DataType)DataType.BigDecimalType), new Field("salesCalOrgId", (DataType)DataType.LongType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0L});
            rsDataSetX = rsDataSetX.filter("subEntryType=0");
            DataSet purInDataSet = dataInputService.buildPurInDataSet(materialIdSet);
            if (!purInDataSet.isEmpty()) {
                rsDataSetX = this.pursInProcess(crParams, crParams.getCalcReportId(), session, i, rsDataSetX, purInDataSet, crParams.getKeyInvOrgIdValCalOrgIdMap(), crParams.getDebugColName(), crParams.getDebugColValue(), inMsgHandler);
            }
            rsDataSetX = DataSetXHelper.unionIfRowDiff(otherSubEntryTypeDsx, rsDataSetX);
        } else {
            rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("pursInQty", (DataType)DataType.BigDecimalType), new Field("pursInAmt", (DataType)DataType.BigDecimalType), new Field("proPursInQty", (DataType)DataType.BigDecimalType), new Field("proPursInAmt", (DataType)DataType.BigDecimalType), new Field("salesCalOrgId", (DataType)DataType.LongType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0L});
        }
        Map<Long, Set<String>> userModifyMaterialIdSetMap = CostRecoveryHelper.getModifyMaterialIdSet(crParams, materialIdSet);
        if (!unRecoveryMaterialIdMap.isEmpty() || !unRecoverySubMaterialIdParternMap.isEmpty()) {
            rsDataSetX = rsDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryNotRecFunction(unRecoveryMaterialIdMap, unRecoverySubMaterialIdParternMap));
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, crParams.getDebugColName(), crParams.getDebugColValue(), "CostRecoveryNotRec-after:", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("addPreQty", (DataType)DataType.BigDecimalType), new Field("actQty", (DataType)DataType.BigDecimalType), new Field("actAmount", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        rsDataSetX = rsDataSetX.leftJoin(materialDsX).on("subMaterialId", "id").select(rsDataSetX.getRowMeta().getFieldNames(), new String[]{"baseunit", "precision"});
        rsDataSetX = rsDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryPreConstrBillSaveFunction(rsDataSetX.getRowMeta(), crParams, userModifyMaterialIdSetMap, crParams.getKeyCalOrgIdValCostAccountIdMap()));
        rsDataSetX.output((Output)new IgnoreOutput());
        session.commit(2, TimeUnit.HOURS);
    }

    private DataSet costRecAccountCalc(CostRecDataInputService dataInputService, CostRecoveryParams crParams, DynamicObject costaccountDyo, Set<String> materialIdSet, List<Set<String>> curNestGroupIdList, int i, IInfoMsgHandler inMsgHandler, boolean costRecNestTwoCalc, Map<String, Set<String>> matQueryLastMap) {
        DataSet transInDataSet;
        Long costaccountId = costaccountDyo.getLong("id");
        Long calOrgId = costaccountDyo.getLong("calorg.id");
        DataSet finishDataSet = dataInputService.buildFinishDataSet(calOrgId, costaccountId, materialIdSet, inMsgHandler);
        DataSetXLogUtil.logDataSet(finishDataSet, crParams.getDebugColName(), crParams.getDebugColValue(), ResManager.loadKDString((String)"\u5b8c\u5de5\u53d6\u6570\uff1a", (String)"CostRecoveryV2Service_2", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
        finishDataSet = finishDataSet.filter("!(finishQty=0 and finishAmount=0)");
        DataSet subMaterialDataSet = finishDataSet.copy().filter("isUnAbsorbd='A' and subElementType ='001'").select("materialId,calckeycolId,subMaterialId,subCalckeycolId").distinct();
        DataSetXLogUtil.logDataSet(subMaterialDataSet, crParams.getDebugColName(), crParams.getDebugColValue(), ResManager.loadKDString((String)"\u5b8c\u5de5\u5b50\u9879\u7269\u6599\uff1a", (String)"CostRecoveryV2Service_3", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
        HashSet subMaterialIdSet = Sets.newHashSet();
        HashSet reWorkSubMaterialIdSet = Sets.newHashSet();
        if (costRecNestTwoCalc) {
            for (Row row : subMaterialDataSet) {
                subMaterialIdSet.add(CostRecCalcHelper.getKeyIdStr(row.getLong("subMaterialId"), row.getLong("subCalckeycolId")));
            }
        } else {
            for (Row row : subMaterialDataSet) {
                String materialKey = CostRecCalcHelper.getKeyIdStr(row.getLong("materialId"), row.getLong("calckeycolId"));
                String subMaterialKey = CostRecCalcHelper.getKeyIdStr(row.getLong("subMaterialId"), row.getLong("subCalckeycolId"));
                if (subMaterialKey.equals(materialKey) || CostRecCalcHelper.isNestMat(curNestGroupIdList, materialKey, subMaterialKey)) {
                    reWorkSubMaterialIdSet.add(subMaterialKey);
                    continue;
                }
                subMaterialIdSet.add(subMaterialKey);
            }
        }
        DataSet tmpFinishDataSet = finishDataSet.copy().filter("isUnAbsorbd='A' and subElementType ='001'").groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "isUnAbsorbd"}).sum("finishQty").sum("finishAmount").max("productQty").finish();
        DataSet preConstrDataSet = dataInputService.buildPreConstrDataSet(calOrgId, costaccountId, crParams.getNextPeriodId(), subMaterialIdSet, matQueryLastMap);
        if (!costRecNestTwoCalc && !reWorkSubMaterialIdSet.isEmpty()) {
            DataSet reWorkPreConstrDataSet = dataInputService.buildPreConstrDataSet(calOrgId, costaccountId, crParams.getPeriodId(), reWorkSubMaterialIdSet);
            preConstrDataSet = preConstrDataSet.union(reWorkPreConstrDataSet);
        }
        DataSet subPreConstrDataSet = preConstrDataSet.leftJoin(tmpFinishDataSet).on("invOrgId", "invOrgId").on("materialId", "subMaterialId").on("materialVerId", "subMertialVerId").on("materialAuxPropId", "subMerialAuxPropId").on("calckeycolId", "subCalckeycolId").select(preConstrDataSet.getRowMeta().getFieldNames(), new String[]{"finishQty as tmpQty", "finishAmount as tmpAmount", "materialId as tmpMaterialId", "materialVerId as tmpMaterialVerId", "materialAuxPropId as tmpMaterialAuxPropId", "calckeycolId as tmpCalckeycolId", "productQty as tmpProductQty"}).finish();
        finishDataSet = finishDataSet.select("invOrgId,1 as level,case when subElementType ='001' then concat(cast(materialId as String),'@',cast(subMaterialId as String)) else concat(cast(materialId as String),'@0') end as treepath,case when subElementType ='001' then concat(cast(materialId as String),'-',cast(calckeycolId as String),'@',cast(subMaterialId as String),'-',cast(subCalckeycolId as String)) else concat(cast(materialId as String),'-',cast(calckeycolId as String),'@0-0') end as keytreepath,materialId,materialVerId,materialAuxPropId,calckeycolId,subMaterialId,subMertialVerId,subMerialAuxPropId,subCalckeycolId,elementId,subElementId,isUnAbsorbd,0.00 as preQty,0.00 as preAmount,0.00 as amountCoeff,finishQty as finQty,finishAmount as finAmount,0.00 as preProQty,productQty as proQty");
        DataSet balDataSet = dataInputService.buildBalanceDataSet(calOrgId, costaccountId, materialIdSet);
        DataSetXLogUtil.logDataSet(balDataSet, crParams.getDebugColName(), crParams.getDebugColValue(), ResManager.loadKDString((String)"\u671f\u521d\u6570\u636e\uff1a", (String)"CostRecoveryV2Service_4", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
        DataSet productPreConstrDataSet = dataInputService.buildPreConstrDataSet(calOrgId, costaccountId, crParams.getPeriodId(), materialIdSet);
        JobSession subSession = AlgoX.createSession((String)("CostRec-Lvl-" + costaccountId + "-" + i));
        DataSetX subMatFinishDataSetX = subSession.fromInput((Input)new DataSetInput(subPreConstrDataSet));
        subMatFinishDataSetX = subMatFinishDataSetX.addFields(new Field[]{new Field("finQty", (DataType)DataType.BigDecimalType), new Field("finAmount", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        subMatFinishDataSetX = DataSetXLogUtil.logDataSetX(subMatFinishDataSetX, crParams.getDebugColName(), crParams.getDebugColValue(), "subMatFinishDataSetX-before:", inMsgHandler);
        subMatFinishDataSetX = subMatFinishDataSetX.groupBy(new String[]{"invOrgId", "tmpMaterialId", "tmpMaterialVerId", "tmpMaterialAuxPropId", "tmpCalckeycolId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoverySubMatAmtProcessFunction(subMatFinishDataSetX.getRowMeta(), crParams));
        subMatFinishDataSetX = DataSetXLogUtil.logDataSetX(subMatFinishDataSetX, crParams.getDebugColName(), crParams.getDebugColValue(), "subMatFinishDataSetX-after:", inMsgHandler);
        subMatFinishDataSetX = subMatFinishDataSetX.removeFields(new String[]{"tmpQty", "tmpAmount", "tmpMaterialId", "tmpMaterialVerId", "tmpMaterialAuxPropId", "tmpCalckeycolId", "qty", "tmpProductQty"});
        DataSetX balDataSetX = subSession.fromInput((Input)new DataSetInput(balDataSet));
        DataSetX productPreConstrDataSetX = subSession.fromInput((Input)new DataSetInput(productPreConstrDataSet));
        JoinDataSetX proMatDataSetX = productPreConstrDataSetX.join(balDataSetX).on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").on("calckeycolId", "calckeycolId").select(productPreConstrDataSetX.getRowMeta().getFieldNames(), new String[]{"preProQty", "balanceAmount"});
        proMatDataSetX = proMatDataSetX.addFields(new Field[]{new Field("preQty", (DataType)DataType.BigDecimalType), new Field("preAmount", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        HashMap fieldKey = Maps.newHashMapWithExpectedSize((int)16);
        fieldKey.put("proQtyKey", "preProQty");
        fieldKey.put("proAmtKey", "balanceAmount");
        fieldKey.put("unitQtyKey", "qty");
        fieldKey.put("unitAmountCoeffKey", "amountCoeff");
        fieldKey.put("saveQtyKey", "preQty");
        fieldKey.put("saveAmtKey", "preAmount");
        proMatDataSetX = DataSetXLogUtil.logDataSetX((DataSetX)proMatDataSetX, crParams.getDebugColName(), crParams.getDebugColValue(), "proMatDataSetX-before", inMsgHandler);
        proMatDataSetX = proMatDataSetX.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryProMatAmtProcessFunction(proMatDataSetX.getRowMeta(), crParams, fieldKey));
        proMatDataSetX = DataSetXLogUtil.logDataSetX((DataSetX)proMatDataSetX, crParams.getDebugColName(), crParams.getDebugColValue(), "proMatDataSetX-after", inMsgHandler);
        proMatDataSetX = proMatDataSetX.removeFields(new String[]{"qty"});
        DataSetX finishDataSetX = subSession.fromInput((Input)new DataSetInput(finishDataSet));
        proMatDataSetX = proMatDataSetX.addFields(new Field[]{new Field("finQty", (DataType)DataType.BigDecimalType), new Field("finAmount", (DataType)DataType.BigDecimalType), new Field("proQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        subMatFinishDataSetX = subMatFinishDataSetX.addFields(new Field[]{new Field("preQty", (DataType)DataType.BigDecimalType), new Field("preAmount", (DataType)DataType.BigDecimalType), new Field("preProQty", (DataType)DataType.BigDecimalType), new Field("proQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        proMatDataSetX = proMatDataSetX.removeFields(new String[]{"balanceAmount"});
        finishDataSetX = finishDataSetX.select(unionSelect);
        proMatDataSetX = proMatDataSetX.select(unionSelect);
        subMatFinishDataSetX = subMatFinishDataSetX.select(unionSelect);
        DataSetX rsDataSetX = finishDataSetX.union(subMatFinishDataSetX).union((DataSetX)proMatDataSetX);
        rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, crParams.getDebugColName(), crParams.getDebugColValue(), "rsDataSetX-befer:", inMsgHandler);
        DataSetX groupByDataSetXForQty = rsDataSetX.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).max("preProQty").max("proQty");
        rsDataSetX = rsDataSetX.removeFields(new String[]{"preProQty", "proQty"});
        rsDataSetX = rsDataSetX.groupBy(new String[]{"invOrgId", "level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd"}).sum("preQty").sum("preAmount").max("amountCoeff").sum("finQty").sum("finAmount");
        rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, crParams.getDebugColName(), crParams.getDebugColValue(), "rsDataSetX-after:", inMsgHandler);
        rsDataSetX = rsDataSetX.leftJoin(groupByDataSetXForQty).on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").on("calckeycolId", "calckeycolId").select(rsDataSetX.getRowMeta().getFieldNames(), new String[]{"preProQty", "proQty"});
        rsDataSetX = rsDataSetX.orderBy(new String[]{"invOrgId", "materialId", "level", "treepath", "keytreepath", "subMaterialId"});
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("unitQty", (DataType)DataType.BigDecimalType), new Field("unitAmt", (DataType)DataType.BigDecimalType), new Field("actQtyForFinish", (DataType)DataType.BigDecimalType), new Field("actAmountForFinish", (DataType)DataType.BigDecimalType), new Field("actQtyForTrans", (DataType)DataType.BigDecimalType), new Field("actAmountForTrans", (DataType)DataType.BigDecimalType), new Field("actQtyForPurs", (DataType)DataType.BigDecimalType), new Field("actAmountForPurs", (DataType)DataType.BigDecimalType), new Field("transInQty", (DataType)DataType.BigDecimalType), new Field("transInAmt", (DataType)DataType.BigDecimalType), new Field("proActAmt", (DataType)DataType.BigDecimalType), new Field("proActQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        rsDataSetX = rsDataSetX.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryCalculateFunction(rsDataSetX.getRowMeta(), crParams));
        rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, crParams.getDebugColName(), crParams.getDebugColValue(), "CostRecoveryCalculate-after:", inMsgHandler);
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("periodId", (DataType)DataType.LongType)}, new Object[]{crParams.getPeriodId()});
        boolean isContainsTransIn = false;
        if (crParams.getCalRange() != null && crParams.getCalRange().indexOf("TRANSDIRBILL") > -1 && !(transInDataSet = dataInputService.buildTransInDataSet(costaccountId, calOrgId, materialIdSet)).isEmpty()) {
            isContainsTransIn = true;
            rsDataSetX = this.transInProcess(crParams, crParams.getCalcReportId(), calOrgId, subSession, i, rsDataSetX, transInDataSet, crParams.getDebugColName(), crParams.getDebugColValue(), inMsgHandler);
            rsDataSetX = rsDataSetX.groupBy(new String[]{"periodId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryCalculateForTransInFunction(rsDataSetX.getRowMeta(), crParams));
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, crParams.getDebugColName(), crParams.getDebugColValue(), String.format("index:%s@reportId:%s@calOrgId:%s@trans-xxxxx-final", i, crParams.getCalcReportId(), calOrgId), inMsgHandler);
        }
        if (!isContainsTransIn) {
            rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType), new Field("transOutOrgId", (DataType)DataType.LongType), new Field("proTransInQty", (DataType)DataType.BigDecimalType), new Field("proTransInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{0, 0L, BigDecimal.ZERO, BigDecimal.ZERO});
        }
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("calOrgId", (DataType)DataType.LongType)}, new Object[]{calOrgId});
        DataSetOutput resultSet = new DataSetOutput(rsDataSetX.getRowMeta());
        String resultId = resultSet.getId();
        rsDataSetX.output((Output)resultSet);
        subSession.commit(2, TimeUnit.HOURS);
        return subSession.readDataSet(resultId);
    }

    private DataSetX transInProcess(CostRecoveryParams crParams, Long reportId, Long calOrgId, JobSession session, int index, DataSetX rsDataSetX, DataSet transInDataSet, String debugColName, String debugValue, IInfoMsgHandler inMsgHandler) {
        HashMap invOrgRelationMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap keyOutOrgIdValInInvMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap keyOutOrgIdValInInvOrgSetMap = Maps.newHashMapWithExpectedSize((int)16);
        DataSet nowTransInDataSet = transInDataSet.copy().filter("outPeriodId=" + crParams.getPeriodId());
        DataSet preTransInDataSet = transInDataSet.copy().filter("outPeriodId<" + crParams.getPeriodId());
        for (Row row : nowTransInDataSet.copy()) {
            Long materialId = row.getLong("materialId");
            Long materialVerId = row.getLong("materialVerId");
            Long materialAuxPropId = row.getLong("materialAuxPropId");
            Long calckeycolId = row.getLong("calckeycolId");
            Long inInvOrgId = row.getLong("transInOrgId");
            Long outInvOrgId = row.getLong("transOutOrgId");
            String inKey = inInvOrgId + "@" + materialId + "@" + materialVerId + "@" + materialAuxPropId + "@" + calckeycolId;
            String outKey = outInvOrgId + "@" + materialId + "@" + materialVerId + "@" + materialAuxPropId + "@" + calckeycolId;
            BigDecimal transInQty = row.getBigDecimal("transInQty");
            BigDecimal transInAmt = row.getBigDecimal("transInAmt");
            BigDecimal[] bgs = new BigDecimal[]{transInQty, transInAmt};
            Map inMap = invOrgRelationMap.computeIfAbsent(inKey, p -> Maps.newHashMapWithExpectedSize((int)16));
            inMap.put(outInvOrgId, bgs);
            Map outMap = keyOutOrgIdValInInvMap.computeIfAbsent(outKey, p -> Maps.newHashMapWithExpectedSize((int)16));
            outMap.put(inInvOrgId, bgs);
            Set inInvOrgSet = keyOutOrgIdValInInvOrgSetMap.computeIfAbsent(outKey, p -> Sets.newHashSetWithExpectedSize((int)16));
            inInvOrgSet.add(inInvOrgId);
        }
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-00000", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.groupBy(new String[]{"materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryStructMergeFunction(rsDataSetX.getRowMeta(), keyOutOrgIdValInInvOrgSetMap, false));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@trans-StructMerge", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("isLeaf", (DataType)DataType.IntegerType), new Field("isFlagEquation", (DataType)DataType.IntegerType)}, new Object[]{0, 0});
        rsDataSetX = rsDataSetX.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryFlagEquationFunction(rsDataSetX.getRowMeta(), false));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-FlagEquation", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.groupBy(new String[]{"level", "treepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd"}).reduceGroup((GroupReduceFunction)new CostRecoveryTransCalcFunction(rsDataSetX.getRowMeta(), invOrgRelationMap, false));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-11111-pre", inMsgHandler);
        }
        DataSetX transOutDataSetX = rsDataSetX.select(new String[]{"periodId", "invOrgId", "level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd", "unitQty", "amountCoeff"});
        transOutDataSetX = transOutDataSetX.addFields(new Field[]{new Field("transOutOrgId", (DataType)DataType.LongType), new Field("proTransInQty", (DataType)DataType.BigDecimalType), new Field("proTransInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{0L, BigDecimal.ZERO, BigDecimal.ZERO});
        transOutDataSetX = transOutDataSetX.groupBy(new String[]{"materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryTransStructFunction(transOutDataSetX.getRowMeta(), keyOutOrgIdValInInvMap, false));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            transOutDataSetX = DataSetXLogUtil.logDataSetX(transOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-22222", inMsgHandler);
        }
        transOutDataSetX = transOutDataSetX.addFields(new Field[]{new Field("transInQty", (DataType)DataType.BigDecimalType), new Field("transInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        HashMap fieldKey = Maps.newHashMapWithExpectedSize((int)16);
        fieldKey.put("proQtyKey", "proTransInQty");
        fieldKey.put("proAmtKey", "proTransInAmt");
        fieldKey.put("unitQtyKey", "unitQty");
        fieldKey.put("unitAmountCoeffKey", "amountCoeff");
        fieldKey.put("saveQtyKey", "transInQty");
        fieldKey.put("saveAmtKey", "transInAmt");
        transOutDataSetX = transOutDataSetX.groupBy(new String[]{"invOrgId", "transOutOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryProMatAmtProcessFunction(transOutDataSetX.getRowMeta(), crParams, fieldKey));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            transOutDataSetX = DataSetXLogUtil.logDataSetX(transOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-33333", inMsgHandler);
        }
        HashSet outMatIdSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet outPerIdSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet outInvOrgIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : preTransInDataSet.copy()) {
            outMatIdSet.add(row.getLong("materialId"));
            outInvOrgIdSet.add(row.getLong("transOutOrgId"));
            outPerIdSet.add(row.getLong("getHalfHidePeriodId"));
            logger.info("\u5206\u5e03\u8c03\u5165\u5b58\u5728\u5f80\u671f\u7684\u7269\u6599\uff1a" + ((Object)outMatIdSet).toString());
        }
        QFilter preHalfprdhideFilter = new QFilter("storageorgunit.id", "in", (Object)outInvOrgIdSet);
        preHalfprdhideFilter.and("period.id", "in", (Object)outPerIdSet);
        preHalfprdhideFilter.and("material.id", "in", (Object)outMatIdSet);
        DataSet preHalfprdhideDataSet = QueryServiceHelper.queryDataSet((String)"CostRec-halfprdhide", (String)"sca_halfprdhide", (String)"storageorgunit.id as invOrgId,entryentity.level as level,entryentity.treepath as treepath,entryentity.keytreepath as keytreepath,period.id as periodId,material.id as materialId,materialversion.id as materialVerId,auxprop.id as materialAuxPropId,calckeycol.id as calckeycolId,entryentity.submaterial.id as subMaterialId,entryentity.submaterialversion.id as subMertialVerId,entryentity.submaterialauxprop.id as subMerialAuxPropId,entryentity.subcalckeycol.id as subCalckeycolId,entryentity.element.id as elementId,entryentity.subelement.id as subElementId,entryentity.isunabsorb as isUnAbsorbd,entryentity.qty as unitQty,entryentity.amountcoeff as amountCoeff", (QFilter[])preHalfprdhideFilter.toArray(), null);
        DataSet preTransOutDataSet = preHalfprdhideDataSet.join(preTransInDataSet).on("invOrgId", "transOutOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").on("calckeycolId", "calckeycolId").on("periodId", "getHalfHidePeriodId").select(new String[]{"level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd", "unitQty", "amountCoeff"}, new String[]{"outPeriodId periodId", "transInOrgId invOrgId", "transOutOrgId", "transInQty proTransInQty", "transInAmt proTransInAmt"}).finish();
        if (StringUtils.isNotEmpty((String)debugValue)) {
            DataSetXLogUtil.logDataSet(preTransOutDataSet, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-preTransOutData", inMsgHandler);
        }
        DataSetX preTransOutDataSetX = session.fromInput((Input)new DataSetInput(preTransOutDataSet));
        preTransOutDataSetX = preTransOutDataSetX.addFields(new Field[]{new Field("transInQty", (DataType)DataType.BigDecimalType), new Field("transInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        preTransOutDataSetX = preTransOutDataSetX.groupBy(new String[]{"invOrgId", "transOutOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryProMatAmtProcessFunction(preTransOutDataSetX.getRowMeta(), crParams, fieldKey));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            preTransOutDataSetX = DataSetXLogUtil.logDataSetX(preTransOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-preTransOutDataSetX", inMsgHandler);
        }
        transOutDataSetX = DataSetXHelper.union(transOutDataSetX, preTransOutDataSetX);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            transOutDataSetX = DataSetXLogUtil.logDataSetX(transOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-preTransOutDataSetX-merge", inMsgHandler);
        }
        DataSetX transInQtyAmtForProDsx = transOutDataSetX.groupBy(new String[]{"periodId", "invOrgId", "transOutOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).max("proTransInQty").max("proTransInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            transInQtyAmtForProDsx = DataSetXLogUtil.logDataSetX(transInQtyAmtForProDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-44444", inMsgHandler);
        }
        DataSetX sumGroupByTransInQtyDataSetX = transInQtyAmtForProDsx.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).sum("proTransInQty").sum("proTransInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            sumGroupByTransInQtyDataSetX = DataSetXLogUtil.logDataSetX(sumGroupByTransInQtyDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-55555", inMsgHandler);
        }
        DataSetX sumTransOutDataSetX = transOutDataSetX.groupBy(new String[]{"invOrgId", "level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd"}).sum("transInQty").sum("transInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            sumTransOutDataSetX = DataSetXLogUtil.logDataSetX(sumTransOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-66666", inMsgHandler);
        }
        DataSetX cacheProQtyDataSetX = rsDataSetX.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).max("preProQty").max("proQty");
        rsDataSetX = DataSetXHelper.unionIfRowDiff(rsDataSetX, sumTransOutDataSetX);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-77777", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.groupBy(new String[]{"invOrgId", "level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd"}).sum("preQty").sum("preAmount").sum("finQty").sum("finAmount").sum("transInQty").sum("transInAmt").sum("actQtyForFinish").sum("actAmountForFinish").sum("actQtyForTrans").sum("actAmountForTrans").sum("actQtyForPurs").sum("actAmountForPurs");
        rsDataSetX = rsDataSetX.leftJoin(cacheProQtyDataSetX).on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").on("calckeycolId", "calckeycolId").select(rsDataSetX.getRowMeta().getFieldNames(), new String[]{"preProQty", "proQty"});
        rsDataSetX = rsDataSetX.leftJoin(sumGroupByTransInQtyDataSetX).on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").on("calckeycolId", "calckeycolId").select(rsDataSetX.getRowMeta().getFieldNames(), new String[]{"proTransInQty", "proTransInAmt"});
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType), new Field("transOutOrgId", (DataType)DataType.LongType), new Field("periodId", (DataType)DataType.LongType)}, new Object[]{0, 0L, crParams.getPeriodId()});
        transOutDataSetX = transOutDataSetX.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType)}, new Object[]{1});
        rsDataSetX = DataSetXHelper.unionIfRowDiff(rsDataSetX, transOutDataSetX);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-88888", inMsgHandler);
        }
        transInQtyAmtForProDsx = transInQtyAmtForProDsx.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType)}, new Object[]{11});
        rsDataSetX = DataSetXHelper.unionIfRowDiff(rsDataSetX, transInQtyAmtForProDsx);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@calOrgId:" + calOrgId + "@trans-99999", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("addPreQty", (DataType)DataType.BigDecimalType), new Field("unitQty", (DataType)DataType.BigDecimalType), new Field("amountCoeff", (DataType)DataType.BigDecimalType), new Field("proActAmt", (DataType)DataType.BigDecimalType), new Field("proActQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        return rsDataSetX;
    }

    private DataSetX pursInProcess(CostRecoveryParams crParams, Long reportId, JobSession session, int index, DataSetX rsDataSetX, DataSet purInDataSet, Map<Long, Long> keyInvOrgIdValCalOrgIdMap, String debugColName, String debugValue, IInfoMsgHandler inMsgHandler) {
        long start = System.currentTimeMillis();
        logger.info(reportId + "@" + index + "@:****\u8de8\u7ec4\u7ec7\u91c7\u8d2d  step1 -> start****");
        HashMap invOrgRelationMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap calOrgRelationMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap keyOutOrgIdValInInvMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap keyOutCalOrgIdValInCalOrgMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap keyOutCalOrgIdValInCalOrgQtyAmtMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Row row : purInDataSet.copy()) {
            Long materialId = row.getLong("materialId");
            Long materialVerId = row.getLong("materialVerId");
            Long materialAuxPropId = row.getLong("materialAuxPropId");
            Long calckeycolId = row.getLong("calckeycolId");
            Long inInvOrgId = row.getLong("invOrgId");
            Long outCalOrgId = row.getLong("salesCalOrgId");
            Long inCalOrgId = keyInvOrgIdValCalOrgIdMap.get(inInvOrgId);
            String materialKey = materialId + "@" + materialVerId + "@" + materialAuxPropId + "@" + calckeycolId;
            String inKey = inInvOrgId + "@" + materialKey;
            String outKey = outCalOrgId + "@" + materialKey;
            String calOrgInKey = inCalOrgId + "@" + materialKey;
            BigDecimal pursInQty = row.getBigDecimal("pursInQty");
            BigDecimal pursInAmt = row.getBigDecimal("pursInAmt");
            BigDecimal[] bgs = new BigDecimal[]{pursInQty, pursInAmt};
            Map inMap = invOrgRelationMap.computeIfAbsent(inKey, p -> Maps.newHashMapWithExpectedSize((int)16));
            inMap.put(outCalOrgId, bgs);
            Map calOrgInMap = calOrgRelationMap.computeIfAbsent(calOrgInKey, p -> Maps.newHashMapWithExpectedSize((int)16));
            calOrgInMap.put(outCalOrgId, bgs);
            Map outMap = keyOutOrgIdValInInvMap.computeIfAbsent(outKey, p -> Maps.newHashMapWithExpectedSize((int)16));
            outMap.put(inInvOrgId, bgs);
            Set inCalOrgSet = keyOutCalOrgIdValInCalOrgMap.computeIfAbsent(outKey, p -> Sets.newHashSetWithExpectedSize((int)16));
            inCalOrgSet.add(inCalOrgId);
            Map outQtyAmtMap = keyOutCalOrgIdValInCalOrgQtyAmtMap.computeIfAbsent(outKey, p -> Maps.newHashMapWithExpectedSize((int)16));
            BigDecimal[] tmpBgs = outQtyAmtMap.computeIfAbsent(inCalOrgId, p -> new BigDecimal[2]);
            tmpBgs[0] = BigDecimalUtils.getBigDecimalOrZero(tmpBgs[0]).add(pursInQty);
            tmpBgs[1] = BigDecimalUtils.getBigDecimalOrZero(tmpBgs[1]).add(pursInAmt);
            outQtyAmtMap.put(inCalOrgId, tmpBgs);
        }
        DataSetX calOrgIdRsDsx = rsDataSetX;
        DataSetX proQtyRsDsx = calOrgIdRsDsx.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).max("preProQty").max("proQty").max("proTransInQty").max("proTransInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            proQtyRsDsx = DataSetXLogUtil.logDataSetX(proQtyRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-aaaaa", inMsgHandler);
        }
        proQtyRsDsx = proQtyRsDsx.groupBy(new String[]{"calOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).sum("preProQty").sum("proQty").sum("proTransInQty").sum("proTransInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            proQtyRsDsx = DataSetXLogUtil.logDataSetX(proQtyRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-aaaaa-1", inMsgHandler);
        }
        calOrgIdRsDsx = calOrgIdRsDsx.groupBy(new String[]{"calOrgId", "level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd"}).sum("preQty").sum("preAmount").sum("finQty").sum("finAmount").sum("transInQty").sum("transInAmt").sum("actQtyForFinish").sum("actAmountForFinish").sum("actQtyForTrans").sum("actAmountForTrans").sum("actQtyForPurs").sum("actAmountForPurs");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            calOrgIdRsDsx = DataSetXLogUtil.logDataSetX(calOrgIdRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-bbbbb-0", inMsgHandler);
        }
        calOrgIdRsDsx = calOrgIdRsDsx.join(proQtyRsDsx).on("calOrgId", "calOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").on("calckeycolId", "calckeycolId").select(calOrgIdRsDsx.getRowMeta().getFieldNames(), new String[]{"preProQty", "proQty", "proTransInQty", "proTransInAmt"});
        if (StringUtils.isNotEmpty((String)debugValue)) {
            calOrgIdRsDsx = DataSetXLogUtil.logDataSetX(calOrgIdRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-bbbbb-1", inMsgHandler);
        }
        calOrgIdRsDsx = calOrgIdRsDsx.addFields(new Field[]{new Field("addPreQty", (DataType)DataType.BigDecimalType), new Field("unitQty", (DataType)DataType.BigDecimalType), new Field("amountCoeff", (DataType)DataType.BigDecimalType), new Field("proActAmt", (DataType)DataType.BigDecimalType), new Field("proActQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        calOrgIdRsDsx = calOrgIdRsDsx.groupBy(new String[]{"calOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryCalculateForTransSumFunction(calOrgIdRsDsx.getRowMeta(), crParams));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            calOrgIdRsDsx = DataSetXLogUtil.logDataSetX(calOrgIdRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-ccccc-CalculateForTransSum", inMsgHandler);
        }
        calOrgIdRsDsx = calOrgIdRsDsx.groupBy(new String[]{"materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryStructMergeFunction(calOrgIdRsDsx.getRowMeta(), keyOutCalOrgIdValInCalOrgMap, true));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            calOrgIdRsDsx = DataSetXLogUtil.logDataSetX(calOrgIdRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-ccccc-StructMerge", inMsgHandler);
        }
        calOrgIdRsDsx = calOrgIdRsDsx.addFields(new Field[]{new Field("isLeaf", (DataType)DataType.IntegerType), new Field("isFlagEquation", (DataType)DataType.IntegerType)}, new Object[]{0, 1});
        calOrgIdRsDsx = calOrgIdRsDsx.groupBy(new String[]{"calOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryFlagEquationFunction(calOrgIdRsDsx.getRowMeta(), true));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            calOrgIdRsDsx = DataSetXLogUtil.logDataSetX(calOrgIdRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-ccccc-FlagEquation", inMsgHandler);
        }
        calOrgIdRsDsx = calOrgIdRsDsx.groupBy(new String[]{"level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd"}).reduceGroup((GroupReduceFunction)new CostRecoveryTransCalcFunction(calOrgIdRsDsx.getRowMeta(), calOrgRelationMap, true));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            calOrgIdRsDsx = DataSetXLogUtil.logDataSetX(calOrgIdRsDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-ddddd-pre", inMsgHandler);
        }
        DataSetX salesOutDataSetX = calOrgIdRsDsx.select(new String[]{"calOrgId", "level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd", "unitQty", "amountCoeff"});
        salesOutDataSetX = salesOutDataSetX.addFields(new Field[]{new Field("salesCalOrgId", (DataType)DataType.LongType), new Field("proPursInQty", (DataType)DataType.BigDecimalType), new Field("proPursInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{0L, BigDecimal.ZERO, BigDecimal.ZERO});
        salesOutDataSetX = salesOutDataSetX.groupBy(new String[]{"materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryTransStructFunction(salesOutDataSetX.getRowMeta(), keyOutCalOrgIdValInCalOrgQtyAmtMap, true));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            salesOutDataSetX = DataSetXLogUtil.logDataSetX(salesOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-eeeee-pre", inMsgHandler);
        }
        DataSetX pursDataSetX = session.fromInput((Input)new DataSetInput(purInDataSet));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            pursDataSetX = DataSetXLogUtil.logDataSetX(pursDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-eeeee-pre-2", inMsgHandler);
        }
        salesOutDataSetX = salesOutDataSetX.join(pursDataSetX).on("salesCalOrgId", "salesCalOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").on("calckeycolId", "calckeycolId").select(new String[]{"level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd", "unitQty", "amountCoeff"}, new String[]{"calOrgId", "invOrgId", "salesCalOrgId", "pursInQty proPursInQty", "pursInAmt proPursInAmt"});
        if (StringUtils.isNotEmpty((String)debugValue)) {
            salesOutDataSetX = DataSetXLogUtil.logDataSetX(salesOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-eeeee-final", inMsgHandler);
        }
        salesOutDataSetX = salesOutDataSetX.addFields(new Field[]{new Field("pursInQty", (DataType)DataType.BigDecimalType), new Field("pursInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        HashMap fieldKey = Maps.newHashMapWithExpectedSize((int)16);
        fieldKey.put("proQtyKey", "proPursInQty");
        fieldKey.put("proAmtKey", "proPursInAmt");
        fieldKey.put("unitQtyKey", "unitQty");
        fieldKey.put("unitAmountCoeffKey", "amountCoeff");
        fieldKey.put("saveQtyKey", "pursInQty");
        fieldKey.put("saveAmtKey", "pursInAmt");
        salesOutDataSetX = salesOutDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "salesCalOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryProMatAmtProcessFunction(salesOutDataSetX.getRowMeta(), crParams, fieldKey));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            salesOutDataSetX = DataSetXLogUtil.logDataSetX(salesOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-fffff", inMsgHandler);
        }
        DataSetX pursInQtyAmtForProDsx = salesOutDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "salesCalOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).max("proPursInQty").max("proPursInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            pursInQtyAmtForProDsx = DataSetXLogUtil.logDataSetX(pursInQtyAmtForProDsx, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-ggggg", inMsgHandler);
        }
        DataSetX sumGroupByPursInQtyDataSetX = pursInQtyAmtForProDsx.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).sum("proPursInQty").sum("proPursInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            sumGroupByPursInQtyDataSetX = DataSetXLogUtil.logDataSetX(sumGroupByPursInQtyDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-hhhhh", inMsgHandler);
        }
        DataSetX sumSalesOutDataSetX = salesOutDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd"}).sum("pursInQty").sum("pursInAmt");
        if (StringUtils.isNotEmpty((String)debugValue)) {
            sumSalesOutDataSetX = DataSetXLogUtil.logDataSetX(sumSalesOutDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-iiiii", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("pursInQty", (DataType)DataType.BigDecimalType), new Field("pursInAmt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX cacheProQtyDataSetX = rsDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).max("preProQty").max("proQty").max("proTransInQty");
        rsDataSetX = DataSetXHelper.unionIfRowDiff(rsDataSetX, sumSalesOutDataSetX);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-jjjjj", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "level", "treepath", "keytreepath", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "isUnAbsorbd"}).sum("preQty").sum("preAmount").sum("finQty").sum("finAmount").sum("transInQty").sum("transInAmt").sum("pursInQty").sum("pursInAmt").sum("actQtyForFinish").sum("actAmountForFinish").sum("actQtyForTrans").sum("actAmountForTrans").sum("actQtyForPurs").sum("actAmountForPurs");
        rsDataSetX = rsDataSetX.leftJoin(cacheProQtyDataSetX).on("calOrgId", "calOrgId").on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").on("calckeycolId", "calckeycolId").select(rsDataSetX.getRowMeta().getFieldNames(), new String[]{"preProQty", "proQty", "proTransInQty"});
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-kkkkk", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.leftJoin(sumGroupByPursInQtyDataSetX).on("calOrgId", "calOrgId").on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").select(rsDataSetX.getRowMeta().getFieldNames(), new String[]{"proPursInQty", "proPursInAmt"});
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-lllll", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType)}, new Object[]{0});
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("salesCalOrgId", (DataType)DataType.LongType)}, new Object[]{0L});
        salesOutDataSetX = salesOutDataSetX.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType)}, new Object[]{2});
        rsDataSetX = DataSetXHelper.unionIfRowDiff(rsDataSetX, salesOutDataSetX);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-mmmmm", inMsgHandler);
        }
        pursInQtyAmtForProDsx = pursInQtyAmtForProDsx.addFields(new Field[]{new Field("subEntryType", (DataType)DataType.IntegerType)}, new Object[]{22});
        rsDataSetX = DataSetXHelper.unionIfRowDiff(rsDataSetX, pursInQtyAmtForProDsx);
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-nnnnn", inMsgHandler);
        }
        rsDataSetX = rsDataSetX.addFields(new Field[]{new Field("addPreQty", (DataType)DataType.BigDecimalType), new Field("unitQty", (DataType)DataType.BigDecimalType), new Field("amountCoeff", (DataType)DataType.BigDecimalType), new Field("proActAmt", (DataType)DataType.BigDecimalType), new Field("proActQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        rsDataSetX = rsDataSetX.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).reduceGroup((GroupReduceFunction)new CostRecoveryCalculateForPursFunction(rsDataSetX.getRowMeta(), crParams));
        if (StringUtils.isNotEmpty((String)debugValue)) {
            rsDataSetX = DataSetXLogUtil.logDataSetX(rsDataSetX, debugColName, debugValue, "index:" + index + "@reportId:" + reportId + "@purins-xxxxx", inMsgHandler);
        }
        logger.info(reportId + "@" + index + "@:****\u8de8\u7ec4\u7ec7\u91c7\u8d2d  step1 -> end****" + (System.currentTimeMillis() - start));
        return rsDataSetX;
    }

    private void buildMatNotRecMap(CostRecoveryParams crParams, DynamicObject[] costaccountColl, Map<String, Set<Long>> unRecoveryMaterialIdMap, Map<String, Set<String>> unRecoverySubMaterialIdParternMap, Map<String, Set<String>> matQueryLastMap) {
        HashSet<String> unReducSubMaterialStrs;
        HashMap unRecoverySubMaterialIdMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap matIdQueryLastMap = Maps.newHashMapWithExpectedSize((int)16);
        CostRecoveryHelper.setUnRecoveryOrgMaterialIdSetting(logger, crParams, crParams.getCalcReportId(), costaccountColl, unRecoveryMaterialIdMap, unRecoverySubMaterialIdMap, matIdQueryLastMap);
        for (Map.Entry entry : unRecoverySubMaterialIdMap.entrySet()) {
            unReducSubMaterialStrs = new HashSet<String>(((Set)entry.getValue()).size());
            for (Long materialId : (Set)entry.getValue()) {
                unReducSubMaterialStrs.add(String.format("@%s@", materialId));
            }
            unRecoverySubMaterialIdParternMap.put((String)entry.getKey(), (Set<String>)unReducSubMaterialStrs);
        }
        for (Map.Entry entry : matIdQueryLastMap.entrySet()) {
            unReducSubMaterialStrs = new HashSet(((Set)entry.getValue()).size());
            for (Long materialId : (Set)entry.getValue()) {
                unReducSubMaterialStrs.add(String.format("%s-", materialId));
            }
            matQueryLastMap.put((String)entry.getKey(), (Set<String>)unReducSubMaterialStrs);
        }
    }

    private List<Set<String>> getMatLvlList(CostRecoveryParams crParams, CostRecDataInputService dataInputService, List<List<String>> nestMatGroupsIds) {
        String curItem = FactCostReductItemEnum.getName(FactCostReductItemEnum.GETMATLOWLEVEL.getValue());
        int seq = FactCostReductTaskHelper.saveTaskRecordEntry(crParams.getTaskRecordId(), FactCostReductCalcCheck.GETMATLOWLEVEL, curItem, "2", null);
        HashSet<String> nestMatTreePaths = new HashSet<String>(10);
        List<Set<String>> matList = dataInputService.getMatLvlList(nestMatGroupsIds, nestMatTreePaths);
        if (matList != null) {
            ArrayList removeList = Lists.newArrayList();
            for (Set<String> set : matList) {
                if (!set.isEmpty()) continue;
                removeList.add(set);
            }
            matList.removeAll(removeList);
        }
        FactCostReductTaskHelper.upateTaskRecord(crParams.getTaskRecordId(), 10, "2");
        if (CollectionUtils.isEmpty(matList)) {
            String errorMsg = ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4f4e\u9636\u7801\u5c42\u7ea7\u6570\u636e\u3002", (String)"CostRecoveryV2Service_5", (String)"macc-sca-algox", (Object[])new Object[0]);
            FactCostReductTaskHelper.upateTaskRecordEntryWithMsg(crParams.getTaskRecordId(), FactCostReductCalcCheck.GETMATLOWLEVEL, seq, errorMsg, 0L, "3");
        } else {
            String tipStr = this.getNestGroupTip(nestMatTreePaths, nestMatGroupsIds);
            FactCostReductTaskHelper.upateTaskRecordEntry(crParams.getTaskRecordId(), FactCostReductCalcCheck.GETMATLOWLEVEL, seq, "4", tipStr);
        }
        return matList;
    }

    private String getNestGroupTip(Set<String> nestMatTreePaths, List<List<String>> nestMatGroupsIds) {
        if (CadEmptyUtils.isEmpty(nestMatTreePaths)) {
            return null;
        }
        StringBuilder nestGroupTip = new StringBuilder();
        nestGroupTip.append(ResManager.loadKDString((String)"\u5d4c\u5957\u8def\u5f84Num\uff1a", (String)"CostRecoveryV2Service_7", (String)"macc-sca-algox", (Object[])new Object[0]));
        nestGroupTip.append("\n");
        for (String string : nestMatTreePaths) {
            nestGroupTip.append(string).append('\n');
        }
        if (CadEmptyUtils.isEmpty(nestMatGroupsIds)) {
            return nestGroupTip.toString();
        }
        HashSet materialIdSet = Sets.newHashSetWithExpectedSize((int)10);
        for (List<String> list : nestMatGroupsIds) {
            for (String matKey : list) {
                materialIdSet.add(Long.parseLong(matKey.split("-")[0]));
            }
        }
        Map<Long, String> map = this.getMateralMap(materialIdSet);
        nestGroupTip.append(ResManager.loadKDString((String)"\u5d4c\u5957\u7ec4\uff1a", (String)"CostRecoveryV2Service_8", (String)"macc-sca-algox", (Object[])new Object[0]));
        nestGroupTip.append("\n");
        for (List<String> nestGroup : nestMatGroupsIds) {
            int i = 0;
            nestGroupTip.append("[");
            for (String matKey : nestGroup) {
                String[] cols = matKey.split("-");
                Long matId = Long.parseLong(cols[0]);
                Long keycolId = Long.parseLong(cols[1]);
                if (i != 0) {
                    nestGroupTip.append(",");
                }
                nestGroupTip.append(map.get(matId) == null ? matId : map.get(matId));
                if (!CadEmptyUtils.isEmpty(keycolId)) {
                    nestGroupTip.append("-").append(keycolId);
                }
                ++i;
            }
            nestGroupTip.append("]\n");
        }
        return nestGroupTip.toString();
    }

    private void reCalcReductParam(CostRecoveryParams crParams) {
        if (!crParams.isUsePreConstr()) {
            return;
        }
        String curItem = FactCostReductItemEnum.getName(FactCostReductItemEnum.RECALCREDUCTPARAM.getValue());
        int seq = FactCostReductTaskHelper.saveTaskRecordEntry(crParams.getTaskRecordId(), FactCostReductItemEnum.COSTREDUCT.getValue(), curItem, "2", null);
        BopHalfprdStructureEngineV2 bopHalfprdStructureEngine = new BopHalfprdStructureEngineV2();
        bopHalfprdStructureEngine.genBopHalfprdStructure(crParams);
        FactCostReductTaskHelper.upateTaskRecord(crParams.getTaskRecordId(), 1, "2");
        FactCostReductTaskHelper.upateTaskRecordEntry(crParams.getTaskRecordId(), FactCostReductItemEnum.COSTREDUCT.getValue(), seq, "4");
    }

    private void clearData(CostRecoveryParams crParams, Set<String> materialIds) {
        String curItem = null;
        int seq = 0;
        if (CadEmptyUtils.isEmpty(materialIds)) {
            curItem = FactCostReductItemEnum.getName(FactCostReductItemEnum.CLEARPREDATA.getValue());
            seq = FactCostReductTaskHelper.saveTaskRecordEntry(crParams.getTaskRecordId(), FactCostReductCalcCheck.CLEARPREDATA, curItem, "2", null);
        }
        int batchSize = CadBgParamUtils.getCadParamForInt((String)"costRecDelBatchSize", (int)200);
        QFilter clearFilter = new QFilter("org.id", "in", crParams.getRelationCalOrgIds());
        clearFilter.and("costaccount.id", "in", crParams.getRelationCostAccountIds());
        if (crParams.getManuOrgId() != 0L) {
            clearFilter.and("prdorg.id", "=", (Object)crParams.getManuOrgId());
        }
        clearFilter.and("period.id", "=", (Object)crParams.getNextPeriodId());
        if (!CadEmptyUtils.isEmpty(materialIds)) {
            clearFilter.and(CostRecCalcHelper.getMatKeyQFilter(materialIds, "material.id", "calckeycol.id"));
        }
        this.batchDelete(clearFilter, "sca_halfprdhide", batchSize);
        clearFilter.and("ismodify", "=", (Object)Boolean.FALSE);
        this.batchDelete(clearFilter, "sca_halfprdstructure", batchSize);
        if (CadEmptyUtils.isEmpty(materialIds)) {
            FactCostReductTaskHelper.upateTaskRecord(crParams.getTaskRecordId(), 10, "2");
            FactCostReductTaskHelper.upateTaskRecordEntry(crParams.getTaskRecordId(), FactCostReductCalcCheck.CLEARPREDATA, seq, "4");
            curItem = FactCostReductItemEnum.getName(FactCostReductItemEnum.CLEARCURRDATA.getValue());
            seq = FactCostReductTaskHelper.saveTaskRecordEntry(crParams.getTaskRecordId(), FactCostReductCalcCheck.CLEARCURRDATA, curItem, "2", null);
        }
        clearFilter = new QFilter("org.id", "in", crParams.getRelationCalOrgIds());
        clearFilter.and("costaccount.id", "in", crParams.getRelationCostAccountIds());
        if (crParams.getManuOrgId() != 0L) {
            clearFilter.and("manuorg.id", "=", (Object)crParams.getManuOrgId());
        }
        clearFilter.and("period.id", "=", (Object)crParams.getPeriodId());
        if (!CadEmptyUtils.isEmpty(materialIds)) {
            clearFilter.and(CostRecCalcHelper.getMatKeyQFilter(materialIds, "material.id", "calckeycol.id"));
        }
        this.batchDelete(clearFilter, "sca_costrecovry", batchSize);
        if (CadEmptyUtils.isEmpty(materialIds)) {
            FactCostReductTaskHelper.upateTaskRecord(crParams.getTaskRecordId(), 10, "2");
            FactCostReductTaskHelper.upateTaskRecordEntry(crParams.getTaskRecordId(), FactCostReductCalcCheck.CLEARCURRDATA, seq, "4");
        }
    }

    private void batchDelete(QFilter clearFilter, String entity, int batchSize) {
        ArrayList idList = Lists.newArrayListWithCapacity((int)1000);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"batchDelete", (String)entity, (String)"id", (QFilter[])clearFilter.toArray(), null);
        for (Row row : ds) {
            idList.add(row.getLong("id"));
        }
        logger.info("\u6210\u672c\u8fd8\u539f\u5355\u636e\u5220\u9664\uff1a{},{},{}", new Object[]{clearFilter, entity, idList.size()});
        List spList = Lists.partition((List)idList, (int)batchSize);
        for (List listTmp : spList) {
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)entity), (Object[])listTmp.toArray());
        }
    }

    private boolean costRecCheck(CostRecoveryParams crParams) {
        String curItem = FactCostReductItemEnum.getName(FactCostReductItemEnum.CALCTASKCHECK.getValue());
        int seq = FactCostReductTaskHelper.saveTaskRecordEntry(crParams.getTaskRecordId(), FactCostReductCalcCheck.CALCTASKCHECK, curItem, "2", null);
        String param = SerializationUtils.toJsonString((Object)crParams);
        param = CostRecoveryHelper.changeSomeValue(param);
        ReductCheckHelper.doCheck(param, crParams);
        int failCount = crParams.getCheckNoPassCount();
        FactCostReductTaskHelper.upateTaskRecord(crParams.getTaskRecordId(), 10, "2", false);
        if (failCount == 0) {
            FactCostReductTaskHelper.upateTaskRecordEntry(crParams.getTaskRecordId(), FactCostReductCalcCheck.CALCTASKCHECK, seq, "4");
        } else {
            Map<String, String> failMap = ReductCheckHelper.getCostReductCalcReportEntryFailInfo(crParams.getCheckResultId());
            String notPassMsg = String.valueOf(failMap.get("notPassMsg"));
            FactCostReductTaskHelper.upateTaskRecordEntryWithMsg(crParams.getTaskRecordId(), FactCostReductCalcCheck.CALCTASKCHECK, seq, notPassMsg, crParams.getCheckResultId(), "3");
        }
        return failCount == 0;
    }

    private void init(CostRecoveryParams crParams) {
        TreeSet calcKeys;
        QFilter filter;
        DynamicObject param;
        String[] ss;
        String debugString = ScaDebugHelper.getDebugKeyword("sca_costrecovery");
        if (StringUtils.isNotEmpty((String)debugString) && (ss = debugString.split("=")).length > 1) {
            crParams.setDebugColName(ss[0]);
            crParams.setDebugColValue(ss[1]);
        }
        if ((param = QueryServiceHelper.queryOne((String)"im_invdbparam", (String)"value", (QFilter[])new QFilter[]{filter = new QFilter("key", "=", (Object)"costrec_matpreci")})) != null) {
            try {
                crParams.setMatPricise(param.getInt("value"));
            }
            catch (Exception ex) {
                logger.error("\u540e\u53f0\u53c2\u6570\u7ef4\u62a4\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff1a{}", (Object)"costrec_matpreci");
            }
        }
        if ((calcKeys = CalcKeycolHelper.getCostaccountReductKeyCols((Long)crParams.getCalOrgId(), (Long)crParams.getCostAccountId(), (String)crParams.getAppnum())) == null) {
            calcKeys = new TreeSet();
        }
        crParams.setCalcKeys(calcKeys);
        crParams.setCalcKeycol(!calcKeys.isEmpty());
        crParams.setExKeycols(CalcKeycolHelper.getExtendKeyCol(calcKeys));
        crParams.setCalbyCostElement(CostAccountHelper.getCostElementByCostAccount(crParams.getCostAccountId()));
    }

    private Map<Long, String> getMateralMap(Set<Long> allMaterialIdSet) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)10);
        try (DataSet matDs = QueryServiceHelper.queryDataSet((String)ALGOKEY_PRE, (String)"bd_material", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", allMaterialIdSet)}, null);){
            for (Row row : matDs) {
                result.put(row.getLong("id"), String.format("%s", row.getString("number")));
            }
        }
        return result;
    }

    private CostRecDataInputService getDataInputService(CostRecoveryParams crParams) {
        CostRecBaseDataInputService service = null;
        service = "aca".equals(crParams.getAppnum()) ? new AcaCostRecDataInputService() : new ScaCostRecDataInputService();
        service.setCrParams(crParams);
        return service;
    }
}

