/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.checker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class HalfProdAduitCheck
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext context = this.getContext();
        List<String> matNotAuditMsg = this.getMatNotAuditData(context);
        if (CadEmptyUtils.isEmpty(matNotAuditMsg)) {
            return;
        }
        String checkDesc = ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u671f\u521d\u534a\u6210\u54c1\u7ed3\u6784\u5355\u3002", (String)"HalfProdAduitCheck_0", (String)"macc-sca-algox", (Object[])new Object[0]);
        for (String matNotAudit : matNotAuditMsg) {
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCheckDetailResult(matNotAudit);
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        this.getSingleCheckContext().setCheckResult(checkDesc);
        this.getSingleCheckContext().setPass(false);
    }

    private List<String> getMatNotAuditData(CalcCheckContext context) {
        ArrayList<String> matNotAuditMsg = new ArrayList<String>();
        Set relationCostAccountIds = new HashSet(10);
        if (context.getParams().get("relationCostAccountIds") != null) {
            relationCostAccountIds = (Set)context.getParams().get("relationCostAccountIds");
        }
        Map bdaccountMap = BusinessDataServiceHelper.loadFromCache((Object[])relationCostAccountIds.toArray(), (String)"cal_bd_costaccount");
        for (DynamicObject costaccount : bdaccountMap.values()) {
            Long orgId = costaccount.getLong("calorg.id");
            Long accountId = costaccount.getLong("id");
            QFilter filter = new QFilter("org", "=", (Object)orgId);
            filter.and("costaccount", "=", (Object)accountId);
            if (!CadEmptyUtils.isEmpty((Long)context.getManuOrgId())) {
                filter.and("prdorg", "=", (Object)context.getManuOrgId());
            }
            filter.and("period", "=", (Object)context.getPeriodId());
            filter.and("billstatus", "in", (Object)new String[]{"A", "B"});
            DynamicObjectCollection halfprdstructure = QueryServiceHelper.query((String)"sca_halfprdstructure", (String)"costaccount.name accountname,material.number materialnumber, material.name materialname", (QFilter[])new QFilter[]{filter});
            Set matNotAduit = halfprdstructure.stream().map(s -> String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u201c%2$s/%3$s\u201d\uff0c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u671f\u521d\u534a\u6210\u54c1\u7ed3\u6784\u5355\u3002", (String)"HalfProdAduitCheck_2", (String)"macc-sca-algox", (Object[])new Object[0]), s.getString("accountname"), s.getString("materialnumber"), s.getString("materialname"))).collect(Collectors.toSet());
            matNotAuditMsg.addAll(matNotAduit);
        }
        return matNotAuditMsg;
    }
}

