/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class CostRecoveryReCalcAmountCoeffFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta srcRowMeta;

    public RowMeta getResultRowMeta() {
        return this.srcRowMeta;
    }

    public CostRecoveryReCalcAmountCoeffFunction(RowMeta rowMeta) {
        this.srcRowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector coll) {
        int level;
        ArrayList saveList = Lists.newArrayList();
        LinkedHashMap levelMap = Maps.newLinkedHashMap();
        for (RowX row : iterable) {
            List<RowX> list;
            level = row.getInteger(this.srcRowMeta.getFieldIndex("level"));
            if (levelMap.get(level) == null) {
                list = Lists.newArrayList();
                levelMap.put(level, list);
            }
            list = (List)levelMap.get(level);
            list.add(row);
            saveList.add(row);
        }
        TreeSet sortSet = new TreeSet((o2, o1) -> o1.compareTo((Integer)o2));
        sortSet.addAll(levelMap.keySet());
        sortSet.comparator();
        Iterator iterator = sortSet.iterator();
        while (iterator.hasNext()) {
            level = (Integer)iterator.next();
            int subLevel = level + 1;
            List subRowList = (List)levelMap.get(subLevel);
            if (subRowList == null) continue;
            List nowList = (List)levelMap.get(level);
            for (RowX currRow : nowList) {
                String treePath = currRow.getString(this.srcRowMeta.getFieldIndex("treePath"));
                BigDecimal amountCoeff = BigDecimal.ZERO;
                boolean isExistsSub = false;
                for (RowX subRow : subRowList) {
                    String subTreePath = subRow.getString(this.srcRowMeta.getFieldIndex("treePath"));
                    if (!subTreePath.startsWith(treePath + "@")) continue;
                    isExistsSub = true;
                    amountCoeff = amountCoeff.add(BigDecimalUtils.getBigDecimalOrZero(subRow.getBigDecimal(this.srcRowMeta.getFieldIndex("amountCoeff"))));
                }
                if (!isExistsSub) continue;
                currRow.set(this.srcRowMeta.getFieldIndex("amountCoeff"), (Object)amountCoeff);
            }
        }
        for (RowX row : saveList) {
            coll.collect(row);
        }
    }
}

