/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class CostRecoveryStructMergeFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -7270465439410173021L;
    private RowMeta srcMeta;
    private boolean isPurIns;
    private Map<String, Set<Long>> keyOutCalOrgIdValInCalOrgMap;

    public RowMeta getSrcMeta() {
        return this.srcMeta;
    }

    public void setSrcMeta(RowMeta srcMeta) {
        this.srcMeta = srcMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public CostRecoveryStructMergeFunction(RowMeta rowMeta, Map<String, Set<Long>> keyOutCalOrgIdValInCalOrgMap, boolean isPurIns) {
        this.srcMeta = rowMeta;
        this.keyOutCalOrgIdValInCalOrgMap = keyOutCalOrgIdValInCalOrgMap;
        this.isPurIns = isPurIns;
    }

    public void reduce(Iterable<RowX> iterable, Collector coll) {
        String orgKey = this.isPurIns ? "calOrgId" : "invOrgId";
        ArrayList saveList = Lists.newArrayList();
        HashMap keyOrgIdAndTreepathMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap keyOrgIdValProQtyAmtMap = Maps.newHashMapWithExpectedSize((int)16);
        Long materialId = 0L;
        Long materialVerId = 0L;
        Long materialAuxPropId = 0L;
        Long calckeycolId = 0L;
        int index = 0;
        HashSet addedSet = Sets.newHashSetWithExpectedSize((int)160);
        for (RowX row : iterable) {
            saveList.add(row);
            if (index == 0) {
                materialId = row.getLong(this.srcMeta.getFieldIndex("materialId"));
                materialVerId = row.getLong(this.srcMeta.getFieldIndex("materialVerId"));
                materialAuxPropId = row.getLong(this.srcMeta.getFieldIndex("materialAuxPropId"));
                calckeycolId = row.getLong(this.srcMeta.getFieldIndex("calckeycolId"));
            }
            Long calOrgId = row.getLong(this.srcMeta.getFieldIndex(orgKey));
            String treePath = row.getString(this.srcMeta.getFieldIndex("keytreepath"));
            Long subElementId = row.getLong(this.srcMeta.getFieldIndex("subElementId"));
            String isUnAbsorbd = row.getString(this.srcMeta.getFieldIndex("isUnAbsorbd"));
            String key = calOrgId + "@" + treePath + "@" + subElementId + "@" + isUnAbsorbd;
            keyOrgIdAndTreepathMap.put(key, row);
            addedSet.add(key);
            if (keyOrgIdValProQtyAmtMap.get(calOrgId) == null) {
                BigDecimal[] bgs = new BigDecimal[]{BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proActQty"))), BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proActAmt")))};
                keyOrgIdValProQtyAmtMap.put(calOrgId, bgs);
            }
            ++index;
        }
        HashMap newKeyOrgIdAndTreepathMap = Maps.newHashMapWithExpectedSize((int)16);
        this.copyLoop(orgKey, saveList, keyOrgIdAndTreepathMap, keyOrgIdValProQtyAmtMap, materialId, materialVerId, materialAuxPropId, calckeycolId, addedSet, newKeyOrgIdAndTreepathMap);
        while (newKeyOrgIdAndTreepathMap.size() > 0) {
            LinkedHashMap newMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
            newMap.putAll(newKeyOrgIdAndTreepathMap);
            newKeyOrgIdAndTreepathMap.clear();
            this.copyLoop(orgKey, saveList, newMap, keyOrgIdValProQtyAmtMap, materialId, materialVerId, materialAuxPropId, calckeycolId, addedSet, newKeyOrgIdAndTreepathMap);
        }
        for (RowX rowX : saveList) {
            coll.collect(rowX);
        }
    }

    private void copyLoop(String orgKey, List<RowX> saveList, Map<String, RowX> keyOrgIdAndTreepathMap, Map<Long, BigDecimal[]> keyOrgIdValProQtyAmtMap, Long materialId, Long materialVerId, Long materialAuxPropId, Long calckeycolId, Set<String> addedSet, Map<String, RowX> newKeyOrgIdAndTreepathMap) {
        for (Map.Entry<String, RowX> entry : keyOrgIdAndTreepathMap.entrySet()) {
            RowX row = entry.getValue();
            Long calOrgId = row.getLong(this.srcMeta.getFieldIndex(orgKey));
            String key = calOrgId + "@" + materialId + "@" + materialVerId + "@" + materialAuxPropId + "@" + calckeycolId;
            String treepath = row.getString(this.srcMeta.getFieldIndex("keytreepath"));
            Long subElementId = row.getLong(this.srcMeta.getFieldIndex("subElementId"));
            String isUnAbsorbd = row.getString(this.srcMeta.getFieldIndex("isUnAbsorbd"));
            if (this.keyOutCalOrgIdValInCalOrgMap.get(key) == null) continue;
            Set<Long> inCalOrgList = this.keyOutCalOrgIdValInCalOrgMap.get(key);
            for (Long inCalOrgId : inCalOrgList) {
                String tmpKey = inCalOrgId + "@" + treepath + "@" + subElementId + "@" + isUnAbsorbd;
                if (keyOrgIdAndTreepathMap.get(tmpKey) != null || addedSet.contains(tmpKey)) continue;
                RowX newRow = row.copy();
                newRow.set(this.srcMeta.getFieldIndex(orgKey), (Object)inCalOrgId);
                newRow.set(this.srcMeta.getFieldIndex("preQty"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("preAmount"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("finQty"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("finAmount"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("transInQty"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("transInAmt"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("actQtyForFinish"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("actAmountForFinish"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("actQtyForTrans"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("actAmountForTrans"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("actQtyForPurs"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("actAmountForPurs"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("preProQty"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("proQty"), (Object)BigDecimal.ZERO);
                if (this.isPurIns) {
                    newRow.set(this.srcMeta.getFieldIndex("proTransInQty"), (Object)BigDecimal.ZERO);
                    newRow.set(this.srcMeta.getFieldIndex("proTransInAmt"), (Object)BigDecimal.ZERO);
                }
                newRow.set(this.srcMeta.getFieldIndex("addPreQty"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("proActQty"), (Object)BigDecimal.ZERO);
                newRow.set(this.srcMeta.getFieldIndex("proActAmt"), (Object)BigDecimal.ZERO);
                BigDecimal[] bgs = keyOrgIdValProQtyAmtMap.get(inCalOrgId);
                if (bgs != null) {
                    newRow.set(this.srcMeta.getFieldIndex("proActQty"), (Object)bgs[0]);
                    newRow.set(this.srcMeta.getFieldIndex("proActAmt"), (Object)bgs[1]);
                }
                newKeyOrgIdAndTreepathMap.put(tmpKey, newRow);
                saveList.add(newRow);
                addedSet.add(tmpKey);
            }
        }
    }
}

