/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class CostRecoveryTransStructFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta srcMeta;
    private Map<String, Map<Long, BigDecimal[]>> keyOutOrgIdValInInvMap;
    private String orgIdKey;
    private boolean isPurIn;

    public CostRecoveryTransStructFunction(RowMeta srcRowMeta, Map<String, Map<Long, BigDecimal[]>> keyOutOrgIdValInInvMap, boolean isPursIn) {
        this.keyOutOrgIdValInInvMap = keyOutOrgIdValInInvMap;
        this.orgIdKey = isPursIn ? "calOrgId" : "invOrgId";
        this.srcMeta = srcRowMeta;
        this.isPurIn = isPursIn;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector coll) {
        HashMap outInvRowXMap = Maps.newHashMapWithExpectedSize((int)16);
        Long materialId = 0L;
        Long materialVerId = 0L;
        Long materialAuxPropId = 0L;
        Long calckeycolId = 0L;
        int index = 0;
        ArrayList saveRowList = Lists.newArrayList();
        for (RowX row : iterable) {
            Long invOrgId = row.getLong(this.srcMeta.getFieldIndex(this.orgIdKey));
            if (index == 0) {
                materialId = row.getLong(this.srcMeta.getFieldIndex("materialId"));
                materialVerId = row.getLong(this.srcMeta.getFieldIndex("materialVerId"));
                materialAuxPropId = row.getLong(this.srcMeta.getFieldIndex("materialAuxPropId"));
                calckeycolId = row.getLong(this.srcMeta.getFieldIndex("calckeycolId"));
            }
            List list = outInvRowXMap.computeIfAbsent(invOrgId, p -> Lists.newArrayList());
            list.add(row);
            ++index;
        }
        HashSet existsTreePathKeySet = Sets.newHashSetWithExpectedSize((int)16);
        HashMap newOutInvRowXMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entry : outInvRowXMap.entrySet()) {
            String string = materialId + "@" + materialVerId + "@" + materialAuxPropId + "@" + calckeycolId;
            List srcRowList = (List)entry.getValue();
            HashSet existsKeySet = Sets.newHashSetWithExpectedSize((int)16);
            this.copyToInInv(outInvRowXMap, newOutInvRowXMap, existsKeySet, existsTreePathKeySet, srcRowList, string, saveRowList, (Long)entry.getKey(), false);
        }
        for (int tmpIndex = 0; tmpIndex == 0 || newOutInvRowXMap.size() > 0; ++tmpIndex) {
            outInvRowXMap.putAll(newOutInvRowXMap);
            newOutInvRowXMap.clear();
            for (Map.Entry entry : outInvRowXMap.entrySet()) {
                String materialKeyStr = materialId + "@" + materialVerId + "@" + materialAuxPropId + "@" + calckeycolId;
                List srcRowList = (List)entry.getValue();
                HashSet existsKeySet = Sets.newHashSetWithExpectedSize((int)16);
                this.copyToInInv(outInvRowXMap, newOutInvRowXMap, existsKeySet, existsTreePathKeySet, srcRowList, materialKeyStr, saveRowList, (Long)entry.getKey(), true);
            }
        }
        for (RowX rowX : saveRowList) {
            coll.collect(rowX);
        }
    }

    private void copyToInInv(Map<Long, List<RowX>> outInvRowXMap, Map<Long, List<RowX>> newOutInvRowXMap, Set<String> existsKeySet, Set<String> existsTreePathKeySet, List<RowX> srcRowList, String materialKeyStr, List<RowX> saveRowList, Long outInvOrgId, boolean isLoop) {
        String key = outInvOrgId + "@" + materialKeyStr;
        Map<Long, BigDecimal[]> inInvMap = this.keyOutOrgIdValInInvMap.get(key);
        if (inInvMap != null) {
            ArrayList newSrcRowList = Lists.newArrayList();
            for (Map.Entry<Long, BigDecimal[]> subEntry : inInvMap.entrySet()) {
                Long inInvOrgId = subEntry.getKey();
                String existsKey = outInvOrgId + "@" + inInvOrgId;
                if (isLoop) {
                    if (existsKeySet.contains(existsKey)) continue;
                    existsKeySet.add(existsKey);
                }
                BigDecimal[] bgs = subEntry.getValue();
                for (int i = 0; i < srcRowList.size(); ++i) {
                    List list;
                    RowX srcRow = srcRowList.get(i);
                    RowX destRow = srcRow.copy();
                    String treePathkey = existsKey + "@" + destRow.getString(this.srcMeta.getFieldIndex("keytreepath")) + "@" + destRow.getString(this.srcMeta.getFieldIndex("subElementId")) + "@" + destRow.getString(this.srcMeta.getFieldIndex("isUnAbsorbd"));
                    if (existsTreePathKeySet.contains(treePathkey)) continue;
                    existsTreePathKeySet.add(treePathkey);
                    if (this.isPurIn) {
                        destRow.set(this.srcMeta.getFieldIndex("calOrgId"), (Object)inInvOrgId);
                        destRow.set(this.srcMeta.getFieldIndex("salesCalOrgId"), (Object)outInvOrgId);
                        destRow.set(this.srcMeta.getFieldIndex("proPursInQty"), (Object)bgs[0]);
                        destRow.set(this.srcMeta.getFieldIndex("proPursInAmt"), (Object)bgs[1]);
                    } else {
                        destRow.set(this.srcMeta.getFieldIndex("invOrgId"), (Object)inInvOrgId);
                        destRow.set(this.srcMeta.getFieldIndex("transOutOrgId"), (Object)outInvOrgId);
                        destRow.set(this.srcMeta.getFieldIndex("proTransInQty"), (Object)bgs[0]);
                        destRow.set(this.srcMeta.getFieldIndex("proTransInAmt"), (Object)bgs[1]);
                    }
                    saveRowList.add(destRow);
                    if (outInvRowXMap.get(inInvOrgId) != null) {
                        list = outInvRowXMap.get(inInvOrgId);
                        list.add(destRow);
                    } else {
                        list = newOutInvRowXMap.computeIfAbsent(inInvOrgId, p -> Lists.newArrayList());
                        list.add(destRow);
                    }
                    RowX otherRow = srcRow.copy();
                    otherRow.set(this.srcMeta.getFieldIndex(this.orgIdKey), (Object)inInvOrgId);
                    newSrcRowList.add(otherRow);
                }
                if (!isLoop) continue;
                this.copyToInInv(outInvRowXMap, newOutInvRowXMap, existsKeySet, existsTreePathKeySet, newSrcRowList, materialKeyStr, saveRowList, inInvOrgId, isLoop);
            }
        }
    }
}

