/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.input;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.costrec.CostRecCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import org.apache.commons.lang3.StringUtils;

public class ActCalcKeycolRadioFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private String dealField = "";
    private int precision = 0;
    private String precisionField;

    public ActCalcKeycolRadioFunction(String dealField, int precision, String precisionField) {
        this.dealField = dealField;
        this.precision = precision;
        this.precisionField = precisionField;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList listRows = Lists.newArrayList();
        for (RowX row : iterable) {
            listRows.add(row);
        }
        this.rowAlloc(listRows);
        this.collectRow(listRows, collector);
    }

    private void rowAlloc(List<RowX> listRows) {
        BigDecimal total;
        if (listRows.size() <= 1) {
            return;
        }
        int fieldIndex = this.sourceRowMeta.getFieldIndex(this.dealField);
        int radioIndex = this.sourceRowMeta.getFieldIndex("subcurrqty");
        Map<RowX, BigDecimal> rowRadioMap = CostRecCalcHelper.getAlgoxRowRadio(listRows, radioIndex);
        BigDecimal diff = total = BigDecimalUtils.getBigDecimalOrZero(listRows.get(0).getBigDecimal(fieldIndex));
        if (total.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        int rowPrecision = this.precision;
        if (!StringUtils.isEmpty((CharSequence)this.precisionField)) {
            Integer precisionVal = listRows.get(0).getInteger(this.sourceRowMeta.getFieldIndex(this.precisionField));
            rowPrecision = precisionVal == null ? 0 : precisionVal;
        }
        RowX maxRow = null;
        for (RowX row : listRows) {
            BigDecimal radio = rowRadioMap.get(row);
            if (radio == null || radio.compareTo(BigDecimal.ZERO) == 0) {
                row.set(fieldIndex, (Object)BigDecimal.ZERO);
                if (maxRow != null) continue;
                maxRow = row;
                continue;
            }
            BigDecimal alloc = total.multiply(radio).setScale(rowPrecision, RoundingMode.HALF_UP);
            if (maxRow == null || maxRow.getBigDecimal(fieldIndex).compareTo(alloc) < 0) {
                maxRow = row;
            }
            row.set(fieldIndex, (Object)alloc);
            diff = diff.subtract(alloc);
        }
        if (diff.compareTo(BigDecimal.ZERO) != 0 && maxRow != null) {
            maxRow.set(fieldIndex, (Object)maxRow.getBigDecimal(fieldIndex).add(diff));
        }
    }

    private void collectRow(List<RowX> listRows, Collector collector) {
        for (RowX row : listRows) {
            collector.collect(row);
        }
    }
}

