/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.input;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.sca.algox.calc.input.LevelMatCode;
import kd.macc.sca.algox.costrec.CostRecCalcHelper;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.costrec.input.ActCalcKeycolRadioFunction;
import kd.macc.sca.algox.costrec.input.CostRecBaseDataInputService;
import kd.macc.sca.algox.costrec.input.ScaCalcFinishConvFunction;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.algox.utils.DataSetXLogUtil;
import kd.macc.sca.algox.utils.IInfoMsgHandler;
import kd.macc.sca.algox.utils.MaterialLevelHelper;

public class ScaCostRecDataInputService
extends CostRecBaseDataInputService {
    private static final String ALGOKEY_PRE = "ScaCRecDI";
    private static final Log logger = LogFactory.getLog(ScaCostRecDataInputService.class);
    private RowMeta factSubqtyRowMeta = new RowMeta(new Field[]{new Field("calOrgId", (DataType)DataType.LongType), new Field("materialId", (DataType)DataType.LongType), new Field("materialVerId", (DataType)DataType.LongType), new Field("materialAuxPropId", (DataType)DataType.LongType), new Field("calckeycolId", (DataType)DataType.LongType), new Field("subMaterialId", (DataType)DataType.LongType), new Field("subMertialVerId", (DataType)DataType.LongType), new Field("subMerialAuxPropId", (DataType)DataType.LongType), new Field("subCalckeycolId", (DataType)DataType.LongType), new Field("subMatUnitPrecision", (DataType)DataType.IntegerType), new Field("costObjectId", (DataType)DataType.LongType), new Field("elementId", (DataType)DataType.LongType), new Field("subElementId", (DataType)DataType.LongType), new Field("subElementType", (DataType)DataType.StringType), new Field("pdcompqty", (DataType)DataType.BigDecimalType), new Field("diffqty", (DataType)DataType.BigDecimalType)});
    private RowMeta factSubqtyKeycolRowMeta = new RowMeta(new Field[]{new Field("calOrgId", (DataType)DataType.LongType), new Field("materialId", (DataType)DataType.LongType), new Field("materialVerId", (DataType)DataType.LongType), new Field("materialAuxPropId", (DataType)DataType.LongType), new Field("calckeycolId", (DataType)DataType.LongType), new Field("subMaterialId", (DataType)DataType.LongType), new Field("subMertialVerId", (DataType)DataType.LongType), new Field("subMerialAuxPropId", (DataType)DataType.LongType), new Field("subCalckeycolId", (DataType)DataType.LongType), new Field("subcurrqty", (DataType)DataType.BigDecimalType), new Field("entryid", (DataType)DataType.LongType), new Field("subMatUnitPrecision", (DataType)DataType.IntegerType), new Field("costObjectId", (DataType)DataType.LongType), new Field("elementId", (DataType)DataType.LongType), new Field("subElementId", (DataType)DataType.LongType), new Field("subElementType", (DataType)DataType.StringType), new Field("pdcompqty", (DataType)DataType.BigDecimalType), new Field("diffqty", (DataType)DataType.BigDecimalType)});
    private RowMeta factSubAmtRowMeta = new RowMeta(new Field[]{new Field("calOrgId", (DataType)DataType.LongType), new Field("materialId", (DataType)DataType.LongType), new Field("materialVerId", (DataType)DataType.LongType), new Field("materialAuxPropId", (DataType)DataType.LongType), new Field("calckeycolId", (DataType)DataType.LongType), new Field("subMaterialId", (DataType)DataType.LongType), new Field("subMertialVerId", (DataType)DataType.LongType), new Field("subMerialAuxPropId", (DataType)DataType.LongType), new Field("subCalckeycolId", (DataType)DataType.LongType), new Field("costObjectId", (DataType)DataType.LongType), new Field("elementId", (DataType)DataType.LongType), new Field("subElementId", (DataType)DataType.LongType), new Field("subElementType", (DataType)DataType.StringType), new Field("finishAmount", (DataType)DataType.BigDecimalType), new Field("producttype", (DataType)DataType.StringType), new Field("isunallocdiff", (DataType)DataType.BooleanType)});
    private RowMeta factSubAmtKeycolRowMeta = new RowMeta(new Field[]{new Field("calOrgId", (DataType)DataType.LongType), new Field("materialId", (DataType)DataType.LongType), new Field("materialVerId", (DataType)DataType.LongType), new Field("materialAuxPropId", (DataType)DataType.LongType), new Field("calckeycolId", (DataType)DataType.LongType), new Field("subMaterialId", (DataType)DataType.LongType), new Field("subMertialVerId", (DataType)DataType.LongType), new Field("subMerialAuxPropId", (DataType)DataType.LongType), new Field("subCalckeycolId", (DataType)DataType.LongType), new Field("subcurrqty", (DataType)DataType.BigDecimalType), new Field("entryid", (DataType)DataType.LongType), new Field("costObjectId", (DataType)DataType.LongType), new Field("elementId", (DataType)DataType.LongType), new Field("subElementId", (DataType)DataType.LongType), new Field("subElementType", (DataType)DataType.StringType), new Field("finishAmount", (DataType)DataType.BigDecimalType), new Field("producttype", (DataType)DataType.StringType), new Field("isunallocdiff", (DataType)DataType.BooleanType)});

    @Override
    public List<Set<String>> getMatLvlList(List<List<String>> nestMatGroupsIds, Set<String> nestMatTreePaths) {
        CostRecoveryParams args = this.getCrParams();
        DataSet lvlDataSet = this.getLvlDataSource(args).distinct();
        ArrayList<List<String>> nestMatGroups = new ArrayList<List<String>>(10);
        if (nestMatTreePaths == null) {
            nestMatTreePaths = new HashSet<String>(10);
        }
        List<List<LevelMatCode>> materlvl = MaterialLevelHelper.getMatLevelList(lvlDataSet, null, null, null, nestMatGroups, nestMatTreePaths, nestMatGroupsIds != null);
        Set<String> prodIds = this.buildCurrentFactMatSet(args);
        Set<String> preProdIds = this.buildPreProductList(args);
        prodIds.addAll(preProdIds);
        for (List list : nestMatGroups) {
            ArrayList<String> nestMatGroupId = new ArrayList<String>(10);
            for (String mat : list) {
                nestMatGroupId.add(CostRecCalcHelper.getKeyIdStr(this.getMaterialIdFromNestGroup(mat), this.getMatKeycolFromNestGroup(mat)));
            }
            nestMatGroupsIds.add(nestMatGroupId);
            prodIds.removeAll(nestMatGroupId);
        }
        ArrayList<Set<String>> lvlMatList = new ArrayList<Set<String>>(10);
        if (materlvl == null) {
            materlvl = new ArrayList<List<LevelMatCode>>(10);
        }
        for (List<LevelMatCode> curCalcMat : materlvl) {
            if (curCalcMat.isEmpty()) continue;
            HashSet curCalcMatIdSet = Sets.newHashSetWithExpectedSize((int)curCalcMat.size());
            for (LevelMatCode actCalcMaterial : curCalcMat) {
                curCalcMatIdSet.add(CostRecCalcHelper.getKeyIdStr(actCalcMaterial.getSubmaterial(), actCalcMaterial.getSubcalckeycol()));
            }
            if (curCalcMatIdSet.isEmpty()) continue;
            lvlMatList.add(curCalcMatIdSet);
            prodIds.removeAll(curCalcMatIdSet);
        }
        if (!prodIds.isEmpty()) {
            if (lvlMatList.isEmpty()) {
                lvlMatList.add(prodIds);
            } else {
                ((Set)lvlMatList.get(lvlMatList.size() - 1)).addAll(prodIds);
            }
        }
        return lvlMatList;
    }

    private DataSet getLvlDataSource(CostRecoveryParams args) {
        QFilter filter = new QFilter("org", "in", args.getRelationCalOrgIds());
        filter.and("costaccount", "in", args.getRelationCostAccountIds());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("entryentity.datatype", "=", (Object)"1");
        filter.and("entryentity.material", ">", (Object)0);
        filter.and("entryentity.producttype", "in", (Object)new String[]{"A", "C"});
        filter.and("entryentity.subelement.type", "in", (Object)new String[]{"001"});
        if (!CadEmptyUtils.isEmpty(args.getManuOrgId())) {
            filter.and("costobject.manuorg.id", "=", (Object)args.getManuOrgId());
        }
        String selectFields = "entryentity.material AS submaterial,'' AS submaterialnumber,0L AS subauxpty,0L AS submatversion" + (args.isCalcKeycol() ? ",entryentity.subentryentity.calckeycol" : ",0L") + " AS subcalckeycol,entryentity.obj.material AS material,'' AS materialnumber,0L AS auxpty,0L AS matversion" + (args.isCalcKeycol() ? ",entryentity.obj.calckeycol" : ",0L") + " AS calckeycol,entryentity.pdcompqty pdcompqty,entryentity.pdcompanount pdcompanount,entryentity.diffqty diffqty,entryentity.diff diff";
        DataSet calcResult = QueryServiceHelper.queryDataSet((String)"ScaCRecDIcalcresult", (String)"sca_calcresult", (String)selectFields, (QFilter[])filter.toArray(), null);
        return calcResult.filter("pdcompqty!=0 or pdcompanount!=0 or diffqty!=0 or diff!=0").removeFields(new String[]{"pdcompqty", "pdcompanount", "diffqty", "diff"});
    }

    private Set<String> buildPreProductList(CostRecoveryParams args) {
        QFilter prdStructureFilter = new QFilter("org", "in", args.getRelationCalOrgIds());
        prdStructureFilter.and("costaccount", "in", args.getRelationCostAccountIds());
        prdStructureFilter.and("period", "=", (Object)args.getPeriodId());
        if (!CadEmptyUtils.isEmpty(args.getManuOrgId())) {
            prdStructureFilter.and("prdorg", "=", (Object)args.getManuOrgId());
        }
        prdStructureFilter.and("billstatus", "=", (Object)"C");
        String selectFields = "material.id as material," + (args.isCalcKeycol() ? "calckeycol.id" : "0L") + " as calckeycol";
        DataSet prdStructure = QueryServiceHelper.queryDataSet((String)"ScaCRecDIprdstructure", (String)"sca_halfprdstructure", (String)selectFields, (QFilter[])prdStructureFilter.toArray(), null);
        HashSet<String> preProductSet = new HashSet<String>(10);
        for (Row row : prdStructure) {
            preProductSet.add(CostRecCalcHelper.getKeyIdStr(row.getLong("material"), row.getLong("calckeycol")));
        }
        return preProductSet;
    }

    public Set<String> buildCurrentFactMatSet(CostRecoveryParams args) {
        QFilter filter = new QFilter("org", "in", args.getRelationCalOrgIds());
        filter.and("appnum", "=", (Object)"sca");
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(args.getManuOrgId())) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        String selectFields = "entryentity.costobject.material material," + (args.isCalcKeycol() ? "entryentity.costobject.calckeycol" : "0L") + " calckeycol";
        DataSet factned = QueryServiceHelper.queryDataSet((String)"ScaCRecDIfactedout", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        HashSet currentFactMatSet = Sets.newHashSetWithExpectedSize((int)32);
        for (Row row : factned) {
            currentFactMatSet.add(CostRecCalcHelper.getKeyIdStr(row.getLong("material"), row.getLong("calckeycol")));
        }
        return currentFactMatSet;
    }

    @Override
    public DataSet buildFinishDataSet(Long orgId, Long costaccountId, Set<String> materialSet, IInfoMsgHandler inMsgHandler) {
        HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)128);
        DataSet factDs = this.getCurrentFactDs(orgId, costaccountId, materialSet, costobjectIds);
        DataSetXLogUtil.logDataSet(factDs, this.getCrParams().getDebugColName(), this.getCrParams().getDebugColValue(), ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u54c1\u6570\u91cf\uff1a", (String)"ScaCostRecDataInputService_0", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
        OrmInput calcResultFactQtyDs = this.getSubMatFactQty(orgId, costaccountId, costobjectIds);
        OrmInput calcResultFactAmtDs = this.getSubMatFactAmt(orgId, costaccountId, costobjectIds);
        JobSession session = AlgoX.createSession((String)"CostRec-FinishDs");
        DataSetX calcResultFactQtyDsX = session.fromInput((Input)calcResultFactQtyDs);
        DataSetX calcResultFactAmtDsX = session.fromInput((Input)calcResultFactAmtDs);
        DataSetX factDsX = session.fromInput((Input)new DataSetInput(factDs));
        calcResultFactAmtDsX = DataSetXLogUtil.logDataSetX(calcResultFactAmtDsX, this.getCrParams().getDebugColName(), this.getCrParams().getDebugColValue(), ResManager.loadKDString((String)"\u5b8c\u5de5\u660e\u7ec6\u5b9e\u9645\u6210\u672c\uff1a", (String)"ScaCostRecDataInputService_1", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
        calcResultFactAmtDsX = calcResultFactAmtDsX.filter("isunallocdiff=false or producttype='B'").removeFields(new String[]{"producttype", "isunallocdiff"});
        calcResultFactQtyDsX = DataSetXLogUtil.logDataSetX(calcResultFactQtyDsX, this.getCrParams().getDebugColName(), this.getCrParams().getDebugColValue(), ResManager.loadKDString((String)"\u5b8c\u5de5\u660e\u7ec6\u6570\u91cf\uff1a", (String)"ScaCostRecDataInputService_2", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
        calcResultFactQtyDsX = calcResultFactQtyDsX.addFields(new Field[]{new Field("finishQty", (DataType)DataType.BigDecimalType), new Field("finishAmount", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        calcResultFactQtyDsX = calcResultFactQtyDsX.map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX row) {
                BigDecimal pdcompqty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("pdcompqty")));
                BigDecimal diffqty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("diffqty")));
                row.set(this.sourceRowMeta.getFieldIndex("finishQty"), (Object)pdcompqty.add(diffqty));
                return row;
            }
        });
        calcResultFactQtyDsX = calcResultFactQtyDsX.removeFields(new String[]{"pdcompqty", "diffqty"});
        if (this.getCrParams().isCalcKeycol()) {
            calcResultFactQtyDsX = calcResultFactQtyDsX.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new ActCalcKeycolRadioFunction("finishQty", 0, "subMatUnitPrecision"));
            calcResultFactAmtDsX = calcResultFactAmtDsX.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new ActCalcKeycolRadioFunction("finishAmount", this.getCrParams().getAmtScale(), ""));
        }
        DataSetX calcResultFactDsX = DataSetXHelper.unionIfRowDiff(calcResultFactQtyDsX, calcResultFactAmtDsX);
        calcResultFactDsX = calcResultFactDsX.map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX row) {
                String subElementType = row.getString(this.sourceRowMeta.getFieldIndex("subElementType"));
                Long subMaterialId = row.getLong(this.sourceRowMeta.getFieldIndex("subMaterialId"));
                if (CadEmptyUtils.isEmpty(subMaterialId) || "003".equals(subElementType) || "004".equals(subElementType) || "005".equals(subElementType)) {
                    row.set(this.sourceRowMeta.getFieldIndex("subMaterialId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("materialId")));
                    row.set(this.sourceRowMeta.getFieldIndex("subMertialVerId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("materialVerId")));
                    row.set(this.sourceRowMeta.getFieldIndex("subMerialAuxPropId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("materialAuxPropId")));
                    row.set(this.sourceRowMeta.getFieldIndex("subCalckeycolId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("calckeycolId")));
                }
                return row;
            }
        });
        calcResultFactDsX = calcResultFactDsX.groupBy(new String[]{"calOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "costObjectId", "elementId", "subElementId", "subElementType"}).max("subMatUnitPrecision").sum("finishQty").sum("finishAmount");
        calcResultFactDsX = DataSetXLogUtil.logDataSetX(calcResultFactDsX, this.getCrParams().getDebugColName(), this.getCrParams().getDebugColValue(), ResManager.loadKDString((String)"\u5b8c\u5de5\u660e\u7ec6\u6570\u91cf\u548c\u91d1\u989d\u5408\u5e76\uff1a", (String)"ScaCostRecDataInputService_3", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
        if (SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(this.getCrParams().getCalDimension())) {
            factDsX = factDsX.groupBy(new String[]{"invOrgId", "costObjectId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).sum("productQty");
            calcResultFactDsX = calcResultFactDsX.join(factDsX).on("costObjectId", "costObjectId").select(calcResultFactDsX.getRowMeta().getFieldNames(), new String[]{"productQty", "invOrgId"});
            calcResultFactDsX = calcResultFactDsX.groupBy(new String[]{"costObjectId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId"}).reduceGroup((GroupReduceFunction)new ScaCalcFinishConvFunction(this.getCrParams().getAmtScale()));
            calcResultFactDsX = DataSetXLogUtil.logDataSetX(calcResultFactDsX, this.getCrParams().getDebugColName(), this.getCrParams().getDebugColValue(), ResManager.loadKDString((String)"\u6309\u5e93\u5b58\u7ec4\u7ec7\u6298\u7b97\uff1a", (String)"ScaCostRecDataInputService_4", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
            DataSetX productDs = calcResultFactDsX.groupBy(new String[]{"invOrgId", "costObjectId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).max("productQty").groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).sum("productQty");
            DataSetX subMaterialDs = calcResultFactDsX.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "subElementType"}).sum("finishQty").sum("finishAmount");
            calcResultFactDsX = subMaterialDs.join(productDs).on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").on("calckeycolId", "calckeycolId").select(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "subElementType", "finishQty", "finishAmount"}, new String[]{"productQty"});
        } else {
            factDsX = factDsX.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).sum("productQty");
            calcResultFactDsX = calcResultFactDsX.join(factDsX).on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").on("calckeycolId", "calckeycolId").select(calcResultFactDsX.getRowMeta().getFieldNames(), new String[]{"productQty", "invOrgId"});
        }
        calcResultFactDsX = calcResultFactDsX.filter("finishQty<>0 or finishAmount<>0 or productQty<>0");
        calcResultFactDsX = calcResultFactDsX.addFields(new Field[]{new Field("isUnAbsorbd", (DataType)DataType.StringType)}, new Object[]{"A"});
        DataSetOutput resultSet = new DataSetOutput(calcResultFactDsX.getRowMeta());
        calcResultFactDsX.output((Output)resultSet);
        try {
            long start = System.currentTimeMillis();
            session.commit(20, TimeUnit.MINUTES);
            logger.info("\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        return session.readDataSet(resultSet.getId());
    }

    private DataSet getCurrentFactDs(Long orgId, Long costaccountId, Set<String> materialSet, Set<Long> costobjectIds) {
        CostRecoveryParams args = this.getCrParams();
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("appnum", "=", (Object)"sca");
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        if (this.getCrParams().isCalcKeycol()) {
            filter.and(CostRecCalcHelper.getMatKeyQFilter(materialSet, "entryentity.costobject.material.id", "entryentity.costobject.calckeycol.id"));
        } else {
            filter.and(CostRecCalcHelper.getMatQFilter(materialSet, "entryentity.costobject.material.id"));
        }
        if (!CadEmptyUtils.isEmpty(args.getManuOrgId())) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        String selectFields = "org.id as calOrgId,entryentity.costobject.id as costObjectId,entryentity.qty as productQty,sourcebill as sourceBillId,sourcebillentry as sourceBillEntryId,entryentity.costobject.material.id as materialId,entryentity.costobject.bomversion.id as materialVerId" + (this.getCrParams().isCalcKeycol() ? ",entryentity.costobject.calckeycol.auxproperty" : ",entryentity.costobject.auxpty.id") + " as materialAuxPropId" + (this.getCrParams().isCalcKeycol() ? ",entryentity.costobject.calckeycol.id" : ",0L") + " as calckeycolId";
        DataSet factned = QueryServiceHelper.queryDataSet((String)"factedoutputbill", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        HashSet factEntryIdSet = Sets.newHashSetWithExpectedSize((int)32);
        DataSet factnedCopy = factned.copy();
        for (Row row : factnedCopy) {
            factEntryIdSet.add(row.getLong("sourceBillEntryId"));
            costobjectIds.add(row.getLong("costObjectId"));
        }
        if (SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(this.getCrParams().getCalDimension())) {
            QFilter qFilter = new QFilter("calorg", "=", (Object)orgId);
            qFilter.and("costaccount", "=", (Object)costaccountId);
            qFilter.and("period", "=", (Object)args.getPeriodId());
            filter.and("bookdate", ">=", (Object)args.getStartDate());
            filter.and("bookdate", "<=", (Object)args.getEndDate());
            qFilter.and("entry.bizbillentryid", "in", (Object)factEntryIdSet);
            qFilter.and("calbilltype", "=", (Object)"IN");
            DataSet costrecordDs = QueryServiceHelper.queryDataSet((String)"getCalCostRecord", (String)"cal_costrecord_subentity", (String)"entry.bizbillentryid AS bizbillentryid,storageorgunit invOrgId", (QFilter[])qFilter.toArray(), null);
            return factned.leftJoin(costrecordDs).on("sourceBillEntryId", "bizbillentryid").select(factned.getRowMeta().getFieldNames(), new String[]{"invOrgId"}).finish();
        }
        return factned.addField("0L", "invOrgId");
    }

    private OrmInput getSubMatFactQty(Long orgId, Long costaccountId, Set<Long> costobjectIds) {
        CostRecoveryParams args = this.getCrParams();
        QFilter filter = new QFilter("org.id", "=", (Object)orgId);
        filter.and("period.id", "=", (Object)args.getPeriodId());
        filter.and("costaccount.id", "=", (Object)costaccountId);
        filter.and("entryentity.obj.id", "in", costobjectIds);
        filter.and("entryentity.datatype", "=", (Object)"1");
        String selectField = "org.id as calOrgId,entryentity.obj.material.id as materialId,entryentity.obj.bomversion.id as materialVerId" + (this.getCrParams().isCalcKeycol() ? ",entryentity.obj.calckeycol.auxproperty" : ",entryentity.obj.auxpty.id") + " as materialAuxPropId" + (this.getCrParams().isCalcKeycol() ? ",entryentity.obj.calckeycol.id" : ",0L") + " as calckeycolId, entryentity.material.id  as subMaterialId, entryentity.matversion.id as subMertialVerId" + (this.getCrParams().isCalcKeycol() ? ",entryentity.subentryentity.calckeycol.auxproperty" : ", entryentity.auxpty.id") + " as subMerialAuxPropId" + (this.getCrParams().isCalcKeycol() ? ",entryentity.subentryentity.calckeycol.id" : ",0L") + " as subCalckeycolId" + (this.getCrParams().isCalcKeycol() ? ",entryentity.subentryentity.subcurrqty as subcurrqty" : "") + (this.getCrParams().isCalcKeycol() ? ",entryentity.id as entryid" : "") + ",entryentity.material.baseunit.precision as subMatUnitPrecision,entryentity.obj.id as costObjectId,entryentity.element.id as elementId,entryentity.subelement.id as subElementId,entryentity.subelement.type as subElementType,entryentity.pdcompqty as pdcompqty,entryentity.diffqty as diffqty";
        RowMeta rowmeta = this.getCrParams().isCalcKeycol() ? this.factSubqtyKeycolRowMeta : this.factSubqtyRowMeta;
        return new OrmInput("ScaCRecDIcalcresult", "sca_calcresult", selectField, filter.toArray(), rowmeta);
    }

    private OrmInput getSubMatFactAmt(Long orgId, Long costaccountId, Set<Long> costobjectIds) {
        CostRecoveryParams args = this.getCrParams();
        QFilter filter = new QFilter("org.id", "=", (Object)orgId);
        filter.and("period.id", "=", (Object)args.getPeriodId());
        filter.and("costaccount.id", "=", (Object)costaccountId);
        filter.and("entryentity1.relacostobject1.id", "in", costobjectIds);
        filter.and("entryentity1.type1", "=", (Object)"1");
        String selectField = "org.id as calOrgId,entryentity1.relacostobject1.material.id as materialId,entryentity1.relacostobject1.bomversion.id as materialVerId" + (this.getCrParams().isCalcKeycol() ? ",entryentity1.relacostobject1.calckeycol.auxproperty" : ",entryentity1.relacostobject1.auxpty.id") + " as materialAuxPropId" + (this.getCrParams().isCalcKeycol() ? ",entryentity1.relacostobject1.calckeycol" : ",0L") + " as calckeycolId, entryentity1.material1.id  as subMaterialId, entryentity1.matversion1.id as subMertialVerId" + (this.getCrParams().isCalcKeycol() ? ", entryentity1.subentryentity1.calckeycol1.auxproperty" : ", entryentity1.auxpty1.id") + " as subMerialAuxPropId" + (this.getCrParams().isCalcKeycol() ? ", entryentity1.subentryentity1.calckeycol1.id" : ",0L") + " as subCalckeycolId" + (this.getCrParams().isCalcKeycol() ? ",entryentity1.subentryentity1.subcurrqty1 as subcurrqty" : "") + (this.getCrParams().isCalcKeycol() ? ",entryentity1.id as entryid" : "") + ",entryentity1.relacostobject1.id as costObjectId,entryentity1.element1.id as elementId,entryentity1.subelement1.id as subElementId,entryentity1.subelement1.type as subElementType,entryentity1.compactcostupamt1 as finishAmount,entryentity1.relacostobject1.producttype producttype,isunallocdiff";
        RowMeta rowMeta = this.getCrParams().isCalcKeycol() ? this.factSubAmtKeycolRowMeta : this.factSubAmtRowMeta;
        return new OrmInput("ScaCRecDIcalcresult", "sca_diffcalcresult", selectField, filter.toArray(), rowMeta);
    }
}

