/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.finish;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.wip.input.CalcDataArgs;

public class FinisCalcProcessor {
    protected static void addUpdateDiffToResult(CalcDataArgs args, Set<Object> costObjects) {
        DynamicObject[] wipCalcResults;
        HashMap prodCostDiffInfoMap = new HashMap();
        ArrayList<QFilter> costupdateeQF = new ArrayList<QFilter>();
        costupdateeQF.add(new QFilter("productentry.org", "=", args.getOrgId()));
        costupdateeQF.add(new QFilter("productentry.period", "=", args.getPeriodId()));
        costupdateeQF.add(new QFilter("productentry.costaccountbook", "=", args.getCostAcctId()));
        if (args.getCostCenterIds() != null) {
            costupdateeQF.add(new QFilter("productentry.costcenter", "in", args.getCostCenterIds()));
        }
        costupdateeQF.add(new QFilter("productentry.costobject", "in", costObjects));
        String selectFields = "productentry.org org,productentry.costaccountbook costaccountbook,productentry.costcenter costcenter,productentry.costobject costobject,productentry.calcbasis calcbasis,productentry.procelement.masterid procelement,productentry.procsubelement.masterid procsubelement,productentry.prosubmaterial.masterid prosubmaterial,productentry.promatversion.id promatversion,productentry.proauxpty.id proauxpty,productentry.resource resource,productentry.updatediff updatediff";
        DataSet rows = QueryServiceHelper.queryDataSet((String)"CalcHelper", (String)"cad_costupdateestablished", (String)selectFields, (QFilter[])costupdateeQF.toArray(new QFilter[0]), null);
        for (Row row : rows) {
            StringBuilder key = new StringBuilder();
            List<String> keyFields = Arrays.asList("org", "costaccountbook", "costcenter", "costobject");
            keyFields.forEach(p -> key.append(row.getString(p)).append("@"));
            String calcBasis = "".equals(row.getString("calcbasis")) ? "0" : row.getString("calcbasis");
            String diffInfoKey = "2@" + row.getString("procelement") + "@" + row.getString("procsubelement") + "@" + row.getString("prosubmaterial") + "@" + row.getString("promatversion") + "@" + row.getString("proauxpty") + "@" + row.get("resource") + "@" + calcBasis;
            String diffInfoKey1 = "1@" + row.getString("procelement") + "@" + row.getString("procsubelement") + "@" + row.getString("prosubmaterial") + "@" + row.getString("promatversion") + "@" + row.getString("proauxpty") + "@" + row.get("resource") + "@" + calcBasis;
            BigDecimal diffcost = row.getBigDecimal("updatediff");
            if (BigDecimal.ZERO.compareTo(diffcost) == 0) continue;
            if (!prodCostDiffInfoMap.containsKey(key.toString())) {
                HashMap<String, BigDecimal> diffInfos = new HashMap<String, BigDecimal>();
                diffInfos.put(diffInfoKey, diffcost);
                diffInfos.put(diffInfoKey1, diffcost);
                prodCostDiffInfoMap.put(key.toString(), diffInfos);
                continue;
            }
            if (!((Map)prodCostDiffInfoMap.get(key.toString())).containsKey(diffInfoKey)) {
                ((Map)prodCostDiffInfoMap.get(key.toString())).put(diffInfoKey, diffcost);
                ((Map)prodCostDiffInfoMap.get(key.toString())).put(diffInfoKey1, diffcost);
                continue;
            }
            BigDecimal newDiffcost = ((BigDecimal)((Map)prodCostDiffInfoMap.get(key.toString())).get(diffInfoKey)).add(diffcost);
            ((Map)prodCostDiffInfoMap.get(key.toString())).put(diffInfoKey, newDiffcost);
            ((Map)prodCostDiffInfoMap.get(key.toString())).put(diffInfoKey1, newDiffcost);
        }
        costupdateeQF.clear();
        costupdateeQF.add(new QFilter("org", "=", args.getOrgId()));
        costupdateeQF.add(new QFilter("period", "=", args.getPeriodId()));
        costupdateeQF.add(new QFilter("costaccount", "=", args.getCostAcctId()));
        costupdateeQF.add(new QFilter("costobject", "in", costObjects));
        String selectedFields = "org,costaccount.id,period.id,costcenter.id,costobject.id,entryentity.element,entryentity.subelement,entryentity.pdstartamount,entryentity.pdendamount,entryentity.datatype,entryentity.caltype,entryentity.difftype,entryentity.material,entryentity.auxpty,entryentity.matversion,entryentity.resource,entryentity.calcbasis,entryentity.pdcurramount,entryentity.pdendamount,entryentity.costupdatediffamt";
        for (DynamicObject wipCalcResult : wipCalcResults = BusinessDataServiceHelper.load((String)"sca_calcresult", (String)selectedFields, (QFilter[])costupdateeQF.toArray(new QFilter[0]))) {
            Map diffInfos;
            DynamicObjectCollection wipCalcResultEntrys = wipCalcResult.getDynamicObjectCollection("entryentity");
            StringBuilder key = new StringBuilder();
            List<String> keyFields = Arrays.asList("org.id", "costaccount.id", "costcenter.id", "costobject.id");
            keyFields.forEach(p -> key.append(wipCalcResult.getString(p)).append("@"));
            if (!prodCostDiffInfoMap.containsKey(key.toString()) || (diffInfos = (Map)prodCostDiffInfoMap.get(key.toString())) == null || diffInfos.size() == 0) continue;
            for (Map.Entry entrySet : diffInfos.entrySet()) {
                String[] diffInfosStrs = ((String)entrySet.getKey()).split("@");
                BigDecimal diffcost = (BigDecimal)entrySet.getValue();
                if (diffcost == null || BigDecimal.ZERO.compareTo(diffcost) == 0) continue;
                DynamicObject entry = wipCalcResultEntrys.addNew();
                entry.set("caltype", (Object)3);
                entry.set("datatype", (Object)diffInfosStrs[0]);
                entry.set("difftype", (Object)"3");
                entry.set("element", (Object)diffInfosStrs[1]);
                entry.set("subelement", (Object)diffInfosStrs[2]);
                entry.set("material", diffInfosStrs[3] == null ? Long.valueOf(0L) : diffInfosStrs[3]);
                entry.set("auxpty", diffInfosStrs[4] == null ? Long.valueOf(0L) : diffInfosStrs[4]);
                entry.set("matversion", diffInfosStrs[5] == null ? Long.valueOf(0L) : diffInfosStrs[5]);
                entry.set("resource", diffInfosStrs[6] == null ? Long.valueOf(0L) : diffInfosStrs[6]);
                entry.set("calcbasis", (Object)("0".equals(diffInfosStrs[7]) ? "" : diffInfosStrs[7]));
                entry.set("pdcurramount", (Object)diffcost);
                entry.set("pdendamount", (Object)diffcost);
                entry.set("costupdatediffamt", (Object)diffcost);
            }
            BigDecimal totalDiff = BigDecimal.ZERO;
            BigDecimal pdendTotalDiff = BigDecimal.ZERO;
            BigDecimal pdCurrTotalDiff = BigDecimal.ZERO;
            DynamicObject totalEntry = null;
            for (DynamicObject wipCalcResultEntry : wipCalcResultEntrys) {
                if ("3".equals(wipCalcResultEntry.getString("difftype")) && "2".equals(wipCalcResultEntry.getString("datatype"))) {
                    totalDiff = totalDiff.add(wipCalcResultEntry.getBigDecimal("costupdatediffamt"));
                }
                if ("2".equals(wipCalcResultEntry.getString("datatype"))) {
                    pdendTotalDiff = pdendTotalDiff.add(wipCalcResultEntry.getBigDecimal("pdendamount"));
                    pdCurrTotalDiff = pdCurrTotalDiff.add(wipCalcResultEntry.getBigDecimal("pdcurramount"));
                }
                if (!"5".equals(wipCalcResultEntry.getString("caltype"))) continue;
                totalEntry = wipCalcResultEntry;
            }
            if (totalEntry == null) continue;
            totalEntry.set("costupdatediffamt", (Object)totalDiff);
            totalEntry.set("pdendamount", (Object)pdendTotalDiff);
            totalEntry.set("pdcurramount", (Object)pdCurrTotalDiff);
        }
        SaveServiceHelper.save((DynamicObject[])wipCalcResults);
    }
}

