/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.report.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.sca.algox.report.args.OutlayCostsCompNewQueryArgs;

public class OutlayCostsCalcUnitCost2Function
extends MapFunction {
    private static final long serialVersionUID = 7067739166749300592L;
    private static final Log logger = LogFactory.getLog(OutlayCostsCalcUnitCost2Function.class);
    private RowMeta srcMeta;
    private OutlayCostsCompNewQueryArgs args;

    public OutlayCostsCalcUnitCost2Function(RowMeta rowMeta, OutlayCostsCompNewQueryArgs args) {
        this.srcMeta = rowMeta;
        this.args = args;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public RowX map(RowX row) {
        int issumrow = row.getInteger(this.srcMeta.getFieldIndex("issumrow"));
        int periodsumrow = row.getInteger(this.srcMeta.getFieldIndex("periodsumrow"));
        int ccsumrow = row.getInteger(this.srcMeta.getFieldIndex("ccsumrow"));
        int totalsumrow = row.getInteger(this.srcMeta.getFieldIndex("totalsumrow"));
        if (this.args.isNoDetails() || issumrow == 1 || ccsumrow == 1 || periodsumrow == 1 || totalsumrow == 1) {
            row.set(this.srcMeta.getFieldIndex("startqty"), (Object)row.getBigDecimal(this.srcMeta.getFieldIndex("startqtys")));
            row.set(this.srcMeta.getFieldIndex("currqty"), (Object)row.getBigDecimal(this.srcMeta.getFieldIndex("currqtys")));
            row.set(this.srcMeta.getFieldIndex("compqty"), (Object)row.getBigDecimal(this.srcMeta.getFieldIndex("compqtys")));
            row.set(this.srcMeta.getFieldIndex("totalqty"), (Object)row.getBigDecimal(this.srcMeta.getFieldIndex("totalqtys")));
            row.set(this.srcMeta.getFieldIndex("endqty"), (Object)row.getBigDecimal(this.srcMeta.getFieldIndex("endqtys")));
            if (issumrow == 1) {
                row.set(this.srcMeta.getFieldIndex("materialname"), row.get(this.srcMeta.getFieldIndex("proMatName")));
                row.set(this.srcMeta.getFieldIndex("materialnumber"), row.get(this.srcMeta.getFieldIndex("proNumber")));
                row.set(this.srcMeta.getFieldIndex("baseunit"), row.get(this.srcMeta.getFieldIndex("proMatUnitId")));
                row.set(this.srcMeta.getFieldIndex("matversion"), row.get(this.srcMeta.getFieldIndex("proMatVerId")));
                row.set(this.srcMeta.getFieldIndex("auxpty"), row.get(this.srcMeta.getFieldIndex("proMatAuxId")));
            } else if (ccsumrow == 1) {
                row.set(this.srcMeta.getFieldIndex("materialname"), (Object)ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5408\u8ba1", (String)"OutlayCostsCalcUnitCost2Function_0", (String)"macc-sca-algox", (Object[])new Object[0]));
                row.set(this.srcMeta.getFieldIndex("baseunit"), (Object)0L);
                row.set(this.srcMeta.getFieldIndex("matversion"), (Object)0L);
                row.set(this.srcMeta.getFieldIndex("auxpty"), (Object)0L);
            } else if (periodsumrow == 1) {
                row.set(this.srcMeta.getFieldIndex("materialname"), (Object)ResManager.loadKDString((String)"\u671f\u95f4\u5408\u8ba1", (String)"OutlayCostsCalcUnitCost2Function_1", (String)"macc-sca-algox", (Object[])new Object[0]));
                row.set(this.srcMeta.getFieldIndex("baseunit"), (Object)0L);
                row.set(this.srcMeta.getFieldIndex("matversion"), (Object)0L);
                row.set(this.srcMeta.getFieldIndex("auxpty"), (Object)0L);
            } else if (totalsumrow == 1) {
                row.set(this.srcMeta.getFieldIndex("materialname"), (Object)ResManager.loadKDString((String)"\u603b\u5408\u8ba1", (String)"OutlayCostsCalcUnitCost2Function_2", (String)"macc-sca-algox", (Object[])new Object[0]));
                row.set(this.srcMeta.getFieldIndex("baseunit"), (Object)0L);
                row.set(this.srcMeta.getFieldIndex("matversion"), (Object)0L);
                row.set(this.srcMeta.getFieldIndex("auxpty"), (Object)0L);
            }
        }
        this.setDiffSum("start", row);
        this.setDiffSum("curr", row);
        this.setDiffSum("comp", row);
        this.setDiffSum("end", row);
        this.setDiffSum("total", row);
        this.setPrice("start", row);
        this.setPrice("curr", row);
        this.setPrice("comp", row);
        this.setPrice("end", row);
        this.setPrice("total", row);
        if (ccsumrow == 1 || periodsumrow == 1 || totalsumrow == 1) {
            row.set(this.srcMeta.getFieldIndex("currprice"), (Object)BigDecimal.ZERO);
            row.set(this.srcMeta.getFieldIndex("curractcostupprice"), (Object)BigDecimal.ZERO);
            row.set(this.srcMeta.getFieldIndex("compprice"), (Object)BigDecimal.ZERO);
            row.set(this.srcMeta.getFieldIndex("compactcostupprice"), (Object)BigDecimal.ZERO);
            row.set(this.srcMeta.getFieldIndex("startprice"), (Object)BigDecimal.ZERO);
            row.set(this.srcMeta.getFieldIndex("startactcostupprice"), (Object)BigDecimal.ZERO);
            row.set(this.srcMeta.getFieldIndex("endprice"), (Object)BigDecimal.ZERO);
            row.set(this.srcMeta.getFieldIndex("endactcostupprice"), (Object)BigDecimal.ZERO);
            row.set(this.srcMeta.getFieldIndex("totalprice"), (Object)BigDecimal.ZERO);
            row.set(this.srcMeta.getFieldIndex("totalactcostupprice"), (Object)BigDecimal.ZERO);
        }
        return row;
    }

    private BigDecimal getOrZero(Object object) {
        if (object == null || !(object instanceof BigDecimal)) {
            return BigDecimal.ZERO;
        }
        return (BigDecimal)object;
    }

    private void setDiffSum(String dataPre, RowX row) {
        BigDecimal compdiffsum = this.getOrZero(row.get(this.srcMeta.getFieldIndex(dataPre + "diffqty"))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex(dataPre + "madediff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex(dataPre + "madeupamt")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex(dataPre + "unjoindiffamt")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex(dataPre + "stdcostupamt")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex(dataPre + "orddiff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex(dataPre + "invoicediff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex(dataPre + "feediff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex(dataPre + "falldiff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex(dataPre + "otherdiff"))));
        row.set(this.srcMeta.getFieldIndex(dataPre + "diffsum"), (Object)compdiffsum);
    }

    private void setPrice(String dataPre, RowX row) {
        BigDecimal compamt = this.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex(dataPre + "amt")));
        BigDecimal compqtys = this.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("tmp" + dataPre + "qtys")));
        if (compqtys.compareTo(BigDecimal.ZERO) == 0) {
            compqtys = row.getBigDecimal(this.srcMeta.getFieldIndex(dataPre + "qtys"));
        }
        BigDecimal compactcostupamt = this.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex(dataPre + "actcostupamt")));
        if (compqtys != null && compqtys.compareTo(BigDecimal.ZERO) > 0) {
            if (compamt != null) {
                BigDecimal compprice = compamt.divide(compqtys, this.args.getPriceSacle(), RoundingMode.HALF_UP);
                row.set(this.srcMeta.getFieldIndex(dataPre + "price"), (Object)compprice);
            }
            if (compactcostupamt != null) {
                BigDecimal compactcostupprice = compactcostupamt.divide(compqtys, this.args.getPriceSacle(), RoundingMode.HALF_UP);
                row.set(this.srcMeta.getFieldIndex(dataPre + "actcostupprice"), (Object)compactcostupprice);
            }
        }
    }
}

