/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.dto.MaterialCodeDto;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CommonUtils;

public class CalServiceHelper {
    private static final Log logger = LogFactory.getLog(CalServiceHelper.class);
    private static final String ALGOKEY_PRE = "DiffCalc-";
    public static final String DEFAULT_DIFFCOL = "calorg";
    public static final String CAL_DBPARAM = "cal_dbparam";
    public static final String[] DIFFMATERIAL_DIM_COLS = new String[]{"material", "auxpty", "configuredcode", "tracknumber", "project", "lot"};
    public static final String[] DIFFMATERIAL_COLS = new String[]{"material", "matversion", "auxpty", "configuredcode", "tracknumber", "project", "lot"};
    private static final Set<String> completedTaskStatus = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("COMPLETED");
            this.add("FAILED");
            this.add("TIMEOUT");
            this.add("ABORTED");
            this.add("SKIP");
        }
    };

    public static boolean isBizGroupModel() {
        QFilter filter = new QFilter("key", "=", (Object)"enable_bizgroup_model");
        Map map = BusinessDataServiceHelper.loadFromCache((String)CAL_DBPARAM, (QFilter[])filter.toArray());
        if (map == null || map.isEmpty()) {
            return false;
        }
        DynamicObject paramInfo = (DynamicObject)map.values().iterator().next();
        if (paramInfo == null) {
            return false;
        }
        return Boolean.parseBoolean(paramInfo.getString("value"));
    }

    public static boolean isGroupDiffBill() {
        QFilter filter = new QFilter("key", "=", (Object)"isgroupdiffbill");
        filter.and("value", "=", (Object)"true");
        return QueryServiceHelper.exists((String)CAL_DBPARAM, (QFilter[])filter.toArray());
    }

    public static void deleteCalDiffBillsV2(DiffCalcDataArgs args, Set<Long> allCalcMat) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)10);
        param.put("costaccount", args.getCostaccountId());
        if (args.isSpecifyMatCalc()) {
            param.put("materials", allCalcMat);
        }
        try {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"DiffAllocService", (String)"deleteDiffBill", (Object[])new Object[]{param});
        }
        catch (Exception e) {
            String errorMsg = ResManager.loadKDString((String)"\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1deleteDiffBill\u7684deleteDiffBill\u65b9\u6cd5\u5931\u8d25\u3002", (String)"CalServiceHelper_8", (String)"macc-sca-algox", (Object[])new Object[0]);
            if (e instanceof KDBizException) {
                errorMsg = e.getMessage();
            }
            logger.error("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684deleteDiffBill\u65b9\u6cd5\u5931\u8d25\u3002", (Throwable)e);
            ErrorCode errorCode = new ErrorCode("cal", errorMsg);
            throw new KDBizException((Throwable)e, errorCode, new Object[0]);
        }
    }

    public static void deleteCalDiffBills(DiffCalcDataArgs args, Collection<MaterialCodeDto> allmats, Set<Long> allCalcMat, Set<String> diffMatLvlDim, Map<Long, Set<Long>> matAuxptysMap) {
        Long periodId = args.getPeriodId();
        Long costAccountId = args.getCostaccountId();
        HashSet<Long> materialids = new HashSet<Long>(16);
        materialids.add(0L);
        materialids.addAll(allCalcMat);
        QFilter filter = new QFilter("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("costaccount.id", "=", (Object)costAccountId);
        filter.and("billsrctype", "=", (Object)"D");
        filter.and("isvoucher", "=", (Object)"0");
        filter.and("ischargeoffed", "=", (Object)Boolean.FALSE);
        filter.and("ischargeoff", "=", (Object)Boolean.FALSE);
        if (args.isSpecifyMatCalc()) {
            filter.and("entryentity.material.id", "in", allCalcMat);
        }
        String selectField = "id,entryentity.material.id as material,entryentity.accounttype as accounttype";
        if (args.isSpecifyMatCalc()) {
            selectField = selectField + ",entryentity.assist auxpty,entryentity.configuredcode configuredcode,entryentity.tracknumber tracknumber,entryentity.lot lot,entryentity.project project ";
        }
        DataSet bills = QueryServiceHelper.queryDataSet((String)"DiffCalc-costadjustbill", (String)"cal_stdcostdiffbill", (String)selectField, (QFilter[])new QFilter[]{filter}, null);
        if (args.isSpecifyMatCalc()) {
            DataSet matDimDs = null;
            matDimDs = diffMatLvlDim.contains("auxpty") ? DiffCalcHelper.getDimMatAndDealAuxptyDsFromLvl(allmats, matAuxptysMap) : DiffCalcHelper.getDimMatDsFromLvl(allmats);
            bills = DiffCalcHelper.joinDimMatDsToFilterDs(bills, matDimDs, diffMatLvlDim);
        }
        ArrayList<Long> billids = new ArrayList<Long>(16);
        ArrayList<Long> actCostBillIds = new ArrayList<Long>(16);
        for (Row bill : bills) {
            if ("D".equals(bill.getString("accounttype"))) {
                billids.add(bill.getLong("id"));
                materialids.add(bill.getLong("material"));
                continue;
            }
            actCostBillIds.add(bill.getLong("id"));
        }
        CalServiceHelper.deleteActAdjustBill(actCostBillIds);
        boolean isNewPeriodBal = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalanceService", (String)"isNewPeriodBal", null);
        if (isNewPeriodBal) {
            CalServiceHelper.deleteNewBalaActAdjustBill(billids);
        } else {
            CalServiceHelper.deleteAdjBillBySql(billids);
            if (args.isSpecifyMatCalc()) {
                CalServiceHelper.recalPurDiffBatch(costAccountId, periodId, allCalcMat);
                CalServiceHelper.recalCalcBalanceBatch(costAccountId, periodId, allCalcMat, args.getParallel());
            } else {
                CalServiceHelper.recalPurDiffBatch(costAccountId, periodId, materialids);
                CalServiceHelper.recalCalcBalanceBatch(costAccountId, periodId, materialids, args.getParallel());
            }
        }
    }

    private static void deleteActAdjustBill(List<Long> auditBillIds) {
        if (CadEmptyUtils.isEmpty(auditBillIds)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", auditBillIds);
        filter.and("billstatus", "=", (Object)"C");
        DataSet bills = QueryServiceHelper.queryDataSet((String)"DiffCalc-costadjustbill1", (String)"cal_stdcostdiffbill", (String)"id", (QFilter[])new QFilter[]{filter}, null);
        ArrayList<Long> auditBills = new ArrayList<Long>(16);
        for (Row bill : bills) {
            auditBills.add(bill.getLong("id"));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("diffAlloc", "true");
        option.setVariableValue("ignoreValidation", "true");
        Lists.partition(auditBills, (int)2000).forEach(list -> {
            long beginTime = System.currentTimeMillis();
            OperationResult operResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_stdcostdiffbill", (Object[])list.toArray(), (OperateOption)option);
            List idList = operResult.getSuccessPkIds();
            if (operResult.isSuccess()) {
                QFilter deleFilter = new QFilter("id", "in", (Object)idList);
                DeleteServiceHelper.delete((String)"cal_stdcostdiffbill", (QFilter[])deleFilter.toArray());
            } else if (operResult.getAllErrorOrValidateInfo() != null && !operResult.getAllErrorOrValidateInfo().isEmpty()) {
                ArrayList<String> errors = new ArrayList<String>(operResult.getAllErrorOrValidateInfo().size());
                for (IOperateInfo operatorInfo : operResult.getAllErrorOrValidateInfo()) {
                    errors.add(operatorInfo.getMessage());
                }
                logger.error("----------ServiceHelper.deleteActAdjustBill->delete fail:" + ((Object)errors).toString());
            }
            long endTime = System.currentTimeMillis();
            logger.info("--------------ServiceHelper.deleteActAdjustBill->delete lot adjBillList size:" + list.size());
            logger.info("--------------ServiceHelper.deleteActAdjustBill->delete lot adjBillList time:" + (endTime - beginTime));
        });
        QFilter filter1 = new QFilter("id", "in", auditBillIds);
        filter1.and("billstatus", "!=", (Object)"C");
        DataSet deleteBills = QueryServiceHelper.queryDataSet((String)"DiffCalc-costadjustbill2", (String)"cal_stdcostdiffbill", (String)"id", (QFilter[])new QFilter[]{filter1}, null);
        ArrayList<Long> deleteBillIds = new ArrayList<Long>(16);
        for (Row deletebill : deleteBills) {
            deleteBillIds.add(deletebill.getLong("id"));
        }
        QFilter deleFilter = new QFilter("id", "in", deleteBillIds);
        DeleteServiceHelper.delete((String)"cal_stdcostdiffbill", (QFilter[])deleFilter.toArray());
    }

    public static void deleteAdjBillBySql(List<Long> adjBillIds) {
        logger.info("--------------ServiceHelper.deleteAdjBillBySql >delete all adjBillsList size:{}", (Object)adjBillIds.size());
        StringBuilder billIds = new StringBuilder();
        Lists.partition(adjBillIds, (int)5000).forEach(list -> {
            long beginTime = System.currentTimeMillis();
            billIds.setLength(0);
            for (Long billId : list) {
                billIds.append(",").append(billId);
            }
            String deleBillDetailSql = "delete from t_cal_costadjust_detail where fentryid in ( select fentryid from t_cal_costadjustbillentry where fid in ( " + billIds.substring(1) + "))";
            String deleBillEntrySql = " delete from t_cal_costadjustbillentry where fid in (" + billIds.substring(1) + ")";
            String deleBillSql = "delete from t_cal_costadjustbill where fid in (" + billIds.substring(1) + ")";
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)deleBillDetailSql);
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)deleBillEntrySql);
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)deleBillSql);
            long endTime = System.currentTimeMillis();
            logger.info("--------------ServiceHelper.deleteAdjBillBySql ->delete lot adjBillList size:{}", (Object)list.size());
            logger.info("--------------ServiceHelper.deleteAdjBillBySql ->delete lot adjBillList time:{}", (Object)(endTime - beginTime));
        });
    }

    private static void deleteNewBalaActAdjustBill(List<Long> billids) {
        QFilter filter = new QFilter("id", "in", billids);
        filter.and("billstatus", "=", (Object)"C");
        DataSet bills = QueryServiceHelper.queryDataSet((String)"DiffCalc-costadjustbill3", (String)"cal_stdcostdiffbill", (String)"id", (QFilter[])new QFilter[]{filter}, null);
        ArrayList<Long> auditBills = new ArrayList<Long>(16);
        for (Row bill : bills) {
            auditBills.add(bill.getLong("id"));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("diffAlloc", "true");
        option.setVariableValue("ignoreValidation", "true");
        Lists.partition(auditBills, (int)2000).forEach(list -> {
            OperationResult operResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_stdcostdiffbill", (Object[])list.toArray(), (OperateOption)option);
            if (!operResult.isSuccess() && operResult.getAllErrorOrValidateInfo() != null && !operResult.getAllErrorOrValidateInfo().isEmpty()) {
                ArrayList<String> errors = new ArrayList<String>(operResult.getAllErrorOrValidateInfo().size());
                for (IOperateInfo operatorInfo : operResult.getAllErrorOrValidateInfo()) {
                    errors.add(operatorInfo.getMessage());
                }
                logger.error("----------ServiceHelper.deleteActAdjustBill->delete fail:{}", (Object)((Object)errors).toString());
            }
        });
        QFilter filter1 = new QFilter("id", "in", billids);
        filter1.and("billstatus", "!=", (Object)"C");
        DataSet deleteBills = QueryServiceHelper.queryDataSet((String)"DiffCalc-costadjustbill4", (String)"cal_stdcostdiffbill", (String)"id", (QFilter[])new QFilter[]{filter1}, null);
        ArrayList<Long> deleteBillIds = new ArrayList<Long>(16);
        for (Row deletebill : deleteBills) {
            deleteBillIds.add(deletebill.getLong("id"));
        }
        logger.info("----------ServiceHelper.deleteActAdjustBill->billSize:{},delete Size:{}", (Object)billids.size(), (Object)deleteBillIds.size());
        QFilter deleFilter = new QFilter("id", "in", deleteBillIds);
        DeleteServiceHelper.delete((String)"cal_stdcostdiffbill", (QFilter[])deleFilter.toArray());
    }

    public static void refreshGroupRecord(DiffCalcDataArgs args) {
        block2: {
            try {
                HashSet<Long> costAccounts = new HashSet<Long>();
                costAccounts.add(args.getCostaccountId());
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"RefreshGroupRecordService", (String)"refreshGroupRecord", (Object[])new Object[]{costAccounts});
            }
            catch (Exception e) {
                logger.info("\u5dee\u5f02\u5206\u644a\u8c03\u7528\u5237\u65b0\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\u9519\u8bef:", (Object)e);
                if (!(e instanceof KDBizException) || !"refresActGroupRunning".equals(((KDBizException)e).getErrorCode().getCode())) break block2;
                throw new KDBizException(ResManager.loadKDString((String)"\u6b63\u5728\u5237\u65b0\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u8ba1\u7b97\u3002", (String)"CalServiceHelper_0", (String)"macc-sca-algox", (Object[])new Object[0]));
            }
        }
    }

    public static void recalPurDiffBatch(Long costAccountId, Long periodId, Set<Long> matIds) {
        if (costAccountId == 0L || periodId == 0L || matIds == null || matIds.isEmpty()) {
            return;
        }
        try {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"ReCalcBalance", (String)"recalPurDiffBatch", (Object[])new Object[]{costAccountId, periodId, matIds});
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1ReCalcBalance\u7684recalPurDiffBatch\u65b9\u6cd5\u5931\u8d25\u3002", (Throwable)e);
            ErrorCode errorCode = new ErrorCode("cal", ResManager.loadKDString((String)"\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1recalPurDiffBatch\u7684recalPurDiffBatch\u65b9\u6cd5\u5931\u8d25\u3002", (String)"CalServiceHelper_1", (String)"macc-sca-algox", (Object[])new Object[0]));
            throw new KDBizException((Throwable)e, errorCode, new Object[0]);
        }
    }

    public static void recalCalcBalanceBatch(Long costAccountId, Long periodId, Set<Long> matIds, boolean parallel) {
        if (costAccountId == 0L || periodId == 0L || matIds == null || matIds.isEmpty()) {
            return;
        }
        try {
            if (parallel) {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"ReCalcBalance", (String)"recalCalcBalanceByTask", (Object[])new Object[]{costAccountId, periodId, matIds});
            } else {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"ReCalcBalance", (String)"recalCalcBalanceBatch", (Object[])new Object[]{costAccountId, periodId, matIds});
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1ReCalcBalance\u7684recalCalcBalanceBatch\u65b9\u6cd5\u5931\u8d25\u3002", (Throwable)e);
            ErrorCode errorCode = new ErrorCode("cal", ResManager.loadKDString((String)"\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1ReCalcBalance\u7684recalCalcBalanceBatch\u65b9\u6cd5\u5931\u8d25\u3002", (String)"CalServiceHelper_2", (String)"macc-sca-algox", (Object[])new Object[0]));
            throw new KDBizException((Throwable)e, errorCode, new Object[0]);
        }
    }

    public static void putAllMatAllocToCal(DiffCalcDataArgs args, Set<Long> allMatIds, boolean isLastLevel) {
        HashMap<String, Object> commonParam = new HashMap<String, Object>();
        commonParam.put("allocmodel", "A");
        commonParam.put("carryrule", "A");
        commonParam.put("iswriterpt", true);
        commonParam.put("iswriteerrrpt", false);
        commonParam.put("matconditiontype", "B");
        commonParam.put("runjob", false);
        commonParam.put("isFirstStep", true);
        if (args.getParallel()) {
            commonParam.put("isParallel", true);
        } else {
            commonParam.put("isParallel", false);
        }
        commonParam.put("isLastLevel", isLastLevel);
        ArrayList bizParamList = new ArrayList(16);
        HashMap<String, Object> bizParam = new HashMap<String, Object>();
        bizParam.put("costaccount", args.getCostaccountId());
        bizParam.put("materials", allMatIds);
        bizParamList.add(bizParam);
        try {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"DiffAllocService", (String)"diffAlloc", (Object[])new Object[]{commonParam, bizParamList});
            logger.info("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAlloc\u65b9\u6cd5\u6210\u529f\u3002{}", (Object)((Object)commonParam).toString());
        }
        catch (Exception ex) {
            logger.error("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAlloc\u65b9\u6cd5\u5931\u8d25\u3002", (Throwable)ex);
            ErrorCode errorCode = new ErrorCode("cal", ResManager.loadKDString((String)"\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAlloc\u65b9\u6cd5\u5931\u8d25\u3002", (String)"CalServiceHelper_4", (String)"macc-sca-algox", (Object[])new Object[0]));
            throw new KDBizException((Throwable)ex, errorCode, new Object[0]);
        }
    }

    public static void putAllMatAllocToCalV2(DiffCalcDataArgs args, List<Map<String, Object>> allMatIds, boolean isLastLevel) {
        HashMap<String, Object> commonParam = new HashMap<String, Object>();
        commonParam.put("allocmodel", "A");
        commonParam.put("carryrule", "A");
        commonParam.put("iswriterpt", true);
        commonParam.put("iswriteerrrpt", false);
        commonParam.put("matconditiontype", "B");
        commonParam.put("runjob", false);
        commonParam.put("isFirstStep", true);
        if (args.getParallel()) {
            commonParam.put("isParallel", true);
        } else {
            commonParam.put("isParallel", false);
        }
        commonParam.put("isLastLevel", isLastLevel);
        ArrayList bizParamList = new ArrayList(16);
        HashMap<String, Object> bizParam = new HashMap<String, Object>();
        bizParam.put("costaccount", args.getCostaccountId());
        bizParam.put("materials", allMatIds);
        bizParamList.add(bizParam);
        try {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"DiffAllocService", (String)"diffAllocForCal", (Object[])new Object[]{commonParam, bizParamList});
            logger.info("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAllocForCal\u65b9\u6cd5\u6210\u529f\u3002{}", (Object)((Object)commonParam).toString());
        }
        catch (Exception ex) {
            logger.error("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAllocForCal\u65b9\u6cd5\u5931\u8d25\u3002", (Throwable)ex);
            ErrorCode errorCode = new ErrorCode("cal", ResManager.loadKDString((String)"\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAllocForCal\u65b9\u6cd5\u5931\u8d25\u3002", (String)"CalServiceHelper_9", (String)"macc-sca-algox", (Object[])new Object[0]));
            throw new KDBizException((Throwable)ex, errorCode, new Object[0]);
        }
    }

    public static void putCurrMatAllocToCal(DiffCalcDataArgs args, Set<Long> curMatIds, List<List<Long>> nestMatGroups, boolean isLastLevel, List<Map<String, Object>> reworkAndNestMatFactMap) {
        if (CadEmptyUtils.isEmpty(curMatIds)) {
            return;
        }
        HashMap<String, Object> commonParam = new HashMap<String, Object>();
        commonParam.put("allocmodel", "A");
        commonParam.put("carryrule", "A");
        commonParam.put("iswriterpt", true);
        commonParam.put("iswriteerrrpt", false);
        commonParam.put("matconditiontype", "A");
        commonParam.put("runjob", false);
        commonParam.put("isFirstStep", false);
        if (args.getParallel()) {
            commonParam.put("isParallel", true);
        } else {
            commonParam.put("isParallel", false);
        }
        commonParam.put("isLastLevel", isLastLevel);
        logger.info("ServiceHelper\u4f20\u9012\u7684isLastLevel\uff1a" + isLastLevel);
        ArrayList bizParamList = new ArrayList();
        HashMap<String, Object> bizParam = new HashMap<String, Object>();
        bizParam.put("costaccount", args.getCostaccountId());
        bizParam.put("materials", curMatIds);
        bizParam.put("isDesignatedMat", args.isSpecifyMatCalc());
        bizParam.put("finishedQtyInfoList", reworkAndNestMatFactMap);
        ArrayList<HashSet> nestMatGroupParams = new ArrayList<HashSet>();
        if (!CadEmptyUtils.isEmpty(nestMatGroups)) {
            for (List<Long> nestMatGroup : nestMatGroups) {
                if (nestMatGroup.isEmpty()) continue;
                HashSet nestMatGroupParam = Sets.newHashSetWithExpectedSize((int)nestMatGroup.size());
                nestMatGroupParam.addAll(nestMatGroup);
                nestMatGroupParams.add(nestMatGroupParam);
            }
        }
        bizParam.put("circlemats", nestMatGroupParams);
        bizParamList.add(bizParam);
        try {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"DiffAllocService", (String)"diffAlloc", (Object[])new Object[]{commonParam, bizParamList});
        }
        catch (Exception ex) {
            logger.error("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAlloc\u65b9\u6cd5\u5931\u8d25\u3002", (Throwable)ex);
            ErrorCode errorCode = new ErrorCode("cal", ResManager.loadKDString((String)"\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAlloc\u65b9\u6cd5\u5931\u8d25\u3002", (String)"CalServiceHelper_4", (String)"macc-sca-algox", (Object[])new Object[0]));
            throw new KDBizException((Throwable)ex, errorCode, new Object[0]);
        }
    }

    public static void putCurrMatAllocToCalV2(DiffCalcDataArgs args, List<Map<String, Object>> curMatIds, List<List<Map<String, Object>>> nestMatGroups, boolean isLastLevel, List<Map<String, Object>> reworkAndNestMatFactMap, String nestMatUseQtyDsCache, String nestPreDiffDsCache, boolean onlyAdjustDiff) {
        if (CadEmptyUtils.isEmpty(curMatIds)) {
            if (curMatIds == null) {
                curMatIds = new ArrayList<Map<String, Object>>(10);
            }
            HashMap matParamMap = Maps.newHashMapWithExpectedSize((int)2);
            matParamMap.put("material", 1L);
            curMatIds.add(matParamMap);
        }
        HashMap<String, Object> commonParam = new HashMap<String, Object>();
        commonParam.put("allocmodel", "A");
        commonParam.put("carryrule", "A");
        commonParam.put("iswriterpt", true);
        commonParam.put("iswriteerrrpt", false);
        commonParam.put("matconditiontype", "A");
        commonParam.put("runjob", false);
        commonParam.put("isFirstStep", false);
        if (onlyAdjustDiff) {
            commonParam.put("onlyAdjustDiff", true);
        }
        if (args.getParallel()) {
            commonParam.put("isParallel", true);
        } else {
            commonParam.put("isParallel", false);
        }
        commonParam.put("isLastLevel", isLastLevel);
        logger.info("ServiceHelper\u4f20\u9012\u7684isLastLevel\uff1a" + isLastLevel);
        logger.info("ServiceHelper\u4f20\u9012\u7684nestMatUseQtyDsCacheId\uff1a" + nestMatUseQtyDsCache);
        logger.info("ServiceHelper\u4f20\u9012\u7684nestPreDiffDsCache\uff1a" + nestPreDiffDsCache);
        ArrayList bizParamList = new ArrayList();
        HashMap<String, Object> bizParam = new HashMap<String, Object>();
        bizParam.put("costaccount", args.getCostaccountId());
        bizParam.put("materials", curMatIds);
        bizParam.put("isDesignatedMat", args.isSpecifyMatCalc());
        if (nestMatUseQtyDsCache == null && nestPreDiffDsCache == null) {
            bizParam.put("finishedQtyInfoList", reworkAndNestMatFactMap);
        }
        bizParam.put("nestMatUseQtyDsCache", nestMatUseQtyDsCache);
        bizParam.put("nestPreDiffDsCache", nestPreDiffDsCache);
        logger.info("\u5d4c\u5957\u7ec4DataSetId  nestPreDiffDsCache:{} nestMatUseQtyDsCacheId:{}", (Object)nestPreDiffDsCache, (Object)nestMatUseQtyDsCache);
        bizParam.put("circlemats", nestMatGroups);
        bizParamList.add(bizParam);
        try {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"DiffAllocService", (String)"diffAlloc", (Object[])new Object[]{commonParam, bizParamList});
        }
        catch (Exception ex) {
            logger.error("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAlloc\u65b9\u6cd5\u5931\u8d25\u3002", (Throwable)ex);
            ErrorCode errorCode = new ErrorCode("cal", ResManager.loadKDString((String)"\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAlloc\u65b9\u6cd5\u5931\u8d25\u3002", (String)"CalServiceHelper_4", (String)"macc-sca-algox", (Object[])new Object[0]));
            throw new KDBizException((Throwable)ex, errorCode, new Object[0]);
        }
    }

    public static void recalCalcBalance(DiffCalcDataArgs args, Set<Long> allmatIds) {
        Long periodId = args.getPeriodId();
        Long costAccountId = args.getCostaccountId();
        QFilter filter = new QFilter("period.id", "=", (Object)periodId);
        filter.and("costaccount.id", "=", (Object)costAccountId);
        filter.and("billsrctype", "=", (Object)"D");
        if (args.isSpecifyMatCalc()) {
            filter.and("entryentity.material.id", "in", allmatIds);
        }
        DataSet bills = QueryServiceHelper.queryDataSet((String)"DiffCalc-costadjust", (String)"cal_stdcostdiffbill", (String)"id,entryentity.material.id as materialid", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> materialids = new HashSet<Long>(16);
        materialids.add(0L);
        for (Row bill : bills) {
            materialids.add(bill.getLong("materialid"));
        }
        CalServiceHelper.recalCalcBalanceBatch(costAccountId, periodId, materialids, args.getParallel());
        CalServiceHelper.recalPurDiffBatch(costAccountId, periodId, materialids);
    }

    public static void transOutCostDiffInfoToCalSystem(DiffCalcDataArgs args, Set<Map<String, Object>> stdCostDiffBillSet) {
        if (stdCostDiffBillSet == null || stdCostDiffBillSet.isEmpty()) {
            return;
        }
        if (args.getParallel()) {
            CalServiceHelper.transOutBillByTask(stdCostDiffBillSet);
        } else {
            CalServiceHelper.transOutBill(stdCostDiffBillSet);
        }
    }

    private static void transOutBill(Set<Map<String, Object>> stdCostDiffBillSet) {
        try {
            long start = System.currentTimeMillis();
            if (!stdCostDiffBillSet.isEmpty()) {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalStandardCostDiffBillService", (String)"buildDiffBill", (Object[])new Object[]{stdCostDiffBillSet});
            }
            logger.info("\u5dee\u5f02\u8f6c\u51fa\u8c03\u7528\u5b58\u8d27\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u751f\u6210\u63a5\u53e3\u6210\u529f,\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception ex) {
            logger.error("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u751f\u6210\u63a5\u53e3CalStandardCostDiffBillService.buildDiffBill\u5931\u8d25\u3002", (Throwable)ex);
            ErrorCode errorCode = new ErrorCode("cal", ResManager.loadKDString((String)"\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u751f\u6210\u63a5\u53e3CalStandardCostDiffBillService.buildDiffBill\u5931\u8d25\u3002", (String)"CalServiceHelper_5", (String)"macc-sca-algox", (Object[])new Object[0]));
            throw new KDBizException((Throwable)ex, errorCode, new Object[0]);
        }
    }

    private static void transOutBillByTask(Set<Map<String, Object>> stdCostDiffBillSet) {
        List<Set<Map<String, Object>>> batchList = CalServiceHelper.spritBatch(stdCostDiffBillSet);
        int size = batchList.size();
        logger.info("CalServiceHelper_transOutBillByTask_batchList.size:{}", (Object)size);
        ArrayList<Long> paramIds = new ArrayList<Long>(10);
        ArrayList<DynamicObject> paramDyns = new ArrayList<DynamicObject>(10);
        for (Set<Map<String, Object>> currBatchDm : batchList) {
            paramIds.add(CalServiceHelper.genParParamDynId("diffout", currBatchDm, paramDyns));
            currBatchDm.clear();
        }
        SaveServiceHelper.save((DynamicObject[])paramDyns.toArray(new DynamicObject[0]));
        int batchIndex = 1;
        HashSet<String> taskIds = new HashSet<String>(16);
        taskIds.add("12321412");
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - 1);
        QFilter taskFilter = new QFilter("id", "in", taskIds);
        taskFilter.and("status", "=", (Object)"BEGIN");
        taskFilter.and("runtime", ">=", (Object)calendar.getTime());
        for (Long paramId : paramIds) {
            taskIds.add(CalServiceHelper.sendTask(paramId, size, batchIndex++));
        }
        logger.info("CalServiceHelper_transOutBillByTask_taskIds.size:{}", (Object)taskIds.size());
        while (true) {
            QFilter completedFilter = new QFilter("id", "in", taskIds);
            completedFilter.and("status", "in", completedTaskStatus);
            DynamicObjectCollection runningTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])completedFilter.toArray());
            if (runningTasks.size() == size) {
                QFilter failTtaskFilter = new QFilter("id", "in", taskIds);
                failTtaskFilter.and("status", "=", (Object)"FAILED");
                DynamicObjectCollection failTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])failTtaskFilter.toArray());
                if (failTasks != null && failTasks.size() > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u901a\u8fc7\u540e\u53f0\u4efb\u52a1\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u751f\u6210\u63a5\u53e3ServiceHelper.transOutBillByTask\u5931\u8d25\u3002", (String)"CalServiceHelper_6", (String)"macc-sca-algox", (Object[])new Object[0]));
                }
                QFilter filter = new QFilter("id", "in", paramIds);
                DeleteServiceHelper.delete((String)"sca_parparam", (QFilter[])filter.toArray());
                return;
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error((Throwable)e);
                continue;
            }
            break;
        }
    }

    protected static Long genParParamDynId(String type, Object param, List<DynamicObject> dyns) {
        Long id = ID.genLongId();
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"sca_parparam");
        dyn.set("id", (Object)id);
        dyn.set("type", (Object)type);
        dyn.set("createtime", (Object)TimeServiceHelper.now());
        dyn.set("param_tag", (Object)SerializationUtils.toJsonString((Object)param));
        dyns.add(dyn);
        return id;
    }

    private static List<Set<Map<String, Object>>> spritBatch(Set<Map<String, Object>> partialDms) {
        ArrayList<Set<Map<String, Object>>> batchList = new ArrayList<Set<Map<String, Object>>>(16);
        if (partialDms == null) {
            return batchList;
        }
        HashMap<Long, Set> matparams = new HashMap<Long, Set>(16);
        for (Map<String, Object> partialDm : partialDms) {
            Long matId = Long.valueOf(partialDm.get("material").toString());
            matparams.computeIfAbsent(matId, t -> new HashSet()).add(partialDm);
        }
        int batch = CadBgParamUtils.getCadParamForInt((String)"scaTranoutBatchSize", (int)2000);
        HashSet<Map> currBatchDms = null;
        for (Map.Entry partialDm : matparams.entrySet()) {
            for (Map map : (Set)partialDm.getValue()) {
                if (currBatchDms == null || currBatchDms.size() >= batch) {
                    currBatchDms = new HashSet<Map>(16);
                    batchList.add(currBatchDms);
                }
                currBatchDms.add(map);
            }
        }
        return batchList;
    }

    private static String sendTask(Long paramId, int totalBatch, int currbatch) {
        HashMap<String, Object> jobParams = new HashMap<String, Object>();
        jobParams.put("paramId", paramId);
        jobParams.put("batchInfo", currbatch + "/" + totalBatch);
        String appId = "sca";
        String taskClass = "kd.macc.sca.algox.task.CalStandardCostDiffBillTask";
        long timestamp = System.currentTimeMillis();
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        String opName = ResManager.loadKDString((String)"\u751f\u6210\u8f6c\u51fa\u5355\u3010{0}\u3011\uff0c\u7b2c\u3010{1}\u3011\u6279\uff0c\u5f00\u59cb\u6267\u884c\u64cd\u4f5c\u4eba:{2}", (String)"CalServiceHelper_7", (String)"macc-sca-algox", (Object[])new Object[0]);
        opName = MessageFormat.format(opName, "TraceId:" + RequestContext.get().getTraceId() + "/timestamp:" + timestamp, currbatch + "/" + totalBatch, RequestContext.get().getUserName());
        job.setName(opName);
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId(appId);
        job.setTaskClassname(taskClass);
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        return JobClient.dispatch((JobInfo)job);
    }

    public static String getDiffAllocDimConfig(Long orgId) {
        String diffAllocDims = (String)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)orgId, (Long)0L, (String)"diffalloccols");
        if (StringUtils.isEmpty((String)diffAllocDims)) {
            diffAllocDims = DEFAULT_DIFFCOL;
        }
        return diffAllocDims;
    }

    public static Set<String> getDiffMaterialCalcDim(Long orgId) {
        String diffAllocDims = CalServiceHelper.getDiffAllocDimConfig(orgId);
        String[] diffAllocDimArr = diffAllocDims.split(",");
        HashSet<String> pamFields = new HashSet<String>(10);
        pamFields.add("material");
        for (String dim : diffAllocDimArr) {
            if (StringUtils.isBlank((String)dim)) continue;
            pamFields.add(dim);
        }
        if (pamFields.remove("assist")) {
            pamFields.add("auxpty");
        }
        TreeSet<String> diffDim = new TreeSet<String>(Arrays.asList(DIFFMATERIAL_DIM_COLS));
        pamFields.retainAll(diffDim);
        return pamFields;
    }

    public static String getDiffAllocDimsAlias(String billEntityNumber, String[] allodDims, String preFalg) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntityNumber);
        StringBuilder selectFields = new StringBuilder();
        for (String field : allodDims) {
            IDataEntityProperty property;
            if (StringUtils.isEmpty((String)field) || (property = entityType.findProperty(field)) == null) continue;
            IDataEntityType parentProp = property.getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            if (entityType.findProperty(field) instanceof BasedataProp) {
                if (isEntryProp) {
                    selectFields.append(",");
                    selectFields.append(parentProp.getName());
                    selectFields.append(".");
                    selectFields.append(field);
                    selectFields.append(".");
                    selectFields.append("id");
                    selectFields.append(" as ");
                    selectFields.append(preFalg);
                    selectFields.append(field);
                    continue;
                }
                selectFields.append(",");
                selectFields.append(field);
                selectFields.append(".");
                selectFields.append("id");
                selectFields.append(" as ");
                selectFields.append(preFalg);
                selectFields.append(field);
                continue;
            }
            if (isEntryProp) {
                selectFields.append(",");
                selectFields.append(parentProp.getName());
                selectFields.append(".");
                selectFields.append(field);
                selectFields.append(" as ");
                selectFields.append(preFalg);
                selectFields.append(field);
                continue;
            }
            selectFields.append(",");
            selectFields.append(field);
            selectFields.append(" as ");
            selectFields.append(preFalg);
            selectFields.append(field);
        }
        return selectFields.toString();
    }

    public static String ficalReCalculateCheck(long reportId, Date checkdate, DiffCalcDataArgs args) {
        HashMap checkParam = Maps.newHashMapWithExpectedSize((int)16);
        checkParam.put("org", args.getOrgId());
        checkParam.put("costAccount", args.getCostaccountId());
        checkParam.put("periodId", args.getPeriodId());
        checkParam.put("checkDate", checkdate);
        checkParam.put("reportId", reportId);
        try {
            long start = System.currentTimeMillis();
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"DiffAllocService", (String)"diffReCalculateCheck", (Object[])new Object[]{checkParam});
            if (result != null) {
                int code;
                int n = code = result.get("status") != null ? Integer.parseInt((String)result.get("status")) : 200;
                if (code != 200) {
                    return (String)result.get("msg");
                }
            }
            logger.info("\u5dee\u5f02\u5206\u644a\u7ee7\u7eed\u8ba1\u7b97-\u5b58\u8d27\u68c0\u67e5\u63a5\u53e3\uff0c\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception ex) {
            logger.error("\u5dee\u5f02\u5206\u644a\u7ee7\u7eed\u8ba1\u7b97-\u5b58\u8d27\u68c0\u67e5\u63a5\u53e3DiffAllocService.diffReCalculateCheck\u5931\u8d25\u3002", (Throwable)ex);
            ErrorCode errorCode = new ErrorCode("cal", ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u7ee7\u7eed\u8ba1\u7b97-\u5b58\u8d27\u68c0\u67e5\u63a5\u53e3DiffAllocService.diffReCalculateCheck\u5931\u8d25\u3002", (String)"CalServiceHelper_10", (String)"macc-sca-algox", (Object[])new Object[0]));
            throw new KDBizException((Throwable)ex, errorCode, new Object[0]);
        }
        return null;
    }

    public static String ficalReCalculateDelBill(DiffCalcDataArgs args, List<Map<String, Object>> curMatIds, Date startTime) {
        if (CadEmptyUtils.isEmpty(curMatIds)) {
            if (curMatIds == null) {
                curMatIds = new ArrayList<Map<String, Object>>(10);
            }
            HashMap matParamMap = Maps.newHashMapWithExpectedSize((int)2);
            matParamMap.put("material", 1L);
            curMatIds.add(matParamMap);
        }
        HashMap<String, Object> bizParam = new HashMap<String, Object>();
        bizParam.put("costAccount", args.getCostaccountId());
        bizParam.put("materials", curMatIds);
        bizParam.put("periodId", args.getPeriodId());
        bizParam.put("startDate", startTime);
        try {
            long start = System.currentTimeMillis();
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"DiffAllocService", (String)"diffReCalculateDelBill", (Object[])new Object[]{bizParam});
            if (result != null) {
                int code;
                int n = code = result.get("status") != null ? Integer.parseInt((String)result.get("status")) : 200;
                if (code != 200) {
                    return (String)result.get("msg");
                }
            }
            logger.info("\u5dee\u5f02\u5206\u644a\u7ee7\u7eed\u8ba1\u7b97-\u5b58\u8d27\u5220\u9664\u6570\u636e\u63a5\u53e3\uff0c\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception ex) {
            logger.error("\u5dee\u5f02\u5206\u644a\u7ee7\u7eed\u8ba1\u7b97-\u5b58\u8d27\u5220\u9664\u6570\u636e\u63a5\u53e3DiffAllocService.diffReCalculateDelBill\u5931\u8d25\u3002", (Throwable)ex);
            ErrorCode errorCode = new ErrorCode("cal", ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u7ee7\u7eed\u8ba1\u7b97-\u5b58\u8d27\u5220\u9664\u6570\u636e\u63a5\u53e3DiffAllocService.diffReCalculateDelBill\u5931\u8d25\u3002", (String)"CalServiceHelper_11", (String)"macc-sca-algox", (Object[])new Object[0]));
            throw new KDBizException((Throwable)ex, errorCode, new Object[0]);
        }
        return null;
    }
}

