/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.dto.MaterialCodeDto;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.utils.JsonEntryServiceHelper;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.ScaCalcHelper;

public class DiffCalcDataInputFactory {
    private static final Log logger = LogFactory.getLog(DiffCalcDataInputFactory.class);
    private static final String ALGOKEY_PRE = "DiffCalc-";

    public static Map<String, String> getMaterialInfoMap(Collection<MaterialCodeDto> lvlmats, Set<String> diffMatLvlDim) {
        Map<String, Set<Object>> dimMatMap = DiffCalcHelper.getDimMatMapFromLvl(lvlmats, diffMatLvlDim);
        HashMap curCalMatNumbers = Maps.newHashMapWithExpectedSize((int)10);
        Map<Long, String> auxptyMap = null;
        HashMap configuredcodeMap = null;
        HashMap tracknumberMap = null;
        HashMap projectMap = null;
        for (Map.Entry<String, Set<Object>> entry : dimMatMap.entrySet()) {
            Row row;
            DataSet resultDs;
            Set<Object> valIds;
            Object row22;
            if (entry.getKey().equals("material")) {
                DataSet materialInfoDs = QueryServiceHelper.queryDataSet((String)"DiffCalc-getMaterialInfo", (String)"bd_material", (String)"id,number", (QFilter[])new QFilter("id", "in", entry.getValue()).toArray(), (String)"number");
                for (Object row22 : materialInfoDs) {
                    curCalMatNumbers.put(row22.getLong("id"), row22.getString("number"));
                }
                continue;
            }
            if (entry.getKey().equals("auxpty")) {
                valIds = entry.getValue();
                valIds.remove(0L);
                if (valIds.isEmpty()) continue;
                auxptyMap = DiffCalcHelper.getAuxValueNameMap(valIds);
                continue;
            }
            if (entry.getKey().equals("configuredcode")) {
                valIds = entry.getValue();
                valIds.remove(0L);
                if (valIds.isEmpty()) continue;
                configuredcodeMap = Maps.newHashMapWithExpectedSize((int)10);
                resultDs = QueryServiceHelper.queryDataSet((String)"DiffCalc-configuredcode", (String)"bd_configuredcode", (String)"id,number", (QFilter[])new QFilter("id", "in", valIds).toArray(), (String)"number");
                row22 = resultDs.iterator();
                while (row22.hasNext()) {
                    row = (Row)row22.next();
                    configuredcodeMap.put(row.getLong("id"), row.getString("number"));
                }
                continue;
            }
            if (entry.getKey().equals("tracknumber")) {
                valIds = entry.getValue();
                valIds.remove(0L);
                if (valIds.isEmpty()) continue;
                tracknumberMap = Maps.newHashMapWithExpectedSize((int)10);
                resultDs = QueryServiceHelper.queryDataSet((String)"DiffCalc-tracknumber", (String)"bd_tracknumber", (String)"id,number", (QFilter[])new QFilter("id", "in", valIds).toArray(), (String)"number");
                row22 = resultDs.iterator();
                while (row22.hasNext()) {
                    row = (Row)row22.next();
                    tracknumberMap.put(row.getLong("id"), row.getString("number"));
                }
                continue;
            }
            if (!entry.getKey().equals("project")) continue;
            valIds = entry.getValue();
            valIds.remove(0L);
            if (valIds.isEmpty()) continue;
            projectMap = Maps.newHashMapWithExpectedSize((int)10);
            resultDs = QueryServiceHelper.queryDataSet((String)"DiffCalc-project", (String)"bd_project", (String)"id,number", (QFilter[])new QFilter("id", "in", valIds).toArray(), (String)"number");
            row22 = resultDs.iterator();
            while (row22.hasNext()) {
                row = (Row)row22.next();
                projectMap.put(row.getLong("id"), row.getString("number"));
            }
        }
        HashMap matToNames = Maps.newHashMapWithExpectedSize((int)10);
        for (MaterialCodeDto matData : lvlmats) {
            String valStr;
            StringBuilder sb = new StringBuilder();
            int i = diffMatLvlDim.size();
            String matNumber = (String)curCalMatNumbers.get(matData.getMaterial());
            sb.append(matNumber != null ? matNumber : "");
            if (--i != 0) {
                sb.append("@");
            }
            if (diffMatLvlDim.contains("auxpty")) {
                valStr = null;
                if (matData.getAuxpty() != 0L && auxptyMap != null) {
                    valStr = auxptyMap.get(matData.getAuxpty());
                }
                sb.append(valStr != null ? valStr : "");
                if (--i != 0) {
                    sb.append("@");
                }
            }
            if (diffMatLvlDim.contains("configuredcode")) {
                valStr = null;
                if (matData.getConfiguredcode() != 0L && configuredcodeMap != null) {
                    valStr = (String)configuredcodeMap.get(matData.getConfiguredcode());
                }
                sb.append(valStr != null ? valStr : "");
                if (--i != 0) {
                    sb.append("@");
                }
            }
            if (diffMatLvlDim.contains("tracknumber")) {
                valStr = null;
                if (matData.getTracknumber() != 0L && tracknumberMap != null) {
                    valStr = (String)tracknumberMap.get(matData.getTracknumber());
                }
                sb.append(valStr != null ? valStr : "");
                if (--i != 0) {
                    sb.append("@");
                }
            }
            if (diffMatLvlDim.contains("project")) {
                valStr = null;
                if (matData.getProject() != 0L && projectMap != null) {
                    valStr = (String)projectMap.get(matData.getProject());
                }
                sb.append(valStr != null ? valStr : "");
                if (--i != 0) {
                    sb.append("@");
                }
            }
            if (diffMatLvlDim.contains("lot")) {
                valStr = matData.getLot();
                sb.append(StringUtils.isEmpty((String)valStr) ? valStr : "");
                if (--i != 0) {
                    sb.append("@");
                }
            }
            matToNames.put(matData.getMaterialKey(), sb.toString());
        }
        return matToNames;
    }

    public static String getMaterialInfo(Collection<MaterialCodeDto> lvlmats, Set<String> diffMatLvlDim) {
        Map<String, String> matToNames = DiffCalcDataInputFactory.getMaterialInfoMap(lvlmats, diffMatLvlDim);
        HashSet<String> values = new HashSet<String>(matToNames.values());
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        for (String msg : values) {
            if (flag) {
                sb.append(",");
            } else {
                flag = true;
            }
            sb.append(org.apache.commons.lang3.StringUtils.stripEnd((String)msg, (String)"@"));
        }
        return sb.toString();
    }

    public static Map<Long, String> getMaterialInfoMap(Set<Long> lvlmats) {
        DataSet materialInfoDs = QueryServiceHelper.queryDataSet((String)"DiffCalc-getMaterialInfo", (String)"bd_material", (String)"id,number,name", (QFilter[])new QFilter("id", "in", lvlmats).toArray(), (String)"number");
        HashMap curCalMatNumbers = Maps.newHashMapWithExpectedSize((int)lvlmats.size());
        for (Row row : materialInfoDs) {
            curCalMatNumbers.put(row.getLong("id"), String.format("%s/%s", row.getString("number"), row.getString("name")));
        }
        return curCalMatNumbers;
    }

    public static OrmInput getMaterialDs(Set<Long> lvlmats) {
        return new OrmInput("DiffCalc-getMaterialInfo", "bd_material", "id,baseunit,baseunit.precision precision", new QFilter("id", "in", lvlmats).toArray());
    }

    public static Set<String> checkCostAdjustAudit(DiffCalcDataArgs args, Set<Long> calcedMat) {
        QFilter qfCostAdjust = new QFilter("calorg.id", "=", (Object)args.getOrgId());
        qfCostAdjust.and("costaccount.id", "=", (Object)args.getCostaccountId());
        qfCostAdjust.and("bookdate", ">=", (Object)args.getStartDate());
        qfCostAdjust.and("bookdate", "<=", (Object)args.getEndDate());
        qfCostAdjust.and("billstatus", "!=", (Object)Character.valueOf('C'));
        qfCostAdjust.and("entryentity.material.id", "in", calcedMat);
        qfCostAdjust.and("isupdatecost", "=", (Object)"1");
        DataSet exceptionDs = QueryServiceHelper.queryDataSet((String)"DiffCalc-loopCheckData", (String)"cal_stdcostdiffbill", (String)"billno", (QFilter[])qfCostAdjust.toArray(), null);
        HashSet billNoSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : exceptionDs) {
            billNoSet.add(row.getString("billno"));
        }
        return billNoSet;
    }

    public static DataSet getCostobjectFact(DiffCalcDataArgs args, Set<Long> costobjectIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("bookdate", ">=", (Object)args.getStartDate());
        qFilter.and("bookdate", "<=", (Object)args.getEndDate());
        qFilter.and("entryentity.costobject", "in", costobjectIds);
        String selectcoField = "id,material material,sourcebillentry, entryentity.qty qty";
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getCostobjectFact", (String)"cad_factnedoutputbill", (String)selectcoField, (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet getTransOutMatFactDs(DiffCalcDataArgs args, Set<Long> materialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("bookdate", ">=", (Object)args.getStartDate());
        qFilter.and("bookdate", "<=", (Object)args.getEndDate());
        qFilter.and("entryentity.costobject.material.id", "in", materialIds);
        String selectcoField = "id,org,costcenter,entryentity.costobject costobject,sourcebill,sourcebillentry, entryentity.qty qty,entryentity.costobject.material material,entryentity.costobject.calckeycol.auxproperty AS auxpty,entryentity.costobject.calckeycol.configuredcode configuredcode,entryentity.costobject.calckeycol.tracknumber tracknumber,entryentity.costobject.calckeycol.project project,entryentity.costobject.calckeycol.lot lot";
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-TransOutMatCostObjects", (String)"cad_factnedoutputbill", (String)selectcoField, (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet getPurchDiffAllocElementInfo(DiffCalcDataArgs args, Set<Long> materialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("becostobject.material", "in", materialIds);
        qFilter.and("biztype", "=", (Object)"00");
        String selectFields = "id,becostobject.costcenter costcenter,becostobject costobject,becostobject.material product,entryentity.element element,entryentity.subelement subelement,entryentity.orddiff orddiff,entryentity.invoicediff invoicediff,entryentity.feediff feediff,entryentity.diffqty diffqty,entryentity.madediff madediff,entryentity.unjoindiffamt unjoindiffamt,entryentity.stdcostupamt stdcostupamt,entryentity.madeupamt madeupamt,entryentity.otherdiff otherdiff,entryentity.falldiff falldiff,entryentity.reservediffx reservediffx,entryentity.reservediffw reservediffw,entryentity.reservediffy reservediffy,becostobject.material material,becostobject.calckeycol.auxproperty AS auxpty,becostobject.calckeycol.configuredcode configuredcode,becostobject.calckeycol.tracknumber tracknumber,becostobject.calckeycol.project project,becostobject.calckeycol.lot lot,material submaterial,auxpty subauxpty,configuredcode subconfiguredcode,tracknumber subtracknumber,project subproject,lot sublot,'W' createtype";
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getSubMatUnAbsorbDiff", (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet getEndPurchDiffAllocDs(DiffCalcDataArgs args, Set<Long> curMaterialIds) {
        return DiffCalcDataInputFactory.getEndPurchDiffAllocDs(args, curMaterialIds, null);
    }

    public static DataSet getEndPurchDiffAllocDs(DiffCalcDataArgs args, Set<Long> curMaterialIds, Set<Long> costobjectIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPrePeriodId());
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("material", "in", curMaterialIds);
        if (costobjectIds != null) {
            qFilter.and("becostobject", "in", costobjectIds);
        }
        qFilter.and("biztype", "=", (Object)"01");
        qFilter.and("entryentity.id", ">", (Object)0L);
        String selectFields = "becostobject.costcenter costcenter,becostobject costobject," + (args.isEnableFactory() ? "becostobject.manuorg manuorg," : "0L manuorg,") + "becostobject.material product,material,version mversion,auxpty,configuredcode,tracknumber,project,lot,keycol,keycolid,difftype,entryentity.element costelement,entryentity.subelement costsubelement,entryentity.orddiff startorddiff,entryentity.invoicediff startinvoicediff,entryentity.feediff startfeediff,entryentity.diffqty startdiffqty,entryentity.madediff startmadediff,entryentity.unjoindiffamt startunjoindiffamt,entryentity.stdcostupamt startstdcostupamt,entryentity.madeupamt startmadeupamt,entryentity.otherdiff startotherdiff,entryentity.falldiff startfalldiff,entryentity.reservediffx startreservediffx,entryentity.reservediffw startreservediffw,entryentity.reservediffy startreservediffy";
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getSubMatUnAbsorbDiff", (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet getEndPurchDiffAllocDsId(DiffCalcDataArgs args, Set<Long> curMaterialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPrePeriodId());
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("material", "in", curMaterialIds);
        qFilter.and("biztype", "=", (Object)"01");
        qFilter.and("entryentity.id", ">", (Object)0L);
        String selectFields = "becostobject costobject,material,version mversion,auxpty,configuredcode,tracknumber,project,lot";
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getSubMatUnAbsorbDiff", (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet getCurPurchDiffAllocDs(DiffCalcDataArgs args, Set<Long> curMaterialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("material", "in", curMaterialIds);
        qFilter.and("entryentity.id", ">", (Object)0L);
        String selectFields = "material,version mversion,auxpty,configuredcode,tracknumber,project,lot,keycol,keycolid,maincostobject costobject,becostobject relacostobject,entryentity.element costelement,entryentity.subelement costsubelement,biztype,entryentity.orddiff orddiff,entryentity.invoicediff invoicediff,entryentity.feediff feediff,entryentity.diffqty diffqty,entryentity.madediff madediff,entryentity.unjoindiffamt unjoindiffamt,entryentity.stdcostupamt stdcostupamt,entryentity.madeupamt madeupamt,entryentity.otherdiff otherdiff,entryentity.falldiff falldiff,entryentity.reservediffx reservediffx,entryentity.reservediffw reservediffw,entryentity.reservediffy reservediffy";
        DataSet ds = QueryServiceHelper.queryDataSet((String)"DiffCalc-getSubMatUnAbsorbDiff", (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])qFilter.toArray(), null);
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(ds.getRowMeta().getFieldNames()));
        for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
            fieldNames.remove(field);
        }
        for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
            fieldNames.add(String.format("case when biztype='01' then -%s else 0 end end%s", field, field));
            fieldNames.add(String.format("case when biztype<>'01' then -%s else 0 end comp%s", field, field));
        }
        return ds.select(fieldNames.toArray(new String[0]));
    }

    public static DataSet getCurPurchDiffAllocDsId(DiffCalcDataArgs args, Set<Long> curMaterialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("material", "in", curMaterialIds);
        qFilter.and("entryentity.id", ">", (Object)0L);
        String selectFields = "material,version mversion,auxpty,configuredcode,tracknumber,project,lot,keycol,keycolid,maincostobject costobject";
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getSubMatUnAbsorbDiff", (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    public static OrmInput getFinishDiffElementInfo(DiffCalcDataArgs args, Set<Long> materialIds, boolean isSplitType) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("costobject.material", "in", materialIds);
        qFilter.and(QFilter.of((String)"entryentity.amount is not null and entryentity.amount<>?", (Object[])new Object[]{BigDecimal.ZERO}));
        String selectFields = "id,costobject,costobject.material product,entryentity.subelement subelement,entryentity.element element, entryentity.amount amount,entryentity.difftype difftype, case costobject.bizstatus when 'A' then 'Z' else 'Y' end createtype,costobject.material material,costobject.calckeycol.auxproperty AS auxpty,costobject.calckeycol.configuredcode configuredcode,costobject.calckeycol.tracknumber tracknumber,costobject.calckeycol.project project,costobject.calckeycol.lot lot";
        if (!isSplitType) {
            selectFields = "id,costobject,costobject.material product,entryentity.subelement subelement,entryentity.element element, entryentity.amount amount,entryentity.difftype difftype, 'W' createtype,costobject.material material,costobject.calckeycol.auxproperty AS auxpty,costobject.calckeycol.configuredcode configuredcode,costobject.calckeycol.tracknumber tracknumber,costobject.calckeycol.project project,costobject.calckeycol.lot lot";
        }
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("costobject", (DataType)DataType.LongType), new Field("product", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.LongType), new Field("element", (DataType)DataType.LongType), new Field("amount", (DataType)DataType.BigDecimalType), new Field("difftype", (DataType)DataType.StringType), new Field("createtype", (DataType)DataType.StringType), new Field("material", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("configuredcode", (DataType)DataType.LongType), new Field("tracknumber", (DataType)DataType.LongType), new Field("project", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType)});
        return new OrmInput("DiffCalc-FinishDiff", "sca_finishdiffbill", selectFields, qFilter.toArray(), rowMeta);
    }

    public static OrmInput getUnAbsorbDiffElementInfo(DiffCalcDataArgs args, Set<Long> materialIds, boolean isSplitType) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("costobject.material", "in", materialIds);
        qFilter.and(QFilter.of((String)"entryentity.amount is not null and entryentity.amount<>?", (Object[])new Object[]{BigDecimal.ZERO}));
        String selectFields = "id,costobject,costobject.material product,difftype,entryentity.element element,entryentity.subelement subelement,entryentity.amount amount,costobject.material material,costobject.calckeycol.auxproperty AS auxpty,costobject.calckeycol.configuredcode configuredcode,costobject.calckeycol.tracknumber tracknumber,costobject.calckeycol.project project,costobject.calckeycol.lot lot,'Z' createtype";
        if (!isSplitType) {
            selectFields = "id,costobject,costobject.material product,difftype,entryentity.element element,entryentity.subelement subelement,entryentity.amount amount,costobject.material material,costobject.calckeycol.auxproperty AS auxpty,costobject.calckeycol.configuredcode configuredcode,costobject.calckeycol.tracknumber tracknumber,costobject.calckeycol.project project,costobject.calckeycol.lot lot,'W' createtype";
        }
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("costobject", (DataType)DataType.LongType), new Field("product", (DataType)DataType.LongType), new Field("difftype", (DataType)DataType.StringType), new Field("element", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.LongType), new Field("amount", (DataType)DataType.BigDecimalType), new Field("material", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("configuredcode", (DataType)DataType.LongType), new Field("tracknumber", (DataType)DataType.LongType), new Field("project", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType), new Field("createtype", (DataType)DataType.StringType)});
        return new OrmInput("DiffCalc-UnAbsorbDiff", "sca_unabsorbdiff", selectFields, qFilter.toArray(), rowMeta);
    }

    public static DataSet getCalCostRecordInfoByBizEntryId(DiffCalcDataArgs args, Set<Long> costRecordEntryIds, String field) {
        QFilter filter = new QFilter("entry.bizbillentryid", "in", costRecordEntryIds);
        filter.and("costaccount", "=", (Object)args.getCostaccountId());
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        String selectField = "entry.bizbillentryid as srcbillentryid" + field;
        selectField = selectField + DiffCalcDataInputFactory.getCostRecordbillExFileds();
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getCalCostRecordInfoByBizEntryId", (String)"cal_costrecord_subentity", (String)selectField, (QFilter[])filter.toArray(), null);
    }

    public static OrmInput getCalCostRecordInfoByBizEntryId(DiffCalcDataArgs args, Set<Long> costRecordEntryIds) {
        QFilter filter = new QFilter("entry.bizbillentryid", "in", costRecordEntryIds);
        filter.and("costaccount", "=", (Object)args.getCostaccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("calorg", "=", (Object)args.getOrgId());
        filter.and("calbilltype", "=", (Object)"IN");
        String selectField = "id,billnumber billno,billtype,storageorgunit,biztype,entry.id as entryid,entry.seq seq,entry.bizbillentryid as srcbillentryid,entry.project project,entry.owner owner,entry.ownertype ownertype,entry.invstatus invstatus,entry.invtype invtype,entry.location location,entry.warehouse warehouse,entry.baseunit baseunit,entry.lot lot,entry.assist auxpty,entry.mversion mversion,entry.material.masterid material,entry.configuredcode configuredcode,entry.tracknumber tracknumber,adminorg,entry.ecostcenter ecostcenter,entry.noupdatecalfields noupdatecalfields";
        selectField = selectField + DiffCalcDataInputFactory.getCostRecordbillExFileds();
        return new OrmInput("DiffCalc-getCalCostRecord", "cal_costrecord_subentity", selectField, filter.toArray());
    }

    public static Input[] getCalCostRecordInfoByMaterialId(DiffCalcDataArgs args, Set<Long> materialIds, int diffAllocMatSize) {
        QFilter qFilter = new QFilter("calorg", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("bookdate", ">=", (Object)args.getStartDate());
        qFilter.and("bookdate", "<=", (Object)args.getEndDate());
        qFilter.and("calbilltype", "=", (Object)"OUT");
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(10);
        if (materialIds.size() > diffAllocMatSize) {
            int batch = DiffCalcDataInputFactory.getBatchAvgSize(diffAllocMatSize, materialIds.size());
            List lists = Lists.partition(new ArrayList<Long>(materialIds), (int)batch);
            for (List list : lists) {
                QFilter materialFilter = new QFilter("entry.material.id", "in", new ArrayList(list));
                inputs.add(new OrmInput("DiffCalc-getCalCostRecord", "cal_costrecord_subentity", "id AS recordid,entry.id rentryid,bizbillid AS bizbillid,entry.bizbillentryid AS bizbillentryid,entry.assist hauxpty,entry.mversion hmversion,entry.material.masterid hmaterial,entry.baseunit baseunit", new QFilter[]{qFilter, materialFilter}));
            }
        } else {
            QFilter materialFilter = new QFilter("entry.material.id", "in", materialIds);
            inputs.add(new OrmInput("DiffCalc-getCalCostRecord", "cal_costrecord_subentity", "id AS recordid,entry.id rentryid,bizbillid AS bizbillid,entry.bizbillentryid AS bizbillentryid,entry.assist hauxpty,entry.mversion hmversion,entry.material.masterid hmaterial,entry.baseunit baseunit", new QFilter[]{qFilter, materialFilter}));
        }
        return inputs.toArray(new Input[0]);
    }

    protected static int getBatchAvgSize(int batch, int totalSize) {
        if (batch <= 0) {
            return 1;
        }
        int patchSize = totalSize / batch;
        if (totalSize != patchSize * batch) {
            if (totalSize % ++patchSize == 0) {
                return totalSize / patchSize;
            }
            return totalSize / patchSize + 1;
        }
        return batch;
    }

    private static String getCostRecordbillExFileds() {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity");
        IDataEntityProperty property = entityType.findProperty("ynzy_costcenter");
        if (property == null) {
            return " ";
        }
        IDataEntityType parentProp = property.getParent();
        boolean isEntryProp = parentProp instanceof EntryType;
        StringBuilder exFileds = new StringBuilder();
        exFileds.append(",");
        if (isEntryProp) {
            exFileds.append(parentProp.getName());
            exFileds.append('.');
        }
        exFileds.append(property.getName());
        exFileds.append(" as ");
        exFileds.append(property.getName());
        return exFileds.toString();
    }

    public static DataSetX getCostAdjustCollData(DiffCalcDataArgs args, Set<Long> materialIds, JobSession session, int diffAllocMatSize, boolean isCon) {
        QFilter billType = new QFilter("biztype", "=", (Object)"B");
        QFilter orgId = new QFilter("calorg", "=", (Object)args.getOrgId());
        QFilter qfCostAccount = new QFilter("costaccount", "=", (Object)args.getCostaccountId());
        QFilter period = new QFilter("bookdate", ">=", (Object)args.getStartDate());
        period.and("bookdate", "<=", (Object)args.getEndDate());
        ArrayList<DataSetX> inputs = new ArrayList<DataSetX>(10);
        String selectFields = "id AS costadjustid,billno AS adjuestbillno,entryentity.id AS costadjustentryid,entryentity.seq AS costadjustseq,entryentity.adjustamt AS adjustamt,entryentity.invbillid AS recordid,entryentity.invbillentryid AS rentryid,entryentity.material.id AS material,entryentity.mversion.id AS mversion,entryentity.assist.id AS auxpty,entryentity.subentryentity.id AS costadjustdetailId,entryentity.subentryentity.costelement.id AS costelement,entryentity.subentryentity.costsubelement.id AS costsubelement,entryentity.subentryentity.ddiff_g AS currorddiff,entryentity.subentryentity.ddiff_h AS currinvoicediff,entryentity.subentryentity.ddiff_k AS currfeediff,entryentity.subentryentity.ddiff_p AS currdiffqty,entryentity.subentryentity.ddiff_q AS currmadediff,entryentity.subentryentity.ddiff_r AS currunjoindiffamt,entryentity.subentryentity.ddiff_m AS currstdcostupamt,entryentity.subentryentity.ddiff_s AS currmadeupamt,entryentity.subentryentity.ddiff_t AS currotherdiff,entryentity.subentryentity.ddiff_c AS currfalldiff,entryentity.subentryentity.ddiff_x AS currreservediffx,entryentity.subentryentity.ddiff_w AS currreservediffw,entryentity.subentryentity.ddiff_y AS currreservediffy";
        if (materialIds.size() > diffAllocMatSize && isCon) {
            int batch = DiffCalcDataInputFactory.getBatchAvgSize(diffAllocMatSize, materialIds.size());
            List lists = Lists.partition(new ArrayList<Long>(materialIds), (int)batch);
            for (List list : lists) {
                QFilter material = new QFilter("entryentity.material.id", "in", new ArrayList(list));
                inputs.add(JsonEntryServiceHelper.queryJsonSubEntryDataSetX((String)"DiffCalc-getCostAdjustColl", (String)"cal_stdcostdiffbill", (String)selectFields, (String)"entryentity.subentryentity", (QFilter[])new QFilter[]{qfCostAccount, billType, orgId, period, material}, (JobSession)session));
            }
        } else {
            QFilter material = new QFilter("entryentity.material.id", "in", materialIds);
            return JsonEntryServiceHelper.queryJsonSubEntryDataSetX((String)"DiffCalc-getCostAdjustColl", (String)"cal_stdcostdiffbill", (String)selectFields, (String)"entryentity.subentryentity", (QFilter[])new QFilter[]{qfCostAccount, billType, orgId, period, material}, (JobSession)session);
        }
        DataSetX resultDs = null;
        ArrayList<DataSetX> datas = new ArrayList<DataSetX>();
        for (DataSetX input : inputs) {
            if (resultDs == null) {
                resultDs = input;
                continue;
            }
            datas.add(input);
        }
        if (!datas.isEmpty() && resultDs != null) {
            for (DataSetX data : datas) {
                resultDs = resultDs.union(data);
            }
        }
        return resultDs;
    }

    public static DataSetX getCostAdjustTranoutData(DiffCalcDataArgs args, Set<Long> materialIds, JobSession session) {
        QFilter billType = new QFilter("biztype", "=", (Object)"A");
        QFilter orgId = new QFilter("calorg", "=", (Object)args.getOrgId());
        QFilter qfCostAccount = new QFilter("costaccount", "=", (Object)args.getCostaccountId());
        QFilter period = new QFilter("bookdate", ">=", (Object)args.getStartDate());
        period.and("bookdate", "<=", (Object)args.getEndDate());
        QFilter material = new QFilter("entryentity.material.id", "in", materialIds);
        HashSet createtypeSet = Sets.newHashSet((Object[])new String[]{"Y", "Z", "W"});
        QFilter createType = new QFilter("createtype", "in", (Object)createtypeSet);
        String selectFields = "id AS costadjustid,billno AS adjuestbillno,entryentity.id AS costadjustentryid,entryentity.seq AS costadjustseq,entryentity.invbillid AS recordid,entryentity.invbillentryid AS rentryid,entryentity.srcbillid AS costobjectId,entryentity.subentryentity.id AS costadjustdetailId,entryentity.subentryentity.costelement.id AS relement,entryentity.subentryentity.costsubelement.id AS rsubelement,entryentity.subentryentity.ddiff_g AS excomporddiff,entryentity.subentryentity.ddiff_h AS excompinvoicediff,entryentity.subentryentity.ddiff_k AS excompfeediff,entryentity.subentryentity.ddiff_p AS excompdiffqty,entryentity.subentryentity.ddiff_q AS excompmadediff,entryentity.subentryentity.ddiff_r AS excompunjoindiffamt,entryentity.subentryentity.ddiff_m AS excompstdcostupamt,entryentity.subentryentity.ddiff_s AS excompmadeupamt,entryentity.subentryentity.ddiff_t AS excompotherdiff,entryentity.subentryentity.ddiff_c AS excompfalldiff,entryentity.subentryentity.ddiff_x AS excompreservediffx,entryentity.subentryentity.ddiff_w AS excompreservediffw,entryentity.subentryentity.ddiff_y AS excompreservediffy,createtype";
        return JsonEntryServiceHelper.queryJsonSubEntryDataSetX((String)"DiffCalc-getCostAdjustColl", (String)"cal_stdcostdiffbill", (String)selectFields, (String)"entryentity.subentryentity", (QFilter[])new QFilter[]{qfCostAccount, billType, orgId, period, material, createType}, (JobSession)session, (boolean)true);
    }

    public static DataSet getFallPrice(DiffCalcDataArgs args, Set<Long> materialIds) {
        QFilter metaFilter = new QFilter("number", "=", (Object)"ynzy_cal_price_revbil_ext");
        boolean exist = QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])metaFilter.toArray());
        logger.info("\u8dcc\u4ef7\u51b2\u56de\u5355\u662f\u5426\u5b58\u5728\uff1a{}", (Object)exist);
        if (!exist) {
            return null;
        }
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostaccountId());
        filter.and("periodid.id", "=", (Object)args.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        HashSet<Long> bizBilltypes = new HashSet<Long>(16);
        bizBilltypes.add(1051649321084129280L);
        bizBilltypes.add(1055789466989421568L);
        filter.and("entry.ynzy_issueentry.ynzy_bizbilltype", "in", bizBilltypes);
        filter.and("entry.material", "in", materialIds);
        logger.info("\u8dcc\u4ef7\u6570\u636e\u67e5\u8be2\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", (Object)filter.toString());
        String fallPriceField = "id costadjustid,billno adjuestbillno,entry.ynzy_issueentry.ynzy_bizbillentryid AS costadjustentryid,entry.ynzy_issueentry.ynzy_bizbillentryseq AS costadjustseq,entry.material.id AS material,0L AS mversion,entry.assist.id AS auxpty,entry.ynzy_issueentry.ynzy_bizbillid as bizbillid,entry.ynzy_issueentry.ynzy_bizbillentryid as bizbillentryid,0L costadjustdetailId,773126985240072192L AS costelement,773175233367685120L AS costsubelement,0-entry.ynzy_issueentry.ynzy_issueamount AS currfalldiff";
        DataSet fallPriceData = QueryServiceHelper.queryDataSet((String)"DiffCalc-getFallPrice", (String)"cal_price_revbill", (String)fallPriceField, (QFilter[])filter.toArray(), null);
        fallPriceData = DiffCalcDataInputFactory.changFiledDataType(fallPriceData, "bizbillid", Long.class);
        fallPriceData = DiffCalcDataInputFactory.changFiledDataType(fallPriceData, "bizbillentryid", Long.class);
        fallPriceData = DiffCalcDataInputFactory.changFiledDataType(fallPriceData, "costadjustentryid", Long.class);
        return fallPriceData;
    }

    public static <T> DataSet changFiledDataType(DataSet dataSet, String filedName, Class<T> T) {
        dataSet = dataSet.select(DiffCalcDataInputFactory.arraysToString(DiffCalcDataInputFactory.addFileds(DiffCalcDataInputFactory.removeFiled(dataSet.getRowMeta().getFieldNames(), filedName), "cast(" + filedName + " as " + T.getSimpleName() + ")as " + filedName + "")));
        return dataSet;
    }

    public static String arraysToString(String[] sourceFileds) {
        String arrayS = Arrays.toString(sourceFileds);
        return arrayS.substring(1, arrayS.length() - 1);
    }

    public static String[] addFileds(String[] source, String ... addFiled) {
        return (String[])ArrayUtils.addAll((Object[])source, (Object[])addFiled);
    }

    public static String[] removeFiled(String[] source, String ... removeFileds) {
        HashSet<String> removeFiledSet = new HashSet<String>(removeFileds.length);
        for (String removeFiled : removeFileds) {
            removeFiledSet.add(removeFiled);
        }
        ArrayList<String> fileds = new ArrayList<String>(source.length);
        for (String string : source) {
            if (removeFiledSet.contains(string)) continue;
            fileds.add(string);
        }
        return fileds.toArray(new String[fileds.size()]);
    }

    public static DataSet getCurMatAllocDataNotSub(DiffCalcDataArgs args, Set<Long> curMaterialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("appnum", "=", (Object)"sca");
        qFilter.and("allocstatus", "=", (Object)"2");
        qFilter.and("material", "in", curMaterialIds);
        String selectFields = "manuorg,useqty qty,costobject,costobject.material material,costobject.calckeycol.auxproperty AS auxpty,costobject.calckeycol.configuredcode configuredcode,costobject.calckeycol.tracknumber tracknumber,costobject.calckeycol.project project,costobject.calckeycol.lot lot,material submaterial,auxpty subauxpty,configuredcode subconfiguredcode,tracknumber subtracknumber,project subproject,lotcoderule sublot";
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getMatAlloc", (String)"sca_matalloc", (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet getEndPurchDiffAllocDsForNest(DiffCalcDataArgs args, Set<Long> curMaterialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPrePeriodId());
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("biztype", "=", (Object)"01");
        qFilter.and("material", "in", curMaterialIds);
        String selectFields = "becostobject.manuorg manuorg,0 qty,becostobject costobject,becostobject.material material,becostobject.calckeycol.auxproperty AS auxpty,becostobject.calckeycol.configuredcode configuredcode,becostobject.calckeycol.tracknumber tracknumber,becostobject.calckeycol.project project,becostobject.calckeycol.lot lot,material submaterial,auxpty subauxpty,configuredcode subconfiguredcode,tracknumber subtracknumber,project subproject,lot sublot";
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getSubMatUnAbsorbDiff", (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet getPreDiffAllocDsForDimFormat(DiffCalcDataArgs args, Set<Long> curMaterialIds, Set<Long> costobjectIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPrePeriodId());
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("material", "in", curMaterialIds);
        if (costobjectIds != null) {
            qFilter.and("becostobject", "in", costobjectIds);
        }
        qFilter.and("biztype", "=", (Object)"01");
        qFilter.and("entryentity.id", ">", (Object)0L);
        String selectFields = "becostobject.costcenter costcenter,becostobject costobject," + (args.isEnableFactory() ? "becostobject.manuorg manuorg," : "0L manuorg,") + "becostobject.material material,becostobject.calckeycol.auxproperty AS auxpty,becostobject.calckeycol.configuredcode configuredcode,becostobject.calckeycol.tracknumber tracknumber,becostobject.calckeycol.project project,becostobject.calckeycol.lot lot,material submaterial,auxpty subauxpty,configuredcode subconfiguredcode,tracknumber subtracknumber,project subproject,lot sublot,keycol,keycolid,difftype,entryentity.element costelement,entryentity.subelement costsubelement,entryentity.orddiff startorddiff,entryentity.invoicediff startinvoicediff,entryentity.feediff startfeediff,entryentity.diffqty startdiffqty,entryentity.madediff startmadediff,entryentity.unjoindiffamt startunjoindiffamt,entryentity.stdcostupamt startstdcostupamt,entryentity.madeupamt startmadeupamt,entryentity.otherdiff startotherdiff,entryentity.falldiff startfalldiff,entryentity.reservediffx startreservediffx,entryentity.reservediffw startreservediffw,entryentity.reservediffy startreservediffy";
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getSubMatUnAbsorbDiff", (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet getCurMatAllocData(DiffCalcDataArgs args, Set<Long> curMaterialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("appnum", "=", (Object)"sca");
        qFilter.and("allocstatus", "=", (Object)"2");
        qFilter.and("material", "in", curMaterialIds);
        String selectFields = "id matallocid,costobject relacostobject,matcollect matcollectid,material,matversion mversion,auxpty,configuredcode,tracknumber,project,lotcoderule lot,keycol,keycolid,useqty totalqty,entryentity.id matallocentryid,entryentity.costobejctentry.costcenter costcenter,entryentity.costobejctentry costobject," + (args.isEnableFactory() ? "entryentity.costobejctentry.manuorg manuorg," : "0L manuorg,") + "entryentity.qty qty,entryentity.price standardcost,entryentity.amount standardamt";
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getMatAlloc", (String)"sca_matalloc", (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet getCurMatAllocDataId(DiffCalcDataArgs args, Set<Long> curMaterialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("appnum", "=", (Object)"sca");
        qFilter.and("allocstatus", "=", (Object)"2");
        qFilter.and("material", "in", curMaterialIds);
        String selectFields = "entryentity.costobejctentry costobject,material,matversion mversion,auxpty,configuredcode,tracknumber,project,lotcoderule lot";
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getMatAlloc", (String)"sca_matalloc", (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet getSubItemStdDataSet(DiffCalcDataArgs args, List<Long> matCostIds) {
        QFilter matCostIdFilter = new QFilter("matcostid", "in", matCostIds);
        QFilter costtypeFilter = new QFilter("costtype", "in", args.getManuorgToCosttypeMap().values());
        QFilter calcTypeFilter = new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3"});
        QFilter stdIsMainDataFilter = new QFilter("ismaindata", "=", (Object)1);
        DataSet effDataSet = QueryServiceHelper.queryDataSet((String)"DiffCalc-getSubItemStdDataSet", (String)"cad_calceffectiveresult", (String)"id eid,keycol,keycolid,matcostid,entryentity.id subentryid,entryentity.element.masterid costelement,entryentity.subelement.masterid costsubelement,entryentity.stdprice substandardcost", (QFilter[])new QFilter[]{matCostIdFilter, calcTypeFilter, stdIsMainDataFilter, costtypeFilter}, null);
        Set<Long> effIds = ScaCalcHelper.getLongIdSetFromDs(effDataSet, "matcostid", true);
        matCostIds.removeAll(effIds);
        if (matCostIds.isEmpty()) {
            return effDataSet;
        }
        QFilter idFilter = new QFilter("id", "in", matCostIds);
        DataSet purDataSet = QueryServiceHelper.queryDataSet((String)"DiffCalc-getSubItemStdDataSet", (String)"cad_matcostinfo", (String)"id eid,keycol,keycolid,id matcostid,entryentity.id subentryid,entryentity.element.masterid costelement,entryentity.subelement.masterid costsubelement,entryentity.standardcost substandardcost", (QFilter[])new QFilter[]{idFilter}, null);
        return effDataSet.union(purDataSet);
    }

    public static DataSet getCostTypeMaterialSubElementMap(DiffCalcDataArgs args, Set<Long> curMaterialIds) {
        Map matIdToPairMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getSubElementByOrg", (Object[])new Object[]{args.getOrgId(), curMaterialIds, new Date(), false});
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("material", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.LongType)});
        ArrayList<Object[]> array = new ArrayList<Object[]>(10);
        for (Map.Entry entry : matIdToPairMap.entrySet()) {
            array.add(new Object[]{entry.getKey(), ((Long[])entry.getValue())[1]});
        }
        return Algo.create((String)"dataset").createDataSet(array.iterator(), rowMeta);
    }

    public static OrmInput getElementDs() {
        return new OrmInput("DiffCalc-getProCostDataSetInfo", "cad_elementdetail", "subelement,subelement.number subelementnum, element,element.number elementnum", null);
    }

    public static OrmInput getCurMatUseCollectData(DiffCalcDataArgs args, Set<Long> curMaterialIds) {
        String algoKey = "kd.macc.sca.algox.calc.function.DiffAllocDealFunction.getMatCol";
        String selectFields = "entryentity.id AS matusecolectentryid,entryentity.sourcebillentryid AS sourcebillentryid";
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("bookdate", ">=", (Object)args.getStartDate());
        qFilter.and("bookdate", "<=", (Object)args.getEndDate());
        qFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
        qFilter.and("entryentity.material", "in", curMaterialIds);
        return new OrmInput(algoKey, "sca_matusecollect", selectFields, qFilter.toArray());
    }

    public static DataSet getCurMatUseCollectData(DiffCalcDataArgs args, List<Long> bizBillentryIds) {
        if (bizBillentryIds.isEmpty()) {
            return null;
        }
        List<List<Long>> splitList = DiffCalcDataInputFactory.splitLists(bizBillentryIds, 100000);
        DataSet result = null;
        for (List<Long> list : splitList) {
            String algoKey = "kd.macc.sca.algox.calc.function.DiffAllocDealFunction.getMatCol";
            String selectFields = "entryentity.id AS matusecolectentryid,entryentity.sourcebillentryid AS sourcebillentryid";
            QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
            qFilter.and("bookdate", ">=", (Object)args.getStartDate());
            qFilter.and("bookdate", "<=", (Object)args.getEndDate());
            qFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
            qFilter.and("entryentity.sourcebillentryid", "in", bizBillentryIds);
            DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_matusecollect", (String)selectFields, (QFilter[])qFilter.toArray(), null);
            if (result == null) {
                result = ds;
                continue;
            }
            result = result.union(ds);
        }
        return result;
    }

    public static DataSet getCurDiffCalcResult(DiffCalcDataArgs args, Set<Long> materialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("entryproduct", "in", materialIds);
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getCurDiffResult", (String)"sca_diffcalcresult", (String)"id,costobject,costobject.material material,costobject.calckeycol.auxproperty AS auxpty,costobject.calckeycol.configuredcode configuredcode,costobject.calckeycol.tracknumber tracknumber,costobject.calckeycol.project project,costobject.calckeycol.lot lot", (QFilter[])qFilter.toArray(), null);
    }

    public static Map<Long, Long> getCurDiffCalcResultId(DiffCalcDataArgs args) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"DiffCalc-getCurDiffResult", (String)"sca_diffcalcresult", (String)"id,costobject", (QFilter[])qFilter.toArray(), null);
        HashMap map = Maps.newHashMapWithExpectedSize((int)1024);
        for (Row row : ds) {
            map.put(row.getLong("costobject"), row.getLong("id"));
        }
        return map;
    }

    public static DataSet getCurSubDiffCalcResultIds(DiffCalcDataArgs args, List<Long> calResultIds, Set<Long> materialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("id", "in", calResultIds);
        qFilter.and("entryentity2.material2", "in", materialIds);
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getCurDiffResult", (String)"sca_diffcalcresult", (String)"id,entryentity2.id entryId,entryentity2.material2 material,entryentity2.auxpty2 auxpty,entryentity2.configuredcode2 configuredcode,entryentity2.tracknumber2 tracknumber,entryentity2.project2 project,entryentity2.lot2 lot", (QFilter[])qFilter.toArray(), null);
    }

    public static OrmInput getPreDiffCalcResult(DiffCalcDataArgs args, Set<Long> costobjectIds, Set<Long> materialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPrePeriodId());
        qFilter.and("costobject", "in", costobjectIds);
        qFilter.and("entryentity2.material2", "in", materialIds);
        qFilter.and("entryentity2.type2", "=", (Object)"5");
        String selectFields = "id,costobject,costobject.costcenter costcenter" + (args.isEnableFactory() ? ",costobject.manuorg manuorg" : ",0L manuorg") + ",entryentity2.type2 type,entryentity2.relacostobject2 relacostobject,entryentity2.material2 material,entryentity2.auxpty2 auxpty,entryentity2.matversion2 mversion,entryentity2.configuredcode2 configuredcode,entryentity2.tracknumber2 tracknumber,entryentity2.project2 project,entryentity2.lot2 lot,entryentity2.keycol2 keycol,entryentity2.keycol2id keycolid,entryentity2.element2 costelement,entryentity2.subelement2 costsubelement,entryentity2.endqty2 startqty,entryentity2.endamt2 startamt,entryentity2.totalqty2 totalqty,entryentity2.totalamt2 totalamt,entryentity2.totaldiffqty2 totaldiffqty,entryentity2.totalmadediff2 totalmadediff,entryentity2.totalmadeupamt2 totalmadeupamt,entryentity2.totalunjoindiffamt2 totalunjoindiffamt,entryentity2.totalstdcostupamt2 totalstdcostupamt,entryentity2.totalorddiff2 totalorddiff,entryentity2.totalinvoicediff2 totalinvoicediff,entryentity2.totalfeediff2 totalfeediff,entryentity2.totalotherdiff2 totalotherdiff,entryentity2.totalfalldiff2 totalfalldiff,entryentity2.totalreservediffx2 totalreservediffx,entryentity2.totalreservediffw2 totalreservediffw,entryentity2.totalreservediffy2 totalreservediffy";
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("costobject", (DataType)DataType.LongType), new Field("costcenter", (DataType)DataType.LongType), new Field("manuorg", (DataType)DataType.LongType), new Field("type", (DataType)DataType.StringType), new Field("relacostobject", (DataType)DataType.LongType), new Field("material", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("mversion", (DataType)DataType.LongType), new Field("configuredcode", (DataType)DataType.LongType), new Field("tracknumber", (DataType)DataType.LongType), new Field("project", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType), new Field("keycol", (DataType)DataType.StringType), new Field("keycolid", (DataType)DataType.LongType), new Field("costelement", (DataType)DataType.LongType), new Field("costsubelement", (DataType)DataType.LongType), new Field("startqty", (DataType)DataType.BigDecimalType), new Field("startamt", (DataType)DataType.BigDecimalType), new Field("totalqty", (DataType)DataType.BigDecimalType), new Field("totalamt", (DataType)DataType.BigDecimalType), new Field("totaldiffqty", (DataType)DataType.BigDecimalType), new Field("totalmadediff", (DataType)DataType.BigDecimalType), new Field("totalmadeupamt", (DataType)DataType.BigDecimalType), new Field("totalunjoindiffamt", (DataType)DataType.BigDecimalType), new Field("totalstdcostupamt", (DataType)DataType.BigDecimalType), new Field("totalorddiff", (DataType)DataType.BigDecimalType), new Field("totalinvoicediff", (DataType)DataType.BigDecimalType), new Field("totalfeediff", (DataType)DataType.BigDecimalType), new Field("totalotherdiff", (DataType)DataType.BigDecimalType), new Field("totalfalldiff", (DataType)DataType.BigDecimalType), new Field("totalreservediffx", (DataType)DataType.BigDecimalType), new Field("totalreservediffw", (DataType)DataType.BigDecimalType), new Field("totalreservediffy", (DataType)DataType.BigDecimalType)});
        return new OrmInput("DiffCalc-getPreDiffResult", "sca_diffcalcresult", selectFields, qFilter.toArray(), rowMeta);
    }

    public static DataSet getCalcResultCostobjectDs(DiffCalcDataArgs args) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getFinishProInfo", (String)"sca_calcresult", (String)"costobject", (QFilter[])qFilter.toArray(), null);
    }

    public static OrmInput getCalcResultCompDs(DiffCalcDataArgs args, String dataType, Collection<Long> costobjectIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("entryentity.datatype", "=", (Object)dataType);
        qFilter.and("costobject", "in", costobjectIds);
        String decimalFields = "entryentity.pdstartqty startqty,entryentity.pdstartamount startamt, entryentity.pdcurrqty currqty,entryentity.pdcurramount curramt, entryentity.pdcompqty compqty,entryentity.pdcompanount compamt, entryentity.pdendqty endqty,entryentity.pdendamount endamt, entryentity.diff diff, entryentity.stdqty totalqty,entryentity.stdamount totalamt";
        String selectFields = "costobject,entryentity.obj relacostobject,entryentity.difftype difftype,entryentity.element element,entryentity.subelement subelement,entryentity.material material,entryentity.matversion mversion,entryentity.auxpty auxpty,entryentity.keycol keycol,entryentity.keycolid keycolid," + decimalFields;
        return new OrmInput("DiffCalc-getFinishProInfo", "sca_calcresult", selectFields, qFilter.toArray());
    }

    public static OrmInput getCalcResultCompKeycolDs(DiffCalcDataArgs args, String dataType, Collection<Long> costobjectIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("entryentity.datatype", "=", (Object)dataType);
        qFilter.and("entryentity.subentryentity.id", ">", (Object)0L);
        qFilter.and("costobject", "in", costobjectIds);
        String selectFields = "costobject,entryentity.obj relacostobject,entryentity.subelement subelement,entryentity.material material,entryentity.matversion mversion,entryentity.auxpty auxpty,entryentity.keycolid keycolid,entryentity.subentryentity.calckeycol calckeycol,entryentity.subentryentity.subcurrqty subcurrqty";
        return new OrmInput("DiffCalc-getCalcResultCompKeycolDs", "sca_calcresult", selectFields, qFilter.toArray());
    }

    public static OrmInput getCalcResultSumDs(DiffCalcDataArgs args, Collection<Long> costobjectIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("entryentity.datatype", "in", (Object)new String[]{"98", "99"});
        qFilter.and("costobject", "in", costobjectIds);
        String selectFields = "'5' type,costobject,entryentity.obj relacostobject,0L element,0L subelement,entryentity.obj.material material,entryentity.obj.bomversion mversion,entryentity.obj.auxpty auxpty,'' keycol,0L keycolid,entryentity.pdstartqty startqty,entryentity.pdstartamount startamt, entryentity.pdcurrqty currqty,entryentity.pdcurramount curramt, entryentity.pdcompqty compqty,entryentity.pdcompanount compamt, entryentity.pdendqty endqty,entryentity.pdendamount endamt, entryentity.stdqty totalqty,entryentity.stdamount totalamt";
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("type", (DataType)DataType.StringType), new Field("costobject", (DataType)DataType.LongType), new Field("relacostobject", (DataType)DataType.LongType), new Field("element", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.LongType), new Field("material", (DataType)DataType.LongType), new Field("mversion", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("keycol", (DataType)DataType.StringType), new Field("keycolid", (DataType)DataType.LongType), new Field("startqty", (DataType)DataType.BigDecimalType), new Field("startamt", (DataType)DataType.BigDecimalType), new Field("currqty", (DataType)DataType.BigDecimalType), new Field("curramt", (DataType)DataType.BigDecimalType), new Field("compqty", (DataType)DataType.BigDecimalType), new Field("compamt", (DataType)DataType.BigDecimalType), new Field("endqty", (DataType)DataType.BigDecimalType), new Field("endamt", (DataType)DataType.BigDecimalType), new Field("totalqty", (DataType)DataType.BigDecimalType), new Field("totalamt", (DataType)DataType.BigDecimalType)});
        return new OrmInput("DiffCalc-getFinishProInfo", "sca_calcresult", selectFields, qFilter.toArray(), rowMeta);
    }

    public static OrmInput getCalcResultUnabsoubDs(DiffCalcDataArgs args, Collection<Long> costobjectIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("unabsorbentry.mfgsubelement", ">", (Object)0L);
        qFilter.and("unabsorbentry.mfgtype", "=", (Object)"1");
        qFilter.and("unabsorbentry.mfgprotype", "!=", (Object)"B");
        qFilter.and("costobject", "in", costobjectIds);
        String selectFields = "costobject,unabsorbentry.mfgobj relacostobject,unabsorbentry.mfgelement element,unabsorbentry.mfgelement.type elementType,unabsorbentry.mfgsubelement subelement,unabsorbentry.mfgobj.material as material,0L as mversion,0L as auxpty,'' as keycol,0L as keycolid,unabsorbentry.mfgpdendamt endunjoindiffamt,unabsorbentry.mfgpddiffamt compunjoindiffamt,unabsorbentry.mfgpdcurramt currunjoindiffamt,unabsorbentry.mfgpdstartamt startunjoindiffamt";
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("costobject", (DataType)DataType.LongType), new Field("relacostobject", (DataType)DataType.LongType), new Field("element", (DataType)DataType.LongType), new Field("elementType", (DataType)DataType.StringType), new Field("subelement", (DataType)DataType.LongType), new Field("material", (DataType)DataType.LongType), new Field("mversion", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("keycol", (DataType)DataType.StringType), new Field("keycolid", (DataType)DataType.LongType), new Field("endunjoindiffamt", (DataType)DataType.BigDecimalType), new Field("compunjoindiffamt", (DataType)DataType.BigDecimalType), new Field("currunjoindiffamt", (DataType)DataType.BigDecimalType), new Field("startunjoindiffamt", (DataType)DataType.BigDecimalType)});
        return new OrmInput("DiffCalc-getFinishProInfo", "sca_calcresult", selectFields, qFilter.toArray(), rowMeta);
    }

    public static OrmInput getPreDiffCalcResultCompDs(DiffCalcDataArgs args, Collection<Long> costobjectIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPrePeriodId());
        qFilter.and("entryentity1.type1", "=", (Object)"1");
        qFilter.and("costobject", "in", costobjectIds);
        String selectFields = "costobject,entryentity1.relacostobject1 relacostobject,entryentity1.element1 element,entryentity1.subelement1 subelement,entryentity1.material1 material,entryentity1.auxpty1 auxpty,entryentity1.matversion1 mversion,entryentity1.keycol1 keycol,entryentity1.keycol1id keycolid,entryentity1.totaldiffqty1 totaldiffqty,entryentity1.totalmadediff1 totalmadediff,entryentity1.totalmadeupamt1 totalmadeupamt,entryentity1.totalunjoindiffamt1 totalunjoindiffamt,entryentity1.totalstdcostupamt1 totalstdcostupamt,entryentity1.totalorddiff1 totalorddiff,entryentity1.totalinvoicediff1 totalinvoicediff,entryentity1.totalfeediff1 totalfeediff,entryentity1.totalfalldiff1 totalfalldiff,entryentity1.totalotherdiff1 totalotherdiff,entryentity1.totalreservediffx1 totalreservediffx,entryentity1.totalreservediffw1 totalreservediffw,entryentity1.totalreservediffy1 totalreservediffy";
        return new OrmInput("DiffCalc-getDiffCalcResult", "sca_diffcalcresult", selectFields, qFilter.toArray());
    }

    public static OrmInput getDiffCalcResultSubDs(DiffCalcDataArgs args, Collection<Long> costobjectIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriodId());
        qFilter.and("entryentity2.id", ">", (Object)0L);
        qFilter.and("entryentity2.type2", "=", (Object)"5");
        qFilter.and("costobject", "in", costobjectIds);
        String selectFields = "costobject,entryentity2.relacostobject2 relacostobject,entryentity2.material2 material,entryentity2.auxpty2 auxpty,entryentity2.matversion2 mversion,entryentity2.keycol2 keycol,entryentity2.keycol2id keycolid,entryentity2.element2 element,entryentity2.subelement2 subelement,entryentity2.startdiffqty2 startdiffqty,entryentity2.startmadediff2 startmadediff,entryentity2.startmadeupamt2 startmadeupamt,entryentity2.startunjoindiffamt2 startunjoindiffamt,entryentity2.startstdcostupamt2 startstdcostupamt,entryentity2.startorddiff2 startorddiff,entryentity2.startinvoicediff2 startinvoicediff,entryentity2.startfeediff2 startfeediff,entryentity2.startotherdiff2 startotherdiff,entryentity2.startfalldiff2 startfalldiff,entryentity2.startreservediffx2 startreservediffx,entryentity2.startreservediffw2 startreservediffw,entryentity2.startreservediffy2 startreservediffy,entryentity2.currdiffqty2 currdiffqty,entryentity2.currmadediff2 currmadediff,entryentity2.currmadeupamt2 currmadeupamt,entryentity2.currunjoindiffamt2 currunjoindiffamt,entryentity2.currstdcostupamt2 currstdcostupamt,entryentity2.currorddiff2 currorddiff,entryentity2.currinvoicediff2 currinvoicediff,entryentity2.currfeediff2 currfeediff,entryentity2.currotherdiff2 currotherdiff,entryentity2.currfalldiff2 currfalldiff,entryentity2.currreservediffx2 currreservediffx,entryentity2.currreservediffw2 currreservediffw,entryentity2.currreservediffy2 currreservediffy,entryentity2.compdiffqty2 compdiffqty,entryentity2.compmadediff2 compmadediff,entryentity2.compmadeupamt2 compmadeupamt,entryentity2.compunjoindiffamt2 compunjoindiffamt,entryentity2.compstdcostupamt2 compstdcostupamt,entryentity2.comporddiff2 comporddiff,entryentity2.compinvoicediff2 compinvoicediff,entryentity2.compfeediff2 compfeediff,entryentity2.compotherdiff2 compotherdiff,entryentity2.compfalldiff2 compfalldiff,entryentity2.compreservediffx2 compreservediffx,entryentity2.compreservediffw2 compreservediffw,entryentity2.compreservediffy2 compreservediffy,entryentity2.enddiffqty2 enddiffqty,entryentity2.endmadediff2 endmadediff,entryentity2.endmadeupamt2 endmadeupamt,entryentity2.endunjoindiffamt2 endunjoindiffamt,entryentity2.endstdcostupamt2 endstdcostupamt,entryentity2.endorddiff2 endorddiff,entryentity2.endinvoicediff2 endinvoicediff,entryentity2.endfeediff2 endfeediff,entryentity2.endotherdiff2 endotherdiff,entryentity2.endfalldiff2 endfalldiff,entryentity2.endreservediffx2 endreservediffx,entryentity2.endreservediffw2 endreservediffw,entryentity2.endreservediffy2 endreservediffy";
        return new OrmInput("DiffCalc-getDiffCalcResult", "sca_diffcalcresult", selectFields, qFilter.toArray());
    }

    public static DataSet getCostobjectDs(Set<Long> costobjectIds) {
        QFilter qFilter = new QFilter("id", "in", costobjectIds);
        return QueryServiceHelper.queryDataSet((String)"DiffCalc-getDiffCalcResult", (String)"cad_costobject", (String)"id,billno,costcenter,manuorg,probill,material,bomversion mversion,auxpty,material.baseunit baseunit,configuredcode,tracknumber,projectnumber project,lot,srcbillnumber,srcbillrow", (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet getMftOrder(Set<Long> proIds) {
        QFilter qFilter = new QFilter("treeentryentity.id", "in", proIds);
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"DiffCalc-mftorder", (String)"pom_mftorder", (String)"billtype,treeentryentity.id entryid,treeentryentity.inwardept inwardept,treeentryentity.warehouse warehouse,treeentryentity.location location", (QFilter[])qFilter.toArray(), null);
        DataSet omResultDs = QueryServiceHelper.queryDataSet((String)"DiffCalc-mftorder", (String)"om_mftorder", (String)"billtype,treeentryentity.id entryid,treeentryentity.inwardept inwardept,treeentryentity.warehouse warehouse,treeentryentity.location location", (QFilter[])qFilter.toArray(), null);
        return resultDs.union(omResultDs);
    }

    public static DataSet getStWarehouse(Collection<Long> stOrgs) {
        QFilter qFilter = new QFilter("org", "in", stOrgs);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"DiffCalc-mftorder", (String)"im_warehousesetup", (String)"org,warehouse.number num,warehouse", (QFilter[])qFilter.toArray(), null);
        return ds.orderBy(new String[]{"num asc"});
    }

    public static DataSet getCostcenterAndCostobjectDs(Set<Long> costobjectIds) {
        if (costobjectIds == null || costobjectIds.size() < 200000) {
            QFilter qFilter = new QFilter("id", "in", costobjectIds);
            return QueryServiceHelper.queryDataSet((String)"DiffCalc-getCostcenterAndCostobjectDs", (String)"cad_costobject", (String)"id,costcenter", (QFilter[])qFilter.toArray(), null);
        }
        return InFilterHelper.queryDataSetIn((String)"cad_costobject", (String)"id,costcenter", null, (String)"id", new ArrayList<Long>(costobjectIds));
    }

    public static List<List<Long>> splitLists(List<Long> sourceList, int groupSize) {
        int length = sourceList.size();
        int num = (length + groupSize - 1) / groupSize;
        ArrayList<List<Long>> newList = new ArrayList<List<Long>>(num);
        for (int i = 0; i < num; ++i) {
            int fromIndex = i * groupSize;
            int toIndex = (i + 1) * groupSize < length ? (i + 1) * groupSize : length;
            newList.add(sourceList.subList(fromIndex, toIndex));
        }
        return newList;
    }
}

