/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.check.SingleCalcCheckContext;
import kd.macc.sca.algox.calc.input.CalcMaterial;

public class RestoreCheckerCommon {
    private static final Log logger = LogFactory.getLog(RestoreCheckerCommon.class);

    public static void dealNestMaterial(CalcCheckContext param, SingleCalcCheckContext singleCheckContext, List<CalcMaterial> nestMats) {
        HashSet<Long> nestPathMatIds = new HashSet<Long>(16);
        for (CalcMaterial nestMat : nestMats) {
            String idPath = nestMat.getPath();
            String[] split = idPath.split("@");
            for (String id : split) {
                nestPathMatIds.add(Long.parseLong(id));
            }
        }
        HashMap<String, String> matIdAndName = new HashMap<String, String>(16);
        QFilter matIdQf = new QFilter("id", "in", nestPathMatIds);
        DataSet materialBills = QueryServiceHelper.queryDataSet((String)"material", (String)"bd_material", (String)"id,name", (QFilter[])matIdQf.toArray(), null);
        for (Row materialBill : materialBills) {
            matIdAndName.put(materialBill.getString("id"), materialBill.getString("name"));
        }
        HashMap<String, List> matIdAndMatAllocBillNo = new HashMap<String, List>(16);
        QFilter matAllocQf = new QFilter("material", "in", nestPathMatIds);
        matAllocQf.and("costaccount", "=", (Object)param.getCostAccountId());
        matAllocQf.and("period", "=", (Object)param.getPeriodId());
        matAllocQf.and("allocstatus", "=", (Object)"2");
        matAllocQf.and("appnum", "=", (Object)"sca");
        DataSet matAllocBills = QueryServiceHelper.queryDataSet((String)"matalloc", (String)"sca_matalloc", (String)"material,billno,entryentity.costobejctentry.material.id srcmat", (QFilter[])matAllocQf.toArray(), null);
        for (Row matAllocBill : matAllocBills) {
            String matAllocKey = matAllocBill.getString("srcmat") + "@" + matAllocBill.getString("material");
            matIdAndMatAllocBillNo.computeIfAbsent(matAllocKey, v -> new ArrayList()).add(matAllocBill.getString("billno"));
        }
        HashMap<String, List> matIdAndCalBillNo = new HashMap<String, List>(16);
        QFilter billGroupQF = new QFilter("entryentity.material", "in", nestPathMatIds);
        billGroupQF.and("entryentity.costaccount.id", "=", (Object)param.getCostAccountId());
        billGroupQF.and("entryentity.period", "=", (Object)param.getPeriodId());
        DataSet accountGroupRecords = QueryServiceHelper.queryDataSet((String)"account_grouprecord", (String)"cal_account_grouprecord", (String)"bizgrouprecordid", (QFilter[])billGroupQF.toArray(), null);
        HashSet bizGroupRecordId = Sets.newHashSet();
        for (Row row : accountGroupRecords) {
            bizGroupRecordId.add(row.getLong("bizgrouprecordid"));
        }
        DataSet groupBillRecords = QueryServiceHelper.queryDataSet((String)"groupbillrecord", (String)"cal_groupbillrecord", (String)"id,entryentity.billno as billno, entryentity.material material ,entryentity.type type", (QFilter[])new QFilter("id", "in", (Object)bizGroupRecordId).toArray(), null);
        HashMap<Long, String> groupIdAndSrcMatId = new HashMap<Long, String>(16);
        for (Row groupBillRecord : groupBillRecords) {
            String srcMatId;
            String type = groupBillRecord.getString("type");
            if ("0".equals(type)) {
                groupIdAndSrcMatId.put(groupBillRecord.getLong("id"), groupBillRecord.getString("material"));
                continue;
            }
            if (!"1".equals(type) || (srcMatId = (String)groupIdAndSrcMatId.get(groupBillRecord.getLong("id"))) == null) continue;
            String calBillKey = groupBillRecord.getString("material") + "@" + srcMatId;
            matIdAndCalBillNo.computeIfAbsent(calBillKey, v -> new ArrayList()).add(groupBillRecord.getString("billno"));
        }
        for (CalcMaterial nestMat : nestMats) {
            String[] numberPaths = nestMat.getNumberPath().split("@");
            String[] idPaths = nestMat.getPath().split("@");
            if (idPaths.length < 2) continue;
            String[] matInfos = new String[idPaths.length];
            StringBuilder matNumberAndName = new StringBuilder();
            for (int i = 0; i < idPaths.length; ++i) {
                String name = (String)matIdAndName.get(idPaths[i]);
                matInfos[i] = name != null ? numberPaths[i] + "/" + name : numberPaths[i];
                matNumberAndName.append("->").append(matInfos[i]);
            }
            String matNumberAndNameStr = matNumberAndName.toString();
            matNumberAndNameStr = matNumberAndNameStr.length() > 2 ? matNumberAndNameStr.substring(2) : matNumberAndNameStr;
            String parentPath = idPaths[0];
            for (int i = 1; i < idPaths.length; ++i) {
                String checkDetailMsg;
                List calBillNos;
                StringBuilder result = new StringBuilder(matNumberAndNameStr);
                result.append('\n');
                List matAllocBillNos = (List)matIdAndMatAllocBillNo.get(parentPath + "@" + idPaths[i]);
                if (matAllocBillNos != null && !matAllocBillNos.isEmpty()) {
                    result.append(matInfos[i - 1]).append("->").append(matInfos[i]).append(ResManager.loadKDString((String)"\u6d89\u53ca\u7684\u6750\u6599\u5206\u914d\u5355\u6709\uff1a", (String)"RestoreCheckerCommon_0", (String)"macc-sca-algox", (Object[])new Object[0]));
                    for (Object billno : matAllocBillNos) {
                        result.append("\u3010").append((String)billno).append('\u3011');
                    }
                }
                if ((calBillNos = (List)matIdAndCalBillNo.get(parentPath + "@" + idPaths[i])) != null && !calBillNos.isEmpty()) {
                    Object billno;
                    result.append(ResManager.loadKDString((String)"\u5b58\u8d27\u6838\u7b97-\u6210\u7ec4\u5173\u7cfb\u8bb0\u5f55\u7684\u5355\u636e\u7f16\u53f7\u6709\uff1a", (String)"RestoreCheckerCommon_1", (String)"macc-sca-algox", (Object[])new Object[0]));
                    billno = calBillNos.iterator();
                    while (billno.hasNext()) {
                        String billno2 = (String)billno.next();
                        result.append("\u3010").append(billno2).append('\u3011');
                    }
                }
                if ((checkDetailMsg = result.toString()).length() > 255) {
                    logger.info("\u8be6\u7ec6\u5d4c\u5957\u4fe1\u606f\uff1a" + checkDetailMsg);
                    checkDetailMsg = checkDetailMsg.substring(0, 254);
                }
                CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                info.setCheckDetailResult(checkDetailMsg);
                singleCheckContext.getCheckDetailResult().add(info);
                parentPath = idPaths[i];
            }
        }
    }
}

