/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.action;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algox.DataSetX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.JSONUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.dto.MaterialCodeDto;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.costrec.DebugInfoMsgHandler;
import kd.macc.sca.algox.restore.action.IDiffCalcAction;
import kd.macc.sca.algox.restore.common.CostCalcResultManager;
import kd.macc.sca.algox.restore.common.DiffCalcContext;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.restore.common.TaskRecordHeader;
import kd.macc.sca.algox.utils.CommonUtils;
import kd.macc.sca.algox.utils.DataSetXLogUtil;
import kd.macc.sca.algox.utils.RestoreCalcReportHelper;

public abstract class AbstractDiffCalcAction
implements IDiffCalcAction {
    public static final Log logger = LogFactory.getLog(AbstractDiffCalcAction.class);
    protected static final Set<String> completedTaskStatus = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("COMPLETED");
            this.add("FAILED");
            this.add("TIMEOUT");
            this.add("ABORTED");
            this.add("SKIP");
        }
    };
    private DiffCalcContext context;
    private CostCalcResultManager resultManager;

    public DiffCalcContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(DiffCalcContext context) {
        this.context = context;
    }

    public CostCalcResultManager getResultManager() {
        return this.resultManager;
    }

    @Override
    public void setResultManager(CostCalcResultManager resultManager) {
        this.resultManager = resultManager;
    }

    @Override
    public final void execute() {
        this.doExecute();
    }

    protected abstract void doExecute();

    public Map<String, MaterialCodeDto> getMaterialCodeMap() {
        if (this.getContext().getMaterialCodeMap() == null) {
            if (this.getContext().getMatLvlList() == null) {
                return null;
            }
            HashMap materialCodeMap = Maps.newHashMapWithExpectedSize((int)128);
            for (List<MaterialCodeDto> mats : this.getContext().getMatLvlList()) {
                for (MaterialCodeDto material : mats) {
                    materialCodeMap.put(material.getMaterialKey(), material);
                }
            }
            List<List<String>> nestMatGroups = this.getContext().getNestMatGroups();
            for (List<String> nestMatGroup : nestMatGroups) {
                for (String mat : nestMatGroup) {
                    if (materialCodeMap.containsKey(mat)) continue;
                    MaterialCodeDto material = DiffCalcHelper.getDiffMaterialDtoFromString(mat);
                    materialCodeMap.put(mat, material);
                }
            }
            this.getContext().setMaterialCodeMap(materialCodeMap);
        }
        return this.getContext().getMaterialCodeMap();
    }

    public void logDataSet(DataSet ds, String logName, DebugInfoMsgHandler msgHander) {
        DiffCalcDataArgs args = this.getContext().getInputArgs();
        if (StringUtils.isEmpty((String)args.getDebugColValue())) {
            return;
        }
        DataSetXLogUtil.logDataSet(ds, args.getDebugColName(), args.getDebugColValue(), logName, msgHander);
    }

    public DataSetX logDataSetX(DataSetX dsx, String logName, DebugInfoMsgHandler msgHander) {
        DiffCalcDataArgs args = this.getContext().getInputArgs();
        if (StringUtils.isNotEmpty((String)args.getDebugColValue())) {
            dsx = DataSetXLogUtil.logDataSetX(dsx, args.getDebugColName(), args.getDebugColValue(), logName, msgHander);
        }
        return dsx;
    }

    protected void saveDiffCalcReport() {
        RestoreCalcReportHelper.saveDiffCalcReport(this.getContext().getInputArgs().getCalcReportId(), BusinessDataServiceHelper.loadSingle((Object)this.getContext().getInputArgs().getTaskRecordId(), (String)"sca_taskrecord"));
    }

    protected void updateTaskRecordProcess(int mProgess, String status) {
        try (TXHandle handle = TX.requiresNew();){
            String curStatus;
            DynamicObject taskRecord = QueryServiceHelper.queryOne((String)"sca_taskrecord", (String)"id,status", (QFilter[])new QFilter("id", "=", (Object)this.context.getInputArgs().getTaskRecordId()).toArray());
            if (taskRecord != null && "6".equals(curStatus = taskRecord.getString("status"))) {
                this.getContext().setCalc(false);
                this.getResultManager().setSkipNextAction(true);
                TaskRecordHeader taskRecordHeader = this.getResultManager().getTaskRecorder().getTaskRecord();
                if (taskRecordHeader != null) {
                    taskRecordHeader.setStatus("6");
                }
                return;
            }
            this.getResultManager().getTaskRecorder().upateTaskRecord(mProgess, status);
            this.saveDiffCalcReport();
        }
    }

    protected int getBatchAvgSize(int batch, int totalSize) {
        if (batch <= 0) {
            return 1;
        }
        int patchSize = totalSize / batch;
        if (totalSize != patchSize * batch) {
            if (totalSize % ++patchSize == 0) {
                return totalSize / patchSize;
            }
            return totalSize / patchSize + 1;
        }
        return batch;
    }

    protected void executeBatch(String sql, List<Object[]> entrys) {
        try (TXHandle handle = TX.requiresNew();){
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, entrys);
        }
    }

    protected void executeBatch(String sql) {
        try (TXHandle handle = TX.requiresNew();){
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql);
        }
    }

    protected String sendTask(String taskName, Object params, int totalBatch, int currbatch, String taskClassName) {
        return this.sendTask(taskName, params, totalBatch, currbatch, taskClassName, null);
    }

    protected String sendTask(String taskName, Object params, int totalBatch, int currbatch, String taskClassName, Map<String, Object> values) {
        HashMap<String, Object> jobParams = new HashMap<String, Object>(10);
        jobParams.put("batchInfo", currbatch + "/" + totalBatch);
        if (values != null) {
            jobParams.putAll(values);
        }
        try {
            if (params instanceof Long) {
                jobParams.put("paramId", params);
            } else {
                jobParams.put("param", JSONUtils.toString((Object)params));
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        long timestamp = System.currentTimeMillis();
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        String opName = ResManager.loadKDString((String)"\u3010{0}\u3011\uff0c\u7b2c\u3010{1}\u3011\u6279\uff0c\u5f00\u59cb\u6267\u884c\u64cd\u4f5c\u4eba:{2}", (String)"AbstractDiffCalcAction_0", (String)"macc-sca-algox", (Object[])new Object[0]);
        opName = MessageFormat.format(opName, taskName + ",TraceId:" + RequestContext.get().getTraceId() + "/timestamp:" + timestamp, currbatch + "/" + totalBatch, RequestContext.get().getUserName());
        job.setName(opName);
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId("sca");
        job.setTaskClassname(taskClassName);
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        return JobClient.dispatch((JobInfo)job);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitTaskExecute(String taskName, Set<String> taskIds, List<Long> paramIds) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - 1);
        logger.info("this-task-is: {} total task size:{},taskID:{}", new Object[]{taskName, taskIds.size(), taskIds});
        boolean pgQuery = "1".equals(CadBgParamUtils.getCadBgParamForString((String)"pgDataQuerySet", (String)"0"));
        boolean isSucc = true;
        try {
            while (true) {
                QFilter completedFilter = new QFilter("id", "in", taskIds);
                completedFilter.and("status", "in", completedTaskStatus);
                DynamicObjectCollection runningTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])completedFilter.toArray());
                if (runningTasks.size() == taskIds.size()) {
                    QFilter failTtaskFilter = new QFilter("id", "in", taskIds);
                    failTtaskFilter.and("status", "=", (Object)"FAILED");
                    failTtaskFilter.and("runtime", ">=", (Object)calendar.getTime());
                    DynamicObjectCollection failTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])failTtaskFilter.toArray());
                    if (failTasks != null && failTasks.size() > 0) {
                        isSucc = false;
                        throw new KDBizException(taskName + "task\uff0cPartitionTaskService.execute failed\u3002");
                    }
                    return;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.error((Throwable)e);
                    throw new KDBizException(taskName + "task\uff0cPartitionTaskService.execute interrupt\u3002");
                }
                if (!pgQuery) continue;
                QFilter filter = new QFilter("id", "=", (Object)0L);
                QueryServiceHelper.queryOne((String)"sca_parparam", (String)"id", (QFilter[])filter.toArray());
            }
        }
        finally {
            if (!CadEmptyUtils.isEmpty(paramIds) && isSucc) {
                try (TXHandle handle = TX.requiresNew();){
                    QFilter filter = new QFilter("id", "in", paramIds);
                    int x = DeleteServiceHelper.delete((String)"sca_parparam", (QFilter[])filter.toArray());
                    logger.info("\u3010\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u3011\u5220\u9664\u5e76\u884c\u8ba1\u7b97\u7684\u65e5\u5fd7 {} \u6761\u6807\u8bc6\u7684\u8bb0\u5f55", (Object)x);
                }
            }
        }
    }

    protected Long genParParamDynId(String type, Object param, List<DynamicObject> dyns) {
        Long id = ID.genLongId();
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"sca_parparam");
        dyn.set("id", (Object)id);
        dyn.set("type", (Object)type);
        dyn.set("createtime", (Object)TimeServiceHelper.now());
        dyn.set("param_tag", (Object)JSON.toJSONString((Object)param));
        dyns.add(dyn);
        return id;
    }

    protected boolean scaDiffColExecute() {
        if (this.getContext().getScaDiffColExe() == null) {
            this.getContext().setScaDiffColExe(CadBgParamUtils.getCadBgParamForString((String)"scaDiffColExe", (String)"1"));
        }
        return "1".equals(this.getContext().getScaDiffColExe());
    }
}

