/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.action;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.dto.MaterialCodeDto;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.sca.algox.costrec.DebugInfoMsgHandler;
import kd.macc.sca.algox.restore.CalServiceHelper;
import kd.macc.sca.algox.restore.DiffCalcDataInputFactory;
import kd.macc.sca.algox.restore.action.DiffCalcBaseAction;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.restore.function.DiffAllocActAmtCalcSumFunction;
import kd.macc.sca.algox.restore.function.DiffAllocBillSaveFunction;
import kd.macc.sca.algox.restore.function.DiffAllocCostAdustIdCollectFunction;
import kd.macc.sca.algox.restore.function.DiffAllocInCostCalcSumFunction;
import kd.macc.sca.algox.restore.function.DiffAllocMainJoinAllocSumFunction;
import kd.macc.sca.algox.restore.function.DiffAllocMatBillStdCalcFunction;
import kd.macc.sca.algox.restore.function.DiffAllocPubMatAllocFunction;
import kd.macc.sca.algox.restore.function.DiffAllocResultSumDealFunction;
import kd.macc.sca.algox.restore.function.DiffAllocSubCalcResultSaveFunction;
import kd.macc.sca.algox.restore.function.DiffCommonDifftypeTranFunction;
import kd.macc.sca.algox.restore.function.DiffTransOutCalcRadioFunction;
import kd.macc.sca.algox.restore.function.DiffTransOutDealRightJoinFunction;
import kd.macc.sca.algox.restore.function.DiffTransOutDealVouDataFunction;
import kd.macc.sca.algox.restore.function.DiffTransOutDealVoucherAmtFunction;
import kd.macc.sca.algox.restore.function.DiffTransOutReworkFilterFunction;
import kd.macc.sca.algox.restore.function.DiffTransOutTransDiffTypeFunction;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;
import kd.macc.sca.common.helper.ProAllocStdHelper;

public class DiffCalcAction
extends DiffCalcBaseAction {
    private static final String[] DIFF_TRANSOUT_GROUP_FIELDS = new String[]{"createtype", "costobject", "product", "element", "subelement"};

    @Override
    protected void diffTransOutDeal(DiffCalcDataArgs args, List<MaterialCodeDto> calMats, List<List<String>> preNestMatGroups, boolean isRework, DebugInfoMsgHandler msgHander, int level) {
        DataSetX costadjustDsx;
        long start = System.currentTimeMillis();
        Set<Long> calMatIds = DiffCalcHelper.getDimMatIdMapFromLvl(calMats);
        DataSet matDimDs = null;
        if (this.getContext().isContainsMaterialOtherDim()) {
            matDimDs = DiffCalcHelper.getDimMatDsFromLvl(calMats);
        }
        DataSet factDs = DiffCalcDataInputFactory.getTransOutMatFactDs(args, calMatIds);
        this.logDataSet(factDs, ResManager.loadKDString((String)"\u672c\u5c42\u7684\u5b8c\u5de5\u5165\u5e93\uff1a", (String)"DiffCalcAction_11", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        Set<Long> sourceEntryIds = ScaCalcHelper.getLongIdSetFromDs(factDs, "sourcebillentry", true);
        boolean isSplitType = CadBgParamUtils.getCadParamForInt((String)"diffCalcSplitType", (int)0) == 1;
        DataSet purAllocDs = DiffCalcDataInputFactory.getPurchDiffAllocElementInfo(args, calMatIds);
        this.logDataSet(purAllocDs, ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u914d\u5355\uff08\u5b8c\u5de5\uff09\uff1a", (String)"DiffCalcAction_12", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        OrmInput finishDiffDs = null;
        OrmInput unAbsoubDiffDs = null;
        if (!isRework) {
            finishDiffDs = DiffCalcDataInputFactory.getFinishDiffElementInfo(args, calMatIds, isSplitType);
            unAbsoubDiffDs = DiffCalcDataInputFactory.getUnAbsorbDiffElementInfo(args, calMatIds, isSplitType);
        }
        if (isRework && purAllocDs.isEmpty()) {
            return;
        }
        OrmInput costrecordDs = DiffCalcDataInputFactory.getCalCostRecordInfoByBizEntryId(args, sourceEntryIds);
        logger.info("\u5dee\u5f02\u5206\u644a-\u5dee\u5f02\u8f6c\u51fa-{}\u5c42-\u51c6\u5907\u6570\u636e\u8017\u65f6\uff1a{}", (Object)level, (Object)(System.currentTimeMillis() - start));
        JobSession session = AlgoX.createSession((String)"DiffCalcAction-diffTransout");
        DataSetX costobjectDiffDsDsX = null;
        DataSetX factDsX = session.fromInput((Input)new DataSetInput(factDs));
        DataSetX purAllocDsX = session.fromInput((Input)new DataSetInput(purAllocDs));
        DataSetX costrecordDsx = session.fromInput((Input)costrecordDs);
        DataSetX matDimDsX = null;
        if (this.getContext().isContainsMaterialOtherDim()) {
            matDimDsX = session.fromInput((Input)new DataSetInput(matDimDs));
        }
        DataSetX finishDiffDsX = null;
        DataSetX unAbsoubDiffDsX = null;
        if (!isRework) {
            finishDiffDsX = session.fromInput((Input)finishDiffDs);
            finishDiffDsX = this.logDataSetX(finishDiffDsX, ResManager.loadKDString((String)"\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u6570\u636e\uff1a", (String)"DiffCalcAction_36", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
            unAbsoubDiffDsX = session.fromInput((Input)unAbsoubDiffDs);
            unAbsoubDiffDsX = this.logDataSetX(unAbsoubDiffDsX, ResManager.loadKDString((String)"\u672a\u5438\u6536\u5dee\u5f02\u6570\u636e\uff1a", (String)"DiffCalcAction_37", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        }
        if (this.getContext().isContainsMaterialOtherDim() && matDimDsX != null) {
            matDimDsX = this.logDataSetX(matDimDsX, ResManager.loadKDString((String)"\u7ef4\u5ea6\u6570\u636e\uff1a", (String)"DiffCalcAction_45", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
            purAllocDsX = DiffCalcHelper.joinDimMatDsXToFilterDs(purAllocDsX, matDimDsX, this.getContext().getDiffMatLvlDim());
            purAllocDsX = this.logDataSetX(purAllocDsX, ResManager.loadKDString((String)"\u8fc7\u6ee4\u7ef4\u5ea6\u540e\u7684\u5dee\u5f02\u5206\u914d\u5355\u6570\u636e\uff1a", (String)"DiffCalcAction_46", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        }
        if (!CadEmptyUtils.isEmpty(preNestMatGroups)) {
            List<List<String>> preNestMatDimGroups = DiffCalcHelper.getLvlNestGroupDimList(preNestMatGroups, this.getMaterialCodeMap(), this.getContext().getDiffMatLvlDim());
            if (StringUtils.isNotEmpty((String)args.getDebugColValue())) {
                msgHander.dealInfoMsg(String.format("preNestMatDimGroups\uff1a  %s%n", preNestMatDimGroups));
            }
            purAllocDsX = purAllocDsX.groupBy(new String[]{"createtype", "costobject", "material"}).reduceGroup((GroupReduceFunction)new DiffTransOutReworkFilterFunction(preNestMatDimGroups, this.getContext().getDiffMatLvlDim(), isRework, args.getDebugColValue(), msgHander));
            purAllocDsX = this.logDataSetX(purAllocDsX, String.format(ResManager.loadKDString((String)"\u5d4c\u5957\u7ec4\u4e4b\u95f4\u8fc7\u6ee4\uff1a%s", (String)"DiffCalcAction_47", (String)"macc-sca-algox", (Object[])new Object[0]), isRework), msgHander);
        }
        if (isRework) {
            costobjectDiffDsDsX = purAllocDsX;
        } else {
            if (this.getContext().isContainsMaterialOtherDim() && matDimDsX != null) {
                finishDiffDsX = DiffCalcHelper.joinDimMatDsXToFilterDs(finishDiffDsX, matDimDsX, this.getContext().getDiffMatLvlDim());
            }
            finishDiffDsX = finishDiffDsX.map((MapFunction)new DiffTransOutTransDiffTypeFunction());
            if (this.getContext().isContainsMaterialOtherDim() && matDimDsX != null) {
                unAbsoubDiffDsX = DiffCalcHelper.joinDimMatDsXToFilterDs(unAbsoubDiffDsX, matDimDsX, this.getContext().getDiffMatLvlDim());
            }
            if (unAbsoubDiffDsX != null) {
                unAbsoubDiffDsX = unAbsoubDiffDsX.map((MapFunction)new DiffTransOutTransDiffTypeFunction());
                costobjectDiffDsDsX = DataSetXHelper.union(finishDiffDsX, unAbsoubDiffDsX);
            }
            costobjectDiffDsDsX = this.logDataSetX(costobjectDiffDsDsX, ResManager.loadKDString((String)"\u672c\u9636\u5dee\u5f02\u6570\u636e\uff1a", (String)"DiffCalcAction_13", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
            costobjectDiffDsDsX = DataSetXHelper.addBigDecimalFields(costobjectDiffDsDsX, DiffCalcHelper.DIFF_FIELD_ARR);
            costobjectDiffDsDsX = costobjectDiffDsDsX.map((MapFunction)new DiffCommonDifftypeTranFunction("", "amount"));
            costobjectDiffDsDsX = costobjectDiffDsDsX.select(DiffCalcHelper.stringArrUnion(DIFF_TRANSOUT_GROUP_FIELDS, DiffCalcHelper.DIFF_FIELD_ARR));
            purAllocDsX = DataSetXHelper.groupBySum(purAllocDsX, DIFF_TRANSOUT_GROUP_FIELDS, DiffCalcHelper.DIFF_FIELD_ARR);
            costobjectDiffDsDsX = DataSetXHelper.union(purAllocDsX, costobjectDiffDsDsX);
        }
        costobjectDiffDsDsX = this.logDataSetX(costobjectDiffDsDsX, ResManager.loadKDString((String)"\u5dee\u5f02\u6570\u636e\uff1a", (String)"DiffCalcAction_14", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        costobjectDiffDsDsX = DataSetXHelper.groupBySum(costobjectDiffDsDsX, DIFF_TRANSOUT_GROUP_FIELDS, DiffCalcHelper.DIFF_FIELD_ARR);
        costobjectDiffDsDsX = this.logDataSetX(costobjectDiffDsDsX, ResManager.loadKDString((String)"\u6c47\u603b\u5dee\u5f02\u91d1\u989d\uff1a", (String)"DiffCalcAction_15", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        JoinDataSetX costobjectDiffAndFactDsx = costobjectDiffDsDsX.leftJoin(factDsX).on("costobject", "costobject").select(costobjectDiffDsDsX.getRowMeta().getFieldNames(), new String[]{"sourcebill", "sourcebillentry", "qty"});
        costobjectDiffAndFactDsx = this.logDataSetX((DataSetX)costobjectDiffAndFactDsx, ResManager.loadKDString((String)"\u5173\u8054\u5b8c\u5de5\u5165\u5e93\u5355\uff1a", (String)"DiffCalcAction_16", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        costobjectDiffAndFactDsx = DataSetXHelper.addBigDecimalFields((DataSetX)costobjectDiffAndFactDsx, DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "comp"));
        costobjectDiffAndFactDsx = costobjectDiffAndFactDsx.groupBy(new String[]{"createtype", "costobject", "product", "element", "subelement"}).reduceGroup((GroupReduceFunction)new DiffTransOutCalcRadioFunction(args));
        costobjectDiffAndFactDsx = this.logDataSetX((DataSetX)costobjectDiffAndFactDsx, ResManager.loadKDString((String)"\u8f6c\u51fa\u6bd4\u4f8b\u8ba1\u7b97\uff1a", (String)"DiffCalcAction_17", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        costobjectDiffAndFactDsx = costobjectDiffAndFactDsx.leftJoin(costrecordDsx).on("sourcebillentry", "srcbillentryid").select(costobjectDiffAndFactDsx.getRowMeta().getFieldNames(), costrecordDsx.getRowMeta().getFieldNames());
        costobjectDiffAndFactDsx = this.logDataSetX((DataSetX)costobjectDiffAndFactDsx, ResManager.loadKDString((String)"\u6210\u672c\u5bf9\u8c61\u5dee\u5f02-\u5173\u8054\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff1a", (String)"DiffCalcAction_38", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        DataSetX costRecordCalcInDsx = costobjectDiffAndFactDsx.filter("id is not null");
        DataSetX notCostRecordCalcInDsx = costobjectDiffAndFactDsx.filter("id is null");
        if (!isRework && (costadjustDsx = DiffCalcDataInputFactory.getCostAdjustTranoutData(args, calMatIds, session)) != null) {
            String[] vouDiffFields = this.getCostAdjustVouFields();
            String[] vouAmtDiffFields = DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "excomp");
            costadjustDsx = DataSetXHelper.groupBySum(costadjustDsx, new String[]{"createtype", "rentryid", "costobjectId", "relement", "rsubelement"}, vouAmtDiffFields);
            costadjustDsx = this.logDataSetX(costadjustDsx, ResManager.loadKDString((String)"\u5dee\u5f02\u8f6c\u51fa-\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u5dee\u5f02\uff1a", (String)"DiffCalcAction_39", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
            costRecordCalcInDsx = this.costRecordCalcInDealVou(costRecordCalcInDsx, costadjustDsx, vouDiffFields, msgHander);
            notCostRecordCalcInDsx = this.notcostRecordCalcInDealVou(notCostRecordCalcInDsx, costadjustDsx, vouDiffFields, msgHander);
        }
        DataSetOutput costRecordCalcInResultSet = new DataSetOutput(costRecordCalcInDsx.getRowMeta());
        DataSetOutput notCostRecordCalcInResultSet = new DataSetOutput(notCostRecordCalcInDsx.getRowMeta());
        costRecordCalcInDsx.output((Output)costRecordCalcInResultSet);
        notCostRecordCalcInDsx.output((Output)notCostRecordCalcInResultSet);
        try {
            session.commit(2, TimeUnit.HOURS);
            logger.info("\u5dee\u5f02\u5206\u644a-\u5dee\u5f02\u8f6c\u51fa-{}\u5c42algx\u8ba1\u7b97\uff1a{}", (Object)level, (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
        }
        catch (Exception e) {
            logger.error("\u5dee\u5f02\u8f6c\u51fa\u6bd4\u4f8b\u8ba1\u7b97\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        DataSet costRecordCalcInDs = session.readDataSet(costRecordCalcInResultSet.getId());
        DataSet notCostRecordCalcInDs = session.readDataSet(notCostRecordCalcInResultSet.getId());
        this.transOutCostDiffInfo(args, costRecordCalcInDs, notCostRecordCalcInDs, msgHander);
        logger.info("\u5dee\u5f02\u5206\u644a-\u5dee\u5f02\u8f6c\u51fa-{}\u5c42\u8c03\u7528\u8f6c\u51fa\u8017\u65f6\uff1a{}", (Object)level, (Object)(System.currentTimeMillis() - start));
    }

    private DataSetX costRecordCalcInDealVou(DataSetX costRecordCalcInDsx, DataSetX costadjustDsx, String[] vouDiffFields, DebugInfoMsgHandler msgHander) {
        JoinDataSetX costRecordCalcInLeftDsx = costRecordCalcInDsx.leftJoin(costadjustDsx).on("entryid", "rentryid").on("subelement", "rsubelement").on("createtype", "createtype").select(costRecordCalcInDsx.getRowMeta().getFieldNames(), vouDiffFields);
        DataSetX costRecordCalcInRightDsx = costRecordCalcInDsx.rightJoin(costadjustDsx).on("entryid", "rentryid").on("subelement", "rsubelement").on("createtype", "createtype").select(costRecordCalcInDsx.getRowMeta().getFieldNames(), vouDiffFields).filter("costobject is null");
        costRecordCalcInDsx = costRecordCalcInLeftDsx.union(costRecordCalcInRightDsx);
        costRecordCalcInDsx = costRecordCalcInDsx.map((MapFunction)new DiffTransOutDealRightJoinFunction("rentryid", "entryid"));
        costRecordCalcInDsx = costRecordCalcInDsx.groupBy(new String[]{"entryid", "rentryid", "createtype"}).reduceGroup((GroupReduceFunction)new DiffTransOutDealVouDataFunction());
        costRecordCalcInDsx = this.logDataSetX(costRecordCalcInDsx, ResManager.loadKDString((String)"\u5dee\u5f02\u8f6c\u51fa\u5173\u8054\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u91d1\u989d\uff1a", (String)"DiffCalcAction_40", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        costRecordCalcInDsx = costRecordCalcInDsx.map((MapFunction)new DiffTransOutDealVoucherAmtFunction());
        costRecordCalcInDsx = this.logDataSetX(costRecordCalcInDsx, ResManager.loadKDString((String)"\u5dee\u5f02\u8f6c\u51fa\u5173\u8054\u6263\u51cf\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u91d1\u989d\uff1a", (String)"DiffCalcAction_41", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        return costRecordCalcInDsx;
    }

    private DataSetX notcostRecordCalcInDealVou(DataSetX notCostRecordCalcInDsx, DataSetX costadjustDsx, String[] vouDiffFields, DebugInfoMsgHandler msgHander) {
        JoinDataSetX notCostRecordCalcInLeftDsx = notCostRecordCalcInDsx.leftJoin(costadjustDsx).on("costobject", "costobjectId").on("subelement", "rsubelement").on("createtype", "createtype").select(notCostRecordCalcInDsx.getRowMeta().getFieldNames(), vouDiffFields);
        DataSetX notCostRecordCalcInRightDsx = notCostRecordCalcInDsx.rightJoin(costadjustDsx).on("costobject", "costobjectId").on("subelement", "rsubelement").on("createtype", "createtype").select(notCostRecordCalcInDsx.getRowMeta().getFieldNames(), vouDiffFields).filter("costobject is null");
        notCostRecordCalcInDsx = notCostRecordCalcInLeftDsx.union(notCostRecordCalcInRightDsx);
        notCostRecordCalcInDsx = notCostRecordCalcInDsx.map((MapFunction)new DiffTransOutDealRightJoinFunction("costobjectId", "costobject"));
        notCostRecordCalcInDsx = notCostRecordCalcInDsx.groupBy(new String[]{"costobject", "costobjectId"}).reduceGroup((GroupReduceFunction)new DiffTransOutDealVouDataFunction());
        notCostRecordCalcInDsx = this.logDataSetX(notCostRecordCalcInDsx, ResManager.loadKDString((String)"\u5dee\u5f02\u8f6c\u51fa-\u672a\u5206\u644a\u5dee\u5f02\u5173\u8054\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u91d1\u989d\uff1a", (String)"DiffCalcAction_42", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        notCostRecordCalcInDsx = notCostRecordCalcInDsx.map((MapFunction)new DiffTransOutDealVoucherAmtFunction());
        notCostRecordCalcInDsx = this.logDataSetX(notCostRecordCalcInDsx, ResManager.loadKDString((String)"\u5dee\u5f02\u8f6c\u51fa-\u672a\u5206\u644a\u5dee\u5f02\u6263\u51cf\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u91d1\u989d\uff1a", (String)"DiffCalcAction_43", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        return notCostRecordCalcInDsx;
    }

    private String[] getCostAdjustVouFields() {
        List<String> vouDiffFields = DiffCalcHelper.fieldsAddPreToList(DiffCalcHelper.DIFF_FIELD_ARR, "excomp");
        vouDiffFields.add("rentryid");
        vouDiffFields.add("costobjectId");
        vouDiffFields.add("relement");
        vouDiffFields.add("rsubelement");
        return vouDiffFields.toArray(new String[0]);
    }

    private void transOutCostDiffInfo(DiffCalcDataArgs args, DataSet costRecordCalcInDs, DataSet notCostRecordCalcInDs, DebugInfoMsgHandler msgHander) {
        Set<Map<String, Object>> stdCostDiffBillSet = this.getDiffTransOutParam(args, costRecordCalcInDs);
        if (!stdCostDiffBillSet.isEmpty() && stdCostDiffBillSet.size() > 5000) {
            logger.info("\u5dee\u5f02\u5206\u644a-\u5dee\u5f02\u8f6c\u51fa\u53c2\u6570\u4e2a\u6570-1\uff1a{}", (Object)stdCostDiffBillSet.size());
            CalServiceHelper.transOutCostDiffInfoToCalSystem(args, stdCostDiffBillSet);
            stdCostDiffBillSet.clear();
        }
        if (!notCostRecordCalcInDs.isEmpty()) {
            Set<Long> costobjectIds = ScaCalcHelper.getLongIdSetFromDs(notCostRecordCalcInDs, "costobject", true);
            stdCostDiffBillSet.addAll(this.getDiffTransOutParamByNotFact(args, notCostRecordCalcInDs, costobjectIds, msgHander));
            args.getUnAllocDiffCostobjectIds().addAll(costobjectIds);
        }
        if (!stdCostDiffBillSet.isEmpty()) {
            logger.info("\u5dee\u5f02\u5206\u644a-\u5dee\u5f02\u8f6c\u51fa\u53c2\u6570\u4e2a\u6570-2\uff1a{}", (Object)stdCostDiffBillSet.size());
            CalServiceHelper.transOutCostDiffInfoToCalSystem(args, stdCostDiffBillSet);
        }
    }

    private Set<Map<String, Object>> getDiffTransOutParamByNotFact(DiffCalcDataArgs args, DataSet calcInDataSet, Set<Long> costobjectIds, DebugInfoMsgHandler msgHander) {
        String[] compDiffAmtArr = DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "comp");
        DataSet costobjectDs = DiffCalcDataInputFactory.getCostobjectDs(costobjectIds);
        DataSet calcInCopyDataSet = costobjectDs.copy();
        calcInDataSet = calcInDataSet.leftJoin(costobjectDs).on("costobject", "id").select(DiffCalcHelper.stringArrUnion({"costobject", "product", "element", "subelement", "createtype"}, compDiffAmtArr), new String[]{"manuorg", "costcenter", "probill", "material", "mversion", "auxpty", "baseunit", "configuredcode", "tracknumber", "project", "lot", "billno", "srcbillnumber", "srcbillrow"}).finish();
        this.logDataSet(calcInDataSet, ResManager.loadKDString((String)"\u672a\u5206\u644a\u7684\u5dee\u5f02\uff1a", (String)"DiffCalcAction_18", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        HashSet probills = Sets.newHashSetWithExpectedSize((int)10);
        for (Row row : calcInCopyDataSet) {
            Long probillId = row.getLong("probill");
            if (CadEmptyUtils.isEmpty((Long)probillId)) continue;
            probills.add(probillId);
        }
        HashMap probillToBillInfoMap = Maps.newHashMapWithExpectedSize((int)10);
        if (!probills.isEmpty()) {
            DataSet probillDs = DiffCalcDataInputFactory.getMftOrder(probills);
            for (Row row : probillDs) {
                Long entryId = row.getLong("entryid");
                Long warehouse = row.getLong("warehouse");
                Long billtype = row.getLong("billtype");
                Long inwardept = row.getLong("inwardept");
                Long location = row.getLong("location");
                Object[] params = new Object[]{billtype, inwardept, warehouse, location};
                probillToBillInfoMap.put(entryId, params);
            }
        }
        return this.getDiffTransOutParamByNotFact(args, calcInDataSet, probillToBillInfoMap);
    }

    private Set<Map<String, Object>> getDiffTransOutParamByNotFact(DiffCalcDataArgs args, DataSet calcInDataSet, Map<Long, Object[]> probillToBillInfoMap) {
        HashSet stdCostDiffBillSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : calcInDataSet) {
            Long costobject = row.getLong("costobject");
            Long probill = row.getLong("probill");
            if (CadEmptyUtils.isEmpty((Long)row.getLong("material"))) {
                logger.error("costobject is null,costobject:{}", (Object)costobject);
                continue;
            }
            if (this.isCompAmtZero(row)) continue;
            Object[] params = probillToBillInfoMap.get(probill);
            HashMap<String, Object> stdCostDiffBill = new HashMap<String, Object>(16);
            stdCostDiffBill.put("isupdatecost", false);
            stdCostDiffBill.put("calorg", args.getOrgId());
            stdCostDiffBill.put("costaccount", args.getCostaccountId());
            stdCostDiffBill.put("period", args.getPeriodId());
            stdCostDiffBill.put("billtype", params == null ? Long.valueOf(0L) : params[0]);
            stdCostDiffBill.put("biztype", "A");
            stdCostDiffBill.put("cstype", "bd_supplier");
            stdCostDiffBill.put("createtype", row.getString("createtype"));
            stdCostDiffBill.put("bizdate", DateUtils.getDayStartTime((Date)args.getEndDate()));
            stdCostDiffBill.put("bookdate", DateUtils.getDayStartTime((Date)args.getEndDate()));
            stdCostDiffBill.put("currency", args.getCurrencyId());
            stdCostDiffBill.put("material", row.getLong("material"));
            stdCostDiffBill.put("storageorgunit", params == null ? Long.valueOf(0L) : params[1]);
            stdCostDiffBill.put("mversion", row.getLong("mversion"));
            stdCostDiffBill.put("assist", row.getLong("auxpty"));
            stdCostDiffBill.put("baseunit", row.getLong("baseunit"));
            stdCostDiffBill.put("warehouse", params == null ? Long.valueOf(0L) : params[2]);
            stdCostDiffBill.put("location", params == null ? Long.valueOf(0L) : params[3]);
            stdCostDiffBill.put("lot", row.getString("lot"));
            stdCostDiffBill.put("invtype", 688884005529250816L);
            stdCostDiffBill.put("invstatus", 691928582720825344L);
            stdCostDiffBill.put("ownertype", "bos_org");
            stdCostDiffBill.put("owner", args.getOrgId());
            stdCostDiffBill.put("project", row.getLong("project"));
            stdCostDiffBill.put("invbizentityobject", "cal_costrecord_subentity");
            stdCostDiffBill.put("configuredcode", row.getLong("configuredcode"));
            stdCostDiffBill.put("tracknumber", row.getLong("tracknumber"));
            stdCostDiffBill.put("costelement", row.getLong("element"));
            stdCostDiffBill.put("costsubelement", row.getLong("subelement"));
            stdCostDiffBill.put("noupdatecalfields", " ");
            this.setDiffAmt(stdCostDiffBill, row);
            stdCostDiffBill.put("billsrctype", "D");
            stdCostDiffBill.put("srcbillid", costobject);
            stdCostDiffBill.put("srcbillnum", row.getString("srcbillnumber"));
            stdCostDiffBill.put("srcentryseq", row.getString("srcbillrow"));
            stdCostDiffBill.put("srcbillentryid", 0L);
            stdCostDiffBill.put("srcbizentityobject", "cad_costobject");
            stdCostDiffBill.put("ecostcenter", row.getLong("costcenter"));
            stdCostDiffBill.put("srcsys", "B");
            stdCostDiffBillSet.add(stdCostDiffBill);
        }
        return stdCostDiffBillSet;
    }

    private Set<Map<String, Object>> getDiffTransOutParam(DiffCalcDataArgs args, DataSet calcInDataSet) {
        HashSet stdCostDiffBillSet = Sets.newHashSetWithExpectedSize((int)16);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity");
        IDataEntityProperty property = entityType.findProperty("ynzy_costcenter");
        int costcenterIndex = calcInDataSet.getRowMeta().getFieldIndex("ynzy_costcenter", false);
        for (Row row : calcInDataSet) {
            if (CadEmptyUtils.isEmpty((Long)row.getLong("srcbillentryid"))) {
                logger.error("costrecordInfos is null,billentryid:{}" + row.getLong("sourcebillentry"));
                continue;
            }
            if (this.isCompAmtZero(row)) continue;
            HashMap<String, Object> stdCostDiffBill = new HashMap<String, Object>(16);
            stdCostDiffBill.put("calorg", args.getOrgId());
            stdCostDiffBill.put("costaccount", args.getCostaccountId());
            stdCostDiffBill.put("period", args.getPeriodId());
            stdCostDiffBill.put("billtype", row.getLong("billtype"));
            stdCostDiffBill.put("biztype", "A");
            stdCostDiffBill.put("cstype", "bd_supplier");
            stdCostDiffBill.put("createtype", row.getString("createtype"));
            stdCostDiffBill.put("bizdate", DateUtils.getDayStartTime((Date)args.getEndDate()));
            stdCostDiffBill.put("bookdate", DateUtils.getDayStartTime((Date)args.getEndDate()));
            stdCostDiffBill.put("currency", args.getCurrencyId());
            stdCostDiffBill.put("material", row.getLong("material"));
            stdCostDiffBill.put("storageorgunit", row.getLong("storageorgunit"));
            stdCostDiffBill.put("mversion", row.getLong("mversion"));
            stdCostDiffBill.put("assist", row.getLong("auxpty"));
            stdCostDiffBill.put("lot", row.getString("lot"));
            stdCostDiffBill.put("baseunit", row.getLong("baseunit"));
            stdCostDiffBill.put("warehouse", row.getLong("warehouse"));
            stdCostDiffBill.put("location", row.getLong("location"));
            stdCostDiffBill.put("invtype", row.getLong("invtype"));
            stdCostDiffBill.put("invstatus", row.getLong("invstatus"));
            stdCostDiffBill.put("ownertype", row.get("ownertype"));
            stdCostDiffBill.put("owner", row.getLong("owner"));
            stdCostDiffBill.put("project", row.getLong("project"));
            stdCostDiffBill.put("adminorg", row.getLong("adminorg"));
            stdCostDiffBill.put("invbillnum", row.getString("billno"));
            stdCostDiffBill.put("inventryseq", row.getString("seq"));
            stdCostDiffBill.put("invbillid", row.getLong("id"));
            stdCostDiffBill.put("invbillentryid", row.getLong("entryid"));
            stdCostDiffBill.put("invbizentityobject", "cal_costrecord_subentity");
            stdCostDiffBill.put("configuredcode", row.getLong("configuredcode"));
            stdCostDiffBill.put("tracknumber", row.getLong("tracknumber"));
            stdCostDiffBill.put("costelement", row.getLong("element"));
            stdCostDiffBill.put("costsubelement", row.getLong("subelement"));
            stdCostDiffBill.put("noupdatecalfields", row.getString("noupdatecalfields"));
            this.setDiffAmt(stdCostDiffBill, row);
            stdCostDiffBill.put("billsrctype", "D");
            stdCostDiffBill.put("invbiztype", row.getLong("biztype"));
            stdCostDiffBill.put("ecostcenter", row.getLong("ecostcenter"));
            stdCostDiffBill.put("srcsys", "B");
            if (property != null && costcenterIndex >= 0) {
                stdCostDiffBill.put(property.getName(), row.getLong("ynzy_costcenter"));
            }
            if (StringUtils.isNotEmpty((String)this.getContext().getInputArgs().getDebugColValue())) {
                logger.info("stdCostDiffBill:info{}", stdCostDiffBill);
            }
            stdCostDiffBillSet.add(stdCostDiffBill);
        }
        return stdCostDiffBillSet;
    }

    private void setDiffAmt(Map<String, Object> stdCostDiffBill, Row row) {
        String[] fields;
        BigDecimal adjustamt = BigDecimal.ZERO;
        for (String field : fields = DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "comp")) {
            BigDecimal amount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(field));
            String diffField = DiffCalcHelper.getDiffTypeField(field, "comp");
            if (diffField == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            stdCostDiffBill.put(diffField, amount);
            adjustamt = adjustamt.add(amount);
        }
        stdCostDiffBill.put("adjustamt", adjustamt);
    }

    private boolean isCompAmtZero(Row row) {
        String[] fields;
        for (String field : fields = DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "comp")) {
            BigDecimal amount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(field));
            if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void diffallocDeal(int level, DiffCalcDataArgs args, List<MaterialCodeDto> curCalMats, DebugInfoMsgHandler msgHander, int batchNo, boolean isParallel) {
        String taskNo = String.format("DiffCalc-dalloc_%s_%s", level, batchNo);
        long start = System.currentTimeMillis();
        Set<Long> curCalMatIds = DiffCalcHelper.getDimMatIdMapFromLvl(curCalMats);
        DataSet dimMatDs = null;
        DataSet matDimCopyDs = null;
        if (this.getContext().isContainsMaterialOtherDim()) {
            dimMatDs = DiffCalcHelper.getDimMatDsFromLvl(curCalMats);
            matDimCopyDs = dimMatDs.copy();
        }
        DataSet fallPriceData = DiffCalcDataInputFactory.getFallPrice(args, curCalMatIds);
        Input[] costRecordDs = DiffCalcDataInputFactory.getCalCostRecordInfoByMaterialId(args, curCalMatIds, this.getContext().getDiffAllocMatQuSize());
        DataSet curMatAllocDs = DiffCalcDataInputFactory.getCurMatAllocData(args, curCalMatIds);
        if (this.getContext().isContainsMaterialOtherDim() && dimMatDs != null) {
            curMatAllocDs = DiffCalcHelper.joinDimMatDsToFilterDs(curMatAllocDs, dimMatDs, this.getContext().getDiffMatLvlDim());
        }
        OrmInput curMatCollectDs = DiffCalcDataInputFactory.getCurMatUseCollectData(args, curCalMatIds);
        this.logDataSet(curMatAllocDs, ResManager.loadKDString((String)"\u6750\u6599\u5206\u914d\u5355:", (String)"DiffCalcAction_20", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        DataSet curPurAllocDs = DiffCalcDataInputFactory.getEndPurchDiffAllocDs(args, curCalMatIds);
        if (this.getContext().isContainsMaterialOtherDim() && dimMatDs != null) {
            curPurAllocDs = DiffCalcHelper.joinDimMatDsToFilterDs(curPurAllocDs, dimMatDs, this.getContext().getDiffMatLvlDim());
        }
        DataSet curVouPurAllocDs = DiffCalcDataInputFactory.getCurPurchDiffAllocDs(args, curCalMatIds);
        if (this.getContext().isContainsMaterialOtherDim() && dimMatDs != null) {
            curVouPurAllocDs = DiffCalcHelper.joinDimMatDsToFilterDs(curVouPurAllocDs, dimMatDs, this.getContext().getDiffMatLvlDim());
        }
        this.logDataSet(curPurAllocDs, ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u914d\u5355\uff08\u5728\u4ea7\uff09:", (String)"DiffCalcAction_21", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        Set<Long> costobjectIds = this.getCostobjectIds(curMatAllocDs, curPurAllocDs, curVouPurAllocDs);
        Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap = ScaCalcHelper.getMainJoinSideCalcResultInfo(args.getOrgId(), args.getCostaccountId(), args.getPeriodId(), args.getPrePeriodId(), costobjectIds, args.getStartDate(), args.getEndDate());
        this.printObjectInfo(args, mainJoinSideCostObjectInfoMap, msgHander);
        if (!isParallel) {
            long gstart = System.currentTimeMillis();
            int size = DiffCalcHelper.generateCostobjectDiffCalcResult(args, this.getContext().getCostobjectDiffCalcResultIdMap(), costobjectIds, mainJoinSideCostObjectInfoMap);
            logger.info("\u5dee\u5f02\u5206\u644a-\u7b2c{}\u5c42\u7269\u6599\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355\u6570\u4e3a{}\uff0c\u8017\u65f6\u4e3a{}", new Object[]{taskNo, size, System.currentTimeMillis() - gstart});
        }
        if (this.getContext().getDiffProAllocStdMap() == null) {
            this.getContext().setDiffProAllocStdMap(ProAllocStdHelper.getDiffProAllocStdMap((Long)args.getOrgId(), (Long)args.getCostaccountId()));
        }
        Map<String, BigDecimal> equivalentMap = ScaCalcHelper.getEquivalentMap(args.getOrgId(), args.getCostaccountId(), null, new ArrayList<Object>(costobjectIds), true);
        OrmInput preDiffCalcResultDs = DiffCalcDataInputFactory.getPreDiffCalcResult(args, costobjectIds, curCalMatIds);
        DataSet materialSubElementDs = DiffCalcDataInputFactory.getCostTypeMaterialSubElementMap(args, curCalMatIds);
        this.logDataSet(materialSubElementDs, ResManager.loadKDString((String)"\u7269\u6599\u5bf9\u5e94\u7684\u5b50\u8981\u7d20\uff1a", (String)"DiffCalcAction_22", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        OrmInput elementDs = DiffCalcDataInputFactory.getElementDs();
        OrmInput materialBUnitDs = DiffCalcDataInputFactory.getMaterialDs(curCalMatIds);
        logger.info("\u5dee\u5f02\u5206\u644a-\u7b2c{}\u5c42\u51c6\u5907\u6570\u636e\u8017\u65f6\uff1a{}", (Object)taskNo, (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        JobSession session = AlgoX.createSession((String)taskNo);
        DataSetX curMatAllocDsX = session.fromInput((Input)new DataSetInput(curMatAllocDs));
        DataSetX costAjustDsX = DiffCalcDataInputFactory.getCostAdjustCollData(args, curCalMatIds, session, this.getContext().getDiffAllocMatQuSize(), this.getContext().isDiffCostadjBatch());
        DataSetX curPurAllocDsX = session.fromInput((Input)new DataSetInput(curPurAllocDs));
        DataSetX materialBUnitDsX = session.fromInput((Input)materialBUnitDs);
        DataSetX preDiffCalcResultDsX = session.fromInput((Input)preDiffCalcResultDs);
        DataSetX curVouPurAllocDsX = session.fromInput((Input)new DataSetInput(curVouPurAllocDs));
        DataSetX materialSubElementDsX = session.fromInput((Input)new DataSetInput(materialSubElementDs));
        DataSetX elementDsX = session.fromInput((Input)elementDs);
        DataSetX curMatCollectDsX = session.fromInput((Input)curMatCollectDs);
        DataSetX costRecordDsX = session.fromInput(costRecordDs);
        DataSetX matDimDsX = null;
        if (matDimCopyDs != null) {
            matDimDsX = session.fromInput((Input)new DataSetInput(matDimCopyDs));
        }
        DataSetX curMatAllocNotHadDetailDsX = curMatAllocDsX.select(new String[]{"matallocid", "matallocentryid", "matcollectid", "relacostobject", "material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "totalqty", "costcenter", "costobject", "manuorg", "qty", "standardcost", "standardamt"});
        DataSetX matAllocQtyStdDsx = curMatAllocNotHadDetailDsX.groupBy(new String[]{"material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costobject", "manuorg", "costcenter"}).sum("qty", "currqty").sum("standardamt", "curramt");
        if (matDimDsX != null) {
            preDiffCalcResultDsX = DiffCalcHelper.joinDimMatDsXToFilterDs(preDiffCalcResultDsX, matDimDsX, this.getContext().getDiffMatLvlDim());
        }
        DataSetX preresultMainStdDsx = preDiffCalcResultDsX.filter("costobject=relacostobject").select(new String[]{"material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costobject", "costcenter", "manuorg", "startqty", "startamt"});
        preDiffCalcResultDsX = this.dealPreDiffCalcResultDs(preDiffCalcResultDsX, materialSubElementDsX, elementDsX);
        matAllocQtyStdDsx = DataSetXHelper.addBigDecimalFields(matAllocQtyStdDsx, new String[]{"startqty", "startamt"});
        matAllocQtyStdDsx = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(matAllocQtyStdDsx, preresultMainStdDsx);
        matAllocQtyStdDsx = matAllocQtyStdDsx.groupBy(new String[]{"material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costobject", "costcenter", "manuorg"}).sum("startqty").sum("startamt").sum("currqty").sum("curramt");
        curMatAllocNotHadDetailDsX = curMatAllocNotHadDetailDsX.join(curMatCollectDsX).on("matcollectid", "matusecolectentryid").select(curMatAllocNotHadDetailDsX.getRowMeta().getFieldNames(), new String[]{"sourcebillentryid"});
        costAjustDsX = this.logDataSetX(costAjustDsX, ResManager.loadKDString((String)"\u5dee\u5f02\u5f52\u96c6\u5355-\u6570\u636e", (String)"DiffCalcAction_19", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        costAjustDsX = costAjustDsX.join(costRecordDsX).on("recordid", "recordid").on("rentryid", "rentryid").select(costAjustDsX.getRowMeta().getFieldNames(), new String[]{"bizbillid", "bizbillentryid"});
        if (fallPriceData != null && !fallPriceData.isEmpty()) {
            DataSetX fallPriceDataX = session.fromInput((Input)new DataSetInput(fallPriceData));
            costAjustDsX = DataSetXHelper.unionIfRowDiff(costAjustDsX, fallPriceDataX);
            costAjustDsX = this.logDataSetX(costAjustDsX, ResManager.loadKDString((String)"\u5dee\u5f02\u5f52\u96c6\u5355-\u6dfb\u52a0\u8dcc\u4ef7\u5dee\u5f02\u6570\u636e", (String)"DiffCalcAction_48", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        }
        JoinDataSetX curMatAllocDiffDsX = curMatAllocNotHadDetailDsX.join(costAjustDsX).on("sourcebillentryid", "bizbillentryid").select(curMatAllocNotHadDetailDsX.getRowMeta().getFieldNames(), DiffCalcHelper.stringArrUnion({"costadjustid", "adjuestbillno", "costadjustentryid", "costadjustdetailId", "costelement", "costsubelement"}, DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "curr")));
        if (this.getContext().isDiffAllocDealUAlloc()) {
            curMatAllocDiffDsX = this.matUnionAllocDeal(args, (DataSetX)curMatAllocDiffDsX, msgHander);
        }
        DataSetX matDiffCostadjstDsx = null;
        if (this.getContext().isDiffAllocSaveCadjId()) {
            matDiffCostadjstDsx = curMatAllocDiffDsX.groupBy(new String[]{"material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costobject"}).reduceGroup((GroupReduceFunction)new DiffAllocCostAdustIdCollectFunction(msgHander));
        }
        curMatAllocDiffDsX = this.matDiffUnionDsx((DataSetX)curMatAllocDiffDsX, matAllocQtyStdDsx, curPurAllocDsX, materialSubElementDsX, materialBUnitDsX, msgHander);
        curMatAllocDiffDsX = this.matDiffMainJoinAllocDsx(args, (DataSetX)curMatAllocDiffDsX, mainJoinSideCostObjectInfoMap, equivalentMap, msgHander);
        DataSetX saveMatAllocDiffDsx = this.savePurAllocBill(args, (DataSetX)curMatAllocDiffDsX, curVouPurAllocDsX, matDiffCostadjstDsx, elementDsX, mainJoinSideCostObjectInfoMap, msgHander);
        curMatAllocDiffDsX = curMatAllocDiffDsX.leftJoin(elementDsX).on("subelement", "subelement").select(curMatAllocDiffDsX.getRowMeta().getFieldNames(), new String[]{"element"});
        curMatAllocDiffDsX = this.generateDownDiffDsx(args, (DataSetX)curMatAllocDiffDsX, preDiffCalcResultDsX, materialBUnitDsX, msgHander, costobjectIds.size());
        curMatAllocDiffDsX = curMatAllocDiffDsX.groupBy(new String[]{"batchgroupId"}).reduceGroup((GroupReduceFunction)new DiffAllocSubCalcResultSaveFunction(this.getContext().getCostobjectDiffCalcResultIdMap(), args.getPeriodId(), args.getOrgId(), this.getContext().getBatchExecuteSize()));
        DataSetOutput result = new DataSetOutput(curMatAllocDiffDsX.getRowMeta());
        curMatAllocDiffDsX.output((Output)result);
        saveMatAllocDiffDsx.output((Output)new IgnoreOutput());
        try {
            session.commit(2, TimeUnit.HOURS);
            logger.info("\u5dee\u5f02\u5206\u644a-\u7b2c{}\u5c42\u51c6\u5907\u6570\u636e\u8017\u65f6\uff1a{}", (Object)taskNo, (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u5dee\u5f02\u5206\u914d\u8ba1\u7b97\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        DataSet resultDs = session.readDataSet(result.getId());
        int batch = 0;
        int saveSize = 0;
        for (Row row : resultDs) {
            ++batch;
            saveSize += row.getInteger("size").intValue();
        }
        logger.info("\u5dee\u5f02\u5206\u644a-\u7b2c{}\u5c42\u4fdd\u5b58\u6279\u6b21\u6570\u4e3a\uff1a{},\u4fdd\u5b58\u7684\u6570\u636e\uff1a{},\u6210\u672c\u5bf9\u8c61\u6570\uff1a{}", new Object[]{taskNo, batch, saveSize, costobjectIds.size()});
    }

    private DataSetX dealPreDiffCalcResultDs(DataSetX preDiffCalcResultDsX, DataSetX materialSubElementDsX, DataSetX elementDsX) {
        preDiffCalcResultDsX = preDiffCalcResultDsX.removeFields(new String[]{"id", "startqty", "startamt"});
        preDiffCalcResultDsX = preDiffCalcResultDsX.leftJoin(materialSubElementDsX).on("material", "material").select(preDiffCalcResultDsX.getRowMeta().getFieldNames(), new String[]{"subelement"});
        preDiffCalcResultDsX = preDiffCalcResultDsX.leftJoin(elementDsX).on("subelement", "subelement").select(preDiffCalcResultDsX.getRowMeta().getFieldNames(), new String[]{"element"});
        final Long defSubElementId = this.getContext().getInputArgs().getDefSubElementId();
        final Long defElementId = this.getContext().getInputArgs().getDefElementId();
        preDiffCalcResultDsX = preDiffCalcResultDsX.map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX row) {
                Long subelement = row.getLong(this.sourceRowMeta.getFieldIndex("subelement"));
                Long element = row.getLong(this.sourceRowMeta.getFieldIndex("element"));
                if (!CadEmptyUtils.isEmpty((Long)subelement) && !CadEmptyUtils.isEmpty((Long)element)) {
                    row.set(this.sourceRowMeta.getFieldIndex("costelement"), (Object)element);
                    row.set(this.sourceRowMeta.getFieldIndex("costsubelement"), (Object)subelement);
                } else if (!CadEmptyUtils.isEmpty((Long)defSubElementId) && !CadEmptyUtils.isEmpty((Long)defElementId)) {
                    row.set(this.sourceRowMeta.getFieldIndex("costelement"), (Object)defElementId);
                    row.set(this.sourceRowMeta.getFieldIndex("costsubelement"), (Object)defSubElementId);
                }
                return row;
            }
        });
        return preDiffCalcResultDsX;
    }

    private DataSetX generateDownDiffDsx(DiffCalcDataArgs args, DataSetX matAllocDiffDsx, DataSetX preDiffCalcResultDsX, DataSetX materialBUnitDsX, DebugInfoMsgHandler msgHander, int costobjectSize) {
        matAllocDiffDsx = matAllocDiffDsx.addFields(new Field[]{new Field("type", (DataType)DataType.StringType)}, new Object[]{"5"});
        matAllocDiffDsx = DataSetXHelper.addBigDecimalFields(matAllocDiffDsx, DiffCalcHelper.stringArrUnion({"totalqty", "totalamt"}, DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "total")));
        matAllocDiffDsx = matAllocDiffDsx.groupBy(new String[]{"material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costobject", "relacostobject"}).reduceGroup((GroupReduceFunction)new DiffAllocResultSumDealFunction());
        matAllocDiffDsx = this.logDataSetX(matAllocDiffDsx, ResManager.loadKDString((String)"\u6c47\u603b\u5dee\u5f02(\u5173\u8054\u6807\u51c6\u6210\u672c\u548c\u57fa\u672c\u5355\u4f4d\uff0c\u548c\u4e0a\u671f\u7684\u7d2f\u8ba1\u7ed3\u8f6c)1\uff1a", (String)"DiffCalcAction_31", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        matAllocDiffDsx = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(matAllocDiffDsx, preDiffCalcResultDsX);
        matAllocDiffDsx = this.logDataSetX(matAllocDiffDsx, ResManager.loadKDString((String)"\u6c47\u603b\u5dee\u5f02(\u5173\u8054\u6807\u51c6\u6210\u672c\u548c\u57fa\u672c\u5355\u4f4d\uff0c\u548c\u4e0a\u671f\u7684\u7d2f\u8ba1\u7ed3\u8f6c)2\uff1a", (String)"DiffCalcAction_32", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        matAllocDiffDsx = DataSetXHelper.groupBySum(matAllocDiffDsx, new String[]{"type", "material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costobject", "relacostobject", "costelement", "costsubelement"}, DiffCalcHelper.stringArrUnion({"startqty", "startamt", "currqty", "curramt", "compqty", "compamt", "endqty", "endamt", "totalqty", "totalamt"}, DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "start"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "curr"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "comp"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "end"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "total")));
        matAllocDiffDsx = DataSetXHelper.addBigDecimalFields(matAllocDiffDsx, new String[]{"startstdcost", "startactcostupamt", "currstdcost", "curractcostupamt", "compstdcost", "compactcostupamt", "endstdcost", "endactcostupamt", "totalstdcost", "totalactcostupamt"});
        matAllocDiffDsx = matAllocDiffDsx.addFields(new Field[]{new Field("batchgroupId", (DataType)DataType.IntegerType)}, new Object[]{0});
        int batchSize = costobjectSize / 50;
        if (batchSize < 16) {
            batchSize = 16;
        }
        matAllocDiffDsx = matAllocDiffDsx.groupBy(new String[]{"material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costobject", "relacostobject"}).reduceGroup((GroupReduceFunction)new DiffAllocActAmtCalcSumFunction(args, batchSize));
        matAllocDiffDsx = matAllocDiffDsx.leftJoin(materialBUnitDsX).on("material", "id").select(matAllocDiffDsx.getRowMeta().getFieldNames(), new String[]{"baseunit"});
        matAllocDiffDsx = this.logDataSetX(matAllocDiffDsx, ResManager.loadKDString((String)"\u6c47\u603b\u5dee\u5f02(\u5173\u8054\u6807\u51c6\u6210\u672c\u548c\u57fa\u672c\u5355\u4f4d\uff0c\u548c\u4e0a\u671f\u7684\u7d2f\u8ba1\u7ed3\u8f6c)3\uff1a", (String)"DiffCalcAction_44", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        return matAllocDiffDsx;
    }

    private DataSetX savePurAllocBill(DiffCalcDataArgs args, DataSetX matAllocDiffDsx, DataSetX curVouPurAllocDsX, DataSetX matDiffCostadjstDsx, DataSetX elementDsX, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap, DebugInfoMsgHandler msgHander) {
        DataSetX purAllocDiffDsx = matAllocDiffDsx.filter("costsubelement>0").select(DiffCalcHelper.stringArrUnion({"material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costobject", "relacostobject", "costelement", "costsubelement"}, DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "comp"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "end")));
        purAllocDiffDsx = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(purAllocDiffDsx, curVouPurAllocDsX);
        purAllocDiffDsx = DataSetXHelper.groupBySum(purAllocDiffDsx, new String[]{"material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costobject", "relacostobject", "costelement", "costsubelement"}, DiffCalcHelper.stringArrUnion(DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "comp"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "end")));
        if (matDiffCostadjstDsx != null) {
            purAllocDiffDsx = purAllocDiffDsx.leftJoin(matDiffCostadjstDsx).on("material", "material").on("mversion", "mversion").on("auxpty", "auxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").on("project", "project").on("lot", "lot").on("keycol", "keycol").on("costobject", "costobject").select(purAllocDiffDsx.getRowMeta().getFieldNames(), new String[]{"costadjustids"});
        }
        purAllocDiffDsx = this.logDataSetX(purAllocDiffDsx, ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u914d\u5355\u4fdd\u5b58\u524d\u6570\u636e\uff1a", (String)"DiffCalcAction_30", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        purAllocDiffDsx = purAllocDiffDsx.leftJoin(elementDsX).on("costsubelement", "subelement").select(purAllocDiffDsx.getRowMeta().getFieldNames(), new String[]{"subelementnum", "elementnum"});
        return purAllocDiffDsx.groupBy(new String[]{"material", "mversion", "auxpty"}).reduceGroup((GroupReduceFunction)new DiffAllocBillSaveFunction(args, mainJoinSideCostObjectInfoMap));
    }

    private DataSetX matDiffMainJoinAllocDsx(DiffCalcDataArgs args, DataSetX matAllocDiffDsx, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap, Map<String, BigDecimal> equivalentMap, DebugInfoMsgHandler msgHander) {
        matAllocDiffDsx = DataSetXHelper.addBigDecimalFields(matAllocDiffDsx, DiffCalcHelper.stringArrUnion({"compqty", "compamt", "endqty", "endamt"}, DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "comp"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "end")));
        matAllocDiffDsx = matAllocDiffDsx.groupBy(new String[]{"material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costobject"}).reduceGroup((GroupReduceFunction)new DiffAllocInCostCalcSumFunction(args, mainJoinSideCostObjectInfoMap, this.getContext().getDiffProAllocStdMap(), equivalentMap, msgHander));
        matAllocDiffDsx = this.logDataSetX(matAllocDiffDsx, ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u8ba1\u7b97\u540e\uff1a", (String)"DiffCalcAction_28", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        matAllocDiffDsx = matAllocDiffDsx.addFields(new Field[]{new Field("relacostobject", (DataType)DataType.LongType), new Field("relaproducttype", (DataType)DataType.StringType)}, new Object[]{0L, " "});
        matAllocDiffDsx = matAllocDiffDsx.groupBy(new String[]{"material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costobject"}).reduceGroup((GroupReduceFunction)new DiffAllocMainJoinAllocSumFunction(args, mainJoinSideCostObjectInfoMap));
        matAllocDiffDsx = this.logDataSetX(matAllocDiffDsx, ResManager.loadKDString((String)"\u4e3b\u8054\u5206\u644a\u540e\uff1a", (String)"DiffCalcAction_29", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        return matAllocDiffDsx;
    }

    private DataSetX matDiffUnionDsx(DataSetX matAllocDiffDsx, DataSetX matAllocQtyStdDsx, DataSetX curPurAllocDsX, DataSetX materialSubElementDsX, DataSetX materialBUnitDsX, DebugInfoMsgHandler msgHander) {
        matAllocDiffDsx = DataSetXHelper.groupBySum(matAllocDiffDsx, new String[]{"material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costcenter", "costobject", "manuorg", "costelement", "costsubelement"}, DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "curr"));
        matAllocDiffDsx = DataSetXHelper.addBigDecimalFields(matAllocDiffDsx, DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "start"));
        matAllocDiffDsx = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(matAllocDiffDsx, curPurAllocDsX);
        matAllocDiffDsx = matAllocDiffDsx.filter("costsubelement>0");
        matAllocDiffDsx = DataSetXHelper.addBigDecimalFields(matAllocDiffDsx, new String[]{"startqty", "startamt", "currqty", "curramt"});
        matAllocDiffDsx = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(matAllocDiffDsx, matAllocQtyStdDsx);
        matAllocDiffDsx = matAllocDiffDsx.leftJoin(materialSubElementDsX).on("material", "material").select(matAllocDiffDsx.getRowMeta().getFieldNames(), new String[]{"subelement"});
        matAllocDiffDsx = DataSetXHelper.groupByAndDataDeal(matAllocDiffDsx, new String[]{"material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "costcenter", "costobject", "manuorg", "subelement", "costelement", "costsubelement"}, DiffCalcHelper.stringArrUnion({"startamt", "curramt", "startqty", "currqty"}, DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "start"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "curr")), null, null);
        matAllocDiffDsx = matAllocDiffDsx.leftJoin(materialBUnitDsX).on("material", "id").select(matAllocDiffDsx.getRowMeta().getFieldNames(), new String[]{"baseunit", "precision"});
        matAllocDiffDsx = this.logDataSetX(matAllocDiffDsx, ResManager.loadKDString((String)"\u6309\u7269\u6599+\u6210\u672c\u5bf9\u8c61+\u5dee\u5f02\u7c7b\u578b\u5408\u5e76\uff1a", (String)"DiffCalcAction_27", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        return matAllocDiffDsx;
    }

    private DataSetX matAllocRelaStd(DiffCalcDataArgs args, DataSetX curMatAllocDsX, DataSetX matcostStdDsX) {
        DataSetX actDataSet = curMatAllocDsX.filter("subentryid != 0 and subentryid is not null");
        DataSetX stdDataSet = curMatAllocDsX.filter("subentryid == 0 or subentryid is null");
        JoinDataSetX resultDataSetDsx = stdDataSet.leftJoin(matcostStdDsX).on("matcostid", "matcostid").select(new String[]{"matallocid", "matallocentryid", "manuorg", "material", "mversion", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol", "keycolid", "matcostid", "subentryid", "costcenter", "relacostobject", "costobject", "qty", "standardcost", "standardamt"}, new String[]{"costelement", "costsubelement", "substandardcost"});
        resultDataSetDsx = DataSetXHelper.addBigDecimalFields((DataSetX)resultDataSetDsx, new String[]{"substandardamt"});
        resultDataSetDsx = resultDataSetDsx.groupBy(new String[]{"matallocid", "matallocentryid", "costobject"}).reduceGroup((GroupReduceFunction)new DiffAllocMatBillStdCalcFunction(args));
        DataSetX curMatAllocStdDsX = DataSetXHelper.unionIfRowDiffStrDefaultEmpty((DataSetX)resultDataSetDsx, actDataSet);
        return curMatAllocStdDsX.filter("costelement>0");
    }

    private DataSetX matUnionAllocDeal(DiffCalcDataArgs args, DataSetX curMatAllocDiffDsX, DebugInfoMsgHandler msgHander) {
        DataSetX directMatAllocDiffDsx = curMatAllocDiffDsX.filter("relacostobject>0");
        DataSetX publicMatAllocDiffDsx = curMatAllocDiffDsX.filter("relacostobject=0");
        publicMatAllocDiffDsx = publicMatAllocDiffDsx.groupBy(new String[]{"matallocid", "costadjustdetailId", "costsubelement"}).reduceGroup((GroupReduceFunction)new DiffAllocPubMatAllocFunction(args));
        publicMatAllocDiffDsx = this.logDataSetX(publicMatAllocDiffDsx, ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u5171\u8017\u5206\u914d\uff1a", (String)"DiffCalcAction_26", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        return directMatAllocDiffDsx.union(publicMatAllocDiffDsx);
    }

    private Set<Long> getCostobjectIds(DataSet curMatAllocDs, DataSet curPurAllocDs, DataSet curVouPurAllocDs) {
        DataSet curMatAllocCopyDs = curMatAllocDs.copy().groupBy(new String[]{"costobject"}).finish();
        Set<Long> costobjectIds = ScaCalcHelper.getLongIdSetFromDs(curMatAllocCopyDs, "costobject", false);
        DataSet curPurAllocCopyDs = curPurAllocDs.copy().groupBy(new String[]{"costobject"}).finish();
        costobjectIds.addAll(ScaCalcHelper.getLongIdSetFromDs(curPurAllocCopyDs, "costobject", false));
        DataSet curVouPurAllocCopyDs = curVouPurAllocDs.copy().groupBy(new String[]{"costobject"}).finish();
        costobjectIds.addAll(ScaCalcHelper.getLongIdSetFromDs(curVouPurAllocCopyDs, "costobject", false));
        return costobjectIds;
    }

    private void printObjectInfo(DiffCalcDataArgs args, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap, DebugInfoMsgHandler msgHander) {
        block4: {
            if (StringUtils.isNotEmpty((String)args.getDebugColValue()) && "costobject".equals(args.getDebugColName())) {
                try {
                    Long costobjectId = Long.valueOf(args.getDebugColValue());
                    Map<Long, CalcResultObjectInfo> detailsMap = mainJoinSideCostObjectInfoMap.get(costobjectId);
                    if (detailsMap != null && msgHander != null) {
                        msgHander.dealInfoMsg("\r\nCalcResultObjectInfo-" + detailsMap);
                    }
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug("\u5dee\u5f02\u5206\u644a\u8ba1\u7b97-long\u7c7b\u578b\u8f6c\u6362\u95ee\u9898\uff0c\u4e0d\u9700\u8981\u5173\u6ce8 ->{}", (Object)ex.getMessage());
                }
            }
        }
    }
}

