/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.cad.common.dto.MaterialCodeDto;
import kd.macc.cad.common.helper.MaterialLevelCompareHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.enums.CalcReportEntryEnum;
import kd.macc.sca.algox.restore.CalServiceHelper;
import kd.macc.sca.algox.restore.DiffCalcDataInputFactory;
import kd.macc.sca.algox.restore.DiffReportItemEnum;
import kd.macc.sca.algox.restore.action.AbstractDiffCalcAction;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.RestoreCalcReportHelper;
import kd.macc.sca.algox.utils.ScaCalcHelper;

public class DiffCalcClearDataAction
extends AbstractDiffCalcAction {
    private static final Log logger = LogFactory.getLog(DiffCalcClearDataAction.class);
    private static final String ALGOKEY_PRE = "DiffCalc-";

    @Override
    protected void doExecute() {
        if (this.getContext().isDiffCheck()) {
            return;
        }
        if (!this.getContext().isCalc()) {
            return;
        }
        DiffCalcDataArgs args = this.getContext().getInputArgs();
        if (this.getContext().getInputArgs().isRetryMode()) {
            this.retryModeCheckAndClear(args);
            this.getContext().getCostobjectDiffCalcResultIdMap().clear();
            this.getContext().getCostobjectDiffCalcResultIdMap().putAll(DiffCalcDataInputFactory.getCurDiffCalcResultId(args));
            return;
        }
        RestoreCalcReportHelper.changeEntryStatusById(CalcReportEntryEnum.clearResult.id);
        if (this.getMaterialCodeMap().isEmpty() && args.isSpecifyMatCalc()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u7269\u6599\u8ba1\u7b97\u65f6\u4f4e\u9636\u7801\u5c42\u7ea7\u7269\u6599\u4e3a\u7a7a\uff0c\u9000\u51fa\u8ba1\u7b97\u3002", (String)"DiffCalcClearDataAction_0", (String)"macc-sca-algox", (Object[])new Object[0]));
        }
        Collection<MaterialCodeDto> allmats = this.getMaterialCodeMap().values();
        if (args.isSpecifyMatCalc()) {
            Map<Long, Long> costobjectDiffCalcResultIdMap = this.getContext().getCostobjectDiffCalcResultIdMap();
            Set<Long> allmatIds = DiffCalcHelper.getDimMatIdMapFromLvl(allmats);
            DataSet curDiffResultDs = DiffCalcDataInputFactory.getCurDiffCalcResult(args, allmatIds);
            if (this.getContext().isContainsMaterialOtherDim()) {
                DataSet matDimDs = DiffCalcHelper.getDimMatDsFromLvl(allmats);
                curDiffResultDs = DiffCalcHelper.joinDimMatDsToFilterDs(curDiffResultDs, matDimDs, this.getContext().getDiffMatLvlDim());
            }
            for (Row row : curDiffResultDs) {
                costobjectDiffCalcResultIdMap.put(row.getLong("costobject"), row.getLong("id"));
            }
        }
        this.clearData(args, allmats);
    }

    private void retryModeCheckAndClear(DiffCalcDataArgs args) {
        DynamicObject taskRecordDyo = BusinessDataServiceHelper.loadSingle((String)"sca_taskrecord", (QFilter[])new QFilter("id", "=", (Object)args.getTaskRecordId()).toArray());
        Date recordStartTime = taskRecordDyo.getDate("starttime");
        QFilter qf = new QFilter("accountorg", "=", (Object)args.getOrgId());
        qf.and("costaccount", "=", (Object)args.getCostaccountId());
        qf.and("starttime", ">", (Object)recordStartTime);
        DynamicObjectCollection reportColl = QueryServiceHelper.query((String)"sca_calcreport", (String)"id", (QFilter[])qf.toArray());
        if (reportColl != null && reportColl.size() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6570\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5728\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u5411\u5bfc\u754c\u9762\u91cd\u65b0\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"DiffCalcBaseAction_14", (String)"macc-sca-algox", (Object[])new Object[0]));
        }
        boolean isSame = MaterialLevelCompareHelper.compareLevelCode(this.getContext().getMatLvlList(), (List)Lists.newArrayList(this.getContext().getNestMatGroups()), (Long)this.getContext().getInputArgs().getCalcReportId());
        if (!isSame) {
            throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6570\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5728\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u5411\u5bfc\u754c\u9762\u91cd\u65b0\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"DiffCalcBaseAction_14", (String)"macc-sca-algox", (Object[])new Object[0]));
        }
        String errorMsg = CalServiceHelper.ficalReCalculateCheck(taskRecordDyo.getLong("id"), taskRecordDyo.getDate("starttime"), args);
        if (errorMsg != null) {
            throw new KDBizException(ResManager.loadKDString((String)errorMsg, (String)"DiffCalcBaseAction_0", (String)"DiffCalcBaseAction_11", (Object[])new Object[0]));
        }
        int retrylevel = args.getRetryLevel();
        if (retrylevel == 99) {
            this.retryClearDataForGenResult(args);
            return;
        }
        this.retryClearData(args, retrylevel, taskRecordDyo, this.getContext().getMatLvlList());
    }

    private void clearData(DiffCalcDataArgs args, Collection<MaterialCodeDto> allmats) {
        String curItem = DiffReportItemEnum.getName(DiffReportItemEnum.CLEARPREDATA.getValue());
        this.getResultManager().getTaskRecorder().saveTaskRecordEntry(curItem, DiffReportItemEnum.CLEARPREDATA.getValue(), "2");
        this.clearDataDeal(args, allmats);
        RestoreCalcReportHelper.clearReportEntryById(CalcReportEntryEnum.clearResult.id);
        RestoreCalcReportHelper.clearReportEntryById(CalcReportEntryEnum.unProduceMatCalc.id);
        RestoreCalcReportHelper.clearReportEntryById(CalcReportEntryEnum.createDiffColl.id);
        RestoreCalcReportHelper.clearReportEntryById(CalcReportEntryEnum.createDiffAlloc.id);
        RestoreCalcReportHelper.clearReportEntryById(CalcReportEntryEnum.createDiffTransfer.id);
        this.getResultManager().getTaskRecorder().upateTaskRecordDetail(DiffReportItemEnum.CLEARPREDATA.getValue(), "4");
        this.updateTaskRecordProcess(5, "2");
    }

    private void clearDataDeal(DiffCalcDataArgs args, Collection<MaterialCodeDto> allmats) {
        Set<Long> allmatIds = DiffCalcHelper.getDimMatIdMapFromLvl(allmats);
        long time = System.currentTimeMillis();
        if (this.scaDiffColExecute()) {
            CalServiceHelper.deleteCalDiffBillsV2(args, allmatIds);
        }
        logger.info("\u5220\u9664\u5b58\u8d27\u6838\u7b97\u7684\u6210\u672c\u8c03\u6574\u5355\u6570\u636e\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        if (!args.isSpecifyMatCalc()) {
            this.expireExistsCalcResult(args, "sca_diffcalcresult", "t_sca_diffcalcresult", allmats);
            this.expireExistsCalcResult(args, "sca_purchdiffalloc", "t_sca_purchdiffalloc", allmats);
            logger.info("\u5931\u6548\u5dee\u5f02\u5206\u914d\u5355\u548c\u5dee\u5f02\u8ba1\u7b97\u7ed3\u679c\u5355\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - time));
        } else {
            ArrayList<Long> calcResultIds = new ArrayList<Long>(this.getContext().getCostobjectDiffCalcResultIdMap().values());
            if (!calcResultIds.isEmpty()) {
                StringBuilder billIds = new StringBuilder();
                Lists.partition(calcResultIds, (int)this.getContext().getBatchExecuteSize()).forEach(list -> {
                    billIds.setLength(0);
                    for (Long billId : list) {
                        billIds.append(",").append(billId);
                    }
                    try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_diffcalcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)args.getPeriodId()), new HintCondition("forgid", "=", (Object)args.getOrgId())});){
                        String deleBillSql = String.format("delete from t_sca_comdiffresultentry where fid in (%s)", billIds.substring(1));
                        String deleBillVSql = String.format("delete from t_sca_comdiffresultentry_v where fid in (%s)", billIds.substring(1));
                        this.executeBatch(deleBillSql);
                        this.executeBatch(deleBillVSql);
                    }
                });
                DataSet curSubDiffResDs = DiffCalcDataInputFactory.getCurSubDiffCalcResultIds(args, calcResultIds, allmatIds);
                if (this.getContext().isContainsMaterialOtherDim()) {
                    DataSet matDimDs = DiffCalcHelper.getDimMatDsFromLvl(allmats);
                    curSubDiffResDs = DiffCalcHelper.joinDimMatDsToFilterDs(curSubDiffResDs, matDimDs, this.getContext().getDiffMatLvlDim());
                }
                List<Long> subEntryIds = ScaCalcHelper.getLongIdListFromDs(curSubDiffResDs, "entryId", false);
                Lists.partition(subEntryIds, (int)this.getContext().getBatchExecuteSize()).forEach(list -> {
                    billIds.setLength(0);
                    for (Long billId : list) {
                        billIds.append(",").append(billId);
                    }
                    try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_diffcalcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)args.getPeriodId()), new HintCondition("forgid", "=", (Object)args.getOrgId())});){
                        String deleBillSql = String.format("delete from t_sca_subdiffresultentry where fentryid in (%s)", billIds.substring(1));
                        this.executeBatch(deleBillSql);
                    }
                });
                if (!CadEmptyUtils.isEmpty((Long)args.getCalcReportId())) {
                    Lists.partition(calcResultIds, (int)this.getContext().getBatchExecuteSize()).forEach(list -> {
                        billIds.setLength(0);
                        for (Long billId : list) {
                            billIds.append(",").append(billId);
                        }
                        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_diffcalcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)args.getPeriodId()), new HintCondition("forgid", "=", (Object)args.getOrgId())});){
                            String deleBillSql = String.format("update t_sca_diffcalcresult set fcalcreportid=%s where fid in (%s)", args.getCalcReportId(), billIds.substring(1));
                            this.executeBatch(deleBillSql);
                        }
                    });
                }
            }
            this.expireExistsCalcResult(args, "sca_purchdiffalloc", "t_sca_purchdiffalloc", allmats);
        }
    }

    private void expireExistsCalcResult(DiffCalcDataArgs args, String metadataStr, String tableStr, Collection<MaterialCodeDto> allmats) {
        QFilter delfilter = new QFilter("org.id", "=", (Object)args.getOrgId());
        delfilter.and("costaccount.id", "=", (Object)args.getCostaccountId());
        delfilter.and("period.id", "=", (Object)args.getPeriodId());
        String selectField = "id";
        if ("sca_purchdiffalloc".equals(metadataStr)) {
            delfilter.and("vouchernum", "in", (Object)new String[]{" ", ""});
            if (args.isSpecifyMatCalc()) {
                delfilter.and("material", "in", DiffCalcHelper.getDimMatIdMapFromLvl(allmats));
                selectField = "id,material,auxpty,configuredcode,tracknumber,project,lot";
            }
        }
        HashSet<Long> ids = new HashSet<Long>(10);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DiffCalc-diffResult", (String)metadataStr, (String)selectField, (QFilter[])new QFilter[]{delfilter}, null);
        if (args.isSpecifyMatCalc() && this.getContext().isContainsMaterialOtherDim()) {
            DataSet matDimDs = DiffCalcHelper.getDimMatDsFromLvl(allmats);
            dataSet = DiffCalcHelper.joinDimMatDsToFilterDs(dataSet, matDimDs, this.getContext().getDiffMatLvlDim());
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            ids.add(row.getLong(0));
        }
        if (!ids.isEmpty()) {
            List splitLists = Lists.partition(new ArrayList(ids), (int)this.getContext().getBatchExecuteSize());
            for (List spids : splitLists) {
                String sql = String.format("update %s set fcostaccountid = %s where fid in (%s)", tableStr, 999999L, this.getUpdateInSql(spids));
                if ("sca_diffcalcresult".equals(metadataStr)) {
                    ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_diffcalcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)this.getContext().getInputArgs().getPeriodId()), new HintCondition("forgid", "=", (Object)args.getOrgId())});
                    Throwable throwable = null;
                    try {
                        this.executeBatch(sql);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ctx == null) continue;
                        if (throwable != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ctx.close();
                        continue;
                    }
                }
                this.executeBatch(sql);
            }
        }
    }

    private String getUpdateInSql(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        for (Long costcenter : ids) {
            sb.append(",").append(costcenter);
        }
        return sb.substring(1);
    }

    private void retryClearDataForGenResult(DiffCalcDataArgs args) {
        QFilter qfiler = new QFilter("org", "=", (Object)args.getOrgId());
        qfiler.and("costaccount", "=", (Object)args.getCostaccountId());
        qfiler.and("period", "=", (Object)args.getPeriodId());
        DataSet clearDs = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "getclearreuslt"), (String)"sca_diffcalcresult", (String)"id,entryentity1.id entryId", (QFilter[])new QFilter[]{qfiler}, null);
        List<Long> subEntryIds = ScaCalcHelper.getLongIdListFromDs(clearDs, "entryId", false);
        StringBuilder billIds = new StringBuilder();
        Lists.partition(subEntryIds, (int)this.getContext().getBatchExecuteSize()).forEach(list -> {
            billIds.setLength(0);
            for (Long billId : list) {
                billIds.append(",").append(billId);
            }
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_diffcalcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)args.getPeriodId()), new HintCondition("forgid", "=", (Object)args.getOrgId())});){
                String deleBillSql = String.format("delete from t_sca_comdiffresultentry where fentryid in (%s)", billIds.substring(1));
                String deleBillSqlV = String.format("delete from t_sca_comdiffresultentry_v where fentryid in (%s)", billIds.substring(1));
                this.executeBatch(deleBillSql);
                this.executeBatch(deleBillSqlV);
            }
        });
    }

    private void retryClearData(DiffCalcDataArgs args, int retrylevel, DynamicObject taskRecordDyo, List<List<MaterialCodeDto>> matLvlList) {
        Date startTime = this.getSubLevelStartTime(taskRecordDyo, retrylevel);
        if (startTime == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5c42\u7ea7\u7684\u5f00\u59cb\u65f6\u95f4\u4e3anull,\u65e0\u6cd5\u7ee7\u7eed\u8ba1\u7b97\u3002", (String)"DiffCalcBaseAction_12", (String)"macc-sca-algox", (Object[])new Object[0]));
        }
        ArrayList ficalClearMaterials = Lists.newArrayList();
        for (int i = 0; i < matLvlList.size(); ++i) {
            if (i + 1 < retrylevel) continue;
            ficalClearMaterials.addAll((Collection)matLvlList.get(i));
        }
        List<Map<String, Object>> matListMap = DiffCalcHelper.getDimMapParamFromLvl(ficalClearMaterials, this.getContext().getDiffMatLvlDim(), this.getContext().getMatAuxptysMap());
        String errorMsg = CalServiceHelper.ficalReCalculateDelBill(args, matListMap, startTime);
        if (errorMsg != null) {
            throw new KDBizException(errorMsg);
        }
        QFilter qfiler = new QFilter("org", "=", (Object)args.getOrgId());
        qfiler.and("costaccount", "=", (Object)args.getCostaccountId());
        qfiler.and("period", "=", (Object)args.getPeriodId());
        DeleteServiceHelper.delete((String)"sca_purchdiffalloc", (QFilter[])new QFilter[]{qfiler, new QFilter("createtime", ">=", (Object)startTime)});
        DataSet clearDs = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "getclearreuslt"), (String)"sca_diffcalcresult", (String)"id,entryentity2.id entryId", (QFilter[])new QFilter[]{qfiler, new QFilter("entryentity2.subtime", ">=", (Object)startTime)}, null);
        List<Long> subEntryIds = ScaCalcHelper.getLongIdListFromDs(clearDs, "entryId", false);
        StringBuilder billIds = new StringBuilder();
        Lists.partition(subEntryIds, (int)this.getContext().getBatchExecuteSize()).forEach(list -> {
            billIds.setLength(0);
            for (Long billId : list) {
                billIds.append(",").append(billId);
            }
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_diffcalcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)args.getPeriodId()), new HintCondition("forgid", "=", (Object)args.getOrgId())});){
                String deleBillSql = String.format("delete from t_sca_subdiffresultentry where fentryid in (%s)", billIds.substring(1));
                this.executeBatch(deleBillSql);
            }
        });
    }

    private Date getSubLevelStartTime(DynamicObject taskRecordDyo, int retrylevel) {
        DynamicObjectCollection entryColl = taskRecordDyo.getDynamicObjectCollection("entryentity");
        String text = ResManager.loadKDString((String)"\u7b2c%s\u5c42", (String)"DiffCalcBaseAction_13", (String)"macc-sca-algox", (Object[])new Object[0]);
        String text1 = "There is no material Pick at level %s that";
        String text2 = "Material of Level %sGenerate";
        text = String.format(text, retrylevel);
        for (DynamicObject dynamicObject : entryColl) {
            if (!dynamicObject.getString("subname").startsWith(text)) continue;
            return dynamicObject.getDate("substarttime");
        }
        text1 = String.format(text1, retrylevel);
        for (DynamicObject dynamicObject : entryColl) {
            if (!dynamicObject.getString("subname").startsWith(text1)) continue;
            return dynamicObject.getDate("substarttime");
        }
        text2 = String.format(text2, retrylevel);
        for (DynamicObject dynamicObject : entryColl) {
            if (!dynamicObject.getString("subname").startsWith(text2)) continue;
            return dynamicObject.getDate("substarttime");
        }
        return null;
    }
}

