/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.dto.MaterialCodeDto;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.calc.input.LevelMatCode;
import kd.macc.sca.algox.costrec.DebugInfoMsgHandler;
import kd.macc.sca.algox.enums.CalcReportEntryEnum;
import kd.macc.sca.algox.restore.CalServiceHelper;
import kd.macc.sca.algox.restore.DiffCalcDataInputFactory;
import kd.macc.sca.algox.restore.DiffReportItemEnum;
import kd.macc.sca.algox.restore.action.AbstractDiffCalcAction;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.restore.function.DiffMaterialLvlDealGroupFunction;
import kd.macc.sca.algox.utils.DataSetHelper;
import kd.macc.sca.algox.utils.MaterialLevelHelper;
import kd.macc.sca.algox.utils.RestoreCalcReportHelper;
import kd.macc.sca.algox.utils.ScaCalcHelper;

public class DiffMaterialLvlCalcAction
extends AbstractDiffCalcAction {
    private static final Log logger = LogFactory.getLog(DiffMaterialLvlCalcAction.class);
    private static final String ALGO_KEY_PRE = "DiffMatLvl-";
    private static final String[] LVL_COL = new String[]{"material", "materialnumber", "auxpty", "matversion", "configuredcode", "tracknumber", "project", "lot", "submaterial", "submaterialnumber", "subauxpty", "submatversion", "subconfiguredcode", "subtracknumber", "subproject", "sublot"};

    @Override
    protected void doExecute() {
        if (this.getContext().isDiffCheck()) {
            return;
        }
        if (!this.getContext().isCalc()) {
            return;
        }
        RestoreCalcReportHelper.changeEntryStatusById(CalcReportEntryEnum.lowLevelCodeCalc.id);
        logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801\u8ba1\u7b97-\u5f00\u59cb");
        String curItem = DiffReportItemEnum.getName(DiffReportItemEnum.MATERIAL_LVL_CALC.getValue());
        long taskEntryId = 0L;
        if (!this.getContext().getInputArgs().isRetryMode()) {
            taskEntryId = this.getResultManager().getTaskRecorder().saveTaskRecordEntry(curItem, DiffReportItemEnum.MATERIAL_LVL_CALC.getValue(), "2");
        }
        long time = System.currentTimeMillis();
        DiffCalcDataArgs args = this.getContext().getInputArgs();
        DebugInfoMsgHandler msgHander = new DebugInfoMsgHandler(this.getContext().getInputArgs().getTaskRecordId(), taskEntryId);
        this.materialLvlDeal(args, msgHander);
        RestoreCalcReportHelper.clearReportEntryById(CalcReportEntryEnum.lowLevelCodeCalc.id);
        this.getResultManager().getTaskRecorder().upateTaskRecordDetail(DiffReportItemEnum.MATERIAL_LVL_CALC.getValue(), "4");
        this.updateTaskRecordProcess(5, "2");
        logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801\u8ba1\u7b97-\u7ed3\u675f\uff1a{}", (Object)(System.currentTimeMillis() - time));
    }

    private void materialLvlDeal(DiffCalcDataArgs args, DebugInfoMsgHandler msgHander) {
        long start = System.currentTimeMillis();
        CalServiceHelper.refreshGroupRecord(args);
        logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801-\u5237\u65b0\u8d26\u8584\u6210\u7ec4\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        Set<String> diffMatLvlDim = CalServiceHelper.getDiffMaterialCalcDim(args.getOrgId());
        this.getContext().setDiffMatLvlDim(diffMatLvlDim);
        HashMap relaMatMainJoinMap = Maps.newHashMapWithExpectedSize((int)10);
        DataSet allocDataSet = this.getMatLvlSourceDs(args, diffMatLvlDim, relaMatMainJoinMap, msgHander);
        logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801-\u83b7\u53d6\u4f4e\u9636\u7801\u6570\u636e\u6e90\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        List<List<String>> nestMatGroups = new ArrayList<List<String>>(10);
        HashSet<String> nestMatTreePaths = new HashSet<String>(10);
        Set<LevelMatCode> legalCheckLvlMats = null;
        List<List<LevelMatCode>> matLvlList = MaterialLevelHelper.getMatLevelList(allocDataSet, args.getSpecifyMatIds(), relaMatMainJoinMap, legalCheckLvlMats, nestMatGroups, nestMatTreePaths, true);
        StringBuilder infoMsg = new StringBuilder();
        infoMsg.append("\nCalcMatlvlSize:").append(matLvlList.size());
        List<List<MaterialCodeDto>> matCodeLvlList = this.transferMaterialCode(matLvlList);
        nestMatGroups = this.transferMaterialCodeGroup(nestMatGroups);
        this.getContext().setNestMatGroups(nestMatGroups);
        this.getContext().setLegalCheckLvlMats(legalCheckLvlMats);
        if (!CadEmptyUtils.isEmpty(nestMatTreePaths)) {
            this.logNestMatGroup(nestMatTreePaths, nestMatGroups, msgHander);
        }
        logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801-\u8ba1\u7b97\u4f4e\u9636\u7801\u5c42\u7ea7:{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        if (matLvlList.isEmpty()) {
            logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801\u8ba1\u7b97\u65e0\u5c42\u7ea7\u6570\u636e\uff0c\u52a0\u5165\u7a7a\u7684\u4e24\u5c42");
            matCodeLvlList.add(Lists.newArrayList());
            matCodeLvlList.add(Lists.newArrayList());
        }
        if (!args.isSpecifyMatCalc()) {
            this.dealNeedCarryMatLevel(args, matCodeLvlList, nestMatGroups, diffMatLvlDim);
        }
        logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801-\u5904\u7406\u7b2c2\u5c42\u6570\u636e\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        if (diffMatLvlDim.contains("auxpty")) {
            this.dealMatLvlAuxpty(args, matCodeLvlList);
        }
        infoMsg.append(",MatFinalLvlSize:").append(matCodeLvlList.size());
        logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801\u5c42\u7ea7\uff1a{}", (Object)matCodeLvlList.size());
        int i = 0;
        for (List<MaterialCodeDto> mats : matCodeLvlList) {
            int matsize = DiffCalcHelper.getDimMatIdMapFromLvl(mats).size();
            infoMsg.append(",lvl-").append(++i).append("_matDim:").append(mats.size()).append("_mat:").append(matsize);
        }
        msgHander.dealInfoMsg(infoMsg.toString());
        this.getContext().setMatLvlList(matCodeLvlList);
    }

    private List<List<String>> transferMaterialCodeGroup(List<List<String>> nestMatGroups) {
        ArrayList<List<String>> newNestMatGroups = new ArrayList<List<String>>(10);
        if (CadEmptyUtils.isEmpty(nestMatGroups)) {
            return newNestMatGroups;
        }
        for (List<String> group : nestMatGroups) {
            ArrayList<String> newGroup = new ArrayList<String>(10);
            for (String mat : group) {
                MaterialCodeDto dto = DiffCalcHelper.getDiffMaterialDtoFromString(mat);
                newGroup.add(dto.getMaterialKey());
            }
            newNestMatGroups.add(newGroup);
        }
        return newNestMatGroups;
    }

    private DataSet getMatLvlSourceDs(DiffCalcDataArgs args, Set<String> diffMatLvlDim, Map<String, String> relaMatMainJoinMap, DebugInfoMsgHandler msgHander) {
        long start = System.currentTimeMillis();
        DataSet allocDataSet = this.buildMatAllocDataSet(args);
        allocDataSet = allocDataSet.distinct();
        logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801-\u83b7\u53d6\u9886\u6599\u6570\u636e\u96c6\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.logDataSet(allocDataSet, String.format(ResManager.loadKDString((String)"%s\u3010\u4f4e\u9636\u7801-\u6750\u6599\u5206\u914d\u5355-\u9886\u6599\u6570\u636e\u3011", (String)"DiffMaterialLvlCalcAction_0", (String)"macc-sca-algox", (Object[])new Object[0]), args.getLogUniqueKey()), msgHander);
        allocDataSet = this.dealMainJoinDataSet(allocDataSet, args, relaMatMainJoinMap, diffMatLvlDim, msgHander);
        allocDataSet = allocDataSet.select(LVL_COL);
        logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801-\u5904\u7406\u4e3b\u8054\u9886\u7528\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        DataSet matGroupDataSet = DiffMaterialLvlCalcAction.dealCalMatGroup(args);
        if (matGroupDataSet != null && !matGroupDataSet.isEmpty()) {
            if (diffMatLvlDim.contains("auxpty")) {
                Map<Long, Set<Long>> matAuxptysMap = this.getContext().getMatAuxptysMap();
                matGroupDataSet = this.dealMaterialAuxpty(matGroupDataSet, matAuxptysMap);
            }
            allocDataSet = DataSetHelper.union(allocDataSet, matGroupDataSet);
            this.logDataSet(allocDataSet, String.format(ResManager.loadKDString((String)"%s\u3010\u4f4e\u9636\u7801-\u6210\u7ec4\u9886\u6599\u6570\u636e\u3011", (String)"DiffMaterialLvlCalcAction_1", (String)"macc-sca-algox", (Object[])new Object[0]), args.getLogUniqueKey()), msgHander);
        }
        logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801-\u5904\u7406\u6210\u7ec4\u5173\u7cfb\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        DataSet prePurDs = DiffMaterialLvlCalcAction.getEndPurchDiffAllocDs(args);
        allocDataSet = DataSetHelper.union(allocDataSet, prePurDs);
        logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801-\u5904\u7406\u5dee\u5f02\u5206\u914d\u5355\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        allocDataSet = DiffCalcHelper.clearDiffDimValue(allocDataSet, diffMatLvlDim);
        DataSet ds = allocDataSet.groupBy(LVL_COL).finish();
        this.logDataSet(ds, String.format(ResManager.loadKDString((String)"%s\u3010\u4f4e\u9636\u7801-\u9886\u6599\u6570\u636e\u3011", (String)"DiffMaterialLvlCalcAction_7", (String)"macc-sca-algox", (Object[])new Object[0]), args.getLogUniqueKey()), msgHander);
        logger.info("\u5dee\u5f02\u5206\u644a-\u4f4e\u9636\u7801-\u6e05\u7406\u7ef4\u5ea6\u503c\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        return ds;
    }

    private void dealMatLvlAuxpty(DiffCalcDataArgs args, List<List<MaterialCodeDto>> matCodeLvlList) {
        DataSet matallocDs = this.buildMatAllocAuxDataSet(args, null);
        matallocDs = matallocDs.groupBy(new String[]{"submaterial", "srcauxpty"}).finish();
        Map<Long, Set<Long>> matAuxptysMap = this.getContext().getMatAuxptysMap();
        for (Object row : matallocDs) {
            Long l = row.getLong("srcauxpty");
            if (l == null) continue;
            matAuxptysMap.computeIfAbsent(row.getLong("submaterial"), t -> new HashSet(16)).add(l);
        }
        HashSet<Long> materialIds = new HashSet<Long>(16);
        for (List list : matCodeLvlList) {
            for (Object material : list) {
                materialIds.add(material.getMaterial());
            }
        }
        List<List<String>> nestMatGroups = this.getContext().getNestMatGroups();
        for (List<String> list : nestMatGroups) {
            for (String mat : list) {
                MaterialCodeDto material = DiffCalcHelper.getDiffMaterialDtoFromString(mat);
                materialIds.add(material.getMaterial());
            }
        }
        DataSet dataSet = this.getAffectPriceDs(materialIds);
        HashSet<Long> hashSet = new HashSet<Long>(16);
        for (Row row : dataSet) {
            hashSet.add(row.getLong("effectpricemat"));
        }
        materialIds.removeAll(hashSet);
        for (Long matId : hashSet) {
            matAuxptysMap.remove(matId);
        }
        DataSet factDs = DiffMaterialLvlCalcAction.getTransOutMatFactDs(this.getContext().getInputArgs(), materialIds);
        HashSet sourceEntryIds = Sets.newHashSetWithExpectedSize((int)10);
        for (Row row : factDs) {
            Long sourcebillentryId = row.getLong("sourcebillentry");
            if (CadEmptyUtils.isEmpty((Long)sourcebillentryId)) continue;
            sourceEntryIds.add(sourcebillentryId);
        }
        DataSet costRecordDs = DiffMaterialLvlCalcAction.getCalCostRecordInfoByBizEntryId(this.getContext().getInputArgs(), sourceEntryIds);
        costRecordDs = costRecordDs.groupBy(new String[]{"material", "auxpty"}).finish();
        for (Row row : costRecordDs) {
            Long srcauxpty = row.getLong("auxpty");
            if (srcauxpty == null) continue;
            matAuxptysMap.computeIfAbsent(row.getLong("material"), t -> new HashSet(16)).add(srcauxpty);
        }
    }

    private List<List<MaterialCodeDto>> transferMaterialCode(List<List<LevelMatCode>> matLvlList) {
        ArrayList<List<MaterialCodeDto>> matCodeLvlDtos = new ArrayList<List<MaterialCodeDto>>(matLvlList.size());
        for (List<LevelMatCode> srcList : matLvlList) {
            ArrayList<MaterialCodeDto> matCodeDtos = new ArrayList<MaterialCodeDto>(srcList.size());
            for (LevelMatCode resMat : srcList) {
                MaterialCodeDto matCodeDto = new MaterialCodeDto();
                matCodeDto.setMaterial(resMat.getSubmaterial());
                matCodeDto.setMatversion(resMat.getSubmatversion());
                matCodeDto.setAuxpty(resMat.getSubauxpty());
                matCodeDto.setConfiguredcode(resMat.getSubconfiguredcode());
                matCodeDto.setTracknumber(resMat.getSubtracknumber());
                matCodeDto.setProject(resMat.getSubproject());
                matCodeDto.setLot(resMat.getSublot());
                matCodeDtos.add(matCodeDto);
            }
            matCodeLvlDtos.add(matCodeDtos);
        }
        return matCodeLvlDtos;
    }

    private DataSet dealMaterialAuxpty(DataSet matGroupDataSet, Map<Long, Set<Long>> matAuxptysMap) {
        HashSet<Long> materialIds = new HashSet<Long>(16);
        DataSet matGroupDataSetCopy = matGroupDataSet.copy();
        for (Row row : matGroupDataSetCopy) {
            materialIds.add(row.getLong("material"));
            materialIds.add(row.getLong("submaterial"));
        }
        DataSet affectAuxptyDs = this.getAffectPriceDs(materialIds);
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(matGroupDataSet.getRowMeta().getFieldNames()));
        matGroupDataSet = matGroupDataSet.leftJoin(affectAuxptyDs).on("material", "effectpricemat").select(fieldNames.toArray(new String[0]), new String[]{"effectpricemat affectmat"}).finish();
        fieldNames.add("affectmat");
        matGroupDataSet = matGroupDataSet.leftJoin(affectAuxptyDs).on("submaterial", "effectpricemat").select(fieldNames.toArray(new String[0]), new String[]{"effectpricemat subaffectmat"}).finish();
        DataSet matGroupDataSetCopy1 = matGroupDataSet.copy();
        for (Row row : matGroupDataSetCopy1) {
            if (CadEmptyUtils.isEmpty((Long)row.getLong("affectmat"))) {
                matAuxptysMap.computeIfAbsent(row.getLong("material"), t -> new HashSet(16)).add(row.getLong("auxpty"));
            }
            if (!CadEmptyUtils.isEmpty((Long)row.getLong("subaffectmat"))) continue;
            matAuxptysMap.computeIfAbsent(row.getLong("submaterial"), t -> new HashSet(16)).add(row.getLong("subauxpty"));
        }
        fieldNames.remove("subaffectmat");
        fieldNames.remove("affectmat");
        fieldNames.remove("auxpty");
        fieldNames.remove("subauxpty");
        fieldNames.add("case when subaffectmat>0 then subauxpty else 0L end subauxpty");
        fieldNames.add("case when affectmat>0 then auxpty else 0L end auxpty");
        return matGroupDataSet.select(fieldNames.toArray(new String[0]));
    }

    private DataSet getAffectPriceDs(Set<Long> materialIdSet) {
        QFilter filter = new QFilter("id", "in", materialIdSet);
        filter.and("isuseauxpty", "=", (Object)Boolean.TRUE);
        filter.and("auxptyentry.isaffectprice", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryDataSet((String)"material", (String)"bd_material", (String)"id as effectpricemat", (QFilter[])new QFilter[]{filter}, null).distinct();
    }

    private void logNestMatGroup(Set<String> nestMatTreePaths, List<List<String>> nestMatGroups, DebugInfoMsgHandler msgHander) {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u5d4c\u5957\u8def\u5f84id\uff1a", (String)"DiffMaterialLvlCalcAction_2", (String)"macc-sca-algox", (Object[])new Object[0]));
        sb.append("\n");
        for (String string : nestMatTreePaths) {
            sb.append(string).append('\n');
        }
        sb.append(ResManager.loadKDString((String)"\u5d4c\u5957\u7ec4id\uff1a", (String)"DiffMaterialLvlCalcAction_4", (String)"macc-sca-algox", (Object[])new Object[0]));
        sb.append("\n");
        ArrayList<MaterialCodeDto> dtos = new ArrayList<MaterialCodeDto>(10);
        for (List<String> list : nestMatGroups) {
            for (String mat : list) {
                dtos.add(DiffCalcHelper.getDiffMaterialDtoFromString(mat));
            }
        }
        Map<String, String> map = DiffCalcDataInputFactory.getMaterialInfoMap(dtos, this.getContext().getDiffMatLvlDim());
        for (List<String> matGroup : nestMatGroups) {
            int i = 0;
            sb.append("[");
            for (String mat : matGroup) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(map.get(mat) == null ? mat : map.get(mat));
                ++i;
            }
            sb.append("]\n");
        }
        msgHander.dealInfoMsg(sb.toString());
    }

    private void dealNeedCarryMatLevel(DiffCalcDataArgs args, List<List<MaterialCodeDto>> matLvlList, List<List<String>> nestMatGroups, Set<String> diffMatLvlDim) {
        HashSet needInMats = Sets.newHashSet();
        DataSet factMatDs = DiffMaterialLvlCalcAction.getCurrFactMaterials(args);
        DataSet purAllocMatDs = DiffMaterialLvlCalcAction.getDiffAllocData(args);
        DataSet calcMatDs = DiffMaterialLvlCalcAction.getCalcDiffData(args);
        DataSet unabsorbDiffMatDs = DiffMaterialLvlCalcAction.getUnAbsorbDiffData(args);
        DataSet twoLvlDs = factMatDs.union(purAllocMatDs).union(calcMatDs).union(unabsorbDiffMatDs).distinct();
        List<Long> costobjectIds = ScaCalcHelper.getLongIdListFromDs(twoLvlDs, "costobject", false);
        if (costobjectIds.isEmpty()) {
            return;
        }
        twoLvlDs = DiffMaterialLvlCalcAction.getDiffAllocData(costobjectIds);
        twoLvlDs = DiffCalcHelper.clearDiffDimValue(twoLvlDs, diffMatLvlDim, false).distinct();
        for (Row row : twoLvlDs) {
            needInMats.add(DiffCalcHelper.getRowDimString(row));
        }
        if (needInMats.isEmpty()) {
            return;
        }
        for (List<String> nestGroup : nestMatGroups) {
            boolean isNeedAdd = false;
            for (String matId : nestGroup) {
                if (!needInMats.contains(matId)) continue;
                isNeedAdd = true;
                break;
            }
            if (!isNeedAdd) continue;
            needInMats.removeAll(nestGroup);
            needInMats.add(nestGroup.get(0));
        }
        List<MaterialCodeDto> oneMats = matLvlList.get(0);
        ArrayList<MaterialCodeDto> twoMats = new ArrayList<MaterialCodeDto>(10);
        for (MaterialCodeDto calcMat : oneMats) {
            if (!needInMats.contains(calcMat.getMaterialKey())) continue;
            twoMats.add(calcMat);
        }
        if (!twoMats.isEmpty()) {
            oneMats.removeAll(twoMats);
        }
        matLvlList.add(1, twoMats);
        Set<String> allMats = this.getMatLvlMaterials(matLvlList);
        needInMats.removeAll(allMats);
        for (String matId : needInMats) {
            MaterialCodeDto mat = DiffCalcHelper.getDiffMaterialDtoFromString(matId);
            twoMats.add(mat);
        }
        if (matLvlList.get(1).isEmpty()) {
            matLvlList.remove(1);
        } else {
            this.getContext().setAddSpecialLevel(true);
        }
    }

    private static DataSet getDiffAllocData(Collection<Long> costobjectIds) {
        QFilter qFilter = new QFilter("id", "in", costobjectIds);
        return QueryServiceHelper.queryDataSet((String)"getDiffCalcResult", (String)"cad_costobject", (String)"material,calckeycol.matvers AS matversion,calckeycol.auxproperty AS auxpty,calckeycol.configuredcode AS configuredcode,calckeycol.tracknumber AS tracknumber,calckeycol.project AS project,calckeycol.lot AS lot", (QFilter[])qFilter.toArray(), null);
    }

    private static DataSet getDiffAllocData(DiffCalcDataArgs args) {
        QFilter reWorkMaterialAllocQF = new QFilter("org", "=", (Object)args.getOrgId());
        reWorkMaterialAllocQF.and("costaccount", "=", (Object)args.getCostaccountId());
        reWorkMaterialAllocQF.and("period", "=", (Object)args.getPrePeriodId());
        reWorkMaterialAllocQF.and("biztype", "=", (Object)"01");
        String selectcoField = "becostobject costobject";
        return QueryServiceHelper.queryDataSet((String)"getDiffAllocData", (String)"sca_purchdiffalloc", (String)selectcoField, (QFilter[])new QFilter[]{reWorkMaterialAllocQF}, null);
    }

    private static DataSet getCalcDiffData(DiffCalcDataArgs args) {
        QFilter reWorkMaterialAllocQF = new QFilter("org", "=", (Object)args.getOrgId());
        reWorkMaterialAllocQF.and("costaccount", "=", (Object)args.getCostaccountId());
        reWorkMaterialAllocQF.and("period", "=", (Object)args.getPeriodId());
        String selectcoField = "costobject";
        return QueryServiceHelper.queryDataSet((String)"getDiffAllocData", (String)"sca_finishdiffbill", (String)selectcoField, (QFilter[])new QFilter[]{reWorkMaterialAllocQF}, null);
    }

    private static DataSet getUnAbsorbDiffData(DiffCalcDataArgs args) {
        QFilter reWorkMaterialAllocQF = new QFilter("org", "=", (Object)args.getOrgId());
        reWorkMaterialAllocQF.and("costaccount", "=", (Object)args.getCostaccountId());
        reWorkMaterialAllocQF.and("period", "=", (Object)args.getPeriodId());
        String selectcoField = "costobject";
        return QueryServiceHelper.queryDataSet((String)"getDiffAllocData", (String)"sca_unabsorbdiff", (String)selectcoField, (QFilter[])new QFilter[]{reWorkMaterialAllocQF}, null);
    }

    public static DataSet getCurrFactMaterials(DiffCalcDataArgs args) {
        String algoKey = "CurrFactMaterials";
        QFilter orgIdFilter = new QFilter("org", "=", (Object)args.getOrgId());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter beginDateFilter = new QFilter("bookdate", ">=", (Object)args.getStartDate());
        QFilter endDateFilter = new QFilter("bookdate", "<=", (Object)args.getEndDate());
        QFilter producttypeFilter = new QFilter("entryentity.costobject.producttype", "!=", (Object)"B");
        String selectcoField = "entryentity.costobject costobject";
        QFilter[] filters = new QFilter[]{orgIdFilter, beginDateFilter, endDateFilter, statusFilter, producttypeFilter};
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)selectcoField, (QFilter[])filters, null);
    }

    public static DataSet getTransOutMatFactDs(DiffCalcDataArgs args, Set<Long> materialIds) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("bookdate", ">=", (Object)args.getStartDate());
        qFilter.and("bookdate", "<=", (Object)args.getEndDate());
        qFilter.and("material", "in", materialIds);
        String selectcoField = "id,material,sourcebill,sourcebillentry";
        return QueryServiceHelper.queryDataSet((String)"TransOutMatCostObjects", (String)"cad_factnedoutputbill", (String)selectcoField, (QFilter[])qFilter.toArray(), null);
    }

    public static DataSet getCalCostRecordInfoByBizEntryId(DiffCalcDataArgs args, Set<Long> costRecordEntryIds) {
        QFilter filter = new QFilter("entry.bizbillentryid", "in", costRecordEntryIds);
        filter.and("costaccount", "=", (Object)args.getCostaccountId());
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        String selectField = "entry.assist auxpty,entry.material material";
        return QueryServiceHelper.queryDataSet((String)"getCalCostRecord", (String)"cal_costrecord_subentity", (String)selectField, (QFilter[])filter.toArray(), null);
    }

    private Set<String> getMatLvlMaterials(List<List<MaterialCodeDto>> matLvls) {
        HashSet materialIds = Sets.newHashSet();
        for (List<MaterialCodeDto> matList : matLvls) {
            for (MaterialCodeDto mat : matList) {
                materialIds.add(mat.getMaterialKey());
            }
        }
        return materialIds;
    }

    private DataSet buildMatAllocAuxDataSet(DiffCalcDataArgs args, Set<Long> materialIds) {
        QFilter filter = new QFilter("allocstatus", "=", (Object)"2");
        filter.and("appnum", "=", (Object)"sca");
        filter.and("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostaccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        if (!CadEmptyUtils.isEmpty(materialIds)) {
            filter.and("material", "in", materialIds);
        }
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("material.id AS submaterial,");
        selectFields.append("srcauxpty");
        DataSet tmpDataSet = QueryServiceHelper.queryDataSet((String)"DiffMatLvl-matalloc", (String)"sca_matalloc", (String)selectFields.toString(), (QFilter[])filter.toArray(), null);
        return tmpDataSet;
    }

    private DataSet buildMatAllocDataSet(DiffCalcDataArgs args) {
        QFilter filter = new QFilter("allocstatus", "=", (Object)"2");
        filter.and("appnum", "=", (Object)"sca");
        filter.and("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostaccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("costcenter");
        selectFields.append(",material.id AS submaterial,'' AS submaterialnumber");
        selectFields.append(",auxpty AS subauxpty");
        selectFields.append(",matversion AS submatversion");
        selectFields.append(",configuredcode AS subconfiguredcode");
        selectFields.append(",tracknumber AS subtracknumber");
        selectFields.append(",project AS subproject");
        selectFields.append(",lotcoderule AS sublot");
        selectFields.append(",entryentity.costobejctentry AS costobject");
        selectFields.append(",entryentity.costobejctentry.material AS material");
        selectFields.append(",'' AS materialnumber");
        selectFields.append(",entryentity.costobejctentry.calckeycol.auxproperty AS auxpty");
        selectFields.append(",entryentity.costobejctentry.calckeycol.matvers AS matversion");
        selectFields.append(",entryentity.costobejctentry.calckeycol.configuredcode AS configuredcode");
        selectFields.append(",entryentity.costobejctentry.calckeycol.tracknumber AS tracknumber");
        selectFields.append(",entryentity.costobejctentry.calckeycol.project AS project");
        selectFields.append(",entryentity.costobejctentry.calckeycol.lot AS lot");
        selectFields.append(",entryentity.costobejctentry.productgroup AS productgroup");
        selectFields.append(",entryentity.costobejctentry.srcbillnumber AS srcbillnumber");
        selectFields.append(",0L AS mainmaterial");
        selectFields.append(",'' AS mainmaterialnumber");
        DataSet tmpDataSet = QueryServiceHelper.queryDataSet((String)"DiffMatLvl-matalloc", (String)"sca_matalloc", (String)selectFields.toString(), (QFilter[])filter.toArray(), null);
        return tmpDataSet;
    }

    public static DataSet getEndPurchDiffAllocDs(DiffCalcDataArgs args) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPrePeriodId());
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("biztype", "=", (Object)"01");
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("material submaterial");
        selectFields.append(",'' AS submaterialnumber");
        selectFields.append(",version submatversion");
        selectFields.append(",auxpty subauxpty");
        selectFields.append(",configuredcode subconfiguredcode");
        selectFields.append(",tracknumber subtracknumber");
        selectFields.append(",project subproject");
        selectFields.append(",lot sublot");
        selectFields.append(",becostobject.material AS material");
        selectFields.append(",'' AS materialnumber");
        selectFields.append(",becostobject.calckeycol.auxproperty AS auxpty");
        selectFields.append(",becostobject.calckeycol.matvers AS matversion");
        selectFields.append(",becostobject.calckeycol.configuredcode AS configuredcode");
        selectFields.append(",becostobject.calckeycol.tracknumber AS tracknumber");
        selectFields.append(",becostobject.calckeycol.project AS project");
        selectFields.append(",becostobject.calckeycol.lot AS lot");
        return QueryServiceHelper.queryDataSet((String)"DiffMatLvl-getSubMatUnAbsorbDiff", (String)"sca_purchdiffalloc", (String)selectFields.toString(), (QFilter[])qFilter.toArray(), null);
    }

    private DataSet dealMainJoinDataSet(DataSet mainMatAlloc, DiffCalcDataArgs args, Map<String, String> relaMatMainJoinMap, Set<String> diffMatLvlDim, DebugInfoMsgHandler msgHander) {
        DataSet joinMatAlloc = mainMatAlloc.copy().filter("productgroup > 0 and material!=submaterial");
        if (joinMatAlloc.isEmpty()) {
            return mainMatAlloc;
        }
        DataSet probillIdDs = joinMatAlloc.copy().select("costobject").distinct();
        HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : probillIdDs) {
            costobjectIds.add(row.getLong("costobject"));
        }
        if (!CollectionUtils.isEmpty((Collection)costobjectIds)) {
            DataSet relaCostobjectDs = this.getMainJoinSideCostobjDsFromMainId(args.getOrgId(), costobjectIds, new String[]{"A"});
            joinMatAlloc = joinMatAlloc.join(relaCostobjectDs).on("costobject", "mainCostObjectId").select(new String[]{"costcenter", "submaterial", "submaterialnumber", "subauxpty", "submatversion", "subconfiguredcode", "subtracknumber", "subproject", "sublot", "material as mainmaterial", "materialnumber mainmaterialnumber", "auxpty as mainAuxpty", "matversion as mainMatversion", "configuredcode as mainConfiguredcode", "tracknumber as mainTracknumber", "project as mainProject", "lot as mainLot"}, new String[]{"costObjectId costobject", "material", "materialnumber", "auxpty", "matversion", "productgroup", "srcbillnumber", "configuredcode", "tracknumber", "project", "lot"}).finish();
            DataSet joinMatAllocMain = joinMatAlloc.copy().select(new String[]{"material", "materialnumber", "auxpty", "matversion", "configuredcode", "tracknumber", "project", "lot", "mainmaterial", "mainmaterialnumber", "mainauxpty", "mainmatversion", "mainconfiguredcode", "maintracknumber", "mainproject", "mainlot"}).filter("material!=mainMaterial").distinct();
            if (relaMatMainJoinMap != null) {
                DataSet joinMatAllocMainCopyDs = joinMatAllocMain.copy();
                for (Row row : joinMatAllocMainCopyDs) {
                    String mainMat = DiffCalcHelper.getRowDimString(row, diffMatLvlDim, "main");
                    String subMat = DiffCalcHelper.getRowDimString(row, diffMatLvlDim, "");
                    relaMatMainJoinMap.put(mainMat, subMat);
                    relaMatMainJoinMap.put(subMat, mainMat);
                }
            }
            this.logDataSet(joinMatAllocMain.copy(), ResManager.loadKDString((String)"\u8054\u4ea7\u54c1\u5bf9\u5e94\u7684\u4e3b\u4ea7\u54c1\u5217\u8868", (String)"DiffMaterialLvlCalcAction_6", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
            mainMatAlloc = DataSetHelper.union(mainMatAlloc, joinMatAlloc.removeFields(new String[]{"mainauxpty", "mainmatversion"}));
            DataSet joinToMainDs = mainMatAlloc.copy().join(joinMatAllocMain).on("submaterial", "material").on("subauxpty", "auxpty").on("subconfiguredcode", "configuredcode").on("subtracknumber", "tracknumber").on("subproject", "project").on("sublot", "lot").select(new String[]{"costcenter", "costobject", "material", "materialnumber", "auxpty", "matversion", "productgroup", "srcbillnumber", "configuredcode", "tracknumber", "project", "lot"}, new String[]{"mainmaterial as submaterial", "mainmaterialnumber as submaterialnumber", "mainauxpty as subauxpty", "mainmatversion as submatversion", "mainconfiguredcode as subconfiguredcode", "maintracknumber as subtracknumber", "mainproject as subproject", "mainlot as sublot", "material as mainmaterial", "materialnumber as mainmaterialnumber"}).finish();
            if (!joinToMainDs.isEmpty()) {
                mainMatAlloc = DataSetHelper.union(mainMatAlloc, joinToMainDs);
            }
        }
        this.logDataSet(mainMatAlloc, String.format(ResManager.loadKDString((String)"%s\u3010\u4f4e\u9636\u7801-\u9886\u6599\u6570\u636e\u3011", (String)"DiffMaterialLvlCalcAction_7", (String)"macc-sca-algox", (Object[])new Object[0]), args.getLogUniqueKey()), msgHander);
        return mainMatAlloc;
    }

    public DataSet getMainJoinSideCostobjDsFromMainId(Long orgId, Set<Long> mainCostobjectIds, String[] productTypes) {
        QFilter filter = new QFilter("id", "in", mainCostobjectIds);
        DataSet mainCostobjectDs = QueryServiceHelper.queryDataSet((String)"CalCadCostobject", (String)"cad_costobject", (String)"costcenter,costcenter mainCostCenterId,id mainCostObjectId,id costObjectId,billno,srcbillnumber,productgroup,producttype,material,'' AS materialnumber,material.baseunit.precision as matunitprecision,calckeycol.matvers AS matversion,calckeycol.auxproperty as auxpty,weight,probill,isoutsource,calckeycol.configuredcode as configuredcode,calckeycol.tracknumber as tracknumber,calckeycol.project as project,calckeycol.lot as lot", (QFilter[])filter.toArray(), null);
        DataSet mainJoinSideDs = null;
        mainJoinSideDs = Arrays.asList(productTypes).contains("C") ? mainCostobjectDs.copy().filter("productgroup>0") : mainCostobjectDs.filter("productgroup>0");
        HashSet productgroupIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet poNos = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : mainJoinSideDs.copy()) {
            productgroupIds.add(row.getLong("productgroup"));
            poNos.add(row.getString("srcbillnumber"));
        }
        DataSet relaCostobjectDs = null;
        if (productgroupIds.isEmpty() && poNos.isEmpty()) {
            relaCostobjectDs = mainJoinSideDs;
        } else {
            ArrayList<String> productTypeList = new ArrayList<String>();
            productTypeList.addAll(Arrays.asList(productTypes));
            productTypeList.remove("C");
            QFilter relaFilter = new QFilter("org", "=", (Object)orgId);
            relaFilter.and("productgroup", "in", (Object)productgroupIds);
            relaFilter.and("srcbillnumber", "in", (Object)poNos);
            relaFilter.and("producttype", "in", productTypeList);
            relaCostobjectDs = QueryServiceHelper.queryDataSet((String)"Calcresult", (String)"cad_costobject", (String)"costcenter,id costObjectId,billno,srcbillnumber,productgroup,producttype,material,'' AS materialnumber,material.baseunit.precision as matunitprecision,calckeycol.matvers AS matversion,calckeycol.auxproperty AS auxpty,weight,probill,isoutsource,mainproobj,calckeycol.configuredcode as configuredcode,calckeycol.tracknumber as tracknumber,calckeycol.project as project,calckeycol.lot as lot", (QFilter[])relaFilter.toArray(), null);
            Object notHasRelaMainDs = relaCostobjectDs.copy().filter("mainproobj=0");
            notHasRelaMainDs = !notHasRelaMainDs.isEmpty() ? mainJoinSideDs.join(notHasRelaMainDs).on("productgroup", "productgroup").on("srcbillnumber", "srcbillnumber").select(new String[]{"mainCostCenterId", "mainCostObjectId"}, new String[]{"costcenter", "costObjectId", "billno", "srcbillnumber", "productgroup", "producttype", "material", "materialnumber", "matunitprecision", "matversion", "auxpty", "weight", "probill", "isoutsource", "configuredcode", "tracknumber", "project", "lot"}).finish() : null;
            relaCostobjectDs = mainJoinSideDs.join(relaCostobjectDs).on("mainCostObjectId", "mainproobj").select(new String[]{"mainCostCenterId", "mainCostObjectId"}, new String[]{"costcenter", "costObjectId", "billno", "srcbillnumber", "productgroup", "producttype", "material", "materialnumber", "matunitprecision", "matversion", "auxpty", "weight", "probill", "isoutsource", "configuredcode", "tracknumber", "project", "lot"}).finish();
            if (notHasRelaMainDs != null) {
                relaCostobjectDs = relaCostobjectDs.union(notHasRelaMainDs);
            }
        }
        if (Arrays.asList(productTypes).contains("C")) {
            relaCostobjectDs = DataSetHelper.union(relaCostobjectDs, mainCostobjectDs);
        }
        return relaCostobjectDs;
    }

    private static DataSet dealCalMatGroup(DiffCalcDataArgs args) {
        OrmInput acctGrpRecordData = null;
        DataSet groupRecordDS = null;
        if (!CalServiceHelper.isBizGroupModel()) {
            QFilter acctGrpRecordFilter = new QFilter("entryentity.costaccount.id", "=", (Object)args.getCostaccountId());
            acctGrpRecordFilter.and("entryentity.period", "=", (Object)args.getPeriodId());
            acctGrpRecordData = new OrmInput("DiffMatLvl-CalMatGroup", "cal_account_grouprecord", "entryentity.type as type,bizgrouprecordid,entryentity.costrecordentryid as billentryid,entryentity.material.id as materialid", new QFilter[]{acctGrpRecordFilter});
        } else {
            HashMap<Long, Object> costAccount2MaterialidMap = new HashMap<Long, Object>(4);
            costAccount2MaterialidMap.put(args.getCostaccountId(), null);
            String selectFields = "type,period,groupid as bizgrouprecordid,costrecordentryid as billentryid,material as materialid";
            String cacheId = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalGroupRecordService", (String)"getGroupRecordDS", (Object[])new Object[]{costAccount2MaterialidMap, selectFields});
            groupRecordDS = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)"MaterialLvl"), true);
            groupRecordDS = groupRecordDS.filter("period =" + args.getPeriodId());
        }
        QFilter filter = new QFilter("period.id", "=", (Object)args.getPeriodId());
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("costaccount.id", "=", (Object)args.getCostaccountId());
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        QFilter exFilter = new QFilter("entry.accounttype", "=", (Object)"D");
        HashSet<String> billtypes = new HashSet<String>(16);
        billtypes.add("im_mdc_ominbill");
        billtypes.add("im_mdc_omproorder");
        billtypes.add("im_mdc_omreturnorder");
        billtypes.add("im_mdc_omfeedorder");
        exFilter.or("bizentityobject", "in", billtypes);
        OrmInput billData = new OrmInput("DiffMatLvl-costrecord", "cal_costrecord_subentity", "entry.id as costrecordentryid,entry.assist auxpty,entry.configuredcode configuredcode,entry.tracknumber tracknumber,entry.project project,entry.lot lot,entry.noupdatecalfields noupdatecalfields", new QFilter[]{filter, exFilter});
        JobSession session = AlgoX.createSession((String)"DiffMaterialLvl-CalcGroup");
        DataSetX acctGrpRecordDataX = null;
        acctGrpRecordDataX = acctGrpRecordData != null ? session.fromInput((Input)acctGrpRecordData) : session.fromInput((Input)new DataSetInput(groupRecordDS));
        DataSetX billDataX = session.fromInput((Input)billData);
        acctGrpRecordDataX = acctGrpRecordDataX.addFields(new Field[]{new Field("materialnum", (DataType)DataType.StringType)}, new Object[]{""});
        JoinDataSetX resultX = acctGrpRecordDataX.leftJoin(billDataX).on("billentryid", "costrecordentryid").select(new String[]{"bizgrouprecordid", "type", "materialid", "materialnum"}, new String[]{"costrecordentryid", "auxpty", "configuredcode", "tracknumber", "project", "lot", "noupdatecalfields"});
        resultX = resultX.filter("costrecordentryid is not null");
        resultX = resultX.groupBy(new String[]{"bizgrouprecordid"}).reduceGroup((GroupReduceFunction)new DiffMaterialLvlDealGroupFunction());
        resultX = resultX.distinct(new String[]{"material", "materialnumber", "auxpty", "matversion", "configuredcode", "tracknumber", "project", "lot", "submaterial", "submaterialnumber", "subauxpty", "submatversion", "subconfiguredcode", "subtracknumber", "subproject", "sublot"});
        DataSetOutput resultSet = new DataSetOutput(resultX.getRowMeta());
        resultX.output((Output)resultSet);
        try {
            long start = System.currentTimeMillis();
            session.commit(20, TimeUnit.MINUTES);
            logger.info("\u6210\u7ec4\u5173\u7cfb\u8f6c\u6362\u4e3a\u4f4e\u9636\u7801\u6570\u636e\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u6210\u7ec4\u5173\u7cfb\u8f6c\u6362\u4e3a\u4f4e\u9636\u7801\u8ba1\u7b97\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        return session.readDataSet(resultSet.getId());
    }

    private static DataSet addCalMatGroup(DiffCalcDataArgs args) {
        HashSet matGroupSet = Sets.newHashSet();
        QFilter acctGrpRecordFilter = new QFilter("entryentity.costaccount.id", "=", (Object)args.getCostaccountId());
        acctGrpRecordFilter.and("entryentity.period", "=", (Object)args.getPeriodId());
        DataSet acctGrpRecordData = QueryServiceHelper.queryDataSet((String)"DiffMatLvl-CalMatGroup", (String)"cal_account_grouprecord", (String)"entryentity.type as type,bizgrouprecordid,entryentity.costrecordentryid as billentryid,entryentity.material.id as materialid,entryentity.material.number as materialnum", (QFilter[])new QFilter[]{acctGrpRecordFilter}, null);
        QFilter filter = new QFilter("period.id", "=", (Object)args.getPeriodId());
        filter.and("costaccount.id", "=", (Object)args.getCostaccountId());
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        QFilter exFilter = new QFilter("entry.accounttype", "=", (Object)"D");
        HashSet<String> billtypes = new HashSet<String>(16);
        billtypes.add("im_mdc_ominbill");
        billtypes.add("im_mdc_omproorder");
        billtypes.add("im_mdc_omreturnorder");
        billtypes.add("im_mdc_omfeedorder");
        exFilter.or("bizentityobject", "in", billtypes);
        DataSet billData = QueryServiceHelper.queryDataSet((String)"DiffMatLvl-costrecord", (String)"cal_costrecord_subentity", (String)"entry.id as costrecordentryid,entry.assist auxpty,entry.configuredcode configuredcode,entry.tracknumber tracknumber,entry.project project,entry.lot lot", (QFilter[])new QFilter[]{filter, exFilter}, null);
        JoinDataSet joinDiffDataSet = acctGrpRecordData.leftJoin(billData).on("billentryid", "costrecordentryid");
        DataSet data = joinDiffDataSet.select(new String[]{"bizgrouprecordid", "type", "materialid", "materialnum"}, new String[]{"costrecordentryid", "auxpty", "configuredcode", "tracknumber", "project", "lot"}).finish().filter(" costrecordentryid is not null").orderBy(new String[]{"bizgrouprecordid", "type"});
        Long lastBizgrouprecordid = 0L;
        HashSet<String> srcBillMatIDs = new HashSet<String>(16);
        HashSet<String> targBillMatIDs = new HashSet<String>(16);
        for (Row row : data) {
            Long currBizgrouprecordid = row.getLong("bizgrouprecordid");
            if (lastBizgrouprecordid == 0L) {
                lastBizgrouprecordid = currBizgrouprecordid;
            }
            String materialData = String.format("%s@%s@%s@%s@%s@%s", row.getLong("materialid"), row.getLong("auxpty"), row.getLong("configuredcode"), row.getLong("tracknumber"), row.getLong("project"), row.getString("lot"));
            if (lastBizgrouprecordid.compareTo(currBizgrouprecordid) != 0) {
                for (String srcMatId : srcBillMatIDs) {
                    for (String tarMatId : targBillMatIDs) {
                        if (srcMatId.equals(tarMatId)) continue;
                        matGroupSet.add(String.format("%s--%s", srcMatId, tarMatId));
                    }
                }
                srcBillMatIDs.clear();
                targBillMatIDs.clear();
            }
            if ("0".equals(row.getString("type"))) {
                srcBillMatIDs.add(materialData);
            } else {
                targBillMatIDs.add(materialData);
            }
            lastBizgrouprecordid = currBizgrouprecordid;
        }
        if (!targBillMatIDs.isEmpty() && !srcBillMatIDs.isEmpty()) {
            for (String srcMatId : srcBillMatIDs) {
                for (String tarMatId : targBillMatIDs) {
                    if (srcMatId.equals(tarMatId)) continue;
                    matGroupSet.add(String.format("%s---%s", srcMatId, tarMatId));
                }
            }
        }
        if (!matGroupSet.isEmpty()) {
            ArrayList matGroupList = Lists.newArrayList();
            RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("submaterial", (DataType)DataType.LongType), new Field("submaterialnumber", (DataType)DataType.LongType), new Field("subauxpty", (DataType)DataType.LongType), new Field("submatversion", (DataType)DataType.LongType), new Field("subconfiguredcode", (DataType)DataType.LongType), new Field("subtracknumber", (DataType)DataType.LongType), new Field("subproject", (DataType)DataType.LongType), new Field("sublot", (DataType)DataType.StringType), new Field("material", (DataType)DataType.LongType), new Field("materialnumber", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("matversion", (DataType)DataType.LongType), new Field("configuredcode", (DataType)DataType.LongType), new Field("tracknumber", (DataType)DataType.LongType), new Field("project", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType)});
            for (String matGroupStr : matGroupSet) {
                String[] arr = matGroupStr.split("---");
                String[] sub = arr[0].split("@");
                String[] main = arr[1].split("@");
                if (arr.length <= 1) continue;
                matGroupList.add(new Object[]{Long.valueOf(sub[0]), " ", Long.valueOf(sub[1]), 0L, Long.valueOf(sub[2]), Long.valueOf(sub[3]), Long.valueOf(sub[4]), sub[5], Long.valueOf(main[0]), " ", Long.valueOf(main[1]), 0L, Long.valueOf(main[2]), Long.valueOf(main[3]), Long.valueOf(main[4]), main[5]});
            }
            return Algo.create((String)"dataset").createDataSet(matGroupList.iterator(), targetRowMeta);
        }
        return null;
    }
}

