/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.action;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.sca.algox.enums.CalcReportEntryEnum;
import kd.macc.sca.algox.restore.DiffReportItemEnum;
import kd.macc.sca.algox.restore.action.AbstractDiffCalcAction;
import kd.macc.sca.algox.restore.action.task.DiffCheckArgs;
import kd.macc.sca.algox.restore.action.task.DiffResultCheckTask;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.utils.RestoreCalcReportHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DiffResultCheckAction
extends AbstractDiffCalcAction {
    private static final Log logger = LogFactory.getLog(DiffResultCheckAction.class);
    private static final String DIFF_DATA_CHECK_KEY = "ScaDiffDataCheck";
    private static final String DIFF_CHECK_CONCURRENT_KEY = "ScaDiffCheckConCur";

    @Override
    protected void doExecute() {
        if (!this.getContext().isCalc()) {
            return;
        }
        logger.info("\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u7ed3\u679c\u68c0\u67e5--\u5f00\u59cb");
        long start = System.currentTimeMillis();
        DiffCalcDataArgs dataArgs = this.getContext().getInputArgs();
        RestoreCalcReportHelper.changeEntryStatusById(CalcReportEntryEnum.inventoryCheck.id);
        boolean diffAllocWarn = this.diffAllocCheck(dataArgs);
        RestoreCalcReportHelper.changeEntryStatusById(CalcReportEntryEnum.costCheck.id);
        boolean dataCheck = this.diffDataCheck(dataArgs);
        RestoreCalcReportHelper.clearReportEntryById(CalcReportEntryEnum.costCheck.id);
        RestoreCalcReportHelper.clearReportEntryById(CalcReportEntryEnum.inventoryCheck.id);
        if (dataCheck || diffAllocWarn) {
            this.updateTaskRecordProcess(2, "5");
        }
        logger.info("\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u7ed3\u679c\u68c0\u67e5--\u7ed3\u675f:{}", (Object)(System.currentTimeMillis() - start));
    }

    private DiffCheckArgs getDiffCheckArgs(DiffCalcDataArgs dataArgs) {
        DiffCheckArgs args = new DiffCheckArgs();
        args.setCostaccountId(dataArgs.getCostaccountId());
        args.setCurrencyId(dataArgs.getCurrencyId());
        args.setEndDate(dataArgs.getEndDate());
        args.setOrgId(dataArgs.getOrgId());
        args.setPeriodId(dataArgs.getPeriodId());
        args.setPrePeriodId(dataArgs.getPrePeriodId());
        args.setStartDate(dataArgs.getStartDate());
        args.setTaskRecordId(dataArgs.getTaskRecordId());
        return args;
    }

    private boolean diffDataCheck(DiffCalcDataArgs dataArgs) {
        if ("0".equals(CadBgParamUtils.getCadBgParamForString((String)DIFF_DATA_CHECK_KEY, (String)"1"))) {
            logger.info("\u6210\u672c\u8ba1\u7b97\u540e\u68c0\u67e5\uff0c\u4e0d\u68c0\u67e5\u6570\u636e");
            return false;
        }
        String curItem = ResManager.loadKDString((String)"\u8ba1\u7b97\u540e\u6570\u636e\u68c0\u67e5", (String)"DiffResultCheckAction_5", (String)"macc-sca-algox", (Object[])new Object[0]);
        long itemId = this.getResultManager().getTaskRecorder().saveTaskRecordEntry(curItem, 0L, "2");
        int warnSize = 0;
        DiffCheckArgs args = this.getDiffCheckArgs(dataArgs);
        try {
            if ("1".equals(CadBgParamUtils.getCadBgParamForString((String)DIFF_CHECK_CONCURRENT_KEY, (String)"0"))) {
                HashMap params = Maps.newHashMapWithExpectedSize((int)10);
                HashSet<String> taskIds = new HashSet<String>(16);
                int i = 0;
                String preTitle = ResManager.loadKDString((String)"\u8ba1\u7b97\u540e\u6570\u636e\u68c0\u67e5", (String)"DiffResultCheckAction_5", (String)"macc-sca-algox", (Object[])new Object[0]);
                String className = DiffResultCheckTask.class.getName();
                params.put("task", "downDiffprePeriodAndCurPeriodCheck");
                taskIds.add(this.sendTask(preTitle + "-downDiffprePeriodAndCurPeriodCheck", args, 10, ++i, className, params));
                params.put("task", "diffInAmtCheck");
                taskIds.add(this.sendTask(preTitle + "-diffInAmtCheck", args, 10, ++i, className, params));
                params.put("task", "downDiffAllocFactCheck");
                taskIds.add(this.sendTask(preTitle + "-downDiffAllocFactCheck", args, 10, ++i, className, params));
                params.put("task", "downDiffAllocInCheck");
                taskIds.add(this.sendTask(preTitle + "-downDiffAllocInCheck", args, 10, ++i, className, params));
                params.put("task", "downDiffCalcCheck");
                taskIds.add(this.sendTask(preTitle + "-downDiffCalcCheck", args, 10, ++i, className, params));
                params.put("task", "diffPrePeriodAndCurPeriodCheck");
                taskIds.add(this.sendTask(preTitle + "-diffPrePeriodAndCurPeriodCheck", args, 10, ++i, className, params));
                params.put("task", "diffMergeDataCheck");
                taskIds.add(this.sendTask(preTitle + "-diffMergeDataCheck", args, 10, ++i, className, params));
                params.put("task", "diffResultActCheck");
                taskIds.add(this.sendTask(preTitle + "-diffResultActCheck", args, 10, ++i, className, params));
                params.put("task", "diffFactDataCheck");
                taskIds.add(this.sendTask(preTitle + "-diffFactDataCheck", args, 10, ++i, className, params));
                params.put("task", "diffReportCheck");
                taskIds.add(this.sendTask(preTitle + "-diffReportCheck", args, 10, ++i, className, params));
                this.waitTaskExecute(preTitle, taskIds, null);
                DynamicObject taskRecordDyn = BusinessDataServiceHelper.loadSingle((Object)this.getContext().getInputArgs().getTaskRecordId(), (String)"sca_taskrecord");
                if (taskRecordDyn != null) {
                    DynamicObjectCollection taskRecordEntrys = taskRecordDyn.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : taskRecordEntrys) {
                        String taskstatus = entry.getString("substatus");
                        if (!"6".equals(taskstatus) && !"3".equals(taskstatus)) continue;
                        ++warnSize;
                    }
                }
            } else {
                DiffResultCheckTask task = new DiffResultCheckTask();
                warnSize += task.check(args, "downDiffprePeriodAndCurPeriodCheck");
                warnSize += task.check(args, "diffInAmtCheck");
                warnSize += task.check(args, "downDiffAllocFactCheck");
                warnSize += task.check(args, "downDiffAllocInCheck");
                warnSize += task.check(args, "downDiffCalcCheck");
                warnSize += task.check(args, "diffPrePeriodAndCurPeriodCheck");
                warnSize += task.check(args, "diffMergeDataCheck");
                warnSize += task.check(args, "diffResultActCheck");
                warnSize += task.check(args, "diffFactDataCheck");
                warnSize += task.check(args, "diffReportCheck");
            }
        }
        catch (Exception ex) {
            logger.info("\u5dee\u5f02\u5206\u644a-\u8ba1\u7b97\u7ed3\u679c\u68c0\u67e5\u51fa\u73b0\u9519\u8bef:" + ex.getMessage(), (Object)ex);
            String errorInfo = this.wrapExceptionErrorInfo(ex);
            this.getResultManager().getTaskRecorder().upateTaskRecordDetail(itemId, "3", -1, ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u5b58\u5728\u5f02\u5e38\u3002", (String)"DiffResultCheckAction_6", (String)"macc-sca-algox", (Object[])new Object[0]), errorInfo, "", false);
            return warnSize > 0;
        }
        this.getResultManager().getTaskRecorder().upateTaskRecordDetail(itemId, warnSize > 0 ? "3" : "4");
        return warnSize > 0;
    }

    private String wrapExceptionErrorInfo(Exception ex) {
        StringBuilder erroStr = new StringBuilder();
        String errormsg = ex.getCause() == null ? (ex.getLocalizedMessage() == null ? "" : ex.getLocalizedMessage()) : ex.getCause().getMessage();
        erroStr.append(errormsg).append('\n');
        erroStr.append(ExceptionUtils.getStackTrace((Throwable)ex));
        return erroStr.toString();
    }

    private boolean diffAllocCheck(DiffCalcDataArgs dataArgs) {
        String curItem = DiffReportItemEnum.getName(DiffReportItemEnum.CHECKACTRESULT.getValue());
        Tuple2<Integer, Long> recorderTuple = this.getResultManager().getTaskRecorder().saveTaskRecordEntryRtEntryId(curItem, DiffReportItemEnum.CHECKACTRESULT.getValue(), "2", null);
        String tip = null;
        try {
            tip = DiffResultCheckAction.checkByDiffAlloc(dataArgs);
        }
        catch (Exception ex) {
            tip = ex.getMessage();
            logger.error("\u5b9e\u9645\u6210\u672c\u5bf9\u6570\u68c0\u67e5\u62a5\u9519", (Throwable)ex);
        }
        String status = !StringUtils.isEmpty((CharSequence)tip) ? "7" : "4";
        RestoreCalcReportHelper.changeEntryStatusById(CalcReportEntryEnum.inventoryCheck.id, status);
        if (!StringUtils.isEmpty((CharSequence)tip)) {
            this.getResultManager().getTaskRecorder().upateTaskRecordDetail(DiffReportItemEnum.CHECKACTRESULT.getValue(), "7", (Integer)recorderTuple.t1, ResManager.loadKDString((String)"\u8be6\u60c5", (String)"DiffResultCheckAction_1", (String)"macc-sca-algox", (Object[])new Object[0]), tip, null, true);
            return true;
        }
        this.getResultManager().getTaskRecorder().upateTaskRecordDetail(DiffReportItemEnum.CHECKACTRESULT.getValue(), "4", (Integer)recorderTuple.t1, null);
        return false;
    }

    private static String checkByDiffAlloc(DiffCalcDataArgs dataArgs) {
        int openDiffCheck = CadBgParamUtils.getCadParamForInt((String)"openDiffCheck", (int)1);
        if (openDiffCheck == 1) {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"DiffActCostIsSameCheckService", (String)"checkActCostIsSame", (Object[])new Object[]{dataArgs.getCalcReportId(), dataArgs.getOrgId(), dataArgs.getCostaccountId(), null});
            StringBuilder alterSb = new StringBuilder();
            if (!"true".equals(result.get("success"))) {
                alterSb.append(ResManager.loadKDString((String)"\u5b58\u5728\u5355\u4f4d\u53d1\u51fa\u5b9e\u9645\u6210\u672c\u4e0e\u5355\u4f4d\u7ed3\u5b58\u5b9e\u9645\u6210\u672c\u4e0d\u4e00\u81f4\u3002", (String)"DiffResultCheckAction_7", (String)"macc-sca-algox", (Object[])new Object[0]));
            }
            return alterSb.toString();
        }
        boolean isNewPeriodBal = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalanceService", (String)"isNewPeriodBal", null);
        DynamicObject periodInfo = BusinessDataServiceHelper.loadSingle((Object)dataArgs.getPeriodId(), (String)"bd_period");
        int periodNum = periodInfo.getInt("periodyear") * 100 + periodInfo.getInt("periodnumber");
        QFilter filter = new QFilter("costaccount", "=", (Object)dataArgs.getCostaccountId());
        filter.and("period", "<=", (Object)periodNum);
        filter.and("endperiod", ">", (Object)periodNum);
        filter.and("accounttype", "=", (Object)"D");
        DataSet balSet = null;
        balSet = isNewPeriodBal ? QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.utils.ActualPriceCheckHelper.checkByDiffAlloc", (String)"cal_bal", (String)DiffResultCheckAction.getNewBalSelectFields(periodNum), (QFilter[])new QFilter[]{filter}, null) : QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.utils.ActualPriceCheckHelper.checkByDiffAlloc", (String)"cal_balance", (String)DiffResultCheckAction.getBalSelectFields(periodNum), (QFilter[])new QFilter[]{filter}, null);
        GroupbyDataSet groupbyDataSet = balSet.groupBy(new String[]{"calrangeid", "calrangenum", "calrangename", "materialid", "materialnum", "materialname"});
        groupbyDataSet.sum("periodbeginqty");
        groupbyDataSet.sum("periodbeginamount");
        groupbyDataSet.sum("periodinqty");
        groupbyDataSet.sum("periodinamount");
        groupbyDataSet.sum("periodoutqty");
        groupbyDataSet.sum("periodoutamount");
        groupbyDataSet.sum("periodendqty");
        groupbyDataSet.sum("periodendamount");
        balSet = groupbyDataSet.finish().select(new String[]{"calrangeid", "calrangenum", "calrangename", "materialid", "materialnum", "materialname", "case when periodbeginqty + periodinqty != 0 then (periodbeginamount + periodinamount)/(periodbeginqty + periodinqty) else 0 end as inprice", "case when periodoutqty != 0 then periodoutamount/periodoutqty else 0 end as outprice", "case when periodendqty != 0 then periodendamount/periodendqty else 0 end as endprice"});
        balSet = balSet.filter(" inprice <> 0 and (outprice <> 0 or endprice <> 0)");
        balSet = balSet.select(new String[]{"calrangeid", "calrangenum", "calrangename", "materialid", "materialnum", "materialname", "case when outprice <> 0 then inprice - outprice else 0 end as outPriceDiff", "case when endprice <> 0 then inprice - endprice else 0 end as endPriceDiff"});
        balSet = balSet.filter(" outPriceDiff > 0.1 or endPriceDiff > 0.1 or outPriceDiff < -0.1 or endPriceDiff < -0.1");
        StringBuilder alterSb = new StringBuilder();
        HashMap<String, StringBuilder> messages = new HashMap<String, StringBuilder>(16);
        for (Row row : balSet) {
            BigDecimal diffPrice = BigDecimal.ZERO;
            diffPrice = row.getBigDecimal("outPriceDiff").abs().compareTo(row.getBigDecimal("endPriceDiff")) > 0 ? row.getBigDecimal("outPriceDiff").setScale(dataArgs.getAmtPrecision(), RoundingMode.HALF_UP) : row.getBigDecimal("endPriceDiff").setScale(dataArgs.getAmtPrecision(), RoundingMode.HALF_UP);
            String calrangenum = row.getString("calrangenum");
            String calrangename = row.getString("calrangename");
            String materialnum = row.getString("materialnum");
            String materialname = row.getString("materialname");
            StringBuilder message = (StringBuilder)messages.get(calrangenum);
            if (message != null) continue;
            message = new StringBuilder();
            message.append(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u3010%1$s/%2$s\u3011\u2014>\u7269\u6599:\u3010%3$s/%4$s\u3011\u4ef7\u683c\u5dee\u5f02\uff1a%5$s", (String)"DiffResultCheckAction_8", (String)"macc-sca-algox", (Object[])new Object[0]), calrangenum, calrangename, materialnum, materialname, diffPrice));
            messages.put(calrangenum, message);
        }
        for (Map.Entry message : messages.entrySet()) {
            alterSb = alterSb.append((CharSequence)message.getValue()).append('\u3002');
        }
        return alterSb.toString();
    }

    private static String getBalSelectFields(int periodNum) {
        String select = "calrange.id as calrangeid,calrange.number as calrangenum,calrange.name as calrangename,material.id as materialid,material.number as materialnum,material.name as materialname,case when period = " + periodNum + " then periodbeginqty else periodendqty  end as periodbeginqty,case when period = " + periodNum + " then beginstandardcost + periodbegincostdiff else periodendstandardcost + periodendcostdiff end as periodbeginamount,case when period = " + periodNum + " then periodinqty else 0 end as periodinqty,case when period = " + periodNum + " then periodinstandardcost + periodincostdiff else 0 end as periodinamount,case when period = " + periodNum + " then periodissueqty else 0 end as periodoutqty,case when period = " + periodNum + " then periodissuestandardcost + periodissuecostdiff else 0 end as periodoutamount,periodendqty as periodendqty,periodendstandardcost + periodendcostdiff as periodendamount";
        return select;
    }

    private static String getNewBalSelectFields(int periodNum) {
        String select = "calrange.id as calrangeid,calrange.number as calrangenum,calrange.name as calrangename,material.id as materialid,material.number as materialnum,material.name as materialname,case when period = " + periodNum + " then baseqty else baseqty_bal  end as periodbeginqty,case when period = " + periodNum + " then standardcost + costdiff else standardcost_bal + costdiff_bal end as periodbeginamount,case when period = " + periodNum + " then baseqty_in else 0 end as periodinqty,case when period = " + periodNum + " then standardcost_in + costdiff_in else 0 end as periodinamount,case when period = " + periodNum + " then baseqty_out else 0 end as periodoutqty,case when period = " + periodNum + " then standardcost_out + costdiff_out else 0 end as periodoutamount,baseqty_bal as periodendqty,standardcost_bal + costdiff_bal as periodendamount";
        return select;
    }
}

