/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.action.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.restore.DiffReportItemEnum;
import kd.macc.sca.algox.restore.action.task.DiffCheckArgs;
import kd.macc.sca.algox.restore.action.task.DiffResultCheckMapFunction;
import kd.macc.sca.algox.restore.common.TaskRecordEntryRow;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;
import org.apache.commons.lang3.StringUtils;

public class DiffResultCheckTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DiffResultCheckTask.class);
    private static final int MAX_ERROR_SIZE = 2000;

    public void execute(RequestContext request, Map<String, Object> paramMap) throws KDException {
        DiffCheckArgs dataArgs = null;
        try {
            String json = null;
            if (paramMap.containsKey("paramId")) {
                Long paramId = (Long)paramMap.get("paramId");
                DynamicObjectCollection dyns = QueryServiceHelper.query((String)"sca_parparam", (String)"type,param_tag", (QFilter[])new QFilter("id", "=", (Object)paramId).toArray());
                if (!dyns.isEmpty()) {
                    json = ((DynamicObject)dyns.get(0)).getString("param_tag");
                }
            } else {
                json = (String)paramMap.get("param");
            }
            dataArgs = (DiffCheckArgs)JSON.parseObject((String)json, DiffCheckArgs.class);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        Object task = paramMap.get("task");
        if (task == null) {
            return;
        }
        this.check(dataArgs, task.toString());
    }

    public int check(DiffCheckArgs dataArgs, String task) {
        int warnSize = 0;
        long start = System.currentTimeMillis();
        switch (task) {
            case "downDiffprePeriodAndCurPeriodCheck": {
                warnSize = this.downDiffprePeriodAndCurPeriodCheck(dataArgs, start);
                logger.info("\u68c0\u67e5\u671f\u521d\u4e0b\u9636\u5dee\u5f02\u7684\u4e0e\u4e0a\u671f\u671f\u672b\u662f\u5426\u4e00\u81f4-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                break;
            }
            case "diffInAmtCheck": {
                warnSize += this.diffInAmtCheck(dataArgs, start);
                logger.info("\u68c0\u67e5\u672c\u671f\u751f\u6210\u7684\u4e0b\u9636\u5dee\u5f02\uff08\u4ece\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u83b7\u53d6\uff09\u4e0e\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u6295\u5165\u662f\u5426\u4e00\u81f4-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                break;
            }
            case "downDiffAllocFactCheck": {
                warnSize += this.downDiffAllocFactCheck(dataArgs, start);
                logger.info("\u68c0\u67e5\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u4e0e\u5dee\u5f02\u5206\u914d\u5355\uff08\u5b8c\u5de5\uff09\u91d1\u989d\u662f\u5426\u4e00\u81f4-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                break;
            }
            case "downDiffAllocInCheck": {
                warnSize += this.downDiffAllocInCheck(dataArgs, start);
                logger.info("\u68c0\u67e5\u4e0b\u9636\u5dee\u5f02\u2022\u671f\u672b\u5728\u4ea7\u54c1\u4e0e\u5dee\u5f02\u5206\u914d\u5355\uff08\u5728\u5236\uff09\u91d1\u989d\u662f\u5426\u4e00\u81f4-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                break;
            }
            case "downDiffCalcCheck": {
                warnSize += this.downDiffCalcCheck(dataArgs, start);
                logger.info("\u68c0\u67e5\u201c\u671f\u521d\u5728\u4ea7\u54c1+\u672c\u671f\u6295\u5165=\u672c\u671f\u5dee\u5f02\u8f6c\u51fa+\u671f\u672b\u5728\u4ea7\u54c1\u201d-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                break;
            }
            case "diffPrePeriodAndCurPeriodCheck": {
                warnSize += this.diffPrePeriodAndCurPeriodCheck(dataArgs, start);
                logger.info("\u68c0\u67e5\u671f\u521d\u4e0e\u4e0a\u671f\u671f\u672b\u662f\u5426\u4e00\u81f4-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                break;
            }
            case "diffMergeDataCheck": {
                warnSize += this.diffMergeDataCheck(dataArgs, start);
                logger.info("\u68c0\u67e5\u201c\u672c\u671f\u5b8c\u5de5=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u672c\u671f\u5b8c\u5de5+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u672c\u671f\u5b8c\u5de5+\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u201d-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                break;
            }
            case "diffResultActCheck": {
                warnSize += this.diffResultActCheck(dataArgs, start);
                logger.info("\u68c0\u67e5\u5b9e\u9645\u6210\u672c\u201c\u671f\u521d\u5728\u4ea7\u54c1+\u672c\u671f\u6295\u5165=\u672c\u671f\u5b8c\u5de5+\u671f\u672b\u5728\u4ea7\u54c1\u201d-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                break;
            }
            case "diffFactDataCheck": {
                warnSize += this.diffFactDataCheck(dataArgs, start);
                logger.info(" \u68c0\u67e5\u672c\u671f\u5b8c\u5de5\u5b9e\u9645\u6210\u672c\u201c\u5206\u9879\u6210\u672c\u5408\u8ba1=\u7efc\u5408\u6210\u672c\u5408\u8ba1\u201d-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                break;
            }
            case "diffReportCheck": {
                warnSize += this.diffReportCheck(dataArgs, start);
                logger.info("\u68c0\u67e5\u5dee\u5f02\u5206\u644a\u5bf9\u6570\u62a5\u8868-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            }
        }
        return warnSize;
    }

    private int diffInAmtCheck(DiffCheckArgs dataArgs, long start) {
        QFilter qFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        qFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        qFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        qFilter.and("appnum", "=", (Object)"sca");
        qFilter.and("allocstatus", "=", (Object)"2");
        OrmInput matAllocDs = new OrmInput("getMatAlloc", "sca_matalloc", "matcollect matcollectid,material", qFilter.toArray());
        QFilter coqFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        coqFilter.and("bookdate", ">=", (Object)dataArgs.getStartDate());
        coqFilter.and("bookdate", "<=", (Object)dataArgs.getEndDate());
        coqFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
        OrmInput matcollectDs = new OrmInput("matcollect", "sca_matusecollect", "entryentity.id AS matusecolectentryid,entryentity.sourcebillentryid AS sourcebillentryid", coqFilter.toArray());
        QFilter costRFilter = new QFilter("calorg", "=", (Object)dataArgs.getOrgId());
        costRFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        costRFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        costRFilter.and("bookdate", ">=", (Object)dataArgs.getStartDate());
        costRFilter.and("bookdate", "<=", (Object)dataArgs.getEndDate());
        costRFilter.and("calbilltype", "=", (Object)"OUT");
        OrmInput costRecordDs = new OrmInput("getCalCostRecord", "cal_costrecord_subentity", "id AS recordid,entry.id rentryid,entry.bizbillentryid AS bizbillentryid", costRFilter.toArray());
        QFilter diffFilter = new QFilter("biztype", "=", (Object)"B");
        diffFilter.and("calorg", "=", (Object)dataArgs.getOrgId());
        diffFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        diffFilter.and("bookdate", ">=", (Object)dataArgs.getStartDate());
        diffFilter.and("bookdate", "<=", (Object)dataArgs.getEndDate());
        OrmInput diffDs = new OrmInput("getCalCostRecord", "cal_stdcostdiffbill", "entryentity.invbillid AS recordid,entryentity.invbillentryid AS rentryid,entryentity.adjustamt adjustamt", diffFilter.toArray());
        QFilter downFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        downFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        downFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        downFilter.and("entryentity2.type2", "=", (Object)"5");
        OrmInput diffInDs = new OrmInput("loadSubElementMfgFeeal", "sca_diffcalcresult", "entryentity2.material2 material,entryentity2.curramt2 as curramt,entryentity2.curractcostupamt2 as curractamt", downFilter.toArray());
        JobSession session = AlgoX.createSession((String)"diffInCheck");
        DataSetX matAllocDsX = session.fromInput((Input)matAllocDs);
        DataSetX matcollectDsX = session.fromInput((Input)matcollectDs);
        DataSetX costRecordDsX = session.fromInput((Input)costRecordDs);
        DataSetX diffDsX = session.fromInput((Input)diffDs);
        DataSetX diffInDsX = session.fromInput((Input)diffInDs);
        JoinDataSetX resultDsx = matAllocDsX.join(matcollectDsX).on("matcollectid", "matusecolectentryid").select(matAllocDsX.getRowMeta().getFieldNames(), new String[]{"sourcebillentryid"});
        resultDsx = resultDsx.leftJoin(costRecordDsX).on("sourcebillentryid", "bizbillentryid").select(resultDsx.getRowMeta().getFieldNames(), new String[]{"rentryid"});
        resultDsx = resultDsx.leftJoin(diffDsX).on("rentryid", "rentryid").select(resultDsx.getRowMeta().getFieldNames(), new String[]{"adjustamt"});
        resultDsx = resultDsx.groupBy(new String[]{"material"}).sum("adjustamt");
        resultDsx = resultDsx.addFields(new Field[]{new Field("actamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        diffInDsX = diffInDsX.addFields(new Field[]{new Field("actamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        diffInDsX = diffInDsX.map((MapFunction)new DiffResultCheckMapFunction());
        diffInDsX = diffInDsX.groupBy(new String[]{"material"}).sum("actamt");
        diffInDsX = diffInDsX.addFields(new Field[]{new Field("adjustamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        resultDsx = DataSetXHelper.union((DataSetX)resultDsx, diffInDsX);
        resultDsx = resultDsx.groupBy(new String[]{"material"}).sum("adjustamt").sum("actamt");
        DataSetOutput result = new DataSetOutput(resultDsx.getRowMeta());
        resultDsx.output((Output)result);
        try {
            session.commit(2, TimeUnit.HOURS);
        }
        catch (Exception e) {
            logger.error("\u5dee\u5f02\u5206\u644a-\u5165\u65b9\u5dee\u5f02\u6bd4\u5bf9\uff1a", (Throwable)e);
            throw e;
        }
        DataSet resultDs = session.readDataSet(result.getId());
        resultDs = resultDs.select("material,case when adjustamt is null then 0.0 else adjustamt end adjustamt,case when actamt is null then 0.0 else actamt end actamt");
        resultDs = resultDs.filter("adjustamt-actamt<>0");
        if (resultDs.isEmpty()) {
            return 0;
        }
        resultDs.close();
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u672c\u671f\u751f\u6210\u7684\u4e0b\u9636\u5dee\u5f02\uff08\u4ece\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u83b7\u53d6\uff09\u4e0e\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u6295\u5165\u662f\u5426\u4e00\u81f4", (String)"DiffResultCheckTask_0", (String)"macc-sca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u672c\u671f\u751f\u6210\u7684\u4e0b\u9636\u5dee\u5f02\u4e0e\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u6295\u5165\u5b58\u5728\u5dee\u5f02\u3002", (String)"DiffResultCheckTask_1", (String)"macc-sca-algox", (Object[])new Object[0]);
        this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), start);
        return 1;
    }

    private int diffFactDataCheck(DiffCheckArgs dataArgs, long start) {
        QFilter qFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        qFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        qFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        qFilter.and("entryentity.datatype", "=", (Object)"1");
        String resultFields = "entryentity.obj.costcenter costcenter,entryentity.obj costobject,entryentity.pdcompanount+entryentity.diff compamt,0.0 diffcompamt";
        DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_calcresult", (String)resultFields, (QFilter[])qFilter.toArray(), null);
        QFilter absoubFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        absoubFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        absoubFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        absoubFilter.and("unabsorbentry.mfgtype", "=", (Object)"5");
        String absoubFields = "unabsorbentry.mfgobj.costcenter costcenter,unabsorbentry.mfgobj costobject,unabsorbentry.mfgpddiffamt compamt,0.0 diffcompamt";
        DataSet absoubDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_calcresult", (String)absoubFields, (QFilter[])absoubFilter.toArray(), null);
        QFilter downFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        downFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        downFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        downFilter.and("entryentity2.type2", "=", (Object)"5");
        String downFields = "entryentity2.relacostobject2.costcenter costcenter,entryentity2.relacostobject2 costobject,entryentity2.compactcostupamt2-entryentity2.compamt2 as compamt";
        DataSet downDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)downFields, (QFilter[])downFilter.toArray(), null);
        downDataSet = downDataSet.groupBy(new String[]{"costcenter", "costobject"}).sum("compamt").finish().select("costcenter,costobject,compamt,0.0 diffcompamt");
        QFilter compFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        compFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        compFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        compFilter.and("entryentity1.type1", "=", (Object)"5");
        String compFields = "entryentity1.relacostobject1.costcenter,entryentity1.relacostobject1 costobject,0.0 compamt,entryentity1.compactcostupamt1 as diffcompamt";
        DataSet compDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)compFields, (QFilter[])compFilter.toArray(), null);
        DataSet resultDs = resultDataSet.union(new DataSet[]{absoubDataSet, downDataSet, compDataSet});
        DataSet compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject"}).sum("compamt").sum("diffcompamt").finish();
        compareDs = compareDs.select("costcenter,costobject,case when compamt is null then 0.0 else compamt end compamt,case when diffcompamt is null then 0.0 else diffcompamt end diffcompamt");
        compareDs = compareDs.filter("abs(compamt-diffcompamt)>0.01");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u672c\u671f\u5b8c\u5de5\u5b9e\u9645\u6210\u672c\u201c\u5206\u9879\u6210\u672c\u5408\u8ba1=\u7efc\u5408\u6210\u672c\u5408\u8ba1\u201d", (String)"DiffResultCheckTask_2", (String)"macc-sca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u672c\u671f\u5b8c\u5de5\u5b9e\u9645\u6210\u672c\u201c\u5206\u9879\u6210\u672c\u5408\u8ba1=\u7efc\u5408\u6210\u672c\u5408\u8ba1\u201d \u5b58\u5728\u5dee\u5f02", (String)"DiffResultCheckTask_3", (String)"macc-sca-algox", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), start);
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem, dataArgs);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u672c\u671f\u5b8c\u5de5\u5b9e\u9645\u6210\u672c\u201c\u5206\u9879\u6210\u672c\u5408\u8ba1\u4e3a\u3010%1$s\u3011=\u7efc\u5408\u6210\u672c\u5408\u8ba1\u4e3a\u3010%2$s\u3011\u201d\u3002", (String)"DiffResultCheckTask_4", (String)"macc-sca-algox", (Object[])new Object[0]), this.getBigDecimalStr(row.getBigDecimal("compamt")), this.getBigDecimalStr(row.getBigDecimal("diffcompamt")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    private int diffResultActCheck(DiffCheckArgs dataArgs, long start) {
        String sqlSelect = "entryentity1.subelement1 subelement,entryentity1.startactcostupamt1 as startamt,entryentity1.curractcostupamt1 as curramt,entryentity1.compactcostupamt1 as compamt,entryentity1.endactcostupamt1 as endamt";
        QFilter qFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        qFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        qFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        qFilter.and("entryentity1.type1", "=", (Object)"5");
        DataSet currDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)sqlSelect, (QFilter[])qFilter.toArray(), null);
        DataSet compareDs = currDataSet.groupBy(null).sum("startamt").sum("curramt").sum("compamt").sum("endamt").finish();
        compareDs = compareDs.select("case when startamt is null then 0.0 else startamt end startamt,case when curramt is null then 0.0 else curramt end curramt,case when compamt is null then 0.0 else compamt end compamt,case when endamt is null then 0.0 else endamt end endamt");
        compareDs = compareDs.filter("startamt+curramt-compamt-endamt!=0");
        if (compareDs.isEmpty()) {
            logger.info("diffResultActCheck-nodiff");
            return 0;
        }
        logger.info("diffResultActCheck-hasdiff");
        compareDs.close();
        sqlSelect = "costcenter,costobject,entryentity1.subelement1 subelement,entryentity1.startactcostupamt1 as startamt,entryentity1.curractcostupamt1 as curramt,entryentity1.compactcostupamt1 as compamt,entryentity1.endactcostupamt1 as endamt";
        qFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        qFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        qFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        qFilter.and("entryentity1.type1", "=", (Object)"1");
        currDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)sqlSelect, (QFilter[])qFilter.toArray(), null);
        compareDs = currDataSet.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("startamt").sum("curramt").sum("compamt").sum("endamt").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when startamt is null then 0.0 else startamt end startamt,case when curramt is null then 0.0 else curramt end curramt,case when compamt is null then 0.0 else compamt end compamt,case when endamt is null then 0.0 else endamt end endamt");
        compareDs = compareDs.filter("startamt+curramt-compamt-endamt!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u5b9e\u9645\u6210\u672c\u201c\u671f\u521d\u5728\u4ea7\u54c1+\u672c\u671f\u6295\u5165=\u672c\u671f\u5b8c\u5de5+\u671f\u672b\u5728\u4ea7\u54c1\u201d", (String)"DiffResultCheckTask_5", (String)"macc-sca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u201c\u671f\u521d\u5728\u4ea7\u54c1+\u672c\u671f\u6295\u5165=\u672c\u671f\u5b8c\u5de5+\u671f\u672b\u5728\u4ea7\u54c1\u201d\u5b58\u5728\u5dee\u5f02", (String)"DiffResultCheckTask_6", (String)"macc-sca-algox", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), start);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem, dataArgs);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010\u5b9e\u9645\u6210\u672c\u3011\u3010%1$s/%2$s\u3011\u4e0d\u6ee1\u8db3\u201c\u671f\u521d\u5728\u4ea7\u54c1\u3010%3$s\u3011+\u672c\u671f\u6295\u5165\u3010%4$s\u3011=\u672c\u671f\u5b8c\u5de5\u3010%5$s\u3011+\u671f\u672b\u5728\u4ea7\u54c1\u3010%6$s\u3011\u201d\u3002", (String)"DiffResultCheckTask_7", (String)"macc-sca-algox", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("startamt")), this.getBigDecimalStr(row.getBigDecimal("curramt")), this.getBigDecimalStr(row.getBigDecimal("compamt")), this.getBigDecimalStr(row.getBigDecimal("endamt")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    private int diffMergeDataCheck(DiffCheckArgs dataArgs, long startTime) {
        DynamicObject newEntry;
        int seq;
        DynamicObjectCollection entryList;
        DynamicObject checkDetail;
        long itemId;
        String detail;
        String curItem;
        QFilter qFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        qFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        qFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        qFilter.and("entryentity.datatype", "in", (Object)new String[]{"99", "98"});
        String resultFields = "entryentity.pdstartamount startamt,entryentity.pdcurramount curramt,entryentity.pdcompanount+entryentity.diff compamt,entryentity.pdendamount endamt";
        DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_calcresult", (String)resultFields, (QFilter[])qFilter.toArray(), null);
        resultDataSet = resultDataSet.groupBy(null).sum("startamt").sum("curramt").sum("compamt").sum("endamt").finish();
        resultDataSet = resultDataSet.select("startamt,curramt,compamt,endamt,0.0 startunjoinamt,0.0 currunjoinamt,0.0 compunjoinamt,0.0 endunjoinamt,0.0 downstartamt,0.0 downcurramt,0.0 downcompamt,0.0 downendamt,0.0 compstartamt,0.0 compcurramt,0.0 compcompamt,0.0 compendamt");
        QFilter absoubFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        absoubFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        absoubFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        absoubFilter.and("unabsorbentry.mfgtype", "=", (Object)"5");
        String absoubFields = "unabsorbentry.mfgpdendamt endunjoinamt,unabsorbentry.mfgpddiffamt compunjoinamt,unabsorbentry.mfgpdcurramt currunjoinamt,unabsorbentry.mfgpdstartamt startunjoinamt";
        DataSet absoubDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_calcresult", (String)absoubFields, (QFilter[])absoubFilter.toArray(), null);
        absoubDataSet = absoubDataSet.groupBy(null).sum("startunjoinamt").sum("currunjoinamt").sum("compunjoinamt").sum("endunjoinamt").finish();
        absoubDataSet = absoubDataSet.select("0.0 startamt,0.0 curramt,0.0 compamt,0.0 endamt,startunjoinamt,currunjoinamt,compunjoinamt,endunjoinamt,0.0 downstartamt,0.0 downcurramt,0.0 downcompamt,0.0 downendamt,0.0 compstartamt,0.0 compcurramt,0.0 compcompamt,0.0 compendamt");
        QFilter downFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        downFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        downFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        downFilter.and("entryentity2.id", ">", (Object)0L);
        downFilter.and("entryentity2.type2", "=", (Object)"5");
        String downFields = "entryentity2.startactcostupamt2-entryentity2.startamt2 as downstartamt,entryentity2.curractcostupamt2-entryentity2.curramt2 as downcurramt,entryentity2.compactcostupamt2-entryentity2.compamt2 as downcompamt,entryentity2.endactcostupamt2-entryentity2.endamt2 as downendamt";
        DataSet downDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)downFields, (QFilter[])downFilter.toArray(), null);
        downDataSet = downDataSet.groupBy(null).sum("downstartamt").sum("downcurramt").sum("downcompamt").sum("downendamt").finish();
        downDataSet = downDataSet.select("0.0 startamt,0.0 curramt,0.0 compamt,0.0 endamt,0.0 startunjoinamt,0.0 currunjoinamt,0.0 compunjoinamt,0.0 endunjoinamt,downstartamt,downcurramt,downcompamt,downendamt,0.0 compstartamt,0.0 compcurramt,0.0 compcompamt,0.0 compendamt");
        QFilter compFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        compFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        compFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        compFilter.and("entryentity1.type1", "=", (Object)"5");
        String compFields = "entryentity1.startactcostupamt1 as compstartamt,entryentity1.curractcostupamt1 as compcurramt,entryentity1.compactcostupamt1 as compcompamt,entryentity1.endactcostupamt1 as compendamt";
        DataSet compDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)compFields, (QFilter[])compFilter.toArray(), null);
        compDataSet = compDataSet.groupBy(null).sum("compstartamt").sum("compcurramt").sum("compcompamt").sum("compendamt").finish();
        compDataSet = compDataSet.select("0.0 startamt,0.0 curramt,0.0 compamt,0.0 endamt,0.0 startunjoinamt,0.0 currunjoinamt,0.0 compunjoinamt,0.0 endunjoinamt,0.0 downstartamt,0.0 downcurramt,0.0 downcompamt,0.0 downendamt,compstartamt,compcurramt,compcompamt,compendamt");
        DataSet resultDs = resultDataSet.union(new DataSet[]{absoubDataSet, downDataSet, compDataSet});
        DataSet compareDs = resultDs.groupBy(null).sum("startamt").sum("curramt").sum("compamt").sum("endamt").sum("startunjoinamt").sum("currunjoinamt").sum("compunjoinamt").sum("endunjoinamt").sum("downstartamt").sum("downcurramt").sum("downcompamt").sum("downendamt").sum("compstartamt").sum("compcurramt").sum("compcompamt").sum("compendamt").finish();
        compareDs = compareDs.select("case when startamt is null then 0.0 else startamt end startamt,case when curramt is null then 0.0 else curramt end curramt,case when compamt is null then 0.0 else compamt end compamt,case when endamt is null then 0.0 else endamt end endamt,case when startunjoinamt is null then 0.0 else startunjoinamt end startunjoinamt,case when currunjoinamt is null then 0.0 else currunjoinamt end currunjoinamt,case when compunjoinamt is null then 0.0 else compunjoinamt end compunjoinamt,case when endunjoinamt is null then 0.0 else endunjoinamt end endunjoinamt,case when downstartamt is null then 0.0 else downstartamt end downstartamt,case when downcurramt is null then 0.0 else downcurramt end downcurramt,case when downcompamt is null then 0.0 else downcompamt end downcompamt,case when downendamt is null then 0.0 else downendamt end downendamt,case when compstartamt is null then 0.0 else compstartamt end compstartamt,case when compcurramt is null then 0.0 else compcurramt end compcurramt,case when compcompamt is null then 0.0 else compcompamt end compcompamt,case when compendamt is null then 0.0 else compendamt end compendamt");
        compareDs = compareDs.select("startamt+startunjoinamt+downstartamt-compstartamt start,curramt+currunjoinamt+downcurramt-compcurramt curr,curramt+currunjoinamt+downcurramt-compcurramt com,endamt+endunjoinamt+downendamt-compendamt end");
        compareDs = compareDs.filter("start!=0 or curr!=0 or com!=0 or end!=0");
        if (compareDs.isEmpty()) {
            logger.info("diffMergeDataCheck-nodiff");
            return 0;
        }
        BigDecimal start = BigDecimal.ZERO;
        BigDecimal curr = BigDecimal.ZERO;
        BigDecimal com = BigDecimal.ZERO;
        BigDecimal end = BigDecimal.ZERO;
        BigDecimal sum = BigDecimal.ZERO;
        for (Row row : compareDs) {
            start = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal("start"));
            curr = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal("curr"));
            com = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal("com"));
            end = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal("end"));
            sum = start.add(curr).subtract(com).subtract(end);
        }
        BigDecimal diff = new BigDecimal("1.0");
        if (sum.compareTo(BigDecimal.ZERO) == 0 && start.abs().compareTo(diff) <= 0 && curr.abs().compareTo(diff) <= 0 && com.abs().compareTo(diff) <= 0 && end.abs().compareTo(diff) <= 0) {
            logger.info("diffMergeDataCheck-nodiff,start={},curr={},com={},end={}", new Object[]{start, curr, com, end});
            return 0;
        }
        logger.info("diffMergeDataCheck-hasdiff,start={},curr={},com={},end={}", new Object[]{start, curr, com, end});
        qFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        qFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        qFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        qFilter.and("entryentity.datatype", "=", (Object)"1");
        resultFields = "entryentity.obj.costcenter costcenter,entryentity.obj costobject,entryentity.subelement subelement,entryentity.pdstartamount startamt,entryentity.pdcurramount curramt,entryentity.pdcompanount+entryentity.diff compamt,entryentity.pdendamount endamt";
        resultDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_calcresult", (String)resultFields, (QFilter[])qFilter.toArray(), null);
        resultDataSet = resultDataSet.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("startamt").sum("curramt").sum("compamt").sum("endamt").finish();
        resultDataSet = resultDataSet.select("costcenter,costobject,subelement,startamt,curramt,compamt,endamt,0.0 startunjoinamt,0.0 currunjoinamt,0.0 compunjoinamt,0.0 endunjoinamt,0.0 downstartamt,0.0 downcurramt,0.0 downcompamt,0.0 downendamt,0.0 compstartamt,0.0 compcurramt,0.0 compcompamt,0.0 compendamt");
        absoubFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        absoubFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        absoubFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        absoubFilter.and("unabsorbentry.mfgsubelement", ">", (Object)0L);
        absoubFilter.and("unabsorbentry.mfgtype", "=", (Object)"1");
        absoubFilter.and("unabsorbentry.mfgprotype", "!=", (Object)"B");
        absoubFields = "unabsorbentry.mfgobj.costcenter costcenter,unabsorbentry.mfgobj costobject,unabsorbentry.mfgsubelement subelement,unabsorbentry.mfgpdendamt endunjoinamt,unabsorbentry.mfgpddiffamt compunjoinamt,unabsorbentry.mfgpdcurramt currunjoinamt,unabsorbentry.mfgpdstartamt startunjoinamt";
        absoubDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_calcresult", (String)absoubFields, (QFilter[])absoubFilter.toArray(), null);
        absoubDataSet = absoubDataSet.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("startunjoinamt").sum("currunjoinamt").sum("compunjoinamt").sum("endunjoinamt").finish();
        absoubDataSet = absoubDataSet.select("costcenter,costobject,subelement,0.0 startamt,0.0 curramt,0.0 compamt,0.0 endamt,startunjoinamt,currunjoinamt,compunjoinamt,endunjoinamt,0.0 downstartamt,0.0 downcurramt,0.0 downcompamt,0.0 downendamt,0.0 compstartamt,0.0 compcurramt,0.0 compcompamt,0.0 compendamt");
        downFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        downFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        downFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        downFilter.and("entryentity2.id", ">", (Object)0L);
        downFilter.and("entryentity2.type2", "=", (Object)"5");
        downFields = "costcenter,entryentity2.relacostobject2 costobject,entryentity2.subelement2 subelement,entryentity2.startactcostupamt2-entryentity2.startamt2 as downstartamt,entryentity2.curractcostupamt2-entryentity2.curramt2 as downcurramt,entryentity2.compactcostupamt2-entryentity2.compamt2 as downcompamt,entryentity2.endactcostupamt2-entryentity2.endamt2 as downendamt";
        downDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)downFields, (QFilter[])downFilter.toArray(), null);
        downDataSet = downDataSet.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("downstartamt").sum("downcurramt").sum("downcompamt").sum("downendamt").finish();
        downDataSet = downDataSet.select("costcenter,costobject,subelement,0.0 startamt,0.0 curramt,0.0 compamt,0.0 endamt,0.0 startunjoinamt,0.0 currunjoinamt,0.0 compunjoinamt,0.0 endunjoinamt,downstartamt,downcurramt,downcompamt,downendamt,0.0 compstartamt,0.0 compcurramt,0.0 compcompamt,0.0 compendamt");
        compFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        compFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        compFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        compFilter.and("entryentity1.type1", "=", (Object)"1");
        compFields = "costcenter,entryentity1.relacostobject1 costobject,entryentity1.subelement1 subelement,entryentity1.startactcostupamt1 as compstartamt,entryentity1.curractcostupamt1 as compcurramt,entryentity1.compactcostupamt1 as compcompamt,entryentity1.endactcostupamt1 as compendamt";
        compDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)compFields, (QFilter[])compFilter.toArray(), null);
        compDataSet = compDataSet.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("compstartamt").sum("compcurramt").sum("compcompamt").sum("compendamt").finish();
        compDataSet = compDataSet.select("costcenter,costobject,subelement,0.0 startamt,0.0 curramt,0.0 compamt,0.0 endamt,0.0 startunjoinamt,0.0 currunjoinamt,0.0 compunjoinamt,0.0 endunjoinamt,0.0 downstartamt,0.0 downcurramt,0.0 downcompamt,0.0 downendamt,compstartamt,compcurramt,compcompamt,compendamt");
        resultDs = resultDataSet.union(new DataSet[]{absoubDataSet, downDataSet, compDataSet});
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("startamt").sum("curramt").sum("compamt").sum("endamt").sum("startunjoinamt").sum("currunjoinamt").sum("compunjoinamt").sum("endunjoinamt").sum("downstartamt").sum("downcurramt").sum("downcompamt").sum("downendamt").sum("compstartamt").sum("compcurramt").sum("compcompamt").sum("compendamt").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when startamt is null then 0.0 else startamt end startamt,case when curramt is null then 0.0 else curramt end curramt,case when compamt is null then 0.0 else compamt end compamt,case when endamt is null then 0.0 else endamt end endamt,case when startunjoinamt is null then 0.0 else startunjoinamt end startunjoinamt,case when currunjoinamt is null then 0.0 else currunjoinamt end currunjoinamt,case when compunjoinamt is null then 0.0 else compunjoinamt end compunjoinamt,case when endunjoinamt is null then 0.0 else endunjoinamt end endunjoinamt,case when downstartamt is null then 0.0 else downstartamt end downstartamt,case when downcurramt is null then 0.0 else downcurramt end downcurramt,case when downcompamt is null then 0.0 else downcompamt end downcompamt,case when downendamt is null then 0.0 else downendamt end downendamt,case when compstartamt is null then 0.0 else compstartamt end compstartamt,case when compcurramt is null then 0.0 else compcurramt end compcurramt,case when compcompamt is null then 0.0 else compcompamt end compcompamt,case when compendamt is null then 0.0 else compendamt end compendamt");
        DataSet startCompDs = compareDs.copy().filter("startamt+startunjoinamt+downstartamt-compstartamt!=0");
        DataSet currCompDs = compareDs.copy().filter("curramt+currunjoinamt+downcurramt-compcurramt!=0");
        DataSet compCompDs = compareDs.copy().filter("compamt+compunjoinamt+downcompamt-compcompamt!=0");
        DataSet endCompDs = compareDs.filter("endamt+endunjoinamt+downendamt-compendamt!=0");
        int warnSize = 0;
        if (!startCompDs.isEmpty()) {
            ++warnSize;
            curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u201c\u671f\u521d\u5728\u4ea7\u54c1=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u671f\u521d\u5728\u4ea7\u54c1+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u671f\u521d\u5728\u4ea7\u54c1+\u4e0b\u9636\u5dee\u5f02\u2022\u671f\u521d\u5728\u4ea7\u54c1\u201d", (String)"DiffResultCheckTask_8", (String)"macc-sca-algox", (Object[])new Object[0]);
            detail = ResManager.loadKDString((String)"\u201c\u671f\u521d\u5728\u4ea7\u54c1=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u671f\u521d\u5728\u4ea7\u54c1+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u671f\u521d\u5728\u4ea7\u54c1+\u4e0b\u9636\u5dee\u5f02\u2022\u671f\u521d\u5728\u4ea7\u54c1\u201d\u5b58\u5728\u5dee\u5f02", (String)"DiffResultCheckTask_9", (String)"macc-sca-algox", (Object[])new Object[0]);
            itemId = this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), startTime);
            startCompDs = this.relaSubElementData(startCompDs);
            startCompDs = startCompDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
            checkDetail = this.createCheckDetailDyn(itemId, curItem, dataArgs);
            entryList = checkDetail.getDynamicObjectCollection("entryentity");
            seq = 0;
            for (Row row : startCompDs) {
                if (seq > 2000) break;
                newEntry = entryList.addNew();
                newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
                newEntry.set("costobject", (Object)row.getLong("costobject"));
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010\u5b9e\u9645\u6210\u672c\u3011\u3010%1$s/%2$s\u3011\u4e0d\u6ee1\u8db3\u201c\u671f\u521d\u5728\u4ea7\u54c1\u3010%3$s\u3011=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u671f\u521d\u5728\u4ea7\u54c1\u3010%4$s\u3011+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u671f\u521d\u5728\u4ea7\u54c1\u3010%5$s\u3011+\u4e0b\u9636\u5dee\u5f02\u2022\u671f\u521d\u5728\u4ea7\u54c1\u3010%6$s\u3011\u201d\u3002", (String)"DiffResultCheckTask_10", (String)"macc-sca-algox", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("compstartamt")), this.getBigDecimalStr(row.getBigDecimal("startamt")), this.getBigDecimalStr(row.getBigDecimal("startunjoinamt")), this.getBigDecimalStr(row.getBigDecimal("downstartamt")))));
                newEntry.set("seq", (Object)seq++);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        }
        if (!currCompDs.isEmpty()) {
            ++warnSize;
            curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u201c\u672c\u671f\u6295\u5165=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u672c\u671f\u6295\u5165+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u672c\u671f\u6295\u5165+\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u6295\u5165\u201d", (String)"DiffResultCheckTask_11", (String)"macc-sca-algox", (Object[])new Object[0]);
            detail = ResManager.loadKDString((String)"\u201c\u672c\u671f\u6295\u5165=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u672c\u671f\u6295\u5165+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u672c\u671f\u6295\u5165+\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u6295\u5165\u201d\u5b58\u5728\u5dee\u5f02", (String)"DiffResultCheckTask_12", (String)"macc-sca-algox", (Object[])new Object[0]);
            itemId = this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), startTime);
            currCompDs = this.relaSubElementData(currCompDs);
            currCompDs = currCompDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
            checkDetail = this.createCheckDetailDyn(itemId, curItem, dataArgs);
            entryList = checkDetail.getDynamicObjectCollection("entryentity");
            seq = 0;
            for (Row row : currCompDs) {
                if (seq > 10000) break;
                newEntry = entryList.addNew();
                newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
                newEntry.set("costobject", (Object)row.getLong("costobject"));
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010\u5b9e\u9645\u6210\u672c\u3011\u3010%1$s/%2$s\u3011\u4e0d\u6ee1\u8db3\u201c\u672c\u671f\u6295\u5165\u3010%3$s\u3011=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u672c\u671f\u6295\u5165\u3010%4$s\u3011+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u672c\u671f\u6295\u5165\u3010%5$s\u3011+\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u6295\u5165\u3010%6$s\u3011\u201d\u3002", (String)"DiffResultCheckTask_13", (String)"macc-sca-algox", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("compcurramt")), this.getBigDecimalStr(row.getBigDecimal("curramt")), this.getBigDecimalStr(row.getBigDecimal("currunjoinamt")), this.getBigDecimalStr(row.getBigDecimal("downcurramt")))));
                newEntry.set("seq", (Object)seq++);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        }
        if (!compCompDs.isEmpty()) {
            ++warnSize;
            curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u201c\u672c\u671f\u5b8c\u5de5=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u672c\u671f\u5b8c\u5de5+\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u672c\u671f\u5b8c\u5de5+\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u201d", (String)"DiffResultCheckTask_14", (String)"macc-sca-algox", (Object[])new Object[0]);
            detail = ResManager.loadKDString((String)"\u201c\u672c\u671f\u5b8c\u5de5=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u672c\u671f\u5b8c\u5de5+\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u672c\u671f\u5b8c\u5de5+\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u201d\u5b58\u5728\u5dee\u5f02", (String)"DiffResultCheckTask_15", (String)"macc-sca-algox", (Object[])new Object[0]);
            itemId = this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), startTime);
            compCompDs = this.relaSubElementData(compCompDs);
            compCompDs = compCompDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
            checkDetail = this.createCheckDetailDyn(itemId, curItem, dataArgs);
            entryList = checkDetail.getDynamicObjectCollection("entryentity");
            seq = 0;
            for (Row row : compCompDs) {
                if (seq > 2000) break;
                newEntry = entryList.addNew();
                newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
                newEntry.set("costobject", (Object)row.getLong("costobject"));
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010\u5b9e\u9645\u6210\u672c\u3011\u3010%1$s/%2$s\u3011\u4e0d\u6ee1\u8db3\u201c\u672c\u671f\u5b8c\u5de5\u3010%3$s\u3011=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u672c\u671f\u5b8c\u5de5\u548c\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u3010%4$s\u3011+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u672c\u671f\u5b8c\u5de5\u3010%5$s\u3011+\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u3010%6$s\u3011\u201d\u3002", (String)"DiffResultCheckTask_16", (String)"macc-sca-algox", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("compcompamt")), this.getBigDecimalStr(row.getBigDecimal("compamt")), this.getBigDecimalStr(row.getBigDecimal("compunjoinamt")), this.getBigDecimalStr(row.getBigDecimal("downcompamt")))));
                newEntry.set("seq", (Object)seq++);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        }
        if (!endCompDs.isEmpty()) {
            ++warnSize;
            curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u201c\u671f\u672b\u5728\u4ea7\u54c1=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u671f\u672b\u5728\u4ea7\u54c1+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u671f\u672b\u5728\u4ea7\u54c1+\u4e0b\u9636\u5dee\u5f02\u2022\u671f\u672b\u5728\u4ea7\u54c1\u201d", (String)"DiffResultCheckTask_17", (String)"macc-sca-algox", (Object[])new Object[0]);
            detail = ResManager.loadKDString((String)"\u201c\u671f\u672b\u5728\u4ea7\u54c1=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u671f\u672b\u5728\u4ea7\u54c1+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u671f\u672b\u5728\u4ea7\u54c1+\u4e0b\u9636\u5dee\u5f02\u2022\u671f\u672b\u5728\u4ea7\u54c1\u201d\u5b58\u5728\u5dee\u5f02", (String)"DiffResultCheckTask_18", (String)"macc-sca-algox", (Object[])new Object[0]);
            itemId = this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), startTime);
            endCompDs = this.relaSubElementData(endCompDs);
            endCompDs = endCompDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
            checkDetail = this.createCheckDetailDyn(itemId, curItem, dataArgs);
            entryList = checkDetail.getDynamicObjectCollection("entryentity");
            seq = 0;
            for (Row row : endCompDs) {
                if (seq > 10000) break;
                newEntry = entryList.addNew();
                newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
                newEntry.set("costobject", (Object)row.getLong("costobject"));
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010\u5b9e\u9645\u6210\u672c\u3011\u3010%1$s/%2$s\u3011\u4e0d\u6ee1\u8db3\u201c\u671f\u672b\u5728\u4ea7\u54c1\u3010%3$s\u3011=\u8ba1\u7b97\u7ed3\u679c\u5355\u2022\u671f\u672b\u5728\u4ea7\u54c1\u3010%4$s\u3011+\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u2022\u671f\u672b\u5728\u4ea7\u54c1\u3010%5$s\u3011+\u4e0b\u9636\u5dee\u5f02\u2022\u671f\u672b\u5728\u4ea7\u54c1\u3010%6$s\u3011\u201d\u3002", (String)"DiffResultCheckTask_19", (String)"macc-sca-algox", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("compendamt")), this.getBigDecimalStr(row.getBigDecimal("endamt")), this.getBigDecimalStr(row.getBigDecimal("endunjoinamt")), this.getBigDecimalStr(row.getBigDecimal("downendamt")))));
                newEntry.set("seq", (Object)seq++);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        }
        return warnSize;
    }

    private int diffPrePeriodAndCurPeriodCheck(DiffCheckArgs dataArgs, long start) {
        String sqlSelect = "0.0 as endamt,entryentity1.startactcostupamt1 startamt";
        QFilter qFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        qFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        qFilter.and("entryentity1.type1", "=", (Object)"5");
        DataSet currDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)sqlSelect, (QFilter[])new QFilter[]{qFilter, new QFilter("period", "=", (Object)dataArgs.getPeriodId()), new QFilter("entryentity1.startactcostupamt1", "!=", (Object)BigDecimal.ZERO)}, null);
        sqlSelect = "entryentity1.endactcostupamt1 as endamt,0.0 startamt";
        DataSet preDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)sqlSelect, (QFilter[])new QFilter[]{qFilter, new QFilter("period", "=", (Object)dataArgs.getPrePeriodId()), new QFilter("entryentity1.endactcostupamt1", "!=", (Object)BigDecimal.ZERO)}, null);
        DataSet resultDs = currDataSet.union(preDataSet);
        DataSet compareDs = resultDs.groupBy(null).sum("endamt").sum("startamt").finish();
        compareDs = compareDs.select("case when endamt is null then 0.0 else endamt end endamt,case when startamt is null then 0.0 else startamt end startamt");
        compareDs = compareDs.filter("startamt-endamt!=0");
        if (compareDs.isEmpty()) {
            logger.info("diffPrePeriodAndCurPeriodCheck-nodiff");
            return 0;
        }
        logger.info("diffPrePeriodAndCurPeriodCheck-hasdiff");
        compareDs.close();
        sqlSelect = "costcenter,costobject,entryentity1.subelement1 as subelement,0.0 as endamt,entryentity1.startactcostupamt1 startamt";
        qFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        qFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        qFilter.and("entryentity1.type1", "=", (Object)"1");
        currDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)sqlSelect, (QFilter[])new QFilter[]{qFilter, new QFilter("period", "=", (Object)dataArgs.getPeriodId()), new QFilter("entryentity1.startactcostupamt1", "!=", (Object)BigDecimal.ZERO)}, null);
        sqlSelect = "costcenter,costobject,entryentity1.subelement1 as subelement,entryentity1.endactcostupamt1 as endamt,0.0 startamt";
        preDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)sqlSelect, (QFilter[])new QFilter[]{qFilter, new QFilter("period", "=", (Object)dataArgs.getPrePeriodId()), new QFilter("entryentity1.endactcostupamt1", "!=", (Object)BigDecimal.ZERO)}, null);
        resultDs = currDataSet.union(preDataSet);
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("endamt").sum("startamt").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when endamt is null then 0.0 else endamt end endamt,case when startamt is null then 0.0 else startamt end startamt");
        compareDs = compareDs.filter("startamt-endamt!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u671f\u521d\u6210\u672c\u4e0e\u4e0a\u671f\u671f\u672b\u662f\u5426\u4e00\u81f4\u3002", (String)"DiffResultCheckTask_20", (String)"macc-sca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u671f\u521d\u6210\u672c\u4e0e\u4e0a\u671f\u671f\u672b\u5b58\u5728\u5dee\u5f02\u3002", (String)"DiffResultCheckTask_21", (String)"macc-sca-algox", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), start);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem, dataArgs);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010\u5b9e\u9645\u6210\u672c\u3011\u3010%1$s/%2$s\u3011\u671f\u521d\u5728\u4ea7\u54c1\u4e3a\u3010%3$s\u3011\uff0c\u4e0a\u671f\u671f\u672b\u5728\u4ea7\u54c1\u4e3a\u3010%4$s\u3011\u5b58\u5728\u5dee\u5f02\u3002", (String)"DiffResultCheckTask_22", (String)"macc-sca-algox", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("startamt")), this.getBigDecimalStr(row.getBigDecimal("endamt")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    private int downDiffCalcCheck(DiffCheckArgs dataArgs, long start) {
        String sqlSelect = "entryentity2.startactcostupamt2-entryentity2.startamt2 as startamt,entryentity2.curractcostupamt2-entryentity2.curramt2 as curramt,entryentity2.compactcostupamt2-entryentity2.compamt2 as compamt,entryentity2.endactcostupamt2-entryentity2.endamt2 as endamt";
        QFilter qFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        qFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        qFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        qFilter.and("entryentity2.type2", "=", (Object)"5");
        DataSet currDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)sqlSelect, (QFilter[])qFilter.toArray(), null);
        DataSet compareDs = currDataSet.groupBy(null).sum("startamt").sum("curramt").sum("compamt").sum("endamt").finish();
        compareDs = compareDs.select("case when startamt is null then 0.0 else startamt end startamt,case when curramt is null then 0.0 else curramt end curramt,case when compamt is null then 0.0 else compamt end compamt,case when endamt is null then 0.0 else endamt end endamt");
        compareDs = compareDs.filter("startamt+curramt-compamt-endamt!=0");
        if (compareDs.isEmpty()) {
            logger.info("downDiffCalcCheck-nodiff");
            return 0;
        }
        logger.info("downDiffCalcCheck-hasdiff");
        compareDs.close();
        sqlSelect = "costcenter,costobject,entryentity2.subelement2 as subelement,entryentity2.startactcostupamt2-entryentity2.startamt2 as startamt,entryentity2.curractcostupamt2-entryentity2.curramt2 as curramt,entryentity2.compactcostupamt2-entryentity2.compamt2 as compamt,entryentity2.endactcostupamt2-entryentity2.endamt2 as endamt";
        qFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        qFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        qFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        qFilter.and("entryentity2.type2", "=", (Object)"5");
        currDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)sqlSelect, (QFilter[])qFilter.toArray(), null);
        compareDs = currDataSet.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("startamt").sum("curramt").sum("compamt").sum("endamt").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when startamt is null then 0.0 else startamt end startamt,case when curramt is null then 0.0 else curramt end curramt,case when compamt is null then 0.0 else compamt end compamt,case when endamt is null then 0.0 else endamt end endamt");
        compareDs = compareDs.filter("startamt+curramt-compamt-endamt!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u4e0b\u9636\u5dee\u5f02\u201c\u671f\u521d\u5728\u4ea7\u54c1+\u672c\u671f\u6295\u5165=\u672c\u671f\u5dee\u5f02\u8f6c\u51fa+\u671f\u672b\u5728\u4ea7\u54c1\u201d", (String)"DiffResultCheckTask_23", (String)"macc-sca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u201c\u671f\u521d\u5728\u4ea7\u54c1+\u672c\u671f\u6295\u5165=\u672c\u671f\u5dee\u5f02\u8f6c\u51fa+\u671f\u672b\u5728\u4ea7\u54c1\u201d\u5b58\u5728\u5dee\u5f02", (String)"DiffResultCheckTask_24", (String)"macc-sca-algox", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), start);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem, dataArgs);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010\u5dee\u5f02\u603b\u989d\u3011\u3010%1$s/%2$s\u3011\u4e0d\u6ee1\u8db3\u201c\u671f\u521d\u5728\u4ea7\u54c1\u3010%3$s\u3011+\u672c\u671f\u6295\u5165\u3010%4$s\u3011=\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u3010%5$s\u3011+\u671f\u672b\u5728\u4ea7\u54c1\u3010%6$s\u3011\u201d\u3002", (String)"DiffResultCheckTask_25", (String)"macc-sca-algox", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("startamt")), this.getBigDecimalStr(row.getBigDecimal("curramt")), this.getBigDecimalStr(row.getBigDecimal("compamt")), this.getBigDecimalStr(row.getBigDecimal("endamt")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    private int downDiffAllocInCheck(DiffCheckArgs dataArgs, long start) {
        String selectFields = "entryentity.amount allocAmount,0.0 as calcAmount";
        QFilter filter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        filter.and(new QFilter("costaccount", "=", (Object)dataArgs.getCostaccountId()));
        filter.and("period", "=", (Object)dataArgs.getPeriodId());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("biztype", "=", (Object)"01"));
        DataSet matDs = QueryServiceHelper.queryDataSet((String)"queryMatAllocDataSet", (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])filter.toArray(), (String)"");
        String reaultSelectFields = "0.0 allocAmount,entryentity2.endactcostupamt2-entryentity2.endamt2 calcAmount";
        QFilter resultFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        resultFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        resultFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        resultFilter.and("entryentity2.type2", "=", (Object)"5");
        DataSet calcResultDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"sca_diffcalcresult", (String)reaultSelectFields, (QFilter[])resultFilter.toArray(), (String)"").filter("calcAmount!=0");
        DataSet resultDs = matDs.union(calcResultDs);
        DataSet compareDs = resultDs.groupBy(null).sum("allocAmount").sum("calcAmount").finish();
        compareDs = compareDs.select("case when allocAmount is null then 0.0 else allocAmount end allocAmount,case when calcAmount is null then 0.0 else calcAmount end calcAmount");
        compareDs = compareDs.filter("allocAmount-calcAmount!=0");
        if (compareDs.isEmpty()) {
            logger.info("downDiffAllocInCheck-nodiff");
            return 0;
        }
        logger.info("downDiffAllocInCheck-hasdiff");
        compareDs.close();
        selectFields = "costcenter,becostobject costobject,entryentity.subelement subelement,entryentity.amount allocAmount,0.0 as calcAmount";
        filter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        filter.and(new QFilter("costaccount", "=", (Object)dataArgs.getCostaccountId()));
        filter.and("period", "=", (Object)dataArgs.getPeriodId());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("biztype", "=", (Object)"01"));
        matDs = QueryServiceHelper.queryDataSet((String)"queryMatAllocDataSet", (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])filter.toArray(), (String)"");
        reaultSelectFields = "entryentity2.relacostobject2.costcenter costcenter,entryentity2.relacostobject2 costobject,entryentity2.subelement2 subelement,0.0 allocAmount,entryentity2.endactcostupamt2-entryentity2.endamt2 calcAmount";
        resultFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        resultFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        resultFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        resultFilter.and("entryentity2.type2", "=", (Object)"5");
        calcResultDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"sca_diffcalcresult", (String)reaultSelectFields, (QFilter[])resultFilter.toArray(), (String)"").filter("calcAmount!=0");
        resultDs = matDs.union(calcResultDs);
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("allocAmount").sum("calcAmount").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when allocAmount is null then 0.0 else allocAmount end allocAmount,case when calcAmount is null then 0.0 else calcAmount end calcAmount");
        compareDs = compareDs.filter("allocAmount-calcAmount!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u4e0b\u9636\u5dee\u5f02\u2022\u671f\u672b\u5728\u4ea7\u54c1\u4e0e\u5dee\u5f02\u5206\u914d\u5355\uff08\u5728\u5236\uff09\u91d1\u989d\u662f\u5426\u4e00\u81f4\u3002", (String)"DiffResultCheckTask_26", (String)"macc-sca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u4e0b\u9636\u5dee\u5f02\u2022\u671f\u672b\u5728\u4ea7\u54c1\u4e0e\u5dee\u5f02\u5206\u914d\u5355\uff08\u5728\u5236\uff09\u91d1\u989d\u5b58\u5728\u5dee\u5f02\u3002", (String)"DiffResultCheckTask_27", (String)"macc-sca-algox", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), start);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem, dataArgs);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010\u5dee\u5f02\u603b\u989d\u3011\u3010%1$s/%2$s\u3011\u4e0b\u9636\u5dee\u5f02\u2022\u671f\u672b\u5728\u4ea7\u54c1\u4e3a\u3010%3$s\u3011\uff0c\u5dee\u5f02\u5206\u914d\u5355\uff08\u5728\u5236\uff09\u4e3a\u3010%4$s\u3011\uff0c\u5b58\u5728\u5dee\u5f02\u3002", (String)"DiffResultCheckTask_28", (String)"macc-sca-algox", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("calcAmount")), this.getBigDecimalStr(row.getBigDecimal("allocAmount")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    private int downDiffAllocFactCheck(DiffCheckArgs dataArgs, long start) {
        String selectFields = "difftotal allocAmount,0.0 as calcAmount";
        QFilter filter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        filter.and(new QFilter("costaccount", "=", (Object)dataArgs.getCostaccountId()));
        filter.and("period", "=", (Object)dataArgs.getPeriodId());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("biztype", "=", (Object)"00"));
        DataSet matDs = QueryServiceHelper.queryDataSet((String)"queryMatAllocDataSet", (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])filter.toArray(), (String)"");
        String reaultSelectFields = "0.0 allocAmount,entryentity2.compactcostupamt2-entryentity2.compamt2 calcAmount";
        QFilter resultFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        resultFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        resultFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        resultFilter.and("entryentity2.type2", "=", (Object)"5");
        DataSet calcResultDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"sca_diffcalcresult", (String)reaultSelectFields, (QFilter[])resultFilter.toArray(), (String)"").filter("calcAmount!=0");
        DataSet resultDs = matDs.union(calcResultDs);
        DataSet compareDs = resultDs.groupBy(null).sum("allocAmount").sum("calcAmount").finish();
        compareDs = compareDs.select("case when allocAmount is null then 0.0 else allocAmount end allocAmount,case when calcAmount is null then 0.0 else calcAmount end calcAmount");
        compareDs = compareDs.filter("allocAmount-calcAmount!=0");
        if (compareDs.isEmpty()) {
            logger.info("downDiffAllocFactCheck-nodiff");
            return 0;
        }
        logger.info("downDiffAllocFactCheck-hasdiff");
        compareDs.close();
        selectFields = "costcenter,becostobject costobject,entryentity.subelement subelement,entryentity.amount allocAmount,0.0 as calcAmount";
        filter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        filter.and(new QFilter("costaccount", "=", (Object)dataArgs.getCostaccountId()));
        filter.and("period", "=", (Object)dataArgs.getPeriodId());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("biztype", "=", (Object)"00"));
        matDs = QueryServiceHelper.queryDataSet((String)"queryMatAllocDataSet", (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])filter.toArray(), (String)"");
        reaultSelectFields = "entryentity2.relacostobject2.costcenter costcenter,entryentity2.relacostobject2 costobject,entryentity2.subelement2 subelement,0.0 allocAmount,entryentity2.compactcostupamt2-entryentity2.compamt2 calcAmount";
        resultFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        resultFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        resultFilter.and("period", "=", (Object)dataArgs.getPeriodId());
        resultFilter.and("entryentity2.type2", "=", (Object)"1");
        calcResultDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"sca_diffcalcresult", (String)reaultSelectFields, (QFilter[])resultFilter.toArray(), (String)"").filter("calcAmount!=0");
        resultDs = matDs.union(calcResultDs);
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("allocAmount").sum("calcAmount").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when allocAmount is null then 0.0 else allocAmount end allocAmount,case when calcAmount is null then 0.0 else calcAmount end calcAmount");
        compareDs = compareDs.filter("allocAmount-calcAmount!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u4e0e\u5dee\u5f02\u5206\u914d\u5355\uff08\u5b8c\u5de5\uff09\u91d1\u989d\u662f\u5426\u4e00\u81f4\u3002", (String)"DiffResultCheckTask_29", (String)"macc-sca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u4e0e\u5dee\u5f02\u5206\u914d\u5355\uff08\u5b8c\u5de5\uff09\u91d1\u989d\u5b58\u5728\u5dee\u5f02\u3002", (String)"DiffResultCheckTask_30", (String)"macc-sca-algox", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), start);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem, dataArgs);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010\u5dee\u5f02\u603b\u989d\u3011\u3010%1$s/%2$s\u3011\u4e0b\u9636\u5dee\u5f02\u2022\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u4e3a\u3010%3$s\u3011\uff0c\u5dee\u5f02\u5206\u914d\u5355\uff08\u5b8c\u5de5\uff09\u4e3a\u3010%4$s\u3011\uff0c\u5b58\u5728\u5dee\u5f02\u3002", (String)"DiffResultCheckTask_31", (String)"macc-sca-algox", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("calcAmount")), this.getBigDecimalStr(row.getBigDecimal("allocAmount")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    private int downDiffprePeriodAndCurPeriodCheck(DiffCheckArgs dataArgs, long start) {
        String sqlSelect = "0.0 as endamt,entryentity2.startactcostupamt2-entryentity2.startamt2 startamt";
        QFilter qFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        qFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        qFilter.and("entryentity2.type2", "=", (Object)"5");
        DataSet currDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)sqlSelect, (QFilter[])new QFilter[]{qFilter, new QFilter("period", "=", (Object)dataArgs.getPeriodId())}, null);
        sqlSelect = "entryentity2.endactcostupamt2-entryentity2.endamt2 as endamt,0.0 startamt";
        DataSet preDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)sqlSelect, (QFilter[])new QFilter[]{qFilter, new QFilter("period", "=", (Object)dataArgs.getPrePeriodId())}, null);
        DataSet resultDs = currDataSet.union(preDataSet);
        DataSet compareDs = resultDs.groupBy().sum("endamt").sum("startamt").finish();
        compareDs = compareDs.select("case when endamt is null then 0.0 else endamt end endamt,case when startamt is null then 0.0 else startamt end startamt");
        compareDs = compareDs.filter("startamt-endamt!=0");
        if (compareDs.isEmpty()) {
            logger.info("downDiffprePeriodAndCurPeriodCheck-nodiff");
            return 0;
        }
        logger.info("downDiffprePeriodAndCurPeriodCheck-hasdiff");
        compareDs.close();
        sqlSelect = "costcenter,costobject,entryentity2.subelement2 as subelement,0.0 as endamt,entryentity2.startactcostupamt2-entryentity2.startamt2 startamt";
        qFilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        qFilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        qFilter.and("entryentity2.type2", "=", (Object)"5");
        currDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)sqlSelect, (QFilter[])new QFilter[]{qFilter, new QFilter("period", "=", (Object)dataArgs.getPeriodId())}, null);
        sqlSelect = "costcenter,costobject,entryentity2.subelement2 as subelement,entryentity2.endactcostupamt2-entryentity2.endamt2 as endamt,0.0 startamt";
        preDataSet = QueryServiceHelper.queryDataSet((String)"loadSubElementMfgFeeal", (String)"sca_diffcalcresult", (String)sqlSelect, (QFilter[])new QFilter[]{qFilter, new QFilter("period", "=", (Object)dataArgs.getPrePeriodId())}, null);
        resultDs = currDataSet.union(preDataSet);
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("endamt").sum("startamt").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when endamt is null then 0.0 else endamt end endamt,case when startamt is null then 0.0 else startamt end startamt");
        compareDs = compareDs.filter("startamt-endamt!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u671f\u521d\u4e0b\u9636\u5dee\u5f02\u91d1\u989d\u4e0e\u4e0a\u671f\u671f\u672b\u662f\u5426\u4e00\u81f4", (String)"DiffResultCheckTask_32", (String)"macc-sca-algox", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u671f\u521d\u4e0b\u9636\u5dee\u5f02\u91d1\u989d\uff0c\u4e0e\u4e0a\u671f\u671f\u672b\u5b58\u5728\u5dee\u5f02", (String)"DiffResultCheckTask_33", (String)"macc-sca-algox", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), start);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem, dataArgs);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010%1$s/%2$s\u3011\u671f\u521d\u4e0b\u9636\u5dee\u5f02\u4e3a\u3010%3$s\u3011\uff0c\u4e0a\u671f\u671f\u672b\u4e0b\u9636\u5dee\u5f02\u4e3a\u3010%4$s\u3011\u5b58\u5728\u5dee\u5f02\u3002", (String)"DiffResultCheckTask_34", (String)"macc-sca-algox", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("startamt")), this.getBigDecimalStr(row.getBigDecimal("endamt")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    private String getBigDecimalStr(BigDecimal val) {
        if (val == null) {
            return "0";
        }
        return val.stripTrailingZeros().toPlainString();
    }

    private long getItemId(String curItem, String detail, long taskrecordId, long start) {
        DynamicObject record = BusinessDataServiceHelper.loadSingleFromCache((Object)taskrecordId, (String)"sca_taskrecord");
        DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
        long itemId = DB.genGlobalLongId();
        int seq = entrys.size() + 1;
        TaskRecordEntryRow recordRow = new TaskRecordEntryRow();
        recordRow.setEntryId(itemId);
        recordRow.setId(taskrecordId);
        recordRow.setSeq(seq);
        recordRow.setDetailConfig(itemId);
        recordRow.setSubName(curItem);
        recordRow.setSubStatus("3");
        recordRow.setSubStartIime(new Date());
        recordRow.setDetail(ResManager.loadKDString((String)"\u8be6\u60c5", (String)"DiffResultCheckTask_35", (String)"macc-sca-algox", (Object[])new Object[0]));
        if (!StringUtils.isEmpty((CharSequence)detail)) {
            recordRow.setSubParam(detail);
        }
        recordRow.setSubTime(System.currentTimeMillis() - start);
        SaveServiceHelper.save((IDataEntityType)OrmUtils.getDataEntityType(TaskRecordEntryRow.class), (Object[])new Object[]{recordRow});
        return itemId;
    }

    private DynamicObject createCheckDetailDyn(long itemId, String curItem, DiffCheckArgs dataArgs) {
        DynamicObject checkDetail = BusinessDataServiceHelper.newDynamicObject((String)"sca_checkreportdetail");
        checkDetail.set("id", (Object)itemId);
        checkDetail.set("org", (Object)dataArgs.getOrgId());
        checkDetail.set("costaccount", (Object)dataArgs.getCostaccountId());
        checkDetail.set("period", (Object)dataArgs.getPeriodId());
        checkDetail.set("currency", (Object)dataArgs.getCurrencyId());
        checkDetail.set("item", (Object)curItem);
        checkDetail.set("calcdate", (Object)TimeServiceHelper.now());
        return checkDetail;
    }

    private String tipSubStr(String tip) {
        return StringUtils.substring((String)tip, (int)0, (int)250);
    }

    private DataSet relaSubElementData(DataSet ds) {
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"cad_subelement", (String)"id, number subelementNo,name subelementName", null, (String)"");
        return ds.leftJoin(subElementDs).on("subelement", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"subelementNo", "subelementName"}).finish();
    }

    private int diffReportCheck(DiffCheckArgs dataArgs, long start) {
        QFilter filter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        filter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        filter.and("period", "=", (Object)dataArgs.getPeriodId());
        filter.and("biztype", "=", (Object)"00");
        DataSet downDs = QueryServiceHelper.queryDataSet((String)"diffalloc", (String)"sca_purchdiffalloc", (String)"becostobject.material.masterid material,entryentity.amount allamt,0.0 adjustamt", (QFilter[])filter.toArray(), null);
        QFilter fifilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        fifilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        fifilter.and("period", "=", (Object)dataArgs.getPeriodId());
        DataSet finishDs = QueryServiceHelper.queryDataSet((String)"finish", (String)"sca_finishdiffbill", (String)"costobject.material.masterid material,entryentity.amount allamt,0.0 adjustamt", (QFilter[])fifilter.toArray(), null);
        QFilter abfilter = new QFilter("org", "=", (Object)dataArgs.getOrgId());
        abfilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        abfilter.and("period", "=", (Object)dataArgs.getPeriodId());
        DataSet absoubDs = QueryServiceHelper.queryDataSet((String)"unabsorb", (String)"sca_unabsorbdiff", (String)"costobject.material.masterid material,entryentity.amount allamt,0.0 adjustamt", (QFilter[])abfilter.toArray(), null);
        QFilter adjustfilter = new QFilter("calorg", "=", (Object)dataArgs.getOrgId());
        adjustfilter.and("costaccount", "=", (Object)dataArgs.getCostaccountId());
        adjustfilter.and("bookdate", ">=", (Object)dataArgs.getStartDate());
        adjustfilter.and("bookdate", "<=", (Object)dataArgs.getEndDate());
        adjustfilter.and("biztype", "=", (Object)"A");
        adjustfilter.and("srcsys", "=", (Object)"B");
        adjustfilter.and("createtype", "in", (Object)Sets.newHashSet((Object[])new String[]{"W", "Y", "Z"}));
        DataSet adjustDs = QueryServiceHelper.queryDataSet((String)"adjuest", (String)"cal_stdcostdiffbill", (String)"entryentity.material.masterid material,0.0 allamt,entryentity.adjustamt adjustamt", (QFilter[])adjustfilter.toArray(), null);
        DataSet resultDs = downDs.union(new DataSet[]{finishDs, absoubDs, adjustDs});
        DataSet ds = resultDs.groupBy(new String[]{"material"}).sum("allamt").sum("adjustamt").finish();
        ds = ds.filter("allamt-adjustamt!=0");
        if (!ds.isEmpty()) {
            ds.close();
            String curItem = DiffReportItemEnum.getName(DiffReportItemEnum.CHECKCALCRESULT.getValue());
            String detail = ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u5bf9\u6570\u62a5\u8868\uff0c\u5b58\u5728\u5f02\u5e38\u6570\u636e\uff0c\u8bf7\u8054\u67e5\u5dee\u5f02\u5206\u644a\u5bf9\u6570\u62a5\u8868\u3002", (String)"DiffResultCheckTask_36", (String)"macc-sca-algox", (Object[])new Object[0]);
            this.getItemId(curItem, detail, dataArgs.getTaskRecordId(), start);
            return 1;
        }
        return 0;
    }
}

