/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.check;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.sca.algox.calc.input.CalcMaterial;
import kd.macc.sca.algox.restore.RestoreCheckerCommon;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public class RestoreNestMatCheck
extends AbstractSingleCalcCheckAction {
    private static final Log logger = LogFactory.getLog(RestoreNestMatCheck.class);

    public void doCheck() {
        CalcCheckContext context = this.getContext();
        Set calcMat = (Set)context.getParams().get("LegalCheckLvlMats");
        if (CadEmptyUtils.isEmpty(calcMat)) {
            return;
        }
        HashMap parentSubMaterialMap = Maps.newHashMapWithExpectedSize((int)16);
        for (CalcMaterial calcMaterial : calcMat) {
            if (calcMaterial.getParentId() <= 0L) continue;
            parentSubMaterialMap.computeIfAbsent(calcMaterial.getParentId(), t -> Lists.newArrayList()).add(calcMaterial);
        }
        HashMap<Long, Integer> materialLevelMap = new HashMap<Long, Integer>(512);
        ArrayList<CalcMaterial> nestMats = new ArrayList<CalcMaterial>();
        for (CalcMaterial rootMat : calcMat) {
            if (!parentSubMaterialMap.containsKey(rootMat.getMaterialId())) continue;
            rootMat.setPath("" + rootMat.getMaterialId());
            rootMat.setNumberPath(rootMat.getMaterialNumber());
            this.setPath(rootMat, parentSubMaterialMap, materialLevelMap, nestMats);
        }
        calcMat.clear();
        String checkDesc = ResManager.loadKDString((String)"\u7269\u6599\u5b58\u5728\u5d4c\u5957\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RestoreNestMatCheck_0", (String)"macc-sca-algox", (Object[])new Object[0]);
        RestoreCheckerCommon.dealNestMaterial(context, this.getSingleCheckContext(), nestMats);
        if (CadEmptyUtils.isEmpty(this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        this.getSingleCheckContext().setCheckResult(checkDesc);
        this.getSingleCheckContext().setPass(false);
    }

    private void setPath(CalcMaterial parentMat, Map<Long, List<CalcMaterial>> parentSubMaterialMap, Map<Long, Integer> materialLevelMap, List<CalcMaterial> nestMats) {
        List<CalcMaterial> materials = parentSubMaterialMap.get(parentMat.getMaterialId());
        if (materials == null) {
            return;
        }
        for (CalcMaterial curMat : materials) {
            parentMat.setIsleaf(false);
            long curMaterialId = curMat.getMaterialId();
            if (!materialLevelMap.containsKey(curMaterialId) || materialLevelMap.get(curMaterialId) < parentMat.getLevel() + 1) {
                materialLevelMap.remove(curMaterialId);
                materialLevelMap.put(curMaterialId, parentMat.getLevel() + 1);
                curMat.setLevel(parentMat.getLevel() + 1);
            } else {
                curMat.setLevel(materialLevelMap.get(curMaterialId));
            }
            if (parentMat.getPath().contains(curMat.getMaterialId() + "")) {
                curMat.setPath(parentMat.getPath() + "@" + curMat.getMaterialId());
                curMat.setNumberPath(parentMat.getNumberPath() + "@" + curMat.getMaterialNumber());
                CalcMaterial nestMat = new CalcMaterial();
                nestMat.setPath(parentMat.getPath() + "@" + curMat.getMaterialId());
                nestMat.setNumberPath(parentMat.getNumberPath() + "@" + curMat.getMaterialNumber());
                nestMats.add(nestMat);
                continue;
            }
            curMat.setPath(parentMat.getPath() + "@" + curMat.getMaterialId());
            curMat.setNumberPath(parentMat.getNumberPath() + "@" + curMat.getMaterialNumber());
            this.setPath(curMat, parentSubMaterialMap, materialLevelMap, nestMats);
        }
    }
}

