/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.ReadWhere;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.algox.enums.CalcReportResultEnum;
import kd.macc.sca.algox.restore.common.DiffCalcContext;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.TaskRecordEntryRow;
import kd.macc.sca.algox.restore.common.TaskRecordHeader;
import kd.macc.sca.algox.utils.CommonUtils;
import kd.macc.sca.algox.utils.TaskHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import org.apache.commons.lang3.StringUtils;

public class TaskRecorder {
    protected static final Log logger = LogFactory.getLog(TaskRecorder.class);
    private IDataEntityType recordHeadType;
    private IDataEntityType recordEntryType;
    private TaskRecordHeader taskRecord;

    public IDataEntityType getRecordHeadType() {
        if (this.recordHeadType == null) {
            this.recordHeadType = OrmUtils.getDataEntityType(TaskRecordHeader.class);
        }
        return this.recordHeadType;
    }

    public IDataEntityType getRecordEntryType() {
        if (this.recordEntryType == null) {
            this.recordEntryType = OrmUtils.getDataEntityType(TaskRecordEntryRow.class);
        }
        return this.recordEntryType;
    }

    public TaskRecordHeader getTaskRecord() {
        return this.taskRecord;
    }

    public TaskRecordHeader loadOrCreateTaskRecord(DiffCalcContext context) {
        Long id = context.getInputArgs().getTaskRecordId();
        if (id == null || Long.compare(0L, id) == 0) {
            id = DBServiceHelper.genGlobalLongId();
        } else {
            this.taskRecord = this.loadTaskRecord(id);
            if (this.taskRecord != null) {
                return this.taskRecord;
            }
        }
        this.taskRecord = this.createAndSaveTaskRecord(context, id);
        context.getInputArgs().setTaskRecordId(id);
        return this.taskRecord;
    }

    public void upateTaskRecord(int mProgess, String status) {
        if (this.taskRecord == null) {
            return;
        }
        int totalProgress = this.taskRecord.getProgress() + mProgess;
        logger.info(String.format("\u66f4\u65b0\u8fdb\u5ea6\uff1a %s + %s = %s", this.taskRecord.getProgress(), mProgess, totalProgress));
        if (mProgess >= 100) {
            this.taskRecord.setProgress(100);
        } else if (totalProgress >= 100) {
            this.taskRecord.setProgress(99);
        } else {
            this.taskRecord.setProgress(totalProgress);
        }
        this.taskRecord.setTime(TimeUtils.getSecond(this.taskRecord.getStartTime(), new Date()));
        this.taskRecord.setStatus(status);
        this.taskRecord.setDirtyFlag("Progress");
        this.taskRecord.setDirtyFlag("Time");
        this.taskRecord.setDirtyFlag("Status");
        try (TXHandle handle = TX.requiresNew();){
            BusinessDataWriter.update((IDataEntityType)this.getRecordHeadType(), (Object[])new Object[]{this.taskRecord});
        }
    }

    public void saveHeader() {
        if (this.taskRecord != null) {
            try (TXHandle handle = TX.requiresNew();){
                BusinessDataWriter.update((IDataEntityType)this.getRecordHeadType(), (Object[])new Object[]{this.taskRecord});
            }
        }
    }

    public void upateTaskRecordDetail(Long taskConfigDetailId, String status, int seq, String suffix) {
        try (TXHandle handle = TX.requiresNew();){
            DynamicObject record = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getTaskRecord().getId(), (String)"sca_taskrecord");
            if (record != null) {
                DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entrys) {
                    if (taskConfigDetailId.compareTo(entry.getLong("detailconfig")) != 0 || seq >= 0 && entry.getInt("seq") != seq) continue;
                    entry.set("substatus", (Object)status);
                    if (suffix != null && (entry.getString("subname") == null || entry.getString("subname").indexOf(suffix) == -1)) {
                        entry.set("subname", (Object)(entry.getString("subname") + suffix));
                    }
                    if ("2".equals(status) && entry.getDate("substarttime") == null) {
                        entry.set("substarttime", (Object)new Date());
                    }
                    if (!"4".equals(status) && !"7".equals(status)) continue;
                    long time = TimeUtils.getMilliSecond(entry.getDate("substarttime"), new Date());
                    entry.set("subtime", (Object)(time > 0L ? time : 0L));
                    entry.set("detail", (Object)"");
                }
                SaveServiceHelper.update((DynamicObject)record);
            }
        }
    }

    public void upateTaskRecordDetail(Long taskConfigDetailId, String status, int seq, String detail, String subParam, String subNextEntity) {
        this.upateTaskRecordDetail(taskConfigDetailId, status, seq, detail, subParam, subNextEntity, false);
    }

    public void upateTaskRecordDetail(Long taskConfigDetailId, String status, int seq, String detail, String subParam, String subNextEntity, boolean isTip) {
        DynamicObject record = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getTaskRecord().getId(), (String)"sca_taskrecord");
        if (record != null) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (taskConfigDetailId.compareTo(entry.getLong("detailconfig")) != 0 || seq >= 0 && entry.getInt("seq") != seq) continue;
                entry.set("substatus", (Object)status);
                if ("2".equals(status) && entry.getDate("substarttime") == null) {
                    entry.set("substarttime", (Object)new Date());
                }
                if ("4".equals(status) || "7".equals(status)) {
                    long time = TimeUtils.getMilliSecond(entry.getDate("substarttime"), new Date());
                    entry.set("subtime", (Object)(time > 0L ? time : 0L));
                }
                entry.set("detail", (Object)detail);
                String infoMsg = entry.getString("subparam_tag");
                infoMsg = infoMsg + subParam;
                String tip = "";
                if (isTip && subParam != null && subParam.length() > 0) {
                    tip = subParam.length() > 255 ? subParam.substring(0, 254) : subParam;
                }
                entry.set("subparam", (Object)tip);
                entry.set("subparam_tag", (Object)infoMsg);
                entry.set("subnextentity", (Object)subNextEntity);
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public void upateTaskRecordDetail(Long taskConfigDetailId, String status) {
        if (this.taskRecord == null || taskConfigDetailId == null) {
            return;
        }
        TaskRecordEntryRow recordEntryRow = this.taskRecord.getEntryRows().get(taskConfigDetailId);
        if (recordEntryRow == null) {
            return;
        }
        recordEntryRow.setSubStatus(status);
        recordEntryRow.setDirtyFlag("SubStatus");
        if ("2".equals(status)) {
            recordEntryRow.setSubStartIime(TimeServiceHelper.now());
            recordEntryRow.setDirtyFlag("SubStartIime");
        }
        if ("4".equals(status) || "7".equals(status)) {
            long oldTime = recordEntryRow.getSubTime();
            Long subTime = 0L;
            if (recordEntryRow.getSubStartIime() != null) {
                subTime = TimeUtils.getMilliSecond(recordEntryRow.getSubStartIime(), new Date());
            }
            recordEntryRow.setSubTime(subTime + oldTime);
            recordEntryRow.setDirtyFlag("SubTime");
        }
        try (TXHandle handle = TX.requiresNew();){
            BusinessDataWriter.update((IDataEntityType)this.getRecordEntryType(), (Object[])new Object[]{recordEntryRow});
        }
    }

    public long saveTaskRecordEntry(String item, Long taskDetailId, String status) {
        return this.saveTaskRecordEntry(item, taskDetailId, status, null);
    }

    public long saveTaskRecordEntry(String item, Long taskDetailId, String status, String bigtext) {
        return (Long)this.saveTaskRecordEntryRtEntryId((String)item, (Long)taskDetailId, (String)status, (String)bigtext).t2;
    }

    public Tuple2<Integer, Long> saveTaskRecordEntryRtEntryId(String item, Long taskDetailId, String status, String bigtext) {
        if (this.taskRecord == null) {
            return new Tuple2((Object)0, (Object)0L);
        }
        try (TXHandle handle = TX.requiresNew();){
            DynamicObject record = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getTaskRecord().getId(), (String)"sca_taskrecord");
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            int seq = entrys.size() + 1;
            long itemId = DBServiceHelper.genGlobalLongId();
            if (record != null) {
                TaskRecordEntryRow recordRow = new TaskRecordEntryRow();
                recordRow.setEntryId(itemId);
                recordRow.setId(this.getTaskRecord().getId());
                recordRow.setSeq(seq);
                recordRow.setDetailConfig(taskDetailId == 0L ? itemId : taskDetailId);
                recordRow.setSubName(item);
                recordRow.setSubStatus(status);
                recordRow.setSubStartIime(new Date());
                recordRow.setSubStatus("1");
                if (StringUtils.isNotEmpty((CharSequence)bigtext)) {
                    recordRow.setSubParam("");
                    recordRow.setSubParam_Tag(StringUtils.substring((String)bigtext, (int)0, (int)2000000));
                }
                this.getTaskRecord().getEntryRows().put(recordRow.getDetailConfig(), recordRow);
                SaveServiceHelper.save((IDataEntityType)this.getRecordEntryType(), (Object[])new Object[]{recordRow});
            }
            Tuple2 tuple2 = new Tuple2((Object)seq, (Object)itemId);
            return tuple2;
        }
    }

    public void upateTaskRecordDetailPara(Long taskConfigDetailId, String status, String detail, String nextPagePara) {
        this.upateTaskRecordDetailPara(taskConfigDetailId, status, detail, nextPagePara, null);
    }

    public void upateTaskRecordDetailPara(Long taskConfigDetailId, String status, String detail, String nextPagePara, String bigtext) {
        if (this.taskRecord == null || taskConfigDetailId == null) {
            return;
        }
        TaskRecordEntryRow recordEntryRow = this.taskRecord.getEntryRows().get(taskConfigDetailId);
        if (recordEntryRow == null) {
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)detail)) {
            recordEntryRow.setDetail(detail);
            recordEntryRow.setDirtyFlag("Detail");
        }
        if (!StringUtils.isEmpty((CharSequence)nextPagePara)) {
            recordEntryRow.setSubParam(nextPagePara);
            recordEntryRow.setDirtyFlag("SubParam");
        }
        if (StringUtils.isNotEmpty((CharSequence)bigtext)) {
            recordEntryRow.setSubParam("");
            recordEntryRow.setSubParam_Tag(StringUtils.substring((String)bigtext, (int)0, (int)2000000));
        }
        if (status != null) {
            recordEntryRow.setSubStatus(status);
            recordEntryRow.setDirtyFlag("SubStatus");
            if ("2".equals(status)) {
                recordEntryRow.setSubStartIime(TimeServiceHelper.now());
                recordEntryRow.setDirtyFlag("SubStartIime");
            }
            if ("4".equals(status) || "7".equals(status)) {
                long oldTime = recordEntryRow.getSubTime();
                Long subTime = 0L;
                if (recordEntryRow.getSubStartIime() != null) {
                    subTime = TimeUtils.getMilliSecond(recordEntryRow.getSubStartIime(), new Date());
                }
                recordEntryRow.setSubTime(subTime + oldTime);
                recordEntryRow.setDirtyFlag("SubTime");
            }
        }
        BusinessDataWriter.update((IDataEntityType)this.getRecordEntryType(), (Object[])new Object[]{recordEntryRow});
    }

    private TaskRecordHeader createAndSaveTaskRecord(DiffCalcContext context, Long taskRecordId) {
        DynamicObject taskConfig = context.getTaskConfig();
        if (taskConfig == null) {
            taskConfig = BusinessDataServiceHelper.loadSingle((Object)context.getTaskConfigId(), (String)"sca_taskconfig");
            context.setTaskConfig(taskConfig);
        }
        if (taskConfig == null) {
            return null;
        }
        TaskRecordHeader recordHeader = new TaskRecordHeader();
        Date startTime = TimeServiceHelper.now();
        recordHeader.setId(taskRecordId);
        recordHeader.setTaskName(taskConfig.getString("name"));
        recordHeader.setStartTime(startTime);
        recordHeader.setTime(0L);
        recordHeader.setStatus("2");
        recordHeader.setProgress(0);
        recordHeader.setExecutor(RequestContext.get().getCurrUserId());
        recordHeader.setNextPage(taskConfig.getString("nextentity"));
        recordHeader.setTaskConfig(context.getTaskConfigId());
        DynamicObjectCollection taskConfigEntrys = taskConfig.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject entry : taskConfigEntrys) {
            TaskRecordEntryRow recordRow = new TaskRecordEntryRow();
            recordRow.setEntryId(DBServiceHelper.genGlobalLongId());
            recordRow.setId(taskRecordId);
            recordRow.setSeq(seq);
            recordRow.setDetailConfig((Long)entry.getPkValue());
            recordRow.setSubName(entry.getString("subname"));
            recordRow.setSubNextEntity(entry.getString("subnextentity"));
            recordRow.setSubStatus("1");
            if (seq == 1) {
                recordRow.setSubStartIime(startTime);
            }
            recordHeader.getEntryRows().put(recordRow.getDetailConfig(), recordRow);
            ++seq;
        }
        SaveServiceHelper.save((IDataEntityType)this.getRecordHeadType(), (Object[])new Object[]{recordHeader});
        if (!recordHeader.getEntryRows().isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)this.getRecordEntryType(), (Object[])recordHeader.getEntryRows().values().toArray());
        }
        return recordHeader;
    }

    private TaskRecordHeader loadTaskRecord(Long taskRecordId) {
        Object[] entryObjs;
        Object[] recordObjs = BusinessDataServiceHelper.load((Object[])new Object[]{taskRecordId}, (IDataEntityType)this.getRecordHeadType());
        if (recordObjs == null || recordObjs.length == 0) {
            return null;
        }
        TaskRecordHeader recordHead = (TaskRecordHeader)recordObjs[0];
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)this.getRecordEntryType());
        dataManager.setSelectHeadOnly(true);
        ArrayList<SqlParameter> sqlParams = new ArrayList<SqlParameter>(1);
        sqlParams.add(new SqlParameter("fid", -5, (Object)taskRecordId));
        ReadWhere where = new ReadWhere("fid = ?", sqlParams);
        for (Object entryObj : entryObjs = dataManager.read(where)) {
            TaskRecordEntryRow entryRow = (TaskRecordEntryRow)entryObj;
            recordHead.getEntryRows().put(entryRow.getDetailConfig(), entryRow);
        }
        return recordHead;
    }

    public void upateTaskRecordHander(Long checkResultId, DiffCalcContext context) {
        if (CadEmptyUtils.isEmpty((Long)checkResultId)) {
            return;
        }
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingleFromCache((Object)checkResultId, (String)"sca_restore_calcreport");
        if (context.getCheckNoPassCount() > 0) {
            checkResult.set("type", (Object)CalcReportResultEnum.CALCREPORT_FAIL.getValue());
        } else if (context.getCheckRemaindCount() > 0) {
            checkResult.set("type", (Object)"5");
        } else {
            checkResult.set("type", (Object)CalcReportResultEnum.CALCREPORT_SUC.getValue());
        }
        long time = this.taskRecord.getTime();
        if (time <= 0L) {
            time = 1L;
        }
        checkResult.set("usetime", (Object)time);
        checkResult.set("progress", (Object)100);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
    }

    public void createCheckDetailHead(DiffCalcDataArgs inputArgs) {
        if (this.taskRecord == null) {
            return;
        }
        for (Map.Entry<Long, TaskRecordEntryRow> entry : this.taskRecord.getEntryRows().entrySet()) {
            boolean flag;
            if (FinshCalcCheck.CALCTASKCHECK.equals(entry.getKey()) || TaskHelper.PDENDENTRY_CHECK_TASKID.equals(entry.getKey()) || !(flag = this.createCheckDetailHead(entry.getValue().getEntryId(), inputArgs, entry.getValue().getSubName()))) continue;
            this.upateTaskRecordDetailPara(entry.getKey(), "3", ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b\u4e2d\u5b58\u5728\u9519\u8bef\u9879\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u3002", (String)"TaskRecorder_0", (String)"macc-sca-algox", (Object[])new Object[0]), null);
        }
    }

    private boolean createCheckDetailHead(Long taskDetailId, DiffCalcDataArgs inputArgs, String curItem) {
        if (this.isNeedGenerateBill(taskDetailId) && !QueryServiceHelper.exists((String)"sca_checkdetail", (Object)taskDetailId)) {
            DynamicObject checkDetail = this.createCheckDetailDyn(inputArgs, taskDetailId, curItem);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"sca_checkdetail");
            SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{checkDetail});
            return true;
        }
        return false;
    }

    public DynamicObject createCheckDetailDyn(DiffCalcDataArgs inputArgs, long itemId, String curItem) {
        DynamicObject checkDetail = BusinessDataServiceHelper.newDynamicObject((String)"sca_checkdetail");
        checkDetail.set("id", (Object)itemId);
        checkDetail.set("org", (Object)inputArgs.getOrgId());
        checkDetail.set("costaccount", (Object)inputArgs.getCostaccountId());
        checkDetail.set("period", (Object)inputArgs.getPeriodId());
        checkDetail.set("currency", (Object)inputArgs.getCurrencyId());
        checkDetail.set("checkitemdesc", (Object)String.format(ResManager.loadKDString((String)"%s-\u5b58\u5728\u9519\u8bef\u4fe1\u606f", (String)"TaskRecorder_1", (String)"macc-sca-algox", (Object[])new Object[0]), curItem));
        checkDetail.set("calcdate", (Object)TimeServiceHelper.now());
        return checkDetail;
    }

    private boolean isNeedGenerateBill(Long taskDetailId) {
        int size = 0;
        try (TXHandle handle = TX.requiresNew();){
            String strSql = "SELECT count(1) value FROM t_sca_checkdetailentry WHERE FId = " + taskDetailId;
            try (DataSet batSizeData = DB.queryDataSet((String)"TaskRecordGetEntrySize", (DBRoute)CommonUtils.getCalDBRouteKey(), (String)strSql);){
                if (batSizeData.hasNext()) {
                    Row row = batSizeData.next();
                    size = Integer.parseInt(row.get("value").toString());
                }
            }
        }
        return size > 0;
    }
}

