/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffAllocActAmtCalcFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private DiffCalcDataArgs args = null;
    private int batchSize = 8;

    public DiffAllocActAmtCalcFunction(DiffCalcDataArgs args, int batchSize) {
        this.args = args;
        this.batchSize = batchSize;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList listRows = Lists.newArrayList();
        BigDecimal startQty = BigDecimal.ZERO;
        BigDecimal currQty = BigDecimal.ZERO;
        BigDecimal compQty = BigDecimal.ZERO;
        BigDecimal endQty = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        RowX compRow = null;
        for (RowX row : iterable) {
            if ("5".equals(row.getString(this.sourceRowMeta.getFieldIndex("type")))) {
                BigDecimal curStartQty = this.getBigDecimalVal(row, "startqty");
                startQty = startQty.add(curStartQty);
                BigDecimal curCurrqty = this.getBigDecimalVal(row, "currqty");
                currQty = currQty.add(curCurrqty);
                BigDecimal curCompQty = this.getBigDecimalVal(row, "compqty");
                compQty = compQty.add(curCompQty);
                BigDecimal curEndQty = this.getBigDecimalVal(row, "endqty");
                endQty = endQty.add(curEndQty);
                BigDecimal curTotalQty = this.getBigDecimalVal(row, "totalqty");
                totalQty = totalQty.add(curTotalQty);
                if (compRow != null && curStartQty.compareTo(BigDecimal.ZERO) == 0 && curCurrqty.compareTo(BigDecimal.ZERO) == 0 && curCompQty.compareTo(BigDecimal.ZERO) == 0 && curEndQty.compareTo(BigDecimal.ZERO) == 0) continue;
                compRow = row;
                continue;
            }
            listRows.add(row);
        }
        if (listRows.isEmpty()) {
            return;
        }
        int batchGroupId = new SecureRandom().nextInt(this.batchSize);
        if (compRow == null) {
            compRow = ((RowX)listRows.get(0)).copy();
            compRow.set(this.sourceRowMeta.getFieldIndex("type"), (Object)"5");
            compRow.set(this.sourceRowMeta.getFieldIndex("startqty"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("currqty"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("compqty"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("endqty"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("totalqty"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("costelement"), (Object)this.args.getDefElementId());
            compRow.set(this.sourceRowMeta.getFieldIndex("costsubelement"), (Object)this.args.getDefSubElementId());
            listRows.add(compRow);
        } else {
            listRows.add(compRow);
        }
        this.dealSumRow(compRow, listRows);
        for (RowX row : listRows) {
            this.calcActAmt(row, "start", "actcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "amt");
            this.calcActAmt(row, "curr", "actcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "amt");
            this.calcActAmt(row, "comp", "actcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "amt");
            this.calcActAmt(row, "end", "actcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "amt");
            this.calcActAmt(row, "total", "actcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "amt");
            this.calcStdCost(row, "start", startQty);
            this.calcStdCost(row, "curr", currQty);
            this.calcStdCost(row, "comp", compQty);
            this.calcStdCost(row, "end", endQty);
            this.calcStdCost(row, "total", totalQty);
        }
        for (RowX row : listRows) {
            row.set(this.sourceRowMeta.getFieldIndex("batchgroupId"), (Object)batchGroupId);
            collector.collect(row);
        }
    }

    private void dealSumRow(RowX compRow, List<RowX> listRows) {
        int i = 0;
        for (RowX row : listRows) {
            if (row == compRow) continue;
            ++i;
        }
        if (i == 0) {
            return;
        }
        compRow.set(this.sourceRowMeta.getFieldIndex("startamt"), (Object)BigDecimal.ZERO);
        compRow.set(this.sourceRowMeta.getFieldIndex("curramt"), (Object)BigDecimal.ZERO);
        compRow.set(this.sourceRowMeta.getFieldIndex("compamt"), (Object)BigDecimal.ZERO);
        compRow.set(this.sourceRowMeta.getFieldIndex("endamt"), (Object)BigDecimal.ZERO);
        compRow.set(this.sourceRowMeta.getFieldIndex("totalamt"), (Object)BigDecimal.ZERO);
        for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
            compRow.set(this.sourceRowMeta.getFieldIndex("start" + field), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("curr" + field), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("comp" + field), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("end" + field), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("total" + field), (Object)BigDecimal.ZERO);
        }
        for (RowX row : listRows) {
            if (row == compRow) continue;
            this.addAmt(row, compRow, "startamt");
            this.addAmt(row, compRow, "curramt");
            this.addAmt(row, compRow, "compamt");
            this.addAmt(row, compRow, "endamt");
            this.addAmt(row, compRow, "totalamt");
            for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
                this.addAmt(row, compRow, "start" + field);
                this.addAmt(row, compRow, "curr" + field);
                this.addAmt(row, compRow, "comp" + field);
                this.addAmt(row, compRow, "end" + field);
                this.addAmt(row, compRow, "total" + field);
            }
        }
    }

    private void addAmt(RowX srcRow, RowX tarRow, String field) {
        int index = this.sourceRowMeta.getFieldIndex(field);
        BigDecimal srcamt = BigDecimalUtils.getBigDecimalOrZero(srcRow.getBigDecimal(index));
        BigDecimal taramt = BigDecimalUtils.getBigDecimalOrZero(tarRow.getBigDecimal(index));
        tarRow.set(index, (Object)taramt.add(srcamt));
    }

    private BigDecimal getBigDecimalVal(RowX rowx, String field) {
        return BigDecimalUtils.getBigDecimalOrZero(rowx.getBigDecimal(this.sourceRowMeta.getFieldIndex(field)));
    }

    private void calcStdCost(RowX row, String pre, BigDecimal qty) {
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal amt = this.getBigDecimalVal(row, pre + "amt");
        row.set(this.sourceRowMeta.getFieldIndex(pre + "stdcost"), (Object)amt.divide(qty, this.args.getPricePrecision(), RoundingMode.HALF_UP));
    }

    private void calcActAmt(RowX row, String pre, String targetfield, String[] diffFieldArr, String stAmtField) {
        BigDecimal stAmt = this.getBigDecimalVal(row, pre + stAmtField);
        for (String field : diffFieldArr) {
            stAmt = stAmt.add(this.getBigDecimalVal(row, pre + field));
        }
        row.set(this.sourceRowMeta.getFieldIndex(pre + targetfield), (Object)stAmt);
    }
}

