/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.costrec.DebugInfoMsgHandler;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;
import kd.macc.sca.common.helper.ProAllocStdHelper;

public class DiffAllocInCostCalcSumFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private DiffCalcDataArgs calcDataArgs;
    private Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap;
    private Map<String, String> diffProAllocStdMap;
    private Map<String, BigDecimal> equivalentMap;
    private DebugInfoMsgHandler msgHander = null;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public DiffAllocInCostCalcSumFunction(DiffCalcDataArgs args, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap, Map<String, String> diffProAllocStdMap, Map<String, BigDecimal> equivalentMap, DebugInfoMsgHandler msgHander) {
        this.calcDataArgs = args;
        this.mainJoinSideCostObjectInfoMap = mainJoinSideCostObjectInfoMap;
        this.diffProAllocStdMap = diffProAllocStdMap;
        this.equivalentMap = equivalentMap;
        this.msgHander = msgHander;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList rows = Lists.newArrayList();
        for (RowX row : iterable) {
            rows.add(row);
        }
        if (rows.isEmpty()) {
            return;
        }
        boolean isCostobjectDebug = false;
        StringBuilder debugMsg = null;
        Long costobjectId = ((RowX)rows.get(0)).getLong(this.sourceRowMeta.getFieldIndex("costobject"));
        Long costcenterId = ((RowX)rows.get(0)).getLong(this.sourceRowMeta.getFieldIndex("costcenter"));
        Long manuOrgId = ((RowX)rows.get(0)).getLong(this.sourceRowMeta.getFieldIndex("manuorg"));
        Long subelementId = ((RowX)rows.get(0)).getLong(this.sourceRowMeta.getFieldIndex("subelement"));
        if (CadEmptyUtils.isEmpty((Long)subelementId)) {
            for (RowX row : rows) {
                row.set(this.sourceRowMeta.getFieldIndex("subelement"), (Object)this.calcDataArgs.getDefSubElementId());
            }
            subelementId = this.calcDataArgs.getDefSubElementId();
        }
        if (isCostobjectDebug = DiffCalcHelper.isCostobjectDebug(this.calcDataArgs, costobjectId)) {
            debugMsg = new StringBuilder();
            debugMsg.append(String.format(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u8ba1\u7b97\uff1a\u7269\u6599=%1$s\uff0c\u5b50\u8981\u7d20=%2$s", (String)"DiffAllocInCostCalcSumFunction_0", (String)"macc-sca-algox", (Object[])new Object[0]), ((RowX)rows.get(0)).getLong(this.sourceRowMeta.getFieldIndex("material")), subelementId)).append("\n");
        }
        if (!this.mainJoinSideCostObjectInfoMap.containsKey(costobjectId)) {
            DiffCalcHelper.insertCalcErrorInfo(this.calcDataArgs.getTaskEntryId(), costcenterId, ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5bf9\u5e94\u7684\u6210\u672c\u5bf9\u8c61\u5b9e\u4f53\u3002", (String)"DiffAllocInCostCalcSumFunction_1", (String)"macc-sca-algox", (Object[])new Object[0]));
            return;
        }
        Map<Long, CalcResultObjectInfo> costOjbectInfoMap = this.mainJoinSideCostObjectInfoMap.get(costobjectId);
        CalcResultObjectInfo costObjectInfo = costOjbectInfoMap.get(costobjectId);
        if (costObjectInfo == null) {
            DiffCalcHelper.insertCalcErrorInfo(this.calcDataArgs.getTaskEntryId(), costcenterId, ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5bf9\u5e94\u7684\u6210\u672c\u5bf9\u8c61\u5b9e\u4f53\u3002", (String)"DiffAllocInCostCalcSumFunction_1", (String)"macc-sca-algox", (Object[])new Object[0]));
            return;
        }
        for (RowX row : rows) {
            if (CadEmptyUtils.isEmpty((Long)row.getLong(this.sourceRowMeta.getFieldIndex("costsubelement")))) {
                this.map(row, "qty", manuOrgId, costcenterId, costobjectId, subelementId, costOjbectInfoMap, costObjectInfo, isCostobjectDebug, debugMsg);
                this.map(row, "amt", manuOrgId, costcenterId, costobjectId, subelementId, costOjbectInfoMap, costObjectInfo, isCostobjectDebug, debugMsg);
                continue;
            }
            for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
                this.map(row, field, manuOrgId, costcenterId, costobjectId, subelementId, costOjbectInfoMap, costObjectInfo, isCostobjectDebug, debugMsg);
            }
        }
        if (isCostobjectDebug) {
            this.msgHander.dealInfoMsg(debugMsg.toString());
        }
        for (RowX row : rows) {
            collector.collect(row);
        }
    }

    public RowX map(RowX rowX, String field, Long manoOrgId, Long costcenterId, Long costobjectId, Long subelementId, Map<Long, CalcResultObjectInfo> costOjbectInfoMap, CalcResultObjectInfo costObjectInfo, boolean isCostobjectDebug, StringBuilder debugMsg) {
        BigDecimal curadjustamt;
        BigDecimal comadjustamt = BigDecimal.ZERO;
        BigDecimal endadjustamt = BigDecimal.ZERO;
        BigDecimal startadjustamt = BigDecimalUtils.getBigDecimalOrZero(rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("start" + field)));
        BigDecimal curCalcAmt = startadjustamt.add(curadjustamt = BigDecimalUtils.getBigDecimalOrZero(rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("curr" + field))));
        if (curCalcAmt.compareTo(BigDecimal.ZERO) == 0) {
            return rowX;
        }
        Integer precision = this.getPrecision(rowX, field);
        if ("B".equals(costObjectInfo.getBizStatus())) {
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u72b6\u6001\u4e3a\u5df2\u7ed3\u7b97\uff0c\u5b8c\u5de5=\u671f\u521d+\u6295\u5165=", (String)"DiffAllocInCostCalcSumFunction_2", (String)"macc-sca-algox", (Object[])new Object[0]));
                debugMsg.append(curCalcAmt).append("\n");
            }
            comadjustamt = curCalcAmt;
            return this.setAllocAmt(rowX, field, comadjustamt, endadjustamt);
        }
        if (!ScaCalcHelper.isHasMainJoinFacted(costOjbectInfoMap)) {
            endadjustamt = curCalcAmt;
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5b8c\u5de5\uff0c\u671f\u672b=\u671f\u521d+\u6295\u5165=", (String)"DiffAllocInCostCalcSumFunction_3", (String)"macc-sca-algox", (Object[])new Object[0]));
                debugMsg.append(curCalcAmt).append("\n");
            }
            return this.setAllocAmt(rowX, field, comadjustamt, endadjustamt);
        }
        if (ScaCalcHelper.isMainJoinAllFacted(costOjbectInfoMap)) {
            comadjustamt = curCalcAmt;
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append(ResManager.loadKDString((String)"\u4e3b\u8054\u5168\u90e8\u5b8c\u5de5\uff0c\u5b8c\u5de5=\u671f\u521d+\u6295\u5165=", (String)"DiffAllocInCostCalcSumFunction_4", (String)"macc-sca-algox", (Object[])new Object[0]));
                debugMsg.append(curCalcAmt).append("\n");
            }
            return this.setAllocAmt(rowX, field, comadjustamt, endadjustamt);
        }
        String allocStd = ProAllocStdHelper.getProAllocStd(this.diffProAllocStdMap, (long)this.calcDataArgs.getCostaccountId(), (long)costcenterId, (long)subelementId);
        if (StringUtils.isEmpty((String)allocStd)) {
            DiffCalcHelper.insertCalcErrorInfo(this.calcDataArgs.getTaskEntryId(), costcenterId, ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5dee\u5f02\u5206\u644a\u5206\u914d\u6807\u51c6\u3002", (String)"DiffAllocInCostCalcSumFunction_5", (String)"macc-sca-algox", (Object[])new Object[0]));
            return rowX;
        }
        if (isCostobjectDebug && debugMsg != null) {
            debugMsg.append(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u5206\u914d\u6807\u51c6\uff1a", (String)"DiffAllocInCostCalcSumFunction_6", (String)"macc-sca-algox", (Object[])new Object[0]));
            debugMsg.append(allocStd).append("\n");
        }
        if ("0".equals(allocStd)) {
            comadjustamt = curCalcAmt;
        } else if ("5".equals(allocStd)) {
            comadjustamt = BigDecimal.ZERO;
        } else if ("2".equals(allocStd) || "1".equals(allocStd)) {
            BigDecimal tmpA;
            BigDecimal equivalent = BigDecimal.ONE;
            if ("2".equals(allocStd)) {
                equivalent = ScaCalcHelper.getCostobjectEquivalent(this.equivalentMap, this.calcDataArgs.getCostaccountId(), manoOrgId, costcenterId, costobjectId, subelementId);
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u7ea6\u5f53\u7cfb\u6570\uff1a", (String)"DiffAllocInCostCalcSumFunction_7", (String)"macc-sca-algox", (Object[])new Object[0]));
                    debugMsg.append(equivalent).append("\n");
                }
                if (equivalent == null) {
                    DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costobjectId, (String)"cad_costobject", (String)"costcenter,name");
                    DiffCalcHelper.insertCalcErrorInfo(this.calcDataArgs.getTaskEntryId(), costcenterId, String.format(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6210\u672c\u5bf9\u8c61\u3010%s\u3011\u5bf9\u5e94\u7684\u7ea6\u5f53\u7cfb\u6570\u3002", (String)"DiffAllocInCostCalcSumFunction_8", (String)"macc-sca-algox", (Object[])new Object[0]), costObjectDyo == null ? "" : costObjectDyo.getString("name")));
                    return rowX;
                }
            }
            BigDecimal proFinQty = ScaCalcHelper.getMainAndJoinProFinQty(costOjbectInfoMap);
            BigDecimal proIntrQty = ScaCalcHelper.getMainAndJoinProEndQty(costOjbectInfoMap);
            if (ScaCalcHelper.isContainsJoinProduct(costOjbectInfoMap)) {
                proFinQty = BigDecimal.ZERO;
                proIntrQty = BigDecimal.ZERO;
                for (Map.Entry<Long, CalcResultObjectInfo> entry : costOjbectInfoMap.entrySet()) {
                    if ("B".equals(entry.getValue().getProductType())) continue;
                    CalcResultObjectInfo costobjectInfo = entry.getValue();
                    proFinQty = proFinQty.add(costobjectInfo.getFinishQty().multiply(costobjectInfo.getWeight()));
                    proIntrQty = proIntrQty.add(costobjectInfo.getEndQty().multiply(costobjectInfo.getWeight()));
                }
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append(ResManager.loadKDString((String)"\u4e3b\u8054\u5b8c\u5de5\u6570\u91cf\uff1a", (String)"DiffAllocInCostCalcSumFunction_9", (String)"macc-sca-algox", (Object[])new Object[0]));
                    debugMsg.append(proFinQty).append("\n");
                    debugMsg.append(ResManager.loadKDString((String)"\u4e3b\u8054\u671f\u672b\u5728\u4ea7\u6570\u91cf\uff1a", (String)"DiffAllocInCostCalcSumFunction_10", (String)"macc-sca-algox", (Object[])new Object[0]));
                    debugMsg.append(proFinQty).append("\n");
                }
            }
            if ((tmpA = proIntrQty.multiply(equivalent).add(proFinQty)).compareTo(BigDecimal.ZERO) == 0) {
                DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costobjectId, (String)"cad_costobject", (String)"costcenter,name");
                DynamicObject subElementDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)subelementId, (String)"cad_subelement", (String)"name");
                DiffCalcHelper.insertCalcErrorInfo(this.calcDataArgs.getTaskEntryId(), costcenterId, String.format(ResManager.loadKDString((String)" \u6210\u672c\u6838\u7b97\u5bf9\u8c61 \uff1a\u3010%1$s\u3011\uff0c \u5b50\u8981\u7d20\uff1a\u3010%2$s\u3011\uff0c\u671f\u672b\u5728\u4ea7\u54c1\u6570\u91cf*\u7ea6\u5f53\u7cfb\u6570+\u5b8c\u5de5\u5165\u5e93\u6570\u91cf=0\u3002", (String)"DiffAllocInCostCalcSumFunction_11", (String)"macc-sca-algox", (Object[])new Object[0]), costObjectDyo == null ? "" : costObjectDyo.getString("name"), subElementDyo == null ? "" : subElementDyo.getString("name")));
                return rowX;
            }
            BigDecimal ratio = proFinQty.divide(tmpA, 10, 4);
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append(ResManager.loadKDString((String)"\u5b8c\u5de5\u6bd4\u4f8b\uff1a", (String)"DiffAllocInCostCalcSumFunction_12", (String)"macc-sca-algox", (Object[])new Object[0]));
                debugMsg.append(ratio).append("\n");
            }
            comadjustamt = curCalcAmt.multiply(ratio).setScale((int)precision, 4);
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append(ResManager.loadKDString((String)"\u5b8c\u5de5\u91d1\u989d\uff1a", (String)"DiffAllocInCostCalcSumFunction_13", (String)"macc-sca-algox", (Object[])new Object[0]));
                debugMsg.append(comadjustamt).append("\n");
            }
        }
        endadjustamt = curCalcAmt.subtract(comadjustamt);
        return this.setAllocAmt(rowX, field, comadjustamt, endadjustamt);
    }

    private RowX setAllocAmt(RowX rowx, String field, BigDecimal comadjustamt, BigDecimal endadjustamt) {
        rowx.set(this.sourceRowMeta.getFieldIndex("comp" + field), (Object)comadjustamt);
        rowx.set(this.sourceRowMeta.getFieldIndex("end" + field), (Object)endadjustamt);
        return rowx;
    }

    private Integer getPrecision(RowX row, String field) {
        Integer precision = this.calcDataArgs.getAmtPrecision();
        if ("qty".equals(field) && (precision = row.getInteger(this.sourceRowMeta.getFieldIndex("precision"))) == null) {
            precision = 0;
        }
        return precision;
    }
}

