/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;

public class DiffAllocMainJoinAllocSumFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap = null;
    private DiffCalcDataArgs calcDataArgs;

    public DiffAllocMainJoinAllocSumFunction(DiffCalcDataArgs args, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap) {
        this.mainJoinSideCostObjectInfoMap = mainJoinSideCostObjectInfoMap;
        this.calcDataArgs = args;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList mainRows = Lists.newArrayList();
        for (RowX rowX : iterable) {
            mainRows.add(rowX);
        }
        if (mainRows.isEmpty()) {
            return;
        }
        Long costObjectId = ((RowX)mainRows.get(0)).getLong(this.sourceRowMeta.getFieldIndex("costobject"));
        if (!this.mainJoinSideCostObjectInfoMap.containsKey(costObjectId)) {
            return;
        }
        for (Object rowx : mainRows) {
            rowx.set(this.sourceRowMeta.getFieldIndex("relacostobject"), (Object)costObjectId);
            rowx.set(this.sourceRowMeta.getFieldIndex("relaproducttype"), (Object)"C");
        }
        Map<Long, CalcResultObjectInfo> map = this.mainJoinSideCostObjectInfoMap.get(costObjectId);
        if (map.size() == 1 || !ScaCalcHelper.isHasMainJoinFacted(map)) {
            for (RowX row : mainRows) {
                collector.collect(row);
            }
            return;
        }
        List<RowX> joinRows = this.calcMainJoinProductCost(mainRows, costObjectId, map);
        for (RowX row : mainRows) {
            collector.collect(row);
        }
        for (RowX row : joinRows) {
            collector.collect(row);
        }
    }

    private List<RowX> calcMainJoinProductCost(List<RowX> mainRows, Long mainCostObjectId, Map<Long, CalcResultObjectInfo> resultVoMaps) {
        ArrayList joinRows = Lists.newArrayList();
        if (!ScaCalcHelper.isContainsProductFacted(resultVoMaps, "A")) {
            return joinRows;
        }
        BigDecimal totalMuilt = this.getTotalMuilt(resultVoMaps);
        Long materialId = mainRows.get(0).getLong(this.sourceRowMeta.getFieldIndex("material"));
        if (totalMuilt.compareTo(BigDecimal.ZERO) == 0) {
            DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)mainCostObjectId, (String)"cad_costobject", (String)"costcenter,name,srcbillnumber");
            DynamicObject materialDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"name");
            String mftNo = costObjectDyo != null ? costObjectDyo.getString("srcbillnumber") : "";
            String costobjectName = costObjectDyo != null ? costObjectDyo.getString("name") : "";
            String materialName = materialDyo != null ? materialDyo.getString("name") : "";
            String errStr = String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u4ea7\u54c1\u5b8c\u5de5\u6bd4\u4f8b\u5206\u914d\u5931\u8d25\uff0c\u3010\u2211\u4e3b\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd+\u2211\u8054\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd=0\u3011\uff0c\u5de5\u5355\u7f16\u53f7\u3010%1$s\u3011\uff0c\u6210\u672c\u5bf9\u8c61\u3010%2$s\u3011\uff0c\u7269\u6599\u3010%3$s\u3011\u3002", (String)"DiffAllocMainJoinAllocSumFunction_0", (String)"macc-sca-algox", (Object[])new Object[0]), mftNo, costobjectName, materialName);
            DiffCalcHelper.insertCalcErrorInfo(this.calcDataArgs.getTaskEntryId(), costObjectDyo != null ? costObjectDyo.getLong("costcenter.id") : 0L, errStr);
            return joinRows;
        }
        HashMap costobjectRowMap = Maps.newHashMapWithExpectedSize((int)10);
        for (RowX mainRow : mainRows) {
            if (CadEmptyUtils.isEmpty((Long)mainRow.getLong(this.sourceRowMeta.getFieldIndex("costsubelement")))) {
                this.mainjoinAlloc(mainRow, "qty", resultVoMaps, costobjectRowMap, totalMuilt);
                this.mainjoinAlloc(mainRow, "amt", resultVoMaps, costobjectRowMap, totalMuilt);
                continue;
            }
            for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
                this.mainjoinAlloc(mainRow, field, resultVoMaps, costobjectRowMap, totalMuilt);
            }
        }
        joinRows.addAll(costobjectRowMap.values());
        return joinRows;
    }

    private void mainjoinAlloc(RowX mainRow, String field, Map<Long, CalcResultObjectInfo> resultVoMaps, Map<String, RowX> costobjectRowMap, BigDecimal totalMuilt) {
        BigDecimal mainJoinFinAmt;
        int comadjustamtIndex = this.sourceRowMeta.getFieldIndex("comp" + field);
        Long costsubelementId = mainRow.getLong(this.sourceRowMeta.getFieldIndex("costsubelement"));
        BigDecimal comadjustamt = BigDecimalUtils.getBigDecimalOrZero(mainRow.getBigDecimal(comadjustamtIndex));
        if (BigDecimal.ZERO.compareTo(comadjustamt) == 0) {
            return;
        }
        BigDecimal diffFinAmt = mainJoinFinAmt = BigDecimalUtils.getBigDecimalOrZero(mainRow.getBigDecimal(comadjustamtIndex));
        RowX allocMaxRow = null;
        boolean isContainMainFact = false;
        boolean isContainJoinFact = false;
        for (Map.Entry<Long, CalcResultObjectInfo> entry : resultVoMaps.entrySet()) {
            CalcResultObjectInfo costobjectInfo;
            if ("B".equals(entry.getValue().getProductType()) || BigDecimal.ZERO.compareTo((costobjectInfo = entry.getValue()).getFinishQty()) == 0) continue;
            BigDecimal qty = costobjectInfo.getFinishQty();
            BigDecimal weight = costobjectInfo.getWeight();
            BigDecimal multi = qty.multiply(weight);
            BigDecimal radio = BigDecimal.ZERO;
            if (totalMuilt.compareTo(BigDecimal.ZERO) != 0) {
                radio = multi.divide(totalMuilt, 10, RoundingMode.HALF_UP);
            }
            BigDecimal allocAmt = radio.multiply(mainJoinFinAmt).setScale(this.calcDataArgs.getAmtPrecision(), RoundingMode.HALF_UP);
            diffFinAmt = diffFinAmt.subtract(allocAmt);
            if ("C".equals(entry.getValue().getProductType())) {
                mainRow.set(comadjustamtIndex, (Object)allocAmt);
                if (allocMaxRow == null || allocMaxRow.getBigDecimal(comadjustamtIndex).compareTo(allocAmt) < 0) {
                    allocMaxRow = mainRow;
                }
                isContainMainFact = true;
                continue;
            }
            RowX joinRow = this.getProductRow(mainRow, costobjectRowMap, costobjectInfo.getCostObjectId(), costsubelementId);
            joinRow.set(comadjustamtIndex, (Object)allocAmt);
            if (allocMaxRow == null || allocMaxRow.getBigDecimal(comadjustamtIndex).compareTo(allocAmt) < 0) {
                allocMaxRow = joinRow;
            }
            isContainJoinFact = true;
        }
        if (diffFinAmt.compareTo(BigDecimal.ZERO) != 0 && allocMaxRow != null) {
            allocMaxRow.set(comadjustamtIndex, (Object)allocMaxRow.getBigDecimal(comadjustamtIndex).add(diffFinAmt));
        }
        if (!isContainMainFact && isContainJoinFact) {
            mainRow.set(comadjustamtIndex, (Object)BigDecimal.ZERO);
        }
    }

    private RowX getProductRow(RowX baseRow, Map<String, RowX> costobjectRowMap, Long costobjectId, Long subelementId) {
        String[] stdArr;
        String key = String.format("%s@%s", costobjectId, subelementId);
        if (costobjectRowMap.containsKey(key)) {
            return costobjectRowMap.get(key);
        }
        RowX newRow = baseRow.copy();
        for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
            newRow.set(this.sourceRowMeta.getFieldIndex("start" + field), (Object)BigDecimal.ZERO);
            newRow.set(this.sourceRowMeta.getFieldIndex("curr" + field), (Object)BigDecimal.ZERO);
            newRow.set(this.sourceRowMeta.getFieldIndex("comp" + field), (Object)BigDecimal.ZERO);
            newRow.set(this.sourceRowMeta.getFieldIndex("end" + field), (Object)BigDecimal.ZERO);
        }
        for (String field : stdArr = new String[]{"qty", "amt"}) {
            newRow.set(this.sourceRowMeta.getFieldIndex("start" + field), (Object)BigDecimal.ZERO);
            newRow.set(this.sourceRowMeta.getFieldIndex("curr" + field), (Object)BigDecimal.ZERO);
            newRow.set(this.sourceRowMeta.getFieldIndex("comp" + field), (Object)BigDecimal.ZERO);
            newRow.set(this.sourceRowMeta.getFieldIndex("end" + field), (Object)BigDecimal.ZERO);
        }
        newRow.set(this.sourceRowMeta.getFieldIndex("relacostobject"), (Object)costobjectId);
        newRow.set(this.sourceRowMeta.getFieldIndex("relaproducttype"), (Object)"A");
        costobjectRowMap.put(key, newRow);
        return newRow;
    }

    private BigDecimal getTotalMuilt(Map<Long, CalcResultObjectInfo> resultVoMaps) {
        BigDecimal totalMuilt = BigDecimal.ZERO;
        BigDecimal maxMuilt = null;
        for (Map.Entry<Long, CalcResultObjectInfo> entry : resultVoMaps.entrySet()) {
            BigDecimal qty;
            if ("B".equals(entry.getValue().getProductType()) || (qty = entry.getValue().getFinishQty()).compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal weight = entry.getValue().getWeight();
            BigDecimal multi = qty.multiply(weight);
            totalMuilt = totalMuilt.add(multi);
            if (maxMuilt != null && maxMuilt.compareTo(multi.abs()) >= 0) continue;
            maxMuilt = multi.abs();
        }
        if (totalMuilt.compareTo(BigDecimal.ZERO) == 0 && maxMuilt != null) {
            totalMuilt = maxMuilt;
        }
        return totalMuilt;
    }
}

