/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffAllocPubMatAllocFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private DiffCalcDataArgs calcDataArgs = null;

    public DiffAllocPubMatAllocFunction(DiffCalcDataArgs calcDataArgs) {
        this.calcDataArgs = calcDataArgs;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector col) {
        ArrayList listRows = Lists.newArrayList();
        for (RowX row : iterable) {
            listRows.add(row);
        }
        if (listRows.isEmpty()) {
            return;
        }
        if (listRows.size() == 1) {
            col.collect((RowX)listRows.get(0));
            return;
        }
        for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
            this.diffAmtAlloc(listRows, "curr" + field);
        }
        for (RowX row : listRows) {
            col.collect(row);
        }
    }

    private void diffAmtAlloc(List<RowX> listRows, String field) {
        int subAdjustAmtIndex = this.sourceRowMeta.getFieldIndex(field);
        BigDecimal totalQty = BigDecimalUtils.getBigDecimalOrZero(listRows.get(0).getBigDecimal(this.sourceRowMeta.getFieldIndex("totalqty")));
        BigDecimal totalAmt = BigDecimalUtils.getBigDecimalOrZero(listRows.get(0).getBigDecimal(subAdjustAmtIndex));
        if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal unitAmt = BigDecimal.ZERO;
        if (totalQty.compareTo(BigDecimal.ZERO) != 0) {
            unitAmt = totalAmt.divide(totalQty, this.calcDataArgs.getPricePrecision(), 4);
        }
        BigDecimal diffAmt = totalAmt;
        RowX maxRow = null;
        BigDecimal maxQty = BigDecimal.ZERO;
        for (RowX row : listRows) {
            BigDecimal qty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("qty")));
            if (maxRow == null || maxQty.compareTo(qty) < 0) {
                maxQty = qty;
                maxRow = row;
            }
            BigDecimal allocAmt = unitAmt.multiply(qty).setScale(this.calcDataArgs.getAmtPrecision(), 4);
            row.set(subAdjustAmtIndex, (Object)allocAmt);
            diffAmt = diffAmt.subtract(allocAmt);
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0 && maxRow != null) {
            maxRow.set(subAdjustAmtIndex, (Object)maxRow.getBigDecimal(subAdjustAmtIndex).add(diffAmt));
        }
    }
}

