/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffCalcResultCalcFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private int batchSize = 8;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public DiffCalcResultCalcFunction(int batchSize) {
        this.batchSize = batchSize;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashMap sumRowMap = Maps.newHashMapWithExpectedSize((int)10);
        ArrayList rows = Lists.newArrayList();
        Long costobjectId = null;
        for (RowX row : iterable) {
            if (costobjectId == null) {
                costobjectId = row.getLong(this.sourceRowMeta.getFieldIndex("costobject"));
            }
            if ("5".equals(row.getString(this.sourceRowMeta.getFieldIndex("type")))) {
                Long relacostobject = row.getLong(this.sourceRowMeta.getFieldIndex("relacostobject"));
                sumRowMap.put(relacostobject, row);
                continue;
            }
            rows.add(row);
        }
        for (RowX rowX : sumRowMap.values()) {
            rowX.set(this.getSourceRowMeta().getFieldIndex("startamt"), (Object)BigDecimal.ZERO);
            rowX.set(this.getSourceRowMeta().getFieldIndex("curramt"), (Object)BigDecimal.ZERO);
            rowX.set(this.getSourceRowMeta().getFieldIndex("compamt"), (Object)BigDecimal.ZERO);
            rowX.set(this.getSourceRowMeta().getFieldIndex("endamt"), (Object)BigDecimal.ZERO);
            rowX.set(this.getSourceRowMeta().getFieldIndex("totalamt"), (Object)BigDecimal.ZERO);
        }
        int batchGroupId = new SecureRandom().nextInt(this.batchSize);
        for (RowX row : rows) {
            for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
                this.addBigDecimal(row, "total" + field, "comp" + field);
            }
            this.calcActAmt(row, "start", "startactcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "startamt");
            this.calcActAmt(row, "curr", "curractcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "curramt");
            this.calcActAmt(row, "comp", "compactcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "compamt");
            this.calcActAmt(row, "end", "endactcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "endamt");
            this.calcActAmt(row, "total", "totalactcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "totalamt");
            Long relacostobject = row.getLong(this.sourceRowMeta.getFieldIndex("relacostobject"));
            if (!sumRowMap.containsKey(relacostobject)) {
                sumRowMap.put(relacostobject, this.generateSumRow((RowX)rows.get(0), costobjectId, relacostobject));
            }
            this.sumDiffAmt((RowX)sumRowMap.get(relacostobject), row, "start", DiffCalcHelper.DIFF_FIELD_ARR);
            this.sumDiffAmt((RowX)sumRowMap.get(relacostobject), row, "curr", DiffCalcHelper.DIFF_FIELD_ARR);
            this.sumDiffAmt((RowX)sumRowMap.get(relacostobject), row, "comp", DiffCalcHelper.DIFF_FIELD_ARR);
            this.sumDiffAmt((RowX)sumRowMap.get(relacostobject), row, "end", DiffCalcHelper.DIFF_FIELD_ARR);
            this.sumDiffAmt((RowX)sumRowMap.get(relacostobject), row, "total", DiffCalcHelper.DIFF_FIELD_ARR);
            this.sumDiffAmt((RowX)sumRowMap.get(relacostobject), row, "start", new String[]{"amt"});
            this.sumDiffAmt((RowX)sumRowMap.get(relacostobject), row, "curr", new String[]{"amt"});
            this.sumDiffAmt((RowX)sumRowMap.get(relacostobject), row, "comp", new String[]{"amt"});
            this.sumDiffAmt((RowX)sumRowMap.get(relacostobject), row, "end", new String[]{"amt"});
            this.sumDiffAmt((RowX)sumRowMap.get(relacostobject), row, "total", new String[]{"amt"});
        }
        for (RowX sumRow : sumRowMap.values()) {
            this.calcActAmt(sumRow, "start", "startactcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "startamt");
            this.calcActAmt(sumRow, "curr", "curractcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "curramt");
            this.calcActAmt(sumRow, "comp", "compactcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "compamt");
            this.calcActAmt(sumRow, "end", "endactcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "endamt");
            this.calcActAmt(sumRow, "total", "totalactcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "totalamt");
        }
        for (RowX row : rows) {
            row.set(this.sourceRowMeta.getFieldIndex("batchgroupId"), (Object)batchGroupId);
            collector.collect(row);
        }
        for (RowX sumRow : sumRowMap.values()) {
            sumRow.set(this.sourceRowMeta.getFieldIndex("batchgroupId"), (Object)batchGroupId);
            collector.collect(sumRow);
        }
    }

    private void addBigDecimal(RowX row, String targetfield, String srcfield) {
        BigDecimal val = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex(targetfield)));
        BigDecimal curVal = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex(srcfield)));
        row.set(this.sourceRowMeta.getFieldIndex(targetfield), (Object)val.add(curVal));
    }

    private void calcActAmt(RowX row, String pre, String targetfield, String[] diffFieldArr, String stAmtField) {
        BigDecimal stAmt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex(stAmtField)));
        if ("end".equals(pre) || "start".equals(pre)) {
            stAmt = BigDecimal.ZERO;
        }
        for (String field : diffFieldArr) {
            stAmt = stAmt.add(BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex(pre + field))));
        }
        row.set(this.sourceRowMeta.getFieldIndex(targetfield), (Object)stAmt);
    }

    private void sumDiffAmt(RowX sumRow, RowX curRow, String fieldPre, String[] fieldKeys) {
        for (String field : fieldKeys) {
            String actField = fieldPre + field;
            BigDecimal val = curRow.getBigDecimal(this.sourceRowMeta.getFieldIndex(actField));
            if (val == null) {
                val = BigDecimal.ZERO;
            }
            sumRow.set(this.sourceRowMeta.getFieldIndex(actField), (Object)val.add(BigDecimalUtils.getBigDecimalOrZero(sumRow.getBigDecimal(this.sourceRowMeta.getFieldIndex(actField)))));
        }
    }

    private RowX generateSumRow(RowX row, Long costobject, Long relacostobject) {
        RowX newRow = row.copy();
        newRow.set(this.sourceRowMeta.getFieldIndex("type"), (Object)"5");
        newRow.set(this.sourceRowMeta.getFieldIndex("costobject"), (Object)costobject);
        newRow.set(this.sourceRowMeta.getFieldIndex("relacostobject"), (Object)relacostobject);
        newRow.set(this.sourceRowMeta.getFieldIndex("element"), (Object)0L);
        newRow.set(this.sourceRowMeta.getFieldIndex("subelement"), (Object)0L);
        newRow.set(this.sourceRowMeta.getFieldIndex("material"), (Object)0L);
        newRow.set(this.sourceRowMeta.getFieldIndex("mversion"), (Object)0L);
        newRow.set(this.sourceRowMeta.getFieldIndex("auxpty"), (Object)0L);
        newRow.set(this.sourceRowMeta.getFieldIndex("baseunit"), (Object)0L);
        for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
            newRow.set(this.sourceRowMeta.getFieldIndex("start" + field), (Object)BigDecimal.ZERO);
            newRow.set(this.sourceRowMeta.getFieldIndex("curr" + field), (Object)BigDecimal.ZERO);
            newRow.set(this.sourceRowMeta.getFieldIndex("comp" + field), (Object)BigDecimal.ZERO);
            newRow.set(this.sourceRowMeta.getFieldIndex("end" + field), (Object)BigDecimal.ZERO);
            newRow.set(this.sourceRowMeta.getFieldIndex("total" + field), (Object)BigDecimal.ZERO);
        }
        newRow.set(this.sourceRowMeta.getFieldIndex("startqty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("currqty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("compqty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("endqty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("totalqty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("startamt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("curramt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("compamt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("endamt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("totalamt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("startactcostupamt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("curractcostupamt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("compactcostupamt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("endactcostupamt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("totalactcostupamt"), (Object)BigDecimal.ZERO);
        return newRow;
    }
}

