/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffCalcResultKeycolDealFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta = null;

    public RowMeta getResultRowMeta() {
        if (this.rowMeta != null) {
            return this.rowMeta;
        }
        this.rowMeta = new RowMeta(new Field[]{new Field("costobject", (DataType)DataType.LongType), new Field("relacostobject", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.LongType), new Field("material", (DataType)DataType.LongType), new Field("mversion", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("keycolid", (DataType)DataType.LongType), new Field("keycolStr", (DataType)DataType.StringType)});
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX colRow = new RowX(this.getResultRowMeta().getFieldCount());
        RowX baseRow = null;
        Iterator<RowX> iterator = iterable.iterator();
        int i = 0;
        HashMap<Long, BigDecimal> calckeyColMap = new HashMap<Long, BigDecimal>();
        while (iterator.hasNext()) {
            RowX curRow = iterator.next();
            Long calckeycolid = curRow.getLong(this.sourceRowMeta.getFieldIndex("calckeycol"));
            BigDecimal qty = BigDecimalUtils.getBigDecimalOrZero(curRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("subcurrqty")));
            BigDecimal sumQty = (BigDecimal)calckeyColMap.get(calckeycolid);
            if (sumQty != null) {
                qty = qty.add(sumQty);
            }
            calckeyColMap.put(calckeycolid, qty);
            if (i == 0) {
                baseRow = curRow;
            }
            ++i;
        }
        if (baseRow == null) {
            return;
        }
        colRow.set(this.getResultRowMeta().getFieldIndex("costobject"), (Object)this.getLongValue(baseRow, "costobject"));
        colRow.set(this.getResultRowMeta().getFieldIndex("relacostobject"), (Object)this.getLongValue(baseRow, "relacostobject"));
        colRow.set(this.getResultRowMeta().getFieldIndex("subelement"), (Object)this.getLongValue(baseRow, "subelement"));
        colRow.set(this.getResultRowMeta().getFieldIndex("material"), (Object)this.getLongValue(baseRow, "material"));
        colRow.set(this.getResultRowMeta().getFieldIndex("mversion"), (Object)this.getLongValue(baseRow, "mversion"));
        colRow.set(this.getResultRowMeta().getFieldIndex("auxpty"), (Object)this.getLongValue(baseRow, "auxpty"));
        colRow.set(this.getResultRowMeta().getFieldIndex("keycolid"), (Object)this.getLongValue(baseRow, "keycolid"));
        colRow.set(this.getResultRowMeta().getFieldIndex("keycolStr"), (Object)JSONObject.toJSONString(calckeyColMap));
        collector.collect(colRow);
    }

    private Long getLongValue(RowX row, String key) {
        Long val = row.getLong(this.sourceRowMeta.getFieldIndex(key));
        if (val == null) {
            return 0L;
        }
        return val;
    }
}

