/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffCheckInDifftypeTranFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private String[] difftypes;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public DiffCheckInDifftypeTranFunction(String[] difftypes) {
        this.difftypes = difftypes;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> rows = new ArrayList<RowX>(10);
        for (RowX row : iterable) {
            BigDecimal sumSrcAmt = BigDecimal.ZERO;
            BigDecimal sumTarAmt = BigDecimal.ZERO;
            for (String difftype : this.difftypes) {
                String field = this.getDiffTypeField(difftype);
                if (field == null) continue;
                BigDecimal srcamt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex(field)));
                BigDecimal taramt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("d" + field)));
                if (BigDecimal.ZERO.compareTo(srcamt) == 0 && BigDecimal.ZERO.compareTo(taramt) == 0) continue;
                RowX newRow = row.copy();
                sumSrcAmt = sumSrcAmt.add(srcamt);
                sumTarAmt = sumTarAmt.add(taramt);
                newRow.set(this.sourceRowMeta.getFieldIndex("difftype"), (Object)difftype);
                newRow.set(this.sourceRowMeta.getFieldIndex("taramt"), (Object)taramt);
                newRow.set(this.sourceRowMeta.getFieldIndex("srcamt"), (Object)srcamt);
                newRow.set(this.sourceRowMeta.getFieldIndex("diffamt"), (Object)taramt.subtract(srcamt));
                rows.add(newRow);
            }
            String diffType = "ALL";
            String field = this.getDiffTypeField(diffType);
            if (this.difftypes.length == 0 || "".equals(this.difftypes[0])) {
                sumSrcAmt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex(field)));
                sumTarAmt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("d" + field)));
            }
            RowX newRow = row.copy();
            newRow.set(this.sourceRowMeta.getFieldIndex("difftype"), (Object)diffType);
            newRow.set(this.sourceRowMeta.getFieldIndex("srcamt"), (Object)sumSrcAmt);
            newRow.set(this.sourceRowMeta.getFieldIndex("taramt"), (Object)sumTarAmt);
            newRow.set(this.sourceRowMeta.getFieldIndex("diffamt"), (Object)sumTarAmt.subtract(sumSrcAmt));
            rows.add(newRow);
        }
        for (RowX row : rows) {
            collector.collect(row);
        }
    }

    private String getDiffTypeField(String difftype) {
        String type = null;
        switch (difftype) {
            case "G": {
                type = "diff_g";
                break;
            }
            case "H": {
                type = "diff_h";
                break;
            }
            case "K": {
                type = "diff_k";
                break;
            }
            case "P": {
                type = "diff_p";
                break;
            }
            case "Q": {
                type = "diff_q";
                break;
            }
            case "R": {
                type = "diff_r";
                break;
            }
            case "M": {
                type = "diff_m";
                break;
            }
            case "S": {
                type = "diff_s";
                break;
            }
            case "T": {
                type = "diff_t";
                break;
            }
            case "C": {
                type = "diff_c";
                break;
            }
            case "X": {
                type = "diff_x";
                break;
            }
            case "W": {
                type = "diff_w";
                break;
            }
            case "Y": {
                type = "diff_y";
                break;
            }
            case "ALL": {
                type = "diff_all";
            }
        }
        return type;
    }
}

