/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.HashSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;

public class DiffMaterialLvlDealGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("submaterial", (DataType)DataType.LongType), new Field("submaterialnumber", (DataType)DataType.StringType), new Field("subauxpty", (DataType)DataType.LongType), new Field("submatversion", (DataType)DataType.LongType), new Field("subconfiguredcode", (DataType)DataType.LongType), new Field("subtracknumber", (DataType)DataType.LongType), new Field("subproject", (DataType)DataType.LongType), new Field("sublot", (DataType)DataType.StringType), new Field("material", (DataType)DataType.LongType), new Field("materialnumber", (DataType)DataType.StringType), new Field("auxpty", (DataType)DataType.LongType), new Field("matversion", (DataType)DataType.LongType), new Field("configuredcode", (DataType)DataType.LongType), new Field("tracknumber", (DataType)DataType.LongType), new Field("project", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType)});

    public RowMeta getResultRowMeta() {
        return targetRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashSet<String> srcBillMatIDs = new HashSet<String>(16);
        HashSet<String> targBillMatIDs = new HashSet<String>(16);
        HashSet matGroupSet = Sets.newHashSet();
        for (RowX row : iterable) {
            this.dealNonUpdateCalFields(row);
            String materialData = String.format("%s@%s@%s@%s@%s@%s", row.getLong(this.getSourceRowMeta().getFieldIndex("materialid")), row.getLong(this.getSourceRowMeta().getFieldIndex("auxpty")), row.getLong(this.getSourceRowMeta().getFieldIndex("configuredcode")), row.getLong(this.getSourceRowMeta().getFieldIndex("tracknumber")), row.getLong(this.getSourceRowMeta().getFieldIndex("project")), row.getString(this.getSourceRowMeta().getFieldIndex("lot")));
            if ("0".equals(row.getString(this.getSourceRowMeta().getFieldIndex("type")))) {
                srcBillMatIDs.add(materialData);
                continue;
            }
            targBillMatIDs.add(materialData);
        }
        for (String srcMatId : srcBillMatIDs) {
            for (String tarMatId : targBillMatIDs) {
                if (srcMatId.equals(tarMatId)) continue;
                matGroupSet.add(String.format("%s---%s", srcMatId, tarMatId));
            }
        }
        for (String matGroupStr : matGroupSet) {
            String[] arr = matGroupStr.split("---");
            String[] sub = arr[0].split("@");
            String[] main = arr[1].split("@");
            RowX newRow = new RowX(16);
            newRow.setValues(new Object[]{Long.valueOf(sub[0]), " ", Long.valueOf(sub[1]), 0L, Long.valueOf(sub[2]), Long.valueOf(sub[3]), Long.valueOf(sub[4]), sub.length < 6 ? "" : sub[5], Long.valueOf(main[0]), " ", Long.valueOf(main[1]), 0L, Long.valueOf(main[2]), Long.valueOf(main[3]), Long.valueOf(main[4]), main.length < 6 ? "" : main[5]});
            collector.collect(newRow);
        }
    }

    private void dealNonUpdateCalFields(RowX row) {
        String noupdatecalfields = row.getString(this.sourceRowMeta.getFieldIndex("noupdatecalfields"));
        if (StringUtils.isEmpty((String)noupdatecalfields)) {
            return;
        }
        JSONObject jsonObj = JSON.parseObject((String)noupdatecalfields);
        JSONArray arr = jsonObj.getJSONArray("setnull");
        if (arr == null || arr.isEmpty()) {
            return;
        }
        HashSet nullFields = Sets.newHashSetWithExpectedSize((int)10);
        for (int i = 0; i < arr.size(); ++i) {
            nullFields.add(arr.getString(i));
        }
        for (String nullField : nullFields) {
            if ("tracknumber".equals(nullField)) {
                row.set(this.sourceRowMeta.getFieldIndex("tracknumber"), (Object)0L);
            }
            if ("configuredcode".equals(nullField)) {
                row.set(this.sourceRowMeta.getFieldIndex("configuredcode"), (Object)0L);
            }
            if (!"project".equals(nullField)) continue;
            row.set(this.sourceRowMeta.getFieldIndex("project"), (Object)0L);
        }
    }
}

