/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;

public class DiffTransOutDifftypeTranFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> rows = new ArrayList<RowX>(10);
        for (RowX row : iterable) {
            for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
                BigDecimal val = row.getBigDecimal(this.sourceRowMeta.getFieldIndex(field));
                String type = this.getDiffTypeField(field);
                if (val == null || BigDecimal.ZERO.compareTo(val) == 0 || type == null) continue;
                RowX newRow = row.copy();
                newRow.set(this.sourceRowMeta.getFieldIndex("difftype"), (Object)type);
                newRow.set(this.sourceRowMeta.getFieldIndex("amount"), (Object)val);
                rows.add(newRow);
            }
        }
        for (RowX row : rows) {
            collector.collect(row);
        }
    }

    private String getDiffTypeField(String diffField) {
        String type = null;
        switch (diffField) {
            case "orddiff": {
                type = "G";
                break;
            }
            case "invoicediff": {
                type = "H";
                break;
            }
            case "feediff": {
                type = "K";
                break;
            }
            case "stdcostupamt": {
                type = "M";
                break;
            }
            case "diffqty": {
                type = "P";
                break;
            }
            case "madediff": {
                type = "Q";
                break;
            }
            case "unjoindiffamt": {
                type = "R";
                break;
            }
            case "madeupamt": {
                type = "S";
                break;
            }
            case "otherdiff": {
                type = "T";
                break;
            }
            case "falldiff": {
                type = "C";
                break;
            }
        }
        return type;
    }
}

