/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.macc.sca.algox.costrec.DebugInfoMsgHandler;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;

public class DiffTransOutReworkFilterFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private List<List<String>> nestMatGroups;
    private boolean isnestgroup = false;
    private Set<String> diffMatLvlDim = null;
    private String debugColValue = null;
    private DebugInfoMsgHandler msgHander;

    public DiffTransOutReworkFilterFunction(List<List<String>> nestMatGroups, Set<String> diffMatLvlDim, boolean isnestgroup, String debugColValue, DebugInfoMsgHandler msgHander) {
        this.nestMatGroups = nestMatGroups;
        this.isnestgroup = isnestgroup;
        if (diffMatLvlDim != null) {
            this.diffMatLvlDim = new TreeSet<String>(diffMatLvlDim);
        }
        this.debugColValue = debugColValue;
        this.msgHander = msgHander;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iteraRows, Collector cols) {
        ArrayList listRows = Lists.newArrayList();
        if (!StringUtils.isEmpty((String)this.debugColValue) && !this.isnestgroup) {
            this.msgHander.dealInfoMsg(String.format("diffMatLvlDim:%s", this.diffMatLvlDim.toString()));
        }
        for (RowX row : iteraRows) {
            boolean isCollect;
            block6: {
                String materialDim;
                String productDim;
                block5: {
                    isCollect = false;
                    productDim = DiffCalcHelper.getDimStrFromRow(row, this.sourceRowMeta, this.diffMatLvlDim, "");
                    materialDim = DiffCalcHelper.getDimStrFromRow(row, this.sourceRowMeta, this.diffMatLvlDim, "sub");
                    if (!this.isnestgroup) break block5;
                    for (List<String> nestMatGroup : this.nestMatGroups) {
                        if (!nestMatGroup.contains(productDim) || !nestMatGroup.contains(materialDim)) continue;
                        isCollect = true;
                        break;
                    }
                    if (StringUtils.isEmpty((String)this.debugColValue)) break block6;
                    this.msgHander.dealInfoMsg(String.format("diffMatLvlDim:%s,productDim:%s,materialDim:%s,isCollect=%s", this.diffMatLvlDim.toString(), productDim, materialDim, isCollect));
                    break block6;
                }
                isCollect = true;
                for (List<String> nestMatGroup : this.nestMatGroups) {
                    if (!nestMatGroup.contains(productDim) || !nestMatGroup.contains(materialDim)) continue;
                    isCollect = false;
                    break;
                }
            }
            if (!isCollect) continue;
            listRows.add(row);
        }
        for (RowX row : listRows) {
            cols.collect(row);
        }
    }
}

