/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.report;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.restore.function.DiffCheckInDifftypeTranFunction;
import kd.macc.sca.algox.restore.report.DiffCheckInReportArgs;
import kd.macc.sca.algox.restore.report.DiffCheckQueryHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.algox.utils.PeriodHelper;

public class DiffCheckInQueryHelper {
    public static final Log logger = LogFactory.getLog(DiffCheckQueryHelper.class);

    public static DataSet queryDiff(DiffCheckInReportArgs args) {
        if (args.getStartDate() == null || args.getEndDate() == null) {
            Date[] periodDate = PeriodHelper.getPeriodStartAndEndTime(args.getPeriod());
            if (periodDate != null) {
                args.setStartDate(periodDate[0]);
                args.setEndDate(periodDate[1]);
            } else {
                return null;
            }
        }
        return DiffCheckInQueryHelper.getResultDs(args);
    }

    private static DataSet getResultDs(DiffCheckInReportArgs args) {
        OrmInput matAllocDs = DiffCheckInQueryHelper.getMatAllocDs(args);
        OrmInput matcollectDs = DiffCheckInQueryHelper.getMatCollectDs(args);
        OrmInput costRecordDs = DiffCheckInQueryHelper.getCostRecordDs(args);
        OrmInput diffDs = DiffCheckInQueryHelper.getStDiffDs(args);
        OrmInput diffInDs = DiffCheckInQueryHelper.getStdInDs(args);
        JobSession session = AlgoX.createSession((String)"diffInCheck");
        DataSetX matAllocDsX = session.fromInput((Input)matAllocDs);
        DataSetX matcollectDsX = session.fromInput((Input)matcollectDs);
        DataSetX costRecordDsX = session.fromInput((Input)costRecordDs);
        DataSetX diffDsX = session.fromInput((Input)diffDs);
        DataSetX diffInDsX = session.fromInput((Input)diffInDs);
        ArrayList<String> groupArr = new ArrayList<String>();
        groupArr.add("materialnum");
        groupArr.add("material");
        if ("2".equals(args.getDisplaymodel()) || "3".equals(args.getDisplaymodel())) {
            groupArr.add("configuredcode");
        }
        if ("3".equals(args.getDisplaymodel())) {
            groupArr.add("tracknumber");
        }
        groupArr.add("costobjectnum");
        groupArr.add("costobject");
        JoinDataSetX diffSrcDsx = matAllocDsX.join(matcollectDsX).on("matcollectid", "matusecolectentryid").select(matAllocDsX.getRowMeta().getFieldNames(), new String[]{"sourcebillentryid"});
        diffSrcDsx = diffSrcDsx.leftJoin(costRecordDsX).on("sourcebillentryid", "bizbillentryid").select(diffSrcDsx.getRowMeta().getFieldNames(), new String[]{"rentryid"});
        diffSrcDsx = diffSrcDsx.leftJoin(diffDsX).on("rentryid", "rentryid").select(diffSrcDsx.getRowMeta().getFieldNames(), new String[]{"diff_g", "diff_h", "diff_k", "diff_p", "diff_q", "diff_r", "diff_m", "diff_s", "diff_t", "diff_c", "diff_x", "diff_w", "diff_y", "diff_all"});
        String[] srcFieldArr = DiffCheckInQueryHelper.getDiffArr(args.getDiffTypes()).toArray(new String[0]);
        diffSrcDsx = DataSetXHelper.groupBySum((DataSetX)diffSrcDsx, groupArr.toArray(new String[0]), srcFieldArr);
        String[] inFieldArr = DiffCalcHelper.fieldsAddPre(srcFieldArr, "d");
        diffSrcDsx = DataSetXHelper.addBigDecimalFields((DataSetX)diffSrcDsx, inFieldArr);
        diffInDsX = diffInDsX.map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX row) {
                BigDecimal diffAmt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("ddiff_all")));
                BigDecimal stAmt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("stamt")));
                row.set(this.sourceRowMeta.getFieldIndex("ddiff_all"), (Object)diffAmt.subtract(stAmt));
                return row;
            }
        });
        diffInDsX = DataSetXHelper.groupBySum(diffInDsX, groupArr.toArray(new String[0]), inFieldArr);
        DataSetX resultDsx = DataSetXHelper.unionIfRowDiff((DataSetX)diffSrcDsx, diffInDsX);
        resultDsx = DataSetXHelper.groupBySum(resultDsx, groupArr.toArray(new String[0]), DiffCalcHelper.stringArrUnion(srcFieldArr, inFieldArr));
        resultDsx = resultDsx.addFields(new Field[]{new Field("difftype", (DataType)DataType.StringType), new Field("srcamt", (DataType)DataType.BigDecimalType), new Field("taramt", (DataType)DataType.BigDecimalType), new Field("diffamt", (DataType)DataType.BigDecimalType)}, new Object[]{"", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        resultDsx = resultDsx.groupBy(groupArr.toArray(new String[0])).reduceGroup((GroupReduceFunction)new DiffCheckInDifftypeTranFunction(args.getDiffTypes()));
        if (args.isShowdiffonly()) {
            resultDsx = resultDsx.filter("diffamt<>0");
        }
        groupArr.add("difftype");
        resultDsx = resultDsx.groupBy(groupArr.toArray(new String[0])).sum("srcamt").sum("taramt").sum("diffamt");
        DataSetX countAllDsx = resultDsx.filter("difftype='ALL'").map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX row) {
                if (this.sourceRowMeta.getFieldIndex("configuredcode", false) >= 0) {
                    row.set(this.sourceRowMeta.getFieldIndex("configuredcode"), (Object)0L);
                }
                if (this.sourceRowMeta.getFieldIndex("tracknumber", false) >= 0) {
                    row.set(this.sourceRowMeta.getFieldIndex("tracknumber"), (Object)0L);
                }
                row.set(this.sourceRowMeta.getFieldIndex("difftype"), (Object)"ZZ");
                row.set(this.sourceRowMeta.getFieldIndex("material"), (Object)0L);
                row.set(this.sourceRowMeta.getFieldIndex("materialnum"), (Object)"");
                row.set(this.sourceRowMeta.getFieldIndex("costobject"), (Object)0L);
                row.set(this.sourceRowMeta.getFieldIndex("costobjectnum"), (Object)"");
                return row;
            }
        });
        countAllDsx = countAllDsx.groupBy(groupArr.toArray(new String[0])).sum("srcamt").sum("taramt").sum("diffamt");
        resultDsx = resultDsx.addFields(new Field[]{new Field("currency", (DataType)DataType.LongType), new Field("org", (DataType)DataType.LongType), new Field("costaccount", (DataType)DataType.LongType), new Field("period", (DataType)DataType.LongType)}, new Object[]{args.getCurrencyId(), args.getOrgId(), args.getCostaccountId(), args.getPeriod()});
        countAllDsx = countAllDsx.addFields(new Field[]{new Field("currency", (DataType)DataType.LongType), new Field("org", (DataType)DataType.LongType), new Field("costaccount", (DataType)DataType.LongType), new Field("period", (DataType)DataType.LongType)}, new Object[]{args.getCurrencyId(), 0L, 0L, 0L});
        resultDsx = resultDsx.union(countAllDsx);
        ArrayList<String> orderNum = new ArrayList<String>(groupArr);
        orderNum.remove("material");
        orderNum.add("difftype");
        resultDsx = resultDsx.orderBy(orderNum.toArray(new String[0]));
        DataSetOutput resultSet = new DataSetOutput(resultDsx.getRowMeta());
        resultDsx.output((Output)resultSet);
        try {
            long start = System.currentTimeMillis();
            session.commit(20, TimeUnit.MINUTES);
            logger.info("\u5dee\u5f02\u5bf9\u6570\u62a5\u8868\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u5dee\u5f02\u5bf9\u6570\u62a5\u8868\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        return session.readDataSet(resultSet.getId());
    }

    private static List<String> getDiffArr(String[] difftypes) {
        HashSet diffArr = Sets.newHashSetWithExpectedSize((int)10);
        if (difftypes.length == 0 || "".equals(difftypes[0])) {
            diffArr.add("diff_all");
        }
        String[] stringArray = difftypes;
        int n = stringArray.length;
        block30: for (int i = 0; i < n; ++i) {
            String difftype;
            switch (difftype = stringArray[i]) {
                case "G": {
                    diffArr.add("diff_g");
                    continue block30;
                }
                case "H": {
                    diffArr.add("diff_h");
                    continue block30;
                }
                case "K": {
                    diffArr.add("diff_k");
                    continue block30;
                }
                case "P": {
                    diffArr.add("diff_p");
                    continue block30;
                }
                case "Q": {
                    diffArr.add("diff_q");
                    continue block30;
                }
                case "R": {
                    diffArr.add("diff_r");
                    continue block30;
                }
                case "M": {
                    diffArr.add("diff_m");
                    continue block30;
                }
                case "S": {
                    diffArr.add("diff_s");
                    continue block30;
                }
                case "T": {
                    diffArr.add("diff_t");
                    continue block30;
                }
                case "C": {
                    diffArr.add("diff_c");
                    continue block30;
                }
                case "X": {
                    diffArr.add("diff_x");
                    continue block30;
                }
                case "W": {
                    diffArr.add("diff_w");
                    continue block30;
                }
                case "Y": {
                    diffArr.add("diff_y");
                }
            }
        }
        return new ArrayList<String>(diffArr);
    }

    private static OrmInput getMatAllocDs(DiffCheckInReportArgs args) {
        QFilter qFilter = new QFilter("org", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        qFilter.and("period", "=", (Object)args.getPeriod());
        qFilter.and("appnum", "=", (Object)"sca");
        qFilter.and("allocstatus", "=", (Object)"2");
        if (!CadEmptyUtils.isEmpty(args.getMaterials())) {
            qFilter.and("material", "in", args.getMaterials());
        }
        return new OrmInput("getMatAlloc", "sca_matalloc", "matcollect matcollectid,material,material.number materialnum,configuredcode,tracknumber,costobject,costobject.billno costobjectnum", qFilter.toArray());
    }

    private static OrmInput getMatCollectDs(DiffCheckInReportArgs args) {
        QFilter coqFilter = new QFilter("org", "=", (Object)args.getOrgId());
        coqFilter.and("bookdate", ">=", (Object)args.getStartDate());
        coqFilter.and("bookdate", "<=", (Object)args.getEndDate());
        coqFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
        if (!CadEmptyUtils.isEmpty(args.getMaterials())) {
            coqFilter.and("entryentity.material", "in", args.getMaterials());
        }
        return new OrmInput("matcollect", "sca_matusecollect", "entryentity.id AS matusecolectentryid,entryentity.sourcebillentryid AS sourcebillentryid", coqFilter.toArray());
    }

    private static OrmInput getCostRecordDs(DiffCheckInReportArgs args) {
        QFilter costRFilter = new QFilter("calorg", "=", (Object)args.getOrgId());
        costRFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        costRFilter.and("period", "=", (Object)args.getPeriod());
        costRFilter.and("bookdate", ">=", (Object)args.getStartDate());
        costRFilter.and("bookdate", "<=", (Object)args.getEndDate());
        costRFilter.and("calbilltype", "=", (Object)"OUT");
        if (!CadEmptyUtils.isEmpty(args.getMaterials())) {
            costRFilter.and("entry.material", "in", args.getMaterials());
        }
        return new OrmInput("getCalCostRecord", "cal_costrecord_subentity", "id AS recordid,entry.id rentryid,entry.bizbillentryid AS bizbillentryid", costRFilter.toArray());
    }

    private static OrmInput getStDiffDs(DiffCheckInReportArgs args) {
        QFilter diffFilter = new QFilter("biztype", "=", (Object)"B");
        diffFilter.and("calorg", "=", (Object)args.getOrgId());
        diffFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        diffFilter.and("bookdate", ">=", (Object)args.getStartDate());
        diffFilter.and("bookdate", "<=", (Object)args.getEndDate());
        diffFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
        if (!CadEmptyUtils.isEmpty(args.getMaterials())) {
            diffFilter.and("entryentity.material", "in", args.getMaterials());
        }
        return new OrmInput("getCalCostRecord", "cal_stdcostdiffbill", "entryentity.invbillid AS recordid,entryentity.invbillentryid AS rentryid,entryentity.diff_g diff_g,entryentity.diff_h diff_h,entryentity.diff_k diff_k,entryentity.diff_p diff_p,entryentity.diff_q diff_q,entryentity.diff_r diff_r,entryentity.diff_m diff_m,entryentity.diff_s diff_s,entryentity.diff_t diff_t,entryentity.diff_c diff_c,entryentity.diff_x diff_x,entryentity.diff_w diff_w,entryentity.diff_y diff_y,entryentity.adjustamt diff_all", diffFilter.toArray());
    }

    private static OrmInput getStdInDs(DiffCheckInReportArgs args) {
        QFilter downFilter = new QFilter("org", "=", (Object)args.getOrgId());
        downFilter.and("costaccount", "=", (Object)args.getCostaccountId());
        downFilter.and("period", "=", (Object)args.getPeriod());
        downFilter.and("entryentity2.type2", "=", (Object)"5");
        downFilter.and("entryentity2.relacostobject2.producttype", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(args.getMaterials())) {
            downFilter.and("entryentity2.material2", "in", args.getMaterials());
        }
        return new OrmInput("loadSubElementMfgFeeal", "sca_diffcalcresult", "entryentity2.material2 material,entryentity2.material2.number materialnum,entryentity2.configuredcode2 configuredcode,entryentity2.tracknumber2 tracknumber,entryentity2.relacostobject2 costobject,entryentity2.relacostobject2.billno costobjectnum,entryentity2.currdiffqty2 ddiff_p,entryentity2.currmadediff2 ddiff_q,entryentity2.currmadeupamt2 ddiff_s,entryentity2.currunjoindiffamt2 ddiff_r,entryentity2.currstdcostupamt2 ddiff_m,entryentity2.currorddiff2 ddiff_g,entryentity2.currinvoicediff2 ddiff_h,entryentity2.currfeediff2 ddiff_k,entryentity2.currotherdiff2 ddiff_t,entryentity2.currfalldiff2 ddiff_c,entryentity2.currreservediffx2 ddiff_x,entryentity2.currreservediffw2 ddiff_w,entryentity2.currreservediffy2 ddiff_y,entryentity2.curractcostupamt2 ddiff_all,entryentity2.curramt2 stamt", downFilter.toArray());
    }
}

