/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.task;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.sca.algox.alloc.function.AbstractCalcFunction;
import kd.macc.sca.algox.alloc.function.FinishFunction;
import kd.macc.sca.algox.alloc.output.CalcResult;
import kd.macc.sca.algox.calc.input.CalcDataArgs;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public abstract class AbstractCalcProcessor {
    protected static final Log logger = LogFactory.getLog(AbstractCalcProcessor.class);
    protected CalcDataArgs args = null;
    private DataSetInput[] dataSetInputs = null;
    private AbstractCalcFunction calculateFunction = null;
    private long calculatedBeginTime;

    public abstract void beforCalculate(CalcDataArgs var1);

    public AbstractCalcProcessor(AbstractCalcFunction calculateFunction, CalcDataArgs args) {
        this.calculateFunction = calculateFunction;
        this.args = args;
        if (calculateFunction != null) {
            this.calculateFunction.setCalcDataArgs(args);
        }
    }

    public CalcResult calculate() {
        this.beforCalculate(this.args);
        CalcResult result = this.doCalculate();
        return result;
    }

    protected CalcResult doCalculate() {
        CalcResult result = new CalcResult();
        if (CadEmptyUtils.isEmpty(this.dataSetInputs)) {
            return result;
        }
        try {
            JobSession session = AlgoX.createSession((String)"AbstractCalcProcessor.doCalculate");
            DataSetX dataSetX = session.fromInput((Input[])this.dataSetInputs);
            DataSetX mainDs = this.wrapDataSetX(dataSetX);
            mainDs = mainDs.groupBy(new String[]{"costobject"}).reduceGroup((GroupReduceFunction)new FinishFunction());
            mainDs.output((Output)new IgnoreOutput());
            try {
                session.commit(60, TimeUnit.MINUTES);
                result.setAllSuccess(true);
            }
            catch (CommitTimeoutException e) {
                result.setAllSuccess(false);
                result.setErrInfo((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("e", e.getMessage());
                    }
                });
                logger.error("\u8ba1\u7b97\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (Throwable)e);
            }
            catch (RunningTimeoutException e) {
                result.setAllSuccess(false);
                result.setErrInfo((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("e", e.getMessage());
                    }
                });
                logger.error("\u8ba1\u7b97\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (Throwable)e);
            }
        }
        catch (Exception e) {
            result.setAllSuccess(false);
            result.setErrInfo((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("e", e.getMessage());
                }
            });
            logger.error("\u8ba1\u7b97\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (Throwable)e);
        }
        return result;
    }

    protected DataSetX wrapDataSetX(DataSetX dataSetX) {
        return dataSetX.reduceGroup((GroupReduceFunction)this.calculateFunction);
    }

    protected AbstractCalcFunction getCalculateFunction() {
        return this.calculateFunction;
    }

    protected CalcDataArgs getArgs() {
        return this.args;
    }

    protected void setArgs(CalcDataArgs args) {
        this.args = args;
    }

    public void setDataSetInput(DataSet ... dataSets) {
        if (dataSets == null) {
            return;
        }
        if (dataSets != null && dataSets.length > 0) {
            this.dataSetInputs = new DataSetInput[dataSets.length];
        }
        for (int i = 0; i < dataSets.length; ++i) {
            this.dataSetInputs[i] = new DataSetInput(dataSets[i]);
        }
    }

    public long getCalculatedBeginTime() {
        return this.calculatedBeginTime;
    }

    public void setCalculatedBeginTime(long calculatedBeginTime) {
        this.calculatedBeginTime = calculatedBeginTime;
    }
}

