/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.task;

import java.util.ArrayList;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.calc.input.CalcDataArgs;

public class DiffCheckQueryHelper {
    public static DataSet queryDiff(CalcDataArgs args) throws Exception {
        boolean isShowdiffdetail = false;
        boolean isShowdiffonly = true;
        String difftypes = ",C,T,S,R,Q,P,M,K,H,G,";
        String replaceStr = difftypes.replace(",", "\",\"");
        replaceStr = replaceStr.substring(2, replaceStr.length() - 2);
        String sql = "difftype in (" + replaceStr + ")";
        DataSet countDS = DiffCheckQueryHelper.getCountDS(args, false, difftypes);
        DataSet countAllDs = countDS.copy();
        countAllDs = DiffCheckQueryHelper.getCountAllDS(countAllDs);
        DataSet detailDS = DiffCheckQueryHelper.getDetailDS(args);
        if (isShowdiffdetail) {
            countDS = countDS.select("org,costaccount,period,material,difftype,allocamt,finishamt,unabsamt,adjustamt,diffamount");
            detailDS = detailDS.filter(sql);
            countDS = countDS.union(detailDS).orderBy(new String[]{"material", "difftype"});
        }
        countDS = countDS.union(countAllDs);
        if (isShowdiffonly) {
            countDS = countDS.filter("diffamount!=0");
        }
        return countDS;
    }

    private static DataSet getCountAllDS(DataSet countAllDs) {
        GroupbyDataSet groupDataSet = countAllDs.groupBy(new String[]{"org", "costaccount", "period"});
        groupDataSet.sum("allocamt");
        groupDataSet.sum("finishamt");
        groupDataSet.sum("unabsamt");
        groupDataSet.sum("adjustamt");
        groupDataSet.sum("diffamount");
        countAllDs = groupDataSet.finish();
        countAllDs = countAllDs.select("0 org,0 costaccount,0 period,0 material,'1' difftype,allocamt,finishamt,unabsamt,adjustamt,diffamount");
        return countAllDs;
    }

    private static DataSet getCountDS(CalcDataArgs args, Boolean isShowdiffdetail, String difftypes) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        QFilter orgQF = new QFilter("org", "=", (Object)args.getOrgId());
        QFilter calorgQF = new QFilter("calorg", "=", (Object)args.getOrgId());
        QFilter costaccQF = new QFilter("costaccount", "=", (Object)args.getCostAccount());
        QFilter periodQF = new QFilter("period", "=", (Object)args.getPeriod());
        Object costcenterQF = null;
        String algoKey = "kd.macc.sca.algox.task.DiffCheckQueryHelper.query";
        filters.add(orgQF);
        filters.add(costaccQF);
        filters.add(periodQF);
        if (isShowdiffdetail.booleanValue()) {
            filters.add(new QFilter("difftype", "in", (Object)difftypes.split(",")));
        }
        String allocSelectFields = "org,costaccount,period,entryentity.costobject.material.masterid material,entryentity.amount allocamt,0 finishamt,0 unabsamt";
        DataSet allocDS = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_purchdiffalloc", (String)allocSelectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        GroupbyDataSet groupDataSet = allocDS.groupBy(new String[]{"org", "costaccount", "period", "material"});
        groupDataSet.sum("allocamt");
        groupDataSet.sum("finishamt");
        groupDataSet.sum("unabsamt");
        allocDS = groupDataSet.finish();
        filters.clear();
        filters.add(orgQF);
        filters.add(costaccQF);
        filters.add(periodQF);
        if (costcenterQF != null) {
            filters.add((QFilter)costcenterQF);
        }
        String finishdiff = difftypes.replace("P", "1");
        finishdiff = finishdiff.replace("Q", "2");
        finishdiff = finishdiff.replace("S", "3");
        finishdiff = finishdiff.replace("R", "4");
        if (isShowdiffdetail.booleanValue()) {
            filters.add(new QFilter("entryentity.difftype", "in", (Object)finishdiff.split(",")));
        }
        String finsihSelectFields = "org,costaccount,period,costobject.material.masterid material,0 allocamt,entryentity.amount finishamt,0 unabsamt";
        DataSet finishDS = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_finishdiffbill", (String)finsihSelectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        groupDataSet = finishDS.groupBy(new String[]{"org", "costaccount", "period", "material"});
        groupDataSet.sum("allocamt");
        groupDataSet.sum("finishamt");
        groupDataSet.sum("unabsamt");
        finishDS = groupDataSet.finish();
        filters.clear();
        filters.add(orgQF);
        filters.add(costaccQF);
        filters.add(periodQF);
        if (costcenterQF != null) {
            filters.add((QFilter)costcenterQF);
        }
        if (isShowdiffdetail.booleanValue()) {
            filters.add(new QFilter("difftype", "in", (Object)finishdiff.split(",")));
        }
        String unabsorbSelectFields = "org,costaccount,period,costobject.material.masterid material,0 allocamt,0 finishamt,entryentity.amount unabsamt";
        DataSet unabsorbDS = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_unabsorbdiff", (String)unabsorbSelectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        groupDataSet = unabsorbDS.groupBy(new String[]{"org", "costaccount", "period", "material"});
        groupDataSet.sum("allocamt");
        groupDataSet.sum("finishamt");
        groupDataSet.sum("unabsamt");
        unabsorbDS = groupDataSet.finish();
        DataSet collDS = allocDS.union(finishDS).union(unabsorbDS);
        groupDataSet = collDS.groupBy(new String[]{"org", "costaccount", "period", "material"});
        groupDataSet.sum("allocamt");
        groupDataSet.sum("finishamt");
        groupDataSet.sum("unabsamt");
        collDS = groupDataSet.finish();
        filters.clear();
        QFilter bizQF = new QFilter("biztype", "=", (Object)"A");
        QFilter btypeQF = DiffCheckQueryHelper.getBillTypeFilter();
        filters.add(calorgQF);
        filters.add(costaccQF);
        filters.add(periodQF);
        filters.add(bizQF);
        filters.add(btypeQF);
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        if (isShowdiffdetail.booleanValue()) {
            filters.add(new QFilter("difftype", "in", (Object)difftypes.split(",")));
        }
        String adjustSelectFields = "calorg org,costaccount,period,entryentity.material.masterid material,entryentity.adjustamt adjustamt";
        DataSet adjustDS = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cal_costadjust_subentity", (String)adjustSelectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        groupDataSet = adjustDS.groupBy(new String[]{"org", "costaccount", "period", "material"});
        groupDataSet.sum("adjustamt");
        adjustDS = groupDataSet.finish();
        JoinDataSet leftJoinDataSet = collDS.join(adjustDS, JoinType.LEFT);
        leftJoinDataSet.on("org", "org");
        leftJoinDataSet.on("costaccount", "costaccount");
        leftJoinDataSet.on("period", "period");
        leftJoinDataSet.on("material", "material");
        collDS = leftJoinDataSet.select(new String[]{"org", "costaccount", "period", "material", "allocamt", "finishamt", "unabsamt"}, new String[]{"adjustamt"}).finish();
        collDS = collDS.select("org,costaccount,period,material,'0' difftype,allocamt,finishamt,unabsamt,adjustamt,allocamt+finishamt+unabsamt- case when adjustamt is null then 0 else adjustamt end diffamount");
        return collDS;
    }

    private static QFilter getBillTypeFilter() {
        QFilter billformidQF = new QFilter("billformid", "in", (Object)new String[]{"im_productinbill", "im_mdc_mftreturnbill", "im_mdc_mftmanuinbill"});
        DynamicObjectCollection billtypes = QueryServiceHelper.query((String)"bos_billtype", (String)"number", (QFilter[])new QFilter[]{billformidQF});
        ArrayList<String> billTypeList = new ArrayList<String>(10);
        for (DynamicObject billtype : billtypes) {
            billTypeList.add(billtype.getString("number"));
        }
        return new QFilter("billtype.number", "in", billTypeList);
    }

    private static DataSet getDetailDS(CalcDataArgs args) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        QFilter orgQF = new QFilter("org", "=", (Object)args.getOrgId());
        QFilter calorgQF = new QFilter("calorg", "=", (Object)args.getOrgId());
        QFilter costaccQF = new QFilter("costaccount", "=", (Object)args.getCostAccount());
        QFilter periodQF = new QFilter("period", "=", (Object)args.getPeriod());
        String algoKey = "kd.macc.sca.algox.task.DiffCheckQueryHelper.query";
        filters.add(orgQF);
        filters.add(costaccQF);
        filters.add(periodQF);
        String allocSelectFields = "org,costaccount,period,entryentity.costobject.material.masterid material,difftype,entryentity.amount allocamt,0 finishamt,0 unabsamt";
        DataSet allocDS = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_purchdiffalloc", (String)allocSelectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        GroupbyDataSet groupDataSet = allocDS.groupBy(new String[]{"org", "costaccount", "period", "material", "difftype"});
        groupDataSet.sum("allocamt");
        groupDataSet.sum("finishamt");
        groupDataSet.sum("unabsamt");
        allocDS = groupDataSet.finish();
        filters.clear();
        filters.add(orgQF);
        filters.add(costaccQF);
        filters.add(periodQF);
        String finsihSelectFields = "org,costaccount,period,costobject.material.masterid material,entryentity.difftype difftype,0 allocamt,entryentity.amount finishamt,0 unabsamt";
        DataSet finishDS = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_finishdiffbill", (String)finsihSelectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        finishDS = finishDS.select("org,costaccount,period,material,case when difftype='1' then 'P' when difftype='2' then 'Q' when difftype='3' then 'S' else difftype end difftype,allocamt,finishamt,unabsamt");
        groupDataSet = finishDS.groupBy(new String[]{"org", "costaccount", "period", "material", "difftype"});
        groupDataSet.sum("allocamt");
        groupDataSet.sum("finishamt");
        groupDataSet.sum("unabsamt");
        finishDS = groupDataSet.finish();
        filters.clear();
        filters.add(orgQF);
        filters.add(costaccQF);
        filters.add(periodQF);
        String unabsorbSelectFields = "org,costaccount,period,costobject.material.masterid material,difftype,0 allocamt,0 finishamt,entryentity.amount unabsamt";
        DataSet unabsorbDS = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_unabsorbdiff", (String)unabsorbSelectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        unabsorbDS = unabsorbDS.select("org,costaccount,period,material,case when difftype='4' then 'R' when difftype='3' then 'S' else difftype end difftype,allocamt,finishamt,unabsamt");
        groupDataSet = unabsorbDS.groupBy(new String[]{"org", "costaccount", "period", "material", "difftype"});
        groupDataSet.sum("allocamt");
        groupDataSet.sum("finishamt");
        groupDataSet.sum("unabsamt");
        unabsorbDS = groupDataSet.finish();
        DataSet collDS = allocDS.union(finishDS).union(unabsorbDS);
        groupDataSet = collDS.groupBy(new String[]{"org", "costaccount", "period", "material", "difftype"});
        groupDataSet.sum("allocamt");
        groupDataSet.sum("finishamt");
        groupDataSet.sum("unabsamt");
        collDS = groupDataSet.finish();
        filters.clear();
        QFilter bizQF = new QFilter("biztype", "=", (Object)"A");
        QFilter btypeQF = DiffCheckQueryHelper.getBillTypeFilter();
        filters.add(calorgQF);
        filters.add(costaccQF);
        filters.add(periodQF);
        filters.add(bizQF);
        filters.add(btypeQF);
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        String adjustSelectFields = "calorg org,costaccount,period,difftype,entryentity.material.masterid material,entryentity.adjustamt adjustamt";
        DataSet adjustDS = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cal_costadjust_subentity", (String)adjustSelectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        groupDataSet = adjustDS.groupBy(new String[]{"org", "costaccount", "period", "material", "difftype"});
        groupDataSet.sum("adjustamt");
        adjustDS = groupDataSet.finish();
        JoinDataSet leftJoinDataSet = collDS.join(adjustDS, JoinType.LEFT);
        leftJoinDataSet.on("org", "org");
        leftJoinDataSet.on("costaccount", "costaccount");
        leftJoinDataSet.on("period", "period");
        leftJoinDataSet.on("material", "material");
        leftJoinDataSet.on("difftype", "difftype");
        DataSet collDS1 = leftJoinDataSet.select(new String[]{"org", "costaccount", "period", "material", "difftype", "allocamt", "finishamt", "unabsamt"}, new String[]{"adjustamt"}).finish();
        leftJoinDataSet = adjustDS.join(collDS, JoinType.LEFT);
        leftJoinDataSet.on("org", "org");
        leftJoinDataSet.on("costaccount", "costaccount");
        leftJoinDataSet.on("period", "period");
        leftJoinDataSet.on("material", "material");
        leftJoinDataSet.on("difftype", "difftype");
        DataSet collDS2 = leftJoinDataSet.select(new String[]{"org", "costaccount", "period", "material", "difftype", "adjustamt"}, new String[]{"allocamt", "finishamt", "unabsamt", "org org1"}).finish();
        collDS2 = collDS2.filter("org1=null");
        collDS2 = collDS2.select("org,costaccount,period,material,difftype,allocamt,finishamt,unabsamt,adjustamt");
        collDS = collDS1.union(collDS2);
        collDS = collDS.select("org,costaccount,period,material,difftype,case when allocamt is null then 0 else allocamt end allocamt,case when finishamt is null then 0 else finishamt end finishamt,case when unabsamt is null then 0 else unabsamt end unabsamt,case when adjustamt is null then 0 else adjustamt end adjustamt");
        collDS = collDS.select("org,costaccount,period,material,difftype,allocamt,finishamt,unabsamt,adjustamt,allocamt+finishamt+unabsamt-adjustamt diffamount");
        return collDS;
    }

    private static Object getFilterItemValue(FilterInfo filterInfo, String propName) {
        FilterItemInfo filterItem = filterInfo.getFilterItem(propName);
        if (filterItem != null && filterItem.getValue() != null) {
            Object value = filterItem.getValue();
            if (value instanceof DynamicObject) {
                return ((DynamicObject)value).getPkValue();
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)value;
                return values.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            }
            return value;
        }
        return null;
    }
}

