/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.calc.input.CalcDataArgs;

public class ActualPriceCheckHelper {
    public static String checkByDiffAlloc(CalcDataArgs args) {
        boolean isNewPeriodBal = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalanceService", (String)"isNewPeriodBal", null);
        DynamicObject periodInfo = BusinessDataServiceHelper.loadSingle((Object)args.getPeriod(), (String)"bd_period");
        int periodNum = periodInfo.getInt("periodyear") * 100 + periodInfo.getInt("periodnumber");
        QFilter filter = new QFilter("costaccount", "=", (Object)args.getCostAccount());
        filter.and("period", "<=", (Object)periodNum);
        filter.and("endperiod", ">", (Object)periodNum);
        filter.and("accounttype", "=", (Object)"D");
        DataSet balSet = null;
        balSet = isNewPeriodBal ? QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.utils.ActualPriceCheckHelper.checkByDiffAlloc", (String)"cal_bal", (String)ActualPriceCheckHelper.getNewBalSelectFields(periodNum), (QFilter[])new QFilter[]{filter}, null) : QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.utils.ActualPriceCheckHelper.checkByDiffAlloc", (String)"cal_balance", (String)ActualPriceCheckHelper.getBalSelectFields(periodNum), (QFilter[])new QFilter[]{filter}, null);
        GroupbyDataSet groupbyDataSet = balSet.groupBy(new String[]{"calrangeid", "calrangenum", "calrangename", "materialid", "materialnum", "materialname"});
        groupbyDataSet.sum("periodbeginqty");
        groupbyDataSet.sum("periodbeginamount");
        groupbyDataSet.sum("periodinqty");
        groupbyDataSet.sum("periodinamount");
        groupbyDataSet.sum("periodoutqty");
        groupbyDataSet.sum("periodoutamount");
        groupbyDataSet.sum("periodendqty");
        groupbyDataSet.sum("periodendamount");
        balSet = groupbyDataSet.finish().select(new String[]{"calrangeid", "calrangenum", "calrangename", "materialid", "materialnum", "materialname", "case when periodbeginqty + periodinqty != 0 then (periodbeginamount + periodinamount)/(periodbeginqty + periodinqty) else 0 end as inprice", "case when periodoutqty != 0 then periodoutamount/periodoutqty else 0 end as outprice", "case when periodendqty != 0 then periodendamount/periodendqty else 0 end as endprice"});
        balSet = balSet.filter(" inprice <> 0 and (outprice <> 0 or endprice <> 0)");
        balSet = balSet.select(new String[]{"calrangeid", "calrangenum", "calrangename", "materialid", "materialnum", "materialname", "case when outprice <> 0 then inprice - outprice else 0 end as outPriceDiff", "case when endprice <> 0 then inprice - endprice else 0 end as endPriceDiff"});
        balSet = balSet.filter(" outPriceDiff > 0.1 or endPriceDiff > 0.1 or outPriceDiff < -0.1 or endPriceDiff < -0.1");
        StringBuilder alterSb = new StringBuilder();
        HashMap<String, StringBuilder> messages = new HashMap<String, StringBuilder>(16);
        for (Row row : balSet) {
            BigDecimal diffPrice = BigDecimal.ZERO;
            diffPrice = row.getBigDecimal("outPriceDiff").abs().compareTo(row.getBigDecimal("endPriceDiff")) > 0 ? row.getBigDecimal("outPriceDiff").setScale(args.getAmtprecision(), RoundingMode.HALF_UP) : row.getBigDecimal("endPriceDiff").setScale(args.getAmtprecision(), RoundingMode.HALF_UP);
            String calrangenum = row.getString("calrangenum");
            String calrangename = row.getString("calrangename");
            String materialnum = row.getString("materialnum");
            String materialname = row.getString("materialname");
            if (messages.containsKey(calrangenum)) continue;
            StringBuilder message = new StringBuilder();
            message.append(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u3010%1$s/%2$s\u3011\u2014>\u7269\u6599:\u3010%3$s/%4$s\u3011\u4ef7\u683c\u5dee\u5f02\uff1a%5$s", (String)"ActualPriceCheckHelper_3", (String)"macc-sca-algox", (Object[])new Object[0]), calrangenum, calrangename, materialnum, materialname, diffPrice));
            messages.put(calrangenum, message);
        }
        for (Map.Entry message : messages.entrySet()) {
            alterSb = alterSb.append((CharSequence)message.getValue()).append("\u3002");
        }
        return alterSb.toString();
    }

    private static String getBalSelectFields(int periodNum) {
        String select = "calrange.id as calrangeid,calrange.number as calrangenum,calrange.name as calrangename,material.id as materialid,material.number as materialnum,material.name as materialname,case when period = " + periodNum + " then periodbeginqty else periodendqty  end as periodbeginqty,case when period = " + periodNum + " then beginstandardcost + periodbegincostdiff else periodendstandardcost + periodendcostdiff end as periodbeginamount,case when period = " + periodNum + " then periodinqty else 0 end as periodinqty,case when period = " + periodNum + " then periodinstandardcost + periodincostdiff else 0 end as periodinamount,case when period = " + periodNum + " then periodissueqty else 0 end as periodoutqty,case when period = " + periodNum + " then periodissuestandardcost + periodissuecostdiff else 0 end as periodoutamount,periodendqty as periodendqty,periodendstandardcost + periodendcostdiff as periodendamount";
        return select;
    }

    private static String getNewBalSelectFields(int periodNum) {
        String select = "calrange.id as calrangeid,calrange.number as calrangenum,calrange.name as calrangename,material.id as materialid,material.number as materialnum,material.name as materialname,case when period = " + periodNum + " then baseqty else baseqty_bal  end as periodbeginqty,case when period = " + periodNum + " then standardcost + costdiff else standardcost_bal + costdiff_bal end as periodbeginamount,case when period = " + periodNum + " then baseqty_in else 0 end as periodinqty,case when period = " + periodNum + " then standardcost_in + costdiff_in else 0 end as periodinamount,case when period = " + periodNum + " then baseqty_out else 0 end as periodoutqty,case when period = " + periodNum + " then standardcost_out + costdiff_out else 0 end as periodoutamount,baseqty_bal as periodendqty,standardcost_bal + costdiff_bal as periodendamount";
        return select;
    }
}

