/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.util.bitset.BitSetFactory;
import kd.bos.algo.util.bitset.LongBitSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.PeriodHelper;

public class BasicProductMfgFeeAllocHelper {
    public static final String MAT_USE_COLLECT = "matUseCollect";
    public static final String RESOURCE_USE_COLLECT = "resourceUseCollect";
    private Map<String, DynamicObject> orgIdCostCenterExpenseItemIdAndMfgStdMap = new HashMap<String, DynamicObject>(16);
    private Map<String, LongBitSet> costCenterShutProductInfo = new HashMap<String, LongBitSet>(16);

    public static void init(Long orgId, DynamicObject periodObj) {
        if (!CadEmptyUtils.isEmpty(orgId)) {
            BasicProductMfgFeeAllocHelper basicProductMfgFeeAllocHelper = new BasicProductMfgFeeAllocHelper();
            basicProductMfgFeeAllocHelper.orgIdCostCenterExpenseItemIdAndMfgStdMap = BasicProductMfgFeeAllocHelper.getOrgIdCostCenterExpenseItemIdAndStdMap(orgId);
            basicProductMfgFeeAllocHelper.costCenterShutProductInfo = BasicProductMfgFeeAllocHelper.getCostCenterShutProductInfo(periodObj, orgId);
        }
    }

    private static Map<String, LongBitSet> getCostCenterShutProductInfo(DynamicObject periodObj, Long orgId) {
        Map<String, Date> periodMap = PeriodHelper.getPeriodBeginDateAndEndDate(periodObj);
        Date startTime = periodMap.get("begindate");
        Date endTime = periodMap.get("enddate");
        String matUseCollect = "sca_matusecollect";
        String resourceUse = "sca_resourceuse";
        LongBitSet costCenterIdsWithMatUseCollect = BitSetFactory.createLong();
        LongBitSet costCenterIdsWithResourceUse = BitSetFactory.createLong();
        HashMap<String, LongBitSet> collectStrAndBigSetMap = new HashMap<String, LongBitSet>(16);
        QFilter bizDateFilter = new QFilter("bookdate", ">=", (Object)startTime).and(new QFilter("bookdate", "<=", (Object)endTime));
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
        QFilter[] qFilters = new QFilter[]{bizDateFilter, orgFilter};
        DynamicObjectCollection costCentersForMatUse = QueryServiceHelper.query((String)matUseCollect, (String)"costcenter", (QFilter[])qFilters);
        for (DynamicObject costCenterObj : costCentersForMatUse) {
            long costCenterId = costCenterObj.getLong("costcenter");
            costCenterIdsWithMatUseCollect.set(costCenterId);
        }
        DynamicObjectCollection costCentersForResourceUse = QueryServiceHelper.query((String)resourceUse, (String)"costcenter", (QFilter[])qFilters);
        for (DynamicObject costCenterObj : costCentersForResourceUse) {
            long costCenterId = costCenterObj.getLong("costcenter");
            costCenterIdsWithResourceUse.set(costCenterId);
        }
        collectStrAndBigSetMap.put(MAT_USE_COLLECT, costCenterIdsWithMatUseCollect);
        collectStrAndBigSetMap.put(RESOURCE_USE_COLLECT, costCenterIdsWithResourceUse);
        return collectStrAndBigSetMap;
    }

    private static Map<String, DynamicObject> getOrgIdCostCenterExpenseItemIdAndStdMap(Long orgId) {
        HashMap<String, DynamicObject> orgIdCostCenterIdAndStdMap = new HashMap<String, DynamicObject>(16);
        QFilter orgIdFilter = new QFilter("org", "=", (Object)orgId);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        String selectFields = "org,costcenter,noproduction,entryentity.expenseitem expenseitem";
        QFilter[] qFilters = new QFilter[]{orgIdFilter, billStatusFilter};
        DynamicObjectCollection stdList = QueryServiceHelper.query((String)"sca_mfgfeeallocstdnew", (String)selectFields, (QFilter[])qFilters);
        if (stdList != null) {
            for (DynamicObject entity : stdList) {
                Long org = entity.getLong("org");
                long costCenterId = entity.getLong("costcenter");
                long expenseItemId = entity.getLong("expenseitem");
                String key = org + "@" + costCenterId + "@" + expenseItemId;
                orgIdCostCenterIdAndStdMap.put(key, entity);
            }
        }
        return orgIdCostCenterIdAndStdMap;
    }

    public Map<String, DynamicObject> getOrgIdCostCenterExpenseItemIdAndMfgStdMap() {
        return this.orgIdCostCenterExpenseItemIdAndMfgStdMap;
    }

    public Map<String, LongBitSet> getCostCenterShutProductInfo() {
        return this.costCenterShutProductInfo;
    }
}

