/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.utils.CommonUtils;
import kd.macc.sca.algox.utils.FinishCalcHelper;
import kd.macc.sca.algox.utils.LogHelper;
import kd.macc.sca.algox.utils.LowTimer;
import kd.macc.sca.algox.utils.PeriodHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.algox.wip.input.CalcDataArgs;

public class CalcResultHelper {
    public static void genCalcTotalResult(CalcDataArgs args) {
        String alokey = "kd.macc.sca.algox.utils.CalcResultHelper.genCalcTotalResult";
        if (args.isNullReqField()) {
            return;
        }
        HashSet<Long> finishedCostObject = new HashSet();
        if ("1".equals(args.getMatCalType())) {
            finishedCostObject = FinishCalcHelper.getFinishedCostObject(args);
        }
        Map<String, Date> date = PeriodHelper.getStartAndEndTimeByPeriod(Long.valueOf(args.getPeriodId().toString()));
        QFilter bizDate = new QFilter("bizDate", "<=", (Object)date.get("enddate"));
        bizDate.and(new QFilter("bizDate", ">=", (Object)date.get("begindate")));
        QFilter wipFilter = new QFilter("billstatus", "=", (Object)"C");
        wipFilter.and(new QFilter("accountorg", "=", args.getOrgId()));
        wipFilter.and(new QFilter("costobject", "in", args.getCostObjects()));
        QFilter appnumQf = new QFilter("appnum", "=", (Object)"sca");
        DataSet planQty = QueryServiceHelper.queryDataSet((String)alokey, (String)"cad_plannedoutputbill", (String)(Long.valueOf(args.getOrgId().toString()) + " orgid,costcenter.masterid costcenterid," + Long.valueOf(args.getCostAcctId().toString()) + " costaccountid," + Long.valueOf(args.getPeriodId().toString()) + " periodid,costobject.id costobjectid,0.0 pdcompqty,qty pdcurrqty,0 pdendqty,0.0 totalqty,0.0 stdqty,0.0 pdstartqty,0.0 pdstartamount,0.0 pdcurramount,0.0 pdcompanount,0.0 pdendamount,0.0 totalamount,0.0 stdamount,0.0 diff,0.0 costupdatediffamt"), (QFilter[])new QFilter[]{wipFilter, bizDate, appnumQf}, null);
        QFilter orgAndCcFilter = FinishCalcHelper.getOrgAndCostCenterFilter(args);
        QFilter costObjectFilter = new QFilter("entryentity.costobject", "in", args.getCostObjects());
        QFilter billstatus = new QFilter("billstatus", "=", (Object)"C");
        DataSet finishInputQty = QueryServiceHelper.queryDataSet((String)alokey, (String)"cad_factnedoutputbill", (String)(Long.valueOf(args.getOrgId().toString()) + " orgid,costcenter.masterid costcenterid," + Long.valueOf(args.getCostAcctId().toString()) + " costaccountid," + Long.valueOf(args.getPeriodId().toString()) + " periodid,entryentity.costobject.id costobjectid,entryentity.qty pdcompqty,0.0 pdcurrqty,0.0 pdendqty,0.0 totalqty,0.0 stdqty,0.0 pdstartqty,0.0 pdstartamount,0.0 pdcurramount,0.0 pdcompanount,0.0 pdendamount,0.0 totalamount,0.0 stdamount,0.0 diff,0.0 costupdatediffamt"), (QFilter[])new QFilter[]{orgAndCcFilter, costObjectFilter, billstatus, bizDate, appnumQf}, null);
        QFilter calcTypeFilter = new QFilter("entryentity.caltype", "=", (Object)"5");
        Long prePeriodId = PeriodHelper.getPrePeriodId(args.getPeriodId());
        orgAndCcFilter = FinishCalcHelper.getCommonFilter(args, false, false, true);
        QFilter periodFilter = new QFilter("period", "=", (Object)prePeriodId);
        QFilter coFilter = new QFilter("costobject", "in", args.getCostObjects());
        DataSet prePeriodQty = QueryServiceHelper.queryDataSet((String)alokey, (String)"sca_calcresult", (String)(" org.masterid orgid,costcenter.masterid costcenterid,costaccount.masterid costaccountid," + prePeriodId + " periodid,costobject.id costobjectid,0.0 pdcompqty,0.0 pdcurrqty,0.0 pdendqty,entryentity.totalqty totalqty,entryentity.stdqty stdqty,entryentity.pdendqty pdstartqty,0.0 pdstartamount,0.0 pdcurramount,0.0 pdcompanount,0.0 pdendamount,0.0 totalamount,0.0 stdamount,0.0 diff,0.0 costupdatediffamt"), (QFilter[])new QFilter[]{orgAndCcFilter, coFilter, periodFilter, calcTypeFilter}, null);
        QFilter dataTypeFilter = new QFilter("entryentity.datatype", "in", (Object)new String[]{"2"});
        QFilter commonFilter = FinishCalcHelper.getCommonFilter(args);
        DataSet amountData = QueryServiceHelper.queryDataSet((String)alokey, (String)"sca_calcresult", (String)" org.masterid orgid,costcenter.masterid costcenterid,costaccount.masterid costaccountid,period.id periodid,costobject.id costobjectid,0.0 pdcompqty,0.0 pdcurrqty,0.0 pdendqty,0.0 totalqty,0.0 stdqty,0.0 pdstartqty,entryentity.pdstartamount pdstartamount,entryentity.pdcurramount pdcurramount,entryentity.pdcompanount pdcompanount,entryentity.pdendamount pdendamount,entryentity.totalamount totalamount,entryentity.stdamount stdamount,entryentity.diff diff,entryentity.costupdatediffamt costupdatediffamt", (QFilter[])new QFilter[]{commonFilter, dataTypeFilter}, null);
        DataSet allData = planQty.union(finishInputQty).union(prePeriodQty).union(amountData);
        allData = CalcResultHelper.groupSumData(allData);
        DynamicObject[] calcResults = BusinessDataServiceHelper.load((String)"sca_calcresult", (String)"org,costcenter,costaccount,period,costobject,entryentity.pdcompqty,entryentity.pdcurrqty,entryentity.pdendqty,entryentity.totalqty,entryentity.stdqty,entryentity.pdstartqty,entryentity.pdstartamount,entryentity.pdcurramount,entryentity.pdcompanount,entryentity.pdendamount,entryentity.totalamount,entryentity.stdamount,entryentity.diff,entryentity.costupdatediffamt,entryentity.caltype,entryentity.datatype", (QFilter[])new QFilter[]{commonFilter});
        HashMap<String, DynamicObject> calcResultMap = new HashMap<String, DynamicObject>();
        for (DynamicObject calcRs : calcResults) {
            if (calcResultMap.containsKey(calcRs.getString("costobject.id"))) continue;
            calcResultMap.put(calcRs.getString("costobject.id"), calcRs);
        }
        CalcResultHelper.saveDB(args, allData, calcResultMap, finishedCostObject);
    }

    private static void saveDB(CalcDataArgs args, DataSet allData, Map<String, DynamicObject> calcResultMap, Set<Long> finishedCostObject) {
        if (allData.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> finishCalc = new ArrayList<DynamicObject>(10);
        HashMap<String, Long> successCoCounts = new HashMap<String, Long>();
        for (Row row : allData) {
            if (!successCoCounts.containsKey(row.getString("costcenterid"))) {
                successCoCounts.put(row.getString("costcenterid"), 1L);
            } else {
                Long currSuccess = (Long)successCoCounts.get(row.getString("costcenterid"));
                currSuccess = currSuccess + 1L;
                successCoCounts.put(row.getString("costcenterid"), currSuccess);
            }
            DynamicObject calcResulttemp = calcResultMap.get(row.getString("costobjectid"));
            if (calcResulttemp == null) {
                calcResulttemp = BusinessDataServiceHelper.newDynamicObject((String)"sca_calcresult");
                calcResulttemp.set("org", args.getOrgId());
                calcResulttemp.set("costaccount", args.getCostAcctId());
                calcResulttemp.set("period", args.getPeriodId());
                calcResulttemp.set("costcenter", row.get("costcenterid"));
                calcResulttemp.set("costobject", row.get("costobjectid"));
                calcResulttemp.set("currency", args.getCurrencyId());
                calcResulttemp.set("billno", (Object)("NO." + System.currentTimeMillis()));
                calcResulttemp.set("bizdate", TimeUtils.compareToEndDate(args.getEndDate()));
                calcResulttemp.set("billstatus", (Object)"A");
                calcResulttemp.set("bizstatus", (Object)"A");
                finishCalc.add(calcResulttemp);
            }
            DynamicObjectCollection entrys = calcResulttemp.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entrys.addNew();
            entry.set("caltype", (Object)"5");
            if ("1".equals(args.getMatCalType())) {
                entry.set("datatype", (Object)"99");
            } else {
                entry.set("datatype", (Object)"98");
            }
            List<String> groupKeys = Arrays.asList("pdstartqty", "pdcompqty", "pdcurrqty", "pdendqty", "totalqty", "stdqty", "pdstartqty", "pdstartamount", "pdcurramount", "pdcompanount", "pdendamount", "totalamount", "stdamount", "diff", "costupdatediffamt");
            for (int i = 0; i < groupKeys.size(); ++i) {
                String field = groupKeys.get(i);
                entry.set(field, row.get(field));
            }
            if (finishedCostObject.contains(row.getLong("costobjectid"))) {
                entry.set("pdendqty", (Object)0);
            } else {
                entry.set("pdendqty", (Object)row.getBigDecimal("pdstartqty").add(row.getBigDecimal("pdcurrqty")).subtract(row.getBigDecimal("pdcompqty")));
            }
            entry.set("totalqty", (Object)row.getBigDecimal("totalqty").add(row.getBigDecimal("pdcompqty")));
            entry.set("stdqty", (Object)row.getBigDecimal("totalqty").add(row.getBigDecimal("pdcompqty")));
        }
        LowTimer timer = new LowTimer();
        SaveServiceHelper.save((DynamicObject[])calcResultMap.values().toArray(new DynamicObject[0]));
        LogHelper.writeLog(ResManager.loadKDString((String)"CalcResultHelper\u4fdd\u5b58\u6570\u636e\u5b8c\u6210", (String)"CalcResultHelper_0", (String)"macc-sca-algox", (Object[])new Object[0]), timer.msValue());
        if (finishCalc.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])finishCalc.toArray(new DynamicObject[0]));
        }
        CalcResultHelper.analysisCoscenter(args, successCoCounts);
    }

    private static DataSet groupSumData(DataSet allDataSet) {
        GroupbyDataSet groupDataSet = allDataSet.groupBy(new String[]{"orgid", "costaccountid", "costcenterid", "costobjectid"});
        groupDataSet.sum("pdstartqty");
        groupDataSet.sum("pdstartamount");
        groupDataSet.sum("pdcurrqty");
        groupDataSet.sum("pdcurramount");
        groupDataSet.sum("pdcompqty");
        groupDataSet.sum("pdcompanount");
        groupDataSet.sum("pdendqty");
        groupDataSet.sum("pdendamount");
        groupDataSet.sum("diff");
        groupDataSet.sum("totalqty");
        groupDataSet.sum("totalamount");
        groupDataSet.sum("stdqty");
        groupDataSet.sum("stdamount");
        groupDataSet.sum("costupdatediffamt");
        return groupDataSet.finish();
    }

    private static void analysisCoscenter(CalcDataArgs args, Map<String, Long> successCoCounts) {
        Map<String, Long> conditionCoCountsInfo = args.getCcAndCoInfos();
        if (args.getCcAndCoInfos() == null) {
            return;
        }
        int costcenterSuccess = 0;
        int costcenterFail = 0;
        long costobjectSuccess = 0L;
        for (Map.Entry<String, Long> entry : conditionCoCountsInfo.entrySet()) {
            String key = entry.getKey();
            if (successCoCounts.get(key) == null || !entry.getValue().equals(successCoCounts.get(key))) {
                ++costcenterFail;
                continue;
            }
            ++costcenterSuccess;
            costobjectSuccess += successCoCounts.get(key).longValue();
        }
        args.setSuccessCcCount(costcenterSuccess);
        args.setFailCcCount(costcenterFail);
        args.setSuccessCoCount(costobjectSuccess);
    }

    public static void updateBizStatus(List<Object> calcResultIds, String bizSattus) {
        if (calcResultIds == null || calcResultIds.size() == 0) {
            return;
        }
        String ids = StringUtils.join((Object[])calcResultIds.toArray(), (String)",");
        String exeSql = "update t_sca_calcresult set fbizstatus='" + bizSattus + "' where FId in( " + ids + ") ";
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)exeSql);
    }

    public static void updateDiff(List<Object> calcResultIds, String operType) {
        if (calcResultIds == null || calcResultIds.size() == 0) {
            return;
        }
        String ids = StringUtils.join((Object[])calcResultIds.toArray(), (String)",");
        String exeSql = null;
        exeSql = "1".equals(operType) ? CalcResultHelper.getConfirmCalcEntrySql(ids) : CalcResultHelper.getUnConfirmCalcEntrySql(ids);
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)exeSql);
    }

    private static String getConfirmCalcEntrySql(String ids) {
        return "update t_sca_calcresultentry set fdiffqty = fpdendqty, fdiff= fpdendamount, fpdendqty = 0, fpdendamount = 0 where FId in( " + ids + ") ";
    }

    private static String getUnConfirmCalcEntrySql(String ids) {
        return "update t_sca_calcresultentry set fpdendqty = fdiffqty, fpdendamount = fdiff, fdiffqty = 0, fdiff = 0 where FId in(" + ids + ") ";
    }

    public static String getCalcRsComFields() {
        return "org.id orgid,costaccount.masterid costaccountid,costobject.id costobjectid,costcenter.masterid costcenterid,period.id periodid,entryentity.element.masterid elementid,entryentity.subelement.masterid subelementid, entryentity.material.id materialid,entryentity.auxpty.id auxptyid, entryentity.matversion.id matversionid,TO_INT(entryentity.datatype) datatype,entryentity.difftype difftype";
    }

    public static String getCalcRsQtyAmtFields() {
        return "entryentity.pdstartqty pdstartqty,entryentity.pdstartamount pdstartamount,entryentity.pdcurrqty pdcurrqty,entryentity.pdcurramount pdcurramount,entryentity.pdcompqty pdcompqty,entryentity.pdcompanount pdcompanount,entryentity.pdendqty pdendqty,entryentity.pdendamount pdendamount,entryentity.diff diff ";
    }

    public static String getCalcRsPrePeriodQtyAmtFields() {
        return "entryentity.pdendqty pdstartqty,entryentity.pdendamount pdstartamount,0 pdcurrqty,0 pdcurramount,0 pdcompqty,0 pdcompanount,0 pdendqty,0 pdendamount,0 diff ";
    }

    public static String getCalcRstaTotalQtyAmtFields() {
        return "entryentity.totalqty totalqty,entryentity.totalamount totalamount,entryentity.stdqty totalstdqty,entryentity.stdamount totalstdamount";
    }
}

