/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.sca.algox.finish.checker.ICalcCheckInterface;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class CheckHelper {
    private static final Log logger = LogFactory.getLog(CheckHelper.class);
    private static final Long CENTER_MANUORG_ID = 1317214147611471872L;

    public static QFilter getCommonFilter(JSONObject checkParamJs) {
        QFilter filter = new QFilter("org", "=", (Object)checkParamJs.getLong("org"));
        filter.and(new QFilter("costaccount", "=", (Object)checkParamJs.getLong("costaccount")));
        filter.and(new QFilter("period", "=", (Object)checkParamJs.getLong("period")));
        if (checkParamJs.getJSONArray("costcenters") != null && checkParamJs.getJSONArray("costcenters").size() > 0) {
            filter.and(new QFilter("costcenter", "in", (Object)checkParamJs.getJSONArray("costcenters")));
        }
        if (checkParamJs.containsKey((Object)"manuOrgIds") && checkParamJs.getJSONArray("manuOrgIds") != null && checkParamJs.getJSONArray("manuOrgIds").size() > 0) {
            filter.and(new QFilter("manuorg", "in", (Object)checkParamJs.getJSONArray("manuOrgIds")));
        }
        return filter;
    }

    public static QFilter getCommonFilter(CalcCheckContext checkParamJs) {
        QFilter filter = new QFilter("org", "=", (Object)checkParamJs.getOrgId());
        filter.and(new QFilter("costaccount", "=", (Object)checkParamJs.getCostAccountId()));
        filter.and(new QFilter("period", "=", (Object)checkParamJs.getPeriodId()));
        if (checkParamJs.getCostCenterIds() != null && checkParamJs.getCostCenterIds().size() > 0) {
            filter.and(new QFilter("costcenter", "in", (Object)checkParamJs.getCostCenterIds()));
        }
        if (checkParamJs.getManuOrgIds() != null && checkParamJs.getManuOrgIds().size() > 0) {
            filter.and(new QFilter("manuorg", "in", (Object)checkParamJs.getManuOrgIds()));
        }
        return filter;
    }

    public static QFilter getOrgAndCostCenterFilter(JSONObject checkParamJs) {
        QFilter filter = new QFilter("org", "=", (Object)checkParamJs.getLong("org"));
        if (checkParamJs.getJSONArray("costcenters") != null && checkParamJs.getJSONArray("costcenters").size() > 0) {
            filter.and(new QFilter("costcenter", "in", (Object)checkParamJs.getJSONArray("costcenters")));
        }
        if (checkParamJs.containsKey((Object)"manuOrgIds") && checkParamJs.getJSONArray("manuOrgIds") != null && checkParamJs.getJSONArray("manuOrgIds").size() > 0) {
            filter.and(new QFilter("manuorg", "in", (Object)checkParamJs.getJSONArray("manuOrgIds")));
        }
        return filter;
    }

    public static DynamicObject getCheckResultNewEntry(String checkParam) {
        JSONObject checkParamJs = JSONObject.fromObject((Object)checkParam);
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingle((Object)checkParamJs.getLong("checkResultId"), (String)"sca_checkresult");
        DynamicObjectCollection entrys = checkResult.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entrys.addNew();
        entry.set("seq", (Object)entrys.size());
        entry.set("item", (Object)checkParamJs.getString("itemDesc"));
        return entry;
    }

    public static Long doCheck(String param) {
        JSONObject checkparam = JSONObject.fromObject((Object)param);
        Long checkResultId = CheckHelper.initCheckReuslt(checkparam);
        CheckHelper.doCheck(checkparam, checkResultId);
        CheckHelper.updateTask(checkparam, checkResultId);
        return checkResultId;
    }

    public static int getCheckFailCount(Long checkResultId) {
        QFilter filter = new QFilter("id", "=", (Object)checkResultId);
        filter.and(new QFilter("entryentity.result", "=", (Object)"2"));
        DynamicObjectCollection checkFailRs = QueryServiceHelper.query((String)"sca_checkresult", (String)"entryentity.id", (QFilter[])new QFilter[]{filter});
        return CadEmptyUtils.isEmpty(checkFailRs) ? 0 : checkFailRs.size();
    }

    public static Boolean getCheckResult(Long checkResultId, Long[] checkItemId) {
        QFilter filter = new QFilter("id", "=", (Object)checkResultId);
        filter.and(new QFilter("entryentity.result", "=", (Object)"2"));
        filter.and(new QFilter("entryentity.id", "in", (Object)checkItemId));
        DynamicObjectCollection chekcResult = QueryServiceHelper.query((String)"sca_checkresult", (String)"entryentity.id", (QFilter[])new QFilter[]{filter});
        return chekcResult.size() == 0;
    }

    private static void doCheck(JSONObject checkparam, Long checkResultId) {
        checkparam.accumulate("checkResultId", (Object)checkResultId);
        long orgId = checkparam.getLong("org");
        boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        QFilter filter = new QFilter("id", "=", (Object)checkparam.getLong("checkConfigId"));
        DynamicObjectCollection checkItems = QueryServiceHelper.query((String)"sca_checkconfig", (String)CheckHelper.getCheckItemsField(), (QFilter[])new QFilter[]{filter}, (String)"entryentity.sort");
        if (checkItems != null && checkItems.size() > 0) {
            for (int index = 0; index < checkItems.size(); ++index) {
                DynamicObject checkItem = (DynamicObject)checkItems.get(index);
                String policyclass = checkItem.getString("class");
                checkparam.remove("itemDesc");
                checkparam.accumulate("itemDesc", (Object)checkItem.getString("desc"));
                if (!isOrgEnableMultiFactory && CENTER_MANUORG_ID.equals(checkItem.getLong("entryId"))) continue;
                try {
                    Class<?> checkerClass = Class.forName(policyclass);
                    ICalcCheckInterface checker = (ICalcCheckInterface)checkerClass.newInstance();
                    checker.doCheck(checkparam.toString());
                    continue;
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    private static void updateTask(JSONObject checkparam, Long checkResultId) {
        QFilter filter = new QFilter("id", "=", (Object)checkparam.getLong("taskRecordId"));
        Object[] taskRecord = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"nextpagepara,progress,status", (QFilter[])new QFilter[]{filter});
        if (!CadEmptyUtils.isEmpty(taskRecord)) {
            if ("2".equals(taskRecord[0].getString("status"))) {
                taskRecord[0].set("status", (Object)"4");
            }
            JSONObject subPagePara = new JSONObject();
            subPagePara.accumulate("checkResultId", (Object)checkResultId);
            taskRecord[0].set("nextpagepara", (Object)subPagePara.toString());
            SaveServiceHelper.update((DynamicObject)taskRecord[0]);
        }
    }

    private static String getCheckItemsField() {
        return "entryentity.class class,entryentity.desc desc, entryentity.id entryId";
    }

    private static Long initCheckReuslt(JSONObject checkparam) {
        DynamicObject checkresultInfo = BusinessDataServiceHelper.newDynamicObject((String)"sca_checkresult");
        Long checkresultId = DBServiceHelper.genGlobalLongId();
        checkresultInfo.set("id", (Object)checkresultId);
        checkresultInfo.set("org", (Object)checkparam.getString("org"));
        checkresultInfo.set("costaccount", (Object)checkparam.getString("costaccount"));
        checkresultInfo.set("period", (Object)checkparam.getString("period"));
        checkresultInfo.set("checkdate", (Object)new Date());
        CheckHelper.setMulControlVal(checkparam, checkresultInfo, "manuOrgIds", "manuorg");
        CheckHelper.setMulControlVal(checkparam, checkresultInfo, "costcenters", "costcenter");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkresultInfo});
        return checkresultId;
    }

    private static void setMulControlVal(JSONObject checkparam, DynamicObject checkresultInfo, String jsonKey, String formKey) {
        DynamicObject[] costcentersParam;
        if (!checkparam.containsKey((Object)jsonKey)) {
            return;
        }
        JSONArray costCenterArray = checkparam.getJSONArray(jsonKey);
        Object[] costcenterIds = new Object[costCenterArray.size()];
        for (int index = 0; index < costCenterArray.size(); ++index) {
            Object costCenterId = costCenterArray.get(index);
            if (costCenterId == null) continue;
            costcenterIds[index] = costCenterId;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"sca_checkresult");
        MulBasedataProp mulBasedataProp = (MulBasedataProp)mainType.findProperty(formKey);
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        DynamicObjectCollection rows = (DynamicObjectCollection)mulBasedataProp.getValue((Object)checkresultInfo);
        for (DynamicObject cc : costcentersParam = BusinessDataServiceHelper.load((Object[])costcenterIds, (DynamicObjectType)basedataProp.getDynamicComplexPropertyType())) {
            DynamicObject newRow = new DynamicObject(subEntityType);
            rows.add((Object)newRow);
            basedataProp.setValue((Object)newRow, (Object)cc);
        }
    }
}

