/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.wip.input.CalcDataArgs;

public class CostAbsorbAdjustHelper {
    public static Map<Object, List<Row>> getAbsorbAdjustMap(Object[] costObjectIds, CalcDataArgs args) {
        HashMap<Object, List<Row>> resultMap = new HashMap<Object, List<Row>>(16);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        args.warpQFilter4Period(filters, "org", true);
        filters.add(new QFilter("costobject", "in", (Object)costObjectIds));
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        String selectFields = "costobject,difftype,resource,entryentity.element as element,entryentity.subelement as subelement,entryentity.amount as amount,costcenter,costaccount";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)CostAbsorbAdjustHelper.class.getName(), (String)"sca_absorbadjust", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            for (Row row : ds.groupBy(new String[]{"costobject", "difftype", "resource", "element", "subelement", "costcenter", "costaccount"}).sum("amount").finish()) {
                List value = resultMap.computeIfAbsent(row.get("costobject"), s -> new ArrayList());
                value.add(row);
            }
        }
        return resultMap;
    }

    private static void addEntry(String calType, DynamicObjectCollection entrys, Row row, String dataType) {
        DynamicObject entry = entrys.addNew();
        entry.set("element", row.get("element"));
        entry.set("subelement", row.get("subelement"));
        entry.set("resource", row.get("resource"));
        entry.set("material", (Object)0L);
        entry.set("matversion", (Object)0L);
        entry.set("auxpty", (Object)0L);
        entry.set("caltype", (Object)calType);
        entry.set("datatype", (Object)dataType);
        entry.set("pdcurrqty", (Object)BigDecimal.ZERO);
        entry.set("pdcurramount", (Object)row.getBigDecimal("amount"));
        entry.set("pdendamount", (Object)row.getBigDecimal("amount"));
        entry.set("difftype", (Object)row.getString("difftype"));
    }

    public static void handleAbsorbAdjust(Map<Object, DynamicObject> cacheSaveItemMap, Set<Object> costObjectIds, Map<Object, List<Row>> absorbCostAdjustMap, CalcDataArgs args) {
        ArrayList<DynamicObject> res = new ArrayList<DynamicObject>(16);
        MainEntityType calcResultType = EntityMetadataCache.getDataEntityType((String)"sca_calcresult");
        for (Object costObjectId : costObjectIds) {
            List<Row> adjustRows = absorbCostAdjustMap.get(costObjectId);
            if (CollectionUtils.isEmpty(adjustRows)) continue;
            DynamicObject saveItem = cacheSaveItemMap.computeIfAbsent(costObjectId, s -> new DynamicObject((DynamicObjectType)calcResultType));
            if (CadEmptyUtils.isEmpty(saveItem.getLong("id"))) {
                saveItem.set("org", args.getOrgId());
                saveItem.set("costaccount", args.getCostAcctId());
                saveItem.set("costcenter", adjustRows.get(0).get("costcenter"));
                saveItem.set("period", args.getPeriodId());
                saveItem.set("currency", args.getCurrencyId());
                saveItem.set("costobject", costObjectId);
                saveItem.set("billno", (Object)("NO." + System.currentTimeMillis()));
            }
            DynamicObjectCollection entrys = saveItem.getDynamicObjectCollection("entryentity");
            for (Row row : adjustRows) {
                CostAbsorbAdjustHelper.addEntry(args.getMfgCalType(), entrys, row, "3");
                CostAbsorbAdjustHelper.addEntry(args.getMfgCalType(), entrys, row, "1");
                CostAbsorbAdjustHelper.addEntry(args.getMfgCalType(), entrys, row, "2");
            }
            res.add(saveItem);
        }
        SaveServiceHelper.save((DynamicObject[])res.toArray(new DynamicObject[0]));
    }
}

