/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.sca.algox.costrec.CostRecCalcHelper;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.utils.CurrencyHelper;
import kd.macc.sca.algox.utils.FactCostReductTaskHelper;
import kd.macc.sca.algox.utils.PeriodHelper;
import kd.macc.sca.algox.utils.ReductCheckHelper;
import net.sf.json.JSONObject;

public class CostRecoveryHelper {
    private static final String ALGOKEY = "kd.macc.sca.algox.utils.CostRecoveryHelper";

    public static void buildUnRecoveryMaterial(CostRecoveryParams crParams, Set<Long> unRecoveryMaterialIdSet, Set<Long> unRecoverySubMaterialIdSet) {
        CostRecoveryHelper.buildUnRecoveryMaterial(crParams.getCalOrgId(), crParams.getCostAccountId(), crParams.getManuOrgId(), unRecoveryMaterialIdSet, unRecoverySubMaterialIdSet, null);
    }

    public static void buildUnRecoveryMaterial(Long orgId, Long costaccountId, Long manuOrgId, Set<Long> unRecoveryMaterialIdSet, Set<Long> unRecoverySubMaterialIdSet, Set<Long> matIdQueryLastMapSet) {
        QFilter unRecoveryFilter = new QFilter("org.id", "=", (Object)orgId);
        unRecoveryFilter.and("costaccount.id", "=", (Object)costaccountId);
        if (manuOrgId > 0L) {
            unRecoveryFilter.and("prdorg.id", "=", (Object)manuOrgId);
        }
        unRecoveryFilter.and("enable", "=", (Object)Boolean.TRUE);
        unRecoveryFilter.and("status", "=", (Object)Character.valueOf('C'));
        DataSet unRecoveryDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_matreductset", (String)"entryentity.material.id as materialId,entryentity.materialsort.id as materialsortId,entryentity.reductparaset as reductparaset", (QFilter[])unRecoveryFilter.toArray(), null);
        for (Row row : unRecoveryDataSet) {
            Long materialId = row.getLong("materialId");
            Long materialsortId = row.getLong("materialsortId");
            String reductparaset = row.getString("reductparaset");
            if (materialId != 0L) {
                if ("1".equals(reductparaset)) {
                    unRecoveryMaterialIdSet.add(materialId);
                    continue;
                }
                if ("2".equals(reductparaset)) {
                    unRecoverySubMaterialIdSet.add(materialId);
                    continue;
                }
                if (!"3".equals(reductparaset) || matIdQueryLastMapSet == null) continue;
                matIdQueryLastMapSet.add(materialId);
                continue;
            }
            if (materialsortId == 0L) continue;
            HashSet<Long> groupIds = new HashSet<Long>();
            groupIds.add(materialsortId);
            CostRecoveryHelper.getMaterialGroupSubData(materialsortId, groupIds);
            QFilter tmpFilter = new QFilter("group.id", "in", groupIds);
            DataSet tmpDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"bd_materialgroupdetail", (String)"material as id", (QFilter[])tmpFilter.toArray(), null);
            HashSet tmpMatIdSet = Sets.newHashSet();
            for (Row tmpRow : tmpDataSet) {
                tmpMatIdSet.add(tmpRow.getLong("id"));
            }
            if ("1".equals(reductparaset)) {
                unRecoveryMaterialIdSet.addAll(tmpMatIdSet);
                continue;
            }
            if ("2".equals(reductparaset)) {
                unRecoverySubMaterialIdSet.addAll(tmpMatIdSet);
                continue;
            }
            if (!"3".equals(reductparaset) || matIdQueryLastMapSet == null) continue;
            matIdQueryLastMapSet.addAll(tmpMatIdSet);
        }
    }

    private static void getMaterialGroupSubData(Long id, Set<Long> groupIds) {
        QFilter tmpFilter = new QFilter("parent", "=", (Object)id);
        DataSet tmpDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"bd_materialgroup", (String)"id,isleaf", (QFilter[])tmpFilter.toArray(), null);
        if (!tmpDataSet.isEmpty()) {
            while (tmpDataSet.hasNext()) {
                Boolean isleaf;
                Row row = tmpDataSet.next();
                Long pkid = row.getLong("id");
                if (!groupIds.add(pkid) || (isleaf = row.getBoolean("isleaf")) == null || isleaf.booleanValue()) continue;
                CostRecoveryHelper.getMaterialGroupSubData(pkid, groupIds);
            }
        }
    }

    @Deprecated
    public static Set<Long> getLeafMatIds(CostRecoveryParams crParams, Set<Long> manuCostObjectIdSet) {
        HashSet<Long> leafMatIds = new HashSet<Long>();
        HashSet<Long> unRecoveryMaterialIdSet = new HashSet<Long>();
        HashSet<Long> unRecoverySubMaterialIdSet = new HashSet<Long>();
        CostRecoveryHelper.buildUnRecoveryMaterial(crParams, unRecoveryMaterialIdSet, unRecoverySubMaterialIdSet);
        QFilter filter = new QFilter("costaccount", "=", (Object)crParams.getCostAccountId());
        filter.and("period", "=", (Object)crParams.getPeriodId());
        filter.and("prdorg", "=", (Object)crParams.getManuOrgId());
        DataSet bophalfStructureData = QueryServiceHelper.queryDataSet((String)"", (String)"sca_halfprdhide", (String)"material as materialid,entryentity.submaterial as submaterialid", (QFilter[])filter.toArray(), null);
        QFilter matFilter = new QFilter("costaccount", "=", (Object)crParams.getCostAccountId());
        matFilter.and("period", "=", (Object)crParams.getPeriodId());
        if (crParams.getManuOrgId() != 0L) {
            matFilter.and("manuorg", "=", (Object)crParams.getManuOrgId());
        }
        DataSet matAllocData = QueryServiceHelper.queryDataSet((String)"", (String)"sca_matalloc", (String)"entryentity.costobejctentry.material as materialid,material.id as submaterialid", (QFilter[])matFilter.toArray(), null);
        DataSet parentAndSubData1 = matAllocData.union(bophalfStructureData).groupBy(new String[]{"materialid", "submaterialid"}).finish();
        JoinDataSet joinData = parentAndSubData1.leftJoin(parentAndSubData1.copy()).on("submaterialid", "materialid");
        parentAndSubData1 = joinData.select(new String[]{"submaterialid"}, new String[]{"materialid"}).finish().filter(" materialid is null");
        for (Row row : parentAndSubData1) {
            leafMatIds.add(row.getLong("submaterialid"));
        }
        leafMatIds.addAll(unRecoveryMaterialIdSet);
        leafMatIds.addAll(unRecoverySubMaterialIdSet);
        return leafMatIds;
    }

    public static Set<Long> getLeafMatIds(Long orgId, Long costaccountId, Long manuOrgId, Long periodId) {
        HashSet<Long> leafMatIds = new HashSet<Long>();
        HashSet<Long> unRecoveryMaterialIdSet = new HashSet<Long>();
        HashSet<Long> unRecoverySubMaterialIdSet = new HashSet<Long>();
        CostRecoveryHelper.buildUnRecoveryMaterial(orgId, costaccountId, manuOrgId, unRecoveryMaterialIdSet, unRecoverySubMaterialIdSet, null);
        QFilter filter = new QFilter("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periodId);
        filter.and("prdorg", "=", (Object)manuOrgId);
        DataSet bophalfStructureData = QueryServiceHelper.queryDataSet((String)"", (String)"sca_halfprdhide", (String)"material as materialid,entryentity.submaterial as submaterialid", (QFilter[])filter.toArray(), null);
        QFilter matFilter = new QFilter("costaccount", "=", (Object)costaccountId);
        matFilter.and("period", "=", (Object)periodId);
        if (manuOrgId != 0L) {
            matFilter.and("manuorg", "=", (Object)manuOrgId);
        }
        DataSet matAllocData = QueryServiceHelper.queryDataSet((String)"", (String)"sca_matalloc", (String)"entryentity.costobejctentry.material as materialid,material.id as submaterialid", (QFilter[])matFilter.toArray(), null);
        DataSet parentAndSubData1 = matAllocData.union(bophalfStructureData).groupBy(new String[]{"materialid", "submaterialid"}).finish();
        JoinDataSet joinData = parentAndSubData1.leftJoin(parentAndSubData1.copy()).on("submaterialid", "materialid");
        parentAndSubData1 = joinData.select(new String[]{"submaterialid"}, new String[]{"materialid"}).finish().filter(" materialid is null");
        for (Row row : parentAndSubData1) {
            leafMatIds.add(row.getLong("submaterialid"));
        }
        leafMatIds.addAll(unRecoveryMaterialIdSet);
        leafMatIds.addAll(unRecoverySubMaterialIdSet);
        return leafMatIds;
    }

    public static List<Long> getOrgToStOrg(Long calorg) {
        HashSet prdStorgs = new HashSet();
        List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)calorg, (boolean)true);
        for (Long porg : productOrgs) {
            prdStorgs.addAll(OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)porg, (boolean)true));
        }
        List stOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)calorg, (boolean)true);
        stOrgs.removeAll(prdStorgs);
        return stOrgs;
    }

    public static void afterCalc(boolean isFail, CostRecoveryParams args, Long checkResultId) {
        DynamicObject taskRecord = FactCostReductTaskHelper.getLastTaskRecord(args.getTaskRecordId());
        Long time = taskRecord.getLong("time");
        Tuple<Integer, Integer> turper = ReductCheckHelper.getCostReductCalcReportEntryFailCount(checkResultId);
        Map<String, Integer> sucPrdMap = FactCostReductTaskHelper.getSucByCalcReportId(args.getCalcReportId());
        int sucOrgCnt = 0;
        int sucPrdCnt = 0;
        if (!isFail) {
            sucPrdCnt = sucPrdMap.get("productsize");
        }
        if (!isFail && (Integer)turper.item1 == 0) {
            sucOrgCnt = args.getRelationCostAccountIds().size();
        }
        int failOrgCnt = args.getRelationCostAccountIds().size() - sucOrgCnt;
        JSONObject pagePara = new JSONObject();
        HashSet<Long> relaCostaccountIds = new HashSet<Long>();
        relaCostaccountIds.addAll(args.getRelationCostAccountIds());
        relaCostaccountIds.remove(args.getCostAccountId());
        pagePara.accumulate("orgId", args.getCalOrgId());
        pagePara.accumulate("costAccountId", args.getCostAccountId());
        pagePara.accumulate("relaCostAccountIds", relaCostaccountIds);
        pagePara.accumulate("prdOrg", args.getManuOrgId());
        pagePara.accumulate("periodId", args.getPeriodId());
        pagePara.accumulate("time", (Object)time);
        pagePara.accumulate("checkFailCount", turper.item1);
        pagePara.accumulate("checkTipCount", turper.item2);
        pagePara.accumulate("isFail", isFail);
        pagePara.accumulate("checkResultId", (Object)checkResultId);
        pagePara.accumulate("calcReportId", (Object)args.getCalcReportId());
        pagePara.accumulate("sucOrgCnt", sucOrgCnt);
        pagePara.accumulate("failOrgCnt", failOrgCnt);
        pagePara.accumulate("sucPrdCnt", sucPrdCnt);
        pagePara.accumulate("calcManuOrgIds", args.getCalcManuOrgIds());
        pagePara.accumulate("currencyId", args.getCurrencyId());
        FactCostReductTaskHelper.updateNextPagePara(args.getTaskRecordId(), pagePara.toString());
    }

    public static String changeSomeValue(String param) {
        JSONObject json = JSONObject.fromObject((Object)param);
        json.accumulate("org", json.getLong("calOrgId"));
        json.accumulate("period", json.getLong("periodId"));
        json.accumulate("costaccount", json.getLong("costAccountId"));
        json.accumulate("prdorg", json.getLong("manuOrgId"));
        json.remove("startDate");
        return SerializationUtils.toJsonString((Object)json);
    }

    public static void setDefaultElementId(CostRecoveryParams crParams) {
        QFilter eleFilter = new QFilter("type", "=", (Object)"001");
        eleFilter.and("defaultvalue", "=", (Object)Boolean.TRUE);
        DynamicObject[] dyo = BusinessDataServiceHelper.load((String)"cad_subelement", (String)"id", (QFilter[])eleFilter.toArray(), (String)"id asc");
        crParams.setDefaultSubElementId(dyo[0].getLong("id"));
        eleFilter = new QFilter("subelement.id", "=", (Object)crParams.getDefaultSubElementId());
        dyo = BusinessDataServiceHelper.load((String)"cad_elementdetail", (String)"element.id", (QFilter[])eleFilter.toArray());
        crParams.setDefaultElementId(dyo[0].getLong("element.id"));
    }

    public static void logInfoIdSet(Log logger, String alias, Set idSet) {
        StringBuilder infoSb = new StringBuilder();
        infoSb.append("***");
        infoSb.append(alias);
        infoSb.append("-->");
        if (idSet != null) {
            for (Object id : idSet) {
                infoSb.append(",");
                infoSb.append(id);
            }
        }
        String tmp = infoSb.toString();
        while (tmp.length() > 8000) {
            logger.info(tmp.substring(0, 8000));
            tmp = tmp.substring(8000, tmp.length());
        }
        logger.info(tmp);
    }

    public static void setUnRecoveryMaterialIdSetting(Log logger, CostRecoveryParams crParams, Long reportId, DynamicObject[] costaccountColl, Map<Long, Set<Long>> unRecoveryMaterialIdMap, Map<Long, Set<Long>> unRecoverySubMaterialIdMap) {
        for (DynamicObject costaccountDyo : costaccountColl) {
            Long orgId = costaccountDyo.getLong("calorg.id");
            Long costaccountId = costaccountDyo.getLong("id");
            HashSet unRecoveryMaterialIdSet = Sets.newHashSet();
            HashSet unRecoverySubMaterialIdSet = Sets.newHashSet();
            CostRecoveryHelper.buildUnRecoveryMaterial(orgId, costaccountId, crParams.getManuOrgId(), unRecoveryMaterialIdSet, unRecoverySubMaterialIdSet, null);
            unRecoveryMaterialIdMap.put(costaccountId, unRecoveryMaterialIdSet);
            unRecoverySubMaterialIdMap.put(costaccountId, unRecoverySubMaterialIdSet);
            CostRecoveryHelper.logInfoIdSet(logger, String.format(ResManager.loadKDString((String)"%1$s:\u4e0d\u53c2\u4e0e\u8fd8\u539f\u7684\u7269\u6599ID,unRecoveryMaterialIdSet,costaccountId:%2$s", (String)"CostRecoveryHelper_4", (String)"macc-sca-algox", (Object[])new Object[0]), reportId, costaccountId), unRecoveryMaterialIdSet);
            CostRecoveryHelper.logInfoIdSet(logger, String.format(ResManager.loadKDString((String)"%1$s:\u672c\u8eab\u53c2\u4e0e\u8fd8\u539f\uff0c\u4e3a\u5b50\u9879\u65f6\u4e0d\u53c2\u4e0e\u8fd8\u539f\u7684\u7269\u6599ID,unRecoverySubMaterialIdSet,costaccountId:%2$s", (String)"CostRecoveryHelper_5", (String)"macc-sca-algox", (Object[])new Object[0]), reportId, costaccountId), unRecoverySubMaterialIdSet);
        }
    }

    public static void setUnRecoveryOrgMaterialIdSetting(Log logger, CostRecoveryParams crParams, Long reportId, DynamicObject[] costaccountColl, Map<String, Set<Long>> unRecoveryMaterialIdMap, Map<String, Set<Long>> unRecoverySubMaterialIdMap) {
        CostRecoveryHelper.setUnRecoveryOrgMaterialIdSetting(logger, crParams, reportId, costaccountColl, unRecoveryMaterialIdMap, unRecoverySubMaterialIdMap, null);
    }

    public static void setUnRecoveryOrgMaterialIdSetting(Log logger, CostRecoveryParams crParams, Long reportId, DynamicObject[] costaccountColl, Map<String, Set<Long>> unRecoveryMaterialIdMap, Map<String, Set<Long>> unRecoverySubMaterialIdMap, Map<String, Set<Long>> matIdQueryLastMap) {
        for (DynamicObject costaccountDyo : costaccountColl) {
            Long orgId = costaccountDyo.getLong("calorg.id");
            Long costaccountId = costaccountDyo.getLong("id");
            if (SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(crParams.getCalDimension())) {
                List manuOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)true);
                for (Long manuorg : manuOrgs) {
                    if (crParams.getManuOrgId() != 0L && crParams.getManuOrgId() != manuorg.longValue()) continue;
                    HashSet unRecoveryMaterialIdSet = Sets.newHashSet();
                    HashSet unRecoverySubMaterialIdSet = Sets.newHashSet();
                    HashSet matIdQueryLastSet = Sets.newHashSet();
                    CostRecoveryHelper.buildUnRecoveryMaterial(orgId, costaccountId, manuorg, unRecoveryMaterialIdSet, unRecoverySubMaterialIdSet, matIdQueryLastSet);
                    List stOrgs = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuorg, (boolean)true);
                    for (Long storg : stOrgs) {
                        String key = String.format("%s@%s", orgId, storg);
                        unRecoveryMaterialIdMap.put(key, unRecoveryMaterialIdSet);
                        unRecoverySubMaterialIdMap.put(key, unRecoverySubMaterialIdSet);
                        if (CollectionUtils.isEmpty((Collection)matIdQueryLastSet) || matIdQueryLastMap == null) continue;
                        matIdQueryLastMap.put(key, matIdQueryLastSet);
                    }
                    CostRecoveryHelper.logInfoIdSet(logger, String.format(ResManager.loadKDString((String)"%1$s:\u4e0d\u53c2\u4e0e\u8fd8\u539f\u7684\u7269\u6599ID,unRecoveryMaterialIdSet,costaccountId:%2$s,manuorgId:%3$s", (String)"CostRecoveryHelper_6", (String)"macc-sca-algox", (Object[])new Object[0]), reportId, costaccountId, manuorg), unRecoveryMaterialIdSet);
                    CostRecoveryHelper.logInfoIdSet(logger, String.format(ResManager.loadKDString((String)"%1$s:\u672c\u8eab\u53c2\u4e0e\u8fd8\u539f\uff0c\u4e3a\u5b50\u9879\u65f6\u4e0d\u53c2\u4e0e\u8fd8\u539f\u7684\u7269\u6599ID,unRecoverySubMaterialIdSet,costaccountId:%2$s,manuorgId:%3$s", (String)"CostRecoveryHelper_7", (String)"macc-sca-algox", (Object[])new Object[0]), reportId, costaccountId, manuorg), unRecoverySubMaterialIdSet);
                }
                continue;
            }
            HashSet unRecoveryMaterialIdSet = Sets.newHashSet();
            HashSet unRecoverySubMaterialIdSet = Sets.newHashSet();
            HashSet matIdQueryLastSet = Sets.newHashSet();
            String key = String.format("%s@0", orgId);
            CostRecoveryHelper.buildUnRecoveryMaterial(orgId, costaccountId, 0L, unRecoveryMaterialIdSet, unRecoverySubMaterialIdSet, matIdQueryLastSet);
            if (!CollectionUtils.isEmpty((Collection)unRecoveryMaterialIdSet)) {
                unRecoveryMaterialIdMap.put(key, unRecoveryMaterialIdSet);
            }
            if (!CollectionUtils.isEmpty((Collection)unRecoverySubMaterialIdSet)) {
                unRecoverySubMaterialIdMap.put(key, unRecoverySubMaterialIdSet);
            }
            if (CollectionUtils.isEmpty((Collection)matIdQueryLastSet) || matIdQueryLastMap == null) continue;
            matIdQueryLastMap.put(key, matIdQueryLastSet);
        }
    }

    public static DynamicObject[] setCommonAttribute(CostRecoveryParams crParams) {
        DynamicObject[] costaccountColl;
        Date[] dateArr;
        crParams.setNextPeriodId(PeriodHelper.getNextPeriod(crParams.getPeriodId()).getLong("id"));
        crParams.setCurrencyId(CurrencyHelper.getCurrencyByCostAccountId(crParams.getCostAccountId()));
        crParams.setAmtScale(CurrencyHelper.getAmtSacleByCurrencyId(crParams.getCurrencyId()));
        crParams.setPriceScale(CurrencyHelper.getPriceSacleByCurrencyId(crParams.getCurrencyId()));
        crParams.setPriceSaveScale(crParams.getPriceScale());
        int preci = CadBgParamUtils.getCadParamForInt((String)"costrec_pripreci", (int)999);
        if (preci != 999) {
            crParams.setPriceSaveScale(preci);
        }
        if (crParams.getStartDate() == null && (dateArr = PeriodHelper.getPeriodStartAndEndTime(crParams.getPeriodId())) != null) {
            crParams.setStartDate(dateArr[0]);
            crParams.setEndDate(dateArr[1]);
        }
        if (crParams.getRelationCostAccountIds() == null) {
            crParams.setRelationCostAccountIds(Sets.newHashSet());
        }
        crParams.getRelationCostAccountIds().add(crParams.getCostAccountId());
        HashSet calOrgIdSet = Sets.newHashSetWithExpectedSize((int)64);
        for (DynamicObject dynamicObject : costaccountColl = BusinessDataServiceHelper.load((String)"cal_bd_costaccount", (String)"calorg.id", (QFilter[])new QFilter[]{new QFilter("id", "in", crParams.getRelationCostAccountIds())})) {
            calOrgIdSet.add(dynamicObject.getLong("calorg.id"));
        }
        crParams.setRelationCalOrgIds(calOrgIdSet);
        return costaccountColl;
    }

    public static Map<Long, Set<String>> getModifyMaterialIdSet(CostRecoveryParams crParams, Set<String> materialIdSet) {
        QFilter noAutoFilter = new QFilter("org.id", "in", crParams.getRelationCalOrgIds());
        noAutoFilter.and("costaccount.id", "in", crParams.getRelationCostAccountIds());
        if (crParams.getManuOrgId() != 0L) {
            noAutoFilter.and("prdorg.id", "=", (Object)crParams.getManuOrgId());
        }
        noAutoFilter.and("period.id", "=", (Object)crParams.getNextPeriodId());
        noAutoFilter.and("ismodify", "=", (Object)Boolean.TRUE);
        if (materialIdSet != null) {
            noAutoFilter.and(CostRecCalcHelper.getMatKeyQFilter(materialIdSet, "material.id", "calckeycol.id"));
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.utils.CostRecoveryHelperHALFPRDSTRUCTURE", (String)"sca_halfprdstructure", (String)"org,material,calckeycol", (QFilter[])new QFilter[]{noAutoFilter}, null);
        for (Row row : ds) {
            Long calOrgId = row.getLong("org");
            Set modifyMaterialIds = result.computeIfAbsent(calOrgId, p -> Sets.newHashSet());
            modifyMaterialIds.add(CostRecCalcHelper.getKeyIdStr(row.getLong("material"), row.getLong("calckeycol")));
        }
        return result;
    }
}

