/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;

public class CostTypeHelper {
    public static boolean isUseMatVersion(Long costTypeId) {
        DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"isuseversion", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costTypeId)});
        if (costType == null) {
            return true;
        }
        return !costType.getBoolean("isuseversion");
    }

    public static boolean isUseMatVer(Long costAccountId) {
        QFilter qfId = new QFilter("id", "=", (Object)costAccountId);
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"costtype", (QFilter[])new QFilter[]{qfId});
        if (costAccount == null || costAccount.get("costtype") == null) {
            return true;
        }
        Long costTypeId = costAccount.getLong("costtype");
        if (costTypeId <= 0L) {
            return true;
        }
        return CostTypeHelper.isUseMatVersion(costTypeId);
    }

    public static Long getCostTypeIdByManuOrgIdFromCal(Long costAccountId, Long calOrgId, Long manuOrgId) {
        if (costAccountId == null) {
            return null;
        }
        boolean isMulFactory = CostAccountHelper.isEnableMulFactory((Long)costAccountId);
        Long costTypeId = null;
        Date now = TimeServiceHelper.now();
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
        filter.and("bizstatus", "=", (Object)Character.valueOf('1'));
        filter.and("effectdate", "<=", (Object)now);
        filter.and("invaliddate", ">", (Object)now);
        if (isMulFactory && manuOrgId != null && manuOrgId > 0L) {
            List invList = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuOrgId, (boolean)true);
            if (invList != null && invList.size() > 0) {
                filter.and("storageorgunit", "=", invList.get(0));
            }
        } else {
            filter.and("calorg", "=", (Object)calOrgId);
        }
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])filter.toArray());
        if (dos != null && dos.length > 0) {
            costTypeId = dos[0].getLong("costtype.id");
        }
        if (costTypeId == null) {
            DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount", (String)"costtype");
            DynamicObject costType = costAccount.getDynamicObject("costtype");
            if (costType == null) {
                return null;
            }
            return (Long)costType.getPkValue();
        }
        return costTypeId;
    }
}

