/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.Grouper;
import kd.bos.algox.RowX;
import kd.bos.exception.KDBizException;

public class DataSetXHelper {
    public static DataSetX union(DataSetX dataSet1, DataSetX dataSet2) {
        dataSet2 = dataSet2.select(dataSet1.getRowMeta().getFieldNames());
        dataSet1 = dataSet1.union(dataSet2);
        return dataSet1;
    }

    public static DataSetX unionIfRowDiff(DataSetX dataSet1, DataSetX dataSet2) {
        return DataSetXHelper.unionIfRowDiff(dataSet1, dataSet2, null);
    }

    public static DataSetX unionIfRowDiffStrDefaultEmpty(DataSetX dataSet1, DataSetX dataSet2) {
        return DataSetXHelper.unionIfRowDiff(dataSet1, dataSet2, "");
    }

    public static DataSetX unionIfRowDiff(DataSetX dataSet1, DataSetX dataSet2, String defaultString) {
        ArrayList srcFileds = Lists.newArrayList((Object[])dataSet1.getRowMeta().getFields());
        ArrayList destFields = Lists.newArrayList((Object[])dataSet2.getRowMeta().getFields());
        srcFileds.removeAll(destFields);
        Object[] values = new Object[srcFileds.size()];
        for (int i = 0; i < srcFileds.size(); ++i) {
            DataType dt = ((Field)srcFileds.get(i)).getDataType();
            if (dt.equals((Object)DataType.BigDecimalType)) {
                values[i] = BigDecimal.ZERO;
                continue;
            }
            if (dt.equals((Object)DataType.BooleanType)) {
                values[i] = false;
                continue;
            }
            if (dt.equals((Object)DataType.DoubleType)) {
                values[i] = 0.0;
                continue;
            }
            if (dt.equals((Object)DataType.IntegerType)) {
                values[i] = 0;
                continue;
            }
            if (dt.equals((Object)DataType.LongType)) {
                values[i] = 0L;
                continue;
            }
            if (dt.equals((Object)DataType.StringType)) {
                if (defaultString != null) {
                    values[i] = defaultString;
                    continue;
                }
                values[i] = " ";
                continue;
            }
            if (!dt.equals((Object)DataType.TimestampType)) continue;
            values[i] = new Date();
        }
        if (srcFileds.size() > 0) {
            dataSet2 = dataSet2.addFields(srcFileds.toArray(new Field[0]), values);
        }
        dataSet2 = dataSet2.select(dataSet1.getRowMeta().getFieldNames());
        dataSet1 = dataSet1.union(dataSet2);
        return dataSet1;
    }

    public static RowX copyRowX(RowX destRow, RowMeta destRowMeta, RowX srcRow, RowMeta srcRowMeta, String[] copyFields) {
        for (String key : copyFields) {
            destRow.set(destRowMeta.getFieldIndex(key), srcRow.get(srcRowMeta.getFieldIndex(key)));
        }
        return destRow;
    }

    public static DataSet getDsFromAlgoxRows(Iterable<RowX> rows, String[] orderArr, RowMeta rowMeta) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        for (RowX row : rows) {
            dataList.add(row.values());
        }
        DataSet ds = Algo.create((String)"kd.macc.cad.algox.utils.DatSetXUtils.DatSetXUtils").createDataSet(dataList.iterator(), rowMeta);
        if (orderArr == null) {
            return ds;
        }
        return ds.orderBy(orderArr);
    }

    public static DataSetX addBigDecimalFields(DataSetX srcDataSetX, String[] fields) {
        if (fields == null || fields.length == 0) {
            return srcDataSetX;
        }
        int length = fields.length;
        Field[] dsfields = new Field[length];
        Object[] defaultValues = new Object[length];
        for (int i = 0; i < fields.length; ++i) {
            dsfields[i] = new Field(fields[i], (DataType)DataType.BigDecimalType);
            defaultValues[i] = BigDecimal.ZERO;
        }
        return srcDataSetX.addFields(dsfields, defaultValues);
    }

    public static DataSetX groupBySum(DataSetX srcDataSetX, String[] groupfields, String[] sumfields) {
        return DataSetXHelper.groupByAndDataDeal(srcDataSetX, groupfields, sumfields, null, null);
    }

    public static DataSetX groupByAndDataDeal(DataSetX srcDataSetX, String[] groupfields, String[] sumfields, String[] maxfields, String[] minFields) {
        if (groupfields.length == 0) {
            throw new KDBizException("group field is null");
        }
        DataSetX dataDsx = null;
        Grouper detailGrouper = srcDataSetX.groupBy(groupfields);
        if (sumfields != null) {
            for (String showQtyCol : sumfields) {
                dataDsx = dataDsx == null ? detailGrouper.sum(showQtyCol) : dataDsx.sum(showQtyCol);
            }
        }
        if (maxfields != null) {
            for (String showQtyCol : maxfields) {
                dataDsx = dataDsx == null ? detailGrouper.max(showQtyCol) : dataDsx.max(showQtyCol);
            }
        }
        if (minFields != null) {
            for (String showQtyCol : minFields) {
                dataDsx = dataDsx == null ? detailGrouper.min(showQtyCol) : dataDsx.min(showQtyCol);
            }
        }
        if (dataDsx == null) {
            return srcDataSetX;
        }
        return dataDsx;
    }
}

