/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.constants.FactCostReductCalcCheck;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.TimeUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class FactCostReductTaskHelper {
    protected static final Log logger = LogFactory.getLog(FactCostReductTaskHelper.class);

    public static Long initCalcReport(Long taskId, IDataModel model, Date calTime) {
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sca_taskconfig");
        DynamicObject calcReport = BusinessDataServiceHelper.newDynamicObject((String)"sca_reductreport");
        Long id = DBServiceHelper.genGlobalLongId();
        calcReport.set("id", (Object)id);
        calcReport.set("taskname", (Object)taskConfig.getString("name"));
        calcReport.set("starttime", (Object)calTime);
        calcReport.set("usetime", (Object)0);
        calcReport.set("type", (Object)"2");
        calcReport.set("progress", (Object)0);
        calcReport.set("billtype", (Object)"2");
        calcReport.set("executor", (Object)RequestContext.get().getUserId());
        DynamicObject currency = model.getDataEntity().getDynamicObject("currency");
        calcReport.set("currency", currency.getPkValue());
        DynamicObject org = model.getDataEntity().getDynamicObject("org");
        Object pkId = org.getPkValue();
        calcReport.set("org", pkId);
        DynamicObject acct = model.getDataEntity().getDynamicObject("costaccount");
        calcReport.set("costaccount", acct.getPkValue());
        DynamicObject prdorg = model.getDataEntity().getDynamicObject("prdorg");
        if (prdorg != null) {
            calcReport.set("prdorg", prdorg.getPkValue());
        }
        DynamicObject period = model.getDataEntity().getDynamicObject("period");
        calcReport.set("period", period.getPkValue());
        DynamicObjectCollection relaCostaccount = calcReport.getDynamicObjectCollection("relacostaccount");
        DynamicObjectCollection modelRelaCostaccount = model.getDataEntity().getDynamicObjectCollection("relacostaccount");
        if (modelRelaCostaccount != null && modelRelaCostaccount.size() > 0) {
            for (DynamicObject dyn : modelRelaCostaccount) {
                DynamicObject obj = relaCostaccount.addNew();
                obj.set("fbasedataid", (Object)dyn.getDynamicObject("fbasedataid"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
        return id;
    }

    public static Long initCostReductReport(Long taskId, JSONObject paramObj) {
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sca_taskconfig");
        DynamicObject calcReport = BusinessDataServiceHelper.newDynamicObject((String)"sca_reductreport");
        Long id = DBServiceHelper.genGlobalLongId();
        calcReport.set("id", (Object)id);
        calcReport.set("taskname", (Object)taskConfig.getString("name"));
        calcReport.set("starttime", (Object)TimeServiceHelper.now());
        calcReport.set("usetime", (Object)0);
        calcReport.set("type", (Object)"2");
        calcReport.set("progress", (Object)0);
        calcReport.set("billtype", (Object)"2");
        calcReport.set("executor", (Object)RequestContext.get().getUserId());
        calcReport.set("currency", (Object)paramObj.getLong("currency"));
        calcReport.set("org", (Object)paramObj.getLong("calOrgId"));
        calcReport.set("costaccount", (Object)paramObj.getLong("costAccountId"));
        if (paramObj.containsKey((Object)"manuOrgId")) {
            calcReport.set("prdorg", (Object)paramObj.getLong("manuOrgId"));
        } else {
            calcReport.set("prdorg", (Object)0);
        }
        calcReport.set("period", (Object)paramObj.getLong("periodId"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
        return id;
    }

    public static Long initCheckReport(Long taskId, IDataModel model, Date calTime) {
        DynamicObject calcReport = BusinessDataServiceHelper.newDynamicObject((String)"sca_reductreport");
        Long id = DBServiceHelper.genGlobalLongId();
        calcReport.set("id", (Object)id);
        calcReport.set("taskname", (Object)ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"FactCostReductTaskHelper_1", (String)"macc-sca-algox", (Object[])new Object[0]));
        calcReport.set("starttime", (Object)calTime);
        calcReport.set("usetime", (Object)0);
        calcReport.set("type", (Object)"2");
        calcReport.set("progress", (Object)0);
        calcReport.set("billtype", (Object)"1");
        calcReport.set("executor", (Object)RequestContext.get().getUserId());
        DynamicObject currency = model.getDataEntity().getDynamicObject("currency");
        calcReport.set("currency", currency.getPkValue());
        DynamicObject org = model.getDataEntity().getDynamicObject("org");
        Object pkId = org.getPkValue();
        calcReport.set("org", pkId);
        DynamicObject acct = model.getDataEntity().getDynamicObject("costaccount");
        calcReport.set("costaccount", acct.getPkValue());
        DynamicObject prdorg = model.getDataEntity().getDynamicObject("prdorg");
        if (prdorg != null) {
            calcReport.set("prdorg", prdorg.getPkValue());
        }
        DynamicObject period = model.getDataEntity().getDynamicObject("period");
        calcReport.set("period", period.getPkValue());
        DynamicObjectCollection relaCostaccount = calcReport.getDynamicObjectCollection("relacostaccount");
        DynamicObjectCollection modelRelaCostaccount = model.getDataEntity().getDynamicObjectCollection("relacostaccount");
        if (modelRelaCostaccount != null && modelRelaCostaccount.size() > 0) {
            for (DynamicObject dyn : modelRelaCostaccount) {
                DynamicObject obj = relaCostaccount.addNew();
                obj.set("fbasedataid", (Object)dyn.getDynamicObject("fbasedataid"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
        return id;
    }

    public static Long initTaskRecord(Long taskId) {
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sca_taskconfig");
        DynamicObject taskrecord = BusinessDataServiceHelper.newDynamicObject((String)"sca_taskrecord");
        Long id = DBServiceHelper.genGlobalLongId();
        Date startTime = new Date();
        taskrecord.set("id", (Object)id);
        taskrecord.set("taskname", (Object)taskConfig.getString("name"));
        taskrecord.set("starttime", (Object)startTime);
        taskrecord.set("time", (Object)0);
        taskrecord.set("status", (Object)2);
        taskrecord.set("progress", (Object)0);
        taskrecord.set("executor", (Object)RequestContext.get().getUserId());
        taskrecord.set("nextpage", (Object)taskConfig.getString("nextentity"));
        taskrecord.set("taskconfig", (Object)taskConfig.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskrecord});
        return id;
    }

    public static void upateTaskRecord(Long taskRecordId, int mProgess, String status) {
        FactCostReductTaskHelper.upateTaskRecord(taskRecordId, mProgess, status, true);
    }

    public static void upateTaskRecord(Long taskRecordId, int mProgess, String status, boolean isAddProcess) {
        QFilter filter = new QFilter("id", "=", (Object)taskRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.substatus", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty(records)) {
            Object record = records[0];
            long totalProgress = 0L;
            totalProgress = isAddProcess ? record.getLong("progress") + (long)mProgess : (long)mProgess;
            if (totalProgress >= 100L) {
                record.set("progress", (Object)100);
            } else {
                record.set("progress", (Object)totalProgress);
            }
            if ("4".equals(status)) {
                DynamicObjectCollection dyncols = record.getDynamicObjectCollection("entryentity");
                for (DynamicObject dyn : dyncols) {
                    String result = dyn.getString("substatus");
                    if (!"3".equals(result)) continue;
                    status = "3";
                    break;
                }
            }
            record.set("time", (Object)TimeUtils.getSecond(record.getDate("starttime"), new Date()));
            record.set("status", (Object)status);
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static Long getLastTaskRecordId(Long taskConfigId, Long executor) {
        QFilter filter = new QFilter("taskconfig", "=", (Object)taskConfigId);
        filter.and(new QFilter("executor", "=", (Object)executor));
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"starttime desc", (int)1);
        return CadEmptyUtils.isEmpty(records) ? 0L : records[0].getLong("id");
    }

    public static int saveTaskRecordEntry(Long taskRecordId, Long taskDetailId, String item, String status, String bigText) {
        QFilter filter = new QFilter("id", "=", (Object)taskRecordId);
        String recordFields = "id,entryentity.id,entryentity.seq,entryentity.subname,entryentity.substarttime,entryentity.substatus,entryentity.subnextentity,entryentity.subparam,entryentity.subparam_tag,entryentity.detailconfig";
        DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"sca_taskrecord", (String)recordFields, (QFilter[])new QFilter[]{filter});
        int seq = 0;
        if (record != null) {
            DynamicObjectCollection taskrecordEntrys = record.getDynamicObjectCollection("entryentity");
            String selectFields = "entryentity.id,entryentity.subnextentity";
            QFilter idfilter = new QFilter("id", "=", (Object)FactCostReductCalcCheck.CALCTASKID);
            DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((String)"sca_taskconfig", (String)selectFields, (QFilter[])new QFilter[]{idfilter});
            DynamicObjectCollection taskConfigEntrys = taskConfig.getDynamicObjectCollection("entryentity");
            for (DynamicObject taskConfigEntry : taskConfigEntrys) {
                if (taskDetailId.compareTo(taskConfigEntry.getLong("id")) != 0) continue;
                DynamicObject taskrecordEntry = taskrecordEntrys.addNew();
                seq = taskrecordEntrys.size();
                taskrecordEntry.set("seq", (Object)seq);
                taskrecordEntry.set("subname", (Object)item);
                taskrecordEntry.set("substarttime", (Object)new Date());
                taskrecordEntry.set("substatus", (Object)status);
                taskrecordEntry.set("subnextentity", (Object)taskConfigEntry.getString("subnextentity"));
                taskrecordEntry.set("detailconfig", taskConfigEntry.getPkValue());
                if (!kd.bos.util.StringUtils.isNotEmpty((String)bigText)) continue;
                taskrecordEntry.set("subparam", (Object)"");
                taskrecordEntry.set("subparam_tag", (Object)bigText);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        }
        return seq;
    }

    public static void upateTaskRecordEntry(Long taskRecordId, Long taskDetailId, int seq, String status) {
        FactCostReductTaskHelper.upateTaskRecordEntry(taskRecordId, taskDetailId, seq, status, null);
    }

    public static void upateTaskRecordEntry(Long taskRecordId, Long taskDetailId, int seq, String status, String bigText) {
        DynamicObject record;
        QFilter filter = new QFilter("id", "=", (Object)taskRecordId);
        String selectField = "id,progress,time,starttime,status,entryentity.detailconfig,entryentity.seq,entryentity.substatus,entryentity.substarttime,entryentity.subtime";
        if (kd.bos.util.StringUtils.isNotEmpty((String)bigText)) {
            selectField = selectField + ",entryentity.subparam,entryentity.subparam_tag";
        }
        if ((record = BusinessDataServiceHelper.loadSingle((String)"sca_taskrecord", (String)selectField, (QFilter[])new QFilter[]{filter})) != null) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (taskDetailId.compareTo(entry.getLong("detailconfig")) != 0 || entry.getInt("seq") != seq) continue;
                entry.set("substatus", (Object)status);
                if ("2".equals(status) && entry.getDate("substarttime") == null) {
                    entry.set("substarttime", (Object)new Date());
                }
                if ("4".equals(status)) {
                    entry.set("subtime", (Object)TimeUtils.getMilliSecond(entry.getDate("substarttime"), new Date()));
                }
                if (!kd.bos.util.StringUtils.isNotEmpty((String)bigText)) continue;
                entry.set("subparam", (Object)"");
                entry.set("subparam_tag", (Object)bigText);
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static void upateTaskRecordEntryWithMsg(Long taskRecordId, Long taskDetailId, int seq, String errMsg, Long checkResultId, String status) {
        QFilter filter = new QFilter("id", "=", (Object)taskRecordId);
        DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.seq,entryentity.substatus,entryentity.substarttime,entryentity.subtime,entryentity.detail,entryentity.subparam", (QFilter[])new QFilter[]{filter});
        if (record != null) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (taskDetailId.compareTo(entry.getLong("detailconfig")) != 0 || entry.getInt("seq") != seq) continue;
                entry.set("substatus", (Object)status);
                if ("2".equals(status) && entry.getDate("substarttime") == null) {
                    entry.set("substarttime", (Object)new Date());
                }
                if ("4".equals(status)) {
                    entry.set("subtime", (Object)TimeUtils.getMilliSecond(entry.getDate("substarttime"), new Date()));
                }
                if (!"3".equals(status)) continue;
                entry.set("subtime", (Object)TimeUtils.getMilliSecond(entry.getDate("substarttime"), new Date()));
                entry.set("detail", (Object)errMsg);
                if (CadEmptyUtils.isEmpty(checkResultId)) continue;
                JSONObject json = new JSONObject();
                json.accumulate("checkResultId", (Object)checkResultId);
                entry.set("subparam", (Object)json.toString());
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static void writeErroToTaskRecordEntry(Long lastRecordId, Exception ex) {
        if (ex == null || ex.getStackTrace() == null || ex.getStackTrace().length < 1) {
            return;
        }
        String errormsg = ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458\u3002", (String)"FactCostReductTaskHelper_0", (String)"macc-sca-algox", (Object[])new Object[0]);
        String errInfo = FactCostReductTaskHelper.wrapExceptionErrorInfo(ex);
        if (ex instanceof KDBizException) {
            if (!kd.bos.util.StringUtils.isEmpty((String)ex.getMessage())) {
                errormsg = ex.getMessage();
                errInfo = ex.getMessage();
            }
        } else if (ex instanceof AlgoException) {
            int i = 5;
            Throwable th = ex;
            while (th.getCause() != null && !((th = th.getCause()) instanceof KDBizException) && --i >= 0) {
            }
            if (th instanceof KDBizException && !kd.bos.util.StringUtils.isEmpty((String)th.getMessage())) {
                errormsg = th.getMessage();
                errInfo = th.getMessage();
            }
        }
        FactCostReductTaskHelper.writeErroToTaskRecordEntry(lastRecordId, errormsg, errInfo);
    }

    public static void writeErroToTaskRecordEntry(Long lastRecordId, String errormsg, String errInfo) {
        QFilter filter = new QFilter("id", "=", (Object)lastRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime,entryentity.detail,entryentity.subparam,entryentity.subparam_tag,entryentity.substatus substatus", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty(records)) {
            Object record = records[0];
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            DynamicObject entry = (DynamicObject)entrys.get(entrys.size() - 1);
            if (entry != null) {
                entry.set("substatus", (Object)"3");
                entry.set("detail", (Object)errormsg);
                entry.set("subparam_tag", (Object)StringUtils.substring((String)errInfo, (int)0, (int)2000000));
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static String wrapExceptionErrorInfo(Exception ex) {
        StringBuilder erroStr = new StringBuilder();
        String errormsg = ex.getCause() == null ? (ex.getLocalizedMessage() == null ? "" : ex.getLocalizedMessage()) : ex.getCause().getMessage();
        erroStr.append(errormsg).append("\n");
        erroStr.append(FactCostReductTaskHelper.toStackTrace(ex));
        return erroStr.toString();
    }

    public static String toStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            return sw.toString();
        }
        catch (Exception e1) {
            logger.error("\u5931\u8d25", (Throwable)e);
            return "";
        }
    }

    public static DynamicObject getLastTaskRecord(Long taskId, Long executor) {
        QFilter filter = new QFilter("taskconfig", "=", (Object)taskId);
        filter.and(new QFilter("executor", "=", (Object)executor));
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,time,nextpagepara", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        return CadEmptyUtils.isEmpty(records) ? null : records[0];
    }

    public static DynamicObject getLastTaskRecord(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,time,nextpagepara", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        return CadEmptyUtils.isEmpty(records) ? null : records[0];
    }

    public static void updateNextPagePara(Long taskRecordId, String nextPagePara) {
        DynamicObject taskRecord = FactCostReductTaskHelper.getLastTaskRecord(taskRecordId);
        if (taskRecord == null) {
            return;
        }
        taskRecord.set("nextpagepara", (Object)nextPagePara);
        SaveServiceHelper.update((DynamicObject)taskRecord);
    }

    public static void updateCalcRreport(Long calcReportId, DynamicObject taskRecord) {
        DynamicObject calcReport = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"sca_reductreport");
        calcReport.set("usetime", taskRecord.get("time"));
        calcReport.set("progress", taskRecord.get("progress"));
        calcReport.set("type", taskRecord.get("status"));
        calcReport.set("nextpagepara", taskRecord.get("nextpagepara"));
        DynamicObjectCollection taskRecordEntrys = taskRecord.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection calaReportEntrys = calcReport.getDynamicObjectCollection("entryentity");
        calaReportEntrys.clear();
        int seq = 1;
        for (DynamicObject entry : taskRecordEntrys) {
            DynamicObject calaReportEntry = calaReportEntrys.addNew();
            calaReportEntry.set("detailconfig", entry.getPkValue());
            calaReportEntry.set("item", (Object)entry.getString("subname"));
            calaReportEntry.set("subnextentity", (Object)entry.getString("subnextentity"));
            calaReportEntry.set("result", entry.get("substatus"));
            calaReportEntry.set("cnsmtime", entry.get("subtime"));
            String subparam = entry.getString("subparam");
            calaReportEntry.set("subparam", (Object)subparam);
            if (!kd.bos.util.StringUtils.isEmpty((String)subparam)) {
                try {
                    JSONObject.fromObject((Object)subparam);
                }
                catch (Exception ex) {
                    logger.error("json\u8f6c\u6362\u5931\u8d25", (Throwable)ex);
                    calaReportEntry.set("bigtext", entry.get("subparam"));
                }
            }
            calaReportEntry.set("bigtext_tag", entry.get("subparam_tag"));
            if (entry.get("detail") != null && !"".equals(entry.get("detail"))) {
                StringBuilder erroStr = new StringBuilder();
                erroStr.append(entry.get("detail"));
                calaReportEntry.set("detail", (Object)(erroStr.length() > 50 ? erroStr.substring(0, 50) : erroStr.toString()));
            }
            calaReportEntry.set("substarttime", entry.get("substarttime"));
            if (entry.get("substatus").equals("3")) {
                calaReportEntry.set("checkdesc", entry.get("detail"));
            }
            calaReportEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
    }

    public static Map<String, Integer> getSucByCalcReportId(Long calcReportId) {
        String algoKey = "kd.macc.sca.algox.utils.getSucByCalcReportId";
        QFilter qfCalcReport = new QFilter("calcreport", "=", (Object)calcReportId);
        String selectFields = "org,material";
        DataSet calcResult = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_costrecovry", (String)selectFields, (QFilter[])new QFilter[]{qfCalcReport}, null);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        HashSet<Long> orgIds = new HashSet<Long>();
        HashSet<Long> productIds = new HashSet<Long>();
        for (Row row : calcResult) {
            orgIds.add(row.getLong("org"));
            productIds.add(row.getLong("material"));
        }
        result.put("orgsize", orgIds.size());
        result.put("productsize", productIds.size());
        return result;
    }

    public static Set<Long> getPrdSetByCalcReportId(Long calcReportId) {
        String algoKey = "kd.macc.sca.algox.utils.getSucByCalcReportId";
        QFilter qfCalcReport = new QFilter("calcreport", "=", (Object)calcReportId);
        String selectFields = "org,material";
        DataSet calcResult = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_costrecovry", (String)selectFields, (QFilter[])new QFilter[]{qfCalcReport}, null);
        HashSet<Long> productIds = new HashSet<Long>();
        for (Row row : calcResult) {
            productIds.add(row.getLong("material"));
        }
        return productIds;
    }

    public static DynamicObject getCurrency(Long costaccountId) {
        if (costaccountId == null) {
            return null;
        }
        DynamicObject costaccount = BusinessDataServiceHelper.loadSingle((Object)costaccountId, (String)"cal_bd_costaccount");
        if (costaccount == null) {
            return null;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return null;
        }
        return QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
    }
}

