/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.alloc.MatAllocHelper;
import kd.macc.sca.algox.alloc.function.CostObjectCalculateFunction;

public class FormulaUtil {
    private static final Log logger = LogFactory.getLog(FormulaUtil.class);
    private static final String OPERATOR = "+-*/()";
    private static final String[] PRIORITY = new String[]{"+-", "*/", "()"};
    private static final String ENTITY_CAD_COSTDRIVER = "cad_costdriver";
    private static Comparator<String> comp = (first, second) -> {
        int fIndex = 0;
        int sIndex = 0;
        for (int i = 0; i < PRIORITY.length; ++i) {
            if (PRIORITY[i].indexOf((String)first) >= 0) {
                fIndex = i;
            }
            if (PRIORITY[i].indexOf((String)second) < 0) continue;
            sIndex = i;
        }
        return fIndex - sIndex;
    };

    public static List<String> analyticFormula(String formula) {
        if (StringUtils.isEmpty((CharSequence)formula)) {
            return null;
        }
        formula = formula.replaceAll("\\s*", "");
        ArrayList<String> suffixList = new ArrayList<String>(10);
        Stack<String> opStack = new Stack<String>();
        StringBuilder buf = new StringBuilder();
        for (char c : formula.toCharArray()) {
            if (OPERATOR.indexOf(c) >= 0) {
                if (buf.length() > 0) {
                    suffixList.add(buf.toString());
                    buf.delete(0, buf.length());
                }
                if (c == '(') {
                    opStack.push(String.valueOf(c));
                    continue;
                }
                if (c == ')') {
                    String last = "";
                    while (opStack.size() > 0 && !(last = (String)opStack.pop()).equals("(")) {
                        suffixList.add(last);
                    }
                    if ("(".equals(last)) continue;
                    logger.error("illegal express. exp is :{}", (Object)formula);
                    return null;
                }
                if (opStack.size() > 0) {
                    String currentOp = String.valueOf(c);
                    String last = (String)opStack.peek();
                    if (last.equals("(") || comp.compare(currentOp, last) > 0) {
                        opStack.push(currentOp);
                        continue;
                    }
                    last = (String)opStack.pop();
                    suffixList.add(last);
                    opStack.push(currentOp);
                    continue;
                }
                opStack.push(String.valueOf(c));
                continue;
            }
            buf.append(c);
        }
        if (buf.length() > 0) {
            suffixList.add(buf.toString());
        }
        while (opStack.size() > 0) {
            String last = (String)opStack.pop();
            if ("()".indexOf(last) >= 0) {
                logger.error("illegal express. exp is :{}", (Object)formula);
                return null;
            }
            suffixList.add(last);
        }
        return suffixList;
    }

    public static DataSet getDiyDsOnCostCenter(Long costDriverId, Long orgId, Long costAccountId, Long periodId, String appId) {
        QFilter baseFilter = new QFilter("billstatus", "=", (Object)"C");
        baseFilter.and("appnum", "=", (Object)appId);
        DataSet resourceDs = FormulaUtil.getResourceUseById(costDriverId, orgId, periodId, appId);
        DataSet diyCostDriverDs = FormulaUtil.getStdValueDiyByCostDriverId(costDriverId, orgId, costAccountId, periodId, appId);
        diyCostDriverDs = diyCostDriverDs.union(resourceDs);
        diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,org,costcenter,benefcostcenter,sum(value) value group by costdriver,org,costcenter,benefcostcenter");
        return diyCostDriverDs;
    }

    private static DataSet getResourceUseById(Long costDriverId, Long orgId, Long periodId, String appId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter dateFilter = FormulaUtil.getDatefilter(periodId);
        QFilter baseFilter = new QFilter("billstatus", "=", (Object)"C");
        baseFilter.and("appnum", "=", (Object)appId);
        String algoKey = "kd.macc.aca.algox.utils.FormulaUtil.getResourceUseByIds";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("appnum", "=", (Object)appId));
        filters.add(new QFilter("id", "in", (Object)costDriverId));
        DataSet resourceDriver = QueryServiceHelper.queryDataSet((String)algoKey, (String)ENTITY_CAD_COSTDRIVER, (String)"id,unit,matchpattern,resource.fbasedataid resource,resourcetype,matchreport", (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet resource = resourceDriver.filter("matchpattern = 'resource'").select("id,unit,resource,resourcetype,matchreport");
        DataSet resourceType = resourceDriver.filter("matchpattern = 'resourcetype'").select("id,unit,resource,case when resourcetype='A' then 'mpdm_equipment' when resourcetype='B' then 'mpdm_toolsresource' when resourcetype='C' then 'mpdm_toolequip' when resourcetype='D' then 'mpdm_mould' when resourcetype='E' then 'mpdm_manuperson' end resourcetype,matchreport");
        filters.clear();
        filters.add(orgFilter);
        filters.add(dateFilter);
        filters.add(baseFilter);
        DataSet resourceData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_resourceuse", (String)"org,costcenter,resource,resource.resourcesentryentity.itemclasstype as resourcetype,entryentity.workhour as workhour,entryentity.facthour as facthour,entryentity.factuse as factuse,entryentity.costobject as costobject", (QFilter[])filters.toArray(new QFilter[0]), null);
        resourceData = resourceData.select("org,costcenter,resource,resourcetype,workhour,facthour,factuse,costobject");
        resource = resource.join(resourceData, JoinType.INNER).on("resource", "resource").select(resource.getRowMeta().getFieldNames(), new String[]{"workhour", "org", "costcenter", "facthour", "factuse"}).finish();
        resourceType = resourceType.join(resourceData, JoinType.INNER).on("resourcetype", "resourcetype").select(resourceType.getRowMeta().getFieldNames(), new String[]{"workhour", "org", "costcenter", "facthour", "factuse"}).finish();
        resource = resource.union(resourceType).select("id,unit,resource,resourcetype,matchreport,org,costcenter,case when workhour=10 then facthour*60 when workhour=8 then facthour/60 else facthour end facthour,factuse");
        resource = resource.select("id as costdriver,org,costcenter,case when matchreport='total' then facthour else factuse end value");
        resource = resource.groupBy(new String[]{"costdriver", "org", "costcenter"}).sum("value").finish();
        resource = resource.select("costdriver,org,costcenter,costcenter as benefcostcenter, value");
        return resource;
    }

    private static DataSet getStdValueDiyByCostDriverId(Long costDriverId, Long orgId, Long costAccountId, Long periodId, String appId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter dateFilter = FormulaUtil.getDatefilter(periodId);
        QFilter baseFilter = new QFilter("billstatus", "=", (Object)"C");
        baseFilter.and("appnum", "=", (Object)appId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "kd.macc.aca.algox.utils.FormulaUtil.getStdValueDiyByCostDriverId";
        filters.add(orgFilter);
        filters.add(dateFilter);
        filters.add(baseFilter);
        filters.add(new QFilter("costdriver.id", "=", (Object)costDriverId));
        DataSet workQtyDs = QueryServiceHelper.queryDataSet((String)(algoKey + "2"), (String)"sca_workqtycollec", (String)"costdriver,org,costcenter,entryentity.benefcostcenter as benefcostcenter,entryentity.entryqty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
        workQtyDs = workQtyDs.executeSql("select costdriver,org,costcenter,benefcostcenter,sum(value) as value group by costdriver,org,costcenter,benefcostcenter");
        filters.clear();
        QFilter appFilter = new QFilter("appnum", "=", (Object)appId);
        filters.add(orgFilter);
        filters.add(appFilter);
        filters.add(new QFilter("costdriver.allocclass", "=", (Object)"COSTCENTER"));
        filters.add(new QFilter("costdriver.id", "=", (Object)costDriverId));
        filters.add(new QFilter("effectperiod", "!=", (Object)0L));
        filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        filters.add(MatAllocHelper.getEffectDateFilter(periodId));
        DataSet diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_diycostdriver", (String)"costdriver,org,costcenter,entryentity.benefcostcenter as benefcostcenter,entryentity.entryqty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
        diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,org,costcenter,benefcostcenter,sum(value) value group by costdriver,org,costcenter,benefcostcenter");
        workQtyDs = workQtyDs.union(diyCostDriverDs);
        return workQtyDs;
    }

    public static DataSet startCostObjectCalculate(Map<String, Object> paramMap, DataSet totalDriverDs, boolean isConSiAux) {
        if (isConSiAux) {
            HashSet<Long> costObjectIds = new HashSet<Long>(16);
            DataSet costObjectDs = totalDriverDs.copy().select("costobject").distinct();
            for (Row row : costObjectDs) {
                costObjectIds.add(row.getLong("costobject"));
            }
            QFilter qFilter = new QFilter("id", "in", costObjectIds);
            DataSet costObjectDataSet = QueryServiceHelper.queryDataSet((String)"FormulaUtil.getCostObjectInfo", (String)"cad_costobject", (String)"id,auxpty as materialauxpty", (QFilter[])qFilter.toArray(), null);
            totalDriverDs = totalDriverDs.join(costObjectDataSet, JoinType.INNER).on("costobject", "id").select(totalDriverDs.getRowMeta().getFieldNames(), new String[]{"materialauxpty"}).finish();
        } else {
            totalDriverDs = totalDriverDs.addField("0L", "materialauxpty");
        }
        JobSession session = AlgoX.createSession((String)"FormulaUtil.doCalculateOnCostObject");
        DataSetInput processingAllocInput = new DataSetInput(totalDriverDs);
        DataSetX dataSetX = session.fromInput((Input)processingAllocInput);
        CostObjectCalculateFunction function = new CostObjectCalculateFunction(totalDriverDs.getRowMeta(), paramMap);
        DataSetX mainDataSet = dataSetX.groupBy(new String[]{"benefcostcenter"}).reduceGroup((GroupReduceFunction)function);
        DataSetOutput dataSetOutput = new DataSetOutput(totalDriverDs.getRowMeta());
        String resultId = dataSetOutput.getId();
        mainDataSet.output((Output)dataSetOutput);
        session.commit(60, TimeUnit.MINUTES);
        return session.readDataSet(resultId);
    }

    private static QFilter getDatefilter(Long periodId) {
        QFilter idfilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])idfilter.toArray());
        QFilter datefilter = new QFilter("bizdate", ">=", (Object)period.getDate("begindate"));
        datefilter.and("bizdate", "<=", (Object)period.getDate("enddate"));
        return datefilter;
    }

    public static String getCompleteFormula(String formula, String currentNumber, String currentName, long costDriverId) throws KDBizException {
        if (StringUtils.isNotEmpty((CharSequence)formula)) {
            List<Long> costDriverIds = FormulaUtil.getCostDriverIds(formula);
            QFilter qFilter = new QFilter("id", "in", costDriverIds);
            QFilter statusFilter = new QFilter("status", "!=", (Object)"C");
            statusFilter.or(new QFilter("enable", "=", (Object)"0"));
            boolean isExists = QueryServiceHelper.exists((String)ENTITY_CAD_COSTDRIVER, (QFilter[])new QFilter[]{qFilter, statusFilter});
            if (isExists) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s/%2$s\u201d\u516c\u5f0f\u4e2d\u5b58\u5728\u975e\u5df2\u5ba1\u6838\u6216\u7981\u7528\u72b6\u6001\u7684\u6210\u672c\u52a8\u56e0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FormulaUtil_2", (String)"macc-sca-algox", (Object[])new Object[0]), currentNumber, currentName));
            }
            qFilter.and(new QFilter("iscomplexcd", "=", (Object)Boolean.TRUE));
            DynamicObjectCollection costDrivers = QueryServiceHelper.query((String)ENTITY_CAD_COSTDRIVER, (String)"id,formula,name", (QFilter[])qFilter.toArray());
            for (DynamicObject costDriver : costDrivers) {
                String subFormula = costDriver.getString("formula");
                String id = costDriver.getString("id");
                List<Long> costDriverIdList = FormulaUtil.getCostDriverIds(subFormula);
                if (costDriverIdList.contains(costDriverId)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s/%2$s\u201d\u516c\u5f0f\u4e2d\u5b58\u5728\u5d4c\u5957\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FormulaUtil_3", (String)"macc-sca-algox", (Object[])new Object[0]), currentNumber, currentName));
                }
                if (StringUtils.isNotBlank((CharSequence)subFormula)) {
                    subFormula = "(" + subFormula + ")";
                }
                formula = formula.replaceAll(id, subFormula);
                FormulaUtil.getCompleteFormula(formula, currentNumber, currentName, costDriverId);
            }
        }
        return formula;
    }

    private static List<Long> getCostDriverIds(String formula) {
        String[] formulaArr;
        String formulaString = formula.replaceAll("\\s*", "");
        ArrayList<Long> costDriverIds = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((CharSequence)formulaString) && (formulaArr = formulaString.split("\\D")) != null) {
            for (String id : formulaArr) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                costDriverIds.add(Long.valueOf(id));
            }
        }
        return costDriverIds;
    }
}

