/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CostTypeHelper;
import kd.macc.sca.algox.utils.FinishCalcHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.algox.wip.input.CalcDataArgs;

public class MatCostHelper {
    private static final int MAP_INITIAL_CAPACITY = 16;

    public static DataSet getStdCost(CalcDataArgs args) {
        String alokey = "kd.macc.sca.algox.utils.MatCostHelper.getStdCost";
        QFilter commonFilter = FinishCalcHelper.getOrgAndCostCenterFilter(args);
        commonFilter.and(new QFilter("bookdate", "<=", (Object)args.getEndDate()));
        commonFilter.and(new QFilter("bookdate", ">=", (Object)args.getStartDate()));
        QFilter costObjectFilter = new QFilter("entryentity.costobject", "in", args.getCostObjects());
        QFilter billstatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter appNumQf = new QFilter("appnum", "=", (Object)"sca");
        Long costAccountId = Long.valueOf(String.valueOf(args.getCostAcctId()));
        boolean isUseMatVer = CostTypeHelper.isUseMatVer(costAccountId);
        String selectFields = Long.valueOf(args.getOrgId().toString()) + " orgid,costcenter.masterid costcenterid," + Long.valueOf(args.getCostAcctId().toString()) + " costaccountid," + Long.valueOf(args.getPeriodId().toString()) + " periodid,entryentity.costobject.id costobjectid,entryentity.costobject.material.masterid materialid,entryentity.costobject.bomversion.id matversionid,entryentity.costobject.auxpty.id auxptyid,entryentity.qty qty,srcauditdate bizdate";
        if (!isUseMatVer) {
            selectFields = Long.valueOf(args.getOrgId().toString()) + " orgid,costcenter.masterid costcenterid," + Long.valueOf(args.getCostAcctId().toString()) + " costaccountid," + Long.valueOf(args.getPeriodId().toString()) + " periodid,entryentity.costobject.id costobjectid,entryentity.costobject.material.masterid materialid,0 matversionid,entryentity.costobject.auxpty.id auxptyid,entryentity.qty qty,srcauditdate bizdate";
        }
        DataSet finishInputQty = QueryServiceHelper.queryDataSet((String)alokey, (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{commonFilter, costObjectFilter, billstatus, appNumQf}, null);
        DynamicObject costaccountInfo = BusinessDataServiceHelper.loadSingle((Object)args.getCostAcctId(), (String)"cal_bd_costaccount");
        DynamicObject costTypeInfo = BusinessDataServiceHelper.loadSingle((Object)costaccountInfo.getLong("costtype.masterid"), (String)"cad_costtype");
        QFilter costtypeFilter = new QFilter("costtype", "=", (Object)costTypeInfo.getLong("masterid"));
        QFilter calcTypeFilter = new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3", "4"});
        QFilter stdIsMainDataFilter = new QFilter("ismaindata", "=", (Object)1);
        HashSet<Long> notInCalcIds = new HashSet<Long>(16);
        HashSet<Long> purPricesIds = new HashSet<Long>(16);
        MatCostHelper.dealPurPricesMat(notInCalcIds, purPricesIds, costtypeFilter, calcTypeFilter, stdIsMainDataFilter);
        QFilter calcIdFilter = new QFilter("id", "not in", notInCalcIds);
        DataSet calcDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.business.check.ProductStdCostCheckAction.getCalcCostObjectDataSet", (String)"cad_calceffectiveresult", (String)"material.masterid matid,matvers.id matverId,auxproperty.id auxptyId,entryentity.submaterial.id submatid,entryentity.submatvers.id submatverId,entryentity.subauxproperty.id subauxptyId,effectdate,expdate,entryentity.resource.id resourceid,entryentity.calcbasis calcbasis,entryentity.element.masterid elementid,entryentity.subelement.masterid subelementid,entryentity.subelement.type subelementtype,entryentity.qty subqty,entryentity.stdprice stdprice,entryentity.datatype calcdatatype,0 ispurprice", (QFilter[])new QFilter[]{costtypeFilter, calcTypeFilter, stdIsMainDataFilter, calcIdFilter}, null);
        QFilter purPriceIdFilter = new QFilter("id", "in", purPricesIds);
        DataSet purPriceDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.business.check.ProductStdCostCheckAction.getPurpriceDataSet", (String)"cad_purprices", (String)"material.masterid matid,0 matverId,0 auxptyId,material.masterid submatid,matversion.id submatverId,auxpty.id subauxptyId,createtime effectdate,createtime expdate,0 resourceid,'' calcbasis,entryentity.element.masterid elementid,entryentity.subelement.masterid subelementid,entryentity.subelement.type subelementtype,1 subqty,entryentity.price stdprice,'' calcdatatype,1 ispurprice", (QFilter[])new QFilter[]{purPriceIdFilter}, null);
        DataSet purPDataSet = purPriceDataSet.select("matid,case when matverId is null then 0 else matverId end matverId,case when auxptyId is null then 0 else auxptyId end auxptyId,submatid,case when submatverId is null then 0 else submatverId end submatverId,case when subauxptyId is null then 0 else subauxptyId end subauxptyId,effectdate,expdate,resourceid,calcbasis,elementid, subelementid,subelementtype,subqty,stdprice,calcdatatype,ispurprice").copy();
        calcDataSet = calcDataSet.union(purPDataSet);
        JoinDataSet joinDataSet = finishInputQty.join(calcDataSet, JoinType.LEFT);
        joinDataSet.on("materialid", "matid");
        joinDataSet.on("matversionid", "matverId");
        joinDataSet.on("auxptyid", "auxptyId");
        DataSet calcAllDataSet = joinDataSet.select(new String[]{"orgid", "costaccountid", "periodid", "costcenterid", "costobjectid", "qty", "bizdate"}, new String[]{"matid", "matverId", "auxptyId", "submatid", "submatverId", "subauxptyId", "effectdate", "expdate", "resourceid", "calcbasis", "elementid", "subelementid", "subelementtype", "subqty", "stdprice", "calcdatatype", "ispurprice"}).finish();
        calcAllDataSet = calcAllDataSet.select("orgid,costaccountid,periodid,costcenterid,costobjectid,matid materialid,matverId matversionid, auxptyId auxptyid,bizdate,effectdate,expdate, submatid,submatverId,subauxptyId,resourceid,calcbasis,elementid,subelementid,subelementtype,qty*subqty stdqty,qty*stdprice stdcost,calcdatatype,ispurprice").where(" (expdate >= bizdate and effectdate <= bizdate) or ispurprice =1");
        DataSet stdCostSubData = calcAllDataSet.select("orgid,costaccountid,periodid,costcenterid,costobjectid,submatid materialid,submatverId matversionid,subauxptyId auxptyid,resourceid,case when resourceid == 0 then '' else calcdatatype end costlevel,calcbasis,elementid,subelementid,subelementtype,stdqty,stdcost,'3' caltype,case when subelementtype == '001' OR subelementtype == '002' then '1' else '2' end  difftype,'2' datatype,calcdatatype,                                       0 pdstartqty,0 pdstartamount,0 pdcurrqty,0 pdcurramount,0 pdcompqty,0 pdcompanount,0 pdendqty,0 pdendamount,0 diff,0 totalqty,0 totalamount,0 totalstdqty,0 totalstdamount,ispurprice").where(" (calcdatatype = '2' or calcdatatype = '3') or ispurprice =1");
        DataSet stdCostCompData = calcAllDataSet.select("orgid,costaccountid,periodid,costcenterid,costobjectid,submatid materialid,submatverId matversionid,subauxptyId auxptyid,resourceid,'' costlevel,calcbasis,elementid,subelementid,subelementtype,stdqty,stdcost,'3' caltype,case when subelementtype == '001' OR subelementtype == '002' then '1' else '2' end  difftype,'1' datatype,calcdatatype,                                       0 pdstartqty,0 pdstartamount,0 pdcurrqty,0 pdcurramount,0 pdcompqty,0 pdcompanount,0 pdendqty,0 pdendamount,0 diff,0 totalqty,0 totalamount,0 totalstdqty,0 totalstdamount,ispurprice").where(" (calcdatatype = '2' or calcdatatype = '4') or ispurprice =1");
        DataSet stdCostAllDataSet = stdCostSubData.union(stdCostCompData);
        GroupbyDataSet groupDataSet = stdCostAllDataSet.groupBy(new String[]{"orgid", "costaccountid", "periodid", "costcenterid", "costobjectid", "materialid", "matversionid", "auxptyid", "resourceid", "costlevel", "calcbasis", "elementid", "subelementid", "difftype", "caltype", "datatype"});
        groupDataSet.sum("pdstartqty");
        groupDataSet.sum("pdstartamount");
        groupDataSet.sum("pdcurrqty");
        groupDataSet.sum("pdcurramount");
        groupDataSet.sum("pdcompqty");
        groupDataSet.sum("pdcompanount");
        groupDataSet.sum("pdendqty");
        groupDataSet.sum("pdendamount");
        groupDataSet.sum("diff");
        groupDataSet.sum("totalqty");
        groupDataSet.sum("totalamount");
        groupDataSet.sum("totalstdqty");
        groupDataSet.sum("totalstdamount");
        groupDataSet.sum("stdqty");
        groupDataSet.sum("stdcost");
        String seleFields = "orgid, costaccountid, costobjectid, costcenterid, periodid, resourceid,costlevel,calcbasis,elementid, subelementid, materialid, auxptyid, matversionid, datatype, difftype, caltype, stdqty, stdcost, pdstartqty, pdstartamount, pdcurrqty, pdcurramount, pdcompqty, pdcompanount, pdendqty, pdendamount, diff, totalqty, totalamount, totalstdqty, totalstdamount,0 costupdatediffamt";
        return groupDataSet.finish().select(seleFields);
    }

    private static void dealPurPricesMat(Set<Long> notInCalcIds, Set<Long> purPricesIds, QFilter costtypeFilter, QFilter calcTypeFilter, QFilter stdIsMainDataFilter) {
        HashSet<String> purPricesSet = new HashSet<String>(16);
        HashSet<Long> purPriceMats = new HashSet<Long>(16);
        QFilter isDownQf = new QFilter("isdowncalc", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection bomSettings = QueryServiceHelper.query((String)"cad_bomsetting", (String)"material.masterid matid,bomversion.id matverId,auxprop.id auxptyId", (QFilter[])new QFilter[]{costtypeFilter, isDownQf});
        for (DynamicObject bomSetting : bomSettings) {
            purPriceMats.add(bomSetting.getLong("matid"));
            purPricesSet.add(MatCostHelper.getNotNullField(bomSetting.getString("matid")) + "-" + MatCostHelper.getNotNullField(bomSetting.getString("matverId")) + "-" + MatCostHelper.getNotNullField(bomSetting.getString("auxptyId")));
        }
        QFilter matQf = new QFilter("material", "in", purPriceMats);
        DynamicObjectCollection calcResults = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)"id,material.masterid matid,matvers.id matverId,auxproperty.id auxptyId", (QFilter[])new QFilter[]{costtypeFilter, calcTypeFilter, stdIsMainDataFilter, matQf});
        for (DynamicObject calc : calcResults) {
            if (!purPricesSet.contains(MatCostHelper.getNotNullField(calc.getString("matid")) + "-" + MatCostHelper.getNotNullField(calc.getString("matverId")) + "-" + MatCostHelper.getNotNullField(calc.getString("auxptyId")))) continue;
            notInCalcIds.add(calc.getLong("id"));
        }
        DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_purprices", (String)"id,material.masterid matid,matversion.id matverId,auxpty.id auxptyId", (QFilter[])new QFilter[]{costtypeFilter, matQf});
        for (DynamicObject purPrice : purPrices) {
            if (!purPricesSet.contains(MatCostHelper.getNotNullField(purPrice.getString("matid")) + "-" + MatCostHelper.getNotNullField(purPrice.getString("matverId")) + "-" + MatCostHelper.getNotNullField(purPrice.getString("auxptyId")))) continue;
            purPricesIds.add(purPrice.getLong("id"));
        }
    }

    private static String getNotNullField(String string) {
        return CadEmptyUtils.isEmpty(string) ? "0" : string;
    }

    public static BigDecimal getMatStdPrice(Long typeId) {
        BigDecimal stdPrice = BigDecimal.ZERO;
        if (CadEmptyUtils.isEmpty(typeId)) {
            return stdPrice;
        }
        DynamicObjectCollection matCostInfos = new DynamicObjectCollection();
        QFilter filter = new QFilter("id", "=", (Object)typeId);
        if (QueryServiceHelper.exists((String)"cad_calceffectiveresult", (Object)typeId)) {
            QFilter typeFilter = new QFilter("entryentity.datatype", "=", (Object)"1");
            matCostInfos = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)"id,entryentity.qty qty,entryentity.stdprice stdprice", (QFilter[])new QFilter[]{filter, typeFilter});
        } else if (QueryServiceHelper.exists((String)"cad_matcostinfo", (Object)typeId)) {
            matCostInfos = QueryServiceHelper.query((String)"cad_matcostinfo", (String)"id,entryentity.standardcost stdprice", (QFilter[])new QFilter[]{filter});
        }
        if (CadEmptyUtils.isEmpty(matCostInfos)) {
            return stdPrice;
        }
        for (DynamicObject matcCost : matCostInfos) {
            stdPrice = stdPrice.add(matcCost.getBigDecimal("stdprice"));
        }
        return stdPrice;
    }

    public static DynamicObjectCollection getMatCostInfo(String costtypeid, String materialid, String matverid, String auxptyid, Date bizDate) {
        return MatCostHelper.getMatCostInfo(costtypeid, materialid, matverid, auxptyid, bizDate, true);
    }

    public static DynamicObjectCollection getMatCostInfo(String costtypeid, String materialid, String matverid, String auxptyid, Date bizDate, boolean hasMatCostInfo) {
        if (CadEmptyUtils.isEmpty(materialid) || CadEmptyUtils.isEmpty(costtypeid)) {
            return null;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)Long.valueOf(costtypeid));
        filter.and(new QFilter("entryentity.datatype", "in", Arrays.asList("2", "3")));
        filter.and(new QFilter("material", "=", (Object)Long.valueOf(materialid)));
        if (StringUtils.isNotEmpty((String)auxptyid)) {
            filter.and(new QFilter("auxproperty", "=", (Object)Long.valueOf(auxptyid)));
        }
        if (StringUtils.isNotEmpty((String)matverid)) {
            filter.and(new QFilter("matvers", "=", (Object)Long.valueOf(matverid)));
        }
        QFilter bizDateFilter = null;
        if (bizDate == null) {
            bizDateFilter = new QFilter("expdate", "=", (Object)TimeUtils.getDeFaultExpDate());
        } else {
            bizDateFilter = new QFilter("effectdate", "<=", (Object)bizDate);
            bizDateFilter.and(new QFilter("expdate", ">=", (Object)bizDate));
        }
        DynamicObjectCollection matCostInfoIds = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)"id", (QFilter[])new QFilter[]{filter, bizDateFilter});
        DynamicObjectCollection matCostInfos = null;
        if (!CadEmptyUtils.isEmpty(matCostInfoIds)) {
            QFilter idFilter = new QFilter("id", "=", (Object)((DynamicObject)matCostInfoIds.get(0)).getLong("id"));
            QFilter dataTypeFilter = new QFilter("entryentity.datatype", "in", Arrays.asList("2", "3"));
            matCostInfos = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)"id,effectdate,expdate,entryentity.element element,entryentity.subelement subelement,entryentity.submaterial submaterial,entryentity.submatvers submatvers,entryentity.subauxproperty subauxproperty,entryentity.qty qty,entryentity.stdprice standardcost,entryentity.price stdprice", (QFilter[])new QFilter[]{idFilter, dataTypeFilter});
        } else if (hasMatCostInfo) {
            QFilter matcostFilter = new QFilter("costtype", "=", (Object)Long.valueOf(costtypeid));
            matcostFilter.and(new QFilter("material", "=", (Object)Long.valueOf(materialid)));
            if (StringUtils.isNotEmpty((String)auxptyid)) {
                matcostFilter.and(new QFilter("auxpty", "=", (Object)Long.valueOf(auxptyid)));
            }
            if (StringUtils.isNotEmpty((String)matverid)) {
                matcostFilter.and(new QFilter("matversion", "=", (Object)Long.valueOf(matverid)));
            }
            matcostFilter.and(new QFilter("effectdate", "<=", (Object)bizDate));
            matcostFilter.and(new QFilter("expdate", ">=", (Object)bizDate));
            matCostInfos = QueryServiceHelper.query((String)"cad_matcostinfo", (String)"id,effectdate,expdate,entryentity.element element,entryentity.subelement subelement,0 submaterial,0 submatvers,0 subauxproperty,0 qty,0 stdprice,entryentity.standardcost standardcost", (QFilter[])new QFilter[]{matcostFilter, bizDateFilter});
        }
        return CadEmptyUtils.isEmpty(matCostInfos) ? null : matCostInfos;
    }

    public static Map<String, Map<Long, List<DynamicObject>>> getMatCostInfo2(Long costTypeId, Set<Long> matIds, Date minDate, Date maxDate) {
        if (CadEmptyUtils.isEmpty(matIds) || CadEmptyUtils.isEmpty(costTypeId)) {
            return null;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and(new QFilter("entryentity.datatype", "in", Arrays.asList("2", "3")));
        filter.and(new QFilter("material", "in", matIds));
        filter.and(new QFilter("ismaindata", "=", (Object)1));
        filter.and(new QFilter("isleaf", "=", (Object)"0"));
        QFilter bizDateFilter = new QFilter("effectdate", "<=", (Object)maxDate);
        bizDateFilter.and(new QFilter("expdate", ">=", (Object)minDate));
        DataSet effeResDS = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.utils.MatCostHelper.getMatCostInfo2", (String)"cad_calceffectiveresult", (String)"id, material, auxproperty, matvers, effectdate, expdate", (QFilter[])new QFilter[]{filter, bizDateFilter}, (String)"");
        HashSet<Long> effeResIds = new HashSet<Long>(16);
        for (Row row : effeResDS) {
            effeResIds.add(row.getLong("id"));
        }
        HashMap<String, Map<Long, List<DynamicObject>>> matCostInfoMap = new HashMap<String, Map<Long, List<DynamicObject>>>(3);
        HashMap<Long, List> effeResMap = new HashMap<Long, List>(16);
        if (!effeResIds.isEmpty()) {
            QFilter idQf = new QFilter("id", "in", effeResIds);
            QFilter dataTypeQf = new QFilter("entryentity.datatype", "in", Arrays.asList("2", "3"));
            DynamicObjectCollection effeResMatCostInfo = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)"id, effectdate, expdate,material,matvers AS matver,auxproperty AS auxpty,entryentity.datatype,entryentity.resource AS resource,entryentity.calcbasis AS calcbasis,entryentity.element AS element,entryentity.subelement AS subelement,entryentity.submaterial AS submaterial,entryentity.submatvers AS submatvers,entryentity.subauxproperty AS subauxproperty,entryentity.qty AS qty,entryentity.stdprice AS standardcost,entryentity.price AS price", (QFilter[])new QFilter[]{idQf, dataTypeQf});
            for (DynamicObject effeResMatCost : effeResMatCostInfo) {
                effeResMap.computeIfAbsent(effeResMatCost.getLong("id"), s -> new ArrayList()).add(effeResMatCost);
            }
            if (!effeResMap.isEmpty()) {
                matCostInfoMap.put("effeResMatCostInfo", effeResMap);
            }
        }
        HashMap<Long, List> matCostMap = new HashMap<Long, List>(16);
        if (!matIds.isEmpty()) {
            QFilter matCostFilter = new QFilter("costtype", "=", (Object)costTypeId);
            matCostFilter.and(new QFilter("material", "in", matIds));
            DynamicObjectCollection commonMatCostInfo = QueryServiceHelper.query((String)"cad_matcostinfo", (String)"id, effectdate, expdate,material,matversion AS matver,auxpty AS auxpty,entryentity.element AS element,entryentity.subelement AS subelement,0 resource,0 submaterial,0 submatvers,0 subauxproperty,0 qty,0 price,entryentity.standardcost AS standardcost", (QFilter[])new QFilter[]{matCostFilter, bizDateFilter});
            for (DynamicObject commonMatCost : commonMatCostInfo) {
                matCostMap.computeIfAbsent(commonMatCost.getLong("id"), s -> new ArrayList()).add(commonMatCost);
            }
            if (!matCostMap.isEmpty()) {
                matCostInfoMap.put("commonMatCostInfo", matCostMap);
            }
        }
        return matCostInfoMap;
    }

    public static Map<String, Map<String, List<BigDecimal>>> getMatCostInfo(Set<Long> allocIds) {
        if (CadEmptyUtils.isEmpty(allocIds)) {
            return null;
        }
        QFilter filter = new QFilter("id", "in", allocIds);
        DynamicObjectCollection allocInfos = QueryServiceHelper.query((String)"sca_matalloc", (String)"id,org,costaccount,material,matcostinfo", (QFilter[])new QFilter[]{filter});
        HashMap<String, Map<String, List<BigDecimal>>> matcostInfoMap = new HashMap<String, Map<String, List<BigDecimal>>>(16);
        HashMap<Long, Set> costaccountSetMap = new HashMap<Long, Set>(16);
        for (DynamicObject allocInfo : allocInfos) {
            Long costacount = allocInfo.getLong("costaccount");
            costaccountSetMap.computeIfAbsent(costacount, t -> new HashSet()).add(allocInfo.getLong("matcostinfo"));
        }
        for (Map.Entry costaccountSetEntry : costaccountSetMap.entrySet()) {
            Map<String, Map<String, List<BigDecimal>>> matstdcostInfoMap = MatCostHelper.getMatCostInfo((Set)costaccountSetEntry.getValue(), new String[]{"2", "3"}, (Long)costaccountSetEntry.getKey());
            matcostInfoMap.putAll(matstdcostInfoMap);
        }
        return matcostInfoMap;
    }

    public static Map<String, Map<String, List<BigDecimal>>> getMatCostInfo(Set<Long> ids, String[] dataType, Long costAccountId) {
        DynamicObject[] purpInfos;
        DynamicObject[] calcInfos;
        HashMap<String, Map<String, List<BigDecimal>>> matcostInfoMap = new HashMap<String, Map<String, List<BigDecimal>>>(16);
        QFilter calcFilter = new QFilter("matcostid", "in", ids);
        calcFilter.and(new QFilter("entryentity.datatype", "in", (Object)dataType));
        for (DynamicObject calcInfo : calcInfos = BusinessDataServiceHelper.load((String)"cad_calceffectiveresult", (String)"id,entryentity.element,entryentity.subelement,entryentity.submaterial,entryentity.submatvers,entryentity.subauxproperty,entryentity.qty,entryentity.stdprice,entryentity.datatype,entryentity.resource, entryentity.calcbasis", (QFilter[])new QFilter[]{calcFilter})) {
            String calcId = calcInfo.getString("id");
            HashMap matCalcInfo = new HashMap();
            DynamicObjectCollection calcEntryInfos = calcInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject calcEntryInfo : calcEntryInfos) {
                if (!Arrays.asList(dataType).contains(calcEntryInfo.getString("datatype"))) continue;
                StringBuilder key = new StringBuilder();
                key.append(calcEntryInfo.getLong("element.masterid")).append("@");
                key.append(calcEntryInfo.getLong("subelement.masterid")).append("@");
                key.append(calcEntryInfo.getLong("submaterial.masterid")).append("@");
                key.append(calcEntryInfo.getLong("submatvers.masterid")).append("@");
                key.append(calcEntryInfo.getLong("subauxproperty.masterid")).append("@");
                key.append(calcEntryInfo.getPkValue().toString()).append("@");
                key.append(calcEntryInfo.getLong("resource.id")).append("@");
                String calcbasis = StringUtils.isEmpty((String)calcEntryInfo.getString("calcbasis")) ? " " : calcEntryInfo.getString("calcbasis");
                key.append(calcbasis).append("@");
                ArrayList<BigDecimal> qtyandcost = new ArrayList<BigDecimal>();
                qtyandcost.add(calcEntryInfo.getBigDecimal("qty"));
                qtyandcost.add(calcEntryInfo.getBigDecimal("stdprice"));
                matCalcInfo.put(key.toString(), qtyandcost);
            }
            matcostInfoMap.put(calcId, matCalcInfo);
        }
        QFilter purpFilter = new QFilter("matcostid", "in", ids);
        for (DynamicObject purpInfo : purpInfos = BusinessDataServiceHelper.load((String)"cad_purprices", (String)"id,material,matversion,auxpty,entryentity.element,entryentity.subelement,amount,entryentity.price", (QFilter[])new QFilter[]{purpFilter})) {
            String purpId = purpInfo.getString("id");
            HashMap matCalcInfo = new HashMap();
            DynamicObjectCollection purpEntryInfos = purpInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject purpEntryInfo : purpEntryInfos) {
                StringBuilder key = new StringBuilder();
                key.append(purpEntryInfo.getLong("element.masterid")).append("@");
                key.append(purpEntryInfo.getLong("subelement.masterid")).append("@");
                key.append(purpInfo.getLong("material.masterid")).append("@");
                key.append(purpInfo.getLong("matversion.id")).append("@");
                key.append(purpInfo.getLong("auxpty.id")).append("@");
                key.append(purpEntryInfo.getPkValue().toString()).append("@");
                key.append(0L).append("@");
                key.append(" ").append("@");
                ArrayList<BigDecimal> qtyandcost = new ArrayList<BigDecimal>();
                qtyandcost.add(BigDecimal.ZERO);
                qtyandcost.add(purpEntryInfo.getBigDecimal("price"));
                matCalcInfo.put(key.toString(), qtyandcost);
            }
            matcostInfoMap.put(purpId, matCalcInfo);
        }
        QFilter recQf = new QFilter("entry.bizbillentryid", "in", ids);
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)"id, entry.bizbillentryid AS bizbillentryid,entry.id AS entryid,entry.material.masterid AS material,entry.mversion.id AS matversion,entry.assist.id AS auxpty,entry.subentrycostelement.sub_actualcost AS subactualcost,entry.subentrycostelement.sub_unitactualcost AS subunitactualcost,entry.subentrycostelement.costelement.masterid AS element,entry.subentrycostelement.costsubelement.masterid AS subelement", (QFilter[])new QFilter[]{recQf, new QFilter("costaccount", "=", (Object)costAccountId)});
        for (DynamicObject calRec : costRecords) {
            BigDecimal subactualcost = (BigDecimal)calRec.get("subactualcost");
            if (BigDecimal.ZERO.compareTo(subactualcost) == 0) continue;
            StringBuilder key = new StringBuilder();
            key.append(calRec.getLong("element")).append("@");
            key.append(calRec.getLong("subelement")).append("@");
            key.append(calRec.getLong("material")).append("@");
            key.append(calRec.getLong("matversion")).append("@");
            key.append(calRec.getLong("auxpty")).append("@");
            key.append(calRec.getLong("entryid")).append("@");
            key.append(0L).append("@");
            key.append(" ").append("@");
            ArrayList<BigDecimal> qtyandcost = new ArrayList<BigDecimal>();
            qtyandcost.add(BigDecimal.ZERO);
            qtyandcost.add(calRec.getBigDecimal("subunitactualcost"));
            String calRecId = calRec.getString("bizbillentryid");
            matcostInfoMap.computeIfAbsent(calRecId, s -> new HashMap()).put(key.toString(), qtyandcost);
        }
        return matcostInfoMap;
    }
}

