/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.sca.algox.calc.input.CalcDataArgsByCostRecovery;
import kd.macc.sca.algox.calc.input.CalcMaterial;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.utils.RestoreCalcByCostRecoveryHelper;
import kd.macc.sca.algox.utils.RestoreCalcHelper;

public class MatLevelHelper {
    public List<Set<CalcMaterial>> getMatLevelByRecovery(CostRecoveryParams crParams) {
        CalcDataArgsByCostRecovery args = new CalcDataArgsByCostRecovery();
        args.setOrgId(crParams.getCalOrgId());
        args.setCostAccount(crParams.getCostAccountId());
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)crParams.getPeriodId(), (String)"bd_period");
        args.setPeriod(period.getLong("id"));
        args.setStartDate(period.getDate("begindate"));
        args.setEndDate(period.getDate("enddate"));
        args.setRecovery(true);
        args.setMfcorgid(crParams.getManuOrgId());
        args.setCalOrgIds(crParams.getRelationCalOrgIds());
        args.setCostAccounts(crParams.getRelationCostAccountIds());
        Set<CalcMaterial> mats = RestoreCalcByCostRecoveryHelper.getCalcMaterial(args);
        if (mats.isEmpty()) {
            return null;
        }
        ArrayList<Set<CalcMaterial>> matLevelList = new ArrayList<Set<CalcMaterial>>(args.getMaxMatLevel());
        HashSet<Long> dealCurCalcMats = new HashSet<Long>();
        for (int i = args.getMaxMatLevel(); i >= 0; --i) {
            Set<CalcMaterial> curCalcMat = RestoreCalcHelper.getCurLevelMat(i, mats);
            if (curCalcMat == null || curCalcMat.isEmpty()) continue;
            HashSet<CalcMaterial> curCalcMats = new HashSet<CalcMaterial>();
            for (CalcMaterial mat : curCalcMat) {
                if (dealCurCalcMats.contains(mat.getMaterialId())) continue;
                curCalcMats.add(mat);
                dealCurCalcMats.add(mat.getMaterialId());
            }
            matLevelList.add(curCalcMats);
        }
        return matLevelList;
    }
}

