/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.sca.algox.calc.input.LevelMatCode;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class MaterialLevelHelper {
    private static final Log logger = LogFactory.getLog(MaterialLevelHelper.class);
    private static final String SPLIT_STR = "---";

    public static List<List<LevelMatCode>> getMatLevelList(DataSet cacheMatDs, Set<String> specifyMatIds, Map<String, String> relaMatMainJoinMap, Set<LevelMatCode> legalCheckLvlMats, List<List<String>> nestMatGroups, Set<String> nestMatTreePaths, boolean nestDeal) {
        Set<LevelMatCode> mats = MaterialLevelHelper.getCalcMaterial(cacheMatDs, specifyMatIds, relaMatMainJoinMap, legalCheckLvlMats, nestMatGroups, nestMatTreePaths, nestDeal);
        if (mats.isEmpty()) {
            return Lists.newArrayList();
        }
        int maxMatLevel = MaterialLevelHelper.getMaxLevel(mats);
        ArrayList<List<LevelMatCode>> matLevelList = new ArrayList<List<LevelMatCode>>(maxMatLevel);
        HashSet<String> dealCurCalcMats = new HashSet<String>();
        for (int i = maxMatLevel; i >= 0; --i) {
            Set<LevelMatCode> curCalcMat = MaterialLevelHelper.getCurLevelMat(i, mats);
            if (curCalcMat == null || curCalcMat.isEmpty()) continue;
            ArrayList curCalcMats = Lists.newArrayList();
            for (LevelMatCode mat : curCalcMat) {
                if (dealCurCalcMats.contains(mat.getSubMaterialKey())) continue;
                curCalcMats.add(mat);
                dealCurCalcMats.add(mat.getSubMaterialKey());
            }
            matLevelList.add(curCalcMats);
        }
        return matLevelList;
    }

    private static Set<LevelMatCode> getCalcMaterial(DataSet cacheMatDs, Set<String> specifyMatIds, Map<String, String> relaMatMainJoinMap, Set<LevelMatCode> legalCheckLvlMats, List<List<String>> nestMatGroups, Set<String> nestMatTreePaths, boolean nestDeal) {
        long start = System.currentTimeMillis();
        Map<String, Map<String, LevelMatCode>> dataMap = MaterialLevelHelper.getCalcMat(cacheMatDs);
        logger.info("\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e00\uff1a\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        if (nestDeal) {
            start = System.currentTimeMillis();
            logger.info("\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e8c\uff1a\u5f00\u59cb");
            String execType = CadBgParamUtils.getCadBgParamForString((String)"nestMatDealPerform", (String)"3");
            if ("1".equals(execType)) {
                dataMap = MaterialLevelHelper.dealNestMatGroup(dataMap, nestMatGroups, nestMatTreePaths, execType);
            } else if ("2".equals(execType)) {
                dataMap = MaterialLevelHelper.dealNestMatGroup(dataMap, nestMatGroups, nestMatTreePaths, execType);
            } else if ("3".equals(execType)) {
                dataMap = MaterialLevelHelper.dealNestMatGroup(dataMap, nestMatGroups, nestMatTreePaths, "1");
                HashSet<String> hashSet = new HashSet<String>(10);
                dataMap = MaterialLevelHelper.dealNestMatGroup(dataMap, nestMatGroups, hashSet, "0");
                nestMatTreePaths.addAll(hashSet);
            } else {
                dataMap = "4".equals(execType) ? MaterialLevelHelper.dealNestMatGroup(dataMap, nestMatGroups, nestMatTreePaths, "4") : MaterialLevelHelper.dealNestMatGroup(dataMap, nestMatGroups, nestMatTreePaths, "0");
            }
            logger.info("\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e8c\uff1atype:{},\u8017\u65f6\uff1a{}", (Object)execType, (Object)(System.currentTimeMillis() - start));
        }
        if (!CadEmptyUtils.isEmpty(specifyMatIds)) {
            start = System.currentTimeMillis();
            logger.info("\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e09\uff1a\u5f00\u59cb");
            if (relaMatMainJoinMap == null) {
                relaMatMainJoinMap = Maps.newHashMapWithExpectedSize((int)2);
            }
            dataMap = MaterialLevelHelper.dealSpecifyMat(dataMap, nestMatGroups, specifyMatIds, relaMatMainJoinMap);
            logger.info("\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e09\uff1a\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        if (legalCheckLvlMats != null) {
            for (Map.Entry entry : dataMap.entrySet()) {
                for (Map.Entry<Object, Object> entry2 : ((Map)entry.getValue()).entrySet()) {
                    legalCheckLvlMats.add((LevelMatCode)entry2.getValue());
                }
            }
        }
        start = System.currentTimeMillis();
        Map<String, List<LevelMatCode>> keyParentValSubListMap = MaterialLevelHelper.dealLevelNew(dataMap);
        logger.info("\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u56db\uff1a\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)3000);
        for (Map.Entry<Object, Object> entry : dataMap.entrySet()) {
            for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                hashSet.add(subEntry.getValue());
            }
        }
        start = System.currentTimeMillis();
        MaterialLevelHelper.dealLeaf(hashSet, keyParentValSubListMap);
        logger.info("\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e94\uff1a\u8017\u65f6\uff1a%s", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        int maxMatLevel = MaterialLevelHelper.getMaxLevel(hashSet);
        logger.info("\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u516d\uff1a\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        Set<LevelMatCode> set = MaterialLevelHelper.getLeafMat(hashSet);
        start = System.currentTimeMillis();
        MaterialLevelHelper.downLeafLevel(set, maxMatLevel);
        logger.info("\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e03\uff1a\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return hashSet;
    }

    private static Map<String, Map<String, LevelMatCode>> dealSpecifyMat(Map<String, Map<String, LevelMatCode>> dataMap, List<List<String>> nestMatGroups, Set<String> specifyMatIds, Map<String, String> relaMatMainJoinMap) {
        boolean bl;
        if (dataMap.size() == 0) {
            return dataMap;
        }
        HashMap materialSubListMap = Maps.newHashMapWithExpectedSize((int)160);
        ArrayList<LevelMatCode> allMat = new ArrayList<LevelMatCode>(dataMap.size());
        for (Map.Entry<String, Map<String, LevelMatCode>> entry : dataMap.entrySet()) {
            for (Map.Entry<String, LevelMatCode> entry2 : entry.getValue().entrySet()) {
                LevelMatCode acm = entry2.getValue();
                allMat.add(acm);
                materialSubListMap.computeIfAbsent(acm.getSubmaterial(), p -> Lists.newArrayList()).add(acm);
            }
        }
        HashSet<String> specifyData = new HashSet<String>(16);
        for (String string : specifyMatIds) {
            Object material22;
            LevelMatCode levelMatCode = MaterialLevelHelper.getDiffMaterialFromString(string);
            if (levelMatCode.getSubmaterial() == 0L) continue;
            List matList = (List)materialSubListMap.get(levelMatCode.getSubmaterial());
            if (!CadEmptyUtils.isEmpty(matList)) {
                for (Object material22 : matList) {
                    if (!MaterialLevelHelper.matchMaterialCode(levelMatCode, (LevelMatCode)material22)) continue;
                    specifyData.add(((LevelMatCode)material22).getSubMaterialKey());
                }
            }
            String materialKeyPre = levelMatCode.getSubmaterial() + "@";
            material22 = nestMatGroups.iterator();
            while (material22.hasNext()) {
                List matGroup = (List)material22.next();
                for (String matId : matGroup) {
                    LevelMatCode targetDto;
                    if (!matId.contains(materialKeyPre) || !MaterialLevelHelper.matchMaterialCode(levelMatCode, targetDto = MaterialLevelHelper.getDiffMaterialFromString(matId))) continue;
                    specifyData.add(matId);
                }
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (String string : specifyData) {
            String relaMatId = relaMatMainJoinMap.get(string);
            if (relaMatId == null) continue;
            arrayList.add(relaMatId);
        }
        specifyData.addAll(arrayList);
        for (List<String> list : nestMatGroups) {
            boolean isContains = false;
            for (String matId : list) {
                if (!specifyData.contains(matId)) continue;
                isContains = true;
                break;
            }
            if (!isContains) continue;
            specifyData.addAll(list);
        }
        boolean bl2 = true;
        while (bl) {
            bl = false;
            for (LevelMatCode calcMat : allMat) {
                long parentId;
                if (!specifyData.contains(calcMat.getSubMaterialKey()) || (parentId = calcMat.getMaterial()) == 0L || !specifyData.add(calcMat.getParMaterialKey())) continue;
                String relaMatId = relaMatMainJoinMap.get(calcMat.getParMaterialKey());
                if (relaMatId != null) {
                    specifyData.add(relaMatId);
                }
                bl = true;
            }
        }
        ArrayList<LevelMatCode> arrayList2 = new ArrayList<LevelMatCode>(10);
        for (LevelMatCode calcMat : allMat) {
            if (!specifyData.contains(calcMat.getSubMaterialKey())) continue;
            arrayList2.add(calcMat);
        }
        HashMap materialsHashMap = Maps.newHashMapWithExpectedSize((int)20);
        for (LevelMatCode calcMat : arrayList2) {
            materialsHashMap.computeIfAbsent(calcMat.getSubMaterialKey(), p -> Maps.newHashMapWithExpectedSize((int)16)).put(calcMat.getUniqueKey(), calcMat);
        }
        return materialsHashMap;
    }

    public static LevelMatCode getDiffMaterialFromString(String materialData) {
        LevelMatCode dto = new LevelMatCode();
        String[] keyArr = materialData.split("@");
        dto.setSubmaterial(Long.parseLong(keyArr[0]));
        dto.setSubmatversion(Long.parseLong(keyArr[1]));
        dto.setSubauxpty(Long.parseLong(keyArr[2]));
        dto.setSubconfiguredcode(Long.parseLong(keyArr[3]));
        dto.setSubtracknumber(Long.parseLong(keyArr[4]));
        dto.setSubproject(Long.parseLong(keyArr[5]));
        if (keyArr.length >= 7) {
            dto.setSublot(keyArr[6]);
        }
        if (keyArr.length >= 8) {
            dto.setSubcalckeycol(Long.parseLong(keyArr[7]));
        }
        return dto;
    }

    private static boolean matchMaterialCode(LevelMatCode srcDto, LevelMatCode targetDto) {
        if (srcDto.getSubauxpty() != 0L && targetDto.getSubauxpty() != srcDto.getSubauxpty()) {
            return false;
        }
        if (srcDto.getSubconfiguredcode() != 0L && targetDto.getSubconfiguredcode() != srcDto.getSubconfiguredcode()) {
            return false;
        }
        if (srcDto.getSubtracknumber() != 0L && targetDto.getSubtracknumber() != srcDto.getSubtracknumber()) {
            return false;
        }
        if (srcDto.getSubproject() != 0L && targetDto.getSubproject() != srcDto.getSubproject()) {
            return false;
        }
        return StringUtils.isEmpty((CharSequence)srcDto.getSublot()) || targetDto.getSublot().equals(srcDto.getSublot());
    }

    private static Map<String, Map<String, LevelMatCode>> dealNestMatGroup(Map<String, Map<String, LevelMatCode>> dataMap, List<List<String>> nestMatGroups, Set<String> nestMatTreePaths, String execType) {
        HashMap keyParentValSubListMap = Maps.newHashMapWithExpectedSize((int)160);
        ArrayList<LevelMatCode> topMat = new ArrayList<LevelMatCode>(10);
        for (Map.Entry<String, Map<String, LevelMatCode>> entry : dataMap.entrySet()) {
            for (Map.Entry<String, LevelMatCode> subEntry : entry.getValue().entrySet()) {
                LevelMatCode acm = subEntry.getValue();
                topMat.add(acm);
                if (acm.getMaterial() <= 0L) continue;
                String key = acm.getParMaterialKey();
                keyParentValSubListMap.computeIfAbsent(key, p -> Lists.newArrayList()).add(acm);
            }
        }
        logger.info("\u5d4c\u5957\u9886\u6599\u8282\u70b9\u6570\uff1a{}", (Object)topMat.size());
        long[] size = new long[1];
        HashSet nestMatIds = null;
        HashSet checkMatIds = null;
        if ("1".equals(execType)) {
            nestMatIds = Sets.newHashSetWithExpectedSize((int)1024);
        } else if ("2".equals(execType)) {
            checkMatIds = Sets.newHashSetWithExpectedSize((int)1024);
        }
        long start = System.currentTimeMillis();
        for (LevelMatCode calcMat : topMat) {
            String key = calcMat.getSubMaterialKey();
            if (!keyParentValSubListMap.containsKey(key)) continue;
            calcMat.setPath(calcMat.getParMaterialKey() + SPLIT_STR + calcMat.getSubMaterialKey());
            if (calcMat.getSubMaterialKey().equals(calcMat.getParMaterialKey())) {
                nestMatTreePaths.add(SPLIT_STR + calcMat.getPath());
                continue;
            }
            if ("4".equals(execType)) continue;
            if (nestMatIds != null) {
                MaterialLevelHelper.concatPath1(null, calcMat, keyParentValSubListMap, nestMatTreePaths, size, nestMatIds);
                continue;
            }
            MaterialLevelHelper.concatPath(calcMat, keyParentValSubListMap, nestMatTreePaths, size, calcMat.getPath(), checkMatIds);
            if (checkMatIds == null) continue;
            checkMatIds.add(calcMat.getSubMaterialKey());
        }
        if ("4".equals(execType)) {
            MaterialLevelHelper.groupConcatPath(topMat, keyParentValSubListMap, nestMatGroups, nestMatTreePaths, size);
        }
        logger.info("\u5d4c\u5957\u9886\u6599\u68c0\u67e5\u6b21\u6570\uff1a{},execType:{},nestIds:{},checkMatIds:{}", new Object[]{size[0], execType, nestMatIds == null ? -1 : nestMatIds.size(), checkMatIds == null ? -1 : checkMatIds.size()});
        if (nestMatTreePaths.isEmpty()) {
            return dataMap;
        }
        nestMatGroups.addAll(MaterialLevelHelper.dealMatGroupListUseSet(nestMatTreePaths));
        MaterialLevelHelper.dealGroupMerge(nestMatGroups);
        if (!nestMatGroups.isEmpty()) {
            return MaterialLevelHelper.replaceMatNodeByMatGroupUseMap(topMat, nestMatGroups);
        }
        return dataMap;
    }

    private static void groupConcatPath(List<LevelMatCode> topMat, Map<String, List<LevelMatCode>> keyParentValSubListMap, List<List<String>> nestMatGroups, Set<String> nestMatTreePaths, long[] size) {
        HashMap<String, Integer> dfn = new HashMap<String, Integer>();
        HashMap<String, Integer> low = new HashMap<String, Integer>();
        ArrayDeque<String> trace = new ArrayDeque<String>();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        int index = 0;
        for (LevelMatCode levelMatCode : topMat) {
            if (dfn.containsKey(levelMatCode.getSubMaterialKey())) continue;
            index = MaterialLevelHelper.grouping(levelMatCode.getSubMaterialKey(), keyParentValSubListMap, nestMatGroups, dfn, low, trace, stack, index);
        }
        for (List list : nestMatGroups) {
            for (String mat : list) {
                MaterialLevelHelper.generatePath(mat, keyParentValSubListMap, nestMatTreePaths);
            }
        }
    }

    private static int grouping(String mat, Map<String, List<LevelMatCode>> keyParentValSubListMap, List<List<String>> nestMatGroups, Map<String, Integer> dfn, Map<String, Integer> low, Deque<String> trace, Deque<String> stack, int index) {
        stack.push(mat);
        HashMap<String, String> parent = new HashMap<String, String>();
        parent.put(mat, mat);
        while (!stack.isEmpty()) {
            String curMat;
            mat = stack.peek();
            if (!dfn.containsKey(mat)) {
                trace.addLast(mat);
                dfn.put(mat, ++index);
                low.put(mat, index);
            }
            boolean flag = false;
            List<LevelMatCode> subMats = keyParentValSubListMap.get(mat);
            if (subMats != null) {
                for (LevelMatCode subMatCode : subMats) {
                    String subMat = subMatCode.getSubMaterialKey();
                    parent.put(subMat, mat);
                    if (!dfn.containsKey(subMat)) {
                        flag = true;
                        stack.push(subMat);
                        continue;
                    }
                    low.put(mat, Math.min(low.get(mat), low.get(subMat)));
                }
            }
            if (flag) continue;
            mat = stack.pop();
            low.put((String)parent.get(mat), Math.min(low.get(parent.get(mat)), low.get(mat)));
            if (!low.get(mat).equals(dfn.get(mat))) continue;
            ArrayList<String> nestMatGroup = new ArrayList<String>();
            do {
                curMat = trace.pollLast();
                nestMatGroup.add(curMat);
                low.put(curMat, Integer.MAX_VALUE);
            } while (!mat.equals(curMat));
            if (nestMatGroup.size() <= 1) continue;
            nestMatGroups.add(nestMatGroup);
        }
        return index;
    }

    public static void generatePath(String material, Map<String, List<LevelMatCode>> materialsMap, Set<String> errorMatList) {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        ArrayDeque<StringBuilder> pathStack = new ArrayDeque<StringBuilder>();
        HashSet<String> visit = new HashSet<String>(1024);
        StringBuilder currentPath = new StringBuilder(material);
        stack.push(material);
        pathStack.push(currentPath);
        while (!stack.isEmpty()) {
            material = (String)stack.pop();
            currentPath = (StringBuilder)pathStack.pop();
            if (visit.contains(material)) {
                errorMatList.add(currentPath.substring(currentPath.indexOf(material)));
                continue;
            }
            visit.add(material);
            List<LevelMatCode> subMaterials = materialsMap.get(material);
            if (subMaterials == null) continue;
            for (LevelMatCode subMaterial : subMaterials) {
                StringBuilder nextPath = new StringBuilder(currentPath).append(SPLIT_STR).append(subMaterial.getSubMaterialKey());
                stack.push(subMaterial.getSubMaterialKey());
                pathStack.push(nextPath);
            }
        }
    }

    private static void concatPath(LevelMatCode parentMat, Map<String, List<LevelMatCode>> materialsMap, Set<String> errorMatList, long[] size, String path, Set<String> checkMatIds) {
        size[0] = size[0] + 1L;
        List<LevelMatCode> subMatList = materialsMap.get(parentMat.getSubMaterialKey());
        if (subMatList == null) {
            return;
        }
        for (LevelMatCode curMat : subMatList) {
            if (curMat.getSubMaterialKey().equals(curMat.getParMaterialKey())) continue;
            String curPath = path + SPLIT_STR + curMat.getSubMaterialKey();
            int index = (path + SPLIT_STR).indexOf(curMat.getSubMaterialKey() + SPLIT_STR);
            if (index > -1) {
                String epath = SPLIT_STR + curPath.substring(index);
                errorMatList.add(epath);
                continue;
            }
            if (curMat.getSubMaterialKey().equals(parentMat.getParMaterialKey()) && parentMat.getSubMaterialKey().equals(curMat.getParMaterialKey()) || checkMatIds != null && checkMatIds.contains(curMat.getSubMaterialKey())) continue;
            MaterialLevelHelper.concatPath(curMat, materialsMap, errorMatList, size, curPath, checkMatIds);
        }
    }

    private static Map<String, Map<String, LevelMatCode>> replaceMatNodeByMatGroupUseMap(List<LevelMatCode> topMat, List<List<String>> nestMatGroup) {
        ArrayList<LevelMatCode> newMatList = new ArrayList<LevelMatCode>(10);
        HashMap nestGroupToMatMap = Maps.newHashMapWithExpectedSize((int)10);
        for (List<String> list : nestMatGroup) {
            if (list.size() == 1) continue;
            String matId = list.get(0);
            nestGroupToMatMap.put(list, matId);
        }
        for (Map.Entry entry : nestGroupToMatMap.entrySet()) {
            List nestGroup = (List)entry.getKey();
            String[] keyArr = ((String)entry.getValue()).split("@");
            long materialId = Long.parseLong(keyArr[0]);
            long materialVer = Long.parseLong(keyArr[1]);
            long materialAuxPropId = Long.parseLong(keyArr[2]);
            long configuredcode = Long.parseLong(keyArr[3]);
            long tracknumber = Long.parseLong(keyArr[4]);
            long project = Long.parseLong(keyArr[5]);
            String lot = "";
            if (keyArr.length >= 7) {
                lot = keyArr[6];
            }
            long calckeycol = 0L;
            if (keyArr.length >= 8) {
                calckeycol = Long.parseLong(keyArr[7]);
            }
            HashSet nestGroupSet = new HashSet(nestGroup);
            for (LevelMatCode calcMat : topMat) {
                if (nestGroupSet.contains(calcMat.getParMaterialKey()) && !calcMat.getParMaterialKey().equals(entry.getValue())) {
                    calcMat.setMaterial(materialId);
                    calcMat.setAuxpty(materialAuxPropId);
                    calcMat.setMatversion(materialVer);
                    calcMat.setConfiguredcode(configuredcode);
                    calcMat.setTracknumber(tracknumber);
                    calcMat.setProject(project);
                    calcMat.setLot(lot);
                    calcMat.setCalckeycol(calckeycol);
                }
                if (!nestGroupSet.contains(calcMat.getSubMaterialKey()) || calcMat.getSubMaterialKey().equals(entry.getValue())) continue;
                calcMat.setSubmaterial(materialId);
                calcMat.setSubauxpty(materialAuxPropId);
                calcMat.setSubmatversion(materialVer);
                calcMat.setSubconfiguredcode(configuredcode);
                calcMat.setSubtracknumber(tracknumber);
                calcMat.setSubproject(project);
                calcMat.setSublot(lot);
                calcMat.setSubcalckeycol(calckeycol);
            }
        }
        for (LevelMatCode levelMatCode : topMat) {
            if (levelMatCode.getSubMaterialKey().equals(levelMatCode.getParMaterialKey())) continue;
            newMatList.add(levelMatCode);
        }
        HashMap materialsHashMap = Maps.newHashMapWithExpectedSize((int)20);
        for (LevelMatCode calcMat : newMatList) {
            materialsHashMap.computeIfAbsent(calcMat.getSubMaterialKey(), p -> Maps.newHashMapWithExpectedSize((int)16)).put(calcMat.getUniqueKey(), calcMat);
        }
        return materialsHashMap;
    }

    private static List<List<String>> dealMatGroupListUseSet(Set<String> errorMatList) {
        ArrayList nestMatGroup = new ArrayList(10);
        for (String errorMatPath : errorMatList) {
            String[] stringArray = errorMatPath.split(SPLIT_STR);
            if (stringArray.length <= 2) continue;
            HashSet<String> groupIds = new HashSet<String>();
            String nestMatId = stringArray[stringArray.length - 1];
            groupIds.add(nestMatId);
            for (int i = stringArray.length - 2; i >= 0; --i) {
                String nextId = stringArray[i];
                String[] stringArray2 = nextId.split("@");
                if (stringArray2.length > 0 && CadEmptyUtils.isEmpty(stringArray2[0])) continue;
                if (nestMatId.equals(nextId)) break;
                groupIds.add(nextId);
            }
            if (groupIds.isEmpty()) continue;
            boolean isMerge = false;
            for (Set set : nestMatGroup) {
                boolean isContain = false;
                for (String gid : groupIds) {
                    if (!set.contains(gid)) continue;
                    isContain = true;
                    break;
                }
                if (!isContain) continue;
                set.addAll(groupIds);
                isMerge = true;
            }
            if (isMerge) continue;
            nestMatGroup.add(groupIds);
        }
        ArrayList<List<String>> res = new ArrayList<List<String>>(nestMatGroup.size());
        for (Set set : nestMatGroup) {
            res.add(new ArrayList(set));
        }
        return res;
    }

    public static void dealGroupMerge(List<List<String>> nestMatGroup) {
        if (nestMatGroup.isEmpty() || nestMatGroup.size() == 1) {
            return;
        }
        boolean isHasMerge = false;
        List<String> delMatGroup = null;
        for (List<String> matGroup : nestMatGroup) {
            for (List<String> dmatGroup : nestMatGroup) {
                if (matGroup == dmatGroup) continue;
                ArrayList<String> temp = new ArrayList<String>();
                temp.addAll(matGroup);
                temp.retainAll(dmatGroup);
                if (temp.isEmpty() && !dmatGroup.isEmpty()) continue;
                isHasMerge = true;
                delMatGroup = dmatGroup;
                for (String id : dmatGroup) {
                    if (matGroup.contains(id)) continue;
                    matGroup.add(id);
                }
            }
            if (!isHasMerge) continue;
            break;
        }
        if (isHasMerge) {
            nestMatGroup.remove(delMatGroup);
            MaterialLevelHelper.dealGroupMerge(nestMatGroup);
        }
    }

    private static void concatPath1(LevelMatCode lastParentMat, LevelMatCode parentMat, Map<String, List<LevelMatCode>> materialsMap, Set<String> errorMatList, long[] size, Set<String> nestMatIds) {
        size[0] = size[0] + 1L;
        List<LevelMatCode> subMatList = materialsMap.get(parentMat.getSubMaterialKey());
        if (subMatList == null) {
            return;
        }
        for (LevelMatCode curMat : subMatList) {
            String key;
            if (nestMatIds != null && lastParentMat != null && !nestMatIds.add(key = lastParentMat.getParMaterialKey() + SPLIT_STR + parentMat.getParMaterialKey() + SPLIT_STR + curMat.getParMaterialKey() + SPLIT_STR + curMat.getSubMaterialKey()) || curMat.getSubMaterialKey().equals(curMat.getParMaterialKey())) continue;
            curMat.setPath(parentMat.getPath() + SPLIT_STR + curMat.getSubMaterialKey());
            int index = (parentMat.getPath() + SPLIT_STR).indexOf(curMat.getSubMaterialKey() + SPLIT_STR);
            if (index > -1) {
                String epath = SPLIT_STR + curMat.getPath().substring(index);
                errorMatList.add(epath);
                continue;
            }
            if (curMat.getSubMaterialKey().equals(parentMat.getParMaterialKey()) && parentMat.getSubMaterialKey().equals(curMat.getParMaterialKey())) continue;
            MaterialLevelHelper.concatPath1(nestMatIds == null ? null : parentMat, curMat, materialsMap, errorMatList, size, nestMatIds);
        }
    }

    public static String getTreePath(String errorMatPath, String material) {
        int index = errorMatPath.indexOf(material);
        if (index >= 0) {
            return SPLIT_STR + errorMatPath.substring(index);
        }
        return errorMatPath;
    }

    public static String getTreePath(String errorMatPath) {
        String treeMatPath = StringUtils.strip((String)errorMatPath, (String)SPLIT_STR);
        String[] pathNodeArr = treeMatPath.split(SPLIT_STR);
        if (pathNodeArr.length > 2) {
            String nextId;
            String nestMatId = pathNodeArr[pathNodeArr.length - 1];
            int index = 0;
            for (index = pathNodeArr.length - 2; index >= 0 && !nestMatId.equals(nextId = pathNodeArr[index]); --index) {
            }
            StringBuilder sb = new StringBuilder();
            sb.append(SPLIT_STR);
            for (int i = index; i < pathNodeArr.length; ++i) {
                sb.append(pathNodeArr[i]);
                if (i >= pathNodeArr.length - 1) continue;
                sb.append(SPLIT_STR);
            }
            return sb.toString();
        }
        return errorMatPath;
    }

    private static Map<String, List<LevelMatCode>> dealLevelNew(Map<String, Map<String, LevelMatCode>> dataMap) {
        HashMap keyParentValSubListMap = Maps.newHashMapWithExpectedSize((int)160);
        HashSet topMat = Sets.newHashSetWithExpectedSize((int)160);
        for (Map.Entry<String, Map<String, LevelMatCode>> entry : dataMap.entrySet()) {
            for (Map.Entry<String, LevelMatCode> subEntry : entry.getValue().entrySet()) {
                LevelMatCode acm = subEntry.getValue();
                if (acm.getLevel() == 0) {
                    topMat.add(acm);
                }
                if (acm.getMaterial() <= 0L) continue;
                String key = acm.getParMaterialKey();
                keyParentValSubListMap.computeIfAbsent(key, p -> Lists.newArrayList()).add(acm);
            }
        }
        HashMap<LevelMatCode, Integer> matsLevels = new HashMap<LevelMatCode, Integer>(16);
        for (LevelMatCode mat : topMat) {
            if (!matsLevels.containsKey(mat)) {
                matsLevels.put(mat, 0);
            }
            MaterialLevelHelper.setLevel(mat, keyParentValSubListMap, matsLevels);
        }
        return keyParentValSubListMap;
    }

    private static void setLevel(LevelMatCode mat, Map<String, List<LevelMatCode>> keyParentValSubListMap, Map<LevelMatCode, Integer> matsLevels) {
        String key = mat.getSubMaterialKey();
        List<LevelMatCode> subMats = keyParentValSubListMap.get(key);
        if (subMats == null) {
            return;
        }
        for (LevelMatCode calcMat : subMats) {
            if (!matsLevels.containsKey(calcMat) || matsLevels.get(calcMat) < mat.getLevel() + 1) {
                calcMat.setLevel(mat.getLevel() + 1);
                matsLevels.remove(calcMat);
                matsLevels.put(calcMat, mat.getLevel() + 1);
                if (mat.getLevel() > 30) {
                    break;
                }
            } else {
                calcMat.setLevel(matsLevels.get(calcMat));
                if (matsLevels.get(calcMat) > 30) break;
            }
            MaterialLevelHelper.setLevel(calcMat, keyParentValSubListMap, matsLevels);
        }
    }

    private static void dealLeaf(Set<LevelMatCode> data, Map<String, List<LevelMatCode>> keyParentValSubListMap) {
        for (LevelMatCode mat : data) {
            String key = mat.getSubMaterialKey();
            if (!keyParentValSubListMap.containsKey(key) || keyParentValSubListMap.get(key).isEmpty()) continue;
            mat.setIsleaf(false);
        }
    }

    private static String getMatKey(long materialId, long materialVer, long materialAuxPropId) {
        return String.format("%s@%s@%s", materialId, materialVer, materialAuxPropId);
    }

    private static void downLeafLevel(Set<LevelMatCode> data, int maxLevel) {
        for (LevelMatCode mat : data) {
            mat.setLevel(maxLevel);
        }
    }

    private static Set<LevelMatCode> getCurLevelMat(int level, Set<LevelMatCode> data) {
        return data.stream().filter(cm -> cm.getLevel() == level).collect(Collectors.toSet());
    }

    private static Set<LevelMatCode> getLeafMat(Set<LevelMatCode> data) {
        return data.stream().filter(cm -> cm.isIsleaf()).collect(Collectors.toSet());
    }

    private static int getMaxLevel(Set<LevelMatCode> data) {
        int maxLevel = 0;
        for (LevelMatCode calcMat : data) {
            if (calcMat.getLevel() <= maxLevel) continue;
            maxLevel = calcMat.getLevel();
        }
        return maxLevel;
    }

    private static Map<String, Map<String, LevelMatCode>> getCalcMat(DataSet cacheMatDs) {
        HashMap materialsHashMap = Maps.newHashMapWithExpectedSize((int)32);
        if (cacheMatDs != null) {
            MaterialLevelHelper.dealCurMat(cacheMatDs, materialsHashMap);
        }
        return materialsHashMap;
    }

    private static void dealCurMat(DataSet data, Map<String, Map<String, LevelMatCode>> materialsHashMap) {
        Iterator it = data.iterator();
        Row row = null;
        LevelMatCode curParentMat = null;
        Long curMatId = 0L;
        Long subMatId = 0L;
        LevelMatCode material = null;
        LevelMatCode subMaterial = null;
        int configuredcodeIndex = data.getRowMeta().getFieldIndex("configuredcode", false);
        int tracknumberIndex = data.getRowMeta().getFieldIndex("tracknumber", false);
        int projectIndex = data.getRowMeta().getFieldIndex("project", false);
        int lotIndex = data.getRowMeta().getFieldIndex("lot", false);
        int subconfiguredcodeIndex = data.getRowMeta().getFieldIndex("subconfiguredcode", false);
        int subtracknumberIndex = data.getRowMeta().getFieldIndex("subtracknumber", false);
        int subprojectIndex = data.getRowMeta().getFieldIndex("subproject", false);
        int sublotIndex = data.getRowMeta().getFieldIndex("sublot", false);
        int calckeycolIndex = data.getRowMeta().getFieldIndex("calckeycol", false);
        int subcalckeycolIndex = data.getRowMeta().getFieldIndex("subcalckeycol", false);
        while (it.hasNext()) {
            row = (Row)it.next();
            curMatId = row.getLong("material");
            if (curMatId != 0L) {
                material = new LevelMatCode();
                material.setSubmaterial(curMatId);
                material.setSubmaterialnumber(row.getString("materialnumber"));
                material.setLevel(0);
                material.setSubauxpty(row.getLong("auxpty"));
                material.setSubmatversion(row.getLong("matversion"));
                if (configuredcodeIndex >= 0) {
                    material.setSubconfiguredcode(row.getLong(configuredcodeIndex));
                }
                if (tracknumberIndex >= 0) {
                    material.setSubtracknumber(row.getLong(tracknumberIndex));
                }
                if (projectIndex >= 0) {
                    material.setSubproject(row.getLong(projectIndex));
                }
                if (lotIndex >= 0) {
                    material.setSublot(row.getString(lotIndex));
                }
                if (calckeycolIndex >= 0) {
                    material.setSubcalckeycol(row.getLong(calckeycolIndex));
                }
                if ((curParentMat = MaterialLevelHelper.getParentMaterialWithVer(material, materialsHashMap)) != null) {
                    material = curParentMat;
                }
                if ((subMatId = row.getLong("submaterial")) != 0L) {
                    material.setIsleaf(false);
                }
                if (!MaterialLevelHelper.isSameMaterialAndVer(material, materialsHashMap)) {
                    materialsHashMap.computeIfAbsent(material.getSubMaterialKey(), p -> Maps.newHashMapWithExpectedSize((int)16)).put(material.getUniqueKey(), material);
                }
            }
            if (subMatId == 0L || material == null) continue;
            subMaterial = new LevelMatCode();
            subMaterial.setMaterial(curMatId);
            subMaterial.setAuxpty(material.getSubauxpty());
            subMaterial.setMatversion(material.getSubmatversion());
            subMaterial.setMaterialnumber(material.getSubmaterialnumber());
            subMaterial.setConfiguredcode(material.getSubconfiguredcode());
            subMaterial.setTracknumber(material.getSubtracknumber());
            subMaterial.setProject(material.getSubproject());
            subMaterial.setLot(material.getSublot());
            subMaterial.setCalckeycol(material.getSubcalckeycol());
            subMaterial.setSubmaterial(subMatId);
            subMaterial.setSubmaterialnumber(row.getString("submaterialnumber"));
            subMaterial.setSubauxpty(row.getLong("subauxpty"));
            subMaterial.setSubmatversion(row.getLong("submatversion"));
            if (subconfiguredcodeIndex >= 0) {
                subMaterial.setSubconfiguredcode(row.getLong(subconfiguredcodeIndex));
            }
            if (subtracknumberIndex >= 0) {
                subMaterial.setSubtracknumber(row.getLong(subtracknumberIndex));
            }
            if (subprojectIndex >= 0) {
                subMaterial.setSubproject(row.getLong(subprojectIndex));
            }
            if (sublotIndex >= 0) {
                subMaterial.setSublot(row.getString(sublotIndex));
            }
            if (subcalckeycolIndex >= 0) {
                subMaterial.setSubcalckeycol(row.getLong(subcalckeycolIndex));
            }
            subMaterial.setLevel(material.getLevel() + 1);
            if (MaterialLevelHelper.isSameMaterialAndVer(subMaterial, materialsHashMap)) continue;
            materialsHashMap.computeIfAbsent(subMaterial.getSubMaterialKey(), p -> Maps.newHashMapWithExpectedSize((int)16)).put(subMaterial.getUniqueKey(), subMaterial);
        }
    }

    private static LevelMatCode getParentMaterialWithVer(LevelMatCode material, Map<String, Map<String, LevelMatCode>> materialsHashMap) {
        Map map = materialsHashMap.computeIfAbsent(material.getSubMaterialKey(), p -> Maps.newHashMapWithExpectedSize((int)16));
        for (Map.Entry entry : map.entrySet()) {
            LevelMatCode getMaterial = (LevelMatCode)entry.getValue();
            if (getMaterial == null || getMaterial.getMaterial() <= 0L) continue;
            return getMaterial;
        }
        return null;
    }

    private static boolean isSameMaterialAndVer(LevelMatCode material, Map<String, Map<String, LevelMatCode>> materialsHashMap) {
        LevelMatCode getMaterial = (LevelMatCode)materialsHashMap.computeIfAbsent(material.getSubMaterialKey(), p -> Maps.newHashMapWithExpectedSize((int)16)).get(material.getUniqueKey());
        if (getMaterial != null) {
            if (material.isIsleaf() != getMaterial.isIsleaf()) {
                getMaterial.setIsleaf(false);
            }
            return true;
        }
        return false;
    }
}

