/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.enums.CalcReportEntryEnum;
import kd.macc.sca.algox.enums.CalcReportResultEnum;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.utils.CalcReportHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class RestoreCalcReportHelper
extends CalcReportHelper {
    public static Long initDiffCalcReport(Long taskId, IDataModel model, String taskType) {
        if (model == null) {
            return null;
        }
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sca_taskconfig");
        DynamicObject newCalcReport = BusinessDataServiceHelper.newDynamicObject((String)"sca_restore_calcreport");
        Long id = ID.genLongId();
        String taskName = taskConfig.getString("name");
        if ("3".equals(taskType)) {
            taskName = String.format("%s-%s", taskName, ResManager.loadKDString((String)"\u6307\u5b9a\u7269\u6599", (String)"RestoreCalcReportHelper_0", (String)"macc-sca-algox", (Object[])new Object[0]));
        }
        newCalcReport.set("id", (Object)id);
        newCalcReport.set("taskname", (Object)taskName);
        newCalcReport.set("calcdate", (Object)TimeServiceHelper.now());
        newCalcReport.set("usetime", (Object)0);
        newCalcReport.set("type", (Object)"2");
        newCalcReport.set("progress", (Object)0);
        newCalcReport.set("executor", (Object)Long.parseLong(RequestContext.get().getUserId()));
        newCalcReport.set("billtype", (Object)taskType);
        newCalcReport.set("currency", (Object)((DynamicObject)model.getValue("currency")));
        newCalcReport.set("org", (Object)((DynamicObject)model.getValue("org")));
        newCalcReport.set("costaccount", (Object)((DynamicObject)model.getValue("costaccount")));
        newCalcReport.set("period", (Object)((DynamicObject)model.getValue("period")));
        String[] numberArr = CodeRuleServiceHelper.getBatchNumber((String)"sca_restore_calcreport", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sca_restore_calcreport"), (String)"", (int)1);
        if (numberArr.length > 0) {
            newCalcReport.set("billno", (Object)numberArr[0]);
        }
        newCalcReport.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCalcReport});
        return id;
    }

    public static Long initDiffCalcReport(Long taskId, DiffCalcDataArgs args, String taskType) {
        if (args == null) {
            return null;
        }
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sca_taskconfig");
        DynamicObject newCalcReport = BusinessDataServiceHelper.newDynamicObject((String)"sca_restore_calcreport");
        Long id = ID.genLongId();
        newCalcReport.set("id", (Object)id);
        newCalcReport.set("taskname", (Object)taskConfig.getString("name"));
        newCalcReport.set("calcdate", (Object)TimeServiceHelper.now());
        newCalcReport.set("usetime", (Object)0);
        newCalcReport.set("type", (Object)"2");
        newCalcReport.set("progress", (Object)0);
        newCalcReport.set("executor", (Object)Long.parseLong(RequestContext.get().getUserId()));
        newCalcReport.set("billtype", (Object)taskType);
        newCalcReport.set("currency", (Object)args.getCurrencyId());
        newCalcReport.set("org", (Object)args.getOrgId());
        newCalcReport.set("costaccount", (Object)args.getCostaccountId());
        newCalcReport.set("period", (Object)args.getPeriodId());
        String[] numberArr = CodeRuleServiceHelper.getBatchNumber((String)"sca_restore_calcreport", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sca_restore_calcreport"), (String)"", (int)1);
        if (numberArr.length > 0) {
            newCalcReport.set("billno", (Object)numberArr[0]);
        }
        newCalcReport.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCalcReport});
        return id;
    }

    public static void saveDiffCalcReport(Long calcReportId, DynamicObject taskRecord) {
        RestoreCalcReportHelper.saveDiffCalcReport(calcReportId, taskRecord, null);
    }

    public static void saveDiffCalcReport(Long calcReportId, DynamicObject taskRecord, Long calcPeriodId) {
        DynamicObject calcReport = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"sca_restore_calcreport");
        calcReport.set("usetime", taskRecord.get("time"));
        calcReport.set("progress", taskRecord.get("progress"));
        calcReport.set("type", taskRecord.get("status"));
        calcReport.set("nextpagepara", taskRecord.get("nextpagepara"));
        Long periodId = calcReport.getLong("period.id");
        if (calcPeriodId != null && !periodId.equals(calcPeriodId)) {
            calcReport.set("period", (Object)periodId);
        }
        DynamicObjectCollection taskRecordEntrys = taskRecord.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection calaReportEntrys = calcReport.getDynamicObjectCollection("entryentity");
        ArrayList<Long> unClearId = new ArrayList<Long>(16);
        for (CalcReportEntryEnum value : CalcReportEntryEnum.values()) {
            unClearId.add(value.id);
        }
        calaReportEntrys.removeIf(calaReportEntry -> !unClearId.contains(calaReportEntry.getLong("id")));
        int seq = 1;
        for (DynamicObject entry : taskRecordEntrys) {
            String longTime = entry.get("subtime") == null ? "0" : entry.get("subtime").toString();
            BigDecimal sortTime = new BigDecimal(longTime).divide(new BigDecimal("1000"), 2, 4);
            DynamicObject calaReportEntry2 = calaReportEntrys.addNew();
            calaReportEntry2.set("id", (Object)entry.getLong("id"));
            calaReportEntry2.set("detailconfig", entry.getPkValue());
            calaReportEntry2.set("item", (Object)entry.getString("subname"));
            calaReportEntry2.set("subnextentity", (Object)entry.getString("subnextentity"));
            calaReportEntry2.set("result", entry.get("substatus"));
            calaReportEntry2.set("cnsmtime", (Object)sortTime);
            calaReportEntry2.set("subparam", entry.get("subparam"));
            calaReportEntry2.set("bigtext", entry.get("subparam"));
            calaReportEntry2.set("bigtext_tag", (Object)StringUtils.substring((String)entry.getString("subparam_tag"), (int)0, (int)2000000));
            if (entry.get("detail") != null && !"".equals(entry.get("detail"))) {
                StringBuilder erroStr = new StringBuilder();
                erroStr.append(entry.get("detail"));
                calaReportEntry2.set("detail", (Object)(erroStr.length() > 50 ? erroStr.substring(0, 50) : erroStr.toString()));
            }
            calaReportEntry2.set("substarttime", entry.get("substarttime"));
            if (entry.get("substatus").equals("3") || entry.get("substatus").equals("7")) {
                calaReportEntry2.set("checkdesc", entry.get("detail"));
            }
            calaReportEntry2.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
    }

    public static void saveDiffCalcReportEntry(Long calcReportId, int seq, String item, Date startTime, CalcReportResultEnum result, Exception e) {
        DynamicObject calcReport = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"sca_restore_calcreport");
        DynamicObjectCollection entrys = calcReport.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entrys.addNew();
        entry.set("id", (Object)ID.genLongId());
        entry.set("seq", (Object)(seq != 0 ? seq : entrys.size()));
        entry.set("item", (Object)item);
        entry.set("cnsmtime", (Object)TimeUtils.getMilliSecond(startTime, TimeServiceHelper.now()));
        entry.set("result", (Object)result.getValue());
        if (e != null && e.getStackTrace() != null && e.getStackTrace().length > 0) {
            StringBuilder erroStr = new StringBuilder();
            erroStr.append(e.getCause()).append('\n');
            for (StackTraceElement traceElement : e.getStackTrace()) {
                erroStr.append(traceElement).append('\n');
            }
            entry.set("checkdesc", (Object)(erroStr.length() > 255 ? erroStr.substring(0, 255) : erroStr.toString()));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
    }

    public static void saveDiffCalcReportEntry(Long calcReportId, int seq, String item, Date startTime, Long checkResultId, int failCount) {
        DynamicObject calcReport = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"sca_restore_calcreport");
        DynamicObjectCollection entrys = calcReport.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entrys.addNew();
        entry.set("id", (Object)ID.genLongId());
        entry.set("seq", (Object)seq);
        entry.set("item", (Object)item);
        entry.set("cnsmtime", (Object)TimeUtils.getMilliSecond(startTime, TimeServiceHelper.now()));
        if (failCount == 0) {
            entry.set("result", (Object)CalcReportResultEnum.CALCREPORT_PASS.getValue());
        } else {
            entry.set("result", (Object)CalcReportResultEnum.CALCREPORT_NOPASS.getValue());
            JSONObject pagePara = new JSONObject();
            pagePara.accumulate("checkResultId", (Object)String.valueOf(checkResultId));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
    }

    public static void updateReportHeadByTaskRecord(Long calcReportId, Long taskRecoradId) {
        DynamicObject taskRecord = QueryServiceHelper.queryOne((String)"sca_taskrecord", (String)"time,status,progress,nextpagepara", (QFilter[])new QFilter("id", "=", (Object)taskRecoradId).toArray());
        DynamicObject calcReport = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"sca_calcreport");
        calcReport.set("usetime", taskRecord.get("time"));
        calcReport.set("progress", taskRecord.get("progress"));
        calcReport.set("type", taskRecord.get("status"));
        calcReport.set("nextpagepara", taskRecord.get("nextpagepara"));
        SaveServiceHelper.update((DynamicObject)calcReport);
    }

    public static Map<String, Integer> getSucByCalcReportId(Long calcReportId) {
        String algoKey = "kd.macc.sca.algox.utils.getSucByCalcReportId";
        QFilter qfCalcReport = new QFilter("calcreport", "=", (Object)calcReportId);
        String selectFields = "costobject,costcenter";
        DataSet calcResult = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_diffcalcresult", (String)selectFields, (QFilter[])new QFilter[]{qfCalcReport}, null);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        HashSet<Long> costObjectIds = new HashSet<Long>();
        HashSet<Long> costCenterIds = new HashSet<Long>();
        for (Row row : calcResult) {
            costObjectIds.add(row.getLong("costobject"));
            costCenterIds.add(row.getLong("costcenter"));
        }
        result.put("costobject", costObjectIds.size());
        result.put("costcenter", costCenterIds.size());
        return result;
    }

    public static void changeEntryStatusById(Long id) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_sca_alloccountrpt_step set fresult='2' where fentryid =" + id));
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
    }

    public static void changeEntryStatusById(Long id, String status) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_sca_alloccountrpt_step set fresult=" + status + " where fentryid =" + id));
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
    }

    public static void clearReportEntryById(Long id) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_sca_alloccountrpt_step where fentryid =" + id));
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
    }
}

